/*
 * Decompiled with CFR 0.152.
 */
package swingwtx.swing;

import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Vector;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CheckboxCellEditor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.custom.TableCursor;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import swingwt.awt.Component;
import swingwt.awt.Container;
import swingwt.awt.event.MouseEvent;
import swingwtx.swing.DefaultListSelectionModel;
import swingwtx.swing.JLabel;
import swingwtx.swing.JTable;
import swingwtx.swing.ListSelectionModel;
import swingwtx.swing.SwingUtilities;
import swingwtx.swing.SwingWTUtils;
import swingwtx.swing.event.CellEditorListener;
import swingwtx.swing.event.ChangeEvent;
import swingwtx.swing.event.ListSelectionEvent;
import swingwtx.swing.event.ListSelectionListener;
import swingwtx.swing.event.TableColumnModelEvent;
import swingwtx.swing.event.TableColumnModelListener;
import swingwtx.swing.event.TableModelEvent;
import swingwtx.swing.event.TableModelListener;
import swingwtx.swing.table.DefaultTableCellRenderer;
import swingwtx.swing.table.DefaultTableColumnModel;
import swingwtx.swing.table.DefaultTableModel;
import swingwtx.swing.table.JTableHeader;
import swingwtx.swing.table.TableCellRenderer;
import swingwtx.swing.table.TableColumn;
import swingwtx.swing.table.TableColumnModel;
import swingwtx.swing.table.TableModel;

public class JSWTTable
extends JTable
implements TableModelListener,
TableColumnModelListener,
ListSelectionListener,
CellEditorListener {
    protected JTableHeader header = null;
    protected TableColumnModel columnModel = null;
    protected ListSelectionModel listSelectionModel = null;
    protected boolean pLines = true;
    protected int pSelRow = -1;
    protected int pSelCol = -1;
    protected int editingColumn = -1;
    protected int editingRow = -1;
    protected boolean cellSelectionEnabled = true;
    protected boolean rowSelection = true;
    protected boolean columnSelection = false;
    protected TableCursor swtCursor = null;
    private SimpleContentProvider contentProvider = new SimpleContentProvider();
    private TableViewer viewer = null;
    private Table ppeer = null;
    private String[] columnNames = null;
    private boolean setModel = false;
    private TableModel model = null;
    private boolean modelDirty = true;
    private HashMap defaultRenderers = new HashMap();
    private HashMap sorter = new HashMap();
    private boolean autoSort = false;
    private int sortedColumn = -1;
    private boolean reverseSort = false;
    private int[] selRows = new int[0];
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Integer;

    public JSWTTable() {
        this(null);
    }

    public JSWTTable(int numRows, int numCols) {
        this(new DefaultTableModel(numRows, numCols));
    }

    public JSWTTable(Object[][] rowData, Object[] columnNames) {
        this(new DefaultTableModel(rowData, columnNames));
    }

    public JSWTTable(Vector rowData, Vector columnNames) {
        this(new DefaultTableModel(rowData, columnNames));
    }

    public JSWTTable(TableModel dm) {
        this(dm, null);
    }

    public JSWTTable(TableModel dm, TableColumnModel columnModel) {
        this(dm, columnModel, null);
    }

    public JSWTTable(TableModel dm, TableColumnModel columnModel, ListSelectionModel selectionModel) {
        if (dm == null) {
            dm = new DefaultTableModel();
        }
        this.setModel(dm);
        if (columnModel != null) {
            this.setColumnModel(columnModel);
        }
        if (selectionModel == null) {
            selectionModel = new DefaultListSelectionModel(this);
        }
        this.setSelectionModel(selectionModel);
        this.defaultRenderers.put(class$java$lang$Object == null ? (class$java$lang$Object = JSWTTable.class$("java.lang.Object")) : class$java$lang$Object, new DefaultTableCellRenderer());
    }

    public TableModel getModel() {
        return this.model;
    }

    public int getRowCount() {
        return this.model.getRowCount();
    }

    public int getColumnCount() {
        return this.model.getColumnCount();
    }

    public void clearSelection() {
        if (!SwingWTUtils.isSWTControlAvailable((Control)this.ppeer)) {
            return;
        }
        this.ppeer.deselectAll();
    }

    public void doLayout() {
        this.modelDirty = true;
        this.refreshTable();
    }

    public String getColumnName(int index) {
        return this.model.getColumnName(index);
    }

    public TableColumn getColumn(Object identifier) {
        return this.columnModel.getColumn(this.columnModel.getColumnIndex(identifier));
    }

    public TableColumn getColumn(int index) {
        return this.columnModel.getColumn(index);
    }

    public int getSelectedColumn() {
        if (SwingWTUtils.isSWTControlAvailable((Control)this.ppeer)) {
            return this.pSelCol;
        }
        return -1;
    }

    public TableColumnModel getColumnModel() {
        return this.columnModel;
    }

    public boolean getColumnSelectionAllowed(boolean b) {
        return this.columnSelection;
    }

    public void setColumnSelectionAllowed(boolean b) {
        this.columnSelection = b;
    }

    public boolean getRowSelectionAllowed(boolean b) {
        return this.rowSelection;
    }

    public int getSelectedRow() {
        final int[] sel = new int[1];
        SwingUtilities.invokeSync(new Runnable(){

            public void run() {
                sel[0] = !SwingWTUtils.isSWTControlAvailable((Control)JSWTTable.this.ppeer) ? JSWTTable.this.pSelRow : JSWTTable.this.ppeer.getSelectionIndex();
            }
        });
        return sel[0];
    }

    public int getSelectedRowCount() {
        final int[] sel = new int[1];
        SwingUtilities.invokeSync(new Runnable(){

            public void run() {
                sel[0] = !SwingWTUtils.isSWTControlAvailable((Control)JSWTTable.this.ppeer) ? 0 : JSWTTable.this.ppeer.getSelectionCount();
            }
        });
        return sel[0];
    }

    public int[] getSelectedRows() {
        SwingUtilities.invokeSync(new Runnable(){

            public void run() {
                if (!SwingWTUtils.isSWTControlAvailable((Control)JSWTTable.this.ppeer)) {
                    JSWTTable.access$102(JSWTTable.this, null);
                } else {
                    JSWTTable.access$102(JSWTTable.this, JSWTTable.this.ppeer.getSelectionIndices());
                }
            }
        });
        return this.selRows;
    }

    private void createDefaultEditors(int from, int to) {
        int i;
        CellEditor[] editors = new CellEditor[this.getColumnCount()];
        CellEditor[] oldEditors = this.viewer.getCellEditors();
        if (oldEditors != null) {
            for (i = 0; i < Math.min(oldEditors.length, editors.length); ++i) {
                editors[i] = oldEditors[i];
            }
        }
        for (i = from; i < to; ++i) {
            TextCellEditor ce = new TextCellEditor((Composite)this.ppeer);
            ce.getControl().setData("isDefault", (Object)"true");
            if (this.model.getColumnClass(i) == (class$java$lang$Boolean == null ? JSWTTable.class$("java.lang.Boolean") : class$java$lang$Boolean)) {
                ce = new CheckboxCellEditor();
            }
            if (this.model.getColumnClass(i) == (class$java$lang$Integer == null ? JSWTTable.class$("java.lang.Integer") : class$java$lang$Integer)) {
                ((Text)ce.getControl()).addVerifyListener(new VerifyListener(){

                    public void verifyText(VerifyEvent e) {
                        e.doit = e.text.matches("[\\-0-9]*");
                    }
                });
            }
            editors[i] = ce;
        }
        this.viewer.setCellEditors(editors);
    }

    public void setModel(TableModel dm, boolean noRefresh) {
        if (this.model != dm) {
            this.model = dm;
            if (this.sorter != null) {
                this.sorter.clear();
            }
            this.generateDefaultColumnModel();
            int columnCount = this.columnModel.getColumnCount();
            this.columnNames = new String[columnCount];
            for (int i = 0; i < columnCount; ++i) {
                this.columnNames[i] = this.columnModel.getColumn(i).getHeaderValue().toString();
            }
        }
        if (SwingWTUtils.isSWTControlAvailable((Control)this.ppeer)) {
            SwingUtilities.invokeSync(new Runnable(){

                public void run() {
                    JSWTTable.this.registerTableListSelectionEvents();
                    if (JSWTTable.this.viewer == null) {
                        JSWTTable.this.viewer = new TableViewer(JSWTTable.this.ppeer);
                    }
                    JSWTTable.this.viewer.setContentProvider((IContentProvider)JSWTTable.this.contentProvider);
                    JSWTTable.this.viewer.setColumnProperties(JSWTTable.this.columnNames);
                    JSWTTable.this.viewer.setInput((Object)JSWTTable.this.model);
                    JSWTTable.this.createDefaultEditors(0, JSWTTable.this.getColumnCount());
                    JSWTTable.this.viewer.setLabelProvider((IBaseLabelProvider)new SimpleLabelProvider());
                    JSWTTable.this.viewer.setCellModifier((ICellModifier)new SimpleCellModifier());
                    JSWTTable.this.modelDirty = true;
                    JSWTTable.this.refreshTable();
                }
            });
        } else {
            this.setModel = true;
        }
    }

    public void setModel(TableModel dm) {
        this.setModel(dm, true);
    }

    public void setColumnModel(TableColumnModel model) {
        if (this.columnModel == model) {
            return;
        }
        this.columnModel = model;
        this.modelDirty = true;
        this.refreshTable();
        this.columnModel.addColumnModelListener(this);
    }

    public void setCellSelectionEnabled(boolean b) {
        this.cellSelectionEnabled = b;
        this.modelDirty = true;
        this.refreshTable();
    }

    public void createDefaultColumnsFromModel() {
        TableColumnModel tableColumnModel = this.getColumnModel();
        if (this.model != null && tableColumnModel != null) {
            while (tableColumnModel.getColumnCount() > 0) {
                tableColumnModel.removeColumn(tableColumnModel.getColumn(0));
            }
            for (int i = 0; i < this.model.getColumnCount(); ++i) {
                TableColumn tc = new TableColumn();
                int colWidth = 0;
                tc.setWidth(colWidth);
                tc.setPreferredWidth(colWidth);
                tc.setMaxWidth(colWidth);
                tc.setMinWidth(colWidth);
                tc.setHeaderValue(this.model.getColumnName(i));
                tc.setIdentifier(this.model.getColumnName(i));
                tc.setModelIndex(i);
                tc.setResizable(true);
                this.columnModel.addColumn(tc);
            }
        }
    }

    public boolean getShowHorizontalLines() {
        return this.isShowGrid();
    }

    public boolean getShowVerticalLines() {
        return this.isShowGrid();
    }

    public boolean isShowHorizontalLines() {
        return this.isShowGrid();
    }

    public boolean isShowVerticalLines() {
        return this.isShowGrid();
    }

    public boolean getShowGrid() {
        return this.isShowGrid();
    }

    public boolean isShowGrid() {
        final boolean[] ret = new boolean[1];
        SwingUtilities.invokeSync(new Runnable(){

            public void run() {
                ret[0] = !SwingWTUtils.isSWTControlAvailable((Control)JSWTTable.this.ppeer) ? false : JSWTTable.this.ppeer.getLinesVisible();
            }
        });
        return ret[0];
    }

    public void addColumn(TableColumn tableColumn) {
        int oldCount = this.getColumnModel().getColumnCount();
        if (tableColumn.getHeaderValue() == null) {
            tableColumn.setHeaderValue(this.getModel().getColumnName(tableColumn.getModelIndex()));
        }
        this.getColumnModel().addColumn(tableColumn);
        this.setModelDirty(true);
        this.refreshTable();
        this.viewer.setColumnProperties(this.columnNames);
        this.createDefaultEditors(oldCount, oldCount + 1);
    }

    public ListSelectionModel getSelectionModel() {
        return this.listSelectionModel;
    }

    public void setSelectionModel(ListSelectionModel l) {
        if (l != null) {
            this.listSelectionModel = l;
            l.addListSelectionListener(this);
        }
    }

    public void setSelectionMode(int mode) {
        this.listSelectionModel.setSelectionMode(mode);
    }

    public void setRowSelectionAllowed(boolean b) {
        this.rowSelection = b;
    }

    public void setRowSelectionInterval(final int first, final int last) {
        SwingUtilities.invokeSync(new Runnable(){

            public void run() {
                if (!SwingWTUtils.isSWTControlAvailable((Control)JSWTTable.this.ppeer)) {
                    JSWTTable.this.ppeer.setSelection(first, last);
                }
            }
        });
    }

    public void setShowGrid(final boolean b) {
        SwingUtilities.invokeSync(new Runnable(){

            public void run() {
                if (!SwingWTUtils.isSWTControlAvailable((Control)JSWTTable.this.ppeer)) {
                    JSWTTable.this.pLines = b;
                } else {
                    JSWTTable.this.ppeer.setLinesVisible(b);
                }
            }
        });
    }

    public void setShowHorizontalLines(boolean b) {
        this.setShowGrid(b);
    }

    public void setShowVerticalLines(boolean b) {
        this.setShowGrid(b);
    }

    public void setDefaultRenderer(Class columnClass, TableCellRenderer tableCellRenderer) {
        if (tableCellRenderer == null) {
            this.defaultRenderers.remove(columnClass);
        } else {
            this.defaultRenderers.put(columnClass, tableCellRenderer);
        }
    }

    public void setSWTEditor(int column, CellEditor editor) {
        if (SwingWTUtils.isSWTControlAvailable((Control)this.ppeer)) {
            editor.getControl().setParent((Composite)this.ppeer);
            CellEditor[] editors = this.viewer.getCellEditors();
            if (column < editors.length) {
                editors[column] = editor;
            }
        }
    }

    public void removeSWTEditor(int column) {
        CellEditor[] editors = this.viewer.getCellEditors();
        if (column < editors.length) {
            editors[column] = null;
        }
    }

    public TableCellRenderer getCellRenderer(int row, int column) {
        TableCellRenderer renderer = this.columnModel.getColumn(column).getCellRenderer();
        if (renderer == null) {
            Class columnClass = this.getModel().getColumnClass(this.convertColumnIndexToModel(column));
            renderer = this.getDefaultRenderer(columnClass);
        }
        return renderer;
    }

    public boolean getCellSelectionEnabled(boolean b) {
        return this.cellSelectionEnabled;
    }

    public TableCellRenderer getDefaultRenderer(Class columnClass) {
        if (columnClass == null) {
            return null;
        }
        TableCellRenderer renderer = (TableCellRenderer)this.defaultRenderers.get(columnClass);
        if (renderer == null) {
            renderer = this.getDefaultRenderer(columnClass.getSuperclass());
        }
        return renderer;
    }

    public boolean isCellSelected(int row, int col) {
        int srow = -1;
        int scol = -1;
        try {
            srow = (Integer)this.swtCursor.getRow().getData("rowindex");
            scol = this.swtCursor.getColumn();
        }
        catch (Exception e) {
            // empty catch block
        }
        if (srow == row && scol == col) {
            return true;
        }
        return this.getSelectedRow() == row;
    }

    public void setModelDirty(boolean b) {
        this.modelDirty = b;
    }

    public void changeSelection(final int row, int col, boolean toggle, boolean extend) {
        this.pSelRow = row;
        this.pSelCol = col;
        SwingUtilities.invokeSync(new Runnable(){

            public void run() {
                if (SwingWTUtils.isSWTControlAvailable((Control)JSWTTable.this.ppeer)) {
                    JSWTTable.this.ppeer.setSelection(row);
                    JSWTTable.this.processListSelection();
                }
            }
        });
    }

    public void showSelection() {
        SwingUtilities.invokeSync(new Runnable(){

            public void run() {
                if (SwingWTUtils.isSWTControlAvailable((Control)JSWTTable.this.ppeer)) {
                    JSWTTable.this.ppeer.showSelection();
                }
            }
        });
    }

    public int convertColumnIndexToModel(int index) {
        return index;
    }

    private void generateDefaultColumnModel() {
        this.columnModel = new DefaultTableColumnModel();
        this.createDefaultColumnsFromModel();
    }

    public JTableHeader getTableHeader() {
        if (this.header == null) {
            this.header = new JTableHeader(this);
        }
        return this.header;
    }

    public Object getValueAt(int row, int col) {
        if (this.model != null) {
            return this.model.getValueAt(row, col);
        }
        return null;
    }

    public void setSwingWTParent(Container parent) throws Exception {
        this.descendantHasPeer = true;
        int style = 2048;
        if (this.rowSelection && !this.columnSelection) {
            style |= 0x10000;
        }
        this.ppeer = new Table(parent.getComposite(), style);
        this.peer = this.ppeer;
        this.parent = parent;
        this.ppeer.setLinesVisible(this.pLines);
        if (this.setModel) {
            this.setModel(this.model);
        }
        if (this.pSelRow != -1) {
            this.ppeer.setSelection(this.pSelRow);
        }
        this.ppeer.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 13) {
                    JSWTTable.this.processCellEdit();
                }
            }

            public void keyReleased(KeyEvent e) {
                if (e.keyCode == 0x1000004) {
                    ++JSWTTable.this.pSelCol;
                }
                if (e.keyCode == 0x1000003) {
                    --JSWTTable.this.pSelCol;
                }
            }
        });
        this.ppeer.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(org.eclipse.swt.events.MouseEvent e) {
                JSWTTable.this.pSelRow = JSWTTable.this.ppeer.getSelectionIndex();
            }
        });
    }

    public void setValueAt(Object value, int row, int col) {
        if (this.model != null) {
            this.model.setValueAt(value, row, col);
        }
    }

    public void setDirty(boolean b) {
        this.modelDirty = b;
    }

    public void refreshTable() {
        if (!this.modelDirty || this.model == null || this.ppeer == null) {
            return;
        }
        this.modelDirty = false;
        SwingUtilities.invokeSync(new Runnable(){

            public void run() {
                int i;
                if (!SwingWTUtils.isSWTControlAvailable((Control)JSWTTable.this.ppeer)) {
                    JSWTTable.this.modelDirty = true;
                    return;
                }
                JSWTTable.this.ppeer.removeAll();
                int columnCount = Math.min(JSWTTable.this.ppeer.getColumnCount(), JSWTTable.this.columnModel.getColumnCount());
                for (i = 0; i < columnCount; ++i) {
                    JSWTTable.this.columnModel.getColumn(i).setWidth(JSWTTable.this.ppeer.getColumn(i).getWidth());
                }
                columnCount = Math.min(JSWTTable.this.model.getColumnCount(), JSWTTable.this.columnModel.getColumnCount());
                if (JSWTTable.this.ppeer.getColumnCount() < columnCount) {
                    while (JSWTTable.this.ppeer.getColumnCount() < columnCount) {
                        org.eclipse.swt.widgets.TableColumn tc = new org.eclipse.swt.widgets.TableColumn(JSWTTable.this.ppeer, JSWTTable.this.ppeer.getColumnCount());
                    }
                } else {
                    while (JSWTTable.this.ppeer.getColumnCount() > columnCount) {
                        JSWTTable.this.ppeer.getColumn(JSWTTable.this.ppeer.getColumnCount() - 1).dispose();
                    }
                }
                JSWTTable.this.ppeer.setHeaderVisible(true);
                JSWTTable.access$402(JSWTTable.this, new String[columnCount]);
                for (i = 0; i < columnCount; ++i) {
                    org.eclipse.swt.widgets.TableColumn tc = JSWTTable.this.ppeer.getColumn(i);
                    tc.setText(JSWTTable.this.columnModel.getColumn(i).getHeaderValue().toString());
                    tc.setResizable(JSWTTable.this.columnModel.getColumn(i).isResizable());
                    ((JSWTTable)JSWTTable.this).columnNames[i] = tc.getText();
                    if (JSWTTable.this.columnModel.getColumn(i).getWidth() == 0) {
                        int colwidth = SwingWTUtils.getRenderStringWidth(JSWTTable.this.columnModel.getColumn(i).getHeaderValue().toString());
                        int contentwidth = 0;
                        for (int z = 0; z < JSWTTable.this.model.getRowCount(); ++z) {
                            Object value = JSWTTable.this.model.getValueAt(z, i);
                            if (value == null) {
                                value = "";
                            }
                            if ((contentwidth = SwingWTUtils.getRenderStringWidth(value.toString())) <= colwidth) continue;
                            colwidth = contentwidth;
                        }
                        tc.setWidth(colwidth);
                    } else {
                        tc.setWidth(JSWTTable.this.columnModel.getColumn(i).getWidth());
                    }
                    if (tc.getData("listenerSet") != null) continue;
                    int index = i;
                    tc.addSelectionListener(new SelectionListener(this, index){
                        private final /* synthetic */ int val$index;
                        private final /* synthetic */ 13 this$1;
                        {
                            this.this$1 = this$1;
                            this.val$index = val$index;
                        }

                        public void widgetSelected(SelectionEvent e) {
                            13.access$800(this.this$1).processColumnClick(this.val$index);
                        }

                        public void widgetDefaultSelected(SelectionEvent e) {
                        }
                    });
                    tc.setData("listenerSet", (Object)new Boolean(true));
                }
                JSWTTable.this.ppeer.setLinesVisible(JSWTTable.this.pLines);
                JSWTTable.this.setCachedProperties();
                JSWTTable.this.registerEvents();
                JSWTTable.this.viewer.refresh();
            }

            static /* synthetic */ JSWTTable access$800(13 x0) {
                return x0.JSWTTable.this;
            }
        });
    }

    public void refreshTable(int rowFrom, int rowTo) {
        this.refreshTable();
    }

    public void insertRows(int rowFrom, int rowTo) {
        for (int i = rowFrom; i <= rowTo; ++i) {
            Object[] item = new Object[this.model.getColumnCount()];
            for (int j = 0; j < this.model.getColumnCount(); ++j) {
                item[j] = this.model.getValueAt(i - 1, j);
            }
            this.contentProvider.addItem(item);
        }
    }

    protected void registerTableListSelectionEvents() {
        this.ppeer.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                JSWTTable.this.processListSelection();
            }
        });
    }

    protected void processListSelection() {
        if (this.listSelectionModel instanceof DefaultListSelectionModel) {
            if (this.listSelectionModel.getSelectionMode() == 2) {
                int lowest = this.ppeer.getSelectionIndex();
                int highest = this.ppeer.getSelectionIndex();
                int[] sel = this.ppeer.getSelectionIndices();
                for (int i = 0; i < sel.length; ++i) {
                    if (lowest > sel[i]) {
                        lowest = sel[i];
                    }
                    if (highest >= sel[i]) continue;
                    highest = sel[i];
                }
                ((DefaultListSelectionModel)this.listSelectionModel).fireListSelectionEvent(this, lowest, highest);
            } else {
                ((DefaultListSelectionModel)this.listSelectionModel).fireListSelectionEvent(this, this.ppeer.getSelectionIndex(), this.ppeer.getSelectionIndex());
            }
        }
    }

    protected void processColumnClick(int index) {
        this.pSelCol = index;
        if (this.columnModel instanceof DefaultTableColumnModel) {
            ((DefaultTableColumnModel)this.columnModel).lastColClicked = index;
        }
        MouseEvent e = new MouseEvent(this.getTableHeader());
        e.eventID = 0;
        e.setX(SwingWTUtils.getDisplay().getCursorLocation().x);
        e.setY(SwingWTUtils.getDisplay().getCursorLocation().y);
        e.setButton(524288);
        e.clickCount = 1;
        this.getTableHeader().processMouseEvent(e);
        if (this.sortedColumn == index) {
            this.reverseSort = !this.reverseSort;
        }
        this.viewer.setSorter(null);
        this.sortedColumn = -1;
        ViewerSorter newSorter = (ViewerSorter)this.sorter.get(this.columnModel.getColumn(index));
        if (newSorter != null) {
            this.sortedColumn = index;
            this.viewer.setSorter(newSorter);
        } else {
            this.reverseSort = false;
        }
    }

    public int getEditingColumn() {
        return this.getSelectedColumn();
    }

    public void setEditingColumn(int aColumn) {
        this.editingColumn = aColumn;
    }

    public int getEditingRow() {
        return this.getSelectedRow();
    }

    public void setEditingRow(int aRow) {
        this.editingRow = aRow;
        this.changeSelection(aRow, this.editingColumn, false, false);
    }

    public void tableChanged(TableModelEvent e) {
        block3: {
            block4: {
                block2: {
                    this.modelDirty = true;
                    if (e.getType() != 1) break block2;
                    this.insertRows(e.getFirstRow(), e.getLastRow());
                    break block3;
                }
                if (e.getType() != 0) break block4;
                for (int i = e.getFirstRow(); i <= e.getLastRow(); ++i) {
                    this.contentProvider.updateItem(((IStructuredSelection)this.viewer.getSelection()).getFirstElement());
                }
                break block3;
            }
            if (e.getType() != -1) break block3;
            for (int i = e.getFirstRow(); i <= e.getLastRow(); ++i) {
                this.ppeer.select(e.getFirstRow());
                this.contentProvider.removeItem(((IStructuredSelection)this.viewer.getSelection()).getFirstElement());
                this.ppeer.select(e.getFirstRow());
            }
        }
    }

    public void valueChanged(ListSelectionEvent e) {
        this.columnSelectionChanged(e);
    }

    public void columnAdded(TableColumnModelEvent e) {
        this.modelDirty = true;
        this.refreshTable();
    }

    public void columnMoved(TableColumnModelEvent e) {
        this.modelDirty = true;
        this.refreshTable();
    }

    public void columnRemoved(TableColumnModelEvent e) {
        this.modelDirty = true;
        this.refreshTable();
    }

    public boolean isEditing() {
        if (SwingWTUtils.isSWTControlAvailable((Control)this.ppeer)) {
            return this.viewer.isCellEditorActive();
        }
        return false;
    }

    public void removeColumn(TableColumn tableColumn) {
        int i;
        int index = this.getColumnModel().getColumnIndex(tableColumn.getIdentifier());
        this.getColumnModel().removeColumn(tableColumn);
        CellEditor[] editors = new CellEditor[this.getColumnCount()];
        CellEditor[] oldEditors = this.viewer.getCellEditors();
        for (i = 0; i < index; ++i) {
            editors[i] = oldEditors[i];
        }
        for (i = index; i < editors.length; ++i) {
            editors[i] = oldEditors[i + 1];
        }
        this.viewer.setCellEditors(editors);
        this.setModelDirty(true);
        this.refreshTable();
        this.viewer.setColumnProperties(this.columnNames);
    }

    public void resizeAndRepaint() {
        this.refreshTable();
    }

    public void selectAll() {
        if (SwingWTUtils.isSWTControlAvailable((Control)this.ppeer)) {
            this.ppeer.selectAll();
        }
    }

    public Component prepareRenderer(TableCellRenderer renderer, int row, int column) {
        return renderer.getTableCellRendererComponent(this, this.getValueAt(row, column), this.isCellSelected(row, column), false, row, column);
    }

    protected void processCellEdit() {
        if (this.viewer == null || this.ppeer.getItemCount() == 0) {
            return;
        }
        if (this.pSelCol < 0) {
            this.pSelCol = 0;
        }
        if (this.pSelCol >= this.model.getColumnCount()) {
            this.pSelCol = this.model.getColumnCount() - 1;
        }
        this.pSelRow = this.ppeer.getSelectionIndex();
        if (this.pSelRow < 0) {
            this.pSelRow = 0;
        }
        this.viewer.editElement(this.ppeer.getItem(this.pSelRow).getData(), this.pSelCol);
    }

    public void editingCanceled(ChangeEvent e) {
    }

    public void editingStopped(ChangeEvent e) {
    }

    public void setSorter(int index, final Comparator comp) {
        if (index > this.columnModel.getColumnCount()) {
            return;
        }
        this.sorter.put(this.columnModel.getColumn(index), new ViewerSorter(){

            public int compare(Viewer viewer, Object o1, Object o2) {
                Object[] row1 = (Object[])((TableRow)o1).data;
                Object[] row2 = (Object[])((TableRow)o2).data;
                if (JSWTTable.this.reverseSort) {
                    return comp.compare(row2[JSWTTable.this.sortedColumn], row1[JSWTTable.this.sortedColumn]);
                }
                return comp.compare(row1[JSWTTable.this.sortedColumn], row2[JSWTTable.this.sortedColumn]);
            }
        });
        this.refreshTable();
    }

    public void removeSorter(int index) {
        this.sorter.remove(this.columnModel.getColumn(index));
        this.viewer.setSorter(null);
    }

    public boolean isAutoSort() {
        return this.autoSort;
    }

    public void setAutoSort(boolean autoSort) {
        this.autoSort = autoSort;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static /* synthetic */ int[] access$102(JSWTTable x0, int[] x1) {
        x0.selRows = x1;
        return x1;
    }

    static /* synthetic */ String[] access$402(JSWTTable x0, String[] x1) {
        x0.columnNames = x1;
        return x1;
    }

    class TableRow {
        public int index;
        public Object data;

        public TableRow(Object data, int index) {
            this.data = data;
            this.index = index;
        }

        public boolean equals(TableRow row) {
            return this.index == row.index;
        }
    }

    class SimpleCellModifier
    implements ICellModifier {
        SimpleCellModifier() {
        }

        public boolean canModify(Object element, String column) {
            int columnIndex = Arrays.asList(JSWTTable.this.columnNames).indexOf(column);
            int rowIndex = ((TableRow)element).index;
            return JSWTTable.this.model.isCellEditable(rowIndex, columnIndex);
        }

        public Object getValue(Object element, String column) {
            int columnIndex = Arrays.asList(JSWTTable.this.columnNames).indexOf(column);
            if (element != null && ((TableRow)element).data != null) {
                Object[] o = (Object[])((TableRow)element).data;
                if (JSWTTable.this.viewer.getCellEditors()[columnIndex] instanceof TextCellEditor && JSWTTable.this.viewer.getCellEditors()[columnIndex].getControl().getData("isDefault").equals("true")) {
                    return o[columnIndex].toString();
                }
                return o[columnIndex];
            }
            return "";
        }

        public void modify(Object element, String column, Object newValue) {
            ViewerSorter newSorter;
            int columnIndex = Arrays.asList(JSWTTable.this.columnNames).indexOf(column);
            TableItem item = (TableItem)element;
            TableRow row = (TableRow)item.getData();
            JSWTTable.this.model.setValueAt(newValue, row.index, columnIndex);
            ((Object[])row.data)[columnIndex] = newValue;
            JSWTTable.this.contentProvider.updateItem((TableRow)item.getData());
            if (JSWTTable.this.isAutoSort() && JSWTTable.this.sortedColumn == columnIndex && (newSorter = (ViewerSorter)JSWTTable.this.sorter.get(JSWTTable.this.columnModel.getColumn(columnIndex))) != null) {
                JSWTTable.this.viewer.setSorter(null);
                JSWTTable.this.viewer.setSorter(newSorter);
            }
            JSWTTable.this.pSelCol = columnIndex;
            JSWTTable.this.ppeer.setSelection(JSWTTable.this.ppeer.indexOf(item));
            JSWTTable.this.ppeer.showSelection();
        }
    }

    public class SimpleLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        public Image getColumnImage(Object element, int columnIndex) {
            if (columnIndex >= JSWTTable.this.getColumnCount()) {
                return null;
            }
            if (element != null && ((TableRow)element).data != null) {
                Component c;
                Object[] data = (Object[])((TableRow)element).data;
                int rowIndex = ((TableRow)element).index;
                TableCellRenderer renderer = JSWTTable.this.getCellRenderer(rowIndex, columnIndex);
                if (renderer != null && (c = renderer.getTableCellRendererComponent(JSWTTable.this, data[columnIndex], true, true, rowIndex, columnIndex)) instanceof JLabel) {
                    JLabel l = (JLabel)c;
                    return SwingWTUtils.getSWTImageFromSwingIcon(l, l.getIcon());
                }
            }
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            if (columnIndex >= JSWTTable.this.getColumnCount()) {
                return "";
            }
            if (element != null && ((TableRow)element).data != null) {
                Component c;
                Object[] data = (Object[])((TableRow)element).data;
                int rowIndex = ((TableRow)element).index;
                TableCellRenderer renderer = JSWTTable.this.getCellRenderer(rowIndex, columnIndex);
                if (renderer != null && (c = renderer.getTableCellRendererComponent(JSWTTable.this, data[columnIndex], true, true, rowIndex, columnIndex)) instanceof JLabel) {
                    JLabel l = (JLabel)c;
                    return l.getText();
                }
                return data[columnIndex].toString();
            }
            return "";
        }
    }

    class SimpleContentProvider
    implements IStructuredContentProvider {
        SimpleContentProvider() {
        }

        public void inputChanged(Viewer v, Object oldInput, Object newInput) {
            if (newInput != null) {
                ((TableModel)newInput).addTableModelListener(JSWTTable.this);
            }
            if (oldInput != null) {
                ((TableModel)oldInput).removeTableModelListener(JSWTTable.this);
            }
        }

        public void dispose() {
            JSWTTable.this.model.removeTableModelListener(JSWTTable.this);
        }

        public Object[] getElements(Object parent) {
            Object[] data = new Object[JSWTTable.this.model.getRowCount()];
            for (int i = 0; i < JSWTTable.this.model.getRowCount(); ++i) {
                Object[] row = new Object[JSWTTable.this.model.getColumnCount()];
                for (int j = 0; j < JSWTTable.this.model.getColumnCount(); ++j) {
                    row[j] = JSWTTable.this.model.getValueAt(i, j);
                }
                data[i] = new TableRow(row, i);
            }
            return data;
        }

        public void addItem(Object data) {
            if (JSWTTable.this.viewer != null) {
                TableRow row = new TableRow(data, JSWTTable.this.ppeer.getItemCount());
                JSWTTable.this.viewer.add((Object)row);
            }
        }

        public void removeItem(Object item) {
            if (JSWTTable.this.viewer != null) {
                JSWTTable.this.viewer.remove(item);
            }
        }

        public void updateItem(Object item) {
            if (JSWTTable.this.viewer != null) {
                JSWTTable.this.viewer.update(item, null);
            }
        }
    }
}

