/*
 * Decompiled with CFR 0.152.
 */
package swingwtx.swing;

import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolItem;
import swingwt.awt.Color;
import swingwt.awt.Container;
import swingwt.awt.Dimension;
import swingwt.awt.event.ItemListener;
import swingwtx.swing.AbstractButton;
import swingwtx.swing.Action;
import swingwtx.swing.ButtonModel;
import swingwtx.swing.Icon;
import swingwtx.swing.JButtonMappedAction;
import swingwtx.swing.JToolBar;
import swingwtx.swing.SwingConstants;
import swingwtx.swing.SwingUtilities;
import swingwtx.swing.SwingWTUtils;

public class JButton
extends AbstractButton
implements SwingConstants,
ButtonModel {
    protected Icon pImage = null;
    protected boolean pDefaultCapable = true;
    protected Container pDefaultButtonParent = null;
    protected ToolItem pSWTToolButton = null;

    public JButton() {
        this("");
    }

    public JButton(String text) {
        this.pText = text;
        this.setModel(this);
        this.showMnemonic();
        this.pHAlign = 0;
    }

    public JButton(Action a) {
        this.setAction(a);
        this.pHAlign = 0;
    }

    public JButton(Icon icon) {
        this.pImage = icon;
        this.pHAlign = 0;
    }

    public JButton(String text, Icon icon) {
        this.pImage = icon;
        this.pText = text;
        this.pHAlign = 0;
        this.setModel(this);
        this.showMnemonic();
    }

    protected JButton(Action a, boolean addAsListener) {
        this.setAction(a, addAsListener);
    }

    private void updateMappedAction() {
        if (this.pAction instanceof JButtonMappedAction) {
            this.pAction.putValue("Name", this.getText());
            this.pAction.putValue("ShortDescription", this.getToolTipText());
            this.pAction.putValue("SmallIcon", this.getIcon());
            this.pAction.putValue("DisabledIcon", this.getIcon());
            this.pAction.putValue("MnemonicKey", new Integer(this.getMnemonic()));
        }
    }

    private void updateToolButton() {
        final JButton pthis = this;
        if (this.pSWTToolButton == null) {
            return;
        }
        SwingUtilities.invokeSync(new Runnable(){

            public void run() {
                JButton.this.pSWTToolButton.setText(JButton.this.getText());
                JButton.this.pSWTToolButton.setToolTipText(JButton.this.getToolTipText());
                JButton.this.pSWTToolButton.setEnabled(JButton.this.isEnabled());
                JButton.this.pSWTToolButton.setImage(SwingWTUtils.getSWTImageFromSwingIcon(pthis, JButton.this.getIcon()));
            }
        });
    }

    public Icon getIcon() {
        return this.pImage;
    }

    public void setIcon(Icon icon) {
        this.pImage = icon;
        final JButton pthis = this;
        SwingUtilities.invokeSync(new Runnable(){

            public void run() {
                if (SwingWTUtils.isSWTControlAvailable((Control)JButton.this.ppeer)) {
                    JButton.this.ppeer.setImage(SwingWTUtils.getSWTImageFromSwingIcon(pthis, JButton.this.pImage));
                }
                JButton.this.renderText();
                JButton.this.updateToolButton();
                JButton.this.updateMappedAction();
            }
        });
    }

    public void setToolTipText(String text) {
        super.setToolTipText(text);
        this.updateToolButton();
        this.updateMappedAction();
    }

    public String getText() {
        return this.pText;
    }

    public void setText(String text) {
        super.setText(text);
        if (this.pForeground != null) {
            this.handleWindowsForegroundKludge();
        }
        this.renderText();
        this.updateMappedAction();
        this.updateToolButton();
    }

    public void setEnabled(boolean b) {
        super.setEnabled(b);
        this.updateToolButton();
    }

    public boolean getDefaultCapable() {
        return this.pDefaultCapable;
    }

    public void setDefaultCapable(boolean b) {
        this.pDefaultCapable = b;
    }

    protected void setColorTextImage(Button button, String text, Color color) {
        button.setForeground(color.getSWTColor());
        final Image img = this.createTextImage(button, text);
        button.setText(text);
        button.setImage(img);
        button.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (!img.isDisposed()) {
                    img.dispose();
                }
            }
        });
    }

    private Image createTextImage(Button button, String text) {
        GC buttonGC = new GC((Drawable)button);
        Point size = buttonGC.textExtent(text, 8);
        Font font = buttonGC.getFont();
        buttonGC.dispose();
        Image img = new Image((Device)button.getDisplay(), size.x, size.y);
        GC imgGC = new GC((Drawable)img);
        imgGC.setFont(font);
        imgGC.setBackground(button.getBackground());
        imgGC.setForeground(button.getForeground());
        imgGC.drawText(text, 0, 0, 8);
        imgGC.dispose();
        return img;
    }

    protected void renderText() {
        if (this.pText == null) {
            return;
        }
        if (!SwingWTUtils.isSWTControlAvailable((Control)this.ppeer)) {
            return;
        }
        if (this.pText.length() == 2 && this.pText.startsWith("&")) {
            return;
        }
        if (this.pText.equals("") || this.pImage == null) {
            return;
        }
        final JButton pthis = this;
        SwingUtilities.invokeSync(new Runnable(){

            public void run() {
                GC gc = new GC((Drawable)JButton.this.ppeer.getImage());
                gc.setFont(JButton.this.ppeer.getFont());
                Point p = gc.textExtent(JButton.this.pText);
                int width = JButton.this.ppeer.getImage().getBounds().width + 2;
                int height = JButton.this.ppeer.getImage().getBounds().height;
                Image im = new Image((Device)SwingWTUtils.getDisplay(), width + p.x, height);
                GC ngc = new GC((Drawable)im);
                ngc.setFont(JButton.this.ppeer.getFont());
                ngc.setBackground(JButton.this.ppeer.getShell().getBackground());
                ngc.setForeground(JButton.this.ppeer.getShell().getBackground());
                ngc.fillRectangle(0, 0, width + p.x, height);
                ngc.setForeground(JButton.this.ppeer.getShell().getForeground());
                ngc.drawImage(SwingWTUtils.getSWTImageFromSwingIcon(pthis, JButton.this.pImage), 0, 0);
                String text = JButton.this.pText;
                int mnPos = text.indexOf("&");
                if (mnPos != -1) {
                    text = text.substring(0, mnPos) + text.substring(mnPos + 1, text.length());
                }
                ngc.drawText(text, width, (height - p.y) / 2, true);
                ngc.dispose();
                gc.dispose();
                JButton.this.ppeer.setImage(im);
            }
        });
    }

    public void setForeground(Color foreground) {
        super.setForeground(foreground);
        this.handleWindowsForegroundKludge();
    }

    protected void handleWindowsForegroundKludge() {
        if (SwingWTUtils.isSWTControlAvailable(this.peer)) {
            SwingUtilities.invokeSync(new Runnable(){

                public void run() {
                    if (SwingWTUtils.isWindows() && JButton.this.pForeground != null && JButton.this.pText != null) {
                        JButton.this.setColorTextImage(JButton.this.ppeer, JButton.this.pText, JButton.this.pForeground);
                    }
                }
            });
        }
    }

    protected Dimension calculatePreferredSize() {
        Dimension size = new Dimension(SwingWTUtils.getRenderStringWidth(this.pText) + 6, SwingWTUtils.getRenderStringHeight(this.pText) + 12);
        this.setSize(size);
        return size;
    }

    protected int getSWTFlags() {
        return this.parent instanceof JToolBar ? 0x800000 : 8;
    }

    public void setSwingWTParent(Container parent) throws Exception {
        this.ppeer = new Button(parent.getComposite(), this.getSWTFlags());
        this.peer = this.ppeer;
        if (this.pForeground != null) {
            this.setForeground(this.pForeground);
        }
        if (this.pText != null) {
            this.ppeer.setText(this.pText);
        }
        if (this.pMnemonic != ' ') {
            this.showMnemonic();
        }
        if (this.pImage != null) {
            this.ppeer.setImage(SwingWTUtils.getSWTImageFromSwingIcon(this, this.pImage));
        }
        if (this.pFont != null) {
            this.ppeer.setFont(this.pFont.getSWTFont());
        }
        this.ppeer.setAlignment(SwingWTUtils.translateSwingAlignmentConstant(this.pVAlign) | SwingWTUtils.translateSwingAlignmentConstant(this.pHAlign));
        this.renderText();
        if (this.pSize != null) {
            this.ppeer.setSize(this.pSize.width, this.pSize.height);
        }
        this.parent = parent;
        if (this.pDefaultButtonParent != null) {
            if (this.pDefaultButtonParent.getComposite() instanceof Shell) {
                ((Shell)this.pDefaultButtonParent.getComposite()).setDefaultButton(this.ppeer);
            } else {
                this.pDefaultButtonParent.getComposite().getShell().setDefaultButton(this.ppeer);
            }
        }
    }

    public void setDefaultButtonParent(Container window) {
        this.pDefaultButtonParent = window;
    }

    public boolean isSelected() {
        return false;
    }

    public void setSelected(boolean b) {
    }

    public void addItemListener(ItemListener l) {
    }

    public Object[] getSelectedObjects() {
        return null;
    }

    public void removeItemListener(ItemListener l) {
    }

    public boolean isArmed() {
        return false;
    }

    public boolean isPressed() {
        return false;
    }

    public boolean isRollover() {
        return false;
    }

    public void setArmed(boolean b) {
    }

    public void setPressed(boolean b) {
    }

    public void setRollover(boolean b) {
    }

    public boolean isDefaultCapable() {
        return true;
    }
}

