/*
 * Decompiled with CFR 0.152.
 */
package swingwt.awt;

import java.io.Serializable;
import java.util.Locale;
import java.util.ResourceBundle;

public final class ComponentOrientation
implements Serializable {
    private static final int UNK_BIT = 1;
    private static final int HORIZ_BIT = 2;
    private static final int LTR_BIT = 4;
    private int orientation;
    public static final ComponentOrientation LEFT_TO_RIGHT = new ComponentOrientation(6);
    public static final ComponentOrientation RIGHT_TO_LEFT = new ComponentOrientation(2);
    public static final ComponentOrientation UNKNOWN = new ComponentOrientation(7);

    public boolean isHorizontal() {
        return (this.orientation & 2) != 0;
    }

    public boolean isLeftToRight() {
        return (this.orientation & 4) != 0;
    }

    public static ComponentOrientation getOrientation(Locale locale) {
        String lang = locale.getLanguage();
        if ("iw".equals(lang) || "ar".equals(lang) || "fa".equals(lang) || "ur".equals(lang)) {
            return RIGHT_TO_LEFT;
        }
        return LEFT_TO_RIGHT;
    }

    public static ComponentOrientation getOrientation(ResourceBundle bdl) {
        ComponentOrientation result = null;
        try {
            result = (ComponentOrientation)bdl.getObject("Orientation");
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (result == null) {
            result = ComponentOrientation.getOrientation(bdl.getLocale());
        }
        if (result == null) {
            result = ComponentOrientation.getOrientation(Locale.getDefault());
        }
        return result;
    }

    private ComponentOrientation(int value) {
        this.orientation = value;
    }
}

