/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.viewers;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.util.Assert;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Widget;

public class ListViewer
extends StructuredViewer {
    private org.eclipse.swt.widgets.List list;
    private List listMap = new ArrayList();

    public ListViewer(Composite parent) {
        this(parent, 2818);
    }

    public ListViewer(Composite parent, int style) {
        this(new org.eclipse.swt.widgets.List(parent, style));
    }

    public ListViewer(org.eclipse.swt.widgets.List list) {
        this.list = list;
        this.hookControl((Control)list);
    }

    public void add(Object[] elements) {
        this.assertElementsNotNull(elements);
        Object[] filtered = this.filter(elements);
        ILabelProvider labelProvider = (ILabelProvider)this.getLabelProvider();
        int i = 0;
        while (i < filtered.length) {
            Object element = filtered[i];
            int ix = this.indexForElement(element);
            this.list.add(labelProvider.getText(element), ix);
            this.listMap.add(ix, element);
            this.mapElement(element, (Widget)this.list);
            ++i;
        }
    }

    public void add(Object element) {
        this.add(new Object[]{element});
    }

    protected Widget doFindInputItem(Object element) {
        if (element != null && this.equals(element, this.getRoot())) {
            return this.getList();
        }
        return null;
    }

    protected Widget doFindItem(Object element) {
        if (element != null && this.listMap.contains(element)) {
            return this.getList();
        }
        return null;
    }

    protected void doUpdateItem(Widget data, Object element, boolean fullMap) {
        int ix;
        if (element != null && (ix = this.listMap.indexOf(element)) >= 0) {
            ILabelProvider labelProvider = (ILabelProvider)this.getLabelProvider();
            this.list.setItem(ix, labelProvider.getText(element));
        }
    }

    public Control getControl() {
        return this.list;
    }

    public Object getElementAt(int index) {
        if (index >= 0 && index < this.listMap.size()) {
            return this.listMap.get(index);
        }
        return null;
    }

    public IBaseLabelProvider getLabelProvider() {
        return super.getLabelProvider();
    }

    public org.eclipse.swt.widgets.List getList() {
        return this.list;
    }

    protected List getSelectionFromWidget() {
        int[] ixs = this.getList().getSelectionIndices();
        ArrayList<Object> list = new ArrayList<Object>(ixs.length);
        int i = 0;
        while (i < ixs.length) {
            Object e = this.getElementAt(ixs[i]);
            if (e != null) {
                list.add(e);
            }
            ++i;
        }
        return list;
    }

    protected int indexForElement(Object element) {
        ViewerSorter sorter = this.getSorter();
        if (sorter == null) {
            return this.list.getItemCount();
        }
        int count = this.list.getItemCount();
        int min = 0;
        int max = count - 1;
        while (min <= max) {
            int mid = (min + max) / 2;
            Object data = this.listMap.get(mid);
            int compare = sorter.compare(this, data, element);
            if (compare == 0) {
                while (compare == 0) {
                    if (++mid >= count) break;
                    data = this.listMap.get(mid);
                    compare = sorter.compare(this, data, element);
                }
                return mid;
            }
            if (compare < 0) {
                min = mid + 1;
                continue;
            }
            max = mid - 1;
        }
        return min;
    }

    protected void inputChanged(Object input, Object oldInput) {
        this.listMap.clear();
        Object[] children = this.getSortedChildren(this.getRoot());
        int size = children.length;
        org.eclipse.swt.widgets.List list = this.getList();
        list.removeAll();
        String[] labels = new String[size];
        int i = 0;
        while (i < size) {
            Object el = children[i];
            labels[i] = ((ILabelProvider)this.getLabelProvider()).getText(el);
            this.listMap.add(el);
            this.mapElement(el, (Widget)list);
            ++i;
        }
        list.setItems(labels);
    }

    protected void internalRefresh(Object element) {
        if (element == null || this.equals(element, this.getRoot())) {
            if (this.listMap != null) {
                this.listMap.clear();
            }
            this.unmapAllElements();
            List selection = this.getSelectionFromWidget();
            this.list.setRedraw(false);
            this.list.removeAll();
            Object[] children = this.getSortedChildren(this.getRoot());
            ILabelProvider labelProvider = (ILabelProvider)this.getLabelProvider();
            int i = 0;
            while (i < children.length) {
                Object el = children[i];
                this.list.add(labelProvider.getText(el), i);
                this.listMap.add(el);
                this.mapElement(el, (Widget)this.list);
                ++i;
            }
            this.list.setRedraw(true);
            this.setSelectionToWidget(selection, false);
        } else {
            this.doUpdateItem((Widget)this.list, element, true);
        }
    }

    private void internalRemove(Object[] elements) {
        Object input = this.getInput();
        int i = 0;
        while (i < elements.length) {
            if (this.equals(elements[i], input)) {
                this.setInput(null);
                return;
            }
            int ix = this.listMap.indexOf(elements[i]);
            if (ix >= 0) {
                this.list.remove(ix);
                this.listMap.remove(ix);
                this.unmapElement(elements[i], (Widget)this.list);
            }
            ++i;
        }
    }

    public void remove(final Object[] elements) {
        this.assertElementsNotNull(elements);
        this.preservingSelection(new Runnable(){

            public void run() {
                ListViewer.this.internalRemove(elements);
            }
        });
    }

    public void remove(Object element) {
        this.remove(new Object[]{element});
    }

    public void reveal(Object element) {
        Assert.isNotNull(element);
        int index = this.listMap.indexOf(element);
        if (index == -1) {
            return;
        }
        int count = this.list.getItemCount();
        if (count == 0) {
            return;
        }
        int height = this.list.getItemHeight();
        Rectangle rect = this.list.getClientArea();
        int topIndex = this.list.getTopIndex();
        int visibleCount = Math.max((rect.x + rect.height) / height, 1);
        int bottomIndex = Math.min(topIndex + visibleCount + 1, count - 1);
        if (topIndex <= index && index <= bottomIndex) {
            return;
        }
        int newTop = Math.min(Math.max(index - visibleCount / 2, 0), count - 1);
        this.list.setTopIndex(newTop);
    }

    public void setLabelProvider(IBaseLabelProvider labelProvider) {
        Assert.isTrue(labelProvider instanceof ILabelProvider);
        super.setLabelProvider(labelProvider);
    }

    protected void setSelectionToWidget(List in, boolean reveal) {
        org.eclipse.swt.widgets.List list = this.getList();
        if (in == null || in.size() == 0) {
            list.deselectAll();
        } else {
            int n = in.size();
            int[] ixs = new int[n];
            int count = 0;
            int i = 0;
            while (i < n) {
                Object el = in.get(i);
                int ix = this.listMap.indexOf(el);
                if (ix >= 0) {
                    ixs[count++] = ix;
                }
                ++i;
            }
            if (count < n) {
                int[] nArray = ixs;
                ixs = new int[count];
                System.arraycopy(nArray, 0, ixs, 0, count);
            }
            list.setSelection(ixs);
            if (reveal) {
                list.showSelection();
            }
        }
    }
}

