/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.internal.carbon.AEDesc;
import org.eclipse.swt.internal.carbon.CFRange;
import org.eclipse.swt.internal.carbon.NavDialogCreationOptions;
import org.eclipse.swt.internal.carbon.NavReplyRecord;
import org.eclipse.swt.internal.carbon.OS;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Shell;

public class FileDialog
extends Dialog {
    String[] filterNames = new String[0];
    String[] filterExtensions = new String[0];
    String[] fileNames = new String[0];
    String filterPath = "";
    String fileName = "";

    public FileDialog(Shell parent) {
        this(parent, 65536);
    }

    public FileDialog(Shell parent, int style) {
        super(parent, style);
        this.checkSubclass();
    }

    public String getFileName() {
        return this.fileName;
    }

    public String[] getFileNames() {
        return this.fileNames;
    }

    public String[] getFilterExtensions() {
        return this.filterExtensions;
    }

    public String[] getFilterNames() {
        return this.filterNames;
    }

    public String getFilterPath() {
        return this.filterPath;
    }

    public String open() {
        String fullPath = null;
        this.fileNames = new String[0];
        int titlePtr = 0;
        if (this.title != null) {
            char[] buffer = new char[this.title.length()];
            this.title.getChars(0, buffer.length, buffer, 0);
            titlePtr = OS.CFStringCreateWithCharacters((int)0, (char[])buffer, (int)buffer.length);
        }
        int fileNamePtr = 0;
        if (this.fileName != null) {
            char[] buffer = new char[this.fileName.length()];
            this.fileName.getChars(0, buffer.length, buffer, 0);
            fileNamePtr = OS.CFStringCreateWithCharacters((int)0, (char[])buffer, (int)buffer.length);
        }
        NavDialogCreationOptions options = new NavDialogCreationOptions();
        options.windowTitle = options.clientName = titlePtr;
        options.parentWindow = OS.GetControlOwner((int)this.parent.handle);
        options.optionFlags = 4352;
        options.location_h = (short)-1;
        options.location_v = (short)-1;
        options.saveFileName = fileNamePtr;
        int[] outDialog = new int[1];
        if ((this.style & 0x2000) != 0) {
            OS.NavCreatePutFileDialog((NavDialogCreationOptions)options, (int)0, (int)0, (int)0, (int)0, (int[])outDialog);
        } else {
            if ((this.style & 2) != 0) {
                options.optionFlags |= 0x80;
            }
            OS.NavCreateGetFileDialog((NavDialogCreationOptions)options, (int)0, (int)0, (int)0, (int)0, (int)0, (int[])outDialog);
        }
        if (outDialog[0] != 0) {
            OS.NavDialogRun((int)outDialog[0]);
            int action = OS.NavDialogGetUserAction((int)outDialog[0]);
            switch (action) {
                case 2: 
                case 3: 
                case 4: {
                    NavReplyRecord record = new NavReplyRecord();
                    OS.NavDialogGetReply((int)outDialog[0], (NavReplyRecord)record);
                    AEDesc selection = new AEDesc();
                    selection.descriptorType = record.selection_descriptorType;
                    selection.dataHandle = record.selection_dataHandle;
                    int[] count = new int[1];
                    OS.AECountItems((AEDesc)selection, (int[])count);
                    if (count[0] <= 0) break;
                    this.fileNames = new String[count[0]];
                    int maximumSize = 80;
                    int dataPtr = OS.NewPtr((int)maximumSize);
                    int[] aeKeyword = new int[1];
                    int[] typeCode = new int[1];
                    int[] actualSize = new int[1];
                    int pathString = 0;
                    int fullString = 0;
                    int fileString = 0;
                    if ((this.style & 0x2000) != 0) {
                        if (OS.AEGetNthPtr((AEDesc)selection, (int)1, (int)1718841958, (int[])aeKeyword, (int[])typeCode, (int)dataPtr, (int)maximumSize, (int[])actualSize) == 0) {
                            byte[] fsRef = new byte[actualSize[0]];
                            OS.memcpy((byte[])fsRef, (int)dataPtr, (int)actualSize[0]);
                            int pathUrl = OS.CFURLCreateFromFSRef((int)0, (byte[])fsRef);
                            int fullUrl = OS.CFURLCreateCopyAppendingPathComponent((int)0, (int)pathUrl, (int)record.saveFileName, (boolean)false);
                            pathString = OS.CFURLCopyFileSystemPath((int)pathUrl, (int)0);
                            fullString = OS.CFURLCopyFileSystemPath((int)fullUrl, (int)0);
                            fileString = record.saveFileName;
                            OS.CFRelease((int)pathUrl);
                            OS.CFRelease((int)fullUrl);
                        }
                    } else {
                        int i = 0;
                        while (i < count[0]) {
                            if (OS.AEGetNthPtr((AEDesc)selection, (int)(i + 1), (int)1718841958, (int[])aeKeyword, (int[])typeCode, (int)dataPtr, (int)maximumSize, (int[])actualSize) == 0) {
                                byte[] fsRef = new byte[actualSize[0]];
                                OS.memcpy((byte[])fsRef, (int)dataPtr, (int)actualSize[0]);
                                int url = OS.CFURLCreateFromFSRef((int)0, (byte[])fsRef);
                                if (i == 0) {
                                    int pathUrl = OS.CFURLCreateCopyDeletingLastPathComponent((int)0, (int)url);
                                    pathString = OS.CFURLCopyFileSystemPath((int)pathUrl, (int)0);
                                    fullString = OS.CFURLCopyFileSystemPath((int)url, (int)0);
                                    fileString = OS.CFURLCopyLastPathComponent((int)url);
                                    OS.CFRelease((int)pathUrl);
                                } else {
                                    int lastString = OS.CFURLCopyLastPathComponent((int)url);
                                    int length = OS.CFStringGetLength((int)lastString);
                                    char[] buffer = new char[length];
                                    CFRange range = new CFRange();
                                    range.length = length;
                                    OS.CFStringGetCharacters((int)lastString, (CFRange)range, (char[])buffer);
                                    this.fileNames[i] = new String(buffer);
                                    OS.CFRelease((int)lastString);
                                }
                                OS.CFRelease((int)url);
                            }
                            ++i;
                        }
                    }
                    OS.DisposePtr((int)dataPtr);
                    if (pathString != 0) {
                        int length = OS.CFStringGetLength((int)pathString);
                        char[] buffer = new char[length];
                        CFRange range = new CFRange();
                        range.length = length;
                        OS.CFStringGetCharacters((int)pathString, (CFRange)range, (char[])buffer);
                        OS.CFRelease((int)pathString);
                        this.filterPath = new String(buffer);
                    }
                    if (fullString != 0) {
                        int length = OS.CFStringGetLength((int)fullString);
                        char[] buffer = new char[length];
                        CFRange range = new CFRange();
                        range.length = length;
                        OS.CFStringGetCharacters((int)fullString, (CFRange)range, (char[])buffer);
                        OS.CFRelease((int)fullString);
                        fullPath = new String(buffer);
                    }
                    if (fileString == 0) break;
                    int length = OS.CFStringGetLength((int)fileString);
                    char[] buffer = new char[length];
                    CFRange range = new CFRange();
                    range.length = length;
                    OS.CFStringGetCharacters((int)fileString, (CFRange)range, (char[])buffer);
                    OS.CFRelease((int)fileString);
                    this.fileName = this.fileNames[0] = new String(buffer);
                }
            }
        }
        if (titlePtr != 0) {
            OS.CFRelease((int)titlePtr);
        }
        if (fileNamePtr != 0) {
            OS.CFRelease((int)fileNamePtr);
        }
        if (outDialog[0] != 0) {
            OS.NavDialogDispose((int)outDialog[0]);
        }
        return fullPath;
    }

    public void setFileName(String string) {
        this.fileName = string;
    }

    public void setFilterExtensions(String[] extensions) {
        this.filterExtensions = extensions;
    }

    public void setFilterNames(String[] names) {
        this.filterNames = names;
    }

    public void setFilterPath(String string) {
        this.filterPath = string;
    }
}

