#include "xslt.h"
const char *xslt_simple = 
"<?xml version=\"1.0\"?>\n"
"<xsl:stylesheet xmlns:xsl=\"http://www.w3.org/1999/XSL/Transform\" xmlns:swft=\"http://subsignal.org/swfml/swft\" xmlns:str=\"http://exslt.org/strings\" xmlns:math=\"http://exslt.org/math\" extension-element-prefixes=\"swft\" version=\"1.0\">\n"
"<xsl:output method=\"xml\" indent=\"yes\"/><xsl:param name=\"quiet\" select=\"'false'\"/>\n"
"	\n"
"<xsl:template xmlns:swft=\"http://subsignal.org/swfml/swft\" xmlns:str=\"http://exslt.org/strings\" xmlns:math=\"http://exslt.org/math\" name=\"color\">\n"
"	<xsl:variable name=\"red\">\n"
"		<xsl:choose>\n"
"			<xsl:when test=\"@red\"><xsl:value-of select=\"@red\"/></xsl:when>\n"
"			<xsl:when test=\"@color\">0x<xsl:value-of select=\"substring(@color,2,2)\"/></xsl:when>\n"
"			<xsl:otherwise>200</xsl:otherwise>\n"
"		</xsl:choose>\n"
"	</xsl:variable>\n"
"	<xsl:variable name=\"green\">\n"
"		<xsl:choose>\n"
"			<xsl:when test=\"@green\"><xsl:value-of select=\"@green\"/></xsl:when>\n"
"			<xsl:when test=\"@color\">0x<xsl:value-of select=\"substring(@color,4,2)\"/></xsl:when>\n"
"			<xsl:otherwise>200</xsl:otherwise>\n"
"		</xsl:choose>\n"
"	</xsl:variable>\n"
"	<xsl:variable name=\"blue\">\n"
"		<xsl:choose>\n"
"			<xsl:when test=\"@blue\"><xsl:value-of select=\"@blue\"/></xsl:when>\n"
"			<xsl:when test=\"@color\">0x<xsl:value-of select=\"substring(@color,6)\"/></xsl:when>\n"
"			<xsl:otherwise>200</xsl:otherwise>\n"
"		</xsl:choose>\n"
"	</xsl:variable>\n"
"	<Color red=\"{$red}\" green=\"{$green}\" blue=\"{$blue}\"/>\n"
"</xsl:template>\n"
"<xsl:template xmlns:swft=\"http://subsignal.org/swfml/swft\" xmlns:str=\"http://exslt.org/strings\" xmlns:math=\"http://exslt.org/math\" name=\"color-rgba\">\n"
"	<xsl:variable name=\"red\">\n"
"		<xsl:choose>\n"
"			<xsl:when test=\"@red\"><xsl:value-of select=\"@red\"/></xsl:when>\n"
"			<xsl:when test=\"@color\">0x<xsl:value-of select=\"substring(@color,2,2)\"/></xsl:when>\n"
"			<xsl:otherwise>0</xsl:otherwise>\n"
"		</xsl:choose>\n"
"	</xsl:variable>\n"
"	<xsl:variable name=\"green\">\n"
"		<xsl:choose>\n"
"			<xsl:when test=\"@green\"><xsl:value-of select=\"@green\"/></xsl:when>\n"
"			<xsl:when test=\"@color\">0x<xsl:value-of select=\"substring(@color,4,2)\"/></xsl:when>\n"
"			<xsl:otherwise>0</xsl:otherwise>\n"
"		</xsl:choose>\n"
"	</xsl:variable>\n"
"	<xsl:variable name=\"blue\">\n"
"		<xsl:choose>\n"
"			<xsl:when test=\"@blue\"><xsl:value-of select=\"@blue\"/></xsl:when>\n"
"			<xsl:when test=\"@color\">0x<xsl:value-of select=\"substring(@color,6)\"/></xsl:when>\n"
"			<xsl:otherwise>0</xsl:otherwise>\n"
"		</xsl:choose>\n"
"	</xsl:variable>\n"
"	<xsl:variable name=\"alpha\">\n"
"		<xsl:choose>\n"
"			<xsl:when test=\"@alpha\"><xsl:value-of select=\"@alpha\"/></xsl:when>\n"
"			<xsl:when test=\"string-length(@color) = 9\">0x<xsl:value-of select=\"substring(@color,8)\"/></xsl:when>\n"
"			<xsl:otherwise>255</xsl:otherwise>\n"
"		</xsl:choose>\n"
"	</xsl:variable>\n"
"	<Color red=\"{$red}\" green=\"{$green}\" blue=\"{$blue}\" alpha=\"{$alpha}\"/>\n"
"</xsl:template>\n"
"<xsl:template xmlns:swft=\"http://subsignal.org/swfml/swft\" xmlns:str=\"http://exslt.org/strings\" xmlns:math=\"http://exslt.org/math\" name=\"color-rgba-param\">\n"
"	<xsl:param name=\"color\">#00000000</xsl:param>\n"
"	<xsl:param name=\"alpha\"/>\n"
"	<xsl:variable name=\"red\">\n"
"		<xsl:choose>\n"
"			<xsl:when test=\"$color\">0x<xsl:value-of select=\"substring($color,2,2)\"/></xsl:when>\n"
"			<xsl:otherwise>0</xsl:otherwise>\n"
"		</xsl:choose>\n"
"	</xsl:variable>\n"
"	<xsl:variable name=\"green\">\n"
"		<xsl:choose>\n"
"			<xsl:when test=\"$color\">0x<xsl:value-of select=\"substring($color,4,2)\"/></xsl:when>\n"
"			<xsl:otherwise>0</xsl:otherwise>\n"
"		</xsl:choose>\n"
"	</xsl:variable>\n"
"	<xsl:variable name=\"blue\">\n"
"		<xsl:choose>\n"
"			<xsl:when test=\"$color\">0x<xsl:value-of select=\"substring($color,6)\"/></xsl:when>\n"
"			<xsl:otherwise>0</xsl:otherwise>\n"
"		</xsl:choose>\n"
"	</xsl:variable>\n"
"	<xsl:variable name=\"a\">\n"
"		<xsl:choose>\n"
"			<xsl:when test=\"$alpha != ''\"><xsl:value-of select=\"$alpha * 255\"/></xsl:when>\n"
"			<xsl:when test=\"string-length($color) = 9\">0x<xsl:value-of select=\"substring($color,8)\"/></xsl:when>\n"
"			<xsl:otherwise>255</xsl:otherwise>\n"
"		</xsl:choose>\n"
"	</xsl:variable>\n"
"	<Color red=\"{$red}\" green=\"{$green}\" blue=\"{$blue}\" alpha=\"{$a}\"/>\n"
"</xsl:template>\n"
"<xsl:template xmlns:swft=\"http://subsignal.org/swfml/swft\" xmlns:str=\"http://exslt.org/strings\" xmlns:math=\"http://exslt.org/math\" match=\"string\" mode=\"set\">\n"
"	<PushData>\n"
"		<items>\n"
"			<StackString value=\"{@name}\"/>\n"
"			<StackString value=\"{@value}\"/>\n"
"		</items>\n"
"	</PushData>\n"
"	<SetVariable/>\n"
"</xsl:template>\n"
"<xsl:template xmlns:swft=\"http://subsignal.org/swfml/swft\" xmlns:str=\"http://exslt.org/strings\" xmlns:math=\"http://exslt.org/math\" match=\"number\" mode=\"set\">\n"
"	<PushData>\n"
"		<items>\n"
"			<StackString value=\"{@name}\"/>\n"
"			<StackDouble value=\"{@value}\"/>\n"
"		</items>\n"
"	</PushData>\n"
"	<SetVariable/>\n"
"</xsl:template>\n"
"<xsl:template xmlns:swft=\"http://subsignal.org/swfml/swft\" xmlns:str=\"http://exslt.org/strings\" xmlns:math=\"http://exslt.org/math\" match=\"boolean\" mode=\"set\">\n"
"	<PushData>\n"
"		<items>\n"
"			<StackString value=\"{@name}\"/>\n"
"			<StackBoolean value=\"{@value}\"/>\n"
"		</items>\n"
"	</PushData>\n"
"	<SetVariable/>\n"
"</xsl:template>\n"
"<xsl:template xmlns:swft=\"http://subsignal.org/swfml/swft\" xmlns:str=\"http://exslt.org/strings\" xmlns:math=\"http://exslt.org/math\" name=\"register-class\">\n"
"	<xsl:param name=\"class\"/>\n"
"	<xsl:param name=\"linkage-id\"/>\n"
"	<xsl:variable name=\"packages\" select=\"str:tokenize($class,'.')\"/>\n"
"	<xsl:variable name=\"strofs\">3</xsl:variable>\n"
"	<xsl:variable name=\"id\" select=\"swft:next-id()\"/>\n"
"\n"
"	<DefineSprite objectID=\"{$id}\" frames=\"1\">\n"
"		<tags>\n"
"		  <End/>\n"
"		</tags>\n"
"	</DefineSprite>\n"
"	<Export>\n"
"		<symbols>\n"
"		  <Symbol objectID=\"{$id}\" name=\"__Packages.swfmill.registerClass.{$linkage-id}\"/>\n"
"		</symbols>\n"
"	</Export>\n"
"	<DoInitAction sprite=\"{$id}\">\n"
"		<actions>\n"
"			<Dictionary>\n"
"				<strings>\n"
"					<String value=\"Object\"/>\n"
"					<String value=\"registerClass\"/>\n"
"					<String value=\"{$linkage-id}\"/>\n"
"					<xsl:for-each select=\"$packages\">\n"
"						<String value=\"{.}\"/>\n"
"					</xsl:for-each>\n"
"				</strings>\n"
"			</Dictionary>\n"
"			\n"
"			<!-- package root -->\n"
"			<PushData>\n"
"				<items>\n"
"				  <StackDictionaryLookup index=\"{$strofs}\"/> \n"
"				</items>\n"
"			</PushData>\n"
"			<GetVariable/>\n"
"			\n"
"			<!-- packages -->\n"
"			<xsl:for-each select=\"$packages[position()&gt;1]\">\n"
"				<PushData>\n"
"					<items>\n"
"					  <StackDictionaryLookup index=\"{$strofs + position()}\"/>\n"
"					</items>\n"
"				</PushData>\n"
"				<GetMember/>\n"
"			</xsl:for-each>\n"
"			\n"
"			<!-- linkage id, 2 (arguments), Object-->\n"
"			<PushData>\n"
"				<items>\n"
"				  <StackDictionaryLookup index=\"2\"/>\n"
"				  <StackInteger value=\"2\"/>\n"
"				  <StackDictionaryLookup index=\"0\"/>\n"
"				</items>\n"
"			</PushData>\n"
"			<GetVariable/>\n"
"			<!-- registerClass -->\n"
"			<PushData>\n"
"				<items>\n"
"				  <StackDictionaryLookup index=\"1\"/>\n"
"				</items>\n"
"			</PushData>\n"
"			<CallMethod/>\n"
"			<Pop/>\n"
"			<EndAction/>\n"
"		</actions>\n"
"	</DoInitAction>\n"
"	\n"
"</xsl:template>\n"
"<xsl:template xmlns:swft=\"http://subsignal.org/swfml/swft\" xmlns:str=\"http://exslt.org/strings\" xmlns:math=\"http://exslt.org/math\" match=\"html-wrapper\">\n"
"	<xsl:document href=\"{@name}\">\n"
"<html>\n"
"	<body>\n"
"	<object classid=\"clsid:d27cdb6e-ae6d-11cf-96b8-444553540000\" codebase=\"http://fpdownload.macromedia.com/pub/shockwave/cabs/flash/swflash.cab#version=7,0,0,0\" width=\"{/movie/@width}\" height=\"{/movie/@width}\" id=\"video\" align=\"middle\">\n"
"		<param name=\"allowScriptAccess\" value=\"sameDomain\"/>\n"
"		<param name=\"movie\" value=\"{@swf}\"/>\n"
"		<param name=\"quality\" value=\"high\"/>\n"
"		<embed src=\"{@swf}\" quality=\"high\" width=\"{/movie/@width}\" height=\"{/movie/@height}\" name=\"video\" align=\"middle\" allowScriptAccess=\"sameDomain\" type=\"application/x-shockwave-flash\" pluginspage=\"http://www.macromedia.com/go/getflashplayer\"/>\n"
"	</object>\n"
"	</body>\n"
"</html>\n"
"	</xsl:document>\n"
"</xsl:template>\n"
"<xsl:template xmlns:swft=\"http://subsignal.org/swfml/swft\" xmlns:str=\"http://exslt.org/strings\" xmlns:math=\"http://exslt.org/math\" match=\"*\" mode=\"htmltext\">\n"
"	<xsl:text>&lt;</xsl:text>\n"
"	<xsl:value-of select=\"name()\"/>\n"
"		<xsl:apply-templates select=\"@*\" mode=\"htmltext\"/>\n"
"	<xsl:text>&gt;</xsl:text>\n"
"		<xsl:apply-templates select=\"*|text()\" mode=\"htmltext\"/>\n"
"	<xsl:text>&lt;/</xsl:text>\n"
"	<xsl:value-of select=\"name()\"/>\n"
"	<xsl:text>&gt;</xsl:text>\n"
"</xsl:template>\n"
"<xsl:template xmlns:swft=\"http://subsignal.org/swfml/swft\" xmlns:str=\"http://exslt.org/strings\" xmlns:math=\"http://exslt.org/math\" match=\"@*\" mode=\"htmltext\">\n"
"	<xsl:text> </xsl:text>\n"
"	<xsl:value-of select=\"name()\"/>\n"
"	<xsl:text>=\"</xsl:text>\n"
"	<xsl:value-of select=\".\"/>\n"
"	<xsl:text>\"</xsl:text>\n"
"</xsl:template>\n"
"<xsl:template xmlns:swft=\"http://subsignal.org/swfml/swft\" xmlns:str=\"http://exslt.org/strings\" xmlns:math=\"http://exslt.org/math\" match=\"text()\" mode=\"htmltext\">\n"
"	<xsl:value-of select=\".\"/>\n"
"</xsl:template>\n"
"<xsl:template xmlns:swft=\"http://subsignal.org/swfml/swft\" xmlns:str=\"http://exslt.org/strings\" xmlns:math=\"http://exslt.org/math\" match=\"@objectID|@sprite|@fontRef\">\n"
"	<xsl:attribute name=\"{name()}\"><xsl:value-of select=\"swft:map-id(.)\"/></xsl:attribute>\n"
"</xsl:template>\n"
"<xsl:template xmlns:swft=\"http://subsignal.org/swfml/swft\" xmlns:str=\"http://exslt.org/strings\" xmlns:math=\"http://exslt.org/math\" match=\"*|@*|text()\" priority=\"-2\">\n"
"	<xsl:copy select=\".\">\n"
"		<xsl:apply-templates select=\"*|@*|text()\"/>\n"
"	</xsl:copy>\n"
"</xsl:template>\n"
"	\n"
"<xsl:variable xmlns:swft=\"http://subsignal.org/swfml/swft\" xmlns:str=\"http://exslt.org/strings\" xmlns:math=\"http://exslt.org/math\" xmlns:dc=\"http://purl.org/dc/elements/1.1/\" xmlns:rdf=\"http://www.w3.org/1999/02/22-rdf-syntax-ns#\" name=\"movie-version\">\n"
"	<xsl:choose>\n"
"		<xsl:when test=\"movie/@version\"><xsl:value-of select=\"movie/@version\"/></xsl:when>\n"
"		<xsl:otherwise>7</xsl:otherwise>\n"
"	</xsl:choose>\n"
"</xsl:variable>\n"
"<xsl:template xmlns:swft=\"http://subsignal.org/swfml/swft\" xmlns:str=\"http://exslt.org/strings\" xmlns:math=\"http://exslt.org/math\" xmlns:dc=\"http://purl.org/dc/elements/1.1/\" xmlns:rdf=\"http://www.w3.org/1999/02/22-rdf-syntax-ns#\" match=\"movie\">\n"
"	<!-- set defaults for movie -->\n"
"	<xsl:variable name=\"version\" select=\"$movie-version\"/>\n"
"	<xsl:variable name=\"compressed\">\n"
"		<xsl:choose>\n"
"			<xsl:when test=\"@compressed='true'\">1</xsl:when>\n"
"			<xsl:when test=\"@compressed='false'\">0</xsl:when>\n"
"			<xsl:otherwise>1</xsl:otherwise>\n"
"		</xsl:choose>\n"
"	</xsl:variable>\n"
"	<xsl:variable name=\"framerate\">\n"
"		<xsl:choose>\n"
"			<xsl:when test=\"@framerate\"><xsl:value-of select=\"@framerate\"/></xsl:when>\n"
"			<xsl:otherwise>12</xsl:otherwise>\n"
"		</xsl:choose>\n"
"	</xsl:variable>\n"
"	<xsl:variable name=\"frames\">\n"
"		<xsl:choose>\n"
"			<xsl:when test=\"@frames\"><xsl:value-of select=\"@frames\"/></xsl:when>\n"
"			<xsl:otherwise>1</xsl:otherwise>\n"
"		</xsl:choose>\n"
"	</xsl:variable>\n"
"	<xsl:variable name=\"left\">\n"
"		<xsl:choose>\n"
"			<xsl:when test=\"@left\"><xsl:value-of select=\"@left * 20\"/></xsl:when>\n"
"			<xsl:otherwise>0</xsl:otherwise>\n"
"		</xsl:choose>\n"
"	</xsl:variable>\n"
"	<xsl:variable name=\"top\">\n"
"		<xsl:choose>\n"
"			<xsl:when test=\"@top\"><xsl:value-of select=\"@top * 20\"/></xsl:when>\n"
"			<xsl:otherwise>0</xsl:otherwise>\n"
"		</xsl:choose>\n"
"	</xsl:variable>\n"
"	<xsl:variable name=\"right\">\n"
"		<xsl:choose>\n"
"			<xsl:when test=\"@width\"><xsl:value-of select=\"$left + (@width * 20)\"/></xsl:when>\n"
"			<xsl:otherwise>6400</xsl:otherwise>\n"
"		</xsl:choose>\n"
"	</xsl:variable>\n"
"	<xsl:variable name=\"bottom\">\n"
"		<xsl:choose>\n"
"			<xsl:when test=\"@height\"><xsl:value-of select=\"$top + (@height * 20)\"/></xsl:when>\n"
"			<xsl:otherwise>4800</xsl:otherwise>\n"
"		</xsl:choose>\n"
"	</xsl:variable>\n"
"	<xsl:variable name=\"hasMetaData\">\n"
"		<xsl:choose>\n"
"			<xsl:when test=\"count(meta) &gt; 0\">1</xsl:when>\n"
"			<xsl:otherwise>0</xsl:otherwise>\n"
"		</xsl:choose>\n"
"	</xsl:variable>\n"
"	<xsl:variable name=\"useNetwork\">\n"
"		<xsl:choose>\n"
"			<xsl:when test=\"@local-access = 'network'\">1</xsl:when>\n"
"			<xsl:when test=\"@local-access = 'filesystem'\">0</xsl:when>\n"
"			<xsl:otherwise>0</xsl:otherwise>\n"
"		</xsl:choose>\n"
"	</xsl:variable>\n"
"	<xsl:variable name=\"as3\">\n"
"		<xsl:choose>\n"
"			<xsl:when test=\"@as3\">1</xsl:when>\n"
"			<xsl:otherwise>0</xsl:otherwise>\n"
"		</xsl:choose>\n"
"	</xsl:variable>\n"
"\n"
"	<swf version=\"{$version}\" compressed=\"{$compressed}\">\n"
"		<Header framerate=\"{$framerate}\" frames=\"{$frames}\">\n"
"			<size>\n"
"				<Rectangle left=\"{$left}\" right=\"{$right}\" top=\"{$top}\" bottom=\"{$bottom}\"/>\n"
"			</size>\n"
"			<tags>\n"
"				<xsl:if test=\"$version &gt;= 8\">\n"
"					<FileAttributes hasMetaData=\"{$hasMetaData}\" useNetwork=\"{$useNetwork}\" allowABC=\"{$as3}\"/>\n"
"				</xsl:if>\n"
"				<xsl:apply-templates/>\n"
"				<End/>\n"
"			</tags>\n"
"		</Header>\n"
"	</swf>\n"
"</xsl:template>\n"
"<xsl:template xmlns:swft=\"http://subsignal.org/swfml/swft\" xmlns:str=\"http://exslt.org/strings\" xmlns:math=\"http://exslt.org/math\" xmlns:dc=\"http://purl.org/dc/elements/1.1/\" xmlns:rdf=\"http://www.w3.org/1999/02/22-rdf-syntax-ns#\" match=\"background\">\n"
"	<SetBackgroundColor>\n"
"		<color>\n"
"			<xsl:call-template name=\"color\"/>\n"
"		</color>\n"
"	</SetBackgroundColor>\n"
"</xsl:template>\n"
"<xsl:template xmlns:swft=\"http://subsignal.org/swfml/swft\" xmlns:str=\"http://exslt.org/strings\" xmlns:math=\"http://exslt.org/math\" xmlns:dc=\"http://purl.org/dc/elements/1.1/\" xmlns:rdf=\"http://www.w3.org/1999/02/22-rdf-syntax-ns#\" match=\"meta\">\n"
"	<Metadata>\n"
"		<rdf:RDF>\n"
"			<rdf:Description>\n"
"				<xsl:apply-templates select=\"@*\" mode=\"meta\"/>\n"
"		    </rdf:Description>\n"
"			<xsl:copy-of select=\"*\"/>\n"
"		</rdf:RDF>\n"
"	</Metadata>\n"
"</xsl:template>\n"
"<xsl:template xmlns:swft=\"http://subsignal.org/swfml/swft\" xmlns:str=\"http://exslt.org/strings\" xmlns:math=\"http://exslt.org/math\" xmlns:dc=\"http://purl.org/dc/elements/1.1/\" xmlns:rdf=\"http://www.w3.org/1999/02/22-rdf-syntax-ns#\" match=\"@title\" mode=\"meta\">\n"
"	<dc:title>\n"
"		<xsl:apply-templates/>\n"
"	</dc:title>\n"
"</xsl:template>\n"
"<xsl:template xmlns:swft=\"http://subsignal.org/swfml/swft\" xmlns:str=\"http://exslt.org/strings\" xmlns:math=\"http://exslt.org/math\" xmlns:dc=\"http://purl.org/dc/elements/1.1/\" xmlns:rdf=\"http://www.w3.org/1999/02/22-rdf-syntax-ns#\" match=\"@description\" mode=\"meta\">\n"
"	<dc:description>\n"
"		<xsl:apply-templates/>\n"
"	</dc:description>\n"
"</xsl:template>\n"
"<xsl:template xmlns:swft=\"http://subsignal.org/swfml/swft\" xmlns:str=\"http://exslt.org/strings\" xmlns:math=\"http://exslt.org/math\" xmlns:dc=\"http://purl.org/dc/elements/1.1/\" xmlns:rdf=\"http://www.w3.org/1999/02/22-rdf-syntax-ns#\" match=\"*|text()\" mode=\"meta\"/>\n"
"<xsl:template xmlns:swft=\"http://subsignal.org/swfml/swft\" xmlns:str=\"http://exslt.org/strings\" xmlns:math=\"http://exslt.org/math\" xmlns:dc=\"http://purl.org/dc/elements/1.1/\" xmlns:rdf=\"http://www.w3.org/1999/02/22-rdf-syntax-ns#\" match=\"library\">\n"
"	<xsl:apply-templates/>\n"
"</xsl:template>\n"
"<xsl:template xmlns:swft=\"http://subsignal.org/swfml/swft\" xmlns:str=\"http://exslt.org/strings\" xmlns:math=\"http://exslt.org/math\" xmlns:dc=\"http://purl.org/dc/elements/1.1/\" xmlns:rdf=\"http://www.w3.org/1999/02/22-rdf-syntax-ns#\" match=\"@id\" mode=\"export\">\n"
"	<xsl:param name=\"id\"/>\n"
"	<Export count=\"1\">\n"
"		<symbols>\n"
"			<Symbol objectID=\"{$id}\">\n"
"				<xsl:attribute name=\"name\"><xsl:value-of select=\".\"/></xsl:attribute>\n"
"			</Symbol>\n"
"		</symbols>\n"
"	</Export>\n"
"</xsl:template>\n"
"<xsl:template xmlns:swft=\"http://subsignal.org/swfml/swft\" xmlns:str=\"http://exslt.org/strings\" xmlns:math=\"http://exslt.org/math\" xmlns:dc=\"http://purl.org/dc/elements/1.1/\" xmlns:rdf=\"http://www.w3.org/1999/02/22-rdf-syntax-ns#\" match=\"@*\" mode=\"export\" priority=\"-1\"/>\n"
"<xsl:template xmlns:swft=\"http://subsignal.org/swfml/swft\" xmlns:str=\"http://exslt.org/strings\" xmlns:math=\"http://exslt.org/math\" xmlns:dc=\"http://purl.org/dc/elements/1.1/\" xmlns:rdf=\"http://www.w3.org/1999/02/22-rdf-syntax-ns#\" match=\"place\">\n"
"	<xsl:variable name=\"id\">\n"
"		<xsl:value-of select=\"swft:map-id(@id)\"/>\n"
"	</xsl:variable>\n"
"	<xsl:variable name=\"x\">\n"
"		<xsl:choose>\n"
"			<xsl:when test=\"@x\"><xsl:value-of select=\"@x * 20\"/></xsl:when>\n"
"			<xsl:otherwise>0</xsl:otherwise>\n"
"		</xsl:choose>\n"
"	</xsl:variable>\n"
"	<xsl:variable name=\"y\">\n"
"		<xsl:choose>\n"
"			<xsl:when test=\"@y\"><xsl:value-of select=\"@y * 20\"/></xsl:when>\n"
"			<xsl:otherwise>0</xsl:otherwise>\n"
"		</xsl:choose>\n"
"	</xsl:variable>\n"
"	<xsl:variable name=\"scale\">\n"
"		<xsl:choose>\n"
"			<xsl:when test=\"@scale\"><xsl:value-of select=\"@scale\"/></xsl:when>\n"
"			<xsl:otherwise>1</xsl:otherwise>\n"
"		</xsl:choose>\n"
"	</xsl:variable>\n"
"    <xsl:variable name=\"skewx\">\n"
"            <xsl:choose>\n"
"                    <xsl:when test=\"@skewx\"><xsl:value-of select=\"@skewx\"/></xsl:when>\n"
"                    <xsl:otherwise>0</xsl:otherwise>\n"
"            </xsl:choose>\n"
"    </xsl:variable>\n"
"    <xsl:variable name=\"skewy\">\n"
"            <xsl:choose>\n"
"                    <xsl:when test=\"@skewy\"><xsl:value-of select=\"@skewy\"/></xsl:when>\n"
"                    <xsl:otherwise>0</xsl:otherwise>\n"
"            </xsl:choose>\n"
"    </xsl:variable>\n"
"    <xsl:variable name=\"scalex\">\n"
"            <xsl:choose>\n"
"                    <xsl:when test=\"@scalex\"><xsl:value-of select=\"@scalex\"/></xsl:when>\n"
"                    <xsl:when test=\"@scale\"><xsl:value-of select=\"@scale\"/></xsl:when>\n"
"                    <xsl:otherwise>1</xsl:otherwise>\n"
"            </xsl:choose>\n"
"    </xsl:variable>\n"
"    <xsl:variable name=\"scaley\">\n"
"            <xsl:choose>\n"
"                    <xsl:when test=\"@scaley\"><xsl:value-of select=\"@scaley\"/></xsl:when>\n"
"                    <xsl:when test=\"@scale\"><xsl:value-of select=\"@scale\"/></xsl:when>\n"
"                    <xsl:otherwise>1</xsl:otherwise>\n"
"            </xsl:choose>\n"
"    </xsl:variable>\n"
"\n"
"	<xsl:variable name=\"depth\"><xsl:value-of select=\"@depth\"/></xsl:variable>\n"
"	\n"
"	<!-- Setting replace=\"1\" doesn't work if we are replacing a sprite.\n"
"		 Instead, we remove the previous sprite with RemoveObject2,\n"
"		 and increment \"morph\". This strange requirement isn't\n"
"		 documented anywhere, but this is what Flash does, and it\n"
"		 works. See bug #409165 on Launchpad. -->\n"
"	<xsl:variable name=\"replace\">\n"
"		<xsl:choose>\n"
"			<xsl:when test=\"preceding-sibling::place[@depth=$depth] or ../preceding-sibling::frame/place[@depth=$depth]\">1</xsl:when>\n"
"			<xsl:otherwise>0</xsl:otherwise>\n"
"		</xsl:choose>\n"
"	</xsl:variable>\n"
"	<xsl:variable name=\"morph\">\n"
"		<xsl:value-of select=\"count(preceding-sibling::place[@depth=$depth] |     ../preceding-sibling::frame/place[@depth=$depth])\"/>\n"
"	</xsl:variable>\n"
"	<xsl:if test=\"$replace = '1'\">\n"
"		<RemoveObject2 depth=\"{@depth}\"/>\n"
"	</xsl:if>\n"
"	<PlaceObject2 replace=\"0\" morph=\"{$morph}\" depth=\"{$depth}\" objectID=\"{$id}\">\n"
"		<xsl:if test=\"@name\">\n"
"			<xsl:attribute name=\"name\"><xsl:value-of select=\"@name\"/></xsl:attribute>\n"
"		</xsl:if>\n"
"		<xsl:if test=\"*\">\n"
"			<!-- 0x200: initialize -->\n"
"			<xsl:attribute name=\"allflags1\">0x200</xsl:attribute>\n"
"			<events>\n"
"				<Event flags1=\"0x200\">\n"
"					<actions>\n"
"						<xsl:apply-templates mode=\"set\"/>\n"
"						<EndAction/>\n"
"					</actions>\n"
"				</Event>\n"
"				<Event/>\n"
"			</events>\n"
"		</xsl:if>\n"
"		<transform>\n"
"			<Transform transX=\"{$x}\" transY=\"{$y}\" scaleX=\"{$scalex}\" scaleY=\"{$scaley}\" skewX=\"{$skewx}\" skewY=\"{$skewy}\"/>\n"
"		</transform>\n"
"	</PlaceObject2>\n"
"</xsl:template>\n"
"<xsl:template xmlns:swft=\"http://subsignal.org/swfml/swft\" xmlns:str=\"http://exslt.org/strings\" xmlns:math=\"http://exslt.org/math\" xmlns:dc=\"http://purl.org/dc/elements/1.1/\" xmlns:rdf=\"http://www.w3.org/1999/02/22-rdf-syntax-ns#\" match=\"transform\">\n"
"	<xsl:variable name=\"id\">\n"
"		<xsl:value-of select=\"swft:map-id(@id)\"/>\n"
"	</xsl:variable>\n"
"	<xsl:variable name=\"myid\">\n"
"		<xsl:value-of select=\"@id\"/>\n"
"	</xsl:variable>\n"
"	<xsl:variable name=\"x\">\n"
"		<xsl:choose>\n"
"			<xsl:when test=\"@x\"><xsl:value-of select=\"@x * 20\"/></xsl:when>\n"
"			<xsl:otherwise>0</xsl:otherwise>\n"
"		</xsl:choose>\n"
"	</xsl:variable>\n"
"	<xsl:variable name=\"y\">\n"
"		<xsl:choose>\n"
"			<xsl:when test=\"@y\"><xsl:value-of select=\"@y * 20\"/></xsl:when>\n"
"			<xsl:otherwise>0</xsl:otherwise>\n"
"		</xsl:choose>\n"
"	</xsl:variable>\n"
"	<xsl:variable name=\"scale\">\n"
"		<xsl:choose>\n"
"			<xsl:when test=\"@scale\"><xsl:value-of select=\"@scale\"/></xsl:when>\n"
"			<xsl:otherwise>1</xsl:otherwise>\n"
"		</xsl:choose>\n"
"	</xsl:variable>\n"
"\n"
"    <xsl:variable name=\"scalex\">\n"
"            <xsl:choose>\n"
"                    <xsl:when test=\"@scalex\"><xsl:value-of select=\"@scalex\"/></xsl:when>\n"
"                    <xsl:when test=\"@scale\"><xsl:value-of select=\"@scale\"/></xsl:when>\n"
"                    <xsl:otherwise>1</xsl:otherwise>\n"
"            </xsl:choose>\n"
"    </xsl:variable>\n"
"    <xsl:variable name=\"scaley\">\n"
"            <xsl:choose>\n"
"                    <xsl:when test=\"@scaley\"><xsl:value-of select=\"@scaley\"/></xsl:when>\n"
"                    <xsl:when test=\"@scale\"><xsl:value-of select=\"@scale\"/></xsl:when>\n"
"                    <xsl:otherwise>1</xsl:otherwise>\n"
"            </xsl:choose>\n"
"    </xsl:variable>\n"
"    <xsl:variable name=\"skewx\">\n"
"            <xsl:choose>\n"
"                    <xsl:when test=\"@skewx\"><xsl:value-of select=\"@skewx\"/></xsl:when>\n"
"                    <xsl:otherwise>0</xsl:otherwise>\n"
"            </xsl:choose>\n"
"    </xsl:variable>\n"
"    <xsl:variable name=\"skewy\">\n"
"            <xsl:choose>\n"
"                    <xsl:when test=\"@skewy\"><xsl:value-of select=\"@skewy\"/></xsl:when>\n"
"                    <xsl:otherwise>0</xsl:otherwise>\n"
"            </xsl:choose>\n"
"    </xsl:variable>\n"
" \n"
"	<xsl:variable name=\"depth\">\n"
"		<xsl:value-of select=\"preceding-sibling::place[@id=$myid]/@depth\"/>\n"
"	</xsl:variable>\n"
"	\n"
"	<PlaceObject2 replace=\"1\" depth=\"{$depth}\" objectID=\"{$id}\">\n"
"		<transform>\n"
"			<Transform transX=\"{$x}\" transY=\"{$y}\" scaleX=\"{$scalex}\" scaleY=\"{$scaley}\" skewX=\"{$skewx}\" skewY=\"{$skewy}\"/>\n"
"		</transform>\n"
"	</PlaceObject2>\n"
"</xsl:template>\n"
"<xsl:template xmlns:swft=\"http://subsignal.org/swfml/swft\" xmlns:str=\"http://exslt.org/strings\" xmlns:math=\"http://exslt.org/math\" xmlns:dc=\"http://purl.org/dc/elements/1.1/\" xmlns:rdf=\"http://www.w3.org/1999/02/22-rdf-syntax-ns#\" match=\"textfield\">\n"
"	<xsl:variable name=\"id\">\n"
"		<xsl:value-of select=\"swft:map-id(@id)\"/>\n"
"	</xsl:variable>\n"
"	<xsl:variable name=\"x\">\n"
"		<xsl:choose>\n"
"			<xsl:when test=\"@x\"><xsl:value-of select=\"@x * 20\"/></xsl:when>\n"
"			<xsl:otherwise>0</xsl:otherwise>\n"
"		</xsl:choose>\n"
"	</xsl:variable>\n"
"	<xsl:variable name=\"y\">\n"
"		<xsl:choose>\n"
"			<xsl:when test=\"@y\"><xsl:value-of select=\"@y * 20\"/></xsl:when>\n"
"			<xsl:otherwise>0</xsl:otherwise>\n"
"		</xsl:choose>\n"
"	</xsl:variable>\n"
"	<xsl:variable name=\"width\">\n"
"		<xsl:choose>\n"
"			<xsl:when test=\"@width\"><xsl:value-of select=\"@width * 20\"/></xsl:when>\n"
"			<xsl:otherwise>100</xsl:otherwise>\n"
"		</xsl:choose>\n"
"	</xsl:variable>\n"
"	<xsl:variable name=\"height\">\n"
"		<xsl:choose>\n"
"			<xsl:when test=\"@height\"><xsl:value-of select=\"@height * 20\"/></xsl:when>\n"
"			<xsl:otherwise>100</xsl:otherwise>\n"
"		</xsl:choose>\n"
"	</xsl:variable>\n"
"	<xsl:variable name=\"size\">\n"
"		<xsl:choose>\n"
"			<xsl:when test=\"@size\"><xsl:value-of select=\"@size * 20\"/></xsl:when>\n"
"			<xsl:otherwise>240</xsl:otherwise>\n"
"		</xsl:choose>\n"
"	</xsl:variable>\n"
"	<xsl:variable name=\"leading\">\n"
"		<xsl:choose>\n"
"			<xsl:when test=\"@leading\"><xsl:value-of select=\"@leading * 20\"/></xsl:when>\n"
"			<xsl:otherwise>20</xsl:otherwise>\n"
"		</xsl:choose>\n"
"	</xsl:variable>\n"
"\n"
"	<DefineEditText objectID=\"{$id}\" fontRef=\"{swft:map-id(@font)}\" fontHeight=\"{$size}\" readOnly=\"0\" autoSize=\"0\" hasLayout=\"0\" notSelectable=\"0\" hasBorder=\"0\" isHTML=\"0\" useOutlines=\"{@useOutlines}\" align=\"0\" leftMargin=\"0\" rightMargin=\"0\" indent=\"0\" leading=\"{$leading}\" wordWrap=\"1\" multiLine=\"1\" password=\"0\" variableName=\"{@name}\">\n"
"		<xsl:for-each select=\"@wordWrap|@multiLine|@password|@readOnly|@autoSize|@notSelectable|@hasBorder|@isHTML|@useOutlines|@align|@leftMargin|@rightMargin|@indent\">\n"
"			<xsl:copy-of select=\".\"/>\n"
"		</xsl:for-each>\n"
"		<xsl:choose>\n"
"			<xsl:when test=\"*|text()\">\n"
"				<xsl:attribute name=\"initialText\">\n"
"					<xsl:apply-templates select=\"*|text()\" mode=\"htmltext\"/>\n"
"				</xsl:attribute>\n"
"			</xsl:when>\n"
"			<xsl:when test=\"@text\">\n"
"				<xsl:attribute name=\"initialText\">\n"
"					<xsl:value-of select=\"@text\"/>\n"
"				</xsl:attribute>\n"
"			</xsl:when>\n"
"		</xsl:choose>\n"
"		<size>\n"
"			<Rectangle left=\"{$x}\" right=\"{$x + $width}\" top=\"{$y}\" bottom=\"{$y + $height}\"/>\n"
"		</size>\n"
"		<color>\n"
"			<xsl:call-template name=\"color-rgba\"/>\n"
"		</color>\n"
"	</DefineEditText>\n"
"	\n"
"	<xsl:if test=\"$movie-version &gt; 7\">\n"
"		<xsl:apply-templates select=\"text-settings\">\n"
"			<xsl:with-param name=\"id\" select=\"$id\"/>\n"
"		</xsl:apply-templates>\n"
"	</xsl:if>\n"
"\n"
"</xsl:template>\n"
"<xsl:template xmlns:swft=\"http://subsignal.org/swfml/swft\" xmlns:str=\"http://exslt.org/strings\" xmlns:math=\"http://exslt.org/math\" xmlns:dc=\"http://purl.org/dc/elements/1.1/\" xmlns:rdf=\"http://www.w3.org/1999/02/22-rdf-syntax-ns#\" match=\"text-settings\">\n"
"	<xsl:param name=\"id\" select=\"0\"/>\n"
"	\n"
"	<CSMTextSettings objectId=\"{$id}\">\n"
"		<xsl:attribute name=\"useFlashType\">\n"
"			<xsl:choose>\n"
"				<xsl:when test=\"@render = 'advanced'\">1</xsl:when>\n"
"				<xsl:otherwise>0</xsl:otherwise>\n"
"			</xsl:choose>\n"
"		</xsl:attribute>\n"
"		<xsl:attribute name=\"gridFit\">\n"
"			<xsl:choose>\n"
"				<xsl:when test=\"@grid = 'sub-pixel'\">2</xsl:when>\n"
"				<xsl:when test=\"@grid = 'pixel'\">1</xsl:when>\n"
"				<xsl:otherwise>0</xsl:otherwise>\n"
"			</xsl:choose>\n"
"		</xsl:attribute>\n"
"		<xsl:attribute name=\"thickness\">\n"
"			<xsl:choose>\n"
"				<xsl:when test=\"@thickness\">\n"
"					<xsl:choose>\n"
"						<xsl:when test=\"@thickness &lt; -200\">\n"
"							<xsl:value-of select=\"-200\"/>\n"
"						</xsl:when>\n"
"						<xsl:when test=\"@thickness &gt; 200\">\n"
"							<xsl:value-of select=\"200\"/>\n"
"						</xsl:when>\n"
"						<xsl:otherwise>\n"
"							<xsl:value-of select=\"@thickness\"/>\n"
"						</xsl:otherwise>\n"
"					</xsl:choose>\n"
"				</xsl:when>\n"
"				<xsl:otherwise>0</xsl:otherwise>\n"
"			</xsl:choose>\n"
"		</xsl:attribute>\n"
"		<xsl:attribute name=\"sharpness\">\n"
"			<xsl:choose>\n"
"				<xsl:when test=\"@sharpness\">\n"
"					<xsl:choose>\n"
"						<xsl:when test=\"@sharpness &lt; -400\">\n"
"							<xsl:value-of select=\"-400\"/>\n"
"						</xsl:when>\n"
"						<xsl:when test=\"@sharpness &gt; 400\">\n"
"							<xsl:value-of select=\"400\"/>\n"
"						</xsl:when>\n"
"						<xsl:otherwise>\n"
"							<xsl:value-of select=\"@sharpness\"/>\n"
"						</xsl:otherwise>\n"
"					</xsl:choose>\n"
"				</xsl:when>\n"
"				<xsl:otherwise>0</xsl:otherwise>\n"
"			</xsl:choose>\n"
"		</xsl:attribute>\n"
"	</CSMTextSettings>\n"
"</xsl:template>\n"
"<xsl:template xmlns:swft=\"http://subsignal.org/swfml/swft\" xmlns:str=\"http://exslt.org/strings\" xmlns:math=\"http://exslt.org/math\" xmlns:dc=\"http://purl.org/dc/elements/1.1/\" xmlns:rdf=\"http://www.w3.org/1999/02/22-rdf-syntax-ns#\" match=\"video\">\n"
"	<xsl:variable name=\"id\">\n"
"		<xsl:choose>\n"
"			<xsl:when test=\"@id\">\n"
"				<xsl:value-of select=\"swft:map-id(@id)\"/>\n"
"			</xsl:when>\n"
"			<xsl:otherwise>\n"
"				<xsl:value-of select=\"swft:next-id()\"/>\n"
"			</xsl:otherwise>\n"
"		</xsl:choose>\n"
"	</xsl:variable>\n"
"	<xsl:variable name=\"frames\">\n"
"		<xsl:choose>\n"
"			<xsl:when test=\"@frames\"><xsl:value-of select=\"@frames\"/></xsl:when>\n"
"			<xsl:otherwise>0</xsl:otherwise>\n"
"		</xsl:choose>\n"
"	</xsl:variable>\n"
"	<xsl:variable name=\"width\">\n"
"		<xsl:choose>\n"
"			<xsl:when test=\"@width\"><xsl:value-of select=\"@width\"/></xsl:when>\n"
"			<xsl:otherwise>160</xsl:otherwise>\n"
"		</xsl:choose>\n"
"	</xsl:variable>\n"
"	<xsl:variable name=\"height\">\n"
"		<xsl:choose>\n"
"			<xsl:when test=\"@height\"><xsl:value-of select=\"@height\"/></xsl:when>\n"
"			<xsl:otherwise>120</xsl:otherwise>\n"
"		</xsl:choose>\n"
"	</xsl:variable>\n"
"	<xsl:variable name=\"deblocking\">\n"
"		<xsl:choose>\n"
"			<xsl:when test=\"@deblocking\"><xsl:value-of select=\"@deblocking\"/></xsl:when>\n"
"			<xsl:otherwise>0</xsl:otherwise>\n"
"		</xsl:choose>\n"
"	</xsl:variable>\n"
"	<xsl:variable name=\"smoothing\">\n"
"		<xsl:choose>\n"
"			<xsl:when test=\"@smoothing\">1</xsl:when>\n"
"			<xsl:otherwise>0</xsl:otherwise>\n"
"		</xsl:choose>\n"
"	</xsl:variable>\n"
"	<xsl:variable name=\"codec\">\n"
"		<xsl:choose>\n"
"			<xsl:when test=\"@codec\"><xsl:value-of select=\"@codec\"/></xsl:when>\n"
"			<xsl:otherwise>0</xsl:otherwise>\n"
"		</xsl:choose>\n"
"	</xsl:variable>\n"
"	<DefineVideoStream objectID=\"{$id}\" frames=\"{$frames}\" width=\"{$width}\" height=\"{$height}\" deblocking=\"{$deblocking}\" smoothing=\"{$smoothing}\" codec=\"{$codec}\"/>\n"
"</xsl:template>\n"
"<xsl:template xmlns:swft=\"http://subsignal.org/swfml/swft\" xmlns:str=\"http://exslt.org/strings\" xmlns:math=\"http://exslt.org/math\" xmlns:dc=\"http://purl.org/dc/elements/1.1/\" xmlns:rdf=\"http://www.w3.org/1999/02/22-rdf-syntax-ns#\" match=\"frame\">\n"
"	<xsl:apply-templates/>\n"
"	<xsl:if test=\"@name\">\n"
"		<FrameLabel label=\"{@name}\"/>\n"
"	</xsl:if>\n"
"	<ShowFrame/>\n"
"</xsl:template>\n"
"<xsl:template xmlns:swft=\"http://subsignal.org/swfml/swft\" xmlns:str=\"http://exslt.org/strings\" xmlns:math=\"http://exslt.org/math\" xmlns:dc=\"http://purl.org/dc/elements/1.1/\" xmlns:rdf=\"http://www.w3.org/1999/02/22-rdf-syntax-ns#\" match=\"clip\" priority=\"-1\">\n"
"	<xsl:variable name=\"id\">\n"
"		<xsl:choose>\n"
"			<xsl:when test=\"@id\">\n"
"				<xsl:value-of select=\"swft:map-id(@id)\"/>\n"
"			</xsl:when>\n"
"			<xsl:otherwise>\n"
"				<xsl:value-of select=\"swft:next-id()\"/>\n"
"			</xsl:otherwise>\n"
"		</xsl:choose>\n"
"	</xsl:variable>\n"
"	<xsl:variable name=\"frames\">\n"
"		<xsl:choose>\n"
"			<xsl:when test=\"count(frame)\">\n"
"				<xsl:value-of select=\"count(frame)\"/>\n"
"			</xsl:when>\n"
"			<xsl:otherwise>1</xsl:otherwise>\n"
"        </xsl:choose>\n"
"    </xsl:variable>\n"
"	<DefineSprite objectID=\"{$id}\" frames=\"{$frames}\">\n"
"		<tags>\n"
"			<xsl:apply-templates/>\n"
"			<End/>\n"
"		</tags>\n"
"	</DefineSprite>	\n"
"	<xsl:if test=\"ancestor::library\">\n"
"		<xsl:apply-templates select=\"*|@*\" mode=\"export\">\n"
"			<xsl:with-param name=\"id\"><xsl:value-of select=\"$id\"/></xsl:with-param>\n"
"		</xsl:apply-templates>\n"
"	</xsl:if>\n"
"	<xsl:if test=\"@class\">\n"
"		<xsl:call-template name=\"register-class\">\n"
"			<xsl:with-param name=\"class\" select=\"@class\"/>\n"
"			<xsl:with-param name=\"linkage-id\" select=\"@id\"/>\n"
"		</xsl:call-template>\n"
"	</xsl:if>\n"
"</xsl:template>\n"
"<xsl:template xmlns:swft=\"http://subsignal.org/swfml/swft\" xmlns:str=\"http://exslt.org/strings\" xmlns:math=\"http://exslt.org/math\" xmlns:dc=\"http://purl.org/dc/elements/1.1/\" xmlns:rdf=\"http://www.w3.org/1999/02/22-rdf-syntax-ns#\" match=\"scale-grid\">\n"
"	<xsl:variable name=\"id\">\n"
"		<xsl:value-of select=\"swft:map-id(@id)\"/>\n"
"	</xsl:variable>\n"
"    <xsl:if test=\"number(/movie/@version) &gt;= 8\"> \n"
"		<DefineScalingGrid objectID=\"{$id}\"> <!-- FIXME ID not Id? does it matter? -->\n"
"			<splitter> \n"
"				<Rectangle left=\"{@left * 20}\" right=\"{@right * 20}\" top=\"{@top * 20}\" bottom=\"{@bottom * 20}\"/> \n"
"			</splitter> \n"
"		</DefineScalingGrid>     \n"
"	</xsl:if> \n"
"</xsl:template>\n"
"<xsl:template xmlns:swft=\"http://subsignal.org/swfml/swft\" xmlns:str=\"http://exslt.org/strings\" xmlns:math=\"http://exslt.org/math\" xmlns:dc=\"http://purl.org/dc/elements/1.1/\" xmlns:rdf=\"http://www.w3.org/1999/02/22-rdf-syntax-ns#\" match=\"stop\">\n"
"	<DoAction>\n"
"		<actions>\n"
"			<Stop/>\n"
"			<EndAction/>\n"
"		</actions>\n"
"	</DoAction>\n"
"</xsl:template>\n"
"<xsl:template xmlns:swft=\"http://subsignal.org/swfml/swft\" xmlns:str=\"http://exslt.org/strings\" xmlns:math=\"http://exslt.org/math\" xmlns:dc=\"http://purl.org/dc/elements/1.1/\" xmlns:rdf=\"http://www.w3.org/1999/02/22-rdf-syntax-ns#\" match=\"call\">\n"
"	<xsl:variable name=\"object\">\n"
"		<xsl:choose>\n"
"			<xsl:when test=\"@object\"><xsl:value-of select=\"@object\"/></xsl:when>\n"
"			<xsl:otherwise>Main</xsl:otherwise>\n"
"		</xsl:choose>\n"
"	</xsl:variable>\n"
"	<xsl:variable name=\"method\">\n"
"		<xsl:choose>\n"
"			<xsl:when test=\"@method\"><xsl:value-of select=\"@method\"/></xsl:when>\n"
"			<xsl:otherwise>main</xsl:otherwise>\n"
"		</xsl:choose>\n"
"	</xsl:variable>\n"
"	<xsl:variable name=\"spriteid\">\n"
"		<xsl:value-of select=\"swft:next-id()\"/>\n"
"	</xsl:variable>\n"
"	<DefineSprite objectID=\"{$spriteid}\" frames=\"1\">\n"
"		<tags>\n"
"			<End/>\n"
"		</tags>\n"
"	</DefineSprite>\n"
"	<Export>\n"
"		<symbols>\n"
"			<Symbol objectID=\"{$spriteid}\" name=\"__Packages.swfmill.call.{$object}.{$method}\"/>\n"
"		</symbols>\n"
"	</Export>\n"
"	<DoInitAction sprite=\"{$spriteid}\">\n"
"		<actions>\n"
"			<PushData>\n"
"				<items>\n"
"					<StackString value=\"{@object}\"/>\n"
"				</items>\n"
"			</PushData>\n"
"			<GetVariable/>\n"
"			<PushData>\n"
"				<items>\n"
"					<StackString value=\"{@method}\"/>\n"
"				</items>\n"
"			</PushData>\n"
"			<CallMethod/>\n"
"			<Pop/>\n"
"			<EndAction/>\n"
"		</actions>\n"
"	</DoInitAction>\n"
"</xsl:template>\n"
"	\n"
"<xsl:template xmlns:swft=\"http://subsignal.org/swfml/swft\" xmlns:str=\"http://exslt.org/strings\" xmlns:math=\"http://exslt.org/math\" match=\"clip[@import]|sound[@import]\">\n"
"	<xsl:variable name=\"id\">\n"
"		<xsl:choose>\n"
"			<xsl:when test=\"@id\">\n"
"				<xsl:value-of select=\"swft:map-id(@id)\"/>\n"
"			</xsl:when>\n"
"			<xsl:otherwise>\n"
"				<xsl:value-of select=\"swft:next-id()\"/>\n"
"			</xsl:otherwise>\n"
"		</xsl:choose>\n"
"	</xsl:variable>\n"
"	<xsl:variable name=\"file\">\n"
"		<xsl:value-of select=\"@import\"/>\n"
"	</xsl:variable>\n"
"	<xsl:variable name=\"mask\">\n"
"		<xsl:value-of select=\"@mask\"/>\n"
"	</xsl:variable>\n"
"	<xsl:variable name=\"ext\">\n"
"		<xsl:value-of select=\"translate(substring(@import,string-length(@import)-2),'ABCDEFGHIJKLMNOPQRSTUVWXYZ','abcdefghijklmnopqrstuvwxyz')\"/>\n"
"	</xsl:variable>\n"
"	<xsl:choose>\n"
"		<xsl:when test=\"@mask\">\n"
"			<xsl:apply-templates select=\"swft:import-jpega($file,$mask)\" mode=\"makeswf\">\n"
"				<xsl:with-param name=\"id\"><xsl:value-of select=\"$id\"/></xsl:with-param>\n"
"			</xsl:apply-templates>\n"
"		</xsl:when>\n"
"		<xsl:when test=\"$ext = 'jpg' or $ext = 'peg'\">\n"
"			<xsl:apply-templates select=\"swft:import-jpeg($file)\" mode=\"makeswf\">\n"
"				<xsl:with-param name=\"id\"><xsl:value-of select=\"$id\"/></xsl:with-param>\n"
"			</xsl:apply-templates>\n"
"		</xsl:when>\n"
"		<xsl:when test=\"$ext = 'png'\">\n"
"			<xsl:apply-templates select=\"swft:import-png($file)\" mode=\"makeswf\">\n"
"				<xsl:with-param name=\"id\"><xsl:value-of select=\"$id\"/></xsl:with-param>\n"
"			</xsl:apply-templates>\n"
"		</xsl:when>\n"
"		<xsl:when test=\"$ext = 'swf'\">\n"
"			<xsl:apply-templates select=\"swft:document($file)\" mode=\"makeswf\">\n"
"				<xsl:with-param name=\"id\"><xsl:value-of select=\"$id\"/></xsl:with-param>\n"
"			</xsl:apply-templates>\n"
"		</xsl:when>\n"
"		<!-- this is stupid, shouldnt be used.\n"
"		<xsl:when test=\"$ext = 'ttf'\">\n"
"			<xsl:apply-templates select=\"swft:import-ttf($file,@glyphs,'hello')\" mode=\"makeswf\">\n"
"				<xsl:with-param name=\"id\"><xsl:value-of select=\"$id\"/></xsl:with-param>\n"
"			</xsl:apply-templates>\n"
"		</xsl:when>\n"
"		-->\n"
"		<xsl:when test=\"$ext = 'svg'\">\n"
"			<swft:push-map/>\n"
"			<xsl:apply-templates select=\"document($file)\" mode=\"svg\">\n"
"				<xsl:with-param name=\"id\"><xsl:value-of select=\"$id\"/></xsl:with-param>\n"
"				<xsl:with-param name=\"export\">\n"
"					<xsl:choose>\n"
"						<xsl:when test=\"@export\"><xsl:value-of select=\"@export\"/></xsl:when>\n"
"						<xsl:otherwise>all</xsl:otherwise>\n"
"					</xsl:choose>\n"
"				</xsl:with-param>\n"
"			</xsl:apply-templates>\n"
"			<swft:pop-map/>\n"
"		</xsl:when>\n"
"		<xsl:when test=\"$ext = 'mp3'\">\n"
"			<xsl:apply-templates select=\"swft:import-mp3($file)\" mode=\"makeswf\">\n"
"				<xsl:with-param name=\"id\"><xsl:value-of select=\"$id\"/></xsl:with-param>\n"
"			</xsl:apply-templates>\n"
"		</xsl:when>\n"
"		<xsl:when test=\"$ext = 'wav'\">\n"
"			<xsl:apply-templates select=\"swft:import-wav($file)\" mode=\"makeswf\">\n"
"				<xsl:with-param name=\"id\"><xsl:value-of select=\"$id\"/></xsl:with-param>\n"
"			</xsl:apply-templates>\n"
"		</xsl:when>\n"
"		<xsl:otherwise>\n"
"			<xsl:message>WARNING: Cannot import <xsl:value-of select=\"$file\"/> (unknown extension), skipping.</xsl:message>\n"
"		</xsl:otherwise>\n"
"	</xsl:choose>\n"
"	<xsl:if test=\"ancestor::library\">\n"
"		<xsl:apply-templates select=\"*|@*\" mode=\"export\">\n"
"			<xsl:with-param name=\"id\"><xsl:value-of select=\"$id\"/></xsl:with-param>\n"
"		</xsl:apply-templates>\n"
"	</xsl:if>\n"
"	<xsl:if test=\"@class\">\n"
"		<xsl:call-template name=\"register-class\">\n"
"			<xsl:with-param name=\"class\" select=\"@class\"/>\n"
"			<xsl:with-param name=\"linkage-id\" select=\"@id\"/>\n"
"		</xsl:call-template>\n"
"	</xsl:if>\n"
"</xsl:template>\n"
"<xsl:template xmlns:swft=\"http://subsignal.org/swfml/swft\" xmlns:str=\"http://exslt.org/strings\" xmlns:math=\"http://exslt.org/math\" match=\"bitmap[@import]\">\n"
"	<xsl:variable name=\"id\">\n"
"		<xsl:choose>\n"
"			<xsl:when test=\"@id\">\n"
"				<xsl:value-of select=\"swft:map-id(@id)\"/>\n"
"			</xsl:when>\n"
"			<xsl:otherwise>\n"
"				<xsl:value-of select=\"swft:next-id()\"/>\n"
"			</xsl:otherwise>\n"
"		</xsl:choose>\n"
"	</xsl:variable>\n"
"	<xsl:variable name=\"file\">\n"
"		<xsl:value-of select=\"@import\"/>\n"
"	</xsl:variable>\n"
"	<xsl:variable name=\"mask\">\n"
"		<xsl:value-of select=\"@mask\"/>\n"
"	</xsl:variable>\n"
"	<xsl:variable name=\"ext\">\n"
"		<xsl:value-of select=\"translate(substring(@import,string-length(@import)-2),'ABCDEFGHIJKLMNOPQRSTUVWXYZ','abcdefghijklmnopqrstuvwxyz')\"/>\n"
"	</xsl:variable>\n"
"	<xsl:choose>\n"
"		<xsl:when test=\"@mask\">\n"
"			<xsl:apply-templates select=\"swft:import-jpega($file,$mask)\" mode=\"bitmap\">\n"
"				<xsl:with-param name=\"id\"><xsl:value-of select=\"$id\"/></xsl:with-param>\n"
"			</xsl:apply-templates>\n"
"		</xsl:when>\n"
"		<xsl:when test=\"$ext = 'jpg' or $ext = 'peg'\">\n"
"			<xsl:apply-templates select=\"swft:import-jpeg($file)\" mode=\"bitmap\">\n"
"				<xsl:with-param name=\"id\"><xsl:value-of select=\"$id\"/></xsl:with-param>\n"
"			</xsl:apply-templates>\n"
"		</xsl:when>\n"
"		<xsl:when test=\"$ext = 'png'\">\n"
"			<xsl:apply-templates select=\"swft:import-png($file)\" mode=\"bitmap\">\n"
"				<xsl:with-param name=\"id\"><xsl:value-of select=\"$id\"/></xsl:with-param>\n"
"			</xsl:apply-templates>\n"
"		</xsl:when>\n"
"		<xsl:otherwise>\n"
"			<xsl:message>WARNING: Cannot import <xsl:value-of select=\"$file\"/> (unknown extension), skipping.</xsl:message>\n"
"		</xsl:otherwise>\n"
"	</xsl:choose>\n"
"	<xsl:if test=\"ancestor::library\">\n"
"		<xsl:apply-templates select=\"*|@*\" mode=\"export\">\n"
"			<xsl:with-param name=\"id\"><xsl:value-of select=\"$id\"/></xsl:with-param>\n"
"		</xsl:apply-templates>\n"
"	</xsl:if>\n"
"</xsl:template>\n"
"<xsl:template xmlns:swft=\"http://subsignal.org/swfml/swft\" xmlns:str=\"http://exslt.org/strings\" xmlns:math=\"http://exslt.org/math\" match=\"font[@import]\">\n"
"	<xsl:variable name=\"id\">\n"
"		<xsl:choose>\n"
"			<xsl:when test=\"@id\">\n"
"				<xsl:value-of select=\"swft:map-id(@id)\"/>\n"
"			</xsl:when>\n"
"			<xsl:otherwise>\n"
"				<xsl:value-of select=\"swft:next-id()\"/>\n"
"			</xsl:otherwise>\n"
"		</xsl:choose>\n"
"	</xsl:variable>\n"
"	<xsl:variable name=\"file\">\n"
"		<xsl:value-of select=\"@import\"/>\n"
"	</xsl:variable>\n"
"	<xsl:variable name=\"offset\">\n"
"		<xsl:choose>\n"
"			<xsl:when test=\"@symbol='true'\">\n"
"				<xsl:value-of select=\"-61440\"/>\n"
"			</xsl:when>\n"
"			<xsl:otherwise>\n"
"				<xsl:value-of select=\"0\"/>\n"
"			</xsl:otherwise>\n"
"		</xsl:choose>\n"
"	</xsl:variable>\n"
"\n"
"	<xsl:apply-templates select=\"swft:import-ttf($file,$movie-version,@glyphs,@name,$offset)\" mode=\"makeswf\">\n"
"		<xsl:with-param name=\"id\"><xsl:value-of select=\"$id\"/></xsl:with-param>\n"
"	</xsl:apply-templates>\n"
"\n"
"	<xsl:if test=\"ancestor::library\">\n"
"		<xsl:apply-templates select=\"*|@*\" mode=\"export\">\n"
"			<xsl:with-param name=\"id\"><xsl:value-of select=\"$id\"/></xsl:with-param>\n"
"		</xsl:apply-templates>\n"
"	</xsl:if>\n"
"</xsl:template>\n"
"<xsl:template xmlns:swft=\"http://subsignal.org/swfml/swft\" xmlns:str=\"http://exslt.org/strings\" xmlns:math=\"http://exslt.org/math\" match=\"binary[@import]\">\n"
"	<xsl:variable name=\"id\">\n"
"		<xsl:choose>\n"
"			<xsl:when test=\"@id\">\n"
"				<xsl:value-of select=\"swft:map-id(@id)\"/>\n"
"			</xsl:when>\n"
"			<xsl:otherwise>\n"
"				<xsl:value-of select=\"swft:next-id()\"/>\n"
"			</xsl:otherwise>\n"
"		</xsl:choose>\n"
"	</xsl:variable>\n"
"	<xsl:variable name=\"file\">\n"
"		<xsl:value-of select=\"@import\"/>\n"
"	</xsl:variable>\n"
"	\n"
"	<xsl:apply-templates select=\"swft:import-binary($file)\" mode=\"makeswf\">\n"
"		<xsl:with-param name=\"id\"><xsl:value-of select=\"$id\"/></xsl:with-param>\n"
"	</xsl:apply-templates>\n"
"\n"
"	<xsl:if test=\"ancestor::library\">\n"
"		<xsl:apply-templates select=\"*|@*\" mode=\"export\">\n"
"			<xsl:with-param name=\"id\"><xsl:value-of select=\"$id\"/></xsl:with-param>\n"
"		</xsl:apply-templates>\n"
"	</xsl:if>\n"
"</xsl:template>\n"
"<xsl:template xmlns:swft=\"http://subsignal.org/swfml/swft\" xmlns:str=\"http://exslt.org/strings\" xmlns:math=\"http://exslt.org/math\" match=\"font\" priority=\"-1\">\n"
"	<xsl:variable name=\"id\">\n"
"		<xsl:choose>\n"
"			<xsl:when test=\"@id\">\n"
"				<xsl:value-of select=\"swft:map-id(@id)\"/>\n"
"			</xsl:when>\n"
"			<xsl:otherwise>\n"
"				<xsl:value-of select=\"swft:next-id()\"/>\n"
"			</xsl:otherwise>\n"
"		</xsl:choose>\n"
"	</xsl:variable>\n"
"	<DefineFont2 objectID=\"{$id}\" isShiftJIS=\"0\" isUnicode=\"0\" isANSII=\"0\" wideGlyphOffsets=\"0\" italic=\"0\" bold=\"0\" language=\"1\" name=\"{@name}\">\n"
"	</DefineFont2>\n"
"</xsl:template>\n"
"<xsl:template xmlns:swft=\"http://subsignal.org/swfml/swft\" xmlns:str=\"http://exslt.org/strings\" xmlns:math=\"http://exslt.org/math\" match=\"jpeg\" mode=\"makeswf\">\n"
"	<xsl:param name=\"id\"/>\n"
"	<xsl:variable name=\"bitmapID\"><xsl:value-of select=\"swft:next-id()\"/></xsl:variable> \n"
"	<xsl:variable name=\"shapeID\"><xsl:value-of select=\"swft:next-id()\"/></xsl:variable> \n"
"	<DefineBitsJPEG2 objectID=\"{$bitmapID}\">\n"
"		<data>\n"
"			<xsl:copy-of select=\"data\"/>\n"
"		</data>\n"
"	</DefineBitsJPEG2>\n"
"	<DefineShape objectID=\"{$shapeID}\">\n"
"		<bounds>\n"
"			<Rectangle left=\"0\" right=\"{@width}\" top=\"0\" bottom=\"{@height}\"/>\n"
"		</bounds>\n"
"		<styles>\n"
"			<StyleList>\n"
"				<fillStyles>\n"
"					<ClippedBitmap objectID=\"{$bitmapID}\">\n"
"						<matrix>\n"
"							<Transform transX=\"0\" transY=\"0\"/>\n"
"						</matrix>\n"
"					</ClippedBitmap>\n"
"				</fillStyles>\n"
"				<lineStyles/>\n"
"			</StyleList>\n"
"		</styles>\n"
"		<shapes>\n"
"			<Shape>\n"
"				<edges>\n"
"					<ShapeSetup x=\"{@width}\" y=\"{@height}\" fillStyle1=\"1\"/>\n"
"					<LineTo x=\"-{@width}\" y=\"0\"/>\n"
"					<LineTo x=\"0\" y=\"-{@height}\"/>\n"
"					<LineTo x=\"{@width}\" y=\"0\"/>\n"
"					<LineTo x=\"0\" y=\"{@height}\"/>\n"
"					<ShapeSetup/>\n"
"				</edges>\n"
"			</Shape>\n"
"		</shapes>\n"
"	</DefineShape>\n"
"	<DefineSprite objectID=\"{$id}\" frames=\"1\">\n"
"		<tags>\n"
"			<PlaceObject2 replace=\"0\" depth=\"1\" objectID=\"{$shapeID}\">\n"
"				<transform>\n"
"					<Transform transX=\"0\" transY=\"0\" scaleX=\"20\" scaleY=\"20\"/>\n"
"				</transform>\n"
"			</PlaceObject2>\n"
"			<ShowFrame/>\n"
"			<End/>\n"
"		</tags>\n"
"	</DefineSprite>\n"
"</xsl:template>\n"
"<xsl:template xmlns:swft=\"http://subsignal.org/swfml/swft\" xmlns:str=\"http://exslt.org/strings\" xmlns:math=\"http://exslt.org/math\" match=\"jpega\" mode=\"makeswf\">\n"
"	<xsl:param name=\"id\"/>\n"
"	<xsl:variable name=\"bitmapID\"><xsl:value-of select=\"swft:next-id()\"/></xsl:variable> \n"
"	<xsl:variable name=\"shapeID\"><xsl:value-of select=\"swft:next-id()\"/></xsl:variable> \n"
"	<DefineBitsJPEG3 objectID=\"{$bitmapID}\" offset_to_alpha=\"{@offset_to_alpha}\">\n"
"		<data>\n"
"			<xsl:copy-of select=\"data\"/>\n"
"		</data>\n"
"	</DefineBitsJPEG3>\n"
"	<DefineShape objectID=\"{$shapeID}\">\n"
"		<bounds>\n"
"			<Rectangle left=\"0\" right=\"{@width}\" top=\"0\" bottom=\"{@height}\"/>\n"
"		</bounds>\n"
"		<styles>\n"
"			<StyleList>\n"
"				<fillStyles>\n"
"					<ClippedBitmap objectID=\"{$bitmapID}\">\n"
"						<matrix>\n"
"							<Transform transX=\"0\" transY=\"0\"/>\n"
"						</matrix>\n"
"					</ClippedBitmap>\n"
"				</fillStyles>\n"
"				<lineStyles/>\n"
"			</StyleList>\n"
"		</styles>\n"
"		<shapes>\n"
"			<Shape>\n"
"				<edges>\n"
"					<ShapeSetup x=\"{@width}\" y=\"{@height}\" fillStyle1=\"1\"/>\n"
"					<LineTo x=\"-{@width}\" y=\"0\"/>\n"
"					<LineTo x=\"0\" y=\"-{@height}\"/>\n"
"					<LineTo x=\"{@width}\" y=\"0\"/>\n"
"					<LineTo x=\"0\" y=\"{@height}\"/>\n"
"					<ShapeSetup/>\n"
"				</edges>\n"
"			</Shape>\n"
"		</shapes>\n"
"	</DefineShape>\n"
"	<DefineSprite objectID=\"{$id}\" frames=\"1\">\n"
"		<tags>\n"
"			<PlaceObject2 replace=\"0\" depth=\"1\" objectID=\"{$shapeID}\">\n"
"				<transform>\n"
"					<Transform transX=\"0\" transY=\"0\" scaleX=\"20\" scaleY=\"20\"/>\n"
"				</transform>\n"
"			</PlaceObject2>\n"
"			<ShowFrame/>\n"
"			<End/>\n"
"		</tags>\n"
"	</DefineSprite>\n"
"</xsl:template>\n"
"<xsl:template xmlns:swft=\"http://subsignal.org/swfml/swft\" xmlns:str=\"http://exslt.org/strings\" xmlns:math=\"http://exslt.org/math\" match=\"png\" mode=\"makeswf\">\n"
"	<xsl:param name=\"id\"/>\n"
"	<xsl:variable name=\"bitmapID\"><xsl:value-of select=\"swft:next-id()\"/></xsl:variable> \n"
"	<xsl:variable name=\"shapeID\"><xsl:value-of select=\"swft:next-id()\"/></xsl:variable> \n"
"	<DefineBitsLossless2 format=\"{@format}\" width=\"{@width}\" height=\"{@height}\" n_colormap=\"{@n_colormap}\" objectID=\"{$bitmapID}\">\n"
"		<data>\n"
"			<xsl:copy-of select=\"data\"/>\n"
"		</data>\n"
"	</DefineBitsLossless2>\n"
"	<DefineShape objectID=\"{$shapeID}\">\n"
"		<bounds>\n"
"			<Rectangle left=\"0\" right=\"{@width}\" top=\"0\" bottom=\"{@height}\"/>\n"
"		</bounds>\n"
"		<styles>\n"
"			<StyleList>\n"
"				<fillStyles>\n"
"					<ClippedBitmap objectID=\"{$bitmapID}\">\n"
"						<matrix>\n"
"							<Transform transX=\"0\" transY=\"0\"/>\n"
"						</matrix>\n"
"					</ClippedBitmap>\n"
"				</fillStyles>\n"
"				<lineStyles/>\n"
"			</StyleList>\n"
"		</styles>\n"
"		<shapes>\n"
"			<Shape>\n"
"				<edges>\n"
"					<ShapeSetup x=\"{@width}\" y=\"{@height}\" fillStyle1=\"1\"/>\n"
"					<LineTo x=\"-{@width}\" y=\"0\"/>\n"
"					<LineTo x=\"0\" y=\"-{@height}\"/>\n"
"					<LineTo x=\"{@width}\" y=\"0\"/>\n"
"					<LineTo x=\"0\" y=\"{@height}\"/>\n"
"					<ShapeSetup/>\n"
"				</edges>\n"
"			</Shape>\n"
"		</shapes>\n"
"	</DefineShape>\n"
"	<DefineSprite objectID=\"{$id}\" frames=\"1\">\n"
"		<tags>\n"
"			<PlaceObject2 replace=\"0\" depth=\"1\" objectID=\"{$shapeID}\">\n"
"				<transform>\n"
"					<Transform transX=\"0\" transY=\"0\" scaleX=\"20\" scaleY=\"20\"/>\n"
"				</transform>\n"
"			</PlaceObject2>\n"
"			<ShowFrame/>\n"
"			<End/>\n"
"		</tags>\n"
"	</DefineSprite>\n"
"</xsl:template>\n"
"<xsl:template xmlns:swft=\"http://subsignal.org/swfml/swft\" xmlns:str=\"http://exslt.org/strings\" xmlns:math=\"http://exslt.org/math\" match=\"jpeg\" mode=\"bitmap\">\n"
"	<xsl:param name=\"id\"/>\n"
"	<DefineBitsJPEG2 objectID=\"{$id}\">\n"
"		<data>\n"
"			<xsl:copy-of select=\"data\"/>\n"
"		</data>\n"
"	</DefineBitsJPEG2>\n"
"</xsl:template>\n"
"<xsl:template xmlns:swft=\"http://subsignal.org/swfml/swft\" xmlns:str=\"http://exslt.org/strings\" xmlns:math=\"http://exslt.org/math\" match=\"jpega\" mode=\"bitmap\">\n"
"	<xsl:param name=\"id\"/>\n"
"	<DefineBitsJPEG3 objectID=\"{$id}\" offset_to_alpha=\"{@offset_to_alpha}\">\n"
"		<data>\n"
"			<xsl:copy-of select=\"data\"/>\n"
"		</data>\n"
"	</DefineBitsJPEG3>\n"
"</xsl:template>\n"
"<xsl:template xmlns:swft=\"http://subsignal.org/swfml/swft\" xmlns:str=\"http://exslt.org/strings\" xmlns:math=\"http://exslt.org/math\" match=\"png\" mode=\"bitmap\">\n"
"	<xsl:param name=\"id\"/>\n"
"	<DefineBitsLossless2 format=\"{@format}\" width=\"{@width}\" height=\"{@height}\" n_colormap=\"{@n_colormap}\" objectID=\"{$id}\">\n"
"		<data>\n"
"			<xsl:copy-of select=\"data\"/>\n"
"		</data>\n"
"	</DefineBitsLossless2>\n"
"</xsl:template>\n"
"<xsl:template xmlns:swft=\"http://subsignal.org/swfml/swft\" xmlns:str=\"http://exslt.org/strings\" xmlns:math=\"http://exslt.org/math\" match=\"swf\" mode=\"makeswf\">\n"
"	<xsl:param name=\"id\"/>\n"
"	<swft:push-map/>\n"
"\n"
"	<xsl:apply-templates select=\"Header/tags/*\" mode=\"sprite-global\"/>\n"
"	\n"
"	<DefineSprite objectID=\"{$id}\" frames=\"{count(Header/tags/ShowFrame)}\">\n"
"		<tags>\n"
"			<xsl:apply-templates select=\"Header/tags/*\" mode=\"sprite-local\"/>\n"
"		</tags>\n"
"	</DefineSprite>\n"
"	<swft:pop-map/>\n"
"</xsl:template>\n"
"<xsl:template xmlns:swft=\"http://subsignal.org/swfml/swft\" xmlns:str=\"http://exslt.org/strings\" xmlns:math=\"http://exslt.org/math\" match=\"binary\" mode=\"makeswf\">\n"
"	<xsl:param name=\"id\"/>\n"
"	<DefineBinaryData objectID=\"{$id}\">\n"
"		<data>\n"
"			<xsl:copy-of select=\"data\"/>\n"
"		</data>\n"
"	</DefineBinaryData>\n"
"</xsl:template>\n"
"<xsl:template xmlns:swft=\"http://subsignal.org/swfml/swft\" xmlns:str=\"http://exslt.org/strings\" xmlns:math=\"http://exslt.org/math\" match=\"@objectID|@fontRef|@sprite\" mode=\"idmap\">\n"
"	<xsl:attribute name=\"{name()}\"><xsl:value-of select=\"swft:map-id(.)\"/></xsl:attribute>\n"
"</xsl:template>\n"
"<xsl:template xmlns:swft=\"http://subsignal.org/swfml/swft\" xmlns:str=\"http://exslt.org/strings\" xmlns:math=\"http://exslt.org/math\" match=\"text()\" mode=\"idmap\" priority=\"-1\">\n"
"	<xsl:copy select=\".\"/>\n"
"</xsl:template>\n"
"<xsl:template xmlns:swft=\"http://subsignal.org/swfml/swft\" xmlns:str=\"http://exslt.org/strings\" xmlns:math=\"http://exslt.org/math\" match=\"@*\" mode=\"idmap\" priority=\"-1\">\n"
"	<xsl:copy select=\".\"/>\n"
"</xsl:template>\n"
"<xsl:template xmlns:swft=\"http://subsignal.org/swfml/swft\" xmlns:str=\"http://exslt.org/strings\" xmlns:math=\"http://exslt.org/math\" match=\"*\" mode=\"idmap\" priority=\"-1\">\n"
"	<xsl:copy select=\".\">\n"
"		<xsl:apply-templates select=\"@*\" mode=\"idmap\"/>\n"
"		<xsl:apply-templates mode=\"idmap\"/>\n"
"	</xsl:copy>\n"
"</xsl:template>\n"
"<xsl:template xmlns:swft=\"http://subsignal.org/swfml/swft\" xmlns:str=\"http://exslt.org/strings\" xmlns:math=\"http://exslt.org/math\" match=\"SetBackgroundColor|FileAttributes\" mode=\"sprite-global\"/>\n"
"<xsl:template xmlns:swft=\"http://subsignal.org/swfml/swft\" xmlns:str=\"http://exslt.org/strings\" xmlns:math=\"http://exslt.org/math\" match=\"DoAction|End|FrameLabel|PlaceObject|PlaceObject2|RemoveObject|RemoveObject2|ShowFrame|SoundStreamBlock|SoundStreamHead|StartSound\" mode=\"sprite-global\"/>\n"
"<xsl:template xmlns:swft=\"http://subsignal.org/swfml/swft\" xmlns:str=\"http://exslt.org/strings\" xmlns:math=\"http://exslt.org/math\" match=\"*|@*|text()\" mode=\"sprite-global\" priority=\"-1\">\n"
"	<xsl:apply-templates select=\".\" mode=\"idmap\"/>\n"
"</xsl:template>\n"
"<xsl:template xmlns:swft=\"http://subsignal.org/swfml/swft\" xmlns:str=\"http://exslt.org/strings\" xmlns:math=\"http://exslt.org/math\" match=\"DoAction|End|FrameLabel|PlaceObject|PlaceObject2|RemoveObject|RemoveObject2|ShowFrame|SoundStreamBlock|SoundStreamHead|StartSound\" mode=\"sprite-local\">\n"
"	<xsl:apply-templates select=\".\" mode=\"idmap\"/>\n"
"</xsl:template>\n"
"<xsl:template xmlns:swft=\"http://subsignal.org/swfml/swft\" xmlns:str=\"http://exslt.org/strings\" xmlns:math=\"http://exslt.org/math\" match=\"*|@*|text()\" mode=\"sprite-local\" priority=\"-1\"/>\n"
"<xsl:template xmlns:swft=\"http://subsignal.org/swfml/swft\" xmlns:str=\"http://exslt.org/strings\" xmlns:math=\"http://exslt.org/math\" match=\"component\">\n"
"	\n"
"	<xsl:variable name=\"name\" select=\"@id\"/>\n"
"	<xsl:variable name=\"component\" select=\"swft:document(@file)\"/>\n"
"\n"
"	<swft:push-map/>\n"
"		<xsl:apply-templates select=\"$component/swf/Header/tags/*\" mode=\"component\"/>\n"
"		<xsl:variable name=\"id\" select=\"swft:map-id($component/swf/Header/tags/Export/symbols/Symbol[@name = $name]/@objectID)\"/>\n"
"	<swft:pop-map/>\n"
"\n"
"	<xsl:value-of select=\"swft:set-map($name,$id)\"/>\n"
"	<xsl:message>New ID of \"<xsl:value-of select=\"$name\"/>\" component is: <xsl:value-of select=\"$id\"/></xsl:message>\n"
"\n"
"</xsl:template>\n"
"<xsl:template xmlns:swft=\"http://subsignal.org/swfml/swft\" xmlns:str=\"http://exslt.org/strings\" xmlns:math=\"http://exslt.org/math\" match=\"PlaceObject2|ShowFrame|End\" mode=\"component\"/>\n"
"<xsl:template xmlns:swft=\"http://subsignal.org/swfml/swft\" xmlns:str=\"http://exslt.org/strings\" xmlns:math=\"http://exslt.org/math\" match=\"*\" mode=\"component\" priority=\"-1\">\n"
"	<xsl:apply-templates select=\".\" mode=\"idmap\"/>\n"
"</xsl:template>\n"
"<xsl:template xmlns:swft=\"http://subsignal.org/swfml/swft\" xmlns:str=\"http://exslt.org/strings\" xmlns:math=\"http://exslt.org/math\" match=\"import\">\n"
"	<xsl:choose>\n"
"		<xsl:when test=\"number(/movie/@version) &gt;= 8\">\n"
"			<ImportAssets2 url=\"{@url}\" reserved1=\"1\" reserved2=\"0\">\n"
"				<symbols>\n"
"					<xsl:if test=\"@symbol\">\n"
"						<Symbol objectID=\"{swft:map-id(@symbol)}\" name=\"{@symbol}\"/>\n"
"					</xsl:if>	\n"
"					<xsl:if test=\"@file\">\n"
"						<xsl:apply-templates select=\"swft:document(@file)/swf/Header/tags/Export/symbols/*\" mode=\"import\"/>\n"
"					</xsl:if>\n"
"				</symbols>\n"
"			</ImportAssets2>\n"
"		</xsl:when>\n"
"		<xsl:otherwise>\n"
"			<Import url=\"{@url}\">\n"
"				<symbols>\n"
"					<xsl:if test=\"@symbol\">\n"
"						<Symbol objectID=\"{swft:map-id(@symbol)}\" name=\"{@symbol}\"/>\n"
"					</xsl:if>	\n"
"					<xsl:if test=\"@file\">\n"
"						<xsl:apply-templates select=\"swft:document(@file)/swf/Header/tags/Export/symbols/*\" mode=\"import\"/>\n"
"					</xsl:if>\n"
"				</symbols>\n"
"			</Import>\n"
"		</xsl:otherwise>\n"
"	</xsl:choose>\n"
"</xsl:template>\n"
"<xsl:template xmlns:swft=\"http://subsignal.org/swfml/swft\" xmlns:str=\"http://exslt.org/strings\" xmlns:math=\"http://exslt.org/math\" match=\"Symbol\" mode=\"import\">\n"
"	<Symbol objectID=\"{swft:map-id(@name)}\" name=\"{@name}\"/>\n"
"</xsl:template>\n"
"<xsl:template xmlns:swft=\"http://subsignal.org/swfml/swft\" xmlns:str=\"http://exslt.org/strings\" xmlns:math=\"http://exslt.org/math\" match=\"ttf\" mode=\"makeswf\">\n"
"	<xsl:param name=\"id\"/>\n"
"	<xsl:choose>\n"
"		<xsl:when test=\"$movie-version &gt;= 8\">\n"
"			<DefineFont3 objectID=\"{$id}\">\n"
"				<xsl:copy-of select=\"DefineFont3/*|DefineFont3/@*[name() != 'objectID']\"/>\n"
"			</DefineFont3>\n"
"		</xsl:when>\n"
"		<xsl:otherwise>\n"
"			<DefineFont2 objectID=\"{$id}\">\n"
"				<xsl:copy-of select=\"DefineFont2/*|DefineFont2/@*[name() != 'objectID']\"/>\n"
"			</DefineFont2>\n"
"		</xsl:otherwise>\n"
"	</xsl:choose>\n"
"</xsl:template>\n"
"<xsl:template xmlns:swft=\"http://subsignal.org/swfml/swft\" xmlns:str=\"http://exslt.org/strings\" xmlns:math=\"http://exslt.org/math\" match=\"mp3\" mode=\"makeswf\">\n"
"	<xsl:param name=\"id\"/>\n"
"	<DefineSound objectID=\"{$id}\" format=\"{@format}\" rate=\"{@rate}\" is16bit=\"{@is16bit}\" stereo=\"{@stereo}\" samples=\"{@samples}\">\n"
"		<data>\n"
"			<xsl:copy-of select=\"data\"/>\n"
"		</data>\n"
"	</DefineSound>\n"
"</xsl:template>\n"
"<xsl:template xmlns:swft=\"http://subsignal.org/swfml/swft\" xmlns:str=\"http://exslt.org/strings\" xmlns:math=\"http://exslt.org/math\" match=\"wav\" mode=\"makeswf\">\n"
"	<xsl:param name=\"id\"/>\n"
"	<DefineSound objectID=\"{$id}\" format=\"{@format}\" rate=\"{@rate}\" is16bit=\"{@is16bit}\" stereo=\"{@stereo}\" samples=\"{@samples}\">\n"
"		<data>\n"
"			<xsl:copy-of select=\"data\"/>\n"
"		</data>\n"
"	</DefineSound>\n"
"</xsl:template>\n"
"<xsl:template xmlns:swft=\"http://subsignal.org/swfml/swft\" xmlns:str=\"http://exslt.org/strings\" xmlns:math=\"http://exslt.org/math\" match=\"include[@file]\">\n"
"	<xsl:apply-templates select=\"document(@file)/movie/*\"/>	\n"
"</xsl:template>\n"
"	\n"
"<xsl:template xmlns:inkscape=\"http://www.inkscape.org/namespaces/inkscape\" xmlns:sodipodi=\"http://inkscape.sourceforge.net/DTD/sodipodi-0.dtd\" xmlns:svg=\"http://www.w3.org/2000/svg\" xmlns:swft=\"http://subsignal.org/swfml/swft\" xmlns:str=\"http://exslt.org/strings\" xmlns:xlink=\"http://www.w3.org/1999/xlink\" name=\"transform\">\n"
"	<transform>\n"
"		<xsl:choose>\n"
"			<!-- catch empty transform attributes. -->\n"
"			<xsl:when test=\"not(@transform) or @transform=''\">\n"
"				<Transform transX=\"0\" transY=\"0\"/>\n"
"			</xsl:when>\n"
"			<xsl:otherwise>\n"
"				<xsl:copy-of select=\"swft:transform(@transform)\"/>\n"
"			</xsl:otherwise>\n"
"		</xsl:choose>\n"
"	</transform>\n"
"</xsl:template>\n"
"<xsl:template xmlns:inkscape=\"http://www.inkscape.org/namespaces/inkscape\" xmlns:sodipodi=\"http://inkscape.sourceforge.net/DTD/sodipodi-0.dtd\" xmlns:svg=\"http://www.w3.org/2000/svg\" xmlns:swft=\"http://subsignal.org/swfml/swft\" xmlns:str=\"http://exslt.org/strings\" xmlns:xlink=\"http://www.w3.org/1999/xlink\" name=\"placeObject\">\n"
"	<!-- place the element, or the referenced element (if it's a reference). \n"
"-->\n"
"	<xsl:variable name=\"id\">\n"
"		<xsl:choose>\n"
"			<xsl:when test=\"name()='use'\">\n"
"				<xsl:value-of select=\"swft:map-id(substring(@xlink:href,2))\"/>\n"
"			</xsl:when>\n"
"			<xsl:when test=\"@id\">\n"
"				<xsl:value-of select=\"swft:map-id(@id)\"/>\n"
"			</xsl:when>\n"
"			<xsl:otherwise>\n"
"				<xsl:value-of select=\"swft:map-id(generate-id(.))\"/>\n"
"			</xsl:otherwise>\n"
"		</xsl:choose>\n"
"	</xsl:variable>\n"
"	<!-- use inkscape label as an instance name instead of id, allowing \n"
"multiple instances with the same name. -->\n"
"	<xsl:variable name=\"name\">\n"
"		<xsl:choose>\n"
"			<xsl:when test=\"@inkscape:label\">\n"
"				<xsl:choose>\n"
"					<xsl:when test=\"substring(@inkscape:label,1,1)='#'\">\n"
"						<xsl:value-of select=\"substring(@inkscape:label,2)\"/>\n"
"					</xsl:when>\n"
"					<xsl:otherwise>\n"
"						<xsl:value-of select=\"@inkscape:label\"/>\n"
"					</xsl:otherwise>\n"
"				</xsl:choose>\n"
"			</xsl:when>\n"
"			<xsl:when test=\"@id\">\n"
"				<xsl:value-of select=\"@id\"/>\n"
"			</xsl:when>\n"
"			<xsl:otherwise>\n"
"				<xsl:value-of select=\"generate-id(.)\"/>\n"
"			</xsl:otherwise>\n"
"		</xsl:choose>\n"
"	</xsl:variable>\n"
"	<!-- place the object. -->\n"
"	<PlaceObject2 replace=\"0\" depth=\"{swft:next-depth()}\" name=\"{$name}\" objectID=\"{$id}\">\n"
"		<!-- svg:use elements add an instance transform, all others have it \n"
"included in their definition. -->\n"
"		<xsl:choose>\n"
"			<xsl:when test=\"name()='use'\">\n"
"				<xsl:call-template name=\"transform\"/>\n"
"			</xsl:when>\n"
"			<xsl:otherwise>\n"
"				<transform>\n"
"					<Transform transX=\"0\" transY=\"0\"/>\n"
"				</transform>\n"
"			</xsl:otherwise>\n"
"		</xsl:choose>\n"
"	</PlaceObject2>\n"
"</xsl:template>\n"
"<xsl:template xmlns:inkscape=\"http://www.inkscape.org/namespaces/inkscape\" xmlns:sodipodi=\"http://inkscape.sourceforge.net/DTD/sodipodi-0.dtd\" xmlns:svg=\"http://www.w3.org/2000/svg\" xmlns:swft=\"http://subsignal.org/swfml/swft\" xmlns:str=\"http://exslt.org/strings\" xmlns:xlink=\"http://www.w3.org/1999/xlink\" name=\"wrapElement\">\n"
"	<xsl:param name=\"innerid\"/>\n"
"	<xsl:variable name=\"id\">\n"
"		<xsl:choose>\n"
"			<xsl:when test=\"@id\">\n"
"				<xsl:value-of select=\"swft:map-id(@id)\"/>\n"
"			</xsl:when>\n"
"			<xsl:otherwise>\n"
"				<xsl:value-of select=\"swft:map-id(generate-id(.))\"/>\n"
"			</xsl:otherwise>\n"
"		</xsl:choose>\n"
"	</xsl:variable>\n"
"	<DefineSprite objectID=\"{$id}\" frames=\"1\">\n"
"		<tags>\n"
"			<PlaceObject2 replace=\"0\" depth=\"{swft:next-depth()}\" objectID=\"{$innerid}\">\n"
"				<xsl:call-template name=\"transform\"/>\n"
"			</PlaceObject2>\n"
"			<ShowFrame/>\n"
"			<End/>\n"
"		</tags>\n"
"	</DefineSprite>\n"
"</xsl:template>\n"
"<xsl:template xmlns:inkscape=\"http://www.inkscape.org/namespaces/inkscape\" xmlns:sodipodi=\"http://inkscape.sourceforge.net/DTD/sodipodi-0.dtd\" xmlns:svg=\"http://www.w3.org/2000/svg\" xmlns:swft=\"http://subsignal.org/swfml/swft\" xmlns:str=\"http://exslt.org/strings\" xmlns:xlink=\"http://www.w3.org/1999/xlink\" name=\"exportElement\">\n"
"	<!-- export the element. -->\n"
"	<xsl:if test=\"@id\">\n"
"		<xsl:variable name=\"id\" select=\"swft:map-id(@id)\"/>\n"
"		<xsl:variable name=\"name\" select=\"@id\"/>\n"
"\n"
"		<Export>\n"
"			<symbols>\n"
"				<Symbol objectID=\"{$id}\" name=\"{$name}\"/>\n"
"			</symbols>\n"
"		</Export>\n"
"	</xsl:if>\n"
"\n"
"	<!-- define a class, if applicable. -->\n"
"	<xsl:variable name=\"swfClass\" select=\"@swfClass\"/>\n"
"	<xsl:if test=\"string-length($swfClass) &gt; 0\">\n"
"		<xsl:call-template name=\"register-class\">\n"
"			<xsl:with-param name=\"class\" select=\"$swfClass\"/>\n"
"			<xsl:with-param name=\"linkage-id\" select=\"@id\"/>\n"
"		</xsl:call-template>\n"
"	</xsl:if>\n"
"</xsl:template>\n"
"<xsl:template xmlns:inkscape=\"http://www.inkscape.org/namespaces/inkscape\" xmlns:sodipodi=\"http://inkscape.sourceforge.net/DTD/sodipodi-0.dtd\" xmlns:svg=\"http://www.w3.org/2000/svg\" xmlns:swft=\"http://subsignal.org/swfml/swft\" xmlns:str=\"http://exslt.org/strings\" xmlns:xlink=\"http://www.w3.org/1999/xlink\" match=\"svg:svg\" mode=\"svg\">\n"
"	<xsl:param name=\"id\"/>\n"
"	<xsl:param name=\"export\"/>\n"
"	<!-- initiate the gradient pass. -->\n"
"	<xsl:apply-templates mode=\"gradient1\"/>\n"
"	<xsl:apply-templates mode=\"gradient2\"/>\n"
"	<!-- initiate the definition pass. -->\n"
"	<xsl:apply-templates mode=\"queue\">\n"
"		<xsl:with-param name=\"export\" select=\"$export\"/>\n"
"	</xsl:apply-templates>\n"
"	<!-- define svg root as sprite. -->\n"
"	<DefineSprite objectID=\"{$id}\" frames=\"1\">\n"
"		<tags>\n"
"			<!-- initiate the placement pass. -->\n"
"			<xsl:apply-templates mode=\"placement\"/>\n"
"			<ShowFrame/>\n"
"			<End/>\n"
"		</tags>\n"
"	</DefineSprite>\n"
"</xsl:template>\n"
"<xsl:template xmlns:inkscape=\"http://www.inkscape.org/namespaces/inkscape\" xmlns:sodipodi=\"http://inkscape.sourceforge.net/DTD/sodipodi-0.dtd\" xmlns:svg=\"http://www.w3.org/2000/svg\" xmlns:swft=\"http://subsignal.org/swfml/swft\" xmlns:str=\"http://exslt.org/strings\" xmlns:xlink=\"http://www.w3.org/1999/xlink\" match=\"svg:linearGradient[not(@xlink:href)]|svg:radialGradient[not(@xlink:href)]\" mode=\"gradient1\">\n"
"	<swft:push-gradient/>\n"
"</xsl:template>\n"
"<xsl:template xmlns:inkscape=\"http://www.inkscape.org/namespaces/inkscape\" xmlns:sodipodi=\"http://inkscape.sourceforge.net/DTD/sodipodi-0.dtd\" xmlns:svg=\"http://www.w3.org/2000/svg\" xmlns:swft=\"http://subsignal.org/swfml/swft\" xmlns:str=\"http://exslt.org/strings\" xmlns:xlink=\"http://www.w3.org/1999/xlink\" match=\"svg:linearGradient[@xlink:href]|svg:radialGradient[@xlink:href]\" mode=\"gradient2\">\n"
"	<swft:push-gradient/>\n"
"</xsl:template>\n"
"<xsl:template xmlns:inkscape=\"http://www.inkscape.org/namespaces/inkscape\" xmlns:sodipodi=\"http://inkscape.sourceforge.net/DTD/sodipodi-0.dtd\" xmlns:svg=\"http://www.w3.org/2000/svg\" xmlns:swft=\"http://subsignal.org/swfml/swft\" xmlns:str=\"http://exslt.org/strings\" xmlns:xlink=\"http://www.w3.org/1999/xlink\" match=\"svg:g|svg:path|svg:rect|svg:circle|svg:ellipse|svg:line|svg:polyline|svg:polygon|svg:use|svg:text|svg:flowRoot\" mode=\"queue\">\n"
"	<xsl:param name=\"export\"/>\n"
"\n"
"	<xsl:if test=\"name()='g'\">\n"
"		<swft:push-style/>\n"
"	</xsl:if>\n"
"\n"
"	<xsl:variable name=\"id\">\n"
"		<xsl:choose>\n"
"			<xsl:when test=\"@id\">\n"
"				<xsl:value-of select=\"swft:map-id(@id)\"/>\n"
"			</xsl:when>\n"
"			<xsl:otherwise>\n"
"				<xsl:value-of select=\"swft:map-id(generate-id(.))\"/>\n"
"			</xsl:otherwise>\n"
"		</xsl:choose>\n"
"	</xsl:variable>\n"
"	<xsl:variable name=\"name\">\n"
"		<xsl:choose>\n"
"			<xsl:when test=\"@id\">\n"
"				<xsl:value-of select=\"@id\"/>\n"
"			</xsl:when>\n"
"			<xsl:otherwise>\n"
"				<xsl:value-of select=\"generate-id(.)\"/>\n"
"			</xsl:otherwise>\n"
"		</xsl:choose>\n"
"	</xsl:variable>\n"
"\n"
"	<!-- first define the subparts, so that we get the innermost ones queued \n"
"first. -->\n"
"	<xsl:apply-templates mode=\"queue\">\n"
"		<xsl:with-param name=\"export\" select=\"$export\"/>\n"
"	</xsl:apply-templates>\n"
"\n"
"	<!-- now define this element, which is based on the subparts. -->\n"
"	<xsl:apply-templates select=\".\" mode=\"definition\">\n"
"		<xsl:with-param name=\"id\" select=\"$id\"/>\n"
"		<xsl:with-param name=\"name\" select=\"$name\"/>\n"
"		<xsl:with-param name=\"export\" select=\"$export\"/>\n"
"	</xsl:apply-templates>\n"
"\n"
"	<xsl:if test=\"name()='g'\">\n"
"		<swft:pop-style/>\n"
"	</xsl:if>\n"
"</xsl:template>\n"
"<xsl:template xmlns:inkscape=\"http://www.inkscape.org/namespaces/inkscape\" xmlns:sodipodi=\"http://inkscape.sourceforge.net/DTD/sodipodi-0.dtd\" xmlns:svg=\"http://www.w3.org/2000/svg\" xmlns:swft=\"http://subsignal.org/swfml/swft\" xmlns:str=\"http://exslt.org/strings\" xmlns:xlink=\"http://www.w3.org/1999/xlink\" match=\"svg:g|svg:path|svg:rect|svg:circle|svg:ellipse|svg:line|svg:polyline|svg:polygon|svg:use|svg:text|svg:flowRoot\" mode=\"placement\">\n"
"	<xsl:if test=\"not(ancestor::svg:defs) or parent::svg:g\">\n"
"		<!-- no definition. just place this element. -->\n"
"		<xsl:call-template name=\"placeObject\"/>\n"
"	</xsl:if>\n"
"</xsl:template>\n"
"<xsl:template xmlns:inkscape=\"http://www.inkscape.org/namespaces/inkscape\" xmlns:sodipodi=\"http://inkscape.sourceforge.net/DTD/sodipodi-0.dtd\" xmlns:svg=\"http://www.w3.org/2000/svg\" xmlns:swft=\"http://subsignal.org/swfml/swft\" xmlns:str=\"http://exslt.org/strings\" xmlns:xlink=\"http://www.w3.org/1999/xlink\" match=\"svg:g\" mode=\"definition\" priority=\"-1\">\n"
"	<xsl:param name=\"id\"/>\n"
"	<xsl:param name=\"name\"/>\n"
"	<xsl:param name=\"export\"/>\n"
"\n"
"	<!-- test if a wrapper is needed for a group transform -->\n"
"	<xsl:choose>\n"
"		<xsl:when test=\"not(@transform) or @transform='' or  transform='translate(0,0)'\">\n"
"			<!-- no transform, define the group and place the subparts -->\n"
"			<DefineSprite objectID=\"{$id}\" frames=\"1\">\n"
"				<tags>\n"
"					<xsl:apply-templates mode=\"placement\"/>\n"
"					<ShowFrame/>\n"
"					<End/>\n"
"				</tags>\n"
"			</DefineSprite>\n"
"		</xsl:when>\n"
"		<xsl:otherwise>\n"
"			<!-- define an inner group and wrap it with the group transform -->\n"
"			<xsl:variable name=\"innerid\"><xsl:value-of select=\"swft:next-id()\"/></xsl:variable>\n"
"			<DefineSprite objectID=\"{$innerid}\" frames=\"1\">\n"
"				<tags>\n"
"					<xsl:apply-templates mode=\"placement\"/>\n"
"					<ShowFrame/>\n"
"					<End/>\n"
"				</tags>\n"
"			</DefineSprite>\n"
"			<xsl:call-template name=\"wrapElement\">\n"
"				<xsl:with-param name=\"innerid\" select=\"$innerid\"/>\n"
"			</xsl:call-template>\n"
"		</xsl:otherwise>\n"
"	</xsl:choose>\n"
"\n"
"\n"
"	<!-- export -->\n"
"	<xsl:if test=\"$export = 'all' or $export = 'groups'\">\n"
"		<xsl:call-template name=\"exportElement\"/>\n"
"	</xsl:if>\n"
"</xsl:template>\n"
"<xsl:template xmlns:inkscape=\"http://www.inkscape.org/namespaces/inkscape\" xmlns:sodipodi=\"http://inkscape.sourceforge.net/DTD/sodipodi-0.dtd\" xmlns:svg=\"http://www.w3.org/2000/svg\" xmlns:swft=\"http://subsignal.org/swfml/swft\" xmlns:str=\"http://exslt.org/strings\" xmlns:xlink=\"http://www.w3.org/1999/xlink\" match=\"svg:rect|svg:circle|svg:ellipse|svg:line|svg:polyline|svg:polygon|svg:path\" mode=\"definition\">\n"
"	<xsl:param name=\"id\"/>\n"
"	<xsl:param name=\"export\"/>\n"
"	<xsl:variable name=\"shapeid\"><xsl:value-of select=\"swft:next-id()\"/></xsl:variable>\n"
"\n"
"	<!-- define the path -->\n"
"	<xsl:copy-of select=\"swft:path(., $shapeid, $movie-version)\"/>\n"
"	<!-- wrap in sprite -->\n"
"	<xsl:call-template name=\"wrapElement\">\n"
"		<xsl:with-param name=\"innerid\" select=\"$shapeid\"/>\n"
"	</xsl:call-template>\n"
"	<!-- export -->\n"
"	<xsl:if test=\"$export = 'all'\">\n"
"		<xsl:call-template name=\"exportElement\"/>\n"
"	</xsl:if>\n"
"</xsl:template>\n"
"<xsl:template xmlns:inkscape=\"http://www.inkscape.org/namespaces/inkscape\" xmlns:sodipodi=\"http://inkscape.sourceforge.net/DTD/sodipodi-0.dtd\" xmlns:svg=\"http://www.w3.org/2000/svg\" xmlns:swft=\"http://subsignal.org/swfml/swft\" xmlns:str=\"http://exslt.org/strings\" xmlns:xlink=\"http://www.w3.org/1999/xlink\" match=\"svg:flowRoot\" mode=\"definition\">\n"
"	<xsl:param name=\"id\"/>\n"
"	<xsl:param name=\"name\"/>\n"
"	<xsl:param name=\"export\"/>\n"
"	<xsl:variable name=\"shapeid\"><xsl:value-of select=\"swft:next-id()\"/></xsl:variable>\n"
"\n"
"	<!-- define the element -->\n"
"	<DefineEditText objectID=\"{$shapeid}\" wordWrap=\"1\" multiLine=\"1\" password=\"0\" readOnly=\"0\" autoSize=\"0\" hasLayout=\"1\" notSelectable=\"0\" hasBorder=\"0\" isHTML=\"0\" useOutlines=\"0\" fontRef=\"{swft:map-id('vera')}\" fontHeight=\"240\" align=\"0\" leftMargin=\"0\" rightMargin=\"0\" indent=\"0\" leading=\"40\" variableName=\"{@name}\">\n"
"		<xsl:attribute name=\"initialText\">\n"
"			<xsl:apply-templates mode=\"svg-text\"/>\n"
"		</xsl:attribute>\n"
"		<size>\n"
"			<Rectangle left=\"{svg:flowRegion/svg:rect/@x * 20}\" right=\"{(svg:flowRegion/svg:rect/@x + svg:flowRegion/svg:rect/@width)* 20}\" top=\"{svg:flowRegion/svg:rect/@y * 20}\" bottom=\"{(svg:flowRegion/svg:rect/@y  + svg:flowRegion/svg:rect/@height)* 20}\"/>\n"
"		</size>\n"
"		<color>\n"
"			<Color red=\"0\" green=\"0\" blue=\"0\" alpha=\"255\"/>\n"
"		</color>\n"
"	</DefineEditText>\n"
"	<!-- wrap in sprite -->\n"
"	<xsl:call-template name=\"wrapElement\">\n"
"		<xsl:with-param name=\"innerid\" select=\"$shapeid\"/>\n"
"	</xsl:call-template>\n"
"	<!-- export -->\n"
"	<xsl:if test=\"$export = 'all'\">\n"
"		<xsl:call-template name=\"exportElement\"/>\n"
"	</xsl:if>\n"
"</xsl:template>\n"
"<xsl:template xmlns:inkscape=\"http://www.inkscape.org/namespaces/inkscape\" xmlns:sodipodi=\"http://inkscape.sourceforge.net/DTD/sodipodi-0.dtd\" xmlns:svg=\"http://www.w3.org/2000/svg\" xmlns:swft=\"http://subsignal.org/swfml/swft\" xmlns:str=\"http://exslt.org/strings\" xmlns:xlink=\"http://www.w3.org/1999/xlink\" match=\"svg:text\" mode=\"definition\">\n"
"	<xsl:param name=\"id\"/>\n"
"	<xsl:param name=\"name\"/>\n"
"	<xsl:param name=\"export\"/>\n"
"	<xsl:variable name=\"shapeid\"><xsl:value-of select=\"swft:next-id()\"/></xsl:variable>\n"
"\n"
"	<!-- define the element -->\n"
"	<DefineEditText objectID=\"{$shapeid}\" wordWrap=\"0\" multiLine=\"1\" password=\"0\" readOnly=\"1\" autoSize=\"1\" hasLayout=\"1\" notSelectable=\"1\" hasBorder=\"0\" isHTML=\"0\" useOutlines=\"0\" fontRef=\"{swft:map-id('vera')}\" fontHeight=\"240\" align=\"0\" leftMargin=\"0\" rightMargin=\"0\" indent=\"0\" leading=\"40\" variableName=\"{@name}\">\n"
"	<xsl:attribute name=\"initialText\">\n"
"		<xsl:apply-templates mode=\"svg-text\"/>\n"
"	</xsl:attribute>\n"
"	<size>\n"
"		<Rectangle left=\"{@x * 20}\" right=\"{(@x + 200) * 20}\" top=\"{@y * 20 - 240}\" bottom=\"{@y  * 20}\"/>\n"
"	</size>\n"
"	<color>\n"
"		<Color red=\"0\" green=\"0\" blue=\"0\" alpha=\"255\"/>\n"
"	</color>\n"
"	</DefineEditText>\n"
"	<!-- wrap in sprite -->\n"
"	<xsl:call-template name=\"wrapElement\">\n"
"		<xsl:with-param name=\"innerid\" select=\"$shapeid\"/>\n"
"	</xsl:call-template>\n"
"	<!-- export -->\n"
"	<xsl:if test=\"$export = 'all'\">\n"
"		<xsl:call-template name=\"exportElement\"/>\n"
"	</xsl:if>\n"
"</xsl:template>\n"
"<xsl:template xmlns:inkscape=\"http://www.inkscape.org/namespaces/inkscape\" xmlns:sodipodi=\"http://inkscape.sourceforge.net/DTD/sodipodi-0.dtd\" xmlns:svg=\"http://www.w3.org/2000/svg\" xmlns:swft=\"http://subsignal.org/swfml/swft\" xmlns:str=\"http://exslt.org/strings\" xmlns:xlink=\"http://www.w3.org/1999/xlink\" match=\"svg:flowRegion\" mode=\"svg-text\">\n"
"	<xsl:apply-templates mode=\"svg-text\"/>\n"
"</xsl:template>\n"
"<xsl:template xmlns:inkscape=\"http://www.inkscape.org/namespaces/inkscape\" xmlns:sodipodi=\"http://inkscape.sourceforge.net/DTD/sodipodi-0.dtd\" xmlns:svg=\"http://www.w3.org/2000/svg\" xmlns:swft=\"http://subsignal.org/swfml/swft\" xmlns:str=\"http://exslt.org/strings\" xmlns:xlink=\"http://www.w3.org/1999/xlink\" match=\"svg:flowPara\" mode=\"svg-text\">\n"
"	<xsl:apply-templates mode=\"svg-text\"/>\n"
"</xsl:template>\n"
"<xsl:template xmlns:inkscape=\"http://www.inkscape.org/namespaces/inkscape\" xmlns:sodipodi=\"http://inkscape.sourceforge.net/DTD/sodipodi-0.dtd\" xmlns:svg=\"http://www.w3.org/2000/svg\" xmlns:swft=\"http://subsignal.org/swfml/swft\" xmlns:str=\"http://exslt.org/strings\" xmlns:xlink=\"http://www.w3.org/1999/xlink\" match=\"svg:tspan[position()=1]\" mode=\"svg-text\">\n"
"	<xsl:apply-templates mode=\"svg-text\"/>\n"
"</xsl:template>\n"
"<xsl:template xmlns:inkscape=\"http://www.inkscape.org/namespaces/inkscape\" xmlns:sodipodi=\"http://inkscape.sourceforge.net/DTD/sodipodi-0.dtd\" xmlns:svg=\"http://www.w3.org/2000/svg\" xmlns:swft=\"http://subsignal.org/swfml/swft\" xmlns:str=\"http://exslt.org/strings\" xmlns:xlink=\"http://www.w3.org/1999/xlink\" match=\"svg:tspan\" mode=\"svg-text\" priority=\"-1\">\n"
"	<xsl:text>\n"
"	</xsl:text>\n"
"	<xsl:apply-templates mode=\"svg-text\"/>\n"
"</xsl:template>\n"
"<xsl:template xmlns:inkscape=\"http://www.inkscape.org/namespaces/inkscape\" xmlns:sodipodi=\"http://inkscape.sourceforge.net/DTD/sodipodi-0.dtd\" xmlns:svg=\"http://www.w3.org/2000/svg\" xmlns:swft=\"http://subsignal.org/swfml/swft\" xmlns:str=\"http://exslt.org/strings\" xmlns:xlink=\"http://www.w3.org/1999/xlink\" match=\"text()\" mode=\"svg-text\">\n"
"	<xsl:copy-of select=\".\"/>\n"
"</xsl:template>\n"
"<xsl:template xmlns:inkscape=\"http://www.inkscape.org/namespaces/inkscape\" xmlns:sodipodi=\"http://inkscape.sourceforge.net/DTD/sodipodi-0.dtd\" xmlns:svg=\"http://www.w3.org/2000/svg\" xmlns:swft=\"http://subsignal.org/swfml/swft\" xmlns:str=\"http://exslt.org/strings\" xmlns:xlink=\"http://www.w3.org/1999/xlink\" match=\"*|@*|text()\" mode=\"svg\" priority=\"-1\"/>\n"
"<xsl:template xmlns:inkscape=\"http://www.inkscape.org/namespaces/inkscape\" xmlns:sodipodi=\"http://inkscape.sourceforge.net/DTD/sodipodi-0.dtd\" xmlns:svg=\"http://www.w3.org/2000/svg\" xmlns:swft=\"http://subsignal.org/swfml/swft\" xmlns:str=\"http://exslt.org/strings\" xmlns:xlink=\"http://www.w3.org/1999/xlink\" match=\"ShapeSetup\" mode=\"shape\">\n"
"	<ShapeSetup fillStyle0=\"1\" fillStyle1=\"2\" lineStyle=\"1\">\n"
"		<xsl:apply-templates select=\"*|@*\" mode=\"shape\"/>\n"
"	</ShapeSetup>\n"
"</xsl:template>\n"
"<xsl:template xmlns:inkscape=\"http://www.inkscape.org/namespaces/inkscape\" xmlns:sodipodi=\"http://inkscape.sourceforge.net/DTD/sodipodi-0.dtd\" xmlns:svg=\"http://www.w3.org/2000/svg\" xmlns:swft=\"http://subsignal.org/swfml/swft\" xmlns:str=\"http://exslt.org/strings\" xmlns:xlink=\"http://www.w3.org/1999/xlink\" match=\"*|@*|text()\" mode=\"shape\" priority=\"-1\">\n"
"	<xsl:copy-of select=\".\"/>\n"
"</xsl:template>\n"
"	\n"
"<xsl:template xmlns:swft=\"http://subsignal.org/swfml/swft\" xmlns:str=\"http://exslt.org/strings\" xmlns:math=\"http://exslt.org/math\" match=\"set\">\n"
"	<xsl:if test=\"$quiet != 'true'\">\n"
"		<xsl:message>\"set\" is deprecated, please use assignments in place</xsl:message>\n"
"	</xsl:if>\n"
"	\n"
"	<xsl:variable name=\"spriteid\">\n"
"		<xsl:value-of select=\"swft:next-id()\"/>\n"
"	</xsl:variable>\n"
"	<DefineSprite objectID=\"{$spriteid}\" frames=\"1\">\n"
"		<tags>\n"
"			<End/>\n"
"		</tags>\n"
"	</DefineSprite>\n"
"	<Export>\n"
"		<symbols>\n"
"			<Symbol objectID=\"{$spriteid}\" name=\"__Packages.swfmill.set.{@name}.{@member}\"/>\n"
"		</symbols>\n"
"	</Export>\n"
"	<DoInitAction sprite=\"{$spriteid}\">\n"
"		<actions>\n"
"			<Dictionary>\n"
"				<strings>\n"
"					<String value=\"_root\"/>\n"
"					<String value=\"{@name}\"/>\n"
"					<String value=\"{@member}\"/>\n"
"					<String value=\"{@value}\"/>\n"
"				</strings>\n"
"			</Dictionary>\n"
"			<PushData>\n"
"				<items>\n"
"					<StackDictionaryLookup index=\"0\"/>\n"
"				</items>\n"
"			</PushData>\n"
"			<GetVariable/>\n"
"			<PushData>\n"
"				<items>\n"
"					<StackDictionaryLookup index=\"1\"/>\n"
"				</items>\n"
"			</PushData>\n"
"			<GetMember/>\n"
"			<PushData>\n"
"				<items>\n"
"					<StackDictionaryLookup index=\"2\"/>\n"
"					<StackDictionaryLookup index=\"3\"/>\n"
"				</items>\n"
"			</PushData>\n"
"			<SetMember/>\n"
"			<EndAction/>\n"
"		</actions>\n"
"	</DoInitAction>\n"
"</xsl:template>\n"
"</xsl:stylesheet>\n"
;
