'''
 ====================================================================
 Copyright (c) 2003-2005 Barry A Scott.  All rights reserved.

 This software is licensed as described in the file LICENSE.txt,
 which you should have received as part of this distribution.

 ====================================================================

    wb_subversion_list_handler.py

'''
import pysvn
import wx
import wb_subversion_utils

class InfoDialog(wx.Dialog):
    def __init__( self, app, parent, path, info_entry_or_info2_list ):
        wx.Dialog.__init__( self, parent, -1, path )

        self.g_sizer = None
        self.g_sizer_list = []

        self.addGroup( 'Entry' )
        self.addRow( 'Path:',path )

        if type(info_entry_or_info2_list) == type([]):
            self.initForInfo2( info_entry_or_info2_list[0][1] )
        else:
            self.initForInfo1( info_entry_or_info2_list )

        self.button_ok = wx.Button( self, wx.ID_OK, ' OK ' )
        self.button_ok.SetDefault()

        self.h_sizer_buttons = wx.BoxSizer( wx.HORIZONTAL )
        self.h_sizer_buttons.Add( (450, 20), 1, wx.EXPAND)
        self.h_sizer_buttons.Add( self.button_ok, 0, wx.EXPAND|wx.EAST, 15 )

        self.v_sizer = wx.BoxSizer( wx.VERTICAL )
        for g_sizer in self.g_sizer_list:
            self.v_sizer.Add( g_sizer, 0, wx.EXPAND|wx.ALL, 5 )
        self.v_sizer.Add( self.h_sizer_buttons, 0, wx.EXPAND|wx.ALL, 5 )

        self.SetAutoLayout( True )
        self.SetSizer( self.v_sizer )
        self.v_sizer.Fit( self )
        self.Layout()

        self.CentreOnParent()

    def initForInfo1( self, entry ):
        if entry.name and entry.name != 'svn:this_dir':
            self.addRow( 'Name:',entry.name )
        if entry.url:
            self.addRow( 'URL:',entry.url )
        if entry.repos:
            self.addRow( 'Repository:',entry.repos )
        if entry.uuid:
            self.addRow( 'Repository UUID:',entry.uuid )
        if entry.revision.kind == pysvn.opt_revision_kind.number:
            self.addRow( 'Revision:',entry.revision.number )
        if entry.kind == pysvn.node_kind.file:
            self.addRow( 'Node kind:','file' )
        elif entry.kind == pysvn.node_kind.dir:
            self.addRow( 'Node kind:','directory' )
        elif entry.kind == pysvn.node_kind.none:
            self.addRow( 'Node kind:','none' )
        else:
            self.addRow( 'Node kind:','unknown' )

        if entry.schedule == pysvn.wc_schedule.normal:
            self.addRow( 'Schedule:','normal' )
        elif entry.schedule == pysvn.wc_schedule.add:
            self.addRow( 'Schedule:','add' )
        elif entry.schedule == pysvn.wc_schedule.delete:
            self.addRow( 'Schedule:','delete' )
        elif entry.schedule == pysvn.wc_schedule.replace:
            self.addRow( 'Schedule:','replace' )
        if entry.is_copied:
            if entry.copy_from_url:
                self.addRow( 'Copied From URL:', entry.copy_from_url )
            if entry.copy_from_rev.number:
                self.addRow( 'Copied From Revision:', entry.copy_from_rev.number )
        if entry.commit_author:
            self.addRow( 'Last Changed Author:', entry.commit_author )
        if entry.commit_revision.number > 0:
            self.addRow( 'Last Changed Revision:', entry.commit_revision.number )
        if entry.commit_time:
            self.addRow( 'Last Changed Date:', wb_subversion_utils.fmtDateTime( entry.commit_time ) )
        if entry.text_time:
            self.addRow( 'Text Last Updated:', wb_subversion_utils.fmtDateTime( entry.text_time ) )
        if entry.properties_time:
            self.addRow( 'Properties Last Updated:', wb_subversion_utils.fmtDateTime( entry.properties_time ) )
        if entry.checksum:
            self.addRow( 'Checksum:', entry.checksum )

    def initForInfo2( self, entry ):
        if entry['URL']:
            self.addRow( 'URL:',entry['URL'] )
        if entry['repos_root_URL']:
            self.addRow( 'Repository root URL:',entry['repos_root_URL'] )
        if entry['repos_UUID']:
            self.addRow( 'Repository UUID:',entry['repos_UUID'] )
        if entry['rev'].kind == pysvn.opt_revision_kind.number:
            self.addRow( 'Revision:',entry['rev'].number )
        if entry['kind'] == pysvn.node_kind.file:
            self.addRow( 'Node kind:','file' )
        elif entry['kind'] == pysvn.node_kind.dir:
            self.addRow( 'Node kind:','directory' )
        elif entry['kind'] == pysvn.node_kind.none:
            self.addRow( 'Node kind:','none' )
        else:
            self.addRow( 'Node kind:','unknown' )

        if entry['last_changed_author']:
            self.addRow( 'Last Changed Author:', entry['last_changed_author'] )
        if entry['last_changed_rev'].number > 0:
            self.addRow( 'Last Changed Revision:', entry['last_changed_rev'].number )
        if entry['last_changed_date']:
            self.addRow( 'Last Changed Date:', wb_subversion_utils.fmtDateTime( entry['last_changed_date'] ) )

        self.addGroup( 'Lock' )
        lock_info = entry['lock']
        if lock_info is not None:
            self.addRow( 'Lock Owner:',lock_info['owner'] )
            self.addRow( 'Lock Creation Date:',wb_subversion_utils.fmtDateTime( lock_info['creation_date'] ) )
            if lock_info['expiration_date'] is not None:
                self.addRow( 'Lock Expiration Date:',wb_subversion_utils.fmtDateTime( lock_info['expiration_date'] ) )
            self.addRow( 'Lock Token:',lock_info['token'] )
            self.addRow( 'Lock Comment:', lock_info['comment'] )
        else:
            self.addRow( 'Lock Token:', '' )

        wc_info = entry['wc_info']
        if wc_info is None:
            return

        self.addGroup( 'Working copy' )
        if wc_info['schedule'] == pysvn.wc_schedule.normal:
            self.addRow( 'Schedule:','normal' )
        elif wc_info['schedule'] == pysvn.wc_schedule.add:
            self.addRow( 'Schedule:','add' )
        elif wc_info['schedule'] == pysvn.wc_schedule.delete:
            self.addRow( 'Schedule:','delete' )
        elif wc_info['schedule'] == pysvn.wc_schedule.replace:
            self.addRow( 'Schedule:','replace' )
        else:
            self.addRow( 'Schedule:', str(wc_info['schedule']))
        if wc_info['copyfrom_url']:
            self.addRow( 'Copied From URL:', wc_info['copyfrom_url'] )
            if wc_info['copyfrom_rev'].number:
                self.addRow( 'Copied From Revision:', wc_info['copyfrom_rev'].number )
        if wc_info['text_time']:
            self.addRow( 'Text Last Updated:', wb_subversion_utils.fmtDateTime( wc_info['text_time'] ) )
        if wc_info['prop_time']:
            self.addRow( 'Properties Last Updated:', wb_subversion_utils.fmtDateTime( wc_info['prop_time'] ) )
        if wc_info['checksum']:
            self.addRow( 'Checksum:', wc_info['checksum'] )

    def addGroup( self, label ):
        self.g_sizer = wx.FlexGridSizer( 0, 2, 0, 0 )
        self.g_sizer.AddGrowableCol( 1 )

        self.border = wx.StaticBox( self, -1, label )
        self.box = wx.StaticBoxSizer( self.border, wx.VERTICAL )
        self.box.Add( self.g_sizer, 0, wx.EXPAND )

        self.g_sizer_list.append( self.box )

    def addRow( self, label, value ):
        label_ctrl = wx.StaticText( self, -1, label, style=wx.ALIGN_RIGHT )
        str_value = str(value)
        if '\n' in str_value:
            value_ctrl = wx.TextCtrl( self, -1, str(value), size=wx.Size( -1, 100 ), style=wx.TE_READONLY|wx.TE_MULTILINE )
        else:
            value_ctrl = wx.TextCtrl( self, -1, str(value), style=wx.TE_READONLY )

        self.g_sizer.Add( label_ctrl, 1, wx.EXPAND|wx.ALL|wx.ALIGN_RIGHT, 3 )
        self.g_sizer.Add( value_ctrl, 0, wx.EXPAND, 5 )
