'''
 ====================================================================
 Copyright (c) 2003-2005 Barry A Scott.  All rights reserved.

 This software is licensed as described in the file LICENSE.txt,
 which you should have received as part of this distribution.

 ====================================================================

    wb_subversion_list_handler.py

'''
import pysvn
import wx
import wb_subversion_utils

class InfoDialog(wx.Dialog):
    def __init__( self, app, parent, path, entry ):
        wx.Dialog.__init__( self, parent, -1, path )

        self.g_sizer = wx.FlexGridSizer( 0, 2, 0, 0 )
        self.g_sizer.AddGrowableCol( 1 )

        self.addRow( 'Path:',path )
        if entry.name and entry.name != 'svn:this_dir':
            self.addRow( 'Name:',entry.name )
        if entry.url:
            self.addRow( 'Url:',entry.url )
        if entry.repos:
            self.addRow( 'Repository:',entry.repos )
        if entry.uuid:
            self.addRow( 'Repository UUID:',entry.uuid )
        if entry.revision.kind == pysvn.opt_revision_kind.number:
            self.addRow( 'Revision:',entry.revision.number )
        if entry.kind == pysvn.node_kind.file:
            self.addRow( 'Node kind:','file' )
        elif entry.kind == pysvn.node_kind.dir:
            self.addRow( 'Node kind:','directory' )
        elif entry.kind == pysvn.node_kind.none:
            self.addRow( 'Node kind:','none' )
        else:
            self.addRow( 'Node kind:','unknown' )

        if entry.schedule == pysvn.wc_schedule.normal:
            self.addRow( 'Schedule:','normal' )
        elif entry.schedule == pysvn.wc_schedule.add:
            self.addRow( 'Schedule:','add' )
        elif entry.schedule == pysvn.wc_schedule.delete:
            self.addRow( 'Schedule:','delete' )
        elif entry.schedule == pysvn.wc_schedule.replace:
            self.addRow( 'Schedule:','replace' )
        if entry.is_copied:
            if entry.copy_from_url:
                self.addRow( 'Copied From URL:', entry.copy_from_url )
            if entry.copy_from_rev.number:
                self.addRow( 'Copied From Rev:', entry.copy_from_rev.number )
        if entry.commit_author:
            self.addRow( 'Last Changed Author:', entry.commit_author )
        if entry.commit_revision.number:
            self.addRow( 'Last Changed Rev:', entry.commit_revision.number )
        if entry.commit_time:
            self.addRow( 'Last Changed Date:', wb_subversion_utils.fmtDateTime( entry.commit_time ) )
        if entry.text_time:
            self.addRow( 'Text Last Updated:', wb_subversion_utils.fmtDateTime( entry.text_time ) )
        if entry.properties_time:
            self.addRow( 'Properties Last Updated:', wb_subversion_utils.fmtDateTime( entry.properties_time ) )
        if entry.checksum:
            self.addRow( 'Checksum:', entry.checksum )

        self.button_ok = wx.Button( self, wx.ID_OK, ' OK ' )
        self.button_ok.SetDefault()

        self.h_sizer_buttons = wx.BoxSizer( wx.HORIZONTAL )
        self.h_sizer_buttons.Add( (450, 20), 1, wx.EXPAND)
        self.h_sizer_buttons.Add( self.button_ok, 0, wx.EXPAND|wx.EAST, 15 )

        self.v_sizer = wx.BoxSizer( wx.VERTICAL )
        self.v_sizer.Add( self.g_sizer, 0, wx.EXPAND|wx.ALL, 5 )
        self.v_sizer.Add( self.h_sizer_buttons, 0, wx.EXPAND|wx.ALL, 5 )

        self.SetAutoLayout( True )
        self.SetSizer( self.v_sizer )
        self.v_sizer.Fit( self )
        self.Layout()

        self.CentreOnParent()

    def addRow( self, label, value ):
        label_ctrl = wx.StaticText( self, -1, label, style=wx.ALIGN_RIGHT )
        value_ctrl = wx.TextCtrl( self, -1, str(value), style=wx.TE_READONLY )

        self.g_sizer.Add( label_ctrl, 1, wx.EXPAND|wx.ALL|wx.ALIGN_RIGHT, 3 )
        self.g_sizer.Add( value_ctrl, 0, wx.EXPAND, 5 )
