'''
 ====================================================================
 Copyright (c) 2005 Barry A Scott.  All rights reserved.

 This software is licensed as described in the file LICENSE.txt,
 which you should have received as part of this distribution.

 ====================================================================

    wb_bookmarks_dialogs.py

'''
import wx

class BookmarkManageDialog(wx.Dialog):
    def __init__( self, parent, bookmark_prefs ):
        wx.Dialog.__init__( self, parent, -1, "Manage Bookmarks" )

        self.bookmark_prefs = bookmark_prefs

        self.initControls()

    def initControls( self ):
        self.v_sizer = wx.BoxSizer( wx.VERTICAL )
        self.h_sizer1 = wx.BoxSizer( wx.HORIZONTAL )
        self.h_sizer2 = wx.BoxSizer( wx.HORIZONTAL )

        self.bookmark_list = wx.ListCtrl( self, wx.NewId(), size=( 600, 200 ), style=wx.LC_REPORT )
        self.bookmark_list.InsertColumn( 0, "Bookmark" )
        self.bookmark_list.SetColumnWidth( 0, 600 )

        self.bookmark_name_list = [name for name in self.bookmark_prefs.getBookmarkNames()
                        if name != 'last position']
        self.bookmark_deleted_list = []

        for index, bm_name in enumerate( self.bookmark_name_list ):
            self.bookmark_list.InsertStringItem( index, bm_name )

        self.button_delete = wx.Button( self, wx.NewId(), " Delete Bookmark " )
        self.button_delete.Enable( False )

        self.button_ok = wx.Button( self, wx.ID_OK, " OK " )
        self.button_cancel = wx.Button( self, wx.ID_CANCEL, " Cancel " )
        self.button_ok.SetDefault()

        self.h_sizer1.Add( self.button_delete, 0, wx.EXPAND|wx.WEST, 15)
        self.h_sizer1.Add( (60, 20), 1, wx.EXPAND)

        self.h_sizer2.Add( (60, 20), 1, wx.EXPAND)
        self.h_sizer2.Add( self.button_ok, 0, wx.EXPAND|wx.EAST, 15)
        self.h_sizer2.Add( self.button_cancel, 0, wx.EXPAND|wx.EAST, 2 )

        self.v_sizer.Add( self.bookmark_list, 0, wx.EXPAND|wx.ALL, 5 )
        self.v_sizer.Add( self.h_sizer1, 0, wx.EXPAND|wx.ALL, 5 )
        self.v_sizer.Add( self.h_sizer2, 0, wx.EXPAND|wx.ALL, 5 )

        self.SetAutoLayout( True )
        self.SetSizer( self.v_sizer )
        self.v_sizer.Fit( self )
        self.Layout()

        self.CentreOnParent()

        wx.EVT_LIST_ITEM_SELECTED( self, self.bookmark_list.GetId(), self.OnSelectBookmark )
        wx.EVT_LIST_ITEM_DESELECTED( self, self.bookmark_list.GetId(), self.OnDeselectBookmark )

        wx.EVT_BUTTON( self, self.button_delete.GetId(), self.OnDeleteBookmark )
        wx.EVT_BUTTON( self, wx.ID_OK, self.OnOk )
        wx.EVT_BUTTON( self, wx.ID_CANCEL, self.OnCancel )

    def OnOk( self, event ):
        self.EndModal( wx.ID_OK )

    def OnCancel( self, event ):
        self.EndModal( wx.ID_CANCEL )

    def OnDeleteBookmark( self, event ):
        self.bookmark_deleted_list.append( self.bookmark_name_list.pop( self.selection ) )
        self.bookmark_list.DeleteItem( self.selection )
        self.button_delete.Enable( False )

    def OnSelectBookmark( self, event ):
        self.selection = event.m_itemIndex
        self.button_delete.Enable( True )

    def OnDeselectBookmark( self, event ):
        self.selection = None
        self.button_delete.Enable( False )

    def getDeletedBookmarkList( self ):
        return self.bookmark_deleted_list
