/*
 * svn_tests_editor.c:  a `dummy' editor implementation for testing
 *
 * ====================================================================
 *    Licensed to the Apache Software Foundation (ASF) under one
 *    or more contributor license agreements.  See the NOTICE file
 *    distributed with this work for additional information
 *    regarding copyright ownership.  The ASF licenses this file
 *    to you under the Apache License, Version 2.0 (the
 *    "License"); you may not use this file except in compliance
 *    with the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *    Unless required by applicable law or agreed to in writing,
 *    software distributed under the License is distributed on an
 *    "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 *    KIND, either express or implied.  See the License for the
 *    specific language governing permissions and limitations
 *    under the License.
 * ====================================================================
 */

/* ==================================================================== */



#ifndef SVN_TEST__DIR_DELTA_EDITOR_H
#define SVN_TEST__DIR_DELTA_EDITOR_H

#include <stdio.h>

#include <apr_pools.h>

#include "svn_types.h"
#include "svn_error.h"
#include "svn_delta.h"

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */


/* Get an editor that will edit an FS transaction via the libsvn_fs API.
 *
 * Set *EDITOR and *EDIT_BATON to a new editor that edits the subtree at
 * PATH of the existing, open transaction TXN_ROOT in filesystem FS.
 *
 * Note: Related but more complex functions in the regular API include
 * svn_fs__editor_create_for() and svn_repos_get_commit_editor*().
 *
 * Note: The only connection with dir-deltas is that a test for dir-deltas
 * was the first user of this editor.
 */
svn_error_t *
dir_delta_get_editor(const svn_delta_editor_t **editor,
                     void **edit_baton,
                     svn_fs_t *fs,
                     svn_fs_root_t *txn_root,
                     const char *path,
                     apr_pool_t *pool);


#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif /* SVN_TEST__DIR_DELTA_EDITOR_H */
