#ifndef _SubtitleView_h
#define _SubtitleView_h

/*
 *  subtitle editor
 *
 *	http://kitone.free.fr/subtitleeditor/
 *
 *	Copyright @ 2005-2006, kitone
 *
 *  Contact: kitone at free dot fr
 *
 *  This program is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU General Public
 *  License as published by the Free Software Foundation; either
 *  version 2 of the License, or (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public
 *  License along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 *  See gpl.txt for more information regarding the GNU General Public License.
 *
 *
 *  \file
 *  \brief 
 *  \author kitone (kitone at free dot fr)
 */

#include <gtkmm/treeview.h>
#include <libglademm.h>
#include "SubtitleModel.h"
#include "Document.h"

/*
 *
 */
class SubtitleView : public Gtk::TreeView
{
public:
  SubtitleView(BaseObjectType* cobject, const Glib::RefPtr<Gnome::Glade::Xml>& refGlade);

	void loadCfg();
	void saveCfg();

  /*
   *  create columns
   */
  void createColumnNum();
	void createColumnLayer();
  void createColumnStart();
  void createColumnEnd();
	void createColumnStyle();
  void createColumnName();
  void createColumnMarginR();
  void createColumnMarginL();
  void createColumnMarginV();
	void createColumnEffect();
  void createColumnText();
	void createColumnTranslation();
 
  
  /*
   *
   */
  Gtk::TreeIter   getSelected();

	/*
	 *
	 */
	void on_selection_changed();

	/*
	 *
	 */
  void on_edited_layer(const Glib::ustring &path, const Glib::ustring &newtext);

	/*
   * callback utiliser pour modifier le temps directement depuis la list (treeview)
   */
  void on_edited_start(const Glib::ustring &path, const Glib::ustring &newtext);

  /*
   *  callback utiliser pour modifier le temps directement depuis la list (treeview)
   */
  void on_edited_end(const Glib::ustring &path, const Glib::ustring &newtext);
  
  /*
   *  callback utiliser pour modifier le texte directement depuis la list (treeview)
   */
  void on_edited_text(const Glib::ustring &path, const Glib::ustring &newtext);

  void on_edited_translation(const Glib::ustring &path, const Glib::ustring &newtext);
  void on_edited_effect(const Glib::ustring &path, const Glib::ustring &newtext);

	/*
	 *	callback utiliser pour modifier le style (a partir d'un menu, cell renderer combo)
	 */
  void on_edited_style(const Glib::ustring &path, const Glib::ustring &newstyle);

	/*
	 *	callback utiliser pour modifier le nom (a partir d'un menu, cell renderer combo)
	 */
  void on_edited_name(const Glib::ustring &path, const Glib::ustring &newstyle);

	/*
	 * 
	 */
  void on_edited_margin_l(const Glib::ustring &path, const Glib::ustring &value);
  void on_edited_margin_r(const Glib::ustring &path, const Glib::ustring &value);
  void on_edited_margin_v(const Glib::ustring &path, const Glib::ustring &value);

	/*
	 *
	 */
  void select_and_set_cursor(const Gtk::TreeIter &iter);


	/*
	 *	passe d'une vue simple pour le format SRT 
	 *	a la vue total (SSA)
	 *	afficher certaine colonne ou non
	 *	"srt" ou "ssa"
	 */
	void set_view_type(const Glib::ustring &type);
	

	/*
	 *
	 */
	void set_column_visible(const Glib::ustring& name, bool state);

	/*
	 *
	 */
	bool get_column_visible(const Glib::ustring &name);

	/*
	 *
	 */
	//bool on_key_press_event(GdkEventKey *event);
	//void editing_start(Gtk::CellEditable* cell, const Glib::ustring &path);
	//bool entry_key_press_event(GdkEventKey *ev);
protected:
	
	Document*			m_refDocument;
	
  SubtitleColumnRecorder      m_column;
  
	Glib::RefPtr<SubtitleModel> m_subtitleModel;
	Glib::RefPtr<StyleModel> m_styleModel;

	// pointe sur les columns par rapport a leur nom
	std::map<Glib::ustring, Gtk::TreeViewColumn*>	m_columns;
};


#endif//_SubtitleView_h
