#ifndef _SubtitleASS_h
#define _SubtitleASS_h

/*
 *	subtitle editor
 *
 *	http://kitone.free.fr/subtitleeditor/
 *
 *	Copyright @ 2005-2006, kitone
 *
 *	Contact: kitone at free dot fr
 *
 *	This program is free software; you can redistribute it and/or
 *	modify it under the terms of the GNU General Public
 *	License as published by the Free Software Foundation; either
 *	version 2 of the License, or (at your option) any later version.
 *
 *	This program is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	See the GNU
 *	General Public License for more details.
 *
 *	You should have received a copy of the GNU General Public
 *	License along with this program; if not, write to the Free Software
 *	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA	02111-1307	USA
 *
 *	See gpl.txt for more information regarding the GNU General Public License.
 *
 *
 *	\file
 *	\brief 
 *	\author kitone (kitone at free dot fr)
 */

#include "Document.h"
#include "SubtitleFormat.h"


class SubtitleASS : public SubtitleFormat
{
public:
	SubtitleASS(Document *doc);
	~SubtitleASS();

	/*
	 *
	 */
	bool open(const Glib::ustring &filename, const Glib::ustring &encoding);

	/*
	 *
	 */
	bool save(const Glib::ustring &filename, const Glib::ustring &encoding);

	/*
	 *
	 */
	static Glib::ustring get_name();
	
	/*
	 *
	 */
	static bool check(const std::string &line);

	/*
	 *
	 */
	static Glib::ustring get_extension();
	
	/*
	 *	READ BLOCK
	 */
	
	/*
	 *
	 */
	bool readScripInfo(std::ifstream &file);

	/*
	 *
	 */
	bool readStyles(std::ifstream &file);

	/*
	 *
	 */
	bool readEvents(std::ifstream &file);


protected:

	/*
	 *	
	 */
	std::vector< std::string > build(const std::string &line, unsigned int column);

	/*
	 *	convertir le temps utiliser par subtitle editor en tant valide pour le format ASS
	 *	hours:mins:secs,msecs -> hours:mins:secs.msecs
	 */
	Glib::ustring convert_time_for_save(const Glib::ustring &time);

	/*
	 *	hours:mins:secs.msecs -> hours:mins:secs,msecs
	 */
	Glib::ustring convert_time_for_subtitleeditor(const Glib::ustring &time);
	
	/*
	 *
	 */
	Glib::ustring clean_style_name(const Glib::ustring &name);

	/*
	 *
	 */
	std::vector<std::string> build_format(const std::string &text, int column=-1, bool remove_space=false);

	/*
	 *	-1=true
	 *	0=false
	 */
	bool str2bool(const std::string &str);
	
protected:
	ScriptInfo* m_scriptInfo;

	Glib::RefPtr<SubtitleModel> m_model;
	Glib::RefPtr<StyleModel> m_style_model;
};

#endif//_SubtitleASS_h

