/*
 *	subtitle editor
 *
 *	http://kitone.free.fr/subtitleeditor/
 *
 *	Copyright @ 2005-2006, kitone
 *
 *	Contact: kitone at free dot fr
 *
 *	This program is free software; you can redistribute it and/or
 *	modify it under the terms of the GNU General Public
 *	License as published by the Free Software Foundation; either
 *	version 2 of the License, or (at your option) any later version.
 *
 *	This program is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	See the GNU
 *	General Public License for more details.
 *
 *	You should have received a copy of the GNU General Public
 *	License along with this program; if not, write to the Free Software
 *	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA	02111-1307	USA
 *
 *	See gpl.txt for more information regarding the GNU General Public License.
 *
 *
 *	\file
 *	\brief 
 *	\author kitone (kitone at free dot fr)
 */


#include "GstMedia.h"
#include <gst/interfaces/xoverlay.h>
#include <gst/interfaces/colorbalance.h>
#include <iostream>
#include "Config.h"


GstMedia::GstMedia(const Glib::ustring &uri)
:GstLaunch(80), m_audiosink(NULL), m_videosink(NULL)
{
	gchar *pipe = g_strdup_printf("playbin uri=%s", uri.c_str());
	
	if(parse(pipe))
	{
		// config
		Glib::ustring audiosink, videosink;

		Config &cfg = Config::getInstance();
		
		if(!cfg.get_value_string("timing-system", "audio-sink", audiosink))
			audiosink = "autoaudiosink";
		if(!cfg.get_value_string("timing-system", "video-sink", videosink))
			videosink = "autovideosink";

		//
		m_audiosink = gst_element_factory_make(audiosink.c_str(), "audiosink");

		m_videosink = gst_element_factory_make(videosink.c_str(), "videosink");

		// TODO check m_audiosink & m_videosink

		
		g_object_set(G_OBJECT(m_pipeline), 
			"video-sink", m_videosink, 
			"audio-sink", m_audiosink, 
			NULL);

		g_object_set(G_OBJECT(m_videosink),
				//"brightness",100,
				"force-aspect-ratio", TRUE,
				NULL);

		ready();

	}
	
	g_free(pipe);
}

GstMedia::~GstMedia()
{
	if(m_videosink && GST_IS_X_OVERLAY(m_videosink))
	{
		gst_x_overlay_set_xwindow_id(GST_X_OVERLAY(m_videosink), 0);
	}
}

GstElement* GstMedia::getAudioSink()
{
	return m_audiosink;
}

GstElement* GstMedia::getVideoSink()
{
	return m_videosink;
}

