#ifndef _Document_h
#define _Document_h

/*
 *	subtitle editor
 *
 *	http://kitone.free.fr/subtitleeditor/
 *
 *	Copyright @ 2005-2006, kitone
 *
 *	Contact: kitone at free dot fr
 *
 *	This program is free software; you can redistribute it and/or
 *	modify it under the terms of the GNU General Public
 *	License as published by the Free Software Foundation; either
 *	version 2 of the License, or (at your option) any later version.
 *
 *	This program is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	See the GNU
 *	General Public License for more details.
 *
 *	You should have received a copy of the GNU General Public
 *	License along with this program; if not, write to the Free Software
 *	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA	02111-1307	USA
 *
 *	See gpl.txt for more information regarding the GNU General Public License.
 *
 *
 *	\file
 *	\brief 
 *	\author kitone (kitone at free dot fr)
 */

#include "SubtitleModel.h"
#include "StyleModel.h"
#include "ScriptInfo.h"

/*
 *
 */
class Document
{
public:
	
	/*
	 *	constructeur par copy
	 */
	Document(Document &copy);

	/*
	 *	constructeur
	 *	s'il y a une option dans le fichier config [encodings] default=xxxx
	 *	on l'utilise pour choisir le charset, sinon on utilise UTF-8
	 */
	Document();

	/*
	 *	destructeur
	 */
	~Document();

	/*
	 *	efface les informations :
	 *	 - script info
	 *	 - subtitle model
	 *	 - style model
	 *	
	 *	reinitialize le charset
	 */
	void clear();

	/*
	 *	SubRip, MicroDVD, ...
	 */
	Glib::ustring getFormat();
	
	/*
	 *	retourne le charset (encodage) du document
	 *	a permet de sauvegarder dans le meme encodage qu'a la lecture
	 *	...
	 */
	Glib::ustring getCharset();

	
	/*
	 *	encodings ""=auto, "UTF-8", ...
	 *	clear permet d'effacer l'ancien model, sinon on ajoute a la suite du document	
	 */
	bool open(const Glib::ustring &filename, const Glib::ustring &encoding="", bool clear=true);

	/*
	 *	format "SubRip", "MicroDVD", "MPL2", ...
	 *	encodings ""=auto, "UTF-8", ...
	 *	rename, change le nom du document (filenameDocument)
	 */
	bool save(const Glib::ustring &filename, const Glib::ustring &format, const Glib::ustring &encoding="", bool rename=true);


	/*
	 *	retourne le model pour la gestion des sous-titres
	 *	on passe par un model (gtk) pour eviter d'avoir des doublons 
	 *	dans les donnes et donc une grosse consomation memoire (inutile)
	 */
	Glib::RefPtr<SubtitleModel> get_subtitle_model();

	/*
	 *	retourne le model pour la gestion des styles
	 */
	Glib::RefPtr<StyleModel> get_style_model();

	/*
	 *	retourne les informations sur le script 
	 *	principalement pour SSA/ASS
	 */
	ScriptInfo& get_script_info();

protected:
	bool _open(const Glib::ustring &filename, const Glib::ustring &encoding="", bool clear=true);
	bool _save(const Glib::ustring &filename, const Glib::ustring &format, const Glib::ustring &encoding="", bool clear=true);
	
public:
	Glib::ustring									m_format;
	std::string										m_charset;
	ScriptInfo										m_scriptInfo;
	Glib::RefPtr<SubtitleModel>		m_subtitleModel;
	Glib::RefPtr<StyleModel>			m_styleModel;
	//Glib::RefPtr<NameModel>			m_nameModel;

	// filename movie, ...
	Glib::ustring filenameDocument;
	Glib::ustring m_uriMovie;
};

#endif//_Document_h

