#ifdef ENABLE_ASPELL

/*
 *	subtitle editor
 *
 *	http://kitone.free.fr/subtitleeditor/
 *
 *	Copyright @ 2005-2006, kitone
 *
 *	Contact: kitone at free dot fr
 *
 *	This program is free software; you can redistribute it and/or
 *	modify it under the terms of the GNU General Public
 *	License as published by the Free Software Foundation; either
 *	version 2 of the License, or (at your option) any later version.
 *
 *	This program is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	See the GNU
 *	General Public License for more details.
 *
 *	You should have received a copy of the GNU General Public
 *	License along with this program; if not, write to the Free Software
 *	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA	02111-1307	USA
 *
 *	See gpl.txt for more information regarding the GNU General Public License.
 *
 *
 *	\file
 *	\brief 
 *	\author kitone (kitone at free dot fr)
 */

#include "ASpell.h"
#include <iostream>


ASpell::ASpell()
{
	m_ret = NULL;
	m_speller = NULL;
	m_config = NULL;

	//init("francais");
	init("fr_FR");
}

ASpell::~ASpell()
{
	close();
}

bool ASpell::init(const Glib::ustring &lang)
{
	// cration de la configuration
	m_config = new_aspell_config();
	aspell_config_replace(m_config, "lang", lang.c_str());
	aspell_config_replace(m_config, "encoding", "UTF-8");

	// init.
	m_ret = new_aspell_speller(m_config);

	//delete_aspell_config(m_config);

	if(aspell_error(m_ret) != 0)
	{
		std::cerr << aspell_error_message(m_ret);
		delete_aspell_can_have_error(m_ret);
		return false;
	}

	m_speller = to_aspell_speller(m_ret);
	// voir la config...
	//m_config = aspell_speller_config(speller);
	//
	return true;
}

bool ASpell::close()
{
	aspell_speller_save_all_word_lists(m_speller);

	delete_aspell_config(m_config);
	delete_aspell_speller(m_speller);

	return true;
}

ASpell::SPELL_RESPONSE ASpell::check(const Glib::ustring &word, std::list<Glib::ustring> &suggestions)
{
	int correct = aspell_speller_check(m_speller,word.c_str(), word.size());
	
	//std::cout << "check: " << word << " : " << correct << std::endl;

	if(correct == 1)
		return SPELL_CORRECT;
	if(correct == -1)
		return SPELL_ERROR;
	if(correct == 0)
	{
		const AspellWordList *wl = aspell_speller_suggest(
				m_speller, word.c_str(), word.size());

		if(wl == NULL)
		{
			std::cerr << aspell_speller_error_message(m_speller);
			return SPELL_NO_SUGGESTION;
		}
		else
		{
			AspellStringEnumeration *els = aspell_word_list_elements(wl);
			const char *wrd = NULL;
			while((wrd=aspell_string_enumeration_next(els)) != NULL)
			{
				//std::cout << ":" << wrd << std::endl;
				suggestions.push_back(wrd);
			}

			delete_aspell_string_enumeration(els);
			return SPELL_SUGGESTION;
		}
	}
	return SPELL_ERROR;
}

/*
 *	on demande d'ignorer ce mot jusqu'a la fin.
 */
bool ASpell::ignore_word(const Glib::ustring &word)
{
	//if(word.size()<3) return false;
	g_return_val_if_fail(m_speller, false);

	aspell_speller_add_to_session(m_speller, word.c_str(), word.size());
	return true;
}

/*
 *	on ajoute ce mot dans notre dico
 */
bool ASpell::add_word(const Glib::ustring &word)
{
	g_return_val_if_fail(m_speller, false);
	
	aspell_speller_add_to_personal(m_speller, word.c_str(), word.size());
	return true;
}

/*
 *	recupere tout les dico
 */
bool ASpell::get_list_dict(std::list<Glib::ustring> &dicts)
{
	const AspellDictInfoList *dlist = NULL;
	AspellDictInfoEnumeration *dels = NULL;
	const AspellDictInfo *entry = NULL;

	dlist = get_aspell_dict_info_list(m_config);

	dels = aspell_dict_info_list_elements(dlist);
	while((entry = aspell_dict_info_enumeration_next(dels)) != NULL)
	{
		Glib::ustring str;
		//str+=(entry->code);
		//str+=" - ";
		str+=entry->name;
		/*
		str+=" - ";
		str+=entry->jargon;
		str+=" - ";
		str+=entry->module->name;
		*/
		dicts.push_back(str);
	}

	delete_aspell_dict_info_enumeration(dels);
	
	return true;
}

/*
 *
 */
bool ASpell::set_dict(const Glib::ustring &dict)
{
	close();
	init(dict);
	//aspell_config_replace(m_config, "lang", dict.c_str());
	return true;
}

/*
 *
 */
Glib::ustring ASpell::get_dict()
{
	Glib::ustring dict;
	//dict+= aspell_config_retrieve(m_config, "personnal");
	//dict+=" - ";
	dict+= aspell_config_retrieve(m_config, "lang");

	return dict;
}


#endif//ENABLE_ASPELL
