#ifndef _INPUT_BLC_H
#define _INPUT_BLC_H

#include <stdio.h>
#include <stdlib.h>

#include "subread.h"
#include "seek-zlib.h"

#define INPUT_BLC_MAX_READS 20

typedef struct {
	unsigned long long read_number;
	int total_bases_in_each_cluster;
	int single_read_lengths[INPUT_BLC_MAX_READS+1];
	int single_read_is_index[INPUT_BLC_MAX_READS];
	int current_lane, bcl_is_gzipped, filter_is_gzipped;
	char bcl_format_string[MAX_FILE_NAME_LENGTH];
	char filter_format_string[MAX_FILE_NAME_LENGTH];
	union{
		seekable_zfile_t ** bcl_gzip_fps; 
		FILE ** bcl_fps; 
	};
	union{
		seekable_zfile_t *  filter_gzip_fp;
		FILE *  filter_fp;
	};
	subread_lock_t read_lock;
} input_BLC_t;

int input_BLC_init( input_BLC_t * blc_input , char * data_dir );
int input_BLC_next_read( input_BLC_t * blc_input, char * readname , char * read, char * qual );
int input_BLC_tell ( input_BLC_t * blc_input , input_BLC_pos_t * pos );
int input_BLC_seek ( input_BLC_t * blc_input , input_BLC_pos_t * pos );
void input_BLC_close (input_BLC_t * blc_input);
#endif
