#!/usr/bin/env python
# -*- coding: utf-8 -*-

#    Copyright (C) 2007 Ivan Garcia capiscuas@gmail.com
#    This program is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 3 of the License, or
#    (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License along
#    with this program; if not, write to the Free Software Foundation, Inc.,
#    see <http://www.gnu.org/licenses/>.
'''
FileManagement package
'''
import re, string

def get_extension(path):
    if re.search("\.\w+$", path):
        return re.search("\w+$", path).group(0)
    return ""

def clear_string(strng):
    r_chars = string.punctuation
    return strng.translate(string.maketrans(r_chars," "*len(r_chars))).replace(" ", "")
    
def without_extension(filename):
    ext = get_extension(filename)
    return filename.replace("."+ext, "")
