/* ====================================================================
 * Copyright (c) 2006-2008  Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

#ifndef _SC_BOOKMARK_H
#define _SC_BOOKMARK_H

// sc
class Project;
#include "util/String.h"
#include "util/Id.h"

// qt
#include <QtCore/QVariant>


class Bookmark
{
public:
  Bookmark( Project* prj );
  Bookmark( Project* prj, long prjItemId, ID parent );

  ID getId() const;
  ID getParentId() const;

  Project* getProject();
  long getPrjItemId();

  const sc::String& getName() const;
  const sc::String& getSource() const;
  const sc::String& getUrl() const;
  void setName( const sc::String& name );
  void setSource( const sc::String& name );

  bool isProject() const;
  long getSortPos() const;
  bool isWorkingCopy() const;
  bool isRepository() const;
  bool isTrunk() const;
  bool isBranches() const;
  bool isTags() const;
  bool isRemote() const;
  bool isVisible() const;

  // working copy
  bool isCurrent() const;
  void setCurrent();
  virtual bool getUpdate() const;
  void setUpdate( bool );
  bool getAutoUpdate() const;
  void setAutoUpdate( bool );
  bool getRecursive() const;
  void setRecursive( bool );
  bool getAutoRefresh();
  void setAutoRefresh( bool );

  void setRunning(bool);
  bool isRunning() const;

  void setViewHeader( const sc::String& header );
  sc::String getViewHeader();

private:
  ID         _id;
  ID         _idParent;

  Project*   _prj;
  long       _prjItemId;

  int        _running;
  mutable sc::String _url;   ///< cached url.
};

/** make @a Bookmark* type available to QVariant. */
Q_DECLARE_METATYPE(Bookmark*);

#endif //  _SC_BOOKMARK_H
