/* ====================================================================
 * Copyright (c) 2008  Martin Hauner
 *                     http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

#ifndef _TESTREPOSITORY_H
#define _TESTREPOSITORY_H

// util
#include "util/apr.h"
#include "util/String.h"


class TestRepository
{
public:
  TestRepository( const sc::String& name );

  /** create test repository and working copy on disk. */
  void setup();
  /** remove test repository and working copy from disk. */
  void cleanup();

private:
  void createTestDir();
  void createRepository();
  void createWorkingCopy();
  void removeTestDir();

  apr::Pool  _pool;
  sc::String _name;       ///< target path, child of _base 

  sc::String _base;       ///< child of _cd
  sc::String _repos;      ///< relative path
  sc::String _wc;         ///< relative path
  sc::String _cd;         ///< current dir

  sc::String _reposUrl;   ///< file url
  sc::String _wcPath;     ///< full path
};

#endif //_TESTREPOSITORY_H
