/* ====================================================================
 * Copyright (c) 2007, 2008  Martin Hauner
 *                           http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

#ifndef _SC_WCVIEWTREEITEMMODEL_H
#define _SC_WCVIEWTREEITEMMODEL_H

// sc
#include "WcViewItem.h"
#include "util/String.h"
class WcViewTreeItemModelMember;
class WcViewTreeItemFolder;

// qt
#include <QtCore/QAbstractItemModel>


/**
 * Item model for WcViewTree.
 */
class WcViewTreeItemModel : public QAbstractItemModel
{
  typedef QAbstractItemModel super;
  Q_OBJECT

public:
  /** Custom Roles. */
  enum Roles {
    WcViewItemRole = Qt::UserRole,
    DeepRole,
    NameRole,
    DragRole,
    DirRole
  };

  WcViewTreeItemModel( const sc::String& root, const WcViewItemData* data );
  ~WcViewTreeItemModel();

  // QAbstractItemModel
  QModelIndex index( int row, int column, const QModelIndex& parent ) const;
  QModelIndex parent( const QModelIndex& index ) const;
  int columnCount( const QModelIndex& parent ) const;
  int rowCount( const QModelIndex& parent ) const;
  QVariant headerData( int section, Qt::Orientation orientation, int role ) const;
  QVariant data( const QModelIndex& index, int role ) const;
  Qt::ItemFlags flags( const QModelIndex &index ) const;

  /** find row index of @a name. The index is invalid if the item was not found. */
  QModelIndex index( const sc::String& name ) const;
  
  /** Set the @a deepStatus of @a path. Returns true if set, else false. */
  bool setDeepStatus( const sc::String& path, bool deepStatus );

public slots:
  /** add the @a WcViewItems entries for @a path to the model. */
  void add( const sc::String& path, const WcViewItems&, bool deepStatus );
  /** remove the @a WcStatuss entries from the model. */
  void remove( const sc::String& path );
  
private:
  void remove( WcViewTreeItemFolder* folder );

  WcViewTreeItemModelMember* _m;
  const WcViewItemData*      _data;
};

#endif // _SC_WCVIEWTREEITEMMODEL_H
