/* ====================================================================
 * Copyright (c) 2008        Martin Hauner
 *                           http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

#ifndef _WCVIEWITEM_H
#define _WCVIEWITEM_H

// sc
namespace sc {
  class String;
}

// qt
#include <QtCore/QString>
#include <QtCore/QVariant>
#include <QtGui/QColor>

// boost
#include <boost/shared_ptr.hpp>

// sys
#include <vector>


/** WcViewTreeModel item interface. */
class WcViewItem
{
public:
  virtual bool isDir() const = 0;
  virtual const sc::String& path() const = 0;
};

typedef boost::shared_ptr<WcViewItem> WcViewItemPtr;
typedef std::vector< WcViewItemPtr >  WcViewItems;

/** make available to QVariant. */
Q_DECLARE_METATYPE(const WcViewItem*);

/** make available to QVariant. */
Q_DECLARE_METATYPE(sc::String);


/** WcViewItemData interface, used to get data from a WcViewItem. */
class WcViewItemData
{
public:
  /** return the data for @a column. */
  virtual QString data( int column, const WcViewItem* ) const = 0;

  /** return the status color. */
  virtual QColor color( int column, const WcViewItem* ) const = 0;

  /** return the header string for @a column. */
  virtual QString header( int column ) const = 0;

  /** return alignment for @a column. */
  virtual Qt::Alignment alignment( int column ) const = 0;

  /** return the number of columns. */
  virtual int columns() const = 0;

  /** is @a column the "deep" column. */
  virtual bool deep( int column ) const = 0;
};


#endif //  _WCVIEWITEM_H
