/* ------------------------------------------------------------------------ */
/*                                                                          */
/* [styx_int.c]               Language Interface                            */
/*                                                                          */
/* ------------------------------------------------------------------------ */

#include "ptm.h"
#include "gls.h"

/*I--------------------- symbol objects - init & quit --------------------- */

static symbol* CfgSyms = (symbol*)NULL;
static symbol* PrdSyms = (symbol*)NULL;
static int initcount_styx = 0;

void styx_initSymbols()
{
  if( initcount_styx == 0 )
  {
    GLS_init();
    assert0(CfgSyms == (symbol*)NULL,"styxSymbols already initialized");
    CfgSyms = (symbol*)NewMem(sizeof(symbol)*97);
    PrdSyms = (symbol*)NewMem(sizeof(symbol)*102);

    CfgSyms[0] = stringToSymbol("Parenthesis");
    CfgSyms[1] = stringToSymbol("Comment");
    CfgSyms[2] = stringToSymbol("Ide");
    CfgSyms[3] = stringToSymbol("Nat");
    CfgSyms[4] = stringToSymbol("Opr");
    CfgSyms[5] = stringToSymbol("Set");
    CfgSyms[6] = stringToSymbol("Seq");
    CfgSyms[7] = stringToSymbol("MacInc");
    CfgSyms[8] = stringToSymbol("MacDel");
    CfgSyms[9] = stringToSymbol("MacDfn");
    CfgSyms[10] = stringToSymbol("MacSep");
    CfgSyms[11] = stringToSymbol("MacCond");
    CfgSyms[12] = stringToSymbol("Language");
    CfgSyms[13] = stringToSymbol("Context");
    CfgSyms[14] = stringToSymbol("Free");
    CfgSyms[15] = stringToSymbol("Grammar");
    CfgSyms[16] = stringToSymbol("Regular");
    CfgSyms[17] = stringToSymbol("=");
    CfgSyms[18] = stringToSymbol("tok");
    CfgSyms[19] = stringToSymbol("<");
    CfgSyms[20] = stringToSymbol(">");
    CfgSyms[21] = stringToSymbol("InGroup");
    CfgSyms[22] = stringToSymbol("ExGroup");
    CfgSyms[23] = stringToSymbol("[");
    CfgSyms[24] = stringToSymbol("]");
    CfgSyms[25] = stringToSymbol("Group");
    CfgSyms[26] = stringToSymbol("let");
    CfgSyms[27] = stringToSymbol("ign");
    CfgSyms[28] = stringToSymbol("com");
    CfgSyms[29] = stringToSymbol("lan");
    CfgSyms[30] = stringToSymbol("ind");
    CfgSyms[31] = stringToSymbol(":");
    CfgSyms[32] = stringToSymbol("!");
    CfgSyms[33] = stringToSymbol("!+");
    CfgSyms[34] = stringToSymbol("!-");
    CfgSyms[35] = stringToSymbol("ica");
    CfgSyms[36] = stringToSymbol("/");
    CfgSyms[37] = stringToSymbol("?");
    CfgSyms[38] = stringToSymbol("|");
    CfgSyms[39] = stringToSymbol("-");
    CfgSyms[40] = stringToSymbol(",");
    CfgSyms[41] = stringToSymbol("{");
    CfgSyms[42] = stringToSymbol("}");
    CfgSyms[43] = stringToSymbol("*");
    CfgSyms[44] = stringToSymbol("+");
    CfgSyms[45] = stringToSymbol("..");
    CfgSyms[46] = stringToSymbol("(");
    CfgSyms[47] = stringToSymbol(")");
    CfgSyms[48] = stringToSymbol("xtop");
    CfgSyms[49] = stringToSymbol("start");
    CfgSyms[50] = stringToSymbol("err");
    CfgSyms[51] = stringToSymbol("other");
    CfgSyms[52] = stringToSymbol("...");
    CfgSyms[53] = stringToSymbol(".");
    CfgSyms[54] = stringToSymbol("reduce");
    CfgSyms[55] = stringToSymbol("Source");
    CfgSyms[56] = stringToSymbol("OptCfg");
    CfgSyms[57] = stringToSymbol("QlxDfns0");
    CfgSyms[58] = stringToSymbol("QlxDfns");
    CfgSyms[59] = stringToSymbol("QlxDfn");
    CfgSyms[60] = stringToSymbol("Ids0");
    CfgSyms[61] = stringToSymbol("Ids");
    CfgSyms[62] = stringToSymbol("QlxCat");
    CfgSyms[63] = stringToSymbol("QlxGrp");
    CfgSyms[64] = stringToSymbol("QlxGrp0");
    CfgSyms[65] = stringToSymbol("QlxGrp1");
    CfgSyms[66] = stringToSymbol("QlxOpt");
    CfgSyms[67] = stringToSymbol("ExpQuot");
    CfgSyms[68] = stringToSymbol("ExpDyck");
    CfgSyms[69] = stringToSymbol("Exp0");
    CfgSyms[70] = stringToSymbol("Exp");
    CfgSyms[71] = stringToSymbol("Exp1");
    CfgSyms[72] = stringToSymbol("OptNat");
    CfgSyms[73] = stringToSymbol("Limit");
    CfgSyms[74] = stringToSymbol("Exp2");
    CfgSyms[75] = stringToSymbol("Exp3");
    CfgSyms[76] = stringToSymbol("Exp4");
    CfgSyms[77] = stringToSymbol("Dfns");
    CfgSyms[78] = stringToSymbol("Dfn");
    CfgSyms[79] = stringToSymbol("Cat0");
    CfgSyms[80] = stringToSymbol("Cat");
    CfgSyms[81] = stringToSymbol("DfnOpt");
    CfgSyms[82] = stringToSymbol("Prds");
    CfgSyms[83] = stringToSymbol("Lay");
    CfgSyms[84] = stringToSymbol("Prd");
    CfgSyms[85] = stringToSymbol("Mbrs");
    CfgSyms[86] = stringToSymbol("Mbr");
    CfgSyms[87] = stringToSymbol("Mbr1");
    CfgSyms[88] = stringToSymbol("OptKey");
    CfgSyms[89] = stringToSymbol("Conflicts");
    CfgSyms[90] = stringToSymbol("Conflict");
    CfgSyms[91] = stringToSymbol("State");
    CfgSyms[92] = stringToSymbol("Token");
    CfgSyms[93] = stringToSymbol("Rules0");
    CfgSyms[94] = stringToSymbol("Rules");
    CfgSyms[95] = stringToSymbol("Rule");
    CfgSyms[96] = stringToSymbol("styx");

    PrdSyms[0] = stringToSymbol("root");
    PrdSyms[1] = stringToSymbol("non");
    PrdSyms[2] = stringToSymbol("cfg");
    PrdSyms[3] = stringToSymbol("nil");
    PrdSyms[4] = stringToSymbol("ign0");
    PrdSyms[5] = stringToSymbol("nil");
    PrdSyms[6] = stringToSymbol("cons");
    PrdSyms[7] = stringToSymbol("defn");
    PrdSyms[8] = stringToSymbol("defd");
    PrdSyms[9] = stringToSymbol("igrp");
    PrdSyms[10] = stringToSymbol("xgrp");
    PrdSyms[11] = stringToSymbol("tgrp");
    PrdSyms[12] = stringToSymbol("mgrp");
    PrdSyms[13] = stringToSymbol("nil");
    PrdSyms[14] = stringToSymbol("cons");
    PrdSyms[15] = stringToSymbol("cons");
    PrdSyms[16] = stringToSymbol("letC");
    PrdSyms[17] = stringToSymbol("tokC");
    PrdSyms[18] = stringToSymbol("ignC");
    PrdSyms[19] = stringToSymbol("comC");
    PrdSyms[20] = stringToSymbol("lanC");
    PrdSyms[21] = stringToSymbol("indC");
    PrdSyms[22] = stringToSymbol("non");
    PrdSyms[23] = stringToSymbol("grp");
    PrdSyms[24] = stringToSymbol("ign0");
    PrdSyms[25] = stringToSymbol("grp");
    PrdSyms[26] = stringToSymbol("igrp");
    PrdSyms[27] = stringToSymbol("pgrp");
    PrdSyms[28] = stringToSymbol("pigrp");
    PrdSyms[29] = stringToSymbol("pop");
    PrdSyms[30] = stringToSymbol("ign0");
    PrdSyms[31] = stringToSymbol("non");
    PrdSyms[32] = stringToSymbol("ignca");
    PrdSyms[33] = stringToSymbol("quot");
    PrdSyms[34] = stringToSymbol("ign0");
    PrdSyms[35] = stringToSymbol("dyck");
    PrdSyms[36] = stringToSymbol("spat");
    PrdSyms[37] = stringToSymbol("epat");
    PrdSyms[38] = stringToSymbol("ign0");
    PrdSyms[39] = stringToSymbol("non");
    PrdSyms[40] = stringToSymbol("ign0");
    PrdSyms[41] = stringToSymbol("union");
    PrdSyms[42] = stringToSymbol("diff");
    PrdSyms[43] = stringToSymbol("ign1");
    PrdSyms[44] = stringToSymbol("conc");
    PrdSyms[45] = stringToSymbol("ign1");
    PrdSyms[46] = stringToSymbol("non");
    PrdSyms[47] = stringToSymbol("nat");
    PrdSyms[48] = stringToSymbol("ntime");
    PrdSyms[49] = stringToSymbol("range");
    PrdSyms[50] = stringToSymbol("opt");
    PrdSyms[51] = stringToSymbol("star");
    PrdSyms[52] = stringToSymbol("plus0");
    PrdSyms[53] = stringToSymbol("plus");
    PrdSyms[54] = stringToSymbol("plusn");
    PrdSyms[55] = stringToSymbol("ign1");
    PrdSyms[56] = stringToSymbol("ign1");
    PrdSyms[57] = stringToSymbol("range");
    PrdSyms[58] = stringToSymbol("ign2");
    PrdSyms[59] = stringToSymbol("sequ");
    PrdSyms[60] = stringToSymbol("set");
    PrdSyms[61] = stringToSymbol("ident");
    PrdSyms[62] = stringToSymbol("nil");
    PrdSyms[63] = stringToSymbol("cons");
    PrdSyms[64] = stringToSymbol("defn");
    PrdSyms[65] = stringToSymbol("bgnC");
    PrdSyms[66] = stringToSymbol("letC");
    PrdSyms[67] = stringToSymbol("bgnC");
    PrdSyms[68] = stringToSymbol("ign0");
    PrdSyms[69] = stringToSymbol("non");
    PrdSyms[70] = stringToSymbol("errnt");
    PrdSyms[71] = stringToSymbol("nil");
    PrdSyms[72] = stringToSymbol("cons");
    PrdSyms[73] = stringToSymbol("dft");
    PrdSyms[74] = stringToSymbol("rec");
    PrdSyms[75] = stringToSymbol("grp");
    PrdSyms[76] = stringToSymbol("prod");
    PrdSyms[77] = stringToSymbol("nil");
    PrdSyms[78] = stringToSymbol("cons");
    PrdSyms[79] = stringToSymbol("tkm");
    PrdSyms[80] = stringToSymbol("else");
    PrdSyms[81] = stringToSymbol("ign0");
    PrdSyms[82] = stringToSymbol("ntm");
    PrdSyms[83] = stringToSymbol("klst0");
    PrdSyms[84] = stringToSymbol("klst1");
    PrdSyms[85] = stringToSymbol("opt");
    PrdSyms[86] = stringToSymbol("dtok");
    PrdSyms[87] = stringToSymbol("nil");
    PrdSyms[88] = stringToSymbol("cons");
    PrdSyms[89] = stringToSymbol("nil");
    PrdSyms[90] = stringToSymbol("cons");
    PrdSyms[91] = stringToSymbol("defn");
    PrdSyms[92] = stringToSymbol("nat");
    PrdSyms[93] = stringToSymbol("seq");
    PrdSyms[94] = stringToSymbol("ide");
    PrdSyms[95] = stringToSymbol("seq");
    PrdSyms[96] = stringToSymbol("ide");
    PrdSyms[97] = stringToSymbol("nil");
    PrdSyms[98] = stringToSymbol("cons");
    PrdSyms[99] = stringToSymbol("cons");
    PrdSyms[100] = stringToSymbol("red");
    PrdSyms[101] = stringToSymbol("Start_Source");
  }
  ++initcount_styx;
}

void styx_quitSymbols()
{
  --initcount_styx;
  if( initcount_styx == 0 )
  {
    assert0(CfgSyms != (symbol*)NULL,"styxSymbols not initialized");
    if( CfgSyms != (symbol*)NULL ) FreeMem(CfgSyms);
    CfgSyms = (symbol*)NULL;
    if( PrdSyms != (symbol*)NULL ) FreeMem(PrdSyms);
    PrdSyms = (symbol*)NULL;
  }
}

/*I-------------------------- Types & Constants --------------------------- */

AbstractType( styx );

AbstractType( styxSource );
AbstractType( styxOptCfg );
AbstractType( styxQlxDfn );
AbstractType( styxQlxCat );
AbstractType( styxQlxGrp );
AbstractType( styxQlxOpt );
AbstractType( styxExp  );
AbstractType( styxOptNat );
AbstractType( styxLimit );
AbstractType( styxDfn  );
AbstractType( styxCat  );
AbstractType( styxDfnOpt );
AbstractType( styxLay  );
AbstractType( styxPrd  );
AbstractType( styxMbr  );
AbstractType( styxConflict );
AbstractType( styxState );
AbstractType( styxToken );
AbstractType( styxRule );

/*I--------------------------- Access to Tokens --------------------------- */

c_bool Tstyx_Ide(GLS_Tok x)
{
  return( PT_THISTOK((PT_Term)x, CfgSyms[2]) );
}

c_bool Tstyx_Nat(GLS_Tok x)
{
  return( PT_THISTOK((PT_Term)x, CfgSyms[3]) );
}

c_bool Tstyx_Set(GLS_Tok x)
{
  return( PT_THISTOK((PT_Term)x, CfgSyms[5]) );
}

c_bool Tstyx_Seq(GLS_Tok x)
{
  return( PT_THISTOK((PT_Term)x, CfgSyms[6]) );
}

/*I--------------------------- Access to Terms ---------------------------- */

c_bool styx_styx(PT_Term x, styx* x1)
{
  if( PT_THISNTM(x, CfgSyms[96]) )
  {
    if( (StdCPtr)x1 != (StdCPtr)NULL ) *x1 = (styx)x;
    return True;
  }
  return False;
}

c_bool styx_Source(PT_Term x, styxSource* x1)
{
  if(  PT_THISNTM(x, CfgSyms[55]) )
  {
    if( (StdCPtr)x1 != (StdCPtr)NULL ) *x1 = (styxSource)x;
    return True;
  }
  return False;
}

c_bool styx_OptCfg(PT_Term x, styxOptCfg* x1)
{
  if(  PT_THISNTM(x, CfgSyms[56]) )
  {
    if( (StdCPtr)x1 != (StdCPtr)NULL ) *x1 = (styxOptCfg)x;
    return True;
  }
  return False;
}

c_bool styx_QlxDfn(PT_Term x, styxQlxDfn* x1)
{
  if(  PT_THISNTM(x, CfgSyms[59]) )
  {
    if( (StdCPtr)x1 != (StdCPtr)NULL ) *x1 = (styxQlxDfn)x;
    return True;
  }
  return False;
}

c_bool styx_QlxCat(PT_Term x, styxQlxCat* x1)
{
  if(  PT_THISNTM(x, CfgSyms[62]) )
  {
    if( (StdCPtr)x1 != (StdCPtr)NULL ) *x1 = (styxQlxCat)x;
    return True;
  }
  return False;
}

c_bool styx_QlxGrp(PT_Term x, styxQlxGrp* x1)
{
  if(  PT_THISNTM(x, CfgSyms[63])
    || PT_THISNTM(x, CfgSyms[64])
    || PT_THISNTM(x, CfgSyms[65]) )
  {
    if( (StdCPtr)x1 != (StdCPtr)NULL ) *x1 = (styxQlxGrp)x;
    return True;
  }
  return False;
}

c_bool styx_QlxOpt(PT_Term x, styxQlxOpt* x1)
{
  if(  PT_THISNTM(x, CfgSyms[66]) )
  {
    if( (StdCPtr)x1 != (StdCPtr)NULL ) *x1 = (styxQlxOpt)x;
    return True;
  }
  return False;
}

c_bool styx_Exp(PT_Term x, styxExp* x1)
{
  if(  PT_THISNTM(x, CfgSyms[69])
    || PT_THISNTM(x, CfgSyms[74])
    || PT_THISNTM(x, CfgSyms[70])
    || PT_THISNTM(x, CfgSyms[67])
    || PT_THISNTM(x, CfgSyms[71])
    || PT_THISNTM(x, CfgSyms[75])
    || PT_THISNTM(x, CfgSyms[68])
    || PT_THISNTM(x, CfgSyms[76]) )
  {
    if( (StdCPtr)x1 != (StdCPtr)NULL ) *x1 = (styxExp)x;
    return True;
  }
  return False;
}

c_bool styx_OptNat(PT_Term x, styxOptNat* x1)
{
  if(  PT_THISNTM(x, CfgSyms[72]) )
  {
    if( (StdCPtr)x1 != (StdCPtr)NULL ) *x1 = (styxOptNat)x;
    return True;
  }
  return False;
}

c_bool styx_Limit(PT_Term x, styxLimit* x1)
{
  if(  PT_THISNTM(x, CfgSyms[73]) )
  {
    if( (StdCPtr)x1 != (StdCPtr)NULL ) *x1 = (styxLimit)x;
    return True;
  }
  return False;
}

c_bool styx_Dfn(PT_Term x, styxDfn* x1)
{
  if(  PT_THISNTM(x, CfgSyms[78]) )
  {
    if( (StdCPtr)x1 != (StdCPtr)NULL ) *x1 = (styxDfn)x;
    return True;
  }
  return False;
}

c_bool styx_Cat(PT_Term x, styxCat* x1)
{
  if(  PT_THISNTM(x, CfgSyms[79])
    || PT_THISNTM(x, CfgSyms[80]) )
  {
    if( (StdCPtr)x1 != (StdCPtr)NULL ) *x1 = (styxCat)x;
    return True;
  }
  return False;
}

c_bool styx_DfnOpt(PT_Term x, styxDfnOpt* x1)
{
  if(  PT_THISNTM(x, CfgSyms[81]) )
  {
    if( (StdCPtr)x1 != (StdCPtr)NULL ) *x1 = (styxDfnOpt)x;
    return True;
  }
  return False;
}

c_bool styx_Lay(PT_Term x, styxLay* x1)
{
  if(  PT_THISNTM(x, CfgSyms[83]) )
  {
    if( (StdCPtr)x1 != (StdCPtr)NULL ) *x1 = (styxLay)x;
    return True;
  }
  return False;
}

c_bool styx_Prd(PT_Term x, styxPrd* x1)
{
  if(  PT_THISNTM(x, CfgSyms[84]) )
  {
    if( (StdCPtr)x1 != (StdCPtr)NULL ) *x1 = (styxPrd)x;
    return True;
  }
  return False;
}

c_bool styx_Mbr(PT_Term x, styxMbr* x1)
{
  if(  PT_THISNTM(x, CfgSyms[87])
    || PT_THISNTM(x, CfgSyms[86]) )
  {
    if( (StdCPtr)x1 != (StdCPtr)NULL ) *x1 = (styxMbr)x;
    return True;
  }
  return False;
}

c_bool styx_Conflict(PT_Term x, styxConflict* x1)
{
  if(  PT_THISNTM(x, CfgSyms[90]) )
  {
    if( (StdCPtr)x1 != (StdCPtr)NULL ) *x1 = (styxConflict)x;
    return True;
  }
  return False;
}

c_bool styx_State(PT_Term x, styxState* x1)
{
  if(  PT_THISNTM(x, CfgSyms[91]) )
  {
    if( (StdCPtr)x1 != (StdCPtr)NULL ) *x1 = (styxState)x;
    return True;
  }
  return False;
}

c_bool styx_Token(PT_Term x, styxToken* x1)
{
  if(  PT_THISNTM(x, CfgSyms[92]) )
  {
    if( (StdCPtr)x1 != (StdCPtr)NULL ) *x1 = (styxToken)x;
    return True;
  }
  return False;
}

c_bool styx_Rule(PT_Term x, styxRule* x1)
{
  if(  PT_THISNTM(x, CfgSyms[95]) )
  {
    if( (StdCPtr)x1 != (StdCPtr)NULL ) *x1 = (styxRule)x;
    return True;
  }
  return False;
}

/*I--------------------------------- styx --------------------------------- */

c_bool styx_Start_Source(styx x, styxSource* x1)
#define styx_Start_0   styx_Start_Source
{
  assert0( PT_THISNTM((PT_Term)x, CfgSyms[96]), "styx expected" );
  if( ! PT_THISPRD((PT_Term)x, PrdSyms[101]) ) return False;
  if( (StdCPtr)x1 != (StdCPtr)NULL )
    *x1 = (styxSource)GLS_ign_Skip(PT_nthSymbol((PT_Term)x, CfgSyms[55], 1, True));
  return True;
}

/*I-------------------------------- Source -------------------------------- */

c_bool styxSource_root(styxSource x, styxOptNat* x1, GLS_Tok* x2,
                       GLS_Lst(styxQlxDfn)* x3, styxOptCfg* x4)
{
  assert0(  PT_THISNTM((PT_Term)x, CfgSyms[55]), "Source expected" );
  if( ! PT_THISPRD((PT_Term)x, PrdSyms[0]) ) return False;
  { PT_Term y;
    if( ! PT_isXaron(x) )
    {
      x = (styxSource)GLS_keycom_Skip(PT_parts(x));
      if( (StdCPtr)x1 != (StdCPtr)NULL )
        *x1 = (styxOptNat)GLS_ign_Skip(x);
      x = (styxSource)GLS_keycom_Skip(PT_next(x));
      if( (StdCPtr)x2 != (StdCPtr)NULL )
        *x2 = (GLS_Tok)GLS_ign_Skip(x);
      x = (styxSource)GLS_keycom_Skip(PT_next(x));
      if( (StdCPtr)x3 != (StdCPtr)NULL )
        *x3 = (GLS_Lst(styxQlxDfn))GLS_ign_Skip(x);
      x = (styxSource)GLS_keycom_Skip(PT_next(x));
      if( (StdCPtr)x4 != (StdCPtr)NULL )
        *x4 = (styxOptCfg)GLS_ign_Skip(x);
    }
    else
    {
      x = XGLS_keycom_Skip(XPT_parts(x)); y = fst(styxSource,x);
      if( (StdCPtr)x1 != (StdCPtr)NULL )
        *x1 = (styxOptNat)GLS_ign_Skip(y);
      x = XGLS_keycom_Skip(rst(x)); y = fst(styxSource,x);
      if( (StdCPtr)x2 != (StdCPtr)NULL )
        *x2 = (GLS_Tok)GLS_ign_Skip(y);
      x = XGLS_keycom_Skip(rst(x)); y = fst(styxSource,x);
      if( (StdCPtr)x3 != (StdCPtr)NULL )
        *x3 = (GLS_Lst(styxQlxDfn))GLS_ign_Skip(y);
      x = XGLS_keycom_Skip(rst(x)); y = fst(styxSource,x);
      if( (StdCPtr)x4 != (StdCPtr)NULL )
        *x4 = (styxOptCfg)GLS_ign_Skip(y);
    }
  }
  return True;
}

/*I-------------------------------- OptCfg -------------------------------- */

c_bool styxOptCfg_non(styxOptCfg x)
{
  assert0(  PT_THISNTM((PT_Term)x, CfgSyms[56]), "OptCfg expected" );
  if( ! PT_THISPRD((PT_Term)x, PrdSyms[1]) ) return False;
  return True;
}

c_bool styxOptCfg_cfg(styxOptCfg x, GLS_Lst(styxDfn)* x1, GLS_Lst(styxConflict)* x2)
{
  assert0(  PT_THISNTM((PT_Term)x, CfgSyms[56]), "OptCfg expected" );
  if( ! PT_THISPRD((PT_Term)x, PrdSyms[2]) ) return False;
  { PT_Term y;
    if( ! PT_isXaron(x) )
    {
      x = (styxOptCfg)GLS_keycom_Skip(PT_parts(x));
      if( (StdCPtr)x1 != (StdCPtr)NULL )
        *x1 = (GLS_Lst(styxDfn))GLS_ign_Skip(x);
      x = (styxOptCfg)GLS_keycom_Skip(PT_next(x));
      if( (StdCPtr)x2 != (StdCPtr)NULL )
        *x2 = (GLS_Lst(styxConflict))GLS_ign_Skip(x);
    }
    else
    {
      x = XGLS_keycom_Skip(XPT_parts(x)); y = fst(styxOptCfg,x);
      if( (StdCPtr)x1 != (StdCPtr)NULL )
        *x1 = (GLS_Lst(styxDfn))GLS_ign_Skip(y);
      x = XGLS_keycom_Skip(rst(x)); y = fst(styxOptCfg,x);
      if( (StdCPtr)x2 != (StdCPtr)NULL )
        *x2 = (GLS_Lst(styxConflict))GLS_ign_Skip(y);
    }
  }
  return True;
}

/*I-------------------------------- QlxDfn -------------------------------- */

c_bool styxQlxDfn_defd(styxQlxDfn x, GLS_Tok* x1)
{
  assert0(  PT_THISNTM((PT_Term)x, CfgSyms[59]), "QlxDfn expected" );
  if( ! PT_THISPRD((PT_Term)x, PrdSyms[8]) ) return False;
  { PT_Term y;
    if( ! PT_isXaron(x) )
    {
      x = (styxQlxDfn)GLS_keycom_Skip(PT_parts(x));
      if( (StdCPtr)x1 != (StdCPtr)NULL )
        *x1 = (GLS_Tok)GLS_ign_Skip(x);
    }
    else
    {
      x = XGLS_keycom_Skip(XPT_parts(x)); y = fst(styxQlxDfn,x);
      if( (StdCPtr)x1 != (StdCPtr)NULL )
        *x1 = (GLS_Tok)GLS_ign_Skip(y);
    }
  }
  return True;
}

c_bool styxQlxDfn_defn(styxQlxDfn x, styxQlxCat* x1, styxQlxOpt* x2,
                       styxQlxGrp* x3, GLS_Tok* x4,
                       styxQlxGrp* x5, styxExp* x6)
{
  assert0(  PT_THISNTM((PT_Term)x, CfgSyms[59]), "QlxDfn expected" );
  if( ! PT_THISPRD((PT_Term)x, PrdSyms[7]) ) return False;
  { PT_Term y;
    if( ! PT_isXaron(x) )
    {
      x = (styxQlxDfn)GLS_keycom_Skip(PT_parts(x));
      if( (StdCPtr)x1 != (StdCPtr)NULL )
        *x1 = (styxQlxCat)GLS_ign_Skip(x);
      x = (styxQlxDfn)GLS_keycom_Skip(PT_next(x));
      if( (StdCPtr)x2 != (StdCPtr)NULL )
        *x2 = (styxQlxOpt)GLS_ign_Skip(x);
      x = (styxQlxDfn)GLS_keycom_Skip(PT_next(x));
      if( (StdCPtr)x3 != (StdCPtr)NULL )
        *x3 = (styxQlxGrp)GLS_ign_Skip(x);
      x = (styxQlxDfn)GLS_keycom_Skip(PT_next(x));
      if( (StdCPtr)x4 != (StdCPtr)NULL )
        *x4 = (GLS_Tok)GLS_ign_Skip(x);
      x = (styxQlxDfn)GLS_keycom_Skip(PT_next(x));
      if( (StdCPtr)x5 != (StdCPtr)NULL )
        *x5 = (styxQlxGrp)GLS_ign_Skip(x);
      x = (styxQlxDfn)GLS_keycom_Skip(PT_next(x));
      if( (StdCPtr)x6 != (StdCPtr)NULL )
        *x6 = (styxExp)GLS_ign_Skip(x);
    }
    else
    {
      x = XGLS_keycom_Skip(XPT_parts(x)); y = fst(styxQlxDfn,x);
      if( (StdCPtr)x1 != (StdCPtr)NULL )
        *x1 = (styxQlxCat)GLS_ign_Skip(y);
      x = XGLS_keycom_Skip(rst(x)); y = fst(styxQlxDfn,x);
      if( (StdCPtr)x2 != (StdCPtr)NULL )
        *x2 = (styxQlxOpt)GLS_ign_Skip(y);
      x = XGLS_keycom_Skip(rst(x)); y = fst(styxQlxDfn,x);
      if( (StdCPtr)x3 != (StdCPtr)NULL )
        *x3 = (styxQlxGrp)GLS_ign_Skip(y);
      x = XGLS_keycom_Skip(rst(x)); y = fst(styxQlxDfn,x);
      if( (StdCPtr)x4 != (StdCPtr)NULL )
        *x4 = (GLS_Tok)GLS_ign_Skip(y);
      x = XGLS_keycom_Skip(rst(x)); y = fst(styxQlxDfn,x);
      if( (StdCPtr)x5 != (StdCPtr)NULL )
        *x5 = (styxQlxGrp)GLS_ign_Skip(y);
      x = XGLS_keycom_Skip(rst(x)); y = fst(styxQlxDfn,x);
      if( (StdCPtr)x6 != (StdCPtr)NULL )
        *x6 = (styxExp)GLS_ign_Skip(y);
    }
  }
  return True;
}

c_bool styxQlxDfn_igrp(styxQlxDfn x, GLS_Tok* x1)
{
  assert0(  PT_THISNTM((PT_Term)x, CfgSyms[59]), "QlxDfn expected" );
  if( ! PT_THISPRD((PT_Term)x, PrdSyms[9]) ) return False;
  { PT_Term y;
    if( ! PT_isXaron(x) )
    {
      x = (styxQlxDfn)GLS_keycom_Skip(PT_parts(x));
      if( (StdCPtr)x1 != (StdCPtr)NULL )
        *x1 = (GLS_Tok)GLS_ign_Skip(x);
    }
    else
    {
      x = XGLS_keycom_Skip(XPT_parts(x)); y = fst(styxQlxDfn,x);
      if( (StdCPtr)x1 != (StdCPtr)NULL )
        *x1 = (GLS_Tok)GLS_ign_Skip(y);
    }
  }
  return True;
}

c_bool styxQlxDfn_tgrp(styxQlxDfn x, GLS_Tok* x1)
{
  assert0(  PT_THISNTM((PT_Term)x, CfgSyms[59]), "QlxDfn expected" );
  if( ! PT_THISPRD((PT_Term)x, PrdSyms[11]) ) return False;
  { PT_Term y;
    if( ! PT_isXaron(x) )
    {
      x = (styxQlxDfn)GLS_keycom_Skip(PT_parts(x));
      if( (StdCPtr)x1 != (StdCPtr)NULL )
        *x1 = (GLS_Tok)GLS_ign_Skip(x);
    }
    else
    {
      x = XGLS_keycom_Skip(XPT_parts(x)); y = fst(styxQlxDfn,x);
      if( (StdCPtr)x1 != (StdCPtr)NULL )
        *x1 = (GLS_Tok)GLS_ign_Skip(y);
    }
  }
  return True;
}

c_bool styxQlxDfn_mgrp(styxQlxDfn x, GLS_Tok* x1, GLS_Lst(GLS_Tok)* x2)
{
  assert0(  PT_THISNTM((PT_Term)x, CfgSyms[59]), "QlxDfn expected" );
  if( ! PT_THISPRD((PT_Term)x, PrdSyms[12]) ) return False;
  { PT_Term y;
    if( ! PT_isXaron(x) )
    {
      x = (styxQlxDfn)GLS_keycom_Skip(PT_parts(x));
      if( (StdCPtr)x1 != (StdCPtr)NULL )
        *x1 = (GLS_Tok)GLS_ign_Skip(x);
      x = (styxQlxDfn)GLS_keycom_Skip(PT_next(x));
      if( (StdCPtr)x2 != (StdCPtr)NULL )
        *x2 = (GLS_Lst(GLS_Tok))GLS_ign_Skip(x);
    }
    else
    {
      x = XGLS_keycom_Skip(XPT_parts(x)); y = fst(styxQlxDfn,x);
      if( (StdCPtr)x1 != (StdCPtr)NULL )
        *x1 = (GLS_Tok)GLS_ign_Skip(y);
      x = XGLS_keycom_Skip(rst(x)); y = fst(styxQlxDfn,x);
      if( (StdCPtr)x2 != (StdCPtr)NULL )
        *x2 = (GLS_Lst(GLS_Tok))GLS_ign_Skip(y);
    }
  }
  return True;
}

c_bool styxQlxDfn_xgrp(styxQlxDfn x, GLS_Tok* x1)
{
  assert0(  PT_THISNTM((PT_Term)x, CfgSyms[59]), "QlxDfn expected" );
  if( ! PT_THISPRD((PT_Term)x, PrdSyms[10]) ) return False;
  { PT_Term y;
    if( ! PT_isXaron(x) )
    {
      x = (styxQlxDfn)GLS_keycom_Skip(PT_parts(x));
      if( (StdCPtr)x1 != (StdCPtr)NULL )
        *x1 = (GLS_Tok)GLS_ign_Skip(x);
    }
    else
    {
      x = XGLS_keycom_Skip(XPT_parts(x)); y = fst(styxQlxDfn,x);
      if( (StdCPtr)x1 != (StdCPtr)NULL )
        *x1 = (GLS_Tok)GLS_ign_Skip(y);
    }
  }
  return True;
}

/*I-------------------------------- QlxCat -------------------------------- */

c_bool styxQlxCat_comC(styxQlxCat x)
{
  assert0(  PT_THISNTM((PT_Term)x, CfgSyms[62]), "QlxCat expected" );
  if( ! PT_THISPRD((PT_Term)x, PrdSyms[19]) ) return False;
  return True;
}

c_bool styxQlxCat_indC(styxQlxCat x)
{
  assert0(  PT_THISNTM((PT_Term)x, CfgSyms[62]), "QlxCat expected" );
  if( ! PT_THISPRD((PT_Term)x, PrdSyms[21]) ) return False;
  return True;
}

c_bool styxQlxCat_letC(styxQlxCat x)
{
  assert0(  PT_THISNTM((PT_Term)x, CfgSyms[62]), "QlxCat expected" );
  if( ! PT_THISPRD((PT_Term)x, PrdSyms[16]) ) return False;
  return True;
}

c_bool styxQlxCat_tokC(styxQlxCat x)
{
  assert0(  PT_THISNTM((PT_Term)x, CfgSyms[62]), "QlxCat expected" );
  if( ! PT_THISPRD((PT_Term)x, PrdSyms[17]) ) return False;
  return True;
}

c_bool styxQlxCat_lanC(styxQlxCat x)
{
  assert0(  PT_THISNTM((PT_Term)x, CfgSyms[62]), "QlxCat expected" );
  if( ! PT_THISPRD((PT_Term)x, PrdSyms[20]) ) return False;
  return True;
}

c_bool styxQlxCat_ignC(styxQlxCat x)
{
  assert0(  PT_THISNTM((PT_Term)x, CfgSyms[62]), "QlxCat expected" );
  if( ! PT_THISPRD((PT_Term)x, PrdSyms[18]) ) return False;
  return True;
}

/*I-------------------------------- QlxGrp -------------------------------- */

c_bool styxQlxGrp_non(styxQlxGrp x)
{
  assert0(  PT_THISNTM((PT_Term)x, CfgSyms[63])
        || PT_THISNTM((PT_Term)x, CfgSyms[64])
        || PT_THISNTM((PT_Term)x, CfgSyms[65]), "QlxGrp expected" );
  if( ! PT_THISPRD((PT_Term)x, PrdSyms[22]) ) return False;
  return True;
}

c_bool styxQlxGrp_pigrp(styxQlxGrp x)
{
  assert0(  PT_THISNTM((PT_Term)x, CfgSyms[63])
        || PT_THISNTM((PT_Term)x, CfgSyms[64])
        || PT_THISNTM((PT_Term)x, CfgSyms[65]), "QlxGrp expected" );
  if( ! PT_THISPRD((PT_Term)x, PrdSyms[28]) ) return False;
  return True;
}

c_bool styxQlxGrp_pop(styxQlxGrp x)
{
  assert0(  PT_THISNTM((PT_Term)x, CfgSyms[63])
        || PT_THISNTM((PT_Term)x, CfgSyms[64])
        || PT_THISNTM((PT_Term)x, CfgSyms[65]), "QlxGrp expected" );
  if( ! PT_THISPRD((PT_Term)x, PrdSyms[29]) ) return False;
  return True;
}

c_bool styxQlxGrp_igrp(styxQlxGrp x)
{
  assert0(  PT_THISNTM((PT_Term)x, CfgSyms[63])
        || PT_THISNTM((PT_Term)x, CfgSyms[64])
        || PT_THISNTM((PT_Term)x, CfgSyms[65]), "QlxGrp expected" );
  if( ! PT_THISPRD((PT_Term)x, PrdSyms[26]) ) return False;
  return True;
}

c_bool styxQlxGrp_pgrp(styxQlxGrp x, GLS_Tok* x1)
{
  assert0(  PT_THISNTM((PT_Term)x, CfgSyms[63])
        || PT_THISNTM((PT_Term)x, CfgSyms[64])
        || PT_THISNTM((PT_Term)x, CfgSyms[65]), "QlxGrp expected" );
  if( ! PT_THISPRD((PT_Term)x, PrdSyms[27]) ) return False;
  { PT_Term y;
    if( ! PT_isXaron(x) )
    {
      x = (styxQlxGrp)GLS_keycom_Skip(PT_parts(x));
      if( (StdCPtr)x1 != (StdCPtr)NULL )
        *x1 = (GLS_Tok)GLS_ign_Skip(x);
    }
    else
    {
      x = XGLS_keycom_Skip(XPT_parts(x)); y = fst(styxQlxGrp,x);
      if( (StdCPtr)x1 != (StdCPtr)NULL )
        *x1 = (GLS_Tok)GLS_ign_Skip(y);
    }
  }
  return True;
}

c_bool styxQlxGrp_grp(styxQlxGrp x, GLS_Tok* x1)
{
  assert0(  PT_THISNTM((PT_Term)x, CfgSyms[63])
        || PT_THISNTM((PT_Term)x, CfgSyms[64])
        || PT_THISNTM((PT_Term)x, CfgSyms[65]), "QlxGrp expected" );
  if( ! PT_THISPRD((PT_Term)x, PrdSyms[23]) ) return False;
  { PT_Term y;
    if( ! PT_isXaron(x) )
    {
      x = (styxQlxGrp)GLS_keycom_Skip(PT_parts(x));
      if( (StdCPtr)x1 != (StdCPtr)NULL )
        *x1 = (GLS_Tok)GLS_ign_Skip(x);
    }
    else
    {
      x = XGLS_keycom_Skip(XPT_parts(x)); y = fst(styxQlxGrp,x);
      if( (StdCPtr)x1 != (StdCPtr)NULL )
        *x1 = (GLS_Tok)GLS_ign_Skip(y);
    }
  }
  return True;
}

/*I-------------------------------- QlxOpt -------------------------------- */

c_bool styxQlxOpt_ignca(styxQlxOpt x)
{
  assert0(  PT_THISNTM((PT_Term)x, CfgSyms[66]), "QlxOpt expected" );
  if( ! PT_THISPRD((PT_Term)x, PrdSyms[32]) ) return False;
  return True;
}

c_bool styxQlxOpt_non(styxQlxOpt x)
{
  assert0(  PT_THISNTM((PT_Term)x, CfgSyms[66]), "QlxOpt expected" );
  if( ! PT_THISPRD((PT_Term)x, PrdSyms[31]) ) return False;
  return True;
}

/*I--------------------------------- Exp ---------------------------------- */

c_bool styxExp_conc(styxExp x, styxExp* x1, styxExp* x2)
{
  assert0(  PT_THISNTM((PT_Term)x, CfgSyms[69])
        || PT_THISNTM((PT_Term)x, CfgSyms[74])
        || PT_THISNTM((PT_Term)x, CfgSyms[70])
        || PT_THISNTM((PT_Term)x, CfgSyms[67])
        || PT_THISNTM((PT_Term)x, CfgSyms[71])
        || PT_THISNTM((PT_Term)x, CfgSyms[75])
        || PT_THISNTM((PT_Term)x, CfgSyms[68])
        || PT_THISNTM((PT_Term)x, CfgSyms[76]), "Exp expected" );
  if( ! PT_THISPRD((PT_Term)x, PrdSyms[44]) ) return False;
  { PT_Term y;
    if( ! PT_isXaron(x) )
    {
      x = (styxExp)GLS_keycom_Skip(PT_parts(x));
      if( (StdCPtr)x1 != (StdCPtr)NULL )
        *x1 = (styxExp)GLS_ign_Skip(x);
      x = (styxExp)GLS_keycom_Skip(PT_next(x));
      if( (StdCPtr)x2 != (StdCPtr)NULL )
        *x2 = (styxExp)GLS_ign_Skip(x);
    }
    else
    {
      x = XGLS_keycom_Skip(XPT_parts(x)); y = fst(styxExp,x);
      if( (StdCPtr)x1 != (StdCPtr)NULL )
        *x1 = (styxExp)GLS_ign_Skip(y);
      x = XGLS_keycom_Skip(rst(x)); y = fst(styxExp,x);
      if( (StdCPtr)x2 != (StdCPtr)NULL )
        *x2 = (styxExp)GLS_ign_Skip(y);
    }
  }
  return True;
}

c_bool styxExp_diff(styxExp x, styxExp* x1, styxExp* x2)
{
  assert0(  PT_THISNTM((PT_Term)x, CfgSyms[69])
        || PT_THISNTM((PT_Term)x, CfgSyms[74])
        || PT_THISNTM((PT_Term)x, CfgSyms[70])
        || PT_THISNTM((PT_Term)x, CfgSyms[67])
        || PT_THISNTM((PT_Term)x, CfgSyms[71])
        || PT_THISNTM((PT_Term)x, CfgSyms[75])
        || PT_THISNTM((PT_Term)x, CfgSyms[68])
        || PT_THISNTM((PT_Term)x, CfgSyms[76]), "Exp expected" );
  if( ! PT_THISPRD((PT_Term)x, PrdSyms[42]) ) return False;
  { PT_Term y;
    if( ! PT_isXaron(x) )
    {
      x = (styxExp)GLS_keycom_Skip(PT_parts(x));
      if( (StdCPtr)x1 != (StdCPtr)NULL )
        *x1 = (styxExp)GLS_ign_Skip(x);
      x = (styxExp)GLS_keycom_Skip(PT_next(x));
      if( (StdCPtr)x2 != (StdCPtr)NULL )
        *x2 = (styxExp)GLS_ign_Skip(x);
    }
    else
    {
      x = XGLS_keycom_Skip(XPT_parts(x)); y = fst(styxExp,x);
      if( (StdCPtr)x1 != (StdCPtr)NULL )
        *x1 = (styxExp)GLS_ign_Skip(y);
      x = XGLS_keycom_Skip(rst(x)); y = fst(styxExp,x);
      if( (StdCPtr)x2 != (StdCPtr)NULL )
        *x2 = (styxExp)GLS_ign_Skip(y);
    }
  }
  return True;
}

c_bool styxExp_sequ(styxExp x, GLS_Tok* x1)
{
  assert0(  PT_THISNTM((PT_Term)x, CfgSyms[69])
        || PT_THISNTM((PT_Term)x, CfgSyms[74])
        || PT_THISNTM((PT_Term)x, CfgSyms[70])
        || PT_THISNTM((PT_Term)x, CfgSyms[67])
        || PT_THISNTM((PT_Term)x, CfgSyms[71])
        || PT_THISNTM((PT_Term)x, CfgSyms[75])
        || PT_THISNTM((PT_Term)x, CfgSyms[68])
        || PT_THISNTM((PT_Term)x, CfgSyms[76]), "Exp expected" );
  if( ! PT_THISPRD((PT_Term)x, PrdSyms[59]) ) return False;
  { PT_Term y;
    if( ! PT_isXaron(x) )
    {
      x = (styxExp)GLS_keycom_Skip(PT_parts(x));
      if( (StdCPtr)x1 != (StdCPtr)NULL )
        *x1 = (GLS_Tok)GLS_ign_Skip(x);
    }
    else
    {
      x = XGLS_keycom_Skip(XPT_parts(x)); y = fst(styxExp,x);
      if( (StdCPtr)x1 != (StdCPtr)NULL )
        *x1 = (GLS_Tok)GLS_ign_Skip(y);
    }
  }
  return True;
}

c_bool styxExp_plusn(styxExp x, styxExp* x1, styxLimit* x2)
{
  assert0(  PT_THISNTM((PT_Term)x, CfgSyms[69])
        || PT_THISNTM((PT_Term)x, CfgSyms[74])
        || PT_THISNTM((PT_Term)x, CfgSyms[70])
        || PT_THISNTM((PT_Term)x, CfgSyms[67])
        || PT_THISNTM((PT_Term)x, CfgSyms[71])
        || PT_THISNTM((PT_Term)x, CfgSyms[75])
        || PT_THISNTM((PT_Term)x, CfgSyms[68])
        || PT_THISNTM((PT_Term)x, CfgSyms[76]), "Exp expected" );
  if( ! PT_THISPRD((PT_Term)x, PrdSyms[54]) ) return False;
  { PT_Term y;
    if( ! PT_isXaron(x) )
    {
      x = (styxExp)GLS_keycom_Skip(PT_parts(x));
      if( (StdCPtr)x1 != (StdCPtr)NULL )
        *x1 = (styxExp)GLS_ign_Skip(x);
      x = (styxExp)GLS_keycom_Skip(PT_next(x));
      if( (StdCPtr)x2 != (StdCPtr)NULL )
        *x2 = (styxLimit)GLS_ign_Skip(x);
    }
    else
    {
      x = XGLS_keycom_Skip(XPT_parts(x)); y = fst(styxExp,x);
      if( (StdCPtr)x1 != (StdCPtr)NULL )
        *x1 = (styxExp)GLS_ign_Skip(y);
      x = XGLS_keycom_Skip(rst(x)); y = fst(styxExp,x);
      if( (StdCPtr)x2 != (StdCPtr)NULL )
        *x2 = (styxLimit)GLS_ign_Skip(y);
    }
  }
  return True;
}

c_bool styxExp_plus0(styxExp x, styxExp* x1)
{
  assert0(  PT_THISNTM((PT_Term)x, CfgSyms[69])
        || PT_THISNTM((PT_Term)x, CfgSyms[74])
        || PT_THISNTM((PT_Term)x, CfgSyms[70])
        || PT_THISNTM((PT_Term)x, CfgSyms[67])
        || PT_THISNTM((PT_Term)x, CfgSyms[71])
        || PT_THISNTM((PT_Term)x, CfgSyms[75])
        || PT_THISNTM((PT_Term)x, CfgSyms[68])
        || PT_THISNTM((PT_Term)x, CfgSyms[76]), "Exp expected" );
  if( ! PT_THISPRD((PT_Term)x, PrdSyms[52]) ) return False;
  { PT_Term y;
    if( ! PT_isXaron(x) )
    {
      x = (styxExp)GLS_keycom_Skip(PT_parts(x));
      if( (StdCPtr)x1 != (StdCPtr)NULL )
        *x1 = (styxExp)GLS_ign_Skip(x);
    }
    else
    {
      x = XGLS_keycom_Skip(XPT_parts(x)); y = fst(styxExp,x);
      if( (StdCPtr)x1 != (StdCPtr)NULL )
        *x1 = (styxExp)GLS_ign_Skip(y);
    }
  }
  return True;
}

c_bool styxExp_dyck(styxExp x, styxExp* x1, styxExp* x2,
                    styxExp* x3)
{
  assert0(  PT_THISNTM((PT_Term)x, CfgSyms[69])
        || PT_THISNTM((PT_Term)x, CfgSyms[74])
        || PT_THISNTM((PT_Term)x, CfgSyms[70])
        || PT_THISNTM((PT_Term)x, CfgSyms[67])
        || PT_THISNTM((PT_Term)x, CfgSyms[71])
        || PT_THISNTM((PT_Term)x, CfgSyms[75])
        || PT_THISNTM((PT_Term)x, CfgSyms[68])
        || PT_THISNTM((PT_Term)x, CfgSyms[76]), "Exp expected" );
  if( ! PT_THISPRD((PT_Term)x, PrdSyms[35]) ) return False;
  { PT_Term y;
    if( ! PT_isXaron(x) )
    {
      x = (styxExp)GLS_keycom_Skip(PT_parts(x));
      if( (StdCPtr)x1 != (StdCPtr)NULL )
        *x1 = (styxExp)GLS_ign_Skip(x);
      x = (styxExp)GLS_keycom_Skip(PT_next(x));
      if( (StdCPtr)x2 != (StdCPtr)NULL )
        *x2 = (styxExp)GLS_ign_Skip(x);
      x = (styxExp)GLS_keycom_Skip(PT_next(x));
      if( (StdCPtr)x3 != (StdCPtr)NULL )
        *x3 = (styxExp)GLS_ign_Skip(x);
    }
    else
    {
      x = XGLS_keycom_Skip(XPT_parts(x)); y = fst(styxExp,x);
      if( (StdCPtr)x1 != (StdCPtr)NULL )
        *x1 = (styxExp)GLS_ign_Skip(y);
      x = XGLS_keycom_Skip(rst(x)); y = fst(styxExp,x);
      if( (StdCPtr)x2 != (StdCPtr)NULL )
        *x2 = (styxExp)GLS_ign_Skip(y);
      x = XGLS_keycom_Skip(rst(x)); y = fst(styxExp,x);
      if( (StdCPtr)x3 != (StdCPtr)NULL )
        *x3 = (styxExp)GLS_ign_Skip(y);
    }
  }
  return True;
}

c_bool styxExp_non(styxExp x)
{
  assert0(  PT_THISNTM((PT_Term)x, CfgSyms[69])
        || PT_THISNTM((PT_Term)x, CfgSyms[74])
        || PT_THISNTM((PT_Term)x, CfgSyms[70])
        || PT_THISNTM((PT_Term)x, CfgSyms[67])
        || PT_THISNTM((PT_Term)x, CfgSyms[71])
        || PT_THISNTM((PT_Term)x, CfgSyms[75])
        || PT_THISNTM((PT_Term)x, CfgSyms[68])
        || PT_THISNTM((PT_Term)x, CfgSyms[76]), "Exp expected" );
  if( ! PT_THISPRD((PT_Term)x, PrdSyms[39]) ) return False;
  return True;
}

c_bool styxExp_opt(styxExp x, styxExp* x1)
{
  assert0(  PT_THISNTM((PT_Term)x, CfgSyms[69])
        || PT_THISNTM((PT_Term)x, CfgSyms[74])
        || PT_THISNTM((PT_Term)x, CfgSyms[70])
        || PT_THISNTM((PT_Term)x, CfgSyms[67])
        || PT_THISNTM((PT_Term)x, CfgSyms[71])
        || PT_THISNTM((PT_Term)x, CfgSyms[75])
        || PT_THISNTM((PT_Term)x, CfgSyms[68])
        || PT_THISNTM((PT_Term)x, CfgSyms[76]), "Exp expected" );
  if( ! PT_THISPRD((PT_Term)x, PrdSyms[50]) ) return False;
  { PT_Term y;
    if( ! PT_isXaron(x) )
    {
      x = (styxExp)GLS_keycom_Skip(PT_parts(x));
      if( (StdCPtr)x1 != (StdCPtr)NULL )
        *x1 = (styxExp)GLS_ign_Skip(x);
    }
    else
    {
      x = XGLS_keycom_Skip(XPT_parts(x)); y = fst(styxExp,x);
      if( (StdCPtr)x1 != (StdCPtr)NULL )
        *x1 = (styxExp)GLS_ign_Skip(y);
    }
  }
  return True;
}

c_bool styxExp_range(styxExp x, styxExp* x1, styxExp* x2)
{
  assert0(  PT_THISNTM((PT_Term)x, CfgSyms[69])
        || PT_THISNTM((PT_Term)x, CfgSyms[74])
        || PT_THISNTM((PT_Term)x, CfgSyms[70])
        || PT_THISNTM((PT_Term)x, CfgSyms[67])
        || PT_THISNTM((PT_Term)x, CfgSyms[71])
        || PT_THISNTM((PT_Term)x, CfgSyms[75])
        || PT_THISNTM((PT_Term)x, CfgSyms[68])
        || PT_THISNTM((PT_Term)x, CfgSyms[76]), "Exp expected" );
  if( ! PT_THISPRD((PT_Term)x, PrdSyms[57]) ) return False;
  { PT_Term y;
    if( ! PT_isXaron(x) )
    {
      x = (styxExp)GLS_keycom_Skip(PT_parts(x));
      if( (StdCPtr)x1 != (StdCPtr)NULL )
        *x1 = (styxExp)GLS_ign_Skip(x);
      x = (styxExp)GLS_keycom_Skip(PT_next(x));
      if( (StdCPtr)x2 != (StdCPtr)NULL )
        *x2 = (styxExp)GLS_ign_Skip(x);
    }
    else
    {
      x = XGLS_keycom_Skip(XPT_parts(x)); y = fst(styxExp,x);
      if( (StdCPtr)x1 != (StdCPtr)NULL )
        *x1 = (styxExp)GLS_ign_Skip(y);
      x = XGLS_keycom_Skip(rst(x)); y = fst(styxExp,x);
      if( (StdCPtr)x2 != (StdCPtr)NULL )
        *x2 = (styxExp)GLS_ign_Skip(y);
    }
  }
  return True;
}

c_bool styxExp_plus(styxExp x, styxExp* x1)
{
  assert0(  PT_THISNTM((PT_Term)x, CfgSyms[69])
        || PT_THISNTM((PT_Term)x, CfgSyms[74])
        || PT_THISNTM((PT_Term)x, CfgSyms[70])
        || PT_THISNTM((PT_Term)x, CfgSyms[67])
        || PT_THISNTM((PT_Term)x, CfgSyms[71])
        || PT_THISNTM((PT_Term)x, CfgSyms[75])
        || PT_THISNTM((PT_Term)x, CfgSyms[68])
        || PT_THISNTM((PT_Term)x, CfgSyms[76]), "Exp expected" );
  if( ! PT_THISPRD((PT_Term)x, PrdSyms[53]) ) return False;
  { PT_Term y;
    if( ! PT_isXaron(x) )
    {
      x = (styxExp)GLS_keycom_Skip(PT_parts(x));
      if( (StdCPtr)x1 != (StdCPtr)NULL )
        *x1 = (styxExp)GLS_ign_Skip(x);
    }
    else
    {
      x = XGLS_keycom_Skip(XPT_parts(x)); y = fst(styxExp,x);
      if( (StdCPtr)x1 != (StdCPtr)NULL )
        *x1 = (styxExp)GLS_ign_Skip(y);
    }
  }
  return True;
}

c_bool styxExp_epat(styxExp x, styxExp* x1, GLS_Tok* x2,
                    styxExp* x3)
{
  assert0(  PT_THISNTM((PT_Term)x, CfgSyms[69])
        || PT_THISNTM((PT_Term)x, CfgSyms[74])
        || PT_THISNTM((PT_Term)x, CfgSyms[70])
        || PT_THISNTM((PT_Term)x, CfgSyms[67])
        || PT_THISNTM((PT_Term)x, CfgSyms[71])
        || PT_THISNTM((PT_Term)x, CfgSyms[75])
        || PT_THISNTM((PT_Term)x, CfgSyms[68])
        || PT_THISNTM((PT_Term)x, CfgSyms[76]), "Exp expected" );
  if( ! PT_THISPRD((PT_Term)x, PrdSyms[37]) ) return False;
  { PT_Term y;
    if( ! PT_isXaron(x) )
    {
      x = (styxExp)GLS_keycom_Skip(PT_parts(x));
      if( (StdCPtr)x1 != (StdCPtr)NULL )
        *x1 = (styxExp)GLS_ign_Skip(x);
      x = (styxExp)GLS_keycom_Skip(PT_next(x));
      if( (StdCPtr)x2 != (StdCPtr)NULL )
        *x2 = (GLS_Tok)GLS_ign_Skip(x);
      x = (styxExp)GLS_keycom_Skip(PT_next(x));
      if( (StdCPtr)x3 != (StdCPtr)NULL )
        *x3 = (styxExp)GLS_ign_Skip(x);
    }
    else
    {
      x = XGLS_keycom_Skip(XPT_parts(x)); y = fst(styxExp,x);
      if( (StdCPtr)x1 != (StdCPtr)NULL )
        *x1 = (styxExp)GLS_ign_Skip(y);
      x = XGLS_keycom_Skip(rst(x)); y = fst(styxExp,x);
      if( (StdCPtr)x2 != (StdCPtr)NULL )
        *x2 = (GLS_Tok)GLS_ign_Skip(y);
      x = XGLS_keycom_Skip(rst(x)); y = fst(styxExp,x);
      if( (StdCPtr)x3 != (StdCPtr)NULL )
        *x3 = (styxExp)GLS_ign_Skip(y);
    }
  }
  return True;
}

c_bool styxExp_set(styxExp x, GLS_Tok* x1)
{
  assert0(  PT_THISNTM((PT_Term)x, CfgSyms[69])
        || PT_THISNTM((PT_Term)x, CfgSyms[74])
        || PT_THISNTM((PT_Term)x, CfgSyms[70])
        || PT_THISNTM((PT_Term)x, CfgSyms[67])
        || PT_THISNTM((PT_Term)x, CfgSyms[71])
        || PT_THISNTM((PT_Term)x, CfgSyms[75])
        || PT_THISNTM((PT_Term)x, CfgSyms[68])
        || PT_THISNTM((PT_Term)x, CfgSyms[76]), "Exp expected" );
  if( ! PT_THISPRD((PT_Term)x, PrdSyms[60]) ) return False;
  { PT_Term y;
    if( ! PT_isXaron(x) )
    {
      x = (styxExp)GLS_keycom_Skip(PT_parts(x));
      if( (StdCPtr)x1 != (StdCPtr)NULL )
        *x1 = (GLS_Tok)GLS_ign_Skip(x);
    }
    else
    {
      x = XGLS_keycom_Skip(XPT_parts(x)); y = fst(styxExp,x);
      if( (StdCPtr)x1 != (StdCPtr)NULL )
        *x1 = (GLS_Tok)GLS_ign_Skip(y);
    }
  }
  return True;
}

c_bool styxExp_union(styxExp x, styxExp* x1, styxExp* x2)
{
  assert0(  PT_THISNTM((PT_Term)x, CfgSyms[69])
        || PT_THISNTM((PT_Term)x, CfgSyms[74])
        || PT_THISNTM((PT_Term)x, CfgSyms[70])
        || PT_THISNTM((PT_Term)x, CfgSyms[67])
        || PT_THISNTM((PT_Term)x, CfgSyms[71])
        || PT_THISNTM((PT_Term)x, CfgSyms[75])
        || PT_THISNTM((PT_Term)x, CfgSyms[68])
        || PT_THISNTM((PT_Term)x, CfgSyms[76]), "Exp expected" );
  if( ! PT_THISPRD((PT_Term)x, PrdSyms[41]) ) return False;
  { PT_Term y;
    if( ! PT_isXaron(x) )
    {
      x = (styxExp)GLS_keycom_Skip(PT_parts(x));
      if( (StdCPtr)x1 != (StdCPtr)NULL )
        *x1 = (styxExp)GLS_ign_Skip(x);
      x = (styxExp)GLS_keycom_Skip(PT_next(x));
      if( (StdCPtr)x2 != (StdCPtr)NULL )
        *x2 = (styxExp)GLS_ign_Skip(x);
    }
    else
    {
      x = XGLS_keycom_Skip(XPT_parts(x)); y = fst(styxExp,x);
      if( (StdCPtr)x1 != (StdCPtr)NULL )
        *x1 = (styxExp)GLS_ign_Skip(y);
      x = XGLS_keycom_Skip(rst(x)); y = fst(styxExp,x);
      if( (StdCPtr)x2 != (StdCPtr)NULL )
        *x2 = (styxExp)GLS_ign_Skip(y);
    }
  }
  return True;
}

c_bool styxExp_quot(styxExp x, styxExp* x1, styxExp* x2)
{
  assert0(  PT_THISNTM((PT_Term)x, CfgSyms[69])
        || PT_THISNTM((PT_Term)x, CfgSyms[74])
        || PT_THISNTM((PT_Term)x, CfgSyms[70])
        || PT_THISNTM((PT_Term)x, CfgSyms[67])
        || PT_THISNTM((PT_Term)x, CfgSyms[71])
        || PT_THISNTM((PT_Term)x, CfgSyms[75])
        || PT_THISNTM((PT_Term)x, CfgSyms[68])
        || PT_THISNTM((PT_Term)x, CfgSyms[76]), "Exp expected" );
  if( ! PT_THISPRD((PT_Term)x, PrdSyms[33]) ) return False;
  { PT_Term y;
    if( ! PT_isXaron(x) )
    {
      x = (styxExp)GLS_keycom_Skip(PT_parts(x));
      if( (StdCPtr)x1 != (StdCPtr)NULL )
        *x1 = (styxExp)GLS_ign_Skip(x);
      x = (styxExp)GLS_keycom_Skip(PT_next(x));
      if( (StdCPtr)x2 != (StdCPtr)NULL )
        *x2 = (styxExp)GLS_ign_Skip(x);
    }
    else
    {
      x = XGLS_keycom_Skip(XPT_parts(x)); y = fst(styxExp,x);
      if( (StdCPtr)x1 != (StdCPtr)NULL )
        *x1 = (styxExp)GLS_ign_Skip(y);
      x = XGLS_keycom_Skip(rst(x)); y = fst(styxExp,x);
      if( (StdCPtr)x2 != (StdCPtr)NULL )
        *x2 = (styxExp)GLS_ign_Skip(y);
    }
  }
  return True;
}

c_bool styxExp_ident(styxExp x, GLS_Tok* x1)
{
  assert0(  PT_THISNTM((PT_Term)x, CfgSyms[69])
        || PT_THISNTM((PT_Term)x, CfgSyms[74])
        || PT_THISNTM((PT_Term)x, CfgSyms[70])
        || PT_THISNTM((PT_Term)x, CfgSyms[67])
        || PT_THISNTM((PT_Term)x, CfgSyms[71])
        || PT_THISNTM((PT_Term)x, CfgSyms[75])
        || PT_THISNTM((PT_Term)x, CfgSyms[68])
        || PT_THISNTM((PT_Term)x, CfgSyms[76]), "Exp expected" );
  if( ! PT_THISPRD((PT_Term)x, PrdSyms[61]) ) return False;
  { PT_Term y;
    if( ! PT_isXaron(x) )
    {
      x = (styxExp)GLS_keycom_Skip(PT_parts(x));
      if( (StdCPtr)x1 != (StdCPtr)NULL )
        *x1 = (GLS_Tok)GLS_ign_Skip(x);
    }
    else
    {
      x = XGLS_keycom_Skip(XPT_parts(x)); y = fst(styxExp,x);
      if( (StdCPtr)x1 != (StdCPtr)NULL )
        *x1 = (GLS_Tok)GLS_ign_Skip(y);
    }
  }
  return True;
}

c_bool styxExp_star(styxExp x, styxExp* x1)
{
  assert0(  PT_THISNTM((PT_Term)x, CfgSyms[69])
        || PT_THISNTM((PT_Term)x, CfgSyms[74])
        || PT_THISNTM((PT_Term)x, CfgSyms[70])
        || PT_THISNTM((PT_Term)x, CfgSyms[67])
        || PT_THISNTM((PT_Term)x, CfgSyms[71])
        || PT_THISNTM((PT_Term)x, CfgSyms[75])
        || PT_THISNTM((PT_Term)x, CfgSyms[68])
        || PT_THISNTM((PT_Term)x, CfgSyms[76]), "Exp expected" );
  if( ! PT_THISPRD((PT_Term)x, PrdSyms[51]) ) return False;
  { PT_Term y;
    if( ! PT_isXaron(x) )
    {
      x = (styxExp)GLS_keycom_Skip(PT_parts(x));
      if( (StdCPtr)x1 != (StdCPtr)NULL )
        *x1 = (styxExp)GLS_ign_Skip(x);
    }
    else
    {
      x = XGLS_keycom_Skip(XPT_parts(x)); y = fst(styxExp,x);
      if( (StdCPtr)x1 != (StdCPtr)NULL )
        *x1 = (styxExp)GLS_ign_Skip(y);
    }
  }
  return True;
}

c_bool styxExp_spat(styxExp x, styxExp* x1, GLS_Tok* x2,
                    styxExp* x3)
{
  assert0(  PT_THISNTM((PT_Term)x, CfgSyms[69])
        || PT_THISNTM((PT_Term)x, CfgSyms[74])
        || PT_THISNTM((PT_Term)x, CfgSyms[70])
        || PT_THISNTM((PT_Term)x, CfgSyms[67])
        || PT_THISNTM((PT_Term)x, CfgSyms[71])
        || PT_THISNTM((PT_Term)x, CfgSyms[75])
        || PT_THISNTM((PT_Term)x, CfgSyms[68])
        || PT_THISNTM((PT_Term)x, CfgSyms[76]), "Exp expected" );
  if( ! PT_THISPRD((PT_Term)x, PrdSyms[36]) ) return False;
  { PT_Term y;
    if( ! PT_isXaron(x) )
    {
      x = (styxExp)GLS_keycom_Skip(PT_parts(x));
      if( (StdCPtr)x1 != (StdCPtr)NULL )
        *x1 = (styxExp)GLS_ign_Skip(x);
      x = (styxExp)GLS_keycom_Skip(PT_next(x));
      if( (StdCPtr)x2 != (StdCPtr)NULL )
        *x2 = (GLS_Tok)GLS_ign_Skip(x);
      x = (styxExp)GLS_keycom_Skip(PT_next(x));
      if( (StdCPtr)x3 != (StdCPtr)NULL )
        *x3 = (styxExp)GLS_ign_Skip(x);
    }
    else
    {
      x = XGLS_keycom_Skip(XPT_parts(x)); y = fst(styxExp,x);
      if( (StdCPtr)x1 != (StdCPtr)NULL )
        *x1 = (styxExp)GLS_ign_Skip(y);
      x = XGLS_keycom_Skip(rst(x)); y = fst(styxExp,x);
      if( (StdCPtr)x2 != (StdCPtr)NULL )
        *x2 = (GLS_Tok)GLS_ign_Skip(y);
      x = XGLS_keycom_Skip(rst(x)); y = fst(styxExp,x);
      if( (StdCPtr)x3 != (StdCPtr)NULL )
        *x3 = (styxExp)GLS_ign_Skip(y);
    }
  }
  return True;
}

/*I-------------------------------- OptNat -------------------------------- */

c_bool styxOptNat_non(styxOptNat x)
{
  assert0(  PT_THISNTM((PT_Term)x, CfgSyms[72]), "OptNat expected" );
  if( ! PT_THISPRD((PT_Term)x, PrdSyms[46]) ) return False;
  return True;
}

c_bool styxOptNat_nat(styxOptNat x, GLS_Tok* x1)
{
  assert0(  PT_THISNTM((PT_Term)x, CfgSyms[72]), "OptNat expected" );
  if( ! PT_THISPRD((PT_Term)x, PrdSyms[47]) ) return False;
  { PT_Term y;
    if( ! PT_isXaron(x) )
    {
      x = (styxOptNat)GLS_keycom_Skip(PT_parts(x));
      if( (StdCPtr)x1 != (StdCPtr)NULL )
        *x1 = (GLS_Tok)GLS_ign_Skip(x);
    }
    else
    {
      x = XGLS_keycom_Skip(XPT_parts(x)); y = fst(styxOptNat,x);
      if( (StdCPtr)x1 != (StdCPtr)NULL )
        *x1 = (GLS_Tok)GLS_ign_Skip(y);
    }
  }
  return True;
}

/*I-------------------------------- Limit --------------------------------- */

c_bool styxLimit_range(styxLimit x, GLS_Tok* x1, styxOptNat* x2)
{
  assert0(  PT_THISNTM((PT_Term)x, CfgSyms[73]), "Limit expected" );
  if( ! PT_THISPRD((PT_Term)x, PrdSyms[49]) ) return False;
  { PT_Term y;
    if( ! PT_isXaron(x) )
    {
      x = (styxLimit)GLS_keycom_Skip(PT_parts(x));
      if( (StdCPtr)x1 != (StdCPtr)NULL )
        *x1 = (GLS_Tok)GLS_ign_Skip(x);
      x = (styxLimit)GLS_keycom_Skip(PT_next(x));
      if( (StdCPtr)x2 != (StdCPtr)NULL )
        *x2 = (styxOptNat)GLS_ign_Skip(x);
    }
    else
    {
      x = XGLS_keycom_Skip(XPT_parts(x)); y = fst(styxLimit,x);
      if( (StdCPtr)x1 != (StdCPtr)NULL )
        *x1 = (GLS_Tok)GLS_ign_Skip(y);
      x = XGLS_keycom_Skip(rst(x)); y = fst(styxLimit,x);
      if( (StdCPtr)x2 != (StdCPtr)NULL )
        *x2 = (styxOptNat)GLS_ign_Skip(y);
    }
  }
  return True;
}

c_bool styxLimit_ntime(styxLimit x, GLS_Tok* x1)
{
  assert0(  PT_THISNTM((PT_Term)x, CfgSyms[73]), "Limit expected" );
  if( ! PT_THISPRD((PT_Term)x, PrdSyms[48]) ) return False;
  { PT_Term y;
    if( ! PT_isXaron(x) )
    {
      x = (styxLimit)GLS_keycom_Skip(PT_parts(x));
      if( (StdCPtr)x1 != (StdCPtr)NULL )
        *x1 = (GLS_Tok)GLS_ign_Skip(x);
    }
    else
    {
      x = XGLS_keycom_Skip(XPT_parts(x)); y = fst(styxLimit,x);
      if( (StdCPtr)x1 != (StdCPtr)NULL )
        *x1 = (GLS_Tok)GLS_ign_Skip(y);
    }
  }
  return True;
}

/*I--------------------------------- Dfn ---------------------------------- */

c_bool styxDfn_defn(styxDfn x, styxCat* x1, styxDfnOpt* x2,
                    GLS_Tok* x3, GLS_Lst(styxPrd)* x4)
{
  assert0(  PT_THISNTM((PT_Term)x, CfgSyms[78]), "Dfn expected" );
  if( ! PT_THISPRD((PT_Term)x, PrdSyms[64]) ) return False;
  { PT_Term y;
    if( ! PT_isXaron(x) )
    {
      x = (styxDfn)GLS_keycom_Skip(PT_parts(x));
      if( (StdCPtr)x1 != (StdCPtr)NULL )
        *x1 = (styxCat)GLS_ign_Skip(x);
      x = (styxDfn)GLS_keycom_Skip(PT_next(x));
      if( (StdCPtr)x2 != (StdCPtr)NULL )
        *x2 = (styxDfnOpt)GLS_ign_Skip(x);
      x = (styxDfn)GLS_keycom_Skip(PT_next(x));
      if( (StdCPtr)x3 != (StdCPtr)NULL )
        *x3 = (GLS_Tok)GLS_ign_Skip(x);
      x = (styxDfn)GLS_keycom_Skip(PT_next(x));
      if( (StdCPtr)x4 != (StdCPtr)NULL )
        *x4 = (GLS_Lst(styxPrd))GLS_ign_Skip(x);
    }
    else
    {
      x = XGLS_keycom_Skip(XPT_parts(x)); y = fst(styxDfn,x);
      if( (StdCPtr)x1 != (StdCPtr)NULL )
        *x1 = (styxCat)GLS_ign_Skip(y);
      x = XGLS_keycom_Skip(rst(x)); y = fst(styxDfn,x);
      if( (StdCPtr)x2 != (StdCPtr)NULL )
        *x2 = (styxDfnOpt)GLS_ign_Skip(y);
      x = XGLS_keycom_Skip(rst(x)); y = fst(styxDfn,x);
      if( (StdCPtr)x3 != (StdCPtr)NULL )
        *x3 = (GLS_Tok)GLS_ign_Skip(y);
      x = XGLS_keycom_Skip(rst(x)); y = fst(styxDfn,x);
      if( (StdCPtr)x4 != (StdCPtr)NULL )
        *x4 = (GLS_Lst(styxPrd))GLS_ign_Skip(y);
    }
  }
  return True;
}

/*I--------------------------------- Cat ---------------------------------- */

c_bool styxCat_letC(styxCat x)
{
  assert0(  PT_THISNTM((PT_Term)x, CfgSyms[79])
        || PT_THISNTM((PT_Term)x, CfgSyms[80]), "Cat expected" );
  if( ! PT_THISPRD((PT_Term)x, PrdSyms[66]) ) return False;
  return True;
}

c_bool styxCat_bgnC(styxCat x)
{
  assert0(  PT_THISNTM((PT_Term)x, CfgSyms[79])
        || PT_THISNTM((PT_Term)x, CfgSyms[80]), "Cat expected" );
  if( ! PT_THISPRD((PT_Term)x, PrdSyms[65]) ) return False;
  return True;
}

/*I-------------------------------- DfnOpt -------------------------------- */

c_bool styxDfnOpt_non(styxDfnOpt x)
{
  assert0(  PT_THISNTM((PT_Term)x, CfgSyms[81]), "DfnOpt expected" );
  if( ! PT_THISPRD((PT_Term)x, PrdSyms[69]) ) return False;
  return True;
}

c_bool styxDfnOpt_errnt(styxDfnOpt x)
{
  assert0(  PT_THISNTM((PT_Term)x, CfgSyms[81]), "DfnOpt expected" );
  if( ! PT_THISPRD((PT_Term)x, PrdSyms[70]) ) return False;
  return True;
}

/*I--------------------------------- Lay ---------------------------------- */

c_bool styxLay_grp(styxLay x)
{
  assert0(  PT_THISNTM((PT_Term)x, CfgSyms[83]), "Lay expected" );
  if( ! PT_THISPRD((PT_Term)x, PrdSyms[75]) ) return False;
  return True;
}

c_bool styxLay_rec(styxLay x)
{
  assert0(  PT_THISNTM((PT_Term)x, CfgSyms[83]), "Lay expected" );
  if( ! PT_THISPRD((PT_Term)x, PrdSyms[74]) ) return False;
  return True;
}

c_bool styxLay_dft(styxLay x)
{
  assert0(  PT_THISNTM((PT_Term)x, CfgSyms[83]), "Lay expected" );
  if( ! PT_THISPRD((PT_Term)x, PrdSyms[73]) ) return False;
  return True;
}

/*I--------------------------------- Prd ---------------------------------- */

c_bool styxPrd_prod(styxPrd x, styxLay* x1, GLS_Tok* x2,
                    GLS_Lst(styxMbr)* x3)
{
  assert0(  PT_THISNTM((PT_Term)x, CfgSyms[84]), "Prd expected" );
  if( ! PT_THISPRD((PT_Term)x, PrdSyms[76]) ) return False;
  { PT_Term y;
    if( ! PT_isXaron(x) )
    {
      x = (styxPrd)GLS_keycom_Skip(PT_parts(x));
      if( (StdCPtr)x1 != (StdCPtr)NULL )
        *x1 = (styxLay)GLS_ign_Skip(x);
      x = (styxPrd)GLS_keycom_Skip(PT_next(x));
      if( (StdCPtr)x2 != (StdCPtr)NULL )
        *x2 = (GLS_Tok)GLS_ign_Skip(x);
      x = (styxPrd)GLS_keycom_Skip(PT_next(x));
      if( (StdCPtr)x3 != (StdCPtr)NULL )
        *x3 = (GLS_Lst(styxMbr))GLS_ign_Skip(x);
    }
    else
    {
      x = XGLS_keycom_Skip(XPT_parts(x)); y = fst(styxPrd,x);
      if( (StdCPtr)x1 != (StdCPtr)NULL )
        *x1 = (styxLay)GLS_ign_Skip(y);
      x = XGLS_keycom_Skip(rst(x)); y = fst(styxPrd,x);
      if( (StdCPtr)x2 != (StdCPtr)NULL )
        *x2 = (GLS_Tok)GLS_ign_Skip(y);
      x = XGLS_keycom_Skip(rst(x)); y = fst(styxPrd,x);
      if( (StdCPtr)x3 != (StdCPtr)NULL )
        *x3 = (GLS_Lst(styxMbr))GLS_ign_Skip(y);
    }
  }
  return True;
}

/*I--------------------------------- Mbr ---------------------------------- */

c_bool styxMbr_opt(styxMbr x, GLS_Lst(GLS_Tok)* x1, styxMbr* x2,
                   GLS_Lst(GLS_Tok)* x3)
{
  assert0(  PT_THISNTM((PT_Term)x, CfgSyms[87])
        || PT_THISNTM((PT_Term)x, CfgSyms[86]), "Mbr expected" );
  if( ! PT_THISPRD((PT_Term)x, PrdSyms[85]) ) return False;
  { PT_Term y;
    if( ! PT_isXaron(x) )
    {
      x = (styxMbr)GLS_keycom_Skip(PT_parts(x));
      if( (StdCPtr)x1 != (StdCPtr)NULL )
        *x1 = (GLS_Lst(GLS_Tok))GLS_ign_Skip(x);
      x = (styxMbr)GLS_keycom_Skip(PT_next(x));
      if( (StdCPtr)x2 != (StdCPtr)NULL )
        *x2 = (styxMbr)GLS_ign_Skip(x);
      x = (styxMbr)GLS_keycom_Skip(PT_next(x));
      if( (StdCPtr)x3 != (StdCPtr)NULL )
        *x3 = (GLS_Lst(GLS_Tok))GLS_ign_Skip(x);
    }
    else
    {
      x = XGLS_keycom_Skip(XPT_parts(x)); y = fst(styxMbr,x);
      if( (StdCPtr)x1 != (StdCPtr)NULL )
        *x1 = (GLS_Lst(GLS_Tok))GLS_ign_Skip(y);
      x = XGLS_keycom_Skip(rst(x)); y = fst(styxMbr,x);
      if( (StdCPtr)x2 != (StdCPtr)NULL )
        *x2 = (styxMbr)GLS_ign_Skip(y);
      x = XGLS_keycom_Skip(rst(x)); y = fst(styxMbr,x);
      if( (StdCPtr)x3 != (StdCPtr)NULL )
        *x3 = (GLS_Lst(GLS_Tok))GLS_ign_Skip(y);
    }
  }
  return True;
}

c_bool styxMbr_dtok(styxMbr x, GLS_Tok* x1, GLS_Tok* x2)
{
  assert0(  PT_THISNTM((PT_Term)x, CfgSyms[87])
        || PT_THISNTM((PT_Term)x, CfgSyms[86]), "Mbr expected" );
  if( ! PT_THISPRD((PT_Term)x, PrdSyms[86]) ) return False;
  { PT_Term y;
    if( ! PT_isXaron(x) )
    {
      x = (styxMbr)GLS_keycom_Skip(PT_parts(x));
      if( (StdCPtr)x1 != (StdCPtr)NULL )
        *x1 = (GLS_Tok)GLS_ign_Skip(x);
      x = (styxMbr)GLS_keycom_Skip(PT_next(x));
      if( (StdCPtr)x2 != (StdCPtr)NULL )
        *x2 = (GLS_Tok)GLS_ign_Skip(x);
    }
    else
    {
      x = XGLS_keycom_Skip(XPT_parts(x)); y = fst(styxMbr,x);
      if( (StdCPtr)x1 != (StdCPtr)NULL )
        *x1 = (GLS_Tok)GLS_ign_Skip(y);
      x = XGLS_keycom_Skip(rst(x)); y = fst(styxMbr,x);
      if( (StdCPtr)x2 != (StdCPtr)NULL )
        *x2 = (GLS_Tok)GLS_ign_Skip(y);
    }
  }
  return True;
}

c_bool styxMbr_klst1(styxMbr x, GLS_Lst(GLS_Tok)* x1, styxMbr* x2,
                     GLS_Lst(GLS_Tok)* x3, GLS_Lst(GLS_Tok)* x4)
{
  assert0(  PT_THISNTM((PT_Term)x, CfgSyms[87])
        || PT_THISNTM((PT_Term)x, CfgSyms[86]), "Mbr expected" );
  if( ! PT_THISPRD((PT_Term)x, PrdSyms[84]) ) return False;
  { PT_Term y;
    if( ! PT_isXaron(x) )
    {
      x = (styxMbr)GLS_keycom_Skip(PT_parts(x));
      if( (StdCPtr)x1 != (StdCPtr)NULL )
        *x1 = (GLS_Lst(GLS_Tok))GLS_ign_Skip(x);
      x = (styxMbr)GLS_keycom_Skip(PT_next(x));
      if( (StdCPtr)x2 != (StdCPtr)NULL )
        *x2 = (styxMbr)GLS_ign_Skip(x);
      x = (styxMbr)GLS_keycom_Skip(PT_next(x));
      if( (StdCPtr)x3 != (StdCPtr)NULL )
        *x3 = (GLS_Lst(GLS_Tok))GLS_ign_Skip(x);
      x = (styxMbr)GLS_keycom_Skip(PT_next(x));
      if( (StdCPtr)x4 != (StdCPtr)NULL )
        *x4 = (GLS_Lst(GLS_Tok))GLS_ign_Skip(x);
    }
    else
    {
      x = XGLS_keycom_Skip(XPT_parts(x)); y = fst(styxMbr,x);
      if( (StdCPtr)x1 != (StdCPtr)NULL )
        *x1 = (GLS_Lst(GLS_Tok))GLS_ign_Skip(y);
      x = XGLS_keycom_Skip(rst(x)); y = fst(styxMbr,x);
      if( (StdCPtr)x2 != (StdCPtr)NULL )
        *x2 = (styxMbr)GLS_ign_Skip(y);
      x = XGLS_keycom_Skip(rst(x)); y = fst(styxMbr,x);
      if( (StdCPtr)x3 != (StdCPtr)NULL )
        *x3 = (GLS_Lst(GLS_Tok))GLS_ign_Skip(y);
      x = XGLS_keycom_Skip(rst(x)); y = fst(styxMbr,x);
      if( (StdCPtr)x4 != (StdCPtr)NULL )
        *x4 = (GLS_Lst(GLS_Tok))GLS_ign_Skip(y);
    }
  }
  return True;
}

c_bool styxMbr_tkm(styxMbr x, GLS_Tok* x1)
{
  assert0(  PT_THISNTM((PT_Term)x, CfgSyms[87])
        || PT_THISNTM((PT_Term)x, CfgSyms[86]), "Mbr expected" );
  if( ! PT_THISPRD((PT_Term)x, PrdSyms[79]) ) return False;
  { PT_Term y;
    if( ! PT_isXaron(x) )
    {
      x = (styxMbr)GLS_keycom_Skip(PT_parts(x));
      if( (StdCPtr)x1 != (StdCPtr)NULL )
        *x1 = (GLS_Tok)GLS_ign_Skip(x);
    }
    else
    {
      x = XGLS_keycom_Skip(XPT_parts(x)); y = fst(styxMbr,x);
      if( (StdCPtr)x1 != (StdCPtr)NULL )
        *x1 = (GLS_Tok)GLS_ign_Skip(y);
    }
  }
  return True;
}

c_bool styxMbr_ntm(styxMbr x, GLS_Tok* x1)
{
  assert0(  PT_THISNTM((PT_Term)x, CfgSyms[87])
        || PT_THISNTM((PT_Term)x, CfgSyms[86]), "Mbr expected" );
  if( ! PT_THISPRD((PT_Term)x, PrdSyms[82]) ) return False;
  { PT_Term y;
    if( ! PT_isXaron(x) )
    {
      x = (styxMbr)GLS_keycom_Skip(PT_parts(x));
      if( (StdCPtr)x1 != (StdCPtr)NULL )
        *x1 = (GLS_Tok)GLS_ign_Skip(x);
    }
    else
    {
      x = XGLS_keycom_Skip(XPT_parts(x)); y = fst(styxMbr,x);
      if( (StdCPtr)x1 != (StdCPtr)NULL )
        *x1 = (GLS_Tok)GLS_ign_Skip(y);
    }
  }
  return True;
}

c_bool styxMbr_klst0(styxMbr x, GLS_Lst(GLS_Tok)* x1, styxMbr* x2,
                     GLS_Lst(GLS_Tok)* x3, GLS_Lst(GLS_Tok)* x4)
{
  assert0(  PT_THISNTM((PT_Term)x, CfgSyms[87])
        || PT_THISNTM((PT_Term)x, CfgSyms[86]), "Mbr expected" );
  if( ! PT_THISPRD((PT_Term)x, PrdSyms[83]) ) return False;
  { PT_Term y;
    if( ! PT_isXaron(x) )
    {
      x = (styxMbr)GLS_keycom_Skip(PT_parts(x));
      if( (StdCPtr)x1 != (StdCPtr)NULL )
        *x1 = (GLS_Lst(GLS_Tok))GLS_ign_Skip(x);
      x = (styxMbr)GLS_keycom_Skip(PT_next(x));
      if( (StdCPtr)x2 != (StdCPtr)NULL )
        *x2 = (styxMbr)GLS_ign_Skip(x);
      x = (styxMbr)GLS_keycom_Skip(PT_next(x));
      if( (StdCPtr)x3 != (StdCPtr)NULL )
        *x3 = (GLS_Lst(GLS_Tok))GLS_ign_Skip(x);
      x = (styxMbr)GLS_keycom_Skip(PT_next(x));
      if( (StdCPtr)x4 != (StdCPtr)NULL )
        *x4 = (GLS_Lst(GLS_Tok))GLS_ign_Skip(x);
    }
    else
    {
      x = XGLS_keycom_Skip(XPT_parts(x)); y = fst(styxMbr,x);
      if( (StdCPtr)x1 != (StdCPtr)NULL )
        *x1 = (GLS_Lst(GLS_Tok))GLS_ign_Skip(y);
      x = XGLS_keycom_Skip(rst(x)); y = fst(styxMbr,x);
      if( (StdCPtr)x2 != (StdCPtr)NULL )
        *x2 = (styxMbr)GLS_ign_Skip(y);
      x = XGLS_keycom_Skip(rst(x)); y = fst(styxMbr,x);
      if( (StdCPtr)x3 != (StdCPtr)NULL )
        *x3 = (GLS_Lst(GLS_Tok))GLS_ign_Skip(y);
      x = XGLS_keycom_Skip(rst(x)); y = fst(styxMbr,x);
      if( (StdCPtr)x4 != (StdCPtr)NULL )
        *x4 = (GLS_Lst(GLS_Tok))GLS_ign_Skip(y);
    }
  }
  return True;
}

c_bool styxMbr_else(styxMbr x)
{
  assert0(  PT_THISNTM((PT_Term)x, CfgSyms[87])
        || PT_THISNTM((PT_Term)x, CfgSyms[86]), "Mbr expected" );
  if( ! PT_THISPRD((PT_Term)x, PrdSyms[80]) ) return False;
  return True;
}

/*I------------------------------- Conflict ------------------------------- */

c_bool styxConflict_defn(styxConflict x, styxState* x1, styxToken* x2,
                         GLS_Lst(styxRule)* x3)
{
  assert0(  PT_THISNTM((PT_Term)x, CfgSyms[90]), "Conflict expected" );
  if( ! PT_THISPRD((PT_Term)x, PrdSyms[91]) ) return False;
  { PT_Term y;
    if( ! PT_isXaron(x) )
    {
      x = (styxConflict)GLS_keycom_Skip(PT_parts(x));
      if( (StdCPtr)x1 != (StdCPtr)NULL )
        *x1 = (styxState)GLS_ign_Skip(x);
      x = (styxConflict)GLS_keycom_Skip(PT_next(x));
      if( (StdCPtr)x2 != (StdCPtr)NULL )
        *x2 = (styxToken)GLS_ign_Skip(x);
      x = (styxConflict)GLS_keycom_Skip(PT_next(x));
      if( (StdCPtr)x3 != (StdCPtr)NULL )
        *x3 = (GLS_Lst(styxRule))GLS_ign_Skip(x);
    }
    else
    {
      x = XGLS_keycom_Skip(XPT_parts(x)); y = fst(styxConflict,x);
      if( (StdCPtr)x1 != (StdCPtr)NULL )
        *x1 = (styxState)GLS_ign_Skip(y);
      x = XGLS_keycom_Skip(rst(x)); y = fst(styxConflict,x);
      if( (StdCPtr)x2 != (StdCPtr)NULL )
        *x2 = (styxToken)GLS_ign_Skip(y);
      x = XGLS_keycom_Skip(rst(x)); y = fst(styxConflict,x);
      if( (StdCPtr)x3 != (StdCPtr)NULL )
        *x3 = (GLS_Lst(styxRule))GLS_ign_Skip(y);
    }
  }
  return True;
}

/*I-------------------------------- State --------------------------------- */

c_bool styxState_nat(styxState x, GLS_Tok* x1)
{
  assert0(  PT_THISNTM((PT_Term)x, CfgSyms[91]), "State expected" );
  if( ! PT_THISPRD((PT_Term)x, PrdSyms[92]) ) return False;
  { PT_Term y;
    if( ! PT_isXaron(x) )
    {
      x = (styxState)GLS_keycom_Skip(PT_parts(x));
      if( (StdCPtr)x1 != (StdCPtr)NULL )
        *x1 = (GLS_Tok)GLS_ign_Skip(x);
    }
    else
    {
      x = XGLS_keycom_Skip(XPT_parts(x)); y = fst(styxState,x);
      if( (StdCPtr)x1 != (StdCPtr)NULL )
        *x1 = (GLS_Tok)GLS_ign_Skip(y);
    }
  }
  return True;
}

c_bool styxState_ide(styxState x, GLS_Tok* x1)
{
  assert0(  PT_THISNTM((PT_Term)x, CfgSyms[91]), "State expected" );
  if( ! PT_THISPRD((PT_Term)x, PrdSyms[94]) ) return False;
  { PT_Term y;
    if( ! PT_isXaron(x) )
    {
      x = (styxState)GLS_keycom_Skip(PT_parts(x));
      if( (StdCPtr)x1 != (StdCPtr)NULL )
        *x1 = (GLS_Tok)GLS_ign_Skip(x);
    }
    else
    {
      x = XGLS_keycom_Skip(XPT_parts(x)); y = fst(styxState,x);
      if( (StdCPtr)x1 != (StdCPtr)NULL )
        *x1 = (GLS_Tok)GLS_ign_Skip(y);
    }
  }
  return True;
}

c_bool styxState_seq(styxState x, GLS_Tok* x1)
{
  assert0(  PT_THISNTM((PT_Term)x, CfgSyms[91]), "State expected" );
  if( ! PT_THISPRD((PT_Term)x, PrdSyms[93]) ) return False;
  { PT_Term y;
    if( ! PT_isXaron(x) )
    {
      x = (styxState)GLS_keycom_Skip(PT_parts(x));
      if( (StdCPtr)x1 != (StdCPtr)NULL )
        *x1 = (GLS_Tok)GLS_ign_Skip(x);
    }
    else
    {
      x = XGLS_keycom_Skip(XPT_parts(x)); y = fst(styxState,x);
      if( (StdCPtr)x1 != (StdCPtr)NULL )
        *x1 = (GLS_Tok)GLS_ign_Skip(y);
    }
  }
  return True;
}

/*I-------------------------------- Token --------------------------------- */

c_bool styxToken_seq(styxToken x, GLS_Tok* x1)
{
  assert0(  PT_THISNTM((PT_Term)x, CfgSyms[92]), "Token expected" );
  if( ! PT_THISPRD((PT_Term)x, PrdSyms[95]) ) return False;
  { PT_Term y;
    if( ! PT_isXaron(x) )
    {
      x = (styxToken)GLS_keycom_Skip(PT_parts(x));
      if( (StdCPtr)x1 != (StdCPtr)NULL )
        *x1 = (GLS_Tok)GLS_ign_Skip(x);
    }
    else
    {
      x = XGLS_keycom_Skip(XPT_parts(x)); y = fst(styxToken,x);
      if( (StdCPtr)x1 != (StdCPtr)NULL )
        *x1 = (GLS_Tok)GLS_ign_Skip(y);
    }
  }
  return True;
}

c_bool styxToken_ide(styxToken x, GLS_Tok* x1)
{
  assert0(  PT_THISNTM((PT_Term)x, CfgSyms[92]), "Token expected" );
  if( ! PT_THISPRD((PT_Term)x, PrdSyms[96]) ) return False;
  { PT_Term y;
    if( ! PT_isXaron(x) )
    {
      x = (styxToken)GLS_keycom_Skip(PT_parts(x));
      if( (StdCPtr)x1 != (StdCPtr)NULL )
        *x1 = (GLS_Tok)GLS_ign_Skip(x);
    }
    else
    {
      x = XGLS_keycom_Skip(XPT_parts(x)); y = fst(styxToken,x);
      if( (StdCPtr)x1 != (StdCPtr)NULL )
        *x1 = (GLS_Tok)GLS_ign_Skip(y);
    }
  }
  return True;
}

/*I--------------------------------- Rule --------------------------------- */

c_bool styxRule_red(styxRule x, GLS_Tok* x1, GLS_Tok* x2)
{
  assert0(  PT_THISNTM((PT_Term)x, CfgSyms[95]), "Rule expected" );
  if( ! PT_THISPRD((PT_Term)x, PrdSyms[100]) ) return False;
  { PT_Term y;
    if( ! PT_isXaron(x) )
    {
      x = (styxRule)GLS_keycom_Skip(PT_parts(x));
      if( (StdCPtr)x1 != (StdCPtr)NULL )
        *x1 = (GLS_Tok)GLS_ign_Skip(x);
      x = (styxRule)GLS_keycom_Skip(PT_next(x));
      if( (StdCPtr)x2 != (StdCPtr)NULL )
        *x2 = (GLS_Tok)GLS_ign_Skip(x);
    }
    else
    {
      x = XGLS_keycom_Skip(XPT_parts(x)); y = fst(styxRule,x);
      if( (StdCPtr)x1 != (StdCPtr)NULL )
        *x1 = (GLS_Tok)GLS_ign_Skip(y);
      x = XGLS_keycom_Skip(rst(x)); y = fst(styxRule,x);
      if( (StdCPtr)x2 != (StdCPtr)NULL )
        *x2 = (GLS_Tok)GLS_ign_Skip(y);
    }
  }
  return True;
}
