/* This file is part of Strigi Desktop Search
 *
 * Copyright (C) 2006 Jos van den Oever <jos@vandenoever.info>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this library; see the file COPYING.LIB.  If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */
/***************************************************************************
 *   Copyright (C) 2006 by Jos van den Oever   *
 *   oever@fs7020   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include <kglobal.h>
#include <klocale.h>
#include <kconfig.h>
#include <kapplication.h>
#include <kmessagebox.h>
#include <kiconloader.h>

#include "strigiapplet.h"
#include <qlineedit.h>
#include <krun.h>
#include "strigilineedit.h"


StrigiApplet::StrigiApplet(const QString& configFile, Type type, int actions, QWidget *parent, const char *name)
    : KPanelApplet(configFile, type, actions, parent, name)
{
    // Get the current application configuration handle
    ksConfig = config();

    lineedit = new StrigiLineEdit(this);
    lineedit->setFocus();
    watchForFocus(lineedit);
    lineedit->show();

    //setBackgroundMode(Qt::FixedPixmap);
    KIconLoader loader;
    QPixmap background = loader.loadIcon("kfind", KIcon::Desktop, 32);
//    lineedit->setBackground(background);
}

StrigiApplet::~StrigiApplet()
{
}

void StrigiApplet::about()
{
    KRun::runCommand("kfmclient newTab 'strigi:about'");
}

void StrigiApplet::help()
{
    KRun::runCommand("kfmclient newTab 'strigi:help'");
}

void StrigiApplet::preferences()
{
    KRun::runCommand("kfmclient newTab 'strigi:config'");
}

int StrigiApplet::widthForHeight(int /*height*/) const
{
    return lineedit->width();
}

int StrigiApplet::heightForWidth(int /*width*/) const
{
    return lineedit->height();
}

void StrigiApplet::resizeEvent(QResizeEvent */*e*/)
{
}

extern "C"
{
    KPanelApplet* init( QWidget *parent, const QString& configFile)
    {
        KGlobal::locale()->insertCatalogue("StrigiApplet");
        return new StrigiApplet(configFile, KPanelApplet::Normal,
                             KPanelApplet::About | KPanelApplet::Help | KPanelApplet::Preferences,
                             parent, "StrigiApplet");
    }
}
