/* This file is part of Strigi Desktop Search
 *
 * Copyright (C) 2006 Jos van den Oever <jos@vandenoever.info>
 *                    Ben van Klinken <bvanklinken@gmail.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this library; see the file COPYING.LIB.  If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */
#ifndef STRIGI_THREAD_H
#define STRIGI_THREAD_H

#if defined(CMAKE_HAVE_PTHREAD_CREATE)
    #include <pthread.h>
    #define STRIGI_DEFINE_MUTEX(x) pthread_mutex_t x;
    #define STRIGI_INIT_MUTEX(x) pthread_mutex_init(&x, 0)
    #define STRIGI_CLOSE_MUTEX(x) pthread_mutex_destroy(&x)
    #define STRIGI_LOCK_MUTEX(x) pthread_mutex_lock(&x)
    #define STRIGI_UNLOCK_MUTEX(x) pthread_mutex_unlock(&x)
#elif defined(CMAKE_USE_WIN32_THREADS_INIT)
    #define STRIGI_DEFINE_MUTEX(x) CRITICAL_SECTION x;
    #define STRIGI_INIT_MUTEX(x) InitializeCriticalSection(&x)
    #define STRIGI_CLOSE_MUTEX(x) DeleteCriticalSection(&x)
    #define STRIGI_LOCK_MUTEX(x) EnterCriticalSection(&x)
    #define STRIGI_UNLOCK_MUTEX(x) LeaveCriticalSection(&x)
#else
    #error A valid thread library was not found
#endif //mutex types

class StrigiMutex{
public:
    STRIGI_DEFINE_MUTEX(lock);
    StrigiMutex(){
        STRIGI_INIT_MUTEX(lock);
    }
    ~StrigiMutex(){
        STRIGI_CLOSE_MUTEX(lock);
    }
};

#endif
