// Copyright (C) 2005-2006 Code Synthesis Tools CC
//
// This program was generated by XML Schema Definition Compiler (XSD)
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License version 2 as
// published by the Free Software Foundation.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA
//
// In addition, as a special exception, Code Synthesis Tools CC gives
// permission to link this program with the Xerces-C++ library (or with
// modified versions of Xerces-C++ that use the same license as Xerces-C++),
// and distribute linked combinations including the two. You must obey
// the GNU General Public License version 2 in all respects for all of
// the code used other than Xerces-C++. If you modify this copy of the
// program, you may extend this exception to your version of the program,
// but you are not obligated to do so. If you do not wish to do so, delete
// this exception statement from your version.
//
// In addition, Code Synthesis Tools CC makes a special exception for
// the Free/Libre and Open Source Software (FLOSS) which is described
// in the accompanying FLOSSE file.
//

// Begin prologue.
//
//
// End prologue.

#include <xsd/cxx/pre.hxx>

#include "strigidaemon.hxx"

namespace strigi
{
  // daemonConfigurationType
  // 

  const daemonConfigurationType::repository::container& daemonConfigurationType::
  repository () const
  {
    return this->_xsd_repository_;
  }

  daemonConfigurationType::repository::container& daemonConfigurationType::
  repository ()
  {
    return this->_xsd_repository_;
  }

  void daemonConfigurationType::
  repository (const repository::container& repository)
  {
    this->_xsd_repository_ = repository;
  }


  // repositoryType
  // 

  const repositoryType::fileSystemSource::container& repositoryType::
  fileSystemSource () const
  {
    return this->_xsd_fileSystemSource_;
  }

  repositoryType::fileSystemSource::container& repositoryType::
  fileSystemSource ()
  {
    return this->_xsd_fileSystemSource_;
  }

  void repositoryType::
  fileSystemSource (const fileSystemSource::container& fileSystemSource)
  {
    this->_xsd_fileSystemSource_ = fileSystemSource;
  }

  const repositoryType::httpSource::container& repositoryType::
  httpSource () const
  {
    return this->_xsd_httpSource_;
  }

  repositoryType::httpSource::container& repositoryType::
  httpSource ()
  {
    return this->_xsd_httpSource_;
  }

  void repositoryType::
  httpSource (const httpSource::container& httpSource)
  {
    this->_xsd_httpSource_ = httpSource;
  }

  const repositoryType::repositoryLocation::type& repositoryType::
  repositoryLocation () const
  {
    return this->_xsd_repositoryLocation_.get ();
  }

  repositoryType::repositoryLocation::type& repositoryType::
  repositoryLocation ()
  {
    return this->_xsd_repositoryLocation_.get ();
  }

  void repositoryType::
  repositoryLocation (const repositoryLocation::type& repositoryLocation)
  {
    this->_xsd_repositoryLocation_.set (repositoryLocation);
  }

  void repositoryType::
  repositoryLocation (::std::auto_ptr< repositoryLocation::type > repositoryLocation)
  {
    this->_xsd_repositoryLocation_.set (repositoryLocation);
  }

  const repositoryType::repositoryType1::type& repositoryType::
  repositoryType1 () const
  {
    return this->_xsd_repositoryType1_.get ();
  }

  repositoryType::repositoryType1::type& repositoryType::
  repositoryType1 ()
  {
    return this->_xsd_repositoryType1_.get ();
  }

  void repositoryType::
  repositoryType1 (const repositoryType1::type& repositoryType1)
  {
    this->_xsd_repositoryType1_.set (repositoryType1);
  }

  void repositoryType::
  repositoryType1 (::std::auto_ptr< repositoryType1::type > repositoryType1)
  {
    this->_xsd_repositoryType1_.set (repositoryType1);
  }


  // repositoryTypeType
  // 

  repositoryTypeType::
  repositoryTypeType (_xsd_repositoryTypeType v)
  : ::xml_schema::string (
    ::std::basic_string< char > (_xsd_repositoryTypeType_literals_[v]), 0, 0, 0)
  {
  }

  repositoryTypeType::
  repositoryTypeType (const ::xml_schema::string& _xsd_repositoryTypeType)
  : ::xml_schema::string(_xsd_repositoryTypeType)
  {
  }

  repositoryTypeType::
  repositoryTypeType (const repositoryTypeType& v,
                      ::xsd::cxx::tree::flags f,
                      ::xsd::cxx::tree::type* c)
  : ::xml_schema::string (v, f, c)
  {
  }

  repositoryTypeType& repositoryTypeType::
  operator= (_xsd_repositoryTypeType v)
  {
    static_cast< ::xml_schema::string& > (*this) = ::xml_schema::string (
      ::std::basic_string< char > (_xsd_repositoryTypeType_literals_[v]), 0, 0, 0);
    return *this;
  }


  // fileSourceType
  // 

  const fileSourceType::baseURI::type& fileSourceType::
  baseURI () const
  {
    return this->_xsd_baseURI_.get ();
  }

  fileSourceType::baseURI::type& fileSourceType::
  baseURI ()
  {
    return this->_xsd_baseURI_.get ();
  }

  void fileSourceType::
  baseURI (const baseURI::type& baseURI)
  {
    this->_xsd_baseURI_.set (baseURI);
  }

  void fileSourceType::
  baseURI (::std::auto_ptr< baseURI::type > baseURI)
  {
    this->_xsd_baseURI_.set (baseURI);
  }

  const fileSourceType::autoUpdateFrequence::container& fileSourceType::
  autoUpdateFrequence () const
  {
    return this->_xsd_autoUpdateFrequence_;
  }

  fileSourceType::autoUpdateFrequence::container& fileSourceType::
  autoUpdateFrequence ()
  {
    return this->_xsd_autoUpdateFrequence_;
  }

  void fileSourceType::
  autoUpdateFrequence (const autoUpdateFrequence::type& autoUpdateFrequence)
  {
    this->_xsd_autoUpdateFrequence_.set (autoUpdateFrequence);
  }

  void fileSourceType::
  autoUpdateFrequence (const autoUpdateFrequence::container& autoUpdateFrequence)
  {
    this->_xsd_autoUpdateFrequence_ = autoUpdateFrequence;
  }


  // fileSystemSourceType
  // 

  // fileSystemSourceType::fileEventListener::_xsd_fileEventListener_::fileEventListener
  // 


  const fileSystemSourceType::fileEventListener::container& fileSystemSourceType::
  fileEventListener () const
  {
    return this->_xsd_fileEventListener_;
  }

  fileSystemSourceType::fileEventListener::container& fileSystemSourceType::
  fileEventListener ()
  {
    return this->_xsd_fileEventListener_;
  }

  void fileSystemSourceType::
  fileEventListener (const fileEventListener::type& fileEventListener)
  {
    this->_xsd_fileEventListener_.set (fileEventListener);
  }

  void fileSystemSourceType::
  fileEventListener (const fileEventListener::container& fileEventListener)
  {
    this->_xsd_fileEventListener_ = fileEventListener;
  }

  void fileSystemSourceType::
  fileEventListener (::std::auto_ptr< fileEventListener::type > fileEventListener)
  {
    this->_xsd_fileEventListener_.set (fileEventListener);
  }


  // httpSourceType
  // 
}

#include <xsd/cxx/xml/dom/parser.hxx>

namespace strigi
{
  // daemonConfigurationType
  //

  daemonConfigurationType::
  daemonConfigurationType ()
  : ::xsd::cxx::tree::type (),
  _xsd_repository_ (::xsd::cxx::tree::flags (), this)
  {
  }

  daemonConfigurationType::
  daemonConfigurationType (const daemonConfigurationType& _xsd_daemonConfigurationType,
                           ::xsd::cxx::tree::flags f,
                           ::xsd::cxx::tree::type* c)
  : ::xsd::cxx::tree::type (_xsd_daemonConfigurationType, f, c),
  _xsd_repository_ (_xsd_daemonConfigurationType._xsd_repository_,
                    f | ::xsd::cxx::tree::flags::not_root,
                    this)
  {
  }

  daemonConfigurationType::
  daemonConfigurationType (const ::xsd::cxx::xml::dom::element< char >& e,
                           ::xsd::cxx::tree::flags f,
                           ::xsd::cxx::tree::type* c)
  : ::xsd::cxx::tree::type (e, f, c),
  _xsd_repository_ (f | ::xsd::cxx::tree::flags::not_root, this)
  {

    parse (e, f);
  }

  ::strigi::daemonConfigurationType* daemonConfigurationType::
  _clone (::xsd::cxx::tree::flags f,
          ::xsd::cxx::tree::type* c) const
  {
    return new daemonConfigurationType (*this, f, c);
  }

  void daemonConfigurationType::
  parse (const ::xsd::cxx::xml::dom::element< char >& e,
         ::xsd::cxx::tree::flags f)
  {
    ::xsd::cxx::xml::dom::parser< char > p (e);

    while (p.more_elements ())
    {
      ::xsd::cxx::xml::dom::element< char > e (p.next_element ());

      // repository
      //
      {
        if (e.name () == "repository" && e.namespace_ ().empty ())
        {
          ::std::auto_ptr< repository::type > r (
            repository::traits::create (
              e, f | ::xsd::cxx::tree::flags::not_root, this));

          this->repository ().push_back (r);
          continue;
        }
      }
    }
  }

  // repositoryType
  //

  repositoryType::
  repositoryType (const repositoryLocation::type& _xsd_repositoryLocation,
                  const repositoryType1::type& _xsd_repositoryType1)
  : ::xsd::cxx::tree::type (),
  _xsd_fileSystemSource_ (::xsd::cxx::tree::flags (), this),
  _xsd_httpSource_ (::xsd::cxx::tree::flags (), this),
  _xsd_repositoryLocation_ (_xsd_repositoryLocation,
                            ::xsd::cxx::tree::flags (),
                            this),
  _xsd_repositoryType1_ (_xsd_repositoryType1,
                         ::xsd::cxx::tree::flags (),
                         this)
  {
  }

  repositoryType::
  repositoryType (const repositoryType& _xsd_repositoryType,
                  ::xsd::cxx::tree::flags f,
                  ::xsd::cxx::tree::type* c)
  : ::xsd::cxx::tree::type (_xsd_repositoryType, f, c),
  _xsd_fileSystemSource_ (_xsd_repositoryType._xsd_fileSystemSource_,
                          f | ::xsd::cxx::tree::flags::not_root,
                          this),
  _xsd_httpSource_ (_xsd_repositoryType._xsd_httpSource_,
                    f | ::xsd::cxx::tree::flags::not_root,
                    this),
  _xsd_repositoryLocation_ (_xsd_repositoryType._xsd_repositoryLocation_,
                            f | ::xsd::cxx::tree::flags::not_root,
                            this),
  _xsd_repositoryType1_ (_xsd_repositoryType._xsd_repositoryType1_,
                         f | ::xsd::cxx::tree::flags::not_root,
                         this)
  {
  }

  repositoryType::
  repositoryType (const ::xsd::cxx::xml::dom::element< char >& e,
                  ::xsd::cxx::tree::flags f,
                  ::xsd::cxx::tree::type* c)
  : ::xsd::cxx::tree::type (e, f, c),
  _xsd_fileSystemSource_ (f | ::xsd::cxx::tree::flags::not_root, this),
  _xsd_httpSource_ (f | ::xsd::cxx::tree::flags::not_root, this),
  _xsd_repositoryLocation_ (f | ::xsd::cxx::tree::flags::not_root, this),
  _xsd_repositoryType1_ (f | ::xsd::cxx::tree::flags::not_root, this)
  {

    parse (e, f);
  }

  ::strigi::repositoryType* repositoryType::
  _clone (::xsd::cxx::tree::flags f,
          ::xsd::cxx::tree::type* c) const
  {
    return new repositoryType (*this, f, c);
  }

  void repositoryType::
  parse (const ::xsd::cxx::xml::dom::element< char >& e,
         ::xsd::cxx::tree::flags f)
  {
    ::xsd::cxx::xml::dom::parser< char > p (e);

    while (p.more_elements ())
    {
      ::xsd::cxx::xml::dom::element< char > e (p.next_element ());

      // fileSystemSource
      //
      {
        if (e.name () == "fileSystemSource" && e.namespace_ ().empty ())
        {
          ::std::auto_ptr< fileSystemSource::type > r (
            fileSystemSource::traits::create (
              e, f | ::xsd::cxx::tree::flags::not_root, this));

          this->fileSystemSource ().push_back (r);
          continue;
        }
      }

      // httpSource
      //
      {
        if (e.name () == "httpSource" && e.namespace_ ().empty ())
        {
          ::std::auto_ptr< httpSource::type > r (
            httpSource::traits::create (
              e, f | ::xsd::cxx::tree::flags::not_root, this));

          this->httpSource ().push_back (r);
          continue;
        }
      }
    }

    while (p.more_attributes ())
    {
      ::xsd::cxx::xml::dom::attribute< char > a (p.next_attribute ());

      if (a.name () == "repositoryLocation" && a.namespace_ ().empty ())
      {
        ::std::auto_ptr< repositoryLocation::type > r (
          repositoryLocation::traits::create (
            a, f | ::xsd::cxx::tree::flags::not_root, this));

        this->repositoryLocation (r);
        continue;
      }

      if (a.name () == "repositoryType" && a.namespace_ ().empty ())
      {
        ::std::auto_ptr< repositoryType1::type > r (
          repositoryType1::traits::create (
            a, f | ::xsd::cxx::tree::flags::not_root, this));

        this->repositoryType1 (r);
        continue;
      }
    }

    if (!_xsd_repositoryLocation_.present ())
    {
      throw ::xsd::cxx::tree::expected_attribute< char > (
        "repositoryLocation",
        "");
    }

    if (!_xsd_repositoryType1_.present ())
    {
      throw ::xsd::cxx::tree::expected_attribute< char > (
        "repositoryType",
        "");
    }
  }

  // repositoryTypeType
  //

  repositoryTypeType::
  repositoryTypeType (const ::xsd::cxx::xml::dom::element< char >& e,
                      ::xsd::cxx::tree::flags f,
                      ::xsd::cxx::tree::type* c)
  : ::xml_schema::string (e, f, c)
  {
    _xsd_repositoryTypeType_convert ();
  }

  repositoryTypeType::
  repositoryTypeType (const ::xsd::cxx::xml::dom::attribute< char >& a,
                      ::xsd::cxx::tree::flags f,
                      ::xsd::cxx::tree::type* c)
  : ::xml_schema::string (a, f, c)
  {
    _xsd_repositoryTypeType_convert ();
  }

  repositoryTypeType::
  repositoryTypeType (const ::std::basic_string< char >& s,
                      const ::xsd::cxx::xml::dom::element< char >* e,
                      ::xsd::cxx::tree::flags f,
                      ::xsd::cxx::tree::type* c)
  : ::xml_schema::string (s, e, f, c)
  {
    _xsd_repositoryTypeType_convert ();
  }

  ::strigi::repositoryTypeType* repositoryTypeType::
  _clone (::xsd::cxx::tree::flags f,
          ::xsd::cxx::tree::type* c) const
  {
    return new repositoryTypeType (*this, f, c);
  }

  ::strigi::repositoryTypeType::_xsd_repositoryTypeType repositoryTypeType::
  _xsd_repositoryTypeType_convert () const
  {
    ::xsd::cxx::tree::enum_comparator< char > c (_xsd_repositoryTypeType_literals_);
    const _xsd_repositoryTypeType* i (::std::lower_bound (
                                        _xsd_repositoryTypeType_indexes_,
                                        _xsd_repositoryTypeType_indexes_ + 4,
                                        *this,
                                        c));

    if (i == _xsd_repositoryTypeType_indexes_ + 4 || _xsd_repositoryTypeType_literals_[*i] != *this)
    {
      throw ::xsd::cxx::tree::unexpected_enumerator < char > (*this);
    }

    return *i;
  }

  const char* const repositoryTypeType::
  _xsd_repositoryTypeType_literals_[4] =
  {
    "CLucene",
    "HyperEstraier",
    "Xapian",
    "Sqlite"
  };

  const repositoryTypeType::_xsd_repositoryTypeType repositoryTypeType::
  _xsd_repositoryTypeType_indexes_[4] =
  {
    ::strigi::repositoryTypeType::CLucene,
    ::strigi::repositoryTypeType::HyperEstraier,
    ::strigi::repositoryTypeType::Sqlite,
    ::strigi::repositoryTypeType::Xapian
  };

  // fileSourceType
  //

  fileSourceType::
  fileSourceType (const baseURI::type& _xsd_baseURI)
  : ::xsd::cxx::tree::type (),
  _xsd_baseURI_ (_xsd_baseURI,
                 ::xsd::cxx::tree::flags (),
                 this),
  _xsd_autoUpdateFrequence_ (::xsd::cxx::tree::flags (), this)
  {
  }

  fileSourceType::
  fileSourceType (const fileSourceType& _xsd_fileSourceType,
                  ::xsd::cxx::tree::flags f,
                  ::xsd::cxx::tree::type* c)
  : ::xsd::cxx::tree::type (_xsd_fileSourceType, f, c),
  _xsd_baseURI_ (_xsd_fileSourceType._xsd_baseURI_,
                 f | ::xsd::cxx::tree::flags::not_root,
                 this),
  _xsd_autoUpdateFrequence_ (_xsd_fileSourceType._xsd_autoUpdateFrequence_,
                             f | ::xsd::cxx::tree::flags::not_root,
                             this)
  {
  }

  fileSourceType::
  fileSourceType (const ::xsd::cxx::xml::dom::element< char >& e,
                  ::xsd::cxx::tree::flags f,
                  ::xsd::cxx::tree::type* c)
  : ::xsd::cxx::tree::type (e, f, c),
  _xsd_baseURI_ (f | ::xsd::cxx::tree::flags::not_root, this),
  _xsd_autoUpdateFrequence_ (f | ::xsd::cxx::tree::flags::not_root, this)
  {

    parse (e, f);
  }

  ::strigi::fileSourceType* fileSourceType::
  _clone (::xsd::cxx::tree::flags f,
          ::xsd::cxx::tree::type* c) const
  {
    return new fileSourceType (*this, f, c);
  }

  void fileSourceType::
  parse (const ::xsd::cxx::xml::dom::element< char >& e,
         ::xsd::cxx::tree::flags f)
  {
    ::xsd::cxx::xml::dom::parser< char > p (e);

    while (p.more_attributes ())
    {
      ::xsd::cxx::xml::dom::attribute< char > a (p.next_attribute ());

      if (a.name () == "baseURI" && a.namespace_ ().empty ())
      {
        ::std::auto_ptr< baseURI::type > r (
          baseURI::traits::create (
            a, f | ::xsd::cxx::tree::flags::not_root, this));

        this->baseURI (r);
        continue;
      }

      if (a.name () == "autoUpdateFrequence" && a.namespace_ ().empty ())
      {
        this->autoUpdateFrequence (
          autoUpdateFrequence::traits::create (
            a, f | ::xsd::cxx::tree::flags::not_root, this));
        continue;
      }
    }

    if (!_xsd_baseURI_.present ())
    {
      throw ::xsd::cxx::tree::expected_attribute< char > (
        "baseURI",
        "");
    }
  }

  // fileSystemSourceType
  //

  // fileSystemSourceType::fileEventListener::_xsd_fileEventListener_::fileEventListener
  //

  fileSystemSourceType::fileEventListener::_xsd_fileEventListener_::fileEventListener::
  fileEventListener ()
  : ::xsd::cxx::tree::type ()
  {
  }

  fileSystemSourceType::fileEventListener::_xsd_fileEventListener_::fileEventListener::
  fileEventListener (const fileEventListener& _xsd_fileEventListener,
                     ::xsd::cxx::tree::flags f,
                     ::xsd::cxx::tree::type* c)
  : ::xsd::cxx::tree::type (_xsd_fileEventListener, f, c)
  {
  }

  fileSystemSourceType::fileEventListener::_xsd_fileEventListener_::fileEventListener::
  fileEventListener (const ::xsd::cxx::xml::dom::element< char >& e,
                     ::xsd::cxx::tree::flags f,
                     ::xsd::cxx::tree::type* c)
  : ::xsd::cxx::tree::type (e, f, c)
  {
  }

  fileSystemSourceType::fileEventListener::_xsd_fileEventListener_::fileEventListener::
  fileEventListener (const ::xsd::cxx::xml::dom::attribute< char >& a,
                     ::xsd::cxx::tree::flags f,
                     ::xsd::cxx::tree::type* c)
  : ::xsd::cxx::tree::type (a, f, c)
  {
  }

  fileSystemSourceType::fileEventListener::_xsd_fileEventListener_::fileEventListener::
  fileEventListener (const ::std::basic_string< char >& s,
                     const ::xsd::cxx::xml::dom::element< char >* p,
                     ::xsd::cxx::tree::flags f,
                     ::xsd::cxx::tree::type* c)
  : ::xsd::cxx::tree::type (s, p, f, c)
  {
  }

  fileSystemSourceType::fileEventListener::_xsd_fileEventListener_::fileEventListener* fileSystemSourceType::fileEventListener::_xsd_fileEventListener_::fileEventListener::
  _clone (::xsd::cxx::tree::flags f,
          ::xsd::cxx::tree::type* c) const
  {
    return new fileEventListener (*this, f, c);
  }

  fileSystemSourceType::
  fileSystemSourceType (const baseURI::type& _xsd_baseURI)
  : ::strigi::fileSourceType (_xsd_baseURI),
  _xsd_fileEventListener_ (::xsd::cxx::tree::flags (), this)
  {
  }

  fileSystemSourceType::
  fileSystemSourceType (const fileSystemSourceType& _xsd_fileSystemSourceType,
                        ::xsd::cxx::tree::flags f,
                        ::xsd::cxx::tree::type* c)
  : ::strigi::fileSourceType (_xsd_fileSystemSourceType, f, c),
  _xsd_fileEventListener_ (_xsd_fileSystemSourceType._xsd_fileEventListener_,
                           f | ::xsd::cxx::tree::flags::not_root,
                           this)
  {
  }

  fileSystemSourceType::
  fileSystemSourceType (const ::xsd::cxx::xml::dom::element< char >& e,
                        ::xsd::cxx::tree::flags f,
                        ::xsd::cxx::tree::type* c)
  : ::strigi::fileSourceType (e, f, c),
  _xsd_fileEventListener_ (f | ::xsd::cxx::tree::flags::not_root, this)
  {

    parse (e, f);
  }

  ::strigi::fileSystemSourceType* fileSystemSourceType::
  _clone (::xsd::cxx::tree::flags f,
          ::xsd::cxx::tree::type* c) const
  {
    return new fileSystemSourceType (*this, f, c);
  }

  void fileSystemSourceType::
  parse (const ::xsd::cxx::xml::dom::element< char >& e,
         ::xsd::cxx::tree::flags f)
  {
    ::xsd::cxx::xml::dom::parser< char > p (e);

    while (p.more_elements ())
    {
      ::xsd::cxx::xml::dom::element< char > e (p.next_element ());

      // fileEventListener
      //
      {
        if (e.name () == "fileEventListener" && e.namespace_ ().empty ())
        {
          ::std::auto_ptr< fileEventListener::type > r (
            fileEventListener::traits::create (
              e, f | ::xsd::cxx::tree::flags::not_root, this));

          if (this->fileEventListener ())
          {
            throw ::xsd::cxx::tree::unexpected_element< char > (
              e.name (), e.namespace_ (),
              "", "");
          }

          this->fileEventListener (r);
          continue;
        }
      }
    }
  }

  // httpSourceType
  //

  httpSourceType::
  httpSourceType (const baseURI::type& _xsd_baseURI)
  : ::strigi::fileSourceType (_xsd_baseURI)
  {
  }

  httpSourceType::
  httpSourceType (const httpSourceType& _xsd_httpSourceType,
                  ::xsd::cxx::tree::flags f,
                  ::xsd::cxx::tree::type* c)
  : ::strigi::fileSourceType (_xsd_httpSourceType, f, c)
  {
  }

  httpSourceType::
  httpSourceType (const ::xsd::cxx::xml::dom::element< char >& e,
                  ::xsd::cxx::tree::flags f,
                  ::xsd::cxx::tree::type* c)
  : ::strigi::fileSourceType (e, f, c)
  {
  }

  ::strigi::httpSourceType* httpSourceType::
  _clone (::xsd::cxx::tree::flags f,
          ::xsd::cxx::tree::type* c) const
  {
    return new httpSourceType (*this, f, c);
  }
}

#include <istream>
#include <xercesc/framework/Wrapper4InputSource.hpp>
#include <xsd/cxx/xml/sax/std-input-source.hxx>
#include <xsd/cxx/tree/exceptions.hxx>
#include <xsd/cxx/tree/error-handler.hxx>

namespace strigi
{
  ::std::auto_ptr< ::strigi::daemonConfigurationType >
  daemonConfiguration (const ::std::basic_string< char >& u,
                       ::xsd::cxx::tree::flags f,
                       const ::xsd::cxx::tree::properties< char >& p)
  {
    ::xsd::cxx::xml::auto_initializer i (
      (f & ::xsd::cxx::tree::flags::dont_initialize) == 0,
      (f & ::xsd::cxx::tree::flags::keep_dom) == 0);

    ::xsd::cxx::tree::error_handler< char > h;

    ::xsd::cxx::xml::dom::auto_ptr< ::xercesc::DOMDocument > d (
      ::xsd::cxx::xml::dom::parse< char > (u, h, p, f));

    h.throw_if_failed< ::xsd::cxx::tree::parsing< char > > ();

    return ::strigi::daemonConfiguration (
      static_cast< const ::xercesc::DOMDocument& > (*d), f);
  }

  ::std::auto_ptr< ::strigi::daemonConfigurationType >
  daemonConfiguration (const ::std::basic_string< char >& u,
                       ::xsd::cxx::xml::error_handler< char >& h,
                       ::xsd::cxx::tree::flags f,
                       const ::xsd::cxx::tree::properties< char >& p)
  {
    ::xsd::cxx::xml::auto_initializer i (
      (f & ::xsd::cxx::tree::flags::dont_initialize) == 0,
      (f & ::xsd::cxx::tree::flags::keep_dom) == 0);

    ::xsd::cxx::xml::dom::auto_ptr< ::xercesc::DOMDocument > d (
      ::xsd::cxx::xml::dom::parse< char > (u, h, p, f));

    if (!d)
    {
      throw ::xsd::cxx::tree::parsing< char > ();
    }

    return ::strigi::daemonConfiguration (
      static_cast< const ::xercesc::DOMDocument& > (*d), f);
  }

  ::std::auto_ptr< ::strigi::daemonConfigurationType >
  daemonConfiguration (const ::std::basic_string< char >& u,
                       ::xercesc::DOMErrorHandler& h,
                       ::xsd::cxx::tree::flags f,
                       const ::xsd::cxx::tree::properties< char >& p)
  {
    ::xsd::cxx::xml::dom::auto_ptr< ::xercesc::DOMDocument > d (
      ::xsd::cxx::xml::dom::parse< char > (u, h, p, f));

    if (!d)
    {
      throw ::xsd::cxx::tree::parsing< char > ();
    }

    return ::strigi::daemonConfiguration (
      static_cast< const ::xercesc::DOMDocument& > (*d), f);
  }

  ::std::auto_ptr< ::strigi::daemonConfigurationType >
  daemonConfiguration (::std::istream& is,
                       ::xsd::cxx::tree::flags f,
                       const ::xsd::cxx::tree::properties< char >& p)
  {
    ::xsd::cxx::xml::auto_initializer i (
      (f & ::xsd::cxx::tree::flags::dont_initialize) == 0,
      (f & ::xsd::cxx::tree::flags::keep_dom) == 0);

    ::xsd::cxx::xml::sax::std_input_source isrc (is);
    xercesc::Wrapper4InputSource wrap (&isrc, false);
    return ::strigi::daemonConfiguration (wrap, f, p);
  }

  ::std::auto_ptr< ::strigi::daemonConfigurationType >
  daemonConfiguration (::std::istream& is,
                       ::xsd::cxx::xml::error_handler< char >& h,
                       ::xsd::cxx::tree::flags f,
                       const ::xsd::cxx::tree::properties< char >& p)
  {
    ::xsd::cxx::xml::auto_initializer i (
      (f & ::xsd::cxx::tree::flags::dont_initialize) == 0,
      (f & ::xsd::cxx::tree::flags::keep_dom) == 0);

    ::xsd::cxx::xml::sax::std_input_source isrc (is);
    xercesc::Wrapper4InputSource wrap (&isrc, false);
    return ::strigi::daemonConfiguration (wrap, h, f, p);
  }

  ::std::auto_ptr< ::strigi::daemonConfigurationType >
  daemonConfiguration (::std::istream& is,
                       ::xercesc::DOMErrorHandler& h,
                       ::xsd::cxx::tree::flags f,
                       const ::xsd::cxx::tree::properties< char >& p)
  {
    ::xsd::cxx::xml::sax::std_input_source isrc (is);
    xercesc::Wrapper4InputSource wrap (&isrc, false);
    return ::strigi::daemonConfiguration (wrap, h, f, p);
  }

  ::std::auto_ptr< ::strigi::daemonConfigurationType >
  daemonConfiguration (::std::istream& is,
                       const ::std::basic_string< char >& sid,
                       ::xsd::cxx::tree::flags f,
                       const ::xsd::cxx::tree::properties< char >& p)
  {
    ::xsd::cxx::xml::auto_initializer i (
      (f & ::xsd::cxx::tree::flags::dont_initialize) == 0,
      (f & ::xsd::cxx::tree::flags::keep_dom) == 0);

    ::xsd::cxx::xml::sax::std_input_source isrc (is, sid);
    xercesc::Wrapper4InputSource wrap (&isrc, false);
    return ::strigi::daemonConfiguration (wrap, f, p);
  }

  ::std::auto_ptr< ::strigi::daemonConfigurationType >
  daemonConfiguration (::std::istream& is,
                       const ::std::basic_string< char >& sid,
                       ::xsd::cxx::xml::error_handler< char >& h,
                       ::xsd::cxx::tree::flags f,
                       const ::xsd::cxx::tree::properties< char >& p)
  {
    ::xsd::cxx::xml::auto_initializer i (
      (f & ::xsd::cxx::tree::flags::dont_initialize) == 0,
      (f & ::xsd::cxx::tree::flags::keep_dom) == 0);

    ::xsd::cxx::xml::sax::std_input_source isrc (is, sid);
    xercesc::Wrapper4InputSource wrap (&isrc, false);
    return ::strigi::daemonConfiguration (wrap, h, f, p);
  }

  ::std::auto_ptr< ::strigi::daemonConfigurationType >
  daemonConfiguration (::std::istream& is,
                       const ::std::basic_string< char >& sid,
                       ::xercesc::DOMErrorHandler& h,
                       ::xsd::cxx::tree::flags f,
                       const ::xsd::cxx::tree::properties< char >& p)
  {
    ::xsd::cxx::xml::sax::std_input_source isrc (is, sid);
    xercesc::Wrapper4InputSource wrap (&isrc, false);
    return ::strigi::daemonConfiguration (wrap, h, f, p);
  }

  ::std::auto_ptr< ::strigi::daemonConfigurationType >
  daemonConfiguration (const ::xercesc::DOMInputSource& i,
                       ::xsd::cxx::tree::flags f,
                       const ::xsd::cxx::tree::properties< char >& p)
  {
    ::xsd::cxx::tree::error_handler< char > h;

    ::xsd::cxx::xml::dom::auto_ptr< ::xercesc::DOMDocument > d (
      ::xsd::cxx::xml::dom::parse< char > (i, h, p, f));

    h.throw_if_failed< ::xsd::cxx::tree::parsing< char > > ();

    return ::strigi::daemonConfiguration (
      static_cast< const ::xercesc::DOMDocument& > (*d), f, p);
  }

  ::std::auto_ptr< ::strigi::daemonConfigurationType >
  daemonConfiguration (const ::xercesc::DOMInputSource& i,
                       ::xsd::cxx::xml::error_handler< char >& h,
                       ::xsd::cxx::tree::flags f,
                       const ::xsd::cxx::tree::properties< char >& p)
  {
    ::xsd::cxx::xml::dom::auto_ptr< ::xercesc::DOMDocument > d (
      ::xsd::cxx::xml::dom::parse< char > (i, h, p, f));

    if (!d)
    {
      throw ::xsd::cxx::tree::parsing< char > ();
    }

    return ::strigi::daemonConfiguration (
      static_cast< const ::xercesc::DOMDocument& > (*d), f, p);
  }

  ::std::auto_ptr< ::strigi::daemonConfigurationType >
  daemonConfiguration (const ::xercesc::DOMInputSource& i,
                       ::xercesc::DOMErrorHandler& h,
                       ::xsd::cxx::tree::flags f,
                       const ::xsd::cxx::tree::properties< char >& p)
  {
    ::xsd::cxx::xml::dom::auto_ptr< ::xercesc::DOMDocument > d (
      ::xsd::cxx::xml::dom::parse< char > (i, h, p, f));

    if (!d)
    {
      throw ::xsd::cxx::tree::parsing< char > ();
    }

    return ::strigi::daemonConfiguration (
      static_cast< const ::xercesc::DOMDocument& > (*d), f, p);
  }

  ::std::auto_ptr< ::strigi::daemonConfigurationType >
  daemonConfiguration (const ::xercesc::DOMDocument& d,
                       ::xsd::cxx::tree::flags f,
                       const ::xsd::cxx::tree::properties< char >&)
  {
    ::xsd::cxx::xml::dom::auto_ptr< ::xercesc::DOMDocument > c (
      (f & ::xsd::cxx::tree::flags::keep_dom) 
      ? static_cast< ::xercesc::DOMDocument* > (d.cloneNode (true))
      : 0);

    ::xsd::cxx::xml::dom::element< char > e (
      c.get () ? c->getDocumentElement () : d.getDocumentElement ());

    if (e.name () == "daemonConfiguration" &&
        e.namespace_ () == "http://www.vandenoever.info/strigi")
    {
      ::std::auto_ptr< ::strigi::daemonConfigurationType > r (
        ::xsd::cxx::tree::traits< ::strigi::daemonConfigurationType >::create (e, f, 0));
      if (f & ::xsd::cxx::tree::flags::keep_dom) c.release ();
      return r;
    }

    throw ::xsd::cxx::tree::unexpected_element < char > (
      e.name (),
      e.namespace_ (),
      "daemonConfiguration",
      "http://www.vandenoever.info/strigi");
  }
}

namespace strigi
{
  void
  daemonConfiguration (::xercesc::DOMDocument& d,
                       const ::strigi::daemonConfigurationType& s,
                       ::xsd::cxx::tree::flags)
  {
    ::xsd::cxx::xml::dom::element< char > e (d.getDocumentElement ());

    if (e.name () == "daemonConfiguration" &&
        e.namespace_ () == "http://www.vandenoever.info/strigi")
    {
      e << s;
    }
    else
    {
      throw ::xsd::cxx::tree::unexpected_element < char > (
        e.name (),
        e.namespace_ (),
        "daemonConfiguration",
        "http://www.vandenoever.info/strigi");
    }
  }

  ::xsd::cxx::xml::dom::auto_ptr< ::xercesc::DOMDocument >
  daemonConfiguration (const ::strigi::daemonConfigurationType& s,
                       const ::xsd::cxx::xml::dom::namespace_infomap< char >& m,
                       ::xsd::cxx::tree::flags f)
  {
    try
    {
      ::xsd::cxx::xml::dom::auto_ptr< ::xercesc::DOMDocument > d (
        ::xsd::cxx::xml::dom::serialize< char > (
          "daemonConfiguration",
          "http://www.vandenoever.info/strigi",
          m,
          f));
      ::strigi::daemonConfiguration (*d, s, f);
      return d;
    }
    catch (const ::xsd::cxx::xml::dom::mapping< char >& e)
    {
      throw ::xsd::cxx::tree::no_namespace_mapping< char > (e.name ());
    }
    catch (const ::xsd::cxx::xml::dom::xsi_already_in_use&)
    {
      throw ::xsd::cxx::tree::xsi_already_in_use< char > ();
    }
  }

  void
  daemonConfiguration (::xercesc::XMLFormatTarget& t,
                       const ::strigi::daemonConfigurationType& s,
                       const ::xsd::cxx::xml::dom::namespace_infomap< char >& m,
                       const ::std::basic_string< char >& e,
                       ::xsd::cxx::tree::flags f)
  {
    ::xsd::cxx::xml::dom::auto_ptr< ::xercesc::DOMDocument > d (
      ::strigi::daemonConfiguration (s, m, f));

    ::xsd::cxx::tree::error_handler< char > h;

    if (!::xsd::cxx::xml::dom::serialize (t, *d, e, h, f))
    {
      h.throw_if_failed< ::xsd::cxx::tree::serialization< char > > ();
    }
  }

  void
  daemonConfiguration (::xercesc::XMLFormatTarget& t,
                       const ::strigi::daemonConfigurationType& s,
                       const ::xsd::cxx::xml::dom::namespace_infomap< char >& m,
                       ::xsd::cxx::xml::error_handler< char >& h,
                       const ::std::basic_string< char >& e,
                       ::xsd::cxx::tree::flags f)
  {
    ::xsd::cxx::xml::dom::auto_ptr< ::xercesc::DOMDocument > d (
      ::strigi::daemonConfiguration (s, m, f));
    if (!::xsd::cxx::xml::dom::serialize (t, *d, e, h, f))
    {
      throw ::xsd::cxx::tree::serialization< char > ();
    }
  }

  void
  daemonConfiguration (::xercesc::XMLFormatTarget& t,
                       const ::strigi::daemonConfigurationType& s,
                       const ::xsd::cxx::xml::dom::namespace_infomap< char >& m,
                       ::xercesc::DOMErrorHandler& h,
                       const ::std::basic_string< char >& e,
                       ::xsd::cxx::tree::flags f)
  {
    ::xsd::cxx::xml::dom::auto_ptr< ::xercesc::DOMDocument > d (
      ::strigi::daemonConfiguration (s, m, f));
    if (!::xsd::cxx::xml::dom::serialize (t, *d, e, h, f))
    {
      throw ::xsd::cxx::tree::serialization< char > ();
    }
  }

  void
  daemonConfiguration (::std::ostream& o,
                       const ::strigi::daemonConfigurationType& s,
                       const ::xsd::cxx::xml::dom::namespace_infomap< char >& m,
                       const ::std::basic_string< char >& e,
                       ::xsd::cxx::tree::flags f)
  {
    ::xsd::cxx::xml::auto_initializer i (
      (f & ::xsd::cxx::tree::flags::dont_initialize) == 0);

    ::xsd::cxx::xml::dom::auto_ptr< ::xercesc::DOMDocument > d (
      ::strigi::daemonConfiguration (s, m, f));

    ::xsd::cxx::tree::error_handler< char > h;

    ::xsd::cxx::xml::dom::ostream_format_target t (o);
    if (!::xsd::cxx::xml::dom::serialize (t, *d, e, h, f))
    {
      h.throw_if_failed< ::xsd::cxx::tree::serialization< char > > ();
    }
  }

  void
  daemonConfiguration (::std::ostream& o,
                       const ::strigi::daemonConfigurationType& s,
                       const ::xsd::cxx::xml::dom::namespace_infomap< char >& m,
                       ::xsd::cxx::xml::error_handler< char >& h,
                       const ::std::basic_string< char >& e,
                       ::xsd::cxx::tree::flags f)
  {
    ::xsd::cxx::xml::auto_initializer i (
      (f & ::xsd::cxx::tree::flags::dont_initialize) == 0);

    ::xsd::cxx::xml::dom::auto_ptr< ::xercesc::DOMDocument > d (
      ::strigi::daemonConfiguration (s, m, f));
    ::xsd::cxx::xml::dom::ostream_format_target t (o);
    if (!::xsd::cxx::xml::dom::serialize (t, *d, e, h, f))
    {
      throw ::xsd::cxx::tree::serialization< char > ();
    }
  }

  void
  daemonConfiguration (::std::ostream& o,
                       const ::strigi::daemonConfigurationType& s,
                       const ::xsd::cxx::xml::dom::namespace_infomap< char >& m,
                       ::xercesc::DOMErrorHandler& h,
                       const ::std::basic_string< char >& e,
                       ::xsd::cxx::tree::flags f)
  {
    ::xsd::cxx::xml::dom::auto_ptr< ::xercesc::DOMDocument > d (
      ::strigi::daemonConfiguration (s, m, f));
    ::xsd::cxx::xml::dom::ostream_format_target t (o);
    if (!::xsd::cxx::xml::dom::serialize (t, *d, e, h, f))
    {
      throw ::xsd::cxx::tree::serialization< char > ();
    }
  }

  void
  operator<< (::xsd::cxx::xml::dom::element< char >& n,
              const daemonConfigurationType& i)
  {
    {
      for (daemonConfigurationType::repository::const_iterator
           b (i.repository ().begin ()), e (i.repository ().end ());
           b != e; ++b)
      {
        ::xsd::cxx::xml::dom::element< char > s (
          "repository",
          n);
        s << *b;
      }
    }
  }

  void
  operator<< (::xsd::cxx::xml::dom::element< char >& n,
              const repositoryType& i)
  {
    {
      for (repositoryType::fileSystemSource::const_iterator
           b (i.fileSystemSource ().begin ()), e (i.fileSystemSource ().end ());
           b != e; ++b)
      {
        ::xsd::cxx::xml::dom::element< char > s (
          "fileSystemSource",
          n);
        s << *b;
      }
    }

    {
      for (repositoryType::httpSource::const_iterator
           b (i.httpSource ().begin ()), e (i.httpSource ().end ());
           b != e; ++b)
      {
        ::xsd::cxx::xml::dom::element< char > s (
          "httpSource",
          n);
        s << *b;
      }
    }

    {
      ::xsd::cxx::xml::dom::attribute< char > a (
        "repositoryLocation",
        n);

      a << i.repositoryLocation ();
    }

    {
      ::xsd::cxx::xml::dom::attribute< char > a (
        "repositoryType",
        n);

      a << i.repositoryType1 ();
    }
  }

  void
  operator<< (::xsd::cxx::xml::dom::element< char >& n,
              repositoryTypeType i)
  {
    n << static_cast< const ::xml_schema::string& > (i);
  }

  void
  operator<< (::xsd::cxx::xml::dom::attribute< char >& n,
              repositoryTypeType i)
  {
    n << static_cast< const ::xml_schema::string& > (i);
  }

  void
  operator<< (::xsd::cxx::xml::dom::list_stream< char >& l,
              repositoryTypeType i)
  {
    l << static_cast< const ::xml_schema::string& > (i);
  }

  void
  operator<< (::xsd::cxx::xml::dom::element< char >& n,
              const fileSourceType& i)
  {
    {
      ::xsd::cxx::xml::dom::attribute< char > a (
        "baseURI",
        n);

      a << i.baseURI ();
    }

    if (i.autoUpdateFrequence ())
    {
      ::xsd::cxx::xml::dom::attribute< char > a (
        "autoUpdateFrequence",
        n);

      a << *i.autoUpdateFrequence ();
    }
  }

  void
  operator<< (::xsd::cxx::xml::dom::element< char >&,
              const fileSystemSourceType::fileEventListener::type&)
  {
  }

  void
  operator<< (::xsd::cxx::xml::dom::attribute< char >&,
              const fileSystemSourceType::fileEventListener::type&)
  {
  }

  void
  operator<< (::xsd::cxx::xml::dom::list_stream< char >&,
              const fileSystemSourceType::fileEventListener::type&)
  {
  }

  void
  operator<< (::xsd::cxx::xml::dom::element< char >& n,
              const fileSystemSourceType& i)
  {
    n << static_cast< const ::strigi::fileSourceType& > (i);
    {
      if (i.fileEventListener ())
      {
        ::xsd::cxx::xml::dom::element< char > e (
          "fileEventListener",
          n);
        e << *i.fileEventListener ();
      }
    }
  }

  void
  operator<< (::xsd::cxx::xml::dom::element< char >& n,
              const httpSourceType& i)
  {
    n << static_cast< const ::strigi::fileSourceType& > (i);
  }
}

#include <xsd/cxx/post.hxx>

// Begin epilogue.
//
//
// End epilogue.

