import Parser.XML.Tree;


/**
 * <p>class Result - Standard Return Type for an action, which covers the result of an action. It offers the ability to
 * render the Result either as XML or as a mapping. Further it contains a set of messages, which presents errors, 
 * warning and status of an action (if needed). 
 * Only one OWLItem or OWLContainer can be linked to one result, new set statements will override the previous ones.
 *</p>
 */
 


/**
 * <p>Rendering type for this resul</p>
 */
    public constant XML = 1;


/**
 * <p>Rendering type</p>
 */
    public constant RENDER_SINGLE = 0;
    
/**
 * <p>Rendering type</p>
 */
    public constant RENDER_DEEP = 1;

/**
 * <p>Rendering type</p>
 */
    public constant RENDER_UP = 2;

    

/**
 * <p>conatains one of RENDER_SINGLE(default),  RENDER_DEEP or RENDER_UP</p>
 */
    private int render_flag = 0;
    
/**
 * <p>counter for the message container</p>
 */
    private int messagecounter = 0;

/**
 * <p>internal flag for the result type,ITEM or CLUSTER or CONTAINER </p>
 */    
    private int result_type  = 0;    
/**
 * <p>Result has a single item</p>
 */    
    private constant ITEM  = 1;
    
/**
 * <p>Result is a cluster (more than on OWLContainer)</p>
 */    
    private constant CLUSTER  = 2;

/**
 * <p>Result is an OWLContainer</p>
 */    
    private constant CONTAINER  = 3;    
/**
 * <p>Container for the messages</p>
 */
    private array messages = ({ })   ;

/**
 * <p>Container for a set of owlitems</p>
 */
    private Visconte.Onto.OWLContainer owl_container ;
    
/**
 * <p>The single OWLItem</p>
 */
    private Visconte.Onto.Item.OWLItem owl_item ;

/**
 * <p>array storing more than one OWLContainer</p>
 */
    private array(array) cluster = ({  }); ;
    
    
/**
 * <p>Constructor</p>
 * 
 */
    public void create() {        
        // your code here
    } 

/**
 * <p>Returns an XML Representation of the Result</p>
 * Checks the result type and and returns a rendered XML-String
 * 
 * @param void|list_flags - mapping with attribute-value that can be added to the &lt;list&gt; tag
 * @return string - the rendered XML
 */
    public string get_XML_Result(void|mapping list_flags) 
    {     
	    
	    XMLConversion xc;
	    string xml_result;
	    if(list_flags)
		    xc= XMLConversion(list_flags);
	    else
		    xc= XMLConversion();   
	    switch(result_type)
	    {
		case ITEM:
			 xml_result = xc->convert_Item(owl_item, render_flag);
			 break;
		 
		case CLUSTER:
			 xml_result = xc->convert_Cluster(cluster);
			 break;
		
		case CONTAINER:
			 xml_result = xc->convert_Container(owl_container);
			 break;
		default:
		xml_result="<list></list>";
		break;
	    }
       
      return xml_result;
       
    } 

/**
 * <p>Returns a mapping with given tag and attribute name and the id as keys</p>
 * 
 * 
 * @param attribute - the attribute to look for
 * @param tag - the tag to look for (e.g. individual etc.) 
 * @return mapping with ids -> attributes
 */
    public mapping get_id_mapping(string attribute, string tag) 
    {    
	    mapping(string:string) id_mapping=([]);
	    Node root = Parser.XML.Tree.parse_input(get_XML_Result());
	    array childs = root->get_descendants(0);
	    foreach(childs,Node n)
	    {
		    mapping attr = n->get_attributes();
		   
		    if(n->get_tag_name()==tag && has_index(attr, "id") && has_index(attr, attribute))
		    {
			    id_mapping+=([ attr["id"] : attr[attribute] ]); 
		    }
	    }
	    return id_mapping;
    }
    
/**
 * <p>Returns an Array with mappings that have all tags and attribute as name:value set</p>
 * 
 * @return array - containing the result mappings
 */
    public array get_result_mapping() 
    {    
	    array items=({});
	    Node root = Parser.XML.Tree.parse_input(get_XML_Result());
	    array childs = root->get_descendants(0);
	    foreach(childs,Node n)
	    {
		    mapping attr = n->get_attributes();
		    attr+=([ "tag_name" : n->get_tag_name() ]);
		    items+=({attr});
	    }
	    return items;
    }
    
    
    
/**
 * <p>Check if this Result has an error</p>
 * 
 * 
 * @param error_num - checks for special Error number, see File MessageCodes
 * @return true or false
 */
    public int has_error(int|void error_num) 
    { 
	   
	    foreach(messages, Visconte.Request.Message m)
	    {
		    if(m->is_error())
		    {
			    if(error_num && m->errorcode==error_num)
			    {	 
				return 1;
				break;
			    }
			    
			    if(!error_num)
			    {
				    return 1;
				    break;
			    }
		    }
	    }
	    return 0;
    }
	    
/**
 * <p>Returns the messages either as XML or as array</p>
 * 
 * 
 * @param content_type - if set to 1 XML will be rendered else the array will be
 * returned 
 * @return mixed (array or string) 
 */
    public mixed get_Messages(int content_type) 
    {        
	    
       if(content_type==XML)
       {
	       Node root_node = Node(Parser.XML.Tree.XML_ROOT,"root", ([ ]), "");
	       mapping(string:string) attr = ([ ]);;

	       string out="";
	       foreach(messages,Visconte.Request.Message msg)
	       {
		       attr+=([ "type" : (string)msg->type , "about" : msg->about , "messagecode" : (string)msg->errorcode ]);
		      
		       Node msg_node = Node(Parser.XML.Tree.XML_ELEMENT,"message", attr,"");
		       Node backtrace_node = Node(Parser.XML.Tree.XML_ELEMENT,"backtrace", ([ ]),"");
		       Node msg_text = Node(Parser.XML.Tree.XML_TEXT,"", ([ ]),msg->msg);
		       Node backtrace_text = Node(Parser.XML.Tree.XML_TEXT,"", ([ ]),msg->backtrace);
		       msg_node->add_child(msg_text);
		       msg_node->add_child(backtrace_node);
		       backtrace_node->add_child(backtrace_text);

		       root_node->add_child(msg_node);
		       
	       }
	       return root_node->render_xml();
       }
       else
       {
	       return messages;
       }
    } 
  
/**
 * <p>Dumps the messages to the console</p>
 */
    public void dump_messages()
    {
	   foreach(messages, Visconte.Request.Message m)
	    {
		 write(m->to_string());
	    }
    }
/**
 * <p>Add a message to the Result</p>
 * 
 * 
 * @param msg - a Message-object 
 */
    public void add_Message(Visconte.Request.Message msg) 
    {       
	    if(msg && objectp(msg))
	    {
		    messages+=({msg});
		    messagecounter++;
	    }
    }
    
/**
 * <p>Add a OWLContainer to the cluster</p>
 * 
 * 
 * @param meta - mapping with attribute-value shape, will be added to the XML-
 * Representation 
 */
    public void add_cluster(mapping meta, Visconte.Onto.OWLContainer container) 
    {       
	    if(container)
	    {
		    cluster+=({ ({meta, container}) });
		    result_type=CLUSTER;    
	    }
    }
	    
/**
 * <p>Set an Visconte.Onto.OWLContainer to the Result. This overwrites any 
 * existing Visconte.Onto.OWLContainer or/and Visconte.Onto.Item.OWLItem</p>
 * 
 * @param container - the Visconte.Onto.OWLContainer 
 */
    public void set_OWLContainer(Visconte.Onto.OWLContainer container) 
    {        
	    if(container)
	    {
		    //if a Visconte.Onto.OWLContainer is added, null an existing Visconte.Onto.Item.OWLItem
		    this_program::owl_container=container;
		    result_type=CONTAINER;  
	    }
	    
		    
    } 
    
/**
 * <p>Set an Visconte.Onto.Item.OWLItem to the Result. This overwrites any 
 * existing Visconte.Onto.OWLContainer or/and Visconte.Onto.Item.OWLItem</p>
 * 
 * 
 * @param item - The OWLitem 
 */
    public void set_OWLItem(Visconte.Onto.Item.OWLItem item, int|void render_flag) 
    {        
	    if(item)
	    {
		    //if a OWLItem is added, null an existing Visconte.Onto.OWLContainer
		    this_program::owl_item=item;
		    result_type=ITEM;  
		    if(render_flag)
			    this_program::render_flag=render_flag;
		    else
			    this_program::render_flag=RENDER_SINGLE;
		   
	    }
	    
		    
    } 
    
    
    
    
/**
 *    class XMLConversion - class to translate OWLItems to the visconte exchange format
 *
 */


    
class XMLConversion
{
	import Visconte;
	import Visconte.Onto.Item;
	import Parser.XML.Tree;
	

/**
 * <p>the Model Tag</p>
 */
	public constant MODEL_NODE = "model";
/**
 * <p>The List Tag</p>
 */
	public constant LIST = "list";
/**
 * <p>The DatatypeProperty tag</p>
 */
 	public constant DATA_TYPE_NODE = "property";
/**
 * <p>The ObjectProperty Tag </p>
 */
	public constant OBJECT_PROPERTY_NODE = "association";
/**
 * <p>The individual tag</p>
 */
	public constant INDIVIDUAL_NODE = "individual";
/**
 * <p>The cluser tag</p>
 */
	public constant CLUSTER_NODE = "cluster";
/**
 * <p>Tag for any attribute (property or associaion) of an individual</p>
 */
	public constant INDIVIDUAL_PROPERTY = "attribute";

/**
 * <p>Attributes for the list tag</p>
 */
	public mapping(string:string) list_flag =([]);	

/**
 * <p>Set an Visconte.Onto.OWLContainer to the Result. This overwrites any 
 * existing Visconte.Onto.OWLContainer or/and OWLItem</p>
 * 
 * @param container - the Visconte.Onto.OWLContainer 
 */	
	public string create(void|mapping list_flag)
	{	
		if(list_flag)
		this_program::list_flag=list_flag;
	}
/**
 * <p>Renders a cluster as XML</p>
 * 
 * @param clusters - the array containing the OWLContainer 
 */	
	public string convert_Cluster(array clusters)
	{
		Node xml_cluster_root = Node(XML_ROOT,"root",([]),"");
		foreach(clusters, array cluster)
		{
			Node cluster_node = Node(XML_ELEMENT,CLUSTER_NODE,cluster[0],"");
			xml_cluster_root->add_child(cluster_node);
			Visconte.Onto.OWLContainer container  = cluster[1];
			while(container->has_items())
				cluster_node->add_child(create_Item_Node(container->next(), 0) );
		}
		return xml_cluster_root->render_xml();
	}
	
	
/**
 * <p>Render a OWLContainer as XML</p>
 * 
 * @param container - the Visconte.Onto.OWLContainer 
 */	
	public string convert_Container(Visconte.Onto.OWLContainer container)
	{
		container->reset_iterator();
		list_flag->size = (string)container->size_of();
		Node xml_container = Node(XML_ELEMENT,LIST,list_flag,"");
		while(container->has_items())
		{
			Visconte.Onto.Item.OWLItem x =container->next();
			xml_container->add_child(create_Item_Node(x,0));
		}
		return xml_container->render_xml();
	}

/**
 * <p>Render a OWLItem as XML</p>
 * 
 * @param item - the OWLItem
 * @param render_flag - the flags: RENDER_SINGLE(default),  RENDER_DEEP or RENDER_UP
 */	
	public string convert_Item(Visconte.Onto.Item.OWLItem item, int render_flag)
	{
		return  create_Item_Node(item,render_flag)->render_xml();
	}


/**
 * <p>Creates a Node for an OWLItem/p>
 * @param item - the OWLItem
 * @param render_flag - the flags: RENDER_SINGLE(default),  RENDER_DEEP or RENDER_UP
 */	
	private  Node create_Item_Node(Visconte.Onto.Item.OWLItem item, int render_flag)
	{
		 switch(item->ITEMTYPE)
		 {
			case Visconte.Onto.Item.OWLItem.CLASS:
			 
			return create_Class_Node(item, render_flag);
			break;
			
			case Visconte.Onto.Item.OWLItem.OBJECT_PROPERTY:
			return create_Object_Property_Node(item);
			break;
			
			case Visconte.Onto.Item.OWLItem.DATATYPE_PROPERTY:
			return create_Datatype_Property_Node(item);
			break;
			
			case Visconte.Onto.Item.OWLItem.INDIVIDUAL:
			return create_Individual_Node(item);
			break;
			
			default:
			 return Node(XML_ELEMENT,MODEL_NODE,([]),"");
			break;
		 }
	}
	
	
/**
 * <p>this method creates an Class Node in visconte format</p>
 * 
 * @param item - the OWLClass
 * @param render_flag - the flags: RENDER_SINGLE(default),  RENDER_DEEP or RENDER_UP
 */	
	private  Node create_Class_Node(Visconte.Onto.Item.OWLItem item, int render_flag)
	{	
		mapping(string:string) attr = ([ ]);;
		Node model_node;
		attr+=(["id": ID(item->get_Id(),1)->uref]);
		attr+=(["label" : item->get_Label()]);
		attr+=(["weight" : (string) item->get_weight(5)]);
		attr+=(["drops" : (string) item->get_weight()]);
		attr+=(["lastModified" : (string) item->get_date_of_change() ]);
		
		model_node = Node(XML_ELEMENT,MODEL_NODE,attr,"");
		
		Visconte.Onto.OWLContainer container = item->get_domain_properties();
		
		while(container->has_items())
		{
			model_node->add_child(create_Item_Node(container->next(),render_flag));
		}
		if(render_flag==Visconte.Request.Result.RENDER_DEEP)
		{
			container = item->get_childs();
			while(container->has_items())
			{
				model_node->add_child(create_Item_Node(container->next(),render_flag));
			}
		}
		if(render_flag==Visconte.Request.Result.RENDER_UP)
		{
			
			if(item->has_parent())
			{
				item = item->get_parent();
				{
					Node parent = create_Item_Node(item,render_flag);
					parent->add_child(model_node);
					return parent;
				}
			}
		}
				
		return  model_node;
		
		
	}
/**
 * <p>this method creates an ObjectProperty Node  in visconte format</p>
 * 
 * @param item - the OWLObjectProperty 
 */	
	private  Node create_Object_Property_Node(Visconte.Onto.Item.OWLItem item)
	{	
		mapping(string:string) attr = ([ ]);
		attr+=(["id" : ID(item->get_Id(),1)->uref]);
		attr+=(["label" : item->get_Label()]);
		attr+=(["with" : ID(item->get_range()->get_Id())->uref]);
		attr+=(["domain" : ID(item->get_domain()->get_Id())->uref]);
		attr+=(["lastModified" : (string)  item->get_date_of_change()]);
		return  Node(XML_ELEMENT,OBJECT_PROPERTY_NODE,attr,"");
	}
/**
 * <p>this method creates an DatatypeProperty Node  in visconte format</p>
 * 
 * @param item - the OWLDatatypeProperty 
 */	
	private  Node create_Datatype_Property_Node(Visconte.Onto.Item.OWLItem item)
	{	
		mapping(string:string) attr = ([ ]);
		attr+=(["id" : ID(item->get_Id(),1)->uref]);
		attr+=(["label" : item->get_Label()]);
		attr+=(["type" : item->get_range()]);
		attr+=(["lastModified" : (string)  item->get_date_of_change()]);
		return  Node(XML_ELEMENT,DATA_TYPE_NODE,attr,"");
	}	
	

/**
 * <p>this method creates an DatatypeProperty Node  in visconte format</p>
 * 
 * @param item - the OWLDatatypeProperty 
 */	
	private  Node create_Individual_Node(Visconte.Onto.Item.OWLItem item)
	{	
		Node individual;
		mapping(string:string) attr = ([ ]);
		
		attr+=(["id" : ID(item->get_Id(),1)->uref]);
		attr+=(["label" : item->get_Label()]);
		attr+=(["domain" : ID(item->get_model_class()->get_Id())->uref]);
		attr+=(["lastModified" : (string)  item->get_date_of_change()]);
		
		individual = Node(XML_ELEMENT,INDIVIDUAL_NODE,attr,"");
		array property_map = item->get_property_map();
		foreach(property_map, array property_definition)
		{
			OWLProperty property = property_definition[0];
			string value = property_definition[1];
			mapping(string:string) attr = ([ ]);
			attr+=(["propertyId" : ID(property->get_Id(),1)->uref ]);
			
			attr+=(["label" : property->get_Label() ]);
			
			if(property->ITEMTYPE==Visconte.Onto.Item.OWLItem.OBJECT_PROPERTY)
			{
				attr+=(["range" : ID(property->get_range()->get_Id(),1)->uref ]);
				attr+=(["type" : "object"]);
				attr+=(["value" : ID(value)->uref ]);

			}
			else
			{
				
				attr+=(["range" : property->get_range() ]);
				attr+=(["type" : "data"]);
				attr+=(["value" : (string) value]);
			}
			
			individual->add_child(Node(XML_ELEMENT,INDIVIDUAL_PROPERTY,attr,""));
		}
		return  individual;
	}	
}
