/***************************************************************************
 *   Copyright (C) 2007 by Patrick Matthäi                                 *
 *   me@linux-development.eu                                               *
 *   http://www.Linux-Dev.org/                                             *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include "sshm.h"

int Parameter::help(char *exec){
	cout << "Usage of " << exec << ":\n" << endl;
	cout << "\t--help\t\tDisplays the help." << endl;
	cout << "\t--version\tDisplays the program version." << endl;
	cout << "\t--list\t\tLists all servers." << endl;
	cout << "\t--add\t\tAdds a server." << endl;
	cout << "\t--del [name]\tDeletes a server." << endl;
	cout << "\t--show [name]\tShows information about a given server." << endl;
	cout << "\nTo connect to a server, you only have to give the serveralias as an argument." << endl;
	cout << "\nNote: You can use all parameters in the format like \'-h\'." << endl;
	return EXIT_SUCCESS;
}

int Parameter::wrong(char *exec){
	cerr << "You have entered too many arguments.\nPlease have a look at the help." << endl;
	return EXIT_SUCCESS;
}

int Parameter::version(char *exec){
	cout << exec << " version: " << SSHMVERSION << endl;
	return EXIT_SUCCESS;
}

int Parameter::add(){
	string configfile = Check::getpath();
	char servername[90], ip[90], user[25], port[15];

	cout << "Enter your connection data for the server:" << endl;

	while(true){
		cout << "\nHostname: ";
		cin >> ip;
		if(Check::domain(ip) == 0){
			cerr << "\nError. Only 85 chars are allowed for the hostname. Please reenter it." << endl;
		} else {
			break;
		}
	}

	while(true){
		cout << "\nPort: ";
		cin >> port;
		if(Check::port(port) == 0){
			cerr << "\nError. The port " << port << " isn't valid. Please reenter it." << endl;
		} else {
			break;
		}
	}

	while(true){
		cout << "\nUsername: ";
		cin >> user;
		if(Check::username(user) == 0){
			cerr << "\nError. Only 20 chars are allowed for the username. Please reenter it." << endl;
		} else {
			break;
		}
	}

	while(true){
		cout << "\nServeralias: ";
		cin >> servername;
		if(Search::line(servername) != 0){
			cerr << "\nError. This serveralias is already used, please choose another one." << endl;
		}
		else if(Check::valid(servername) == 0){
			cerr << "\nError. The serveralias contains unallowed characters such as \'#\'." << endl;
		} else {
			break;
		}
	}

	FILE *stream_add;
	stream_add = fopen(configfile.c_str(),"a");
	fprintf(stream_add, "%s %s %s %s\n", servername, user, ip, port);
	fclose(stream_add);

	if(Search::line(servername) != 0){
		cout << "\nAdded server." << endl;
	} else {
		cerr << "You have to define a serveralias to delete." << endl;
	}

	return EXIT_SUCCESS;
}

int Parameter::del(char *todel){
	if(!todel){
		cerr << "You habe to define a serveralias to delete." << endl;
		return EXIT_SUCCESS; 
	}
	else if(Search::line(todel) == 0){
		cerr << "Can't find this server at the configfile. Please have a look at the --list option." << endl;
		return EXIT_SUCCESS;
	}
	else if(Action::del(todel) == 1){
		cout << "Deleted the server." << endl;
	} else {
		cerr << "An error occurred while deleting the entry." << endl;
	}
	return EXIT_SUCCESS;
}

int Parameter::show(char *arg){
	if(!arg){
		cerr << "You have to define a serveralias." << endl;
		return EXIT_SUCCESS;
	}
	string server = Search::get(arg);
	cout << "Serveralias / User / Hostname / Port:\n" << server << endl;
	return EXIT_SUCCESS;
}

int Parameter::list(char *search){
	unsigned int counter=0;
	char serverlist[BUFFER];

	string configfile = Check::getpath();
	FILE *stream_list;
	stream_list = fopen(configfile.c_str(),"r");

	while(fgets(serverlist, BUFFER, stream_list) != NULL){
		char servername[85], ip[85], user[20], port[10];
		port[0] = '\0';
		if(sscanf(serverlist, "%s %s %s %s", servername, user, ip, port) != 4){
			continue;
		}
		else if(servername[0] == '\0' || port[0] == '\0' || servername[0] == '#' || servername[0] == '\n'){
			continue;
		}
		else if(search && strstr(serverlist,search) == 0){
			continue;
		} else {
			counter++;
			if(counter == 1){
				cout << "List of all added servers:" << endl;
				cout << "\t#\tServeralias\tUser @ Hostname : Port\n" << endl;
			}
			string tabs = "\t";
			if(strlen(servername) < 8){
				tabs += "\t";
			}
			cout << "\t" << counter << ".\t" << servername << tabs << user << "@" << ip << ":" << port << endl;
		}
	}

	if(counter == 0){
		cout << "No server found." << endl;
	}

	fclose(stream_list);
	return EXIT_SUCCESS;
}

Parameter::~Parameter(){
}
