/* sqlheavy-error.c generated by valac 0.12.1, the Vala compiler
 * generated from sqlheavy-error.vala, do not modify */


#include <glib.h>
#include <glib-object.h>
#include "SQLHeavy.h"
#include <sqlite3.h>
#include <stdlib.h>
#include <string.h>

#define _g_free0(var) (var = (g_free (var), NULL))

/**
   * SQLHeavy Errors
   *
   * Most of these are from SQLite--see [[http://sqlite.org/c3ref/c_abort.html]] for documentation.
   */


gboolean sql_heavy_error_if_not_ok (gint ec, SQLHeavyQueryable* queryable, GError** error);
const gchar* sql_heavy_sqlite_errstr (gint ec);
gint sql_heavy_sqlite_code_from_error (GError* e);


gboolean sql_heavy_error_if_not_ok (gint ec, SQLHeavyQueryable* queryable, GError** error) {
	gboolean result = FALSE;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	gchar* msg;
	GError * _inner_error_ = NULL;
	if (ec == SQLITE_OK) {
		result = TRUE;
		return result;
	}
	_tmp0_ = sql_heavy_sqlite_errstr (ec);
	_tmp1_ = g_strdup (_tmp0_);
	msg = _tmp1_;
	switch (ec) {
		case SQLITE_ERROR:
		{
			GError* _tmp2_ = NULL;
			_tmp2_ = g_error_new_literal (SQL_HEAVY_ERROR, SQL_HEAVY_ERROR_ERROR, msg);
			_inner_error_ = _tmp2_;
			if (_inner_error_->domain == SQL_HEAVY_ERROR) {
				g_propagate_error (error, _inner_error_);
				_g_free0 (msg);
				return FALSE;
			} else {
				_g_free0 (msg);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return FALSE;
			}
		}
		case SQLITE_INTERNAL:
		{
			GError* _tmp3_ = NULL;
			_tmp3_ = g_error_new_literal (SQL_HEAVY_ERROR, SQL_HEAVY_ERROR_INTERNAL, msg);
			_inner_error_ = _tmp3_;
			if (_inner_error_->domain == SQL_HEAVY_ERROR) {
				g_propagate_error (error, _inner_error_);
				_g_free0 (msg);
				return FALSE;
			} else {
				_g_free0 (msg);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return FALSE;
			}
		}
		case SQLITE_PERM:
		{
			GError* _tmp4_ = NULL;
			_tmp4_ = g_error_new_literal (SQL_HEAVY_ERROR, SQL_HEAVY_ERROR_ACCESS_DENIED, msg);
			_inner_error_ = _tmp4_;
			if (_inner_error_->domain == SQL_HEAVY_ERROR) {
				g_propagate_error (error, _inner_error_);
				_g_free0 (msg);
				return FALSE;
			} else {
				_g_free0 (msg);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return FALSE;
			}
		}
		case SQLITE_ABORT:
		{
			GError* _tmp5_ = NULL;
			_tmp5_ = g_error_new_literal (SQL_HEAVY_ERROR, SQL_HEAVY_ERROR_ABORTED, msg);
			_inner_error_ = _tmp5_;
			if (_inner_error_->domain == SQL_HEAVY_ERROR) {
				g_propagate_error (error, _inner_error_);
				_g_free0 (msg);
				return FALSE;
			} else {
				_g_free0 (msg);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return FALSE;
			}
		}
		case SQLITE_BUSY:
		{
			GError* _tmp6_ = NULL;
			_tmp6_ = g_error_new_literal (SQL_HEAVY_ERROR, SQL_HEAVY_ERROR_BUSY, msg);
			_inner_error_ = _tmp6_;
			if (_inner_error_->domain == SQL_HEAVY_ERROR) {
				g_propagate_error (error, _inner_error_);
				_g_free0 (msg);
				return FALSE;
			} else {
				_g_free0 (msg);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return FALSE;
			}
		}
		case SQLITE_LOCKED:
		{
			GError* _tmp7_ = NULL;
			_tmp7_ = g_error_new_literal (SQL_HEAVY_ERROR, SQL_HEAVY_ERROR_LOCKED, msg);
			_inner_error_ = _tmp7_;
			if (_inner_error_->domain == SQL_HEAVY_ERROR) {
				g_propagate_error (error, _inner_error_);
				_g_free0 (msg);
				return FALSE;
			} else {
				_g_free0 (msg);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return FALSE;
			}
		}
		case SQLITE_NOMEM:
		{
			GError* _tmp8_ = NULL;
			_tmp8_ = g_error_new_literal (SQL_HEAVY_ERROR, SQL_HEAVY_ERROR_NO_MEMORY, msg);
			_inner_error_ = _tmp8_;
			if (_inner_error_->domain == SQL_HEAVY_ERROR) {
				g_propagate_error (error, _inner_error_);
				_g_free0 (msg);
				return FALSE;
			} else {
				_g_free0 (msg);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return FALSE;
			}
		}
		case SQLITE_READONLY:
		{
			GError* _tmp9_ = NULL;
			_tmp9_ = g_error_new_literal (SQL_HEAVY_ERROR, SQL_HEAVY_ERROR_READ_ONLY, msg);
			_inner_error_ = _tmp9_;
			if (_inner_error_->domain == SQL_HEAVY_ERROR) {
				g_propagate_error (error, _inner_error_);
				_g_free0 (msg);
				return FALSE;
			} else {
				_g_free0 (msg);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return FALSE;
			}
		}
		case SQLITE_INTERRUPT:
		{
			GError* _tmp10_ = NULL;
			_tmp10_ = g_error_new_literal (SQL_HEAVY_ERROR, SQL_HEAVY_ERROR_INTERRUPTED, msg);
			_inner_error_ = _tmp10_;
			if (_inner_error_->domain == SQL_HEAVY_ERROR) {
				g_propagate_error (error, _inner_error_);
				_g_free0 (msg);
				return FALSE;
			} else {
				_g_free0 (msg);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return FALSE;
			}
		}
		case SQLITE_IOERR:
		{
			GError* _tmp11_ = NULL;
			_tmp11_ = g_error_new_literal (SQL_HEAVY_ERROR, SQL_HEAVY_ERROR_IO, msg);
			_inner_error_ = _tmp11_;
			if (_inner_error_->domain == SQL_HEAVY_ERROR) {
				g_propagate_error (error, _inner_error_);
				_g_free0 (msg);
				return FALSE;
			} else {
				_g_free0 (msg);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return FALSE;
			}
		}
		case SQLITE_CORRUPT:
		{
			GError* _tmp12_ = NULL;
			_tmp12_ = g_error_new_literal (SQL_HEAVY_ERROR, SQL_HEAVY_ERROR_CORRUPT, msg);
			_inner_error_ = _tmp12_;
			if (_inner_error_->domain == SQL_HEAVY_ERROR) {
				g_propagate_error (error, _inner_error_);
				_g_free0 (msg);
				return FALSE;
			} else {
				_g_free0 (msg);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return FALSE;
			}
		}
		case SQLITE_FULL:
		{
			GError* _tmp13_ = NULL;
			_tmp13_ = g_error_new_literal (SQL_HEAVY_ERROR, SQL_HEAVY_ERROR_FULL, msg);
			_inner_error_ = _tmp13_;
			if (_inner_error_->domain == SQL_HEAVY_ERROR) {
				g_propagate_error (error, _inner_error_);
				_g_free0 (msg);
				return FALSE;
			} else {
				_g_free0 (msg);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return FALSE;
			}
		}
		case SQLITE_CANTOPEN:
		{
			GError* _tmp14_ = NULL;
			_tmp14_ = g_error_new_literal (SQL_HEAVY_ERROR, SQL_HEAVY_ERROR_CAN_NOT_OPEN, msg);
			_inner_error_ = _tmp14_;
			if (_inner_error_->domain == SQL_HEAVY_ERROR) {
				g_propagate_error (error, _inner_error_);
				_g_free0 (msg);
				return FALSE;
			} else {
				_g_free0 (msg);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return FALSE;
			}
		}
		case SQLITE_EMPTY:
		{
			GError* _tmp15_ = NULL;
			_tmp15_ = g_error_new_literal (SQL_HEAVY_ERROR, SQL_HEAVY_ERROR_EMPTY, msg);
			_inner_error_ = _tmp15_;
			if (_inner_error_->domain == SQL_HEAVY_ERROR) {
				g_propagate_error (error, _inner_error_);
				_g_free0 (msg);
				return FALSE;
			} else {
				_g_free0 (msg);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return FALSE;
			}
		}
		case SQLITE_SCHEMA:
		{
			GError* _tmp16_ = NULL;
			_tmp16_ = g_error_new_literal (SQL_HEAVY_ERROR, SQL_HEAVY_ERROR_SCHEMA, msg);
			_inner_error_ = _tmp16_;
			if (_inner_error_->domain == SQL_HEAVY_ERROR) {
				g_propagate_error (error, _inner_error_);
				_g_free0 (msg);
				return FALSE;
			} else {
				_g_free0 (msg);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return FALSE;
			}
		}
		case SQLITE_TOOBIG:
		{
			GError* _tmp17_ = NULL;
			_tmp17_ = g_error_new_literal (SQL_HEAVY_ERROR, SQL_HEAVY_ERROR_TOO_BIG, msg);
			_inner_error_ = _tmp17_;
			if (_inner_error_->domain == SQL_HEAVY_ERROR) {
				g_propagate_error (error, _inner_error_);
				_g_free0 (msg);
				return FALSE;
			} else {
				_g_free0 (msg);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return FALSE;
			}
		}
		case SQLITE_CONSTRAINT:
		{
			GError* _tmp18_ = NULL;
			_tmp18_ = g_error_new_literal (SQL_HEAVY_ERROR, SQL_HEAVY_ERROR_CONSTRAINT, msg);
			_inner_error_ = _tmp18_;
			if (_inner_error_->domain == SQL_HEAVY_ERROR) {
				g_propagate_error (error, _inner_error_);
				_g_free0 (msg);
				return FALSE;
			} else {
				_g_free0 (msg);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return FALSE;
			}
		}
		case SQLITE_MISMATCH:
		{
			GError* _tmp19_ = NULL;
			_tmp19_ = g_error_new_literal (SQL_HEAVY_ERROR, SQL_HEAVY_ERROR_MISMATCH, msg);
			_inner_error_ = _tmp19_;
			if (_inner_error_->domain == SQL_HEAVY_ERROR) {
				g_propagate_error (error, _inner_error_);
				_g_free0 (msg);
				return FALSE;
			} else {
				_g_free0 (msg);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return FALSE;
			}
		}
		case SQLITE_MISUSE:
		{
			GError* _tmp20_ = NULL;
			_tmp20_ = g_error_new_literal (SQL_HEAVY_ERROR, SQL_HEAVY_ERROR_MISUSE, msg);
			_inner_error_ = _tmp20_;
			if (_inner_error_->domain == SQL_HEAVY_ERROR) {
				g_propagate_error (error, _inner_error_);
				_g_free0 (msg);
				return FALSE;
			} else {
				_g_free0 (msg);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return FALSE;
			}
		}
		case SQLITE_NOLFS:
		{
			GError* _tmp21_ = NULL;
			_tmp21_ = g_error_new_literal (SQL_HEAVY_ERROR, SQL_HEAVY_ERROR_NOLFS, msg);
			_inner_error_ = _tmp21_;
			if (_inner_error_->domain == SQL_HEAVY_ERROR) {
				g_propagate_error (error, _inner_error_);
				_g_free0 (msg);
				return FALSE;
			} else {
				_g_free0 (msg);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return FALSE;
			}
		}
		case SQLITE_AUTH:
		{
			GError* _tmp22_ = NULL;
			_tmp22_ = g_error_new_literal (SQL_HEAVY_ERROR, SQL_HEAVY_ERROR_AUTH, msg);
			_inner_error_ = _tmp22_;
			if (_inner_error_->domain == SQL_HEAVY_ERROR) {
				g_propagate_error (error, _inner_error_);
				_g_free0 (msg);
				return FALSE;
			} else {
				_g_free0 (msg);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return FALSE;
			}
		}
		case SQLITE_FORMAT:
		{
			GError* _tmp23_ = NULL;
			_tmp23_ = g_error_new_literal (SQL_HEAVY_ERROR, SQL_HEAVY_ERROR_FORMAT, msg);
			_inner_error_ = _tmp23_;
			if (_inner_error_->domain == SQL_HEAVY_ERROR) {
				g_propagate_error (error, _inner_error_);
				_g_free0 (msg);
				return FALSE;
			} else {
				_g_free0 (msg);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return FALSE;
			}
		}
		case SQLITE_RANGE:
		{
			GError* _tmp24_ = NULL;
			_tmp24_ = g_error_new_literal (SQL_HEAVY_ERROR, SQL_HEAVY_ERROR_RANGE, msg);
			_inner_error_ = _tmp24_;
			if (_inner_error_->domain == SQL_HEAVY_ERROR) {
				g_propagate_error (error, _inner_error_);
				_g_free0 (msg);
				return FALSE;
			} else {
				_g_free0 (msg);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return FALSE;
			}
		}
		case SQLITE_NOTADB:
		{
			GError* _tmp25_ = NULL;
			_tmp25_ = g_error_new_literal (SQL_HEAVY_ERROR, SQL_HEAVY_ERROR_NOTADB, msg);
			_inner_error_ = _tmp25_;
			if (_inner_error_->domain == SQL_HEAVY_ERROR) {
				g_propagate_error (error, _inner_error_);
				_g_free0 (msg);
				return FALSE;
			} else {
				_g_free0 (msg);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return FALSE;
			}
		}
		default:
		{
			GError* _tmp26_ = NULL;
			_tmp26_ = g_error_new_literal (SQL_HEAVY_ERROR, SQL_HEAVY_ERROR_UNKNOWN, msg);
			_inner_error_ = _tmp26_;
			if (_inner_error_->domain == SQL_HEAVY_ERROR) {
				g_propagate_error (error, _inner_error_);
				_g_free0 (msg);
				return FALSE;
			} else {
				_g_free0 (msg);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return FALSE;
			}
		}
	}
	_g_free0 (msg);
}


GQuark sql_heavy_error_quark (void) {
	return g_quark_from_static_string ("sql_heavy_error-quark");
}


/**
   * Convert an SQLHeavy.Error to an SQLite error code. This function
   * is used to convert errors thrown by user defined functions.
   *
   * @param e SQLHeavy error
   */
gint sql_heavy_sqlite_code_from_error (GError* e) {
	gint result = 0;
	if (g_error_matches (e, SQL_HEAVY_ERROR, SQL_HEAVY_ERROR_INTERNAL)) {
		result = SQLITE_INTERNAL;
		return result;
	} else {
		if (g_error_matches (e, SQL_HEAVY_ERROR, SQL_HEAVY_ERROR_ACCESS_DENIED)) {
			result = SQLITE_PERM;
			return result;
		} else {
			if (g_error_matches (e, SQL_HEAVY_ERROR, SQL_HEAVY_ERROR_ERROR)) {
				result = SQLITE_ERROR;
				return result;
			} else {
				if (g_error_matches (e, SQL_HEAVY_ERROR, SQL_HEAVY_ERROR_ABORTED)) {
					result = SQLITE_ABORT;
					return result;
				} else {
					if (g_error_matches (e, SQL_HEAVY_ERROR, SQL_HEAVY_ERROR_BUSY)) {
						result = SQLITE_BUSY;
						return result;
					} else {
						if (g_error_matches (e, SQL_HEAVY_ERROR, SQL_HEAVY_ERROR_LOCKED)) {
							result = SQLITE_LOCKED;
							return result;
						} else {
							if (g_error_matches (e, SQL_HEAVY_ERROR, SQL_HEAVY_ERROR_NO_MEMORY)) {
								result = SQLITE_NOMEM;
								return result;
							} else {
								if (g_error_matches (e, SQL_HEAVY_ERROR, SQL_HEAVY_ERROR_READ_ONLY)) {
									result = SQLITE_READONLY;
									return result;
								} else {
									if (g_error_matches (e, SQL_HEAVY_ERROR, SQL_HEAVY_ERROR_INTERRUPTED)) {
										result = SQLITE_INTERRUPT;
										return result;
									} else {
										if (g_error_matches (e, SQL_HEAVY_ERROR, SQL_HEAVY_ERROR_IO)) {
											result = SQLITE_IOERR;
											return result;
										} else {
											if (g_error_matches (e, SQL_HEAVY_ERROR, SQL_HEAVY_ERROR_CORRUPT)) {
												result = SQLITE_CORRUPT;
												return result;
											} else {
												if (g_error_matches (e, SQL_HEAVY_ERROR, SQL_HEAVY_ERROR_FULL)) {
													result = SQLITE_FULL;
													return result;
												} else {
													if (g_error_matches (e, SQL_HEAVY_ERROR, SQL_HEAVY_ERROR_CAN_NOT_OPEN)) {
														result = SQLITE_CANTOPEN;
														return result;
													} else {
														if (g_error_matches (e, SQL_HEAVY_ERROR, SQL_HEAVY_ERROR_EMPTY)) {
															result = SQLITE_EMPTY;
															return result;
														} else {
															if (g_error_matches (e, SQL_HEAVY_ERROR, SQL_HEAVY_ERROR_SCHEMA)) {
																result = SQLITE_SCHEMA;
																return result;
															} else {
																if (g_error_matches (e, SQL_HEAVY_ERROR, SQL_HEAVY_ERROR_TOO_BIG)) {
																	result = SQLITE_TOOBIG;
																	return result;
																} else {
																	if (g_error_matches (e, SQL_HEAVY_ERROR, SQL_HEAVY_ERROR_CONSTRAINT)) {
																		result = SQLITE_CONSTRAINT;
																		return result;
																	} else {
																		if (g_error_matches (e, SQL_HEAVY_ERROR, SQL_HEAVY_ERROR_MISMATCH)) {
																			result = SQLITE_MISMATCH;
																			return result;
																		} else {
																			if (g_error_matches (e, SQL_HEAVY_ERROR, SQL_HEAVY_ERROR_MISUSE)) {
																				result = SQLITE_MISUSE;
																				return result;
																			} else {
																				if (g_error_matches (e, SQL_HEAVY_ERROR, SQL_HEAVY_ERROR_NOLFS)) {
																					result = SQLITE_NOLFS;
																					return result;
																				} else {
																					if (g_error_matches (e, SQL_HEAVY_ERROR, SQL_HEAVY_ERROR_AUTH)) {
																						result = SQLITE_AUTH;
																						return result;
																					} else {
																						if (g_error_matches (e, SQL_HEAVY_ERROR, SQL_HEAVY_ERROR_FORMAT)) {
																							result = SQLITE_FORMAT;
																							return result;
																						} else {
																							if (g_error_matches (e, SQL_HEAVY_ERROR, SQL_HEAVY_ERROR_RANGE)) {
																								result = SQLITE_RANGE;
																								return result;
																							} else {
																								if (g_error_matches (e, SQL_HEAVY_ERROR, SQL_HEAVY_ERROR_NOTADB)) {
																									result = SQLITE_NOTADB;
																									return result;
																								} else {
																									result = SQLITE_ERROR;
																									return result;
																								}
																							}
																						}
																					}
																				}
																			}
																		}
																	}
																}
															}
														}
													}
												}
											}
										}
									}
								}
							}
						}
					}
				}
			}
		}
	}
}


/**
   * Convert an SQLite error code into a string representation.
   */
const gchar* sql_heavy_sqlite_errstr (gint ec) {
	const gchar* result = NULL;
	switch (ec) {
		case SQLITE_ERROR:
		{
			result = "SQL error or missing database";
			return result;
		}
		case SQLITE_INTERNAL:
		{
			result = "Internal logic error in SQLite";
			return result;
		}
		case SQLITE_PERM:
		{
			result = "Access permission denied";
			return result;
		}
		case SQLITE_ABORT:
		{
			result = "Callback routine requested an abort";
			return result;
		}
		case SQLITE_BUSY:
		{
			result = "The database file is locked";
			return result;
		}
		case SQLITE_LOCKED:
		{
			result = "A table in the database is locked";
			return result;
		}
		case SQLITE_NOMEM:
		{
			result = "A malloc failed";
			return result;
		}
		case SQLITE_READONLY:
		{
			result = "Attempt to write to a read-only database";
			return result;
		}
		case SQLITE_INTERRUPT:
		{
			result = "Operation interrupted";
			return result;
		}
		case SQLITE_IOERR:
		{
			result = "Some kind of disk I/O error occurred";
			return result;
		}
		case SQLITE_CORRUPT:
		{
			result = "The database disk image is malformed";
			return result;
		}
		case SQLITE_FULL:
		{
			result = "Insertion failed because database is full";
			return result;
		}
		case SQLITE_CANTOPEN:
		{
			result = "Unable to open the database file";
			return result;
		}
		case SQLITE_EMPTY:
		{
			result = "Database is empty";
			return result;
		}
		case SQLITE_SCHEMA:
		{
			result = "The database schema changed";
			return result;
		}
		case SQLITE_TOOBIG:
		{
			result = "String or BLOB exceeds size limit";
			return result;
		}
		case SQLITE_CONSTRAINT:
		{
			result = "Abort due to constraint violation";
			return result;
		}
		case SQLITE_MISMATCH:
		{
			result = "Data type mismatch";
			return result;
		}
		case SQLITE_MISUSE:
		{
			result = "Library used incorrectly";
			return result;
		}
		case SQLITE_NOLFS:
		{
			result = "Uses OS features not supported on host";
			return result;
		}
		case SQLITE_AUTH:
		{
			result = "Authorization denied";
			return result;
		}
		case SQLITE_FORMAT:
		{
			result = "Auxiliary database format error";
			return result;
		}
		case SQLITE_RANGE:
		{
			result = "Parameter out of range";
			return result;
		}
		case SQLITE_NOTADB:
		{
			result = "File opened that is not a database file";
			return result;
		}
		case SQLITE_ROW:
		{
			result = "sqlite3_step() has another row ready";
			return result;
		}
		case SQLITE_DONE:
		{
			result = "sqlite3_step() has finished executing";
			return result;
		}
		default:
		{
			result = "An unknown error occured";
			return result;
		}
	}
}



