// Global vars
var gPref = Components.classes["@mozilla.org/preferences-service;1"]
               .getService(Components.interfaces.nsIPrefService)
               .QueryInterface(Components.interfaces.nsIPrefBranch2);
var targetDial = -1;
var retVals = null;
var addDialBundle;

function Startup() {
  // Set variables
  targetDial = window.arguments[0];
  retVals = window.arguments[1];

  addDialBundle = document.getElementById("bundle_editDial");
  var text = document.getElementById("targetFile");
  if (gPref.prefHasUserValue("extensions.speeddial.thumbnail-" + targetDial + "-url")) {
    var targetURL = gPref.getCharPref("extensions.speeddial.thumbnail-" + targetDial + "-url");
    if (SpeedDialUtils.stringStartsWith(targetURL, "launch:")) {
      var targetFile = targetURL.substring("launch:".length);
      text.value = targetFile;
    }
  }
}

function onOK(event) {
  var text = document.getElementById("targetFile").value;
  
  // Delete thumbnail
  SpeedDialUtils.deassignThumbnail(targetDial);
  
  gPref.setCharPref("extensions.speeddial.thumbnail-" + targetDial + "-url", "launch:" + text);
  gPref.setBoolPref("extensions.speeddial.thumbnail-" + targetDial + "-js", false);
  gPref.setIntPref("extensions.speeddial.thumbnail-" + targetDial + "-layout", 3);
  
  var str = Components.classes["@mozilla.org/supports-string;1"].createInstance(Components.interfaces.nsISupportsString);
  var position = text.lastIndexOf("\\");
  if (position < 0) {
    position = text.lastIndexOf("/");
  }
  if (position == text.length - 1) {
    position = text.lastIndexOf("\\", text.length - 2);
    if (position < 0) {
      position = text.lastIndexOf("/", text.length - 2);
    }
  }
  if (position > -1) {
    str.data = text.substring(position + 1);
  } else {
    str.data = text;
  }
  
  gPref.setComplexValue("extensions.speeddial.thumbnail-" + targetDial + "-label", Components.interfaces.nsISupportsString, str);
  
  if (!SpeedDialUtils.isFirefox3()) {
    gPref.setCharPref("extensions.speeddial.thumbnail-" + targetDial + "-icon", "data:");
  }
  
  return true;
}

function onCancel(event) {
  if (retVals != null) {
    retVals.canceled = true;
  }
  return true;
}

function showFileBrowser() {
  var nsIFilePicker = Components.interfaces.nsIFilePicker;
  var fp = Components.classes["@mozilla.org/filepicker;1"].createInstance(nsIFilePicker);
  fp.init(window, addDialBundle.getString("selectFile"), nsIFilePicker.modeOpen);
  fp.appendFilters(nsIFilePicker.filterAll);

  try {
    var currentFile = document.getElementById("targetFile").value;
    var obj = Components.classes["@mozilla.org/file/local;1"].
          createInstance(Components.interfaces.nsILocalFile);
    obj.initWithPath(currentFile);
    if (!obj.isDirectory && obj.parent) {
      obj = obj.parent;
    }
    fp.displayDirectory = obj;
  } catch (e) {
    SpeedDialUtils.log(e);
  }
  
  var res = fp.show();
  if (res == nsIFilePicker.returnOK){
    document.getElementById("targetFile").value = fp.file.path;
  }
}

function showFolderBrowser() {
  var nsIFilePicker = Components.interfaces.nsIFilePicker;
  var fp = Components.classes["@mozilla.org/filepicker;1"].createInstance(nsIFilePicker);
  fp.init(window, addDialBundle.getString("selectFolder"), nsIFilePicker.modeGetFolder);
  fp.appendFilters(nsIFilePicker.filterAll);

  try {
    var currentFile = document.getElementById("targetFile").value;
    var obj = Components.classes["@mozilla.org/file/local;1"].
          createInstance(Components.interfaces.nsILocalFile);
    obj.initWithPath(currentFile);
    if (!obj.isDirectory && obj.parent) {
      obj = obj.parent;
    }
    fp.displayDirectory = obj;
  } catch (e) {
    SpeedDialUtils.log(e);
  }
  
  var res = fp.show();
  if (res == nsIFilePicker.returnOK){
    document.getElementById("targetFile").value = fp.file.path;
  }
}

function openFullEdit() {
  window.opener.openDialog("chrome://speeddial/content/editDial.xul", "",
             "centerscreen,chrome,dialog,resizable,dependent",
             targetDial);
  window.close();
}
