#include <gtk/gtk.h>
#include <gdk/gdkkeysyms.h>
#include "paramselector.h"
#include "specimen.h"
#include "patch.h"

enum
{
    CHANGED,
    LAST_SIGNAL,
};

static int signals[LAST_SIGNAL];
static GtkHBoxClass* parent_class;

static void param_selector_class_init(ParamSelectorClass* klass);
static void param_selector_init(ParamSelector* self);


GType param_selector_get_type(void)
{
    static GType type = 0;

    if (!type)
    {
	static const GTypeInfo info =
	    {
		sizeof (ParamSelectorClass),
		NULL,
		NULL,
		(GClassInitFunc) param_selector_class_init,
		NULL,
		NULL,
		sizeof (ParamSelector),
		0,
		(GInstanceInitFunc) param_selector_init,
	    };

	type = g_type_register_static(GTK_TYPE_HBOX, "ParamSelector", &info, 0);
    }

    return type;
}


static void param_selector_class_init(ParamSelectorClass* klass)
{
    parent_class = g_type_class_peek_parent(klass);

    signals[CHANGED] =
	  g_signal_new ("changed",
			G_TYPE_FROM_CLASS (klass),
			G_SIGNAL_RUN_FIRST | G_SIGNAL_ACTION,
			G_STRUCT_OFFSET (ParamSelectorClass, changed),
			NULL, NULL,
			g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);

    klass->changed = NULL;
}


static gboolean press_cb(GtkToggleButton* button, GdkEvent* event, ParamSelector* self)
{
    gboolean toggle = FALSE;

    switch (event->type)
    {
    case GDK_KEY_PRESS:
	if (event->key.keyval == GDK_Return ||
	    event->key.keyval == GDK_KP_Enter ||
	    event->key.keyval == GDK_space)
	    toggle = TRUE;
	break;
    case GDK_BUTTON_PRESS:
	if (event->button.button == 1)
	    toggle = TRUE;
	break;
    default:
	break;
    }

    if (!toggle)
	return FALSE;

    if (gtk_toggle_button_get_active(button))
	return TRUE;

    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(self->current), FALSE);
    self->current = GTK_WIDGET(button);
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(self->current), TRUE);

    g_signal_emit_by_name(G_OBJECT(self), "changed");
    
    return TRUE;
}


static gboolean enter_cb(GtkWidget* button, GdkEvent* event, ParamSelector* self)
{
    if (self->current == button)
	return TRUE;

    return FALSE;
}


static void param_selector_init(ParamSelector* self)
{
    GtkBox* box;
    GtkWidget* hbox;
    GList* list;

    hbox = gtk_hbox_new(FALSE, 0);
    gtk_box_pack_start(GTK_BOX(self), hbox, TRUE, FALSE, 0);
    gtk_widget_show(hbox);
    box = GTK_BOX(hbox);

    self->vol = gtk_toggle_button_new_with_label("Vol");
    self->pan = gtk_toggle_button_new_with_label("Pan");
    self->cut = gtk_toggle_button_new_with_label("Cut");
    self->res = gtk_toggle_button_new_with_label("Res");
    self->pitch = gtk_toggle_button_new_with_label("Pitch");

    gtk_box_pack_start(box, self->vol, TRUE, TRUE, 0);
    gtk_box_pack_start(box, self->pan, TRUE, TRUE, 0);
    gtk_box_pack_start(box, self->cut, TRUE, TRUE, 0);
    gtk_box_pack_start(box, self->res, TRUE, TRUE, 0);
    gtk_box_pack_start(box, self->pitch, TRUE, TRUE, 0);

    gtk_widget_show(self->vol);
    gtk_widget_show(self->pan);
    gtk_widget_show(self->cut);
    gtk_widget_show(self->res);
    gtk_widget_show(self->pitch);

    self->current = self->vol;
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(self->vol), TRUE);

    /* make connections */
    list = gtk_container_get_children(GTK_CONTAINER(hbox));
    while (list != NULL)
    {
	g_signal_connect(G_OBJECT(list->data), "button-press-event",
			 G_CALLBACK(press_cb), (gpointer)self);
	g_signal_connect(G_OBJECT(list->data), "key-press-event",
			 G_CALLBACK(press_cb), (gpointer)self);
	g_signal_connect(G_OBJECT(list->data), "enter-notify-event", 
			 G_CALLBACK(enter_cb), (gpointer)self);

	list = list->next;
    }
}


GtkWidget* param_selector_new(void)
{
    return (GtkWidget*) g_object_new(PARAM_SELECTOR_TYPE, NULL);
}


PatchParamType param_selector_get(ParamSelector* self)
{
    if (self->current == self->pan)
	return PATCH_PARAM_PANNING;
    else if (self->current == self->cut)
	return PATCH_PARAM_CUTOFF;
    else if (self->current == self->res)
	return PATCH_PARAM_RESONANCE;
    else if (self->current == self->pitch)
	return PATCH_PARAM_PITCH;
    else
	return PATCH_PARAM_VOLUME;
}
