/*

 helper function for srs_init.c -- populating the SPATIAL_REF_SYS table

 this code was autogenerated by "auto_epsg_ext" on Tue Jul 14 19:02:34 2020

 Author: Sandro Furieri a.furieri@lqt.it

 -----------------------------------------------------------------------------

 Version: MPL 1.1/GPL 2.0/LGPL 2.1

 The contents of this file are subject to the Mozilla Public License Version
 1.1 (the "License"); you may not use this file except in compliance with
 the License. You may obtain a copy of the License at
 http://www.mozilla.org/MPL/

Software distributed under the License is distributed on an "AS IS" basis,
WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
for the specific language governing rights and limitations under the
License.

The Original Code is the SpatiaLite library

The Initial Developer of the Original Code is Alessandro Furieri

Portions created by the Initial Developer are Copyright (C) 2008
the Initial Developer. All Rights Reserved.

Contributor(s):

Alternatively, the contents of this file may be used under the terms of
either the GNU General Public License Version 2 or later (the "GPL"), or
the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
in which case the provisions of the GPL or the LGPL are applicable instead
of those above. If you wish to allow use of your version of this file only
under the terms of either the GPL or the LGPL, and not to allow others to
use your version of this file under the terms of the MPL, indicate your
decision by deleting the provisions above and replace them with the notice
and other provisions required by the GPL or the LGPL. If you do not delete
the provisions above, a recipient may use your version of this file under
the terms of any one of the MPL, the GPL or the LGPL.

*/

#if defined(_WIN32) && !defined(__MINGW32__)
#include "config-msvc.h"
#else
#include "config.h"
#endif

#include <spatialite_private.h>

#ifndef OMIT_EPSG    /* full EPSG initialization enabled */

SPATIALITE_PRIVATE void
initialize_epsg_38 (int filter, struct epsg_defs **first, struct epsg_defs **last)
{
/* initializing the EPSG defs list */
    struct epsg_defs *p;
    p = add_epsg_def_ex (filter, first, last, 7420, "epsg", 7420,
        "ETRS89 / Kp2000 Bornholm", 0, 0,
        "GRS 1980", "Greenwich",
        "European_Terrestrial_Reference_System_1989", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=15 +k=1 +x_0=900000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +vunits=m +n");
    add_proj4text (p, 2,
        "o_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"ETRS89 / Kp2000 Bornholm + DVR90 height\",PRO");
    add_srs_wkt (p, 1,
        "JCS[\"ETRS89 / Kp2000 Bornholm\",GEOGCS[\"ETRS89\",DATUM");
    add_srs_wkt (p, 2,
        "[\"European_Terrestrial_Reference_System_1989\",SPHEROID");
    add_srs_wkt (p, 3,
        "[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 4,
        "7019\"]],AUTHORITY[\"EPSG\",\"6258\"]],PRIMEM[\"Greenwic");
    add_srs_wkt (p, 5,
        "h\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01");
    add_srs_wkt (p, 6,
        "74532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"");
    add_srs_wkt (p, 7,
        "EPSG\",\"4258\"]],PROJECTION[\"Transverse_Mercator\"],PA");
    add_srs_wkt (p, 8,
        "RAMETER[\"latitude_of_origin\",0],PARAMETER[\"central_me");
    add_srs_wkt (p, 9,
        "ridian\",15],PARAMETER[\"scale_factor\",1],PARAMETER[\"f");
    add_srs_wkt (p, 10,
        "alse_easting\",900000],PARAMETER[\"false_northing\",0],U");
    add_srs_wkt (p, 11,
        "NIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Eas");
    add_srs_wkt (p, 12,
        "ting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 13,
        ",\"2198\"]],VERT_CS[\"DVR90 height\",VERT_DATUM[\"Dansk ");
    add_srs_wkt (p, 14,
        "Vertikal Reference 1990\",2005,AUTHORITY[\"EPSG\",\"5206");
    add_srs_wkt (p, 15,
        "\"]],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS");
    add_srs_wkt (p, 16,
        "[\"Gravity-related height\",UP],AUTHORITY[\"EPSG\",\"579");
    add_srs_wkt (p, 17,
        "9\"]],AUTHORITY[\"EPSG\",\"7420\"]]");
    p = add_epsg_def_ex (filter, first, last, 7421, "epsg", 7421,
        "NTF (Paris) / Lambert zone II", 0, 0,
        "Clarke 1880 (IGN)", "Paris",
        "Nouvelle_Triangulation_Francaise_Paris", "Lambert_Conformal_Conic_1SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=46.8 +lat_0=46.8 +lon_0=0 +k_0=0.999877");
    add_proj4text (p, 1,
        "42 +x_0=600000 +y_0=2200000 +a=6378249.2 +b=6356515 +tow");
    add_proj4text (p, 2,
        "gs84=-168,-60,320,0,0,0,0 +pm=paris +units=m +vunits=m +");
    add_proj4text (p, 3,
        "no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"NTF (Paris) / Lambert zone II + NGF-IGN69 hei");
    add_srs_wkt (p, 1,
        "ght\",PROJCS[\"NTF (Paris) / Lambert zone II\",GEOGCS[\"");
    add_srs_wkt (p, 2,
        "NTF (Paris)\",DATUM[\"Nouvelle_Triangulation_Francaise_P");
    add_srs_wkt (p, 3,
        "aris\",SPHEROID[\"Clarke 1880 (IGN)\",6378249.2,293.4660");
    add_srs_wkt (p, 4,
        "21293627,AUTHORITY[\"EPSG\",\"7011\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 5,
        ",\"6807\"]],PRIMEM[\"Paris\",2.33722917,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 6,
        "\",\"8903\"]],UNIT[\"grad\",0.0157079632679489,AUTHORITY");
    add_srs_wkt (p, 7,
        "[\"EPSG\",\"9105\"]],AUTHORITY[\"EPSG\",\"4807\"]],PROJE");
    add_srs_wkt (p, 8,
        "CTION[\"Lambert_Conformal_Conic_1SP\"],PARAMETER[\"latit");
    add_srs_wkt (p, 9,
        "ude_of_origin\",52],PARAMETER[\"central_meridian\",0],PA");
    add_srs_wkt (p, 10,
        "RAMETER[\"scale_factor\",0.99987742],PARAMETER[\"false_e");
    add_srs_wkt (p, 11,
        "asting\",600000],PARAMETER[\"false_northing\",2200000],U");
    add_srs_wkt (p, 12,
        "NIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Eas");
    add_srs_wkt (p, 13,
        "ting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 14,
        ",\"27572\"]],VERT_CS[\"NGF-IGN69 height\",VERT_DATUM[\"N");
    add_srs_wkt (p, 15,
        "ivellement General de la France - IGN69\",2005,AUTHORITY");
    add_srs_wkt (p, 16,
        "[\"EPSG\",\"5119\"]],UNIT[\"metre\",1,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 17,
        ",\"9001\"]],AXIS[\"Gravity-related height\",UP],AUTHORIT");
    add_srs_wkt (p, 18,
        "Y[\"EPSG\",\"5720\"]],AUTHORITY[\"EPSG\",\"7421\"]]");
    p = add_epsg_def_ex (filter, first, last, 7422, "epsg", 7422,
        "NTF (Paris) / Lambert zone III", 0, 0,
        "Clarke 1880 (IGN)", "Paris",
        "Nouvelle_Triangulation_Francaise_Paris", "Lambert_Conformal_Conic_1SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=44.10000000000001 +lat_0=44.10000000000");
    add_proj4text (p, 1,
        "001 +lon_0=0 +k_0=0.999877499 +x_0=600000 +y_0=3200000 +");
    add_proj4text (p, 2,
        "a=6378249.2 +b=6356515 +towgs84=-168,-60,320,0,0,0,0 +pm");
    add_proj4text (p, 3,
        "=paris +units=m +vunits=m +no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"NTF (Paris) / Lambert zone III + NGF-IGN69 he");
    add_srs_wkt (p, 1,
        "ight\",PROJCS[\"NTF (Paris) / Lambert zone III\",GEOGCS[");
    add_srs_wkt (p, 2,
        "\"NTF (Paris)\",DATUM[\"Nouvelle_Triangulation_Francaise");
    add_srs_wkt (p, 3,
        "_Paris\",SPHEROID[\"Clarke 1880 (IGN)\",6378249.2,293.46");
    add_srs_wkt (p, 4,
        "6021293627,AUTHORITY[\"EPSG\",\"7011\"]],AUTHORITY[\"EPS");
    add_srs_wkt (p, 5,
        "G\",\"6807\"]],PRIMEM[\"Paris\",2.33722917,AUTHORITY[\"E");
    add_srs_wkt (p, 6,
        "PSG\",\"8903\"]],UNIT[\"grad\",0.0157079632679489,AUTHOR");
    add_srs_wkt (p, 7,
        "ITY[\"EPSG\",\"9105\"]],AUTHORITY[\"EPSG\",\"4807\"]],PR");
    add_srs_wkt (p, 8,
        "OJECTION[\"Lambert_Conformal_Conic_1SP\"],PARAMETER[\"la");
    add_srs_wkt (p, 9,
        "titude_of_origin\",49],PARAMETER[\"central_meridian\",0]");
    add_srs_wkt (p, 10,
        ",PARAMETER[\"scale_factor\",0.999877499],PARAMETER[\"fal");
    add_srs_wkt (p, 11,
        "se_easting\",600000],PARAMETER[\"false_northing\",320000");
    add_srs_wkt (p, 12,
        "0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"");
    add_srs_wkt (p, 13,
        "Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPS");
    add_srs_wkt (p, 14,
        "G\",\"27573\"]],VERT_CS[\"NGF-IGN69 height\",VERT_DATUM[");
    add_srs_wkt (p, 15,
        "\"Nivellement General de la France - IGN69\",2005,AUTHOR");
    add_srs_wkt (p, 16,
        "ITY[\"EPSG\",\"5119\"]],UNIT[\"metre\",1,AUTHORITY[\"EPS");
    add_srs_wkt (p, 17,
        "G\",\"9001\"]],AXIS[\"Gravity-related height\",UP],AUTHO");
    add_srs_wkt (p, 18,
        "RITY[\"EPSG\",\"5720\"]],AUTHORITY[\"EPSG\",\"7422\"]]");
    p = add_epsg_def_ex (filter, first, last, 7423, "epsg", 7423,
        "ETRS89", 1, 0,
        "GRS 1980", "Greenwich",
        "European_Terrestrial_Reference_System_1989", "none", "degree",
        "Latitude", "North", "Longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +vunit");
    add_proj4text (p, 1,
        "s=m +no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"ETRS89 + EVRF2007 height\",GEOGCS[\"ETRS89\",");
    add_srs_wkt (p, 1,
        "DATUM[\"European_Terrestrial_Reference_System_1989\",SPH");
    add_srs_wkt (p, 2,
        "EROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPS");
    add_srs_wkt (p, 3,
        "G\",\"7019\"]],AUTHORITY[\"EPSG\",\"6258\"]],PRIMEM[\"Gr");
    add_srs_wkt (p, 4,
        "eenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\"");
    add_srs_wkt (p, 5,
        ",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"");
    add_srs_wkt (p, 6,
        "Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"E");
    add_srs_wkt (p, 7,
        "PSG\",\"4258\"]],VERT_CS[\"EVRF2007 height\",VERT_DATUM[");
    add_srs_wkt (p, 8,
        "\"European Vertical Reference Frame 2007\",2005,AUTHORIT");
    add_srs_wkt (p, 9,
        "Y[\"EPSG\",\"5215\"]],UNIT[\"metre\",1,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 10,
        ",\"9001\"]],AXIS[\"Gravity-related height\",UP],AUTHORIT");
    add_srs_wkt (p, 11,
        "Y[\"EPSG\",\"5621\"]],AUTHORITY[\"EPSG\",\"7423\"]]");
    p = add_epsg_def_ex (filter, first, last, 7528, "epsg", 7528,
        "NAD83(2011) / WISCRS Adams and Juneau (m)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=43.36666666666667 +lon_0=-90 +k=1.000");
    add_proj4text (p, 1,
        "0365285 +x_0=147218.6942 +y_0=0.0037 +ellps=GRS80 +units");
    add_proj4text (p, 2,
        "=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / WISCRS Adams and Juneau (m)\",GEO");
    add_srs_wkt (p, 1,
        "GCS[\"NAD83(2011)\",DATUM[\"NAD83_National_Spatial_Refer");
    add_srs_wkt (p, 2,
        "ence_System_2011\",SPHEROID[\"GRS 1980\",6378137,298.257");
    add_srs_wkt (p, 3,
        "222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 4,
        "\"1116\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8");
    add_srs_wkt (p, 5,
        "901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"E");
    add_srs_wkt (p, 6,
        "PSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTIO");
    add_srs_wkt (p, 7,
        "N[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_origi");
    add_srs_wkt (p, 8,
        "n\",43.3666666666667],PARAMETER[\"central_meridian\",-90");
    add_srs_wkt (p, 9,
        "],PARAMETER[\"scale_factor\",1.0000365285],PARAMETER[\"f");
    add_srs_wkt (p, 10,
        "alse_easting\",147218.6942],PARAMETER[\"false_northing\"");
    add_srs_wkt (p, 11,
        ",0.0037],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],");
    add_srs_wkt (p, 12,
        "AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORIT");
    add_srs_wkt (p, 13,
        "Y[\"EPSG\",\"7528\"]]");
    p = add_epsg_def_ex (filter, first, last, 7529, "epsg", 7529,
        "NAD83(2011) / WISCRS Ashland (m)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=45.70611111111111 +lon_0=-90.62222222");
    add_proj4text (p, 1,
        "222222 +k=1.0000495683 +x_0=172821.9461 +y_0=0.0017 +ell");
    add_proj4text (p, 2,
        "ps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / WISCRS Ashland (m)\",GEOGCS[\"NAD");
    add_srs_wkt (p, 1,
        "83(2011)\",DATUM[\"NAD83_National_Spatial_Reference_Syst");
    add_srs_wkt (p, 2,
        "em_2011\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AU");
    add_srs_wkt (p, 3,
        "THORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116\"]");
    add_srs_wkt (p, 4,
        "],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],U");
    add_srs_wkt (p, 5,
        "NIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9");
    add_srs_wkt (p, 6,
        "122\"]],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Trans");
    add_srs_wkt (p, 7,
        "verse_Mercator\"],PARAMETER[\"latitude_of_origin\",45.70");
    add_srs_wkt (p, 8,
        "61111111111],PARAMETER[\"central_meridian\",-90.62222222");
    add_srs_wkt (p, 9,
        "22222],PARAMETER[\"scale_factor\",1.0000495683],PARAMETE");
    add_srs_wkt (p, 10,
        "R[\"false_easting\",172821.9461],PARAMETER[\"false_north");
    add_srs_wkt (p, 11,
        "ing\",0.0017],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001");
    add_srs_wkt (p, 12,
        "\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUT");
    add_srs_wkt (p, 13,
        "HORITY[\"EPSG\",\"7529\"]]");
    p = add_epsg_def_ex (filter, first, last, 7530, "epsg", 7530,
        "NAD83(2011) / WISCRS Barron (m)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=45.13333333333333 +lon_0=-91.84999999");
    add_proj4text (p, 1,
        "999999 +k=1.0000486665 +x_0=93150 +y_0=0.0029 +ellps=GRS");
    add_proj4text (p, 2,
        "80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / WISCRS Barron (m)\",GEOGCS[\"NAD8");
    add_srs_wkt (p, 1,
        "3(2011)\",DATUM[\"NAD83_National_Spatial_Reference_Syste");
    add_srs_wkt (p, 2,
        "m_2011\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUT");
    add_srs_wkt (p, 3,
        "HORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116\"]]");
    add_srs_wkt (p, 4,
        ",PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UN");
    add_srs_wkt (p, 5,
        "IT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"91");
    add_srs_wkt (p, 6,
        "22\"]],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Transv");
    add_srs_wkt (p, 7,
        "erse_Mercator\"],PARAMETER[\"latitude_of_origin\",45.133");
    add_srs_wkt (p, 8,
        "3333333333],PARAMETER[\"central_meridian\",-91.85],PARAM");
    add_srs_wkt (p, 9,
        "ETER[\"scale_factor\",1.0000486665],PARAMETER[\"false_ea");
    add_srs_wkt (p, 10,
        "sting\",93150],PARAMETER[\"false_northing\",0.0029],UNIT");
    add_srs_wkt (p, 11,
        "[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Eastin");
    add_srs_wkt (p, 12,
        "g\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 13,
        "7530\"]]");
    p = add_epsg_def_ex (filter, first, last, 7531, "epsg", 7531,
        "NAD83(2011) / WISCRS Bayfield (m)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Lambert_Conformal_Conic_1SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=46.66964837722222 +lat_0=46.66964837722");
    add_proj4text (p, 1,
        "222 +lon_0=-91.15277777777779 +k_0=1.0000331195 +x_0=228");
    add_proj4text (p, 2,
        "600.4575 +y_0=148551.4837 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / WISCRS Bayfield (m)\",GEOGCS[\"NA");
    add_srs_wkt (p, 1,
        "D83(2011)\",DATUM[\"NAD83_National_Spatial_Reference_Sys");
    add_srs_wkt (p, 2,
        "tem_2011\",SPHEROID[\"GRS 1980\",6378137,298.257222101,A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116\"");
    add_srs_wkt (p, 4,
        "]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],");
    add_srs_wkt (p, 5,
        "UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "9122\"]],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Lamb");
    add_srs_wkt (p, 7,
        "ert_Conformal_Conic_1SP\"],PARAMETER[\"latitude_of_origi");
    add_srs_wkt (p, 8,
        "n\",46.6696483772222],PARAMETER[\"central_meridian\",-91");
    add_srs_wkt (p, 9,
        ".1527777777778],PARAMETER[\"scale_factor\",1.0000331195]");
    add_srs_wkt (p, 10,
        ",PARAMETER[\"false_easting\",228600.4575],PARAMETER[\"fa");
    add_srs_wkt (p, 11,
        "lse_northing\",148551.4837],UNIT[\"metre\",1,AUTHORITY[\"");
    add_srs_wkt (p, 12,
        "EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing");
    add_srs_wkt (p, 13,
        "\",NORTH],AUTHORITY[\"EPSG\",\"7531\"]]");
    p = add_epsg_def_ex (filter, first, last, 7532, "epsg", 7532,
        "NAD83(2011) / WISCRS Brown (m)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=43 +lon_0=-88 +k=1.00002 +x_0=31600 +");
    add_proj4text (p, 1,
        "y_0=4600 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / WISCRS Brown (m)\",GEOGCS[\"NAD83");
    add_srs_wkt (p, 1,
        "(2011)\",DATUM[\"NAD83_National_Spatial_Reference_System");
    add_srs_wkt (p, 2,
        "_2011\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTH");
    add_srs_wkt (p, 3,
        "ORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116\"]],");
    add_srs_wkt (p, 4,
        "PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNI");
    add_srs_wkt (p, 5,
        "T[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"912");
    add_srs_wkt (p, 6,
        "2\"]],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Transve");
    add_srs_wkt (p, 7,
        "rse_Mercator\"],PARAMETER[\"latitude_of_origin\",43],PAR");
    add_srs_wkt (p, 8,
        "AMETER[\"central_meridian\",-88],PARAMETER[\"scale_facto");
    add_srs_wkt (p, 9,
        "r\",1.00002],PARAMETER[\"false_easting\",31600],PARAMETE");
    add_srs_wkt (p, 10,
        "R[\"false_northing\",4600],UNIT[\"metre\",1,AUTHORITY[\"");
    add_srs_wkt (p, 11,
        "EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing");
    add_srs_wkt (p, 12,
        "\",NORTH],AUTHORITY[\"EPSG\",\"7532\"]]");
    p = add_epsg_def_ex (filter, first, last, 7533, "epsg", 7533,
        "NAD83(2011) / WISCRS Buffalo (m)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=43.48138888888889 +lon_0=-91.79722222");
    add_proj4text (p, 1,
        "222222 +k=1.0000382778 +x_0=175260.3502 +y_0=0.0048 +ell");
    add_proj4text (p, 2,
        "ps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / WISCRS Buffalo (m)\",GEOGCS[\"NAD");
    add_srs_wkt (p, 1,
        "83(2011)\",DATUM[\"NAD83_National_Spatial_Reference_Syst");
    add_srs_wkt (p, 2,
        "em_2011\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AU");
    add_srs_wkt (p, 3,
        "THORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116\"]");
    add_srs_wkt (p, 4,
        "],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],U");
    add_srs_wkt (p, 5,
        "NIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9");
    add_srs_wkt (p, 6,
        "122\"]],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Trans");
    add_srs_wkt (p, 7,
        "verse_Mercator\"],PARAMETER[\"latitude_of_origin\",43.48");
    add_srs_wkt (p, 8,
        "13888888889],PARAMETER[\"central_meridian\",-91.79722222");
    add_srs_wkt (p, 9,
        "22222],PARAMETER[\"scale_factor\",1.0000382778],PARAMETE");
    add_srs_wkt (p, 10,
        "R[\"false_easting\",175260.3502],PARAMETER[\"false_north");
    add_srs_wkt (p, 11,
        "ing\",0.0048],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001");
    add_srs_wkt (p, 12,
        "\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUT");
    add_srs_wkt (p, 13,
        "HORITY[\"EPSG\",\"7533\"]]");
    p = add_epsg_def_ex (filter, first, last, 7534, "epsg", 7534,
        "NAD83(2011) / WISCRS Burnett (m)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Lambert_Conformal_Conic_1SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=45.89871486583333 +lat_0=45.89871486583");
    add_proj4text (p, 1,
        "333 +lon_0=-92.45777777777778 +k_0=1.0000383841 +x_0=640");
    add_proj4text (p, 2,
        "08.1276 +y_0=59445.9043 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / WISCRS Burnett (m)\",GEOGCS[\"NAD");
    add_srs_wkt (p, 1,
        "83(2011)\",DATUM[\"NAD83_National_Spatial_Reference_Syst");
    add_srs_wkt (p, 2,
        "em_2011\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AU");
    add_srs_wkt (p, 3,
        "THORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116\"]");
    add_srs_wkt (p, 4,
        "],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],U");
    add_srs_wkt (p, 5,
        "NIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9");
    add_srs_wkt (p, 6,
        "122\"]],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Lambe");
    add_srs_wkt (p, 7,
        "rt_Conformal_Conic_1SP\"],PARAMETER[\"latitude_of_origin");
    add_srs_wkt (p, 8,
        "\",45.8987148658333],PARAMETER[\"central_meridian\",-92.");
    add_srs_wkt (p, 9,
        "4577777777778],PARAMETER[\"scale_factor\",1.0000383841],");
    add_srs_wkt (p, 10,
        "PARAMETER[\"false_easting\",64008.1276],PARAMETER[\"fals");
    add_srs_wkt (p, 11,
        "e_northing\",59445.9043],UNIT[\"metre\",1,AUTHORITY[\"EP");
    add_srs_wkt (p, 12,
        "SG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\"");
    add_srs_wkt (p, 13,
        ",NORTH],AUTHORITY[\"EPSG\",\"7534\"]]");
    p = add_epsg_def_ex (filter, first, last, 7535, "epsg", 7535,
        "NAD83(2011) / WISCRS Calumet, Fond du Lac, Outagamie and Winnebago (m)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=42.71944444444445 +lon_0=-88.5 +k=1.0");
    add_proj4text (p, 1,
        "000286569 +x_0=244754.8893 +y_0=0.0049 +ellps=GRS80 +uni");
    add_proj4text (p, 2,
        "ts=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / WISCRS Calumet, Fond du Lac, Outa");
    add_srs_wkt (p, 1,
        "gamie and Winnebago (m)\",GEOGCS[\"NAD83(2011)\",DATUM[\"");
    add_srs_wkt (p, 2,
        "NAD83_National_Spatial_Reference_System_2011\",SPHEROID[");
    add_srs_wkt (p, 3,
        "\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 4,
        "7019\"]],AUTHORITY[\"EPSG\",\"1116\"]],PRIMEM[\"Greenwic");
    add_srs_wkt (p, 5,
        "h\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01");
    add_srs_wkt (p, 6,
        "74532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"");
    add_srs_wkt (p, 7,
        "EPSG\",\"6318\"]],PROJECTION[\"Transverse_Mercator\"],PA");
    add_srs_wkt (p, 8,
        "RAMETER[\"latitude_of_origin\",42.7194444444444],PARAMET");
    add_srs_wkt (p, 9,
        "ER[\"central_meridian\",-88.5],PARAMETER[\"scale_factor\"");
    add_srs_wkt (p, 10,
        ",1.0000286569],PARAMETER[\"false_easting\",244754.8893],");
    add_srs_wkt (p, 11,
        "PARAMETER[\"false_northing\",0.0049],UNIT[\"metre\",1,AU");
    add_srs_wkt (p, 12,
        "THORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[");
    add_srs_wkt (p, 13,
        "\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"7535\"]]");
    p = add_epsg_def_ex (filter, first, last, 7536, "epsg", 7536,
        "NAD83(2011) / WISCRS Chippewa (m)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Lambert_Conformal_Conic_1SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=44.97785689861112 +lat_0=44.97785689861");
    add_proj4text (p, 1,
        "112 +lon_0=-91.29444444444444 +k_0=1.0000391127 +x_0=600");
    add_proj4text (p, 2,
        "45.72 +y_0=44091.4346 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / WISCRS Chippewa (m)\",GEOGCS[\"NA");
    add_srs_wkt (p, 1,
        "D83(2011)\",DATUM[\"NAD83_National_Spatial_Reference_Sys");
    add_srs_wkt (p, 2,
        "tem_2011\",SPHEROID[\"GRS 1980\",6378137,298.257222101,A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116\"");
    add_srs_wkt (p, 4,
        "]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],");
    add_srs_wkt (p, 5,
        "UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "9122\"]],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Lamb");
    add_srs_wkt (p, 7,
        "ert_Conformal_Conic_1SP\"],PARAMETER[\"latitude_of_origi");
    add_srs_wkt (p, 8,
        "n\",44.9778568986111],PARAMETER[\"central_meridian\",-91");
    add_srs_wkt (p, 9,
        ".2944444444444],PARAMETER[\"scale_factor\",1.0000391127]");
    add_srs_wkt (p, 10,
        ",PARAMETER[\"false_easting\",60045.72],PARAMETER[\"false");
    add_srs_wkt (p, 11,
        "_northing\",44091.4346],UNIT[\"metre\",1,AUTHORITY[\"EPS");
    add_srs_wkt (p, 12,
        "G\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",");
    add_srs_wkt (p, 13,
        "NORTH],AUTHORITY[\"EPSG\",\"7536\"]]");
    p = add_epsg_def_ex (filter, first, last, 7537, "epsg", 7537,
        "NAD83(2011) / WISCRS Clark (m)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=43.6 +lon_0=-90.70833333333334 +k=1.0");
    add_proj4text (p, 1,
        "000463003 +x_0=199949.1989 +y_0=0.0086 +ellps=GRS80 +uni");
    add_proj4text (p, 2,
        "ts=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / WISCRS Clark (m)\",GEOGCS[\"NAD83");
    add_srs_wkt (p, 1,
        "(2011)\",DATUM[\"NAD83_National_Spatial_Reference_System");
    add_srs_wkt (p, 2,
        "_2011\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTH");
    add_srs_wkt (p, 3,
        "ORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116\"]],");
    add_srs_wkt (p, 4,
        "PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNI");
    add_srs_wkt (p, 5,
        "T[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"912");
    add_srs_wkt (p, 6,
        "2\"]],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Transve");
    add_srs_wkt (p, 7,
        "rse_Mercator\"],PARAMETER[\"latitude_of_origin\",43.6],P");
    add_srs_wkt (p, 8,
        "ARAMETER[\"central_meridian\",-90.7083333333333],PARAMET");
    add_srs_wkt (p, 9,
        "ER[\"scale_factor\",1.0000463003],PARAMETER[\"false_east");
    add_srs_wkt (p, 10,
        "ing\",199949.1989],PARAMETER[\"false_northing\",0.0086],");
    add_srs_wkt (p, 11,
        "UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Ea");
    add_srs_wkt (p, 12,
        "sting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 13,
        ",\"7537\"]]");
    p = add_epsg_def_ex (filter, first, last, 7538, "epsg", 7538,
        "NAD83(2011) / WISCRS Columbia (m)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Lambert_Conformal_Conic_1SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=43.46254664583333 +lat_0=43.46254664583");
    add_proj4text (p, 1,
        "333 +lon_0=-89.39444444444445 +k_0=1.00003498 +x_0=16916");
    add_proj4text (p, 2,
        "4.3381 +y_0=111569.6134 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / WISCRS Columbia (m)\",GEOGCS[\"NA");
    add_srs_wkt (p, 1,
        "D83(2011)\",DATUM[\"NAD83_National_Spatial_Reference_Sys");
    add_srs_wkt (p, 2,
        "tem_2011\",SPHEROID[\"GRS 1980\",6378137,298.257222101,A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116\"");
    add_srs_wkt (p, 4,
        "]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],");
    add_srs_wkt (p, 5,
        "UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "9122\"]],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Lamb");
    add_srs_wkt (p, 7,
        "ert_Conformal_Conic_1SP\"],PARAMETER[\"latitude_of_origi");
    add_srs_wkt (p, 8,
        "n\",43.4625466458333],PARAMETER[\"central_meridian\",-89");
    add_srs_wkt (p, 9,
        ".3944444444444],PARAMETER[\"scale_factor\",1.00003498],P");
    add_srs_wkt (p, 10,
        "ARAMETER[\"false_easting\",169164.3381],PARAMETER[\"fals");
    add_srs_wkt (p, 11,
        "e_northing\",111569.6134],UNIT[\"metre\",1,AUTHORITY[\"E");
    add_srs_wkt (p, 12,
        "PSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\"");
    add_srs_wkt (p, 13,
        ",NORTH],AUTHORITY[\"EPSG\",\"7538\"]]");
    p = add_epsg_def_ex (filter, first, last, 7539, "epsg", 7539,
        "NAD83(2011) / WISCRS Crawford (m)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Lambert_Conformal_Conic_1SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=43.200055605 +lat_0=43.200055605 +lon_0");
    add_proj4text (p, 1,
        "=-90.9388888888889 +k_0=1.0000349151 +x_0=113690.6274 +y");
    add_proj4text (p, 2,
        "_0=53703.1201 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / WISCRS Crawford (m)\",GEOGCS[\"NA");
    add_srs_wkt (p, 1,
        "D83(2011)\",DATUM[\"NAD83_National_Spatial_Reference_Sys");
    add_srs_wkt (p, 2,
        "tem_2011\",SPHEROID[\"GRS 1980\",6378137,298.257222101,A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116\"");
    add_srs_wkt (p, 4,
        "]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],");
    add_srs_wkt (p, 5,
        "UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "9122\"]],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Lamb");
    add_srs_wkt (p, 7,
        "ert_Conformal_Conic_1SP\"],PARAMETER[\"latitude_of_origi");
    add_srs_wkt (p, 8,
        "n\",43.200055605],PARAMETER[\"central_meridian\",-90.938");
    add_srs_wkt (p, 9,
        "8888888889],PARAMETER[\"scale_factor\",1.0000349151],PAR");
    add_srs_wkt (p, 10,
        "AMETER[\"false_easting\",113690.6274],PARAMETER[\"false_");
    add_srs_wkt (p, 11,
        "northing\",53703.1201],UNIT[\"metre\",1,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 12,
        "\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",N");
    add_srs_wkt (p, 13,
        "ORTH],AUTHORITY[\"EPSG\",\"7539\"]]");
    p = add_epsg_def_ex (filter, first, last, 7540, "epsg", 7540,
        "NAD83(2011) / WISCRS Dane (m)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Lambert_Conformal_Conic_1SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=43.0695160375 +lat_0=43.0695160375 +lon");
    add_proj4text (p, 1,
        "_0=-89.42222222222223 +k_0=1.0000384786 +x_0=247193.2944");
    add_proj4text (p, 2,
        " +y_0=146591.9896 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / WISCRS Dane (m)\",GEOGCS[\"NAD83(");
    add_srs_wkt (p, 1,
        "2011)\",DATUM[\"NAD83_National_Spatial_Reference_System_");
    add_srs_wkt (p, 2,
        "2011\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHO");
    add_srs_wkt (p, 3,
        "RITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116\"]],P");
    add_srs_wkt (p, 4,
        "RIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT");
    add_srs_wkt (p, 5,
        "[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122");
    add_srs_wkt (p, 6,
        "\"]],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Lambert_");
    add_srs_wkt (p, 7,
        "Conformal_Conic_1SP\"],PARAMETER[\"latitude_of_origin\",");
    add_srs_wkt (p, 8,
        "43.0695160375],PARAMETER[\"central_meridian\",-89.422222");
    add_srs_wkt (p, 9,
        "2222222],PARAMETER[\"scale_factor\",1.0000384786],PARAME");
    add_srs_wkt (p, 10,
        "TER[\"false_easting\",247193.2944],PARAMETER[\"false_nor");
    add_srs_wkt (p, 11,
        "thing\",146591.9896],UNIT[\"metre\",1,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 12,
        ",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NOR");
    add_srs_wkt (p, 13,
        "TH],AUTHORITY[\"EPSG\",\"7540\"]]");
    p = add_epsg_def_ex (filter, first, last, 7541, "epsg", 7541,
        "NAD83(2011) / WISCRS Dodge and Jefferson (m)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=41.47222222222222 +lon_0=-88.77500000");
    add_proj4text (p, 1,
        "000001 +k=1.0000346418 +x_0=263347.7263 +y_0=0.0076 +ell");
    add_proj4text (p, 2,
        "ps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / WISCRS Dodge and Jefferson (m)\",");
    add_srs_wkt (p, 1,
        "GEOGCS[\"NAD83(2011)\",DATUM[\"NAD83_National_Spatial_Re");
    add_srs_wkt (p, 2,
        "ference_System_2011\",SPHEROID[\"GRS 1980\",6378137,298.");
    add_srs_wkt (p, 3,
        "257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 4,
        "\",\"1116\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 5,
        "\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[");
    add_srs_wkt (p, 6,
        "\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"6318\"]],PROJEC");
    add_srs_wkt (p, 7,
        "TION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_or");
    add_srs_wkt (p, 8,
        "igin\",41.4722222222222],PARAMETER[\"central_meridian\",");
    add_srs_wkt (p, 9,
        "-88.775],PARAMETER[\"scale_factor\",1.0000346418],PARAME");
    add_srs_wkt (p, 10,
        "TER[\"false_easting\",263347.7263],PARAMETER[\"false_nor");
    add_srs_wkt (p, 11,
        "thing\",0.0076],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"90");
    add_srs_wkt (p, 12,
        "01\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],A");
    add_srs_wkt (p, 13,
        "UTHORITY[\"EPSG\",\"7541\"]]");
    p = add_epsg_def_ex (filter, first, last, 7542, "epsg", 7542,
        "NAD83(2011) / WISCRS Door (m)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=44.4 +lon_0=-87.27222222222223 +k=1.0");
    add_proj4text (p, 1,
        "000187521 +x_0=158801.1176 +y_0=0.0023 +ellps=GRS80 +uni");
    add_proj4text (p, 2,
        "ts=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / WISCRS Door (m)\",GEOGCS[\"NAD83(");
    add_srs_wkt (p, 1,
        "2011)\",DATUM[\"NAD83_National_Spatial_Reference_System_");
    add_srs_wkt (p, 2,
        "2011\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHO");
    add_srs_wkt (p, 3,
        "RITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116\"]],P");
    add_srs_wkt (p, 4,
        "RIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT");
    add_srs_wkt (p, 5,
        "[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122");
    add_srs_wkt (p, 6,
        "\"]],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Transver");
    add_srs_wkt (p, 7,
        "se_Mercator\"],PARAMETER[\"latitude_of_origin\",44.4],PA");
    add_srs_wkt (p, 8,
        "RAMETER[\"central_meridian\",-87.2722222222222],PARAMETE");
    add_srs_wkt (p, 9,
        "R[\"scale_factor\",1.0000187521],PARAMETER[\"false_easti");
    add_srs_wkt (p, 10,
        "ng\",158801.1176],PARAMETER[\"false_northing\",0.0023],U");
    add_srs_wkt (p, 11,
        "NIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Eas");
    add_srs_wkt (p, 12,
        "ting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 13,
        ",\"7542\"]]");
    p = add_epsg_def_ex (filter, first, last, 7543, "epsg", 7543,
        "NAD83(2011) / WISCRS Douglas (m)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=45.88333333333333 +lon_0=-91.91666666");
    add_proj4text (p, 1,
        "666667 +k=1.0000385418 +x_0=59131.3183 +y_0=0.0041 +ellp");
    add_proj4text (p, 2,
        "s=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / WISCRS Douglas (m)\",GEOGCS[\"NAD");
    add_srs_wkt (p, 1,
        "83(2011)\",DATUM[\"NAD83_National_Spatial_Reference_Syst");
    add_srs_wkt (p, 2,
        "em_2011\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AU");
    add_srs_wkt (p, 3,
        "THORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116\"]");
    add_srs_wkt (p, 4,
        "],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],U");
    add_srs_wkt (p, 5,
        "NIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9");
    add_srs_wkt (p, 6,
        "122\"]],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Trans");
    add_srs_wkt (p, 7,
        "verse_Mercator\"],PARAMETER[\"latitude_of_origin\",45.88");
    add_srs_wkt (p, 8,
        "33333333333],PARAMETER[\"central_meridian\",-91.91666666");
    add_srs_wkt (p, 9,
        "66667],PARAMETER[\"scale_factor\",1.0000385418],PARAMETE");
    add_srs_wkt (p, 10,
        "R[\"false_easting\",59131.3183],PARAMETER[\"false_northi");
    add_srs_wkt (p, 11,
        "ng\",0.0041],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"");
    add_srs_wkt (p, 12,
        "]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHO");
    add_srs_wkt (p, 13,
        "RITY[\"EPSG\",\"7543\"]]");
    p = add_epsg_def_ex (filter, first, last, 7544, "epsg", 7544,
        "NAD83(2011) / WISCRS Dunn (m)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=44.40833333333333 +lon_0=-91.89444444");
    add_proj4text (p, 1,
        "444445 +k=1.0000410324 +x_0=51816.104 +y_0=0.003 +ellps=");
    add_proj4text (p, 2,
        "GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / WISCRS Dunn (m)\",GEOGCS[\"NAD83(");
    add_srs_wkt (p, 1,
        "2011)\",DATUM[\"NAD83_National_Spatial_Reference_System_");
    add_srs_wkt (p, 2,
        "2011\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHO");
    add_srs_wkt (p, 3,
        "RITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116\"]],P");
    add_srs_wkt (p, 4,
        "RIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT");
    add_srs_wkt (p, 5,
        "[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122");
    add_srs_wkt (p, 6,
        "\"]],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Transver");
    add_srs_wkt (p, 7,
        "se_Mercator\"],PARAMETER[\"latitude_of_origin\",44.40833");
    add_srs_wkt (p, 8,
        "33333333],PARAMETER[\"central_meridian\",-91.89444444444");
    add_srs_wkt (p, 9,
        "44],PARAMETER[\"scale_factor\",1.0000410324],PARAMETER[\"");
    add_srs_wkt (p, 10,
        "false_easting\",51816.104],PARAMETER[\"false_northing\",");
    add_srs_wkt (p, 11,
        "0.003],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AX");
    add_srs_wkt (p, 12,
        "IS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[");
    add_srs_wkt (p, 13,
        "\"EPSG\",\"7544\"]]");
    p = add_epsg_def_ex (filter, first, last, 7545, "epsg", 7545,
        "NAD83(2011) / WISCRS Eau Claire (m)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Lambert_Conformal_Conic_1SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=44.87228112638889 +lat_0=44.87228112638");
    add_proj4text (p, 1,
        "889 +lon_0=-91.28888888888889 +k_0=1.000035079 +x_0=1200");
    add_proj4text (p, 2,
        "91.4402 +y_0=91687.92389999999 +ellps=GRS80 +units=m +no");
    add_proj4text (p, 3,
        "_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / WISCRS Eau Claire (m)\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "NAD83(2011)\",DATUM[\"NAD83_National_Spatial_Reference_S");
    add_srs_wkt (p, 2,
        "ystem_2011\",SPHEROID[\"GRS 1980\",6378137,298.257222101");
    add_srs_wkt (p, 3,
        ",AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116");
    add_srs_wkt (p, 4,
        "\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]");
    add_srs_wkt (p, 5,
        "],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 6,
        "\"9122\"]],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"La");
    add_srs_wkt (p, 7,
        "mbert_Conformal_Conic_1SP\"],PARAMETER[\"latitude_of_ori");
    add_srs_wkt (p, 8,
        "gin\",44.8722811263889],PARAMETER[\"central_meridian\",-");
    add_srs_wkt (p, 9,
        "91.2888888888889],PARAMETER[\"scale_factor\",1.000035079");
    add_srs_wkt (p, 10,
        "],PARAMETER[\"false_easting\",120091.4402],PARAMETER[\"f");
    add_srs_wkt (p, 11,
        "alse_northing\",91687.9239],UNIT[\"metre\",1,AUTHORITY[\"");
    add_srs_wkt (p, 12,
        "EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing");
    add_srs_wkt (p, 13,
        "\",NORTH],AUTHORITY[\"EPSG\",\"7545\"]]");
    p = add_epsg_def_ex (filter, first, last, 7546, "epsg", 7546,
        "NAD83(2011) / WISCRS Florence (m)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=45.43888888888888 +lon_0=-88.14166666");
    add_proj4text (p, 1,
        "666668 +k=1.0000552095 +x_0=133502.6683 +y_0=0.0063 +ell");
    add_proj4text (p, 2,
        "ps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / WISCRS Florence (m)\",GEOGCS[\"NA");
    add_srs_wkt (p, 1,
        "D83(2011)\",DATUM[\"NAD83_National_Spatial_Reference_Sys");
    add_srs_wkt (p, 2,
        "tem_2011\",SPHEROID[\"GRS 1980\",6378137,298.257222101,A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116\"");
    add_srs_wkt (p, 4,
        "]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],");
    add_srs_wkt (p, 5,
        "UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "9122\"]],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Tran");
    add_srs_wkt (p, 7,
        "sverse_Mercator\"],PARAMETER[\"latitude_of_origin\",45.4");
    add_srs_wkt (p, 8,
        "388888888889],PARAMETER[\"central_meridian\",-88.1416666");
    add_srs_wkt (p, 9,
        "666667],PARAMETER[\"scale_factor\",1.0000552095],PARAMET");
    add_srs_wkt (p, 10,
        "ER[\"false_easting\",133502.6683],PARAMETER[\"false_nort");
    add_srs_wkt (p, 11,
        "hing\",0.0063],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"900");
    add_srs_wkt (p, 12,
        "1\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AU");
    add_srs_wkt (p, 13,
        "THORITY[\"EPSG\",\"7546\"]]");
    p = add_epsg_def_ex (filter, first, last, 7547, "epsg", 7547,
        "NAD83(2011) / WISCRS Forest (m)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=44.00555555555555 +lon_0=-88.63333333");
    add_proj4text (p, 1,
        "333334 +k=1.0000673004 +x_0=275844.5533 +y_0=0.0157 +ell");
    add_proj4text (p, 2,
        "ps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / WISCRS Forest (m)\",GEOGCS[\"NAD8");
    add_srs_wkt (p, 1,
        "3(2011)\",DATUM[\"NAD83_National_Spatial_Reference_Syste");
    add_srs_wkt (p, 2,
        "m_2011\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUT");
    add_srs_wkt (p, 3,
        "HORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116\"]]");
    add_srs_wkt (p, 4,
        ",PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UN");
    add_srs_wkt (p, 5,
        "IT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"91");
    add_srs_wkt (p, 6,
        "22\"]],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Transv");
    add_srs_wkt (p, 7,
        "erse_Mercator\"],PARAMETER[\"latitude_of_origin\",44.005");
    add_srs_wkt (p, 8,
        "5555555556],PARAMETER[\"central_meridian\",-88.633333333");
    add_srs_wkt (p, 9,
        "3333],PARAMETER[\"scale_factor\",1.0000673004],PARAMETER");
    add_srs_wkt (p, 10,
        "[\"false_easting\",275844.5533],PARAMETER[\"false_northi");
    add_srs_wkt (p, 11,
        "ng\",0.0157],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"");
    add_srs_wkt (p, 12,
        "]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHO");
    add_srs_wkt (p, 13,
        "RITY[\"EPSG\",\"7547\"]]");
    p = add_epsg_def_ex (filter, first, last, 7548, "epsg", 7548,
        "NAD83(2011) / WISCRS Grant (m)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=41.41111111111111 +lon_0=-90.8 +k=1.0");
    add_proj4text (p, 1,
        "000349452 +x_0=242316.4841 +y_0=0.01 +ellps=GRS80 +units");
    add_proj4text (p, 2,
        "=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / WISCRS Grant (m)\",GEOGCS[\"NAD83");
    add_srs_wkt (p, 1,
        "(2011)\",DATUM[\"NAD83_National_Spatial_Reference_System");
    add_srs_wkt (p, 2,
        "_2011\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTH");
    add_srs_wkt (p, 3,
        "ORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116\"]],");
    add_srs_wkt (p, 4,
        "PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNI");
    add_srs_wkt (p, 5,
        "T[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"912");
    add_srs_wkt (p, 6,
        "2\"]],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Transve");
    add_srs_wkt (p, 7,
        "rse_Mercator\"],PARAMETER[\"latitude_of_origin\",41.4111");
    add_srs_wkt (p, 8,
        "111111111],PARAMETER[\"central_meridian\",-90.8],PARAMET");
    add_srs_wkt (p, 9,
        "ER[\"scale_factor\",1.0000349452],PARAMETER[\"false_east");
    add_srs_wkt (p, 10,
        "ing\",242316.4841],PARAMETER[\"false_northing\",0.01],UN");
    add_srs_wkt (p, 11,
        "IT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"East");
    add_srs_wkt (p, 12,
        "ing\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 13,
        "\"7548\"]]");
    p = add_epsg_def_ex (filter, first, last, 7549, "epsg", 7549,
        "NAD83(2011) / WISCRS Green and Lafayette (m)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Lambert_Conformal_Conic_1SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=42.63756227694444 +lat_0=42.63756227694");
    add_proj4text (p, 1,
        "444 +lon_0=-89.83888888888889 +k_0=1.0000390487 +x_0=170");
    add_proj4text (p, 2,
        "078.7403 +y_0=45830.2947 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / WISCRS Green and Lafayette (m)\",");
    add_srs_wkt (p, 1,
        "GEOGCS[\"NAD83(2011)\",DATUM[\"NAD83_National_Spatial_Re");
    add_srs_wkt (p, 2,
        "ference_System_2011\",SPHEROID[\"GRS 1980\",6378137,298.");
    add_srs_wkt (p, 3,
        "257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 4,
        "\",\"1116\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 5,
        "\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[");
    add_srs_wkt (p, 6,
        "\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"6318\"]],PROJEC");
    add_srs_wkt (p, 7,
        "TION[\"Lambert_Conformal_Conic_1SP\"],PARAMETER[\"latitu");
    add_srs_wkt (p, 8,
        "de_of_origin\",42.6375622769444],PARAMETER[\"central_mer");
    add_srs_wkt (p, 9,
        "idian\",-89.8388888888889],PARAMETER[\"scale_factor\",1.");
    add_srs_wkt (p, 10,
        "0000390487],PARAMETER[\"false_easting\",170078.7403],PAR");
    add_srs_wkt (p, 11,
        "AMETER[\"false_northing\",45830.2947],UNIT[\"metre\",1,A");
    add_srs_wkt (p, 12,
        "UTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS");
    add_srs_wkt (p, 13,
        "[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"7549\"]]");
    p = add_epsg_def_ex (filter, first, last, 7550, "epsg", 7550,
        "NAD83(2011) / WISCRS Green Lake and Marquette (m)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Lambert_Conformal_Conic_1SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=43.80700011777778 +lat_0=43.80700011777");
    add_proj4text (p, 1,
        "778 +lon_0=-89.24166666666667 +k_0=1.0000344057 +x_0=150");
    add_proj4text (p, 2,
        "876.3018 +y_0=79170.7795 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / WISCRS Green Lake and Marquette (");
    add_srs_wkt (p, 1,
        "m)\",GEOGCS[\"NAD83(2011)\",DATUM[\"NAD83_National_Spati");
    add_srs_wkt (p, 2,
        "al_Reference_System_2011\",SPHEROID[\"GRS 1980\",6378137");
    add_srs_wkt (p, 3,
        ",298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"");
    add_srs_wkt (p, 4,
        "EPSG\",\"1116\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPS");
    add_srs_wkt (p, 5,
        "G\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHOR");
    add_srs_wkt (p, 6,
        "ITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"6318\"]],PR");
    add_srs_wkt (p, 7,
        "OJECTION[\"Lambert_Conformal_Conic_1SP\"],PARAMETER[\"la");
    add_srs_wkt (p, 8,
        "titude_of_origin\",43.8070001177778],PARAMETER[\"central");
    add_srs_wkt (p, 9,
        "_meridian\",-89.2416666666667],PARAMETER[\"scale_factor\"");
    add_srs_wkt (p, 10,
        ",1.0000344057],PARAMETER[\"false_easting\",150876.3018],");
    add_srs_wkt (p, 11,
        "PARAMETER[\"false_northing\",79170.7795],UNIT[\"metre\",");
    add_srs_wkt (p, 12,
        "1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],A");
    add_srs_wkt (p, 13,
        "XIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"7550\"]]");
    p = add_epsg_def_ex (filter, first, last, 7551, "epsg", 7551,
        "NAD83(2011) / WISCRS Iowa (m)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=42.53888888888888 +lon_0=-90.16111111");
    add_proj4text (p, 1,
        "111111 +k=1.0000394961 +x_0=113081.0261 +y_0=0.0045 +ell");
    add_proj4text (p, 2,
        "ps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / WISCRS Iowa (m)\",GEOGCS[\"NAD83(");
    add_srs_wkt (p, 1,
        "2011)\",DATUM[\"NAD83_National_Spatial_Reference_System_");
    add_srs_wkt (p, 2,
        "2011\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHO");
    add_srs_wkt (p, 3,
        "RITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116\"]],P");
    add_srs_wkt (p, 4,
        "RIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT");
    add_srs_wkt (p, 5,
        "[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122");
    add_srs_wkt (p, 6,
        "\"]],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Transver");
    add_srs_wkt (p, 7,
        "se_Mercator\"],PARAMETER[\"latitude_of_origin\",42.53888");
    add_srs_wkt (p, 8,
        "88888889],PARAMETER[\"central_meridian\",-90.16111111111");
    add_srs_wkt (p, 9,
        "11],PARAMETER[\"scale_factor\",1.0000394961],PARAMETER[\"");
    add_srs_wkt (p, 10,
        "false_easting\",113081.0261],PARAMETER[\"false_northing\"");
    add_srs_wkt (p, 11,
        ",0.0045],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],");
    add_srs_wkt (p, 12,
        "AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORIT");
    add_srs_wkt (p, 13,
        "Y[\"EPSG\",\"7551\"]]");
    p = add_epsg_def_ex (filter, first, last, 7552, "epsg", 7552,
        "NAD83(2011) / WISCRS Iron (m)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=45.43333333333333 +lon_0=-90.25555555");
    add_proj4text (p, 1,
        "555556 +k=1.0000677153 +x_0=220980.4419 +y_0=0.008500000");
    add_proj4text (p, 2,
        "000000001 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / WISCRS Iron (m)\",GEOGCS[\"NAD83(");
    add_srs_wkt (p, 1,
        "2011)\",DATUM[\"NAD83_National_Spatial_Reference_System_");
    add_srs_wkt (p, 2,
        "2011\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHO");
    add_srs_wkt (p, 3,
        "RITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116\"]],P");
    add_srs_wkt (p, 4,
        "RIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT");
    add_srs_wkt (p, 5,
        "[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122");
    add_srs_wkt (p, 6,
        "\"]],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Transver");
    add_srs_wkt (p, 7,
        "se_Mercator\"],PARAMETER[\"latitude_of_origin\",45.43333");
    add_srs_wkt (p, 8,
        "33333333],PARAMETER[\"central_meridian\",-90.25555555555");
    add_srs_wkt (p, 9,
        "56],PARAMETER[\"scale_factor\",1.0000677153],PARAMETER[\"");
    add_srs_wkt (p, 10,
        "false_easting\",220980.4419],PARAMETER[\"false_northing\"");
    add_srs_wkt (p, 11,
        ",0.0085],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],");
    add_srs_wkt (p, 12,
        "AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORIT");
    add_srs_wkt (p, 13,
        "Y[\"EPSG\",\"7552\"]]");
    p = add_epsg_def_ex (filter, first, last, 7553, "epsg", 7553,
        "NAD83(2011) / WISCRS Jackson (m)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=44.25333512777778 +lon_0=-90.84429651");
    add_proj4text (p, 1,
        "944444 +k=1.0000353 +x_0=27000 +y_0=25000 +ellps=GRS80 +");
    add_proj4text (p, 2,
        "units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / WISCRS Jackson (m)\",GEOGCS[\"NAD");
    add_srs_wkt (p, 1,
        "83(2011)\",DATUM[\"NAD83_National_Spatial_Reference_Syst");
    add_srs_wkt (p, 2,
        "em_2011\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AU");
    add_srs_wkt (p, 3,
        "THORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116\"]");
    add_srs_wkt (p, 4,
        "],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],U");
    add_srs_wkt (p, 5,
        "NIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9");
    add_srs_wkt (p, 6,
        "122\"]],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Trans");
    add_srs_wkt (p, 7,
        "verse_Mercator\"],PARAMETER[\"latitude_of_origin\",44.25");
    add_srs_wkt (p, 8,
        "33351277778],PARAMETER[\"central_meridian\",-90.84429651");
    add_srs_wkt (p, 9,
        "94444],PARAMETER[\"scale_factor\",1.0000353],PARAMETER[\"");
    add_srs_wkt (p, 10,
        "false_easting\",27000],PARAMETER[\"false_northing\",2500");
    add_srs_wkt (p, 11,
        "0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"");
    add_srs_wkt (p, 12,
        "Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPS");
    add_srs_wkt (p, 13,
        "G\",\"7553\"]]");
    p = add_epsg_def_ex (filter, first, last, 7554, "epsg", 7554,
        "NAD83(2011) / WISCRS Kenosha, Milwaukee, Ozaukee and Racine (m)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=42.21666666666667 +lon_0=-87.89444444");
    add_proj4text (p, 1,
        "444445 +k=1.0000260649 +x_0=185928.3728 +y_0=0.0009 +ell");
    add_proj4text (p, 2,
        "ps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / WISCRS Kenosha, Milwaukee, Ozauke");
    add_srs_wkt (p, 1,
        "e and Racine (m)\",GEOGCS[\"NAD83(2011)\",DATUM[\"NAD83_");
    add_srs_wkt (p, 2,
        "National_Spatial_Reference_System_2011\",SPHEROID[\"GRS ");
    add_srs_wkt (p, 3,
        "1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"");
    add_srs_wkt (p, 4,
        "]],AUTHORITY[\"EPSG\",\"1116\"]],PRIMEM[\"Greenwich\",0,");
    add_srs_wkt (p, 5,
        "AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329");
    add_srs_wkt (p, 6,
        "25199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 7,
        ",\"6318\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETE");
    add_srs_wkt (p, 8,
        "R[\"latitude_of_origin\",42.2166666666667],PARAMETER[\"c");
    add_srs_wkt (p, 9,
        "entral_meridian\",-87.8944444444444],PARAMETER[\"scale_f");
    add_srs_wkt (p, 10,
        "actor\",1.0000260649],PARAMETER[\"false_easting\",185928");
    add_srs_wkt (p, 11,
        ".3728],PARAMETER[\"false_northing\",0.0009],UNIT[\"metre");
    add_srs_wkt (p, 12,
        "\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST");
    add_srs_wkt (p, 13,
        "],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"7554\"]]");
    p = add_epsg_def_ex (filter, first, last, 7555, "epsg", 7555,
        "NAD83(2011) / WISCRS Kewaunee, Manitowoc and Sheboygan (m)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=43.26666666666667 +lon_0=-87.55 +k=1.");
    add_proj4text (p, 1,
        "0000233704 +x_0=79857.7614 +y_0=0.0012 +ellps=GRS80 +uni");
    add_proj4text (p, 2,
        "ts=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / WISCRS Kewaunee, Manitowoc and Sh");
    add_srs_wkt (p, 1,
        "eboygan (m)\",GEOGCS[\"NAD83(2011)\",DATUM[\"NAD83_Natio");
    add_srs_wkt (p, 2,
        "nal_Spatial_Reference_System_2011\",SPHEROID[\"GRS 1980\"");
    add_srs_wkt (p, 3,
        ",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUT");
    add_srs_wkt (p, 4,
        "HORITY[\"EPSG\",\"1116\"]],PRIMEM[\"Greenwich\",0,AUTHOR");
    add_srs_wkt (p, 5,
        "ITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251994");
    add_srs_wkt (p, 6,
        "33,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"63");
    add_srs_wkt (p, 7,
        "18\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"l");
    add_srs_wkt (p, 8,
        "atitude_of_origin\",43.2666666666667],PARAMETER[\"centra");
    add_srs_wkt (p, 9,
        "l_meridian\",-87.55],PARAMETER[\"scale_factor\",1.000023");
    add_srs_wkt (p, 10,
        "3704],PARAMETER[\"false_easting\",79857.7614],PARAMETER[");
    add_srs_wkt (p, 11,
        "\"false_northing\",0.0012],UNIT[\"metre\",1,AUTHORITY[\"");
    add_srs_wkt (p, 12,
        "EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing");
    add_srs_wkt (p, 13,
        "\",NORTH],AUTHORITY[\"EPSG\",\"7555\"]]");
    p = add_epsg_def_ex (filter, first, last, 7556, "epsg", 7556,
        "NAD83(2011) / WISCRS La Crosse (m)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=43.45111111111111 +lon_0=-91.31666666");
    add_proj4text (p, 1,
        "666666 +k=1.0000319985 +x_0=130454.6598 +y_0=0.0033 +ell");
    add_proj4text (p, 2,
        "ps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / WISCRS La Crosse (m)\",GEOGCS[\"N");
    add_srs_wkt (p, 1,
        "AD83(2011)\",DATUM[\"NAD83_National_Spatial_Reference_Sy");
    add_srs_wkt (p, 2,
        "stem_2011\",SPHEROID[\"GRS 1980\",6378137,298.257222101,");
    add_srs_wkt (p, 3,
        "AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116\"");
    add_srs_wkt (p, 4,
        "]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],");
    add_srs_wkt (p, 5,
        "UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "9122\"]],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Tran");
    add_srs_wkt (p, 7,
        "sverse_Mercator\"],PARAMETER[\"latitude_of_origin\",43.4");
    add_srs_wkt (p, 8,
        "511111111111],PARAMETER[\"central_meridian\",-91.3166666");
    add_srs_wkt (p, 9,
        "666667],PARAMETER[\"scale_factor\",1.0000319985],PARAMET");
    add_srs_wkt (p, 10,
        "ER[\"false_easting\",130454.6598],PARAMETER[\"false_nort");
    add_srs_wkt (p, 11,
        "hing\",0.0033],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"900");
    add_srs_wkt (p, 12,
        "1\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AU");
    add_srs_wkt (p, 13,
        "THORITY[\"EPSG\",\"7556\"]]");
    p = add_epsg_def_ex (filter, first, last, 7557, "epsg", 7557,
        "NAD83(2011) / WISCRS Langlade (m)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Lambert_Conformal_Conic_1SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=45.15423710527778 +lat_0=45.15423710527");
    add_proj4text (p, 1,
        "778 +lon_0=-89.03333333333333 +k_0=1.0000627024 +x_0=198");
    add_proj4text (p, 2,
        "425.197 +y_0=105279.7829 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / WISCRS Langlade (m)\",GEOGCS[\"NA");
    add_srs_wkt (p, 1,
        "D83(2011)\",DATUM[\"NAD83_National_Spatial_Reference_Sys");
    add_srs_wkt (p, 2,
        "tem_2011\",SPHEROID[\"GRS 1980\",6378137,298.257222101,A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116\"");
    add_srs_wkt (p, 4,
        "]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],");
    add_srs_wkt (p, 5,
        "UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "9122\"]],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Lamb");
    add_srs_wkt (p, 7,
        "ert_Conformal_Conic_1SP\"],PARAMETER[\"latitude_of_origi");
    add_srs_wkt (p, 8,
        "n\",45.1542371052778],PARAMETER[\"central_meridian\",-89");
    add_srs_wkt (p, 9,
        ".0333333333333],PARAMETER[\"scale_factor\",1.0000627024]");
    add_srs_wkt (p, 10,
        ",PARAMETER[\"false_easting\",198425.197],PARAMETER[\"fal");
    add_srs_wkt (p, 11,
        "se_northing\",105279.7829],UNIT[\"metre\",1,AUTHORITY[\"");
    add_srs_wkt (p, 12,
        "EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing");
    add_srs_wkt (p, 13,
        "\",NORTH],AUTHORITY[\"EPSG\",\"7557\"]]");
    p = add_epsg_def_ex (filter, first, last, 7558, "epsg", 7558,
        "NAD83(2011) / WISCRS Lincoln (m)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=44.84444444444445 +lon_0=-89.73333333");
    add_proj4text (p, 1,
        "333333 +k=1.0000599003 +x_0=116129.0323 +y_0=0.0058 +ell");
    add_proj4text (p, 2,
        "ps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / WISCRS Lincoln (m)\",GEOGCS[\"NAD");
    add_srs_wkt (p, 1,
        "83(2011)\",DATUM[\"NAD83_National_Spatial_Reference_Syst");
    add_srs_wkt (p, 2,
        "em_2011\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AU");
    add_srs_wkt (p, 3,
        "THORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116\"]");
    add_srs_wkt (p, 4,
        "],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],U");
    add_srs_wkt (p, 5,
        "NIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9");
    add_srs_wkt (p, 6,
        "122\"]],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Trans");
    add_srs_wkt (p, 7,
        "verse_Mercator\"],PARAMETER[\"latitude_of_origin\",44.84");
    add_srs_wkt (p, 8,
        "44444444444],PARAMETER[\"central_meridian\",-89.73333333");
    add_srs_wkt (p, 9,
        "33333],PARAMETER[\"scale_factor\",1.0000599003],PARAMETE");
    add_srs_wkt (p, 10,
        "R[\"false_easting\",116129.0323],PARAMETER[\"false_north");
    add_srs_wkt (p, 11,
        "ing\",0.0058],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001");
    add_srs_wkt (p, 12,
        "\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUT");
    add_srs_wkt (p, 13,
        "HORITY[\"EPSG\",\"7558\"]]");
    p = add_epsg_def_ex (filter, first, last, 7559, "epsg", 7559,
        "NAD83(2011) / WISCRS Marathon (m)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Lambert_Conformal_Conic_1SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=44.90090442361111 +lat_0=44.90090442361");
    add_proj4text (p, 1,
        "111 +lon_0=-89.77 +k_0=1.000053289 +x_0=74676.1493 +y_0=");
    add_proj4text (p, 2,
        "55049.2669 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / WISCRS Marathon (m)\",GEOGCS[\"NA");
    add_srs_wkt (p, 1,
        "D83(2011)\",DATUM[\"NAD83_National_Spatial_Reference_Sys");
    add_srs_wkt (p, 2,
        "tem_2011\",SPHEROID[\"GRS 1980\",6378137,298.257222101,A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116\"");
    add_srs_wkt (p, 4,
        "]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],");
    add_srs_wkt (p, 5,
        "UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "9122\"]],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Lamb");
    add_srs_wkt (p, 7,
        "ert_Conformal_Conic_1SP\"],PARAMETER[\"latitude_of_origi");
    add_srs_wkt (p, 8,
        "n\",44.9009044236111],PARAMETER[\"central_meridian\",-89");
    add_srs_wkt (p, 9,
        ".77],PARAMETER[\"scale_factor\",1.000053289],PARAMETER[\"");
    add_srs_wkt (p, 10,
        "false_easting\",74676.1493],PARAMETER[\"false_northing\"");
    add_srs_wkt (p, 11,
        ",55049.2669],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"");
    add_srs_wkt (p, 12,
        "]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHO");
    add_srs_wkt (p, 13,
        "RITY[\"EPSG\",\"7559\"]]");
    p = add_epsg_def_ex (filter, first, last, 7560, "epsg", 7560,
        "NAD83(2011) / WISCRS Marinette (m)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=44.69166666666666 +lon_0=-87.71111111");
    add_proj4text (p, 1,
        "111111 +k=1.0000234982 +x_0=238658.8794 +y_0=0.0032 +ell");
    add_proj4text (p, 2,
        "ps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / WISCRS Marinette (m)\",GEOGCS[\"N");
    add_srs_wkt (p, 1,
        "AD83(2011)\",DATUM[\"NAD83_National_Spatial_Reference_Sy");
    add_srs_wkt (p, 2,
        "stem_2011\",SPHEROID[\"GRS 1980\",6378137,298.257222101,");
    add_srs_wkt (p, 3,
        "AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116\"");
    add_srs_wkt (p, 4,
        "]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],");
    add_srs_wkt (p, 5,
        "UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "9122\"]],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Tran");
    add_srs_wkt (p, 7,
        "sverse_Mercator\"],PARAMETER[\"latitude_of_origin\",44.6");
    add_srs_wkt (p, 8,
        "916666666667],PARAMETER[\"central_meridian\",-87.7111111");
    add_srs_wkt (p, 9,
        "111111],PARAMETER[\"scale_factor\",1.0000234982],PARAMET");
    add_srs_wkt (p, 10,
        "ER[\"false_easting\",238658.8794],PARAMETER[\"false_nort");
    add_srs_wkt (p, 11,
        "hing\",0.0032],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"900");
    add_srs_wkt (p, 12,
        "1\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AU");
    add_srs_wkt (p, 13,
        "THORITY[\"EPSG\",\"7560\"]]");
    p = add_epsg_def_ex (filter, first, last, 7561, "epsg", 7561,
        "NAD83(2011) / WISCRS Menominee (m)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=44.71666666666667 +lon_0=-88.41666666");
    add_proj4text (p, 1,
        "666667 +k=1.0000362499 +x_0=105461.0121 +y_0=0.0029 +ell");
    add_proj4text (p, 2,
        "ps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / WISCRS Menominee (m)\",GEOGCS[\"N");
    add_srs_wkt (p, 1,
        "AD83(2011)\",DATUM[\"NAD83_National_Spatial_Reference_Sy");
    add_srs_wkt (p, 2,
        "stem_2011\",SPHEROID[\"GRS 1980\",6378137,298.257222101,");
    add_srs_wkt (p, 3,
        "AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116\"");
    add_srs_wkt (p, 4,
        "]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],");
    add_srs_wkt (p, 5,
        "UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "9122\"]],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Tran");
    add_srs_wkt (p, 7,
        "sverse_Mercator\"],PARAMETER[\"latitude_of_origin\",44.7");
    add_srs_wkt (p, 8,
        "166666666667],PARAMETER[\"central_meridian\",-88.4166666");
    add_srs_wkt (p, 9,
        "666667],PARAMETER[\"scale_factor\",1.0000362499],PARAMET");
    add_srs_wkt (p, 10,
        "ER[\"false_easting\",105461.0121],PARAMETER[\"false_nort");
    add_srs_wkt (p, 11,
        "hing\",0.0029],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"900");
    add_srs_wkt (p, 12,
        "1\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AU");
    add_srs_wkt (p, 13,
        "THORITY[\"EPSG\",\"7561\"]]");
    p = add_epsg_def_ex (filter, first, last, 7562, "epsg", 7562,
        "NAD83(2011) / WISCRS Monroe (m)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Lambert_Conformal_Conic_1SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=44.00007392861111 +lat_0=44.00007392861");
    add_proj4text (p, 1,
        "111 +lon_0=-90.64166666666668 +k_0=1.0000434122 +x_0=204");
    add_proj4text (p, 2,
        "521.209 +y_0=121923.9861 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / WISCRS Monroe (m)\",GEOGCS[\"NAD8");
    add_srs_wkt (p, 1,
        "3(2011)\",DATUM[\"NAD83_National_Spatial_Reference_Syste");
    add_srs_wkt (p, 2,
        "m_2011\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUT");
    add_srs_wkt (p, 3,
        "HORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116\"]]");
    add_srs_wkt (p, 4,
        ",PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UN");
    add_srs_wkt (p, 5,
        "IT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"91");
    add_srs_wkt (p, 6,
        "22\"]],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Lamber");
    add_srs_wkt (p, 7,
        "t_Conformal_Conic_1SP\"],PARAMETER[\"latitude_of_origin\"");
    add_srs_wkt (p, 8,
        ",44.0000739286111],PARAMETER[\"central_meridian\",-90.64");
    add_srs_wkt (p, 9,
        "16666666667],PARAMETER[\"scale_factor\",1.0000434122],PA");
    add_srs_wkt (p, 10,
        "RAMETER[\"false_easting\",204521.209],PARAMETER[\"false_");
    add_srs_wkt (p, 11,
        "northing\",121923.9861],UNIT[\"metre\",1,AUTHORITY[\"EPS");
    add_srs_wkt (p, 12,
        "G\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",");
    add_srs_wkt (p, 13,
        "NORTH],AUTHORITY[\"EPSG\",\"7562\"]]");
    p = add_epsg_def_ex (filter, first, last, 7563, "epsg", 7563,
        "NAD83(2011) / WISCRS Oconto (m)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=44.39722222222222 +lon_0=-87.90833333");
    add_proj4text (p, 1,
        "333335 +k=1.0000236869 +x_0=182880.3676 +y_0=0.0033 +ell");
    add_proj4text (p, 2,
        "ps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / WISCRS Oconto (m)\",GEOGCS[\"NAD8");
    add_srs_wkt (p, 1,
        "3(2011)\",DATUM[\"NAD83_National_Spatial_Reference_Syste");
    add_srs_wkt (p, 2,
        "m_2011\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUT");
    add_srs_wkt (p, 3,
        "HORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116\"]]");
    add_srs_wkt (p, 4,
        ",PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UN");
    add_srs_wkt (p, 5,
        "IT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"91");
    add_srs_wkt (p, 6,
        "22\"]],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Transv");
    add_srs_wkt (p, 7,
        "erse_Mercator\"],PARAMETER[\"latitude_of_origin\",44.397");
    add_srs_wkt (p, 8,
        "2222222222],PARAMETER[\"central_meridian\",-87.908333333");
    add_srs_wkt (p, 9,
        "3333],PARAMETER[\"scale_factor\",1.0000236869],PARAMETER");
    add_srs_wkt (p, 10,
        "[\"false_easting\",182880.3676],PARAMETER[\"false_northi");
    add_srs_wkt (p, 11,
        "ng\",0.0033],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"");
    add_srs_wkt (p, 12,
        "]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHO");
    add_srs_wkt (p, 13,
        "RITY[\"EPSG\",\"7563\"]]");
    p = add_epsg_def_ex (filter, first, last, 7564, "epsg", 7564,
        "NAD83(2011) / WISCRS Oneida (m)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Lambert_Conformal_Conic_1SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=45.70422377027778 +lat_0=45.70422377027");
    add_proj4text (p, 1,
        "778 +lon_0=-89.54444444444444 +k_0=1.0000686968 +x_0=701");
    add_proj4text (p, 2,
        "04.1401 +y_0=57588.0346 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / WISCRS Oneida (m)\",GEOGCS[\"NAD8");
    add_srs_wkt (p, 1,
        "3(2011)\",DATUM[\"NAD83_National_Spatial_Reference_Syste");
    add_srs_wkt (p, 2,
        "m_2011\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUT");
    add_srs_wkt (p, 3,
        "HORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116\"]]");
    add_srs_wkt (p, 4,
        ",PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UN");
    add_srs_wkt (p, 5,
        "IT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"91");
    add_srs_wkt (p, 6,
        "22\"]],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Lamber");
    add_srs_wkt (p, 7,
        "t_Conformal_Conic_1SP\"],PARAMETER[\"latitude_of_origin\"");
    add_srs_wkt (p, 8,
        ",45.7042237702778],PARAMETER[\"central_meridian\",-89.54");
    add_srs_wkt (p, 9,
        "44444444444],PARAMETER[\"scale_factor\",1.0000686968],PA");
    add_srs_wkt (p, 10,
        "RAMETER[\"false_easting\",70104.1401],PARAMETER[\"false_");
    add_srs_wkt (p, 11,
        "northing\",57588.0346],UNIT[\"metre\",1,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 12,
        "\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",N");
    add_srs_wkt (p, 13,
        "ORTH],AUTHORITY[\"EPSG\",\"7564\"]]");
    p = add_epsg_def_ex (filter, first, last, 7565, "epsg", 7565,
        "NAD83(2011) / WISCRS Pepin and Pierce (m)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Lambert_Conformal_Conic_1SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=44.63614887194444 +lat_0=44.63614887194");
    add_proj4text (p, 1,
        "444 +lon_0=-92.22777777777777 +k_0=1.0000362977 +x_0=167");
    add_proj4text (p, 2,
        "640.3354 +y_0=86033.0876 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / WISCRS Pepin and Pierce (m)\",GEO");
    add_srs_wkt (p, 1,
        "GCS[\"NAD83(2011)\",DATUM[\"NAD83_National_Spatial_Refer");
    add_srs_wkt (p, 2,
        "ence_System_2011\",SPHEROID[\"GRS 1980\",6378137,298.257");
    add_srs_wkt (p, 3,
        "222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 4,
        "\"1116\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8");
    add_srs_wkt (p, 5,
        "901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"E");
    add_srs_wkt (p, 6,
        "PSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTIO");
    add_srs_wkt (p, 7,
        "N[\"Lambert_Conformal_Conic_1SP\"],PARAMETER[\"latitude_");
    add_srs_wkt (p, 8,
        "of_origin\",44.6361488719444],PARAMETER[\"central_meridi");
    add_srs_wkt (p, 9,
        "an\",-92.2277777777778],PARAMETER[\"scale_factor\",1.000");
    add_srs_wkt (p, 10,
        "0362977],PARAMETER[\"false_easting\",167640.3354],PARAME");
    add_srs_wkt (p, 11,
        "TER[\"false_northing\",86033.0876],UNIT[\"metre\",1,AUTH");
    add_srs_wkt (p, 12,
        "ORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"");
    add_srs_wkt (p, 13,
        "Northing\",NORTH],AUTHORITY[\"EPSG\",\"7565\"]]");
    p = add_epsg_def_ex (filter, first, last, 7566, "epsg", 7566,
        "NAD83(2011) / WISCRS Polk (m)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=44.66111111111111 +lon_0=-92.63333333");
    add_proj4text (p, 1,
        "333334 +k=1.0000433849 +x_0=141732.2823 +y_0=0.0059 +ell");
    add_proj4text (p, 2,
        "ps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / WISCRS Polk (m)\",GEOGCS[\"NAD83(");
    add_srs_wkt (p, 1,
        "2011)\",DATUM[\"NAD83_National_Spatial_Reference_System_");
    add_srs_wkt (p, 2,
        "2011\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHO");
    add_srs_wkt (p, 3,
        "RITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116\"]],P");
    add_srs_wkt (p, 4,
        "RIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT");
    add_srs_wkt (p, 5,
        "[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122");
    add_srs_wkt (p, 6,
        "\"]],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Transver");
    add_srs_wkt (p, 7,
        "se_Mercator\"],PARAMETER[\"latitude_of_origin\",44.66111");
    add_srs_wkt (p, 8,
        "11111111],PARAMETER[\"central_meridian\",-92.63333333333");
    add_srs_wkt (p, 9,
        "33],PARAMETER[\"scale_factor\",1.0000433849],PARAMETER[\"");
    add_srs_wkt (p, 10,
        "false_easting\",141732.2823],PARAMETER[\"false_northing\"");
    add_srs_wkt (p, 11,
        ",0.0059],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],");
    add_srs_wkt (p, 12,
        "AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORIT");
    add_srs_wkt (p, 13,
        "Y[\"EPSG\",\"7566\"]]");
    p = add_epsg_def_ex (filter, first, last, 7567, "epsg", 7567,
        "NAD83(2011) / WISCRS Portage (m)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Lambert_Conformal_Conic_1SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=44.41682397527777 +lat_0=44.41682397527");
    add_proj4text (p, 1,
        "777 +lon_0=-89.5 +k_0=1.000039936 +x_0=56388.1128 +y_0=5");
    add_proj4text (p, 2,
        "0022.1874 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / WISCRS Portage (m)\",GEOGCS[\"NAD");
    add_srs_wkt (p, 1,
        "83(2011)\",DATUM[\"NAD83_National_Spatial_Reference_Syst");
    add_srs_wkt (p, 2,
        "em_2011\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AU");
    add_srs_wkt (p, 3,
        "THORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116\"]");
    add_srs_wkt (p, 4,
        "],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],U");
    add_srs_wkt (p, 5,
        "NIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9");
    add_srs_wkt (p, 6,
        "122\"]],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Lambe");
    add_srs_wkt (p, 7,
        "rt_Conformal_Conic_1SP\"],PARAMETER[\"latitude_of_origin");
    add_srs_wkt (p, 8,
        "\",44.4168239752778],PARAMETER[\"central_meridian\",-89.");
    add_srs_wkt (p, 9,
        "5],PARAMETER[\"scale_factor\",1.000039936],PARAMETER[\"f");
    add_srs_wkt (p, 10,
        "alse_easting\",56388.1128],PARAMETER[\"false_northing\",");
    add_srs_wkt (p, 11,
        "50022.1874],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"");
    add_srs_wkt (p, 12,
        "]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHO");
    add_srs_wkt (p, 13,
        "RITY[\"EPSG\",\"7567\"]]");
    p = add_epsg_def_ex (filter, first, last, 7568, "epsg", 7568,
        "NAD83(2011) / WISCRS Price (m)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=44.55555555555555 +lon_0=-90.48888888");
    add_proj4text (p, 1,
        "888889 +k=1.0000649554 +x_0=227990.8546 +y_0=0.0109 +ell");
    add_proj4text (p, 2,
        "ps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / WISCRS Price (m)\",GEOGCS[\"NAD83");
    add_srs_wkt (p, 1,
        "(2011)\",DATUM[\"NAD83_National_Spatial_Reference_System");
    add_srs_wkt (p, 2,
        "_2011\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTH");
    add_srs_wkt (p, 3,
        "ORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116\"]],");
    add_srs_wkt (p, 4,
        "PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNI");
    add_srs_wkt (p, 5,
        "T[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"912");
    add_srs_wkt (p, 6,
        "2\"]],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Transve");
    add_srs_wkt (p, 7,
        "rse_Mercator\"],PARAMETER[\"latitude_of_origin\",44.5555");
    add_srs_wkt (p, 8,
        "555555556],PARAMETER[\"central_meridian\",-90.4888888888");
    add_srs_wkt (p, 9,
        "889],PARAMETER[\"scale_factor\",1.0000649554],PARAMETER[");
    add_srs_wkt (p, 10,
        "\"false_easting\",227990.8546],PARAMETER[\"false_northin");
    add_srs_wkt (p, 11,
        "g\",0.0109],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"");
    add_srs_wkt (p, 12,
        "]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHO");
    add_srs_wkt (p, 13,
        "RITY[\"EPSG\",\"7568\"]]");
    p = add_epsg_def_ex (filter, first, last, 7569, "epsg", 7569,
        "NAD83(2011) / WISCRS Richland (m)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Lambert_Conformal_Conic_1SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=43.3223129275 +lat_0=43.3223129275 +lon");
    add_proj4text (p, 1,
        "_0=-90.43055555555556 +k_0=1.0000375653 +x_0=202387.6048");
    add_proj4text (p, 2,
        " +y_0=134255.4253 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / WISCRS Richland (m)\",GEOGCS[\"NA");
    add_srs_wkt (p, 1,
        "D83(2011)\",DATUM[\"NAD83_National_Spatial_Reference_Sys");
    add_srs_wkt (p, 2,
        "tem_2011\",SPHEROID[\"GRS 1980\",6378137,298.257222101,A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116\"");
    add_srs_wkt (p, 4,
        "]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],");
    add_srs_wkt (p, 5,
        "UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "9122\"]],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Lamb");
    add_srs_wkt (p, 7,
        "ert_Conformal_Conic_1SP\"],PARAMETER[\"latitude_of_origi");
    add_srs_wkt (p, 8,
        "n\",43.3223129275],PARAMETER[\"central_meridian\",-90.43");
    add_srs_wkt (p, 9,
        "05555555556],PARAMETER[\"scale_factor\",1.0000375653],PA");
    add_srs_wkt (p, 10,
        "RAMETER[\"false_easting\",202387.6048],PARAMETER[\"false");
    add_srs_wkt (p, 11,
        "_northing\",134255.4253],UNIT[\"metre\",1,AUTHORITY[\"EP");
    add_srs_wkt (p, 12,
        "SG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\"");
    add_srs_wkt (p, 13,
        ",NORTH],AUTHORITY[\"EPSG\",\"7569\"]]");
    p = add_epsg_def_ex (filter, first, last, 7570, "epsg", 7570,
        "NAD83(2011) / WISCRS Rock (m)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=41.94444444444444 +lon_0=-89.07222222");
    add_proj4text (p, 1,
        "222222 +k=1.0000337311 +x_0=146304.2926 +y_0=0.0068 +ell");
    add_proj4text (p, 2,
        "ps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / WISCRS Rock (m)\",GEOGCS[\"NAD83(");
    add_srs_wkt (p, 1,
        "2011)\",DATUM[\"NAD83_National_Spatial_Reference_System_");
    add_srs_wkt (p, 2,
        "2011\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHO");
    add_srs_wkt (p, 3,
        "RITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116\"]],P");
    add_srs_wkt (p, 4,
        "RIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT");
    add_srs_wkt (p, 5,
        "[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122");
    add_srs_wkt (p, 6,
        "\"]],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Transver");
    add_srs_wkt (p, 7,
        "se_Mercator\"],PARAMETER[\"latitude_of_origin\",41.94444");
    add_srs_wkt (p, 8,
        "44444444],PARAMETER[\"central_meridian\",-89.07222222222");
    add_srs_wkt (p, 9,
        "22],PARAMETER[\"scale_factor\",1.0000337311],PARAMETER[\"");
    add_srs_wkt (p, 10,
        "false_easting\",146304.2926],PARAMETER[\"false_northing\"");
    add_srs_wkt (p, 11,
        ",0.0068],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],");
    add_srs_wkt (p, 12,
        "AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORIT");
    add_srs_wkt (p, 13,
        "Y[\"EPSG\",\"7570\"]]");
    p = add_epsg_def_ex (filter, first, last, 7571, "epsg", 7571,
        "NAD83(2011) / WISCRS Rusk (m)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=43.91944444444444 +lon_0=-91.06666666");
    add_proj4text (p, 1,
        "666666 +k=1.0000495976 +x_0=250546.1013 +y_0=0.0234 +ell");
    add_proj4text (p, 2,
        "ps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / WISCRS Rusk (m)\",GEOGCS[\"NAD83(");
    add_srs_wkt (p, 1,
        "2011)\",DATUM[\"NAD83_National_Spatial_Reference_System_");
    add_srs_wkt (p, 2,
        "2011\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHO");
    add_srs_wkt (p, 3,
        "RITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116\"]],P");
    add_srs_wkt (p, 4,
        "RIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT");
    add_srs_wkt (p, 5,
        "[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122");
    add_srs_wkt (p, 6,
        "\"]],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Transver");
    add_srs_wkt (p, 7,
        "se_Mercator\"],PARAMETER[\"latitude_of_origin\",43.91944");
    add_srs_wkt (p, 8,
        "44444444],PARAMETER[\"central_meridian\",-91.06666666666");
    add_srs_wkt (p, 9,
        "67],PARAMETER[\"scale_factor\",1.0000495976],PARAMETER[\"");
    add_srs_wkt (p, 10,
        "false_easting\",250546.1013],PARAMETER[\"false_northing\"");
    add_srs_wkt (p, 11,
        ",0.0234],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],");
    add_srs_wkt (p, 12,
        "AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORIT");
    add_srs_wkt (p, 13,
        "Y[\"EPSG\",\"7571\"]]");
    p = add_epsg_def_ex (filter, first, last, 7572, "epsg", 7572,
        "NAD83(2011) / WISCRS Sauk (m)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=42.81944444444445 +lon_0=-89.90000000");
    add_proj4text (p, 1,
        "000001 +k=1.0000373868 +x_0=185623.5716 +y_0=0.0051 +ell");
    add_proj4text (p, 2,
        "ps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / WISCRS Sauk (m)\",GEOGCS[\"NAD83(");
    add_srs_wkt (p, 1,
        "2011)\",DATUM[\"NAD83_National_Spatial_Reference_System_");
    add_srs_wkt (p, 2,
        "2011\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHO");
    add_srs_wkt (p, 3,
        "RITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116\"]],P");
    add_srs_wkt (p, 4,
        "RIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT");
    add_srs_wkt (p, 5,
        "[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122");
    add_srs_wkt (p, 6,
        "\"]],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Transver");
    add_srs_wkt (p, 7,
        "se_Mercator\"],PARAMETER[\"latitude_of_origin\",42.81944");
    add_srs_wkt (p, 8,
        "44444444],PARAMETER[\"central_meridian\",-89.9],PARAMETE");
    add_srs_wkt (p, 9,
        "R[\"scale_factor\",1.0000373868],PARAMETER[\"false_easti");
    add_srs_wkt (p, 10,
        "ng\",185623.5716],PARAMETER[\"false_northing\",0.0051],U");
    add_srs_wkt (p, 11,
        "NIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Eas");
    add_srs_wkt (p, 12,
        "ting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 13,
        ",\"7572\"]]");
    p = add_epsg_def_ex (filter, first, last, 7573, "epsg", 7573,
        "NAD83(2011) / WISCRS Sawyer (m)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Lambert_Conformal_Conic_1SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=45.90009913138888 +lat_0=45.90009913138");
    add_proj4text (p, 1,
        "888 +lon_0=-91.11666666666666 +k_0=1.0000573461 +x_0=216");
    add_proj4text (p, 2,
        "713.2336 +y_0=120734.1631 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / WISCRS Sawyer (m)\",GEOGCS[\"NAD8");
    add_srs_wkt (p, 1,
        "3(2011)\",DATUM[\"NAD83_National_Spatial_Reference_Syste");
    add_srs_wkt (p, 2,
        "m_2011\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUT");
    add_srs_wkt (p, 3,
        "HORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116\"]]");
    add_srs_wkt (p, 4,
        ",PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UN");
    add_srs_wkt (p, 5,
        "IT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"91");
    add_srs_wkt (p, 6,
        "22\"]],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Lamber");
    add_srs_wkt (p, 7,
        "t_Conformal_Conic_1SP\"],PARAMETER[\"latitude_of_origin\"");
    add_srs_wkt (p, 8,
        ",45.9000991313889],PARAMETER[\"central_meridian\",-91.11");
    add_srs_wkt (p, 9,
        "66666666667],PARAMETER[\"scale_factor\",1.0000573461],PA");
    add_srs_wkt (p, 10,
        "RAMETER[\"false_easting\",216713.2336],PARAMETER[\"false");
    add_srs_wkt (p, 11,
        "_northing\",120734.1631],UNIT[\"metre\",1,AUTHORITY[\"EP");
    add_srs_wkt (p, 12,
        "SG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\"");
    add_srs_wkt (p, 13,
        ",NORTH],AUTHORITY[\"EPSG\",\"7573\"]]");
    p = add_epsg_def_ex (filter, first, last, 7574, "epsg", 7574,
        "NAD83(2011) / WISCRS Shawano (m)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=44.03611111111111 +lon_0=-88.60555555");
    add_proj4text (p, 1,
        "555555 +k=1.000032144 +x_0=262433.3253 +y_0=0.0095999999");
    add_proj4text (p, 2,
        "99999999 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / WISCRS Shawano (m)\",GEOGCS[\"NAD");
    add_srs_wkt (p, 1,
        "83(2011)\",DATUM[\"NAD83_National_Spatial_Reference_Syst");
    add_srs_wkt (p, 2,
        "em_2011\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AU");
    add_srs_wkt (p, 3,
        "THORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116\"]");
    add_srs_wkt (p, 4,
        "],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],U");
    add_srs_wkt (p, 5,
        "NIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9");
    add_srs_wkt (p, 6,
        "122\"]],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Trans");
    add_srs_wkt (p, 7,
        "verse_Mercator\"],PARAMETER[\"latitude_of_origin\",44.03");
    add_srs_wkt (p, 8,
        "61111111111],PARAMETER[\"central_meridian\",-88.60555555");
    add_srs_wkt (p, 9,
        "55556],PARAMETER[\"scale_factor\",1.000032144],PARAMETER");
    add_srs_wkt (p, 10,
        "[\"false_easting\",262433.3253],PARAMETER[\"false_northi");
    add_srs_wkt (p, 11,
        "ng\",0.0096],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"");
    add_srs_wkt (p, 12,
        "]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHO");
    add_srs_wkt (p, 13,
        "RITY[\"EPSG\",\"7574\"]]");
    p = add_epsg_def_ex (filter, first, last, 7575, "epsg", 7575,
        "NAD83(2011) / WISCRS St. Croix (m)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=44.03611111111111 +lon_0=-92.63333333");
    add_proj4text (p, 1,
        "333334 +k=1.0000381803 +x_0=165506.7302 +y_0=0.0103 +ell");
    add_proj4text (p, 2,
        "ps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / WISCRS St. Croix (m)\",GEOGCS[\"N");
    add_srs_wkt (p, 1,
        "AD83(2011)\",DATUM[\"NAD83_National_Spatial_Reference_Sy");
    add_srs_wkt (p, 2,
        "stem_2011\",SPHEROID[\"GRS 1980\",6378137,298.257222101,");
    add_srs_wkt (p, 3,
        "AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116\"");
    add_srs_wkt (p, 4,
        "]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],");
    add_srs_wkt (p, 5,
        "UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "9122\"]],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Tran");
    add_srs_wkt (p, 7,
        "sverse_Mercator\"],PARAMETER[\"latitude_of_origin\",44.0");
    add_srs_wkt (p, 8,
        "361111111111],PARAMETER[\"central_meridian\",-92.6333333");
    add_srs_wkt (p, 9,
        "333333],PARAMETER[\"scale_factor\",1.0000381803],PARAMET");
    add_srs_wkt (p, 10,
        "ER[\"false_easting\",165506.7302],PARAMETER[\"false_nort");
    add_srs_wkt (p, 11,
        "hing\",0.0103],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"900");
    add_srs_wkt (p, 12,
        "1\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AU");
    add_srs_wkt (p, 13,
        "THORITY[\"EPSG\",\"7575\"]]");
    p = add_epsg_def_ex (filter, first, last, 7576, "epsg", 7576,
        "NAD83(2011) / WISCRS Taylor (m)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Lambert_Conformal_Conic_1SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=45.17782208583333 +lat_0=45.17782208583");
    add_proj4text (p, 1,
        "333 +lon_0=-90.48333333333333 +k_0=1.0000597566 +x_0=187");
    add_proj4text (p, 2,
        "147.5744 +y_0=107746.7522 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / WISCRS Taylor (m)\",GEOGCS[\"NAD8");
    add_srs_wkt (p, 1,
        "3(2011)\",DATUM[\"NAD83_National_Spatial_Reference_Syste");
    add_srs_wkt (p, 2,
        "m_2011\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUT");
    add_srs_wkt (p, 3,
        "HORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116\"]]");
    add_srs_wkt (p, 4,
        ",PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UN");
    add_srs_wkt (p, 5,
        "IT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"91");
    add_srs_wkt (p, 6,
        "22\"]],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Lamber");
    add_srs_wkt (p, 7,
        "t_Conformal_Conic_1SP\"],PARAMETER[\"latitude_of_origin\"");
    add_srs_wkt (p, 8,
        ",45.1778220858333],PARAMETER[\"central_meridian\",-90.48");
    add_srs_wkt (p, 9,
        "33333333333],PARAMETER[\"scale_factor\",1.0000597566],PA");
    add_srs_wkt (p, 10,
        "RAMETER[\"false_easting\",187147.5744],PARAMETER[\"false");
    add_srs_wkt (p, 11,
        "_northing\",107746.7522],UNIT[\"metre\",1,AUTHORITY[\"EP");
    add_srs_wkt (p, 12,
        "SG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\"");
    add_srs_wkt (p, 13,
        ",NORTH],AUTHORITY[\"EPSG\",\"7576\"]]");
    p = add_epsg_def_ex (filter, first, last, 7577, "epsg", 7577,
        "NAD83(2011) / WISCRS Trempealeau (m)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=43.16111111111111 +lon_0=-91.36666666");
    add_proj4text (p, 1,
        "666666 +k=1.0000361538 +x_0=256946.9138 +y_0=0.0041 +ell");
    add_proj4text (p, 2,
        "ps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / WISCRS Trempealeau (m)\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "NAD83(2011)\",DATUM[\"NAD83_National_Spatial_Reference_S");
    add_srs_wkt (p, 2,
        "ystem_2011\",SPHEROID[\"GRS 1980\",6378137,298.257222101");
    add_srs_wkt (p, 3,
        ",AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116");
    add_srs_wkt (p, 4,
        "\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]");
    add_srs_wkt (p, 5,
        "],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 6,
        "\"9122\"]],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Tr");
    add_srs_wkt (p, 7,
        "ansverse_Mercator\"],PARAMETER[\"latitude_of_origin\",43");
    add_srs_wkt (p, 8,
        ".1611111111111],PARAMETER[\"central_meridian\",-91.36666");
    add_srs_wkt (p, 9,
        "66666667],PARAMETER[\"scale_factor\",1.0000361538],PARAM");
    add_srs_wkt (p, 10,
        "ETER[\"false_easting\",256946.9138],PARAMETER[\"false_no");
    add_srs_wkt (p, 11,
        "rthing\",0.0041],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9");
    add_srs_wkt (p, 12,
        "001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],");
    add_srs_wkt (p, 13,
        "AUTHORITY[\"EPSG\",\"7577\"]]");
    p = add_epsg_def_ex (filter, first, last, 7578, "epsg", 7578,
        "NAD83(2011) / WISCRS Vernon (m)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Lambert_Conformal_Conic_1SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=43.57503293972223 +lat_0=43.57503293972");
    add_proj4text (p, 1,
        "223 +lon_0=-90.78333333333333 +k_0=1.0000408158 +x_0=222");
    add_proj4text (p, 2,
        "504.4451 +y_0=47532.0602 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / WISCRS Vernon (m)\",GEOGCS[\"NAD8");
    add_srs_wkt (p, 1,
        "3(2011)\",DATUM[\"NAD83_National_Spatial_Reference_Syste");
    add_srs_wkt (p, 2,
        "m_2011\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUT");
    add_srs_wkt (p, 3,
        "HORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116\"]]");
    add_srs_wkt (p, 4,
        ",PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UN");
    add_srs_wkt (p, 5,
        "IT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"91");
    add_srs_wkt (p, 6,
        "22\"]],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Lamber");
    add_srs_wkt (p, 7,
        "t_Conformal_Conic_1SP\"],PARAMETER[\"latitude_of_origin\"");
    add_srs_wkt (p, 8,
        ",43.5750329397222],PARAMETER[\"central_meridian\",-90.78");
    add_srs_wkt (p, 9,
        "33333333333],PARAMETER[\"scale_factor\",1.0000408158],PA");
    add_srs_wkt (p, 10,
        "RAMETER[\"false_easting\",222504.4451],PARAMETER[\"false");
    add_srs_wkt (p, 11,
        "_northing\",47532.0602],UNIT[\"metre\",1,AUTHORITY[\"EPS");
    add_srs_wkt (p, 12,
        "G\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",");
    add_srs_wkt (p, 13,
        "NORTH],AUTHORITY[\"EPSG\",\"7578\"]]");
    p = add_epsg_def_ex (filter, first, last, 7579, "epsg", 7579,
        "NAD83(2011) / WISCRS Vilas (m)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Lambert_Conformal_Conic_1SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=46.07784409055556 +lat_0=46.07784409055");
    add_proj4text (p, 1,
        "556 +lon_0=-89.48888888888889 +k_0=1.0000730142 +x_0=134");
    add_proj4text (p, 2,
        "417.0689 +y_0=50337.1092 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / WISCRS Vilas (m)\",GEOGCS[\"NAD83");
    add_srs_wkt (p, 1,
        "(2011)\",DATUM[\"NAD83_National_Spatial_Reference_System");
    add_srs_wkt (p, 2,
        "_2011\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTH");
    add_srs_wkt (p, 3,
        "ORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116\"]],");
    add_srs_wkt (p, 4,
        "PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNI");
    add_srs_wkt (p, 5,
        "T[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"912");
    add_srs_wkt (p, 6,
        "2\"]],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Lambert");
    add_srs_wkt (p, 7,
        "_Conformal_Conic_1SP\"],PARAMETER[\"latitude_of_origin\"");
    add_srs_wkt (p, 8,
        ",46.0778440905556],PARAMETER[\"central_meridian\",-89.48");
    add_srs_wkt (p, 9,
        "88888888889],PARAMETER[\"scale_factor\",1.0000730142],PA");
    add_srs_wkt (p, 10,
        "RAMETER[\"false_easting\",134417.0689],PARAMETER[\"false");
    add_srs_wkt (p, 11,
        "_northing\",50337.1092],UNIT[\"metre\",1,AUTHORITY[\"EPS");
    add_srs_wkt (p, 12,
        "G\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",");
    add_srs_wkt (p, 13,
        "NORTH],AUTHORITY[\"EPSG\",\"7579\"]]");
    p = add_epsg_def_ex (filter, first, last, 7580, "epsg", 7580,
        "NAD83(2011) / WISCRS Walworth (m)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Lambert_Conformal_Conic_1SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=42.66946209694444 +lat_0=42.66946209694");
    add_proj4text (p, 1,
        "444 +lon_0=-88.54166666666667 +k_0=1.0000367192 +x_0=232");
    add_proj4text (p, 2,
        "562.8651 +y_0=111088.2224 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / WISCRS Walworth (m)\",GEOGCS[\"NA");
    add_srs_wkt (p, 1,
        "D83(2011)\",DATUM[\"NAD83_National_Spatial_Reference_Sys");
    add_srs_wkt (p, 2,
        "tem_2011\",SPHEROID[\"GRS 1980\",6378137,298.257222101,A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116\"");
    add_srs_wkt (p, 4,
        "]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],");
    add_srs_wkt (p, 5,
        "UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "9122\"]],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Lamb");
    add_srs_wkt (p, 7,
        "ert_Conformal_Conic_1SP\"],PARAMETER[\"latitude_of_origi");
    add_srs_wkt (p, 8,
        "n\",42.6694620969444],PARAMETER[\"central_meridian\",-88");
    add_srs_wkt (p, 9,
        ".5416666666667],PARAMETER[\"scale_factor\",1.0000367192]");
    add_srs_wkt (p, 10,
        ",PARAMETER[\"false_easting\",232562.8651],PARAMETER[\"fa");
    add_srs_wkt (p, 11,
        "lse_northing\",111088.2224],UNIT[\"metre\",1,AUTHORITY[\"");
    add_srs_wkt (p, 12,
        "EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing");
    add_srs_wkt (p, 13,
        "\",NORTH],AUTHORITY[\"EPSG\",\"7580\"]]");
    p = add_epsg_def_ex (filter, first, last, 7581, "epsg", 7581,
        "NAD83(2011) / WISCRS Washburn (m)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Lambert_Conformal_Conic_1SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=45.96121983333334 +lat_0=45.96121983333");
    add_proj4text (p, 1,
        "334 +lon_0=-91.78333333333333 +k_0=1.0000475376 +x_0=234");
    add_proj4text (p, 2,
        "086.8682 +y_0=188358.6058 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / WISCRS Washburn (m)\",GEOGCS[\"NA");
    add_srs_wkt (p, 1,
        "D83(2011)\",DATUM[\"NAD83_National_Spatial_Reference_Sys");
    add_srs_wkt (p, 2,
        "tem_2011\",SPHEROID[\"GRS 1980\",6378137,298.257222101,A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116\"");
    add_srs_wkt (p, 4,
        "]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],");
    add_srs_wkt (p, 5,
        "UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "9122\"]],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Lamb");
    add_srs_wkt (p, 7,
        "ert_Conformal_Conic_1SP\"],PARAMETER[\"latitude_of_origi");
    add_srs_wkt (p, 8,
        "n\",45.9612198333333],PARAMETER[\"central_meridian\",-91");
    add_srs_wkt (p, 9,
        ".7833333333333],PARAMETER[\"scale_factor\",1.0000475376]");
    add_srs_wkt (p, 10,
        ",PARAMETER[\"false_easting\",234086.8682],PARAMETER[\"fa");
    add_srs_wkt (p, 11,
        "lse_northing\",188358.6058],UNIT[\"metre\",1,AUTHORITY[\"");
    add_srs_wkt (p, 12,
        "EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing");
    add_srs_wkt (p, 13,
        "\",NORTH],AUTHORITY[\"EPSG\",\"7581\"]]");
    p = add_epsg_def_ex (filter, first, last, 7582, "epsg", 7582,
        "NAD83(2011) / WISCRS Washington (m)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=42.91805555555555 +lon_0=-88.06388888");
    add_proj4text (p, 1,
        "888888 +k=1.00003738 +x_0=120091.4415 +y_0=0.003 +ellps=");
    add_proj4text (p, 2,
        "GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / WISCRS Washington (m)\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "NAD83(2011)\",DATUM[\"NAD83_National_Spatial_Reference_S");
    add_srs_wkt (p, 2,
        "ystem_2011\",SPHEROID[\"GRS 1980\",6378137,298.257222101");
    add_srs_wkt (p, 3,
        ",AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116");
    add_srs_wkt (p, 4,
        "\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]");
    add_srs_wkt (p, 5,
        "],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 6,
        "\"9122\"]],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Tr");
    add_srs_wkt (p, 7,
        "ansverse_Mercator\"],PARAMETER[\"latitude_of_origin\",42");
    add_srs_wkt (p, 8,
        ".9180555555556],PARAMETER[\"central_meridian\",-88.06388");
    add_srs_wkt (p, 9,
        "88888889],PARAMETER[\"scale_factor\",1.00003738],PARAMET");
    add_srs_wkt (p, 10,
        "ER[\"false_easting\",120091.4415],PARAMETER[\"false_nort");
    add_srs_wkt (p, 11,
        "hing\",0.003],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001");
    add_srs_wkt (p, 12,
        "\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUT");
    add_srs_wkt (p, 13,
        "HORITY[\"EPSG\",\"7582\"]]");
    p = add_epsg_def_ex (filter, first, last, 7583, "epsg", 7583,
        "NAD83(2011) / WISCRS Waukesha (m)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=42.56944444444445 +lon_0=-88.22499999");
    add_proj4text (p, 1,
        "999999 +k=1.0000346179 +x_0=208788.418 +y_0=0.0034 +ellp");
    add_proj4text (p, 2,
        "s=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / WISCRS Waukesha (m)\",GEOGCS[\"NA");
    add_srs_wkt (p, 1,
        "D83(2011)\",DATUM[\"NAD83_National_Spatial_Reference_Sys");
    add_srs_wkt (p, 2,
        "tem_2011\",SPHEROID[\"GRS 1980\",6378137,298.257222101,A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116\"");
    add_srs_wkt (p, 4,
        "]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],");
    add_srs_wkt (p, 5,
        "UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "9122\"]],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Tran");
    add_srs_wkt (p, 7,
        "sverse_Mercator\"],PARAMETER[\"latitude_of_origin\",42.5");
    add_srs_wkt (p, 8,
        "694444444444],PARAMETER[\"central_meridian\",-88.225],PA");
    add_srs_wkt (p, 9,
        "RAMETER[\"scale_factor\",1.0000346179],PARAMETER[\"false");
    add_srs_wkt (p, 10,
        "_easting\",208788.418],PARAMETER[\"false_northing\",0.00");
    add_srs_wkt (p, 11,
        "34],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[");
    add_srs_wkt (p, 12,
        "\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"E");
    add_srs_wkt (p, 13,
        "PSG\",\"7583\"]]");
    p = add_epsg_def_ex (filter, first, last, 7584, "epsg", 7584,
        "NAD83(2011) / WISCRS Waupaca (m)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=43.42027777777778 +lon_0=-88.81666666");
    add_proj4text (p, 1,
        "666666 +k=1.0000333645 +x_0=185013.9709 +y_0=0.007 +ellp");
    add_proj4text (p, 2,
        "s=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / WISCRS Waupaca (m)\",GEOGCS[\"NAD");
    add_srs_wkt (p, 1,
        "83(2011)\",DATUM[\"NAD83_National_Spatial_Reference_Syst");
    add_srs_wkt (p, 2,
        "em_2011\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AU");
    add_srs_wkt (p, 3,
        "THORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116\"]");
    add_srs_wkt (p, 4,
        "],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],U");
    add_srs_wkt (p, 5,
        "NIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9");
    add_srs_wkt (p, 6,
        "122\"]],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Trans");
    add_srs_wkt (p, 7,
        "verse_Mercator\"],PARAMETER[\"latitude_of_origin\",43.42");
    add_srs_wkt (p, 8,
        "02777777778],PARAMETER[\"central_meridian\",-88.81666666");
    add_srs_wkt (p, 9,
        "66667],PARAMETER[\"scale_factor\",1.0000333645],PARAMETE");
    add_srs_wkt (p, 10,
        "R[\"false_easting\",185013.9709],PARAMETER[\"false_north");
    add_srs_wkt (p, 11,
        "ing\",0.007],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"");
    add_srs_wkt (p, 12,
        "]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHO");
    add_srs_wkt (p, 13,
        "RITY[\"EPSG\",\"7584\"]]");
    p = add_epsg_def_ex (filter, first, last, 7585, "epsg", 7585,
        "NAD83(2011) / WISCRS Waushara (m)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Lambert_Conformal_Conic_1SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=44.11394404583334 +lat_0=44.11394404583");
    add_proj4text (p, 1,
        "334 +lon_0=-89.24166666666667 +k_0=1.0000392096 +x_0=120");
    add_proj4text (p, 2,
        "091.4402 +y_0=45069.7587 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / WISCRS Waushara (m)\",GEOGCS[\"NA");
    add_srs_wkt (p, 1,
        "D83(2011)\",DATUM[\"NAD83_National_Spatial_Reference_Sys");
    add_srs_wkt (p, 2,
        "tem_2011\",SPHEROID[\"GRS 1980\",6378137,298.257222101,A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116\"");
    add_srs_wkt (p, 4,
        "]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],");
    add_srs_wkt (p, 5,
        "UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "9122\"]],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Lamb");
    add_srs_wkt (p, 7,
        "ert_Conformal_Conic_1SP\"],PARAMETER[\"latitude_of_origi");
    add_srs_wkt (p, 8,
        "n\",44.1139440458333],PARAMETER[\"central_meridian\",-89");
    add_srs_wkt (p, 9,
        ".2416666666667],PARAMETER[\"scale_factor\",1.0000392096]");
    add_srs_wkt (p, 10,
        ",PARAMETER[\"false_easting\",120091.4402],PARAMETER[\"fa");
    add_srs_wkt (p, 11,
        "lse_northing\",45069.7587],UNIT[\"metre\",1,AUTHORITY[\"");
    add_srs_wkt (p, 12,
        "EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing");
    add_srs_wkt (p, 13,
        "\",NORTH],AUTHORITY[\"EPSG\",\"7585\"]]");
    p = add_epsg_def_ex (filter, first, last, 7586, "epsg", 7586,
        "NAD83(2011) / WISCRS Wood (m)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Lambert_Conformal_Conic_1SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=44.36259546944444 +lat_0=44.36259546944");
    add_proj4text (p, 1,
        "444 +lon_0=-90 +k_0=1.0000421209 +x_0=208483.6173 +y_0=1");
    add_proj4text (p, 2,
        "34589.754 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / WISCRS Wood (m)\",GEOGCS[\"NAD83(");
    add_srs_wkt (p, 1,
        "2011)\",DATUM[\"NAD83_National_Spatial_Reference_System_");
    add_srs_wkt (p, 2,
        "2011\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHO");
    add_srs_wkt (p, 3,
        "RITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116\"]],P");
    add_srs_wkt (p, 4,
        "RIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT");
    add_srs_wkt (p, 5,
        "[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122");
    add_srs_wkt (p, 6,
        "\"]],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Lambert_");
    add_srs_wkt (p, 7,
        "Conformal_Conic_1SP\"],PARAMETER[\"latitude_of_origin\",");
    add_srs_wkt (p, 8,
        "44.3625954694444],PARAMETER[\"central_meridian\",-90],PA");
    add_srs_wkt (p, 9,
        "RAMETER[\"scale_factor\",1.0000421209],PARAMETER[\"false");
    add_srs_wkt (p, 10,
        "_easting\",208483.6173],PARAMETER[\"false_northing\",134");
    add_srs_wkt (p, 11,
        "589.754],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],");
    add_srs_wkt (p, 12,
        "AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORIT");
    add_srs_wkt (p, 13,
        "Y[\"EPSG\",\"7586\"]]");
    p = add_epsg_def_ex (filter, first, last, 7587, "epsg", 7587,
        "NAD83(2011) / WISCRS Adams and Juneau (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=43.36666666666667 +lon_0=-90 +k=1.000");
    add_proj4text (p, 1,
        "0365285 +x_0=147218.6941325883 +y_0=0.00365760731521463 ");
    add_proj4text (p, 2,
        "+ellps=GRS80 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / WISCRS Adams and Juneau (ftUS)\",");
    add_srs_wkt (p, 1,
        "GEOGCS[\"NAD83(2011)\",DATUM[\"NAD83_National_Spatial_Re");
    add_srs_wkt (p, 2,
        "ference_System_2011\",SPHEROID[\"GRS 1980\",6378137,298.");
    add_srs_wkt (p, 3,
        "257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 4,
        "\",\"1116\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 5,
        "\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[");
    add_srs_wkt (p, 6,
        "\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"6318\"]],PROJEC");
    add_srs_wkt (p, 7,
        "TION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_or");
    add_srs_wkt (p, 8,
        "igin\",43.3666666666667],PARAMETER[\"central_meridian\",");
    add_srs_wkt (p, 9,
        "-90],PARAMETER[\"scale_factor\",1.0000365285],PARAMETER[");
    add_srs_wkt (p, 10,
        "\"false_easting\",482999.999],PARAMETER[\"false_northing");
    add_srs_wkt (p, 11,
        "\",0.012],UNIT[\"US survey foot\",0.304800609601219,AUTH");
    add_srs_wkt (p, 12,
        "ORITY[\"EPSG\",\"9003\"]],AXIS[\"Easting\",EAST],AXIS[\"");
    add_srs_wkt (p, 13,
        "Northing\",NORTH],AUTHORITY[\"EPSG\",\"7587\"]]");
    p = add_epsg_def_ex (filter, first, last, 7588, "epsg", 7588,
        "NAD83(2011) / WISCRS Ashland (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=45.70611111111111 +lon_0=-90.62222222");
    add_proj4text (p, 1,
        "222222 +k=1.0000495683 +x_0=172821.945948692 +y_0=0.0018");
    add_proj4text (p, 2,
        "28803657607315 +ellps=GRS80 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / WISCRS Ashland (ftUS)\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "NAD83(2011)\",DATUM[\"NAD83_National_Spatial_Reference_S");
    add_srs_wkt (p, 2,
        "ystem_2011\",SPHEROID[\"GRS 1980\",6378137,298.257222101");
    add_srs_wkt (p, 3,
        ",AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116");
    add_srs_wkt (p, 4,
        "\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]");
    add_srs_wkt (p, 5,
        "],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 6,
        "\"9122\"]],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Tr");
    add_srs_wkt (p, 7,
        "ansverse_Mercator\"],PARAMETER[\"latitude_of_origin\",45");
    add_srs_wkt (p, 8,
        ".7061111111111],PARAMETER[\"central_meridian\",-90.62222");
    add_srs_wkt (p, 9,
        "22222222],PARAMETER[\"scale_factor\",1.0000495683],PARAM");
    add_srs_wkt (p, 10,
        "ETER[\"false_easting\",567000.001],PARAMETER[\"false_nor");
    add_srs_wkt (p, 11,
        "thing\",0.006],UNIT[\"US survey foot\",0.304800609601219");
    add_srs_wkt (p, 12,
        ",AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"Easting\",EAST],AX");
    add_srs_wkt (p, 13,
        "IS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"7588\"]]");
    p = add_epsg_def_ex (filter, first, last, 7589, "epsg", 7589,
        "NAD83(2011) / WISCRS Barron (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=45.13333333333333 +lon_0=-91.84999999");
    add_proj4text (p, 1,
        "999999 +k=1.0000486665 +x_0=93150 +y_0=0.003048006096012");
    add_proj4text (p, 2,
        "192 +ellps=GRS80 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / WISCRS Barron (ftUS)\",GEOGCS[\"N");
    add_srs_wkt (p, 1,
        "AD83(2011)\",DATUM[\"NAD83_National_Spatial_Reference_Sy");
    add_srs_wkt (p, 2,
        "stem_2011\",SPHEROID[\"GRS 1980\",6378137,298.257222101,");
    add_srs_wkt (p, 3,
        "AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116\"");
    add_srs_wkt (p, 4,
        "]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],");
    add_srs_wkt (p, 5,
        "UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "9122\"]],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Tran");
    add_srs_wkt (p, 7,
        "sverse_Mercator\"],PARAMETER[\"latitude_of_origin\",45.1");
    add_srs_wkt (p, 8,
        "333333333333],PARAMETER[\"central_meridian\",-91.85],PAR");
    add_srs_wkt (p, 9,
        "AMETER[\"scale_factor\",1.0000486665],PARAMETER[\"false_");
    add_srs_wkt (p, 10,
        "easting\",305609.625],PARAMETER[\"false_northing\",0.01]");
    add_srs_wkt (p, 11,
        ",UNIT[\"US survey foot\",0.304800609601219,AUTHORITY[\"E");
    add_srs_wkt (p, 12,
        "PSG\",\"9003\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\"");
    add_srs_wkt (p, 13,
        ",NORTH],AUTHORITY[\"EPSG\",\"7589\"]]");
    p = add_epsg_def_ex (filter, first, last, 7590, "epsg", 7590,
        "NAD83(2011) / WISCRS Bayfield (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Lambert_Conformal_Conic_1SP", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=46.66964837722222 +lat_0=46.66964837722");
    add_proj4text (p, 1,
        "222 +lon_0=-91.15277777777779 +k_0=1.0000331195 +x_0=228");
    add_proj4text (p, 2,
        "600.4575057151 +y_0=148551.4835661671 +ellps=GRS80 +unit");
    add_proj4text (p, 3,
        "s=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / WISCRS Bayfield (ftUS)\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "NAD83(2011)\",DATUM[\"NAD83_National_Spatial_Reference_S");
    add_srs_wkt (p, 2,
        "ystem_2011\",SPHEROID[\"GRS 1980\",6378137,298.257222101");
    add_srs_wkt (p, 3,
        ",AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116");
    add_srs_wkt (p, 4,
        "\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]");
    add_srs_wkt (p, 5,
        "],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 6,
        "\"9122\"]],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"La");
    add_srs_wkt (p, 7,
        "mbert_Conformal_Conic_1SP\"],PARAMETER[\"latitude_of_ori");
    add_srs_wkt (p, 8,
        "gin\",46.6696483772222],PARAMETER[\"central_meridian\",-");
    add_srs_wkt (p, 9,
        "91.1527777777778],PARAMETER[\"scale_factor\",1.000033119");
    add_srs_wkt (p, 10,
        "5],PARAMETER[\"false_easting\",750000.001],PARAMETER[\"f");
    add_srs_wkt (p, 11,
        "alse_northing\",487372.659],UNIT[\"US survey foot\",0.30");
    add_srs_wkt (p, 12,
        "4800609601219,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"Easti");
    add_srs_wkt (p, 13,
        "ng\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 14,
        "7590\"]]");
    p = add_epsg_def_ex (filter, first, last, 7591, "epsg", 7591,
        "NAD83(2011) / WISCRS Brown (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=43 +lon_0=-88 +k=1.00002 +x_0=31599.9");
    add_proj4text (p, 1,
        "9989839979 +y_0=4599.999898399797 +ellps=GRS80 +units=us");
    add_proj4text (p, 2,
        "-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / WISCRS Brown (ftUS)\",GEOGCS[\"NA");
    add_srs_wkt (p, 1,
        "D83(2011)\",DATUM[\"NAD83_National_Spatial_Reference_Sys");
    add_srs_wkt (p, 2,
        "tem_2011\",SPHEROID[\"GRS 1980\",6378137,298.257222101,A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116\"");
    add_srs_wkt (p, 4,
        "]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],");
    add_srs_wkt (p, 5,
        "UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "9122\"]],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Tran");
    add_srs_wkt (p, 7,
        "sverse_Mercator\"],PARAMETER[\"latitude_of_origin\",43],");
    add_srs_wkt (p, 8,
        "PARAMETER[\"central_meridian\",-88],PARAMETER[\"scale_fa");
    add_srs_wkt (p, 9,
        "ctor\",1.00002],PARAMETER[\"false_easting\",103674.333],");
    add_srs_wkt (p, 10,
        "PARAMETER[\"false_northing\",15091.833],UNIT[\"US survey");
    add_srs_wkt (p, 11,
        " foot\",0.304800609601219,AUTHORITY[\"EPSG\",\"9003\"]],");
    add_srs_wkt (p, 12,
        "AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORIT");
    add_srs_wkt (p, 13,
        "Y[\"EPSG\",\"7591\"]]");
    p = add_epsg_def_ex (filter, first, last, 7592, "epsg", 7592,
        "NAD83(2011) / WISCRS Buffalo (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=43.48138888888889 +lon_0=-91.79722222");
    add_proj4text (p, 1,
        "222222 +k=1.0000382778 +x_0=175260.3502159004 +y_0=0.004");
    add_proj4text (p, 2,
        "876809753619507 +ellps=GRS80 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / WISCRS Buffalo (ftUS)\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "NAD83(2011)\",DATUM[\"NAD83_National_Spatial_Reference_S");
    add_srs_wkt (p, 2,
        "ystem_2011\",SPHEROID[\"GRS 1980\",6378137,298.257222101");
    add_srs_wkt (p, 3,
        ",AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116");
    add_srs_wkt (p, 4,
        "\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]");
    add_srs_wkt (p, 5,
        "],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 6,
        "\"9122\"]],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Tr");
    add_srs_wkt (p, 7,
        "ansverse_Mercator\"],PARAMETER[\"latitude_of_origin\",43");
    add_srs_wkt (p, 8,
        ".4813888888889],PARAMETER[\"central_meridian\",-91.79722");
    add_srs_wkt (p, 9,
        "22222222],PARAMETER[\"scale_factor\",1.0000382778],PARAM");
    add_srs_wkt (p, 10,
        "ETER[\"false_easting\",574999.999],PARAMETER[\"false_nor");
    add_srs_wkt (p, 11,
        "thing\",0.016],UNIT[\"US survey foot\",0.304800609601219");
    add_srs_wkt (p, 12,
        ",AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"Easting\",EAST],AX");
    add_srs_wkt (p, 13,
        "IS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"7592\"]]");
    p = add_epsg_def_ex (filter, first, last, 7593, "epsg", 7593,
        "NAD83(2011) / WISCRS Burnett (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Lambert_Conformal_Conic_1SP", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=45.89871486583333 +lat_0=45.89871486583");
    add_proj4text (p, 1,
        "333 +lon_0=-92.45777777777778 +k_0=1.0000383841 +x_0=640");
    add_proj4text (p, 2,
        "08.12771145543 +y_0=59445.90419100838 +ellps=GRS80 +unit");
    add_proj4text (p, 3,
        "s=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / WISCRS Burnett (ftUS)\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "NAD83(2011)\",DATUM[\"NAD83_National_Spatial_Reference_S");
    add_srs_wkt (p, 2,
        "ystem_2011\",SPHEROID[\"GRS 1980\",6378137,298.257222101");
    add_srs_wkt (p, 3,
        ",AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116");
    add_srs_wkt (p, 4,
        "\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]");
    add_srs_wkt (p, 5,
        "],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 6,
        "\"9122\"]],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"La");
    add_srs_wkt (p, 7,
        "mbert_Conformal_Conic_1SP\"],PARAMETER[\"latitude_of_ori");
    add_srs_wkt (p, 8,
        "gin\",45.8987148658333],PARAMETER[\"central_meridian\",-");
    add_srs_wkt (p, 9,
        "92.4577777777778],PARAMETER[\"scale_factor\",1.000038384");
    add_srs_wkt (p, 10,
        "1],PARAMETER[\"false_easting\",209999.999],PARAMETER[\"f");
    add_srs_wkt (p, 11,
        "alse_northing\",195032.104],UNIT[\"US survey foot\",0.30");
    add_srs_wkt (p, 12,
        "4800609601219,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"Easti");
    add_srs_wkt (p, 13,
        "ng\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 14,
        "7593\"]]");
    p = add_epsg_def_ex (filter, first, last, 7594, "epsg", 7594,
        "NAD83(2011) / WISCRS Calumet, Fond du Lac, Outagamie and Winnebago (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=42.71944444444445 +lon_0=-88.5 +k=1.0");
    add_proj4text (p, 1,
        "000286569 +x_0=244754.8892049784 +y_0=0.0048768097536195");
    add_proj4text (p, 2,
        "07 +ellps=GRS80 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / WISCRS Calumet, Fond du Lac, Outa");
    add_srs_wkt (p, 1,
        "gamie and Winnebago (ftUS)\",GEOGCS[\"NAD83(2011)\",DATU");
    add_srs_wkt (p, 2,
        "M[\"NAD83_National_Spatial_Reference_System_2011\",SPHER");
    add_srs_wkt (p, 3,
        "OID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 4,
        ",\"7019\"]],AUTHORITY[\"EPSG\",\"1116\"]],PRIMEM[\"Green");
    add_srs_wkt (p, 5,
        "wich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0");
    add_srs_wkt (p, 6,
        ".0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORIT");
    add_srs_wkt (p, 7,
        "Y[\"EPSG\",\"6318\"]],PROJECTION[\"Transverse_Mercator\"");
    add_srs_wkt (p, 8,
        "],PARAMETER[\"latitude_of_origin\",42.7194444444444],PAR");
    add_srs_wkt (p, 9,
        "AMETER[\"central_meridian\",-88.5],PARAMETER[\"scale_fac");
    add_srs_wkt (p, 10,
        "tor\",1.0000286569],PARAMETER[\"false_easting\",802999.9");
    add_srs_wkt (p, 11,
        "99],PARAMETER[\"false_northing\",0.016],UNIT[\"US survey");
    add_srs_wkt (p, 12,
        " foot\",0.304800609601219,AUTHORITY[\"EPSG\",\"9003\"]],");
    add_srs_wkt (p, 13,
        "AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORIT");
    add_srs_wkt (p, 14,
        "Y[\"EPSG\",\"7594\"]]");
    p = add_epsg_def_ex (filter, first, last, 7595, "epsg", 7595,
        "NAD83(2011) / WISCRS Chippewa (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Lambert_Conformal_Conic_1SP", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=44.97785689861112 +lat_0=44.97785689861");
    add_proj4text (p, 1,
        "112 +lon_0=-91.29444444444444 +k_0=1.0000391127 +x_0=600");
    add_proj4text (p, 2,
        "45.72009144018 +y_0=44091.43449326898 +ellps=GRS80 +unit");
    add_proj4text (p, 3,
        "s=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / WISCRS Chippewa (ftUS)\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "NAD83(2011)\",DATUM[\"NAD83_National_Spatial_Reference_S");
    add_srs_wkt (p, 2,
        "ystem_2011\",SPHEROID[\"GRS 1980\",6378137,298.257222101");
    add_srs_wkt (p, 3,
        ",AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116");
    add_srs_wkt (p, 4,
        "\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]");
    add_srs_wkt (p, 5,
        "],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 6,
        "\"9122\"]],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"La");
    add_srs_wkt (p, 7,
        "mbert_Conformal_Conic_1SP\"],PARAMETER[\"latitude_of_ori");
    add_srs_wkt (p, 8,
        "gin\",44.9778568986111],PARAMETER[\"central_meridian\",-");
    add_srs_wkt (p, 9,
        "91.2944444444444],PARAMETER[\"scale_factor\",1.000039112");
    add_srs_wkt (p, 10,
        "7],PARAMETER[\"false_easting\",197000],PARAMETER[\"false");
    add_srs_wkt (p, 11,
        "_northing\",144656.648],UNIT[\"US survey foot\",0.304800");
    add_srs_wkt (p, 12,
        "609601219,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"Easting\"");
    add_srs_wkt (p, 13,
        ",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"759");
    add_srs_wkt (p, 14,
        "5\"]]");
    p = add_epsg_def_ex (filter, first, last, 7596, "epsg", 7596,
        "NAD83(2011) / WISCRS Clark (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=43.6 +lon_0=-90.70833333333334 +k=1.0");
    add_proj4text (p, 1,
        "000463003 +x_0=199949.198983998 +y_0=0.00853441706883413");
    add_proj4text (p, 2,
        "7 +ellps=GRS80 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / WISCRS Clark (ftUS)\",GEOGCS[\"NA");
    add_srs_wkt (p, 1,
        "D83(2011)\",DATUM[\"NAD83_National_Spatial_Reference_Sys");
    add_srs_wkt (p, 2,
        "tem_2011\",SPHEROID[\"GRS 1980\",6378137,298.257222101,A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116\"");
    add_srs_wkt (p, 4,
        "]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],");
    add_srs_wkt (p, 5,
        "UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "9122\"]],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Tran");
    add_srs_wkt (p, 7,
        "sverse_Mercator\"],PARAMETER[\"latitude_of_origin\",43.6");
    add_srs_wkt (p, 8,
        "],PARAMETER[\"central_meridian\",-90.7083333333333],PARA");
    add_srs_wkt (p, 9,
        "METER[\"scale_factor\",1.0000463003],PARAMETER[\"false_e");
    add_srs_wkt (p, 10,
        "asting\",655999.997],PARAMETER[\"false_northing\",0.028]");
    add_srs_wkt (p, 11,
        ",UNIT[\"US survey foot\",0.304800609601219,AUTHORITY[\"E");
    add_srs_wkt (p, 12,
        "PSG\",\"9003\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\"");
    add_srs_wkt (p, 13,
        ",NORTH],AUTHORITY[\"EPSG\",\"7596\"]]");
    p = add_epsg_def_ex (filter, first, last, 7597, "epsg", 7597,
        "NAD83(2011) / WISCRS Columbia (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Lambert_Conformal_Conic_1SP", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=43.46254664583333 +lat_0=43.46254664583");
    add_proj4text (p, 1,
        "333 +lon_0=-89.39444444444445 +k_0=1.00003498 +x_0=16916");
    add_proj4text (p, 2,
        "4.338023876 +y_0=111569.613512827 +ellps=GRS80 +units=us");
    add_proj4text (p, 3,
        "-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / WISCRS Columbia (ftUS)\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "NAD83(2011)\",DATUM[\"NAD83_National_Spatial_Reference_S");
    add_srs_wkt (p, 2,
        "ystem_2011\",SPHEROID[\"GRS 1980\",6378137,298.257222101");
    add_srs_wkt (p, 3,
        ",AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116");
    add_srs_wkt (p, 4,
        "\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]");
    add_srs_wkt (p, 5,
        "],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 6,
        "\"9122\"]],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"La");
    add_srs_wkt (p, 7,
        "mbert_Conformal_Conic_1SP\"],PARAMETER[\"latitude_of_ori");
    add_srs_wkt (p, 8,
        "gin\",43.4625466458333],PARAMETER[\"central_meridian\",-");
    add_srs_wkt (p, 9,
        "89.3944444444444],PARAMETER[\"scale_factor\",1.00003498]");
    add_srs_wkt (p, 10,
        ",PARAMETER[\"false_easting\",554999.999],PARAMETER[\"fal");
    add_srs_wkt (p, 11,
        "se_northing\",366041.307],UNIT[\"US survey foot\",0.3048");
    add_srs_wkt (p, 12,
        "00609601219,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"Easting");
    add_srs_wkt (p, 13,
        "\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 14,
        "597\"]]");
    p = add_epsg_def_ex (filter, first, last, 7598, "epsg", 7598,
        "NAD83(2011) / WISCRS Crawford (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Lambert_Conformal_Conic_1SP", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=43.200055605 +lat_0=43.200055605 +lon_0");
    add_proj4text (p, 1,
        "=-90.9388888888889 +k_0=1.0000349151 +x_0=113690.6273812");
    add_proj4text (p, 2,
        "548 +y_0=53703.12024384048 +ellps=GRS80 +units=us-ft +no");
    add_proj4text (p, 3,
        "_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / WISCRS Crawford (ftUS)\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "NAD83(2011)\",DATUM[\"NAD83_National_Spatial_Reference_S");
    add_srs_wkt (p, 2,
        "ystem_2011\",SPHEROID[\"GRS 1980\",6378137,298.257222101");
    add_srs_wkt (p, 3,
        ",AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116");
    add_srs_wkt (p, 4,
        "\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]");
    add_srs_wkt (p, 5,
        "],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 6,
        "\"9122\"]],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"La");
    add_srs_wkt (p, 7,
        "mbert_Conformal_Conic_1SP\"],PARAMETER[\"latitude_of_ori");
    add_srs_wkt (p, 8,
        "gin\",43.200055605],PARAMETER[\"central_meridian\",-90.9");
    add_srs_wkt (p, 9,
        "388888888889],PARAMETER[\"scale_factor\",1.0000349151],P");
    add_srs_wkt (p, 10,
        "ARAMETER[\"false_easting\",373000],PARAMETER[\"false_nor");
    add_srs_wkt (p, 11,
        "thing\",176190.987],UNIT[\"US survey foot\",0.3048006096");
    add_srs_wkt (p, 12,
        "01219,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"Easting\",EAS");
    add_srs_wkt (p, 13,
        "T],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"7598\"]");
    add_srs_wkt (p, 14,
        "]");
    p = add_epsg_def_ex (filter, first, last, 7599, "epsg", 7599,
        "NAD83(2011) / WISCRS Dane (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Lambert_Conformal_Conic_1SP", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=43.0695160375 +lat_0=43.0695160375 +lon");
    add_proj4text (p, 1,
        "_0=-89.42222222222223 +k_0=1.0000384786 +x_0=247193.2943");
    add_proj4text (p, 2,
        "865888 +y_0=146591.9896367793 +ellps=GRS80 +units=us-ft ");
    add_proj4text (p, 3,
        "+no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / WISCRS Dane (ftUS)\",GEOGCS[\"NAD");
    add_srs_wkt (p, 1,
        "83(2011)\",DATUM[\"NAD83_National_Spatial_Reference_Syst");
    add_srs_wkt (p, 2,
        "em_2011\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AU");
    add_srs_wkt (p, 3,
        "THORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116\"]");
    add_srs_wkt (p, 4,
        "],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],U");
    add_srs_wkt (p, 5,
        "NIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9");
    add_srs_wkt (p, 6,
        "122\"]],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Lambe");
    add_srs_wkt (p, 7,
        "rt_Conformal_Conic_1SP\"],PARAMETER[\"latitude_of_origin");
    add_srs_wkt (p, 8,
        "\",43.0695160375],PARAMETER[\"central_meridian\",-89.422");
    add_srs_wkt (p, 9,
        "2222222222],PARAMETER[\"scale_factor\",1.0000384786],PAR");
    add_srs_wkt (p, 10,
        "AMETER[\"false_easting\",811000],PARAMETER[\"false_north");
    add_srs_wkt (p, 11,
        "ing\",480943.886],UNIT[\"US survey foot\",0.304800609601");
    add_srs_wkt (p, 12,
        "219,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"Easting\",EAST]");
    add_srs_wkt (p, 13,
        ",AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"7599\"]]");
    p = add_epsg_def_ex (filter, first, last, 7600, "epsg", 7600,
        "NAD83(2011) / WISCRS Dodge and Jefferson (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=41.47222222222222 +lon_0=-88.77500000");
    add_proj4text (p, 1,
        "000001 +k=1.0000346418 +x_0=263347.7263906528 +y_0=0.007");
    add_proj4text (p, 2,
        "62001524003048 +ellps=GRS80 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / WISCRS Dodge and Jefferson (ftUS)");
    add_srs_wkt (p, 1,
        "\",GEOGCS[\"NAD83(2011)\",DATUM[\"NAD83_National_Spatial");
    add_srs_wkt (p, 2,
        "_Reference_System_2011\",SPHEROID[\"GRS 1980\",6378137,2");
    add_srs_wkt (p, 3,
        "98.257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"E");
    add_srs_wkt (p, 4,
        "PSG\",\"1116\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 5,
        "\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORI");
    add_srs_wkt (p, 6,
        "TY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"6318\"]],PRO");
    add_srs_wkt (p, 7,
        "JECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of");
    add_srs_wkt (p, 8,
        "_origin\",41.4722222222222],PARAMETER[\"central_meridian");
    add_srs_wkt (p, 9,
        "\",-88.775],PARAMETER[\"scale_factor\",1.0000346418],PAR");
    add_srs_wkt (p, 10,
        "AMETER[\"false_easting\",863999.999],PARAMETER[\"false_n");
    add_srs_wkt (p, 11,
        "orthing\",0.025],UNIT[\"US survey foot\",0.3048006096012");
    add_srs_wkt (p, 12,
        "19,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"Easting\",EAST],");
    add_srs_wkt (p, 13,
        "AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"7600\"]]");
    p = add_epsg_def_ex (filter, first, last, 7601, "epsg", 7601,
        "NAD83(2011) / WISCRS Door (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=44.4 +lon_0=-87.27222222222223 +k=1.0");
    add_proj4text (p, 1,
        "000187521 +x_0=158801.1176022352 +y_0=0.0024384048768097");
    add_proj4text (p, 2,
        "54 +ellps=GRS80 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / WISCRS Door (ftUS)\",GEOGCS[\"NAD");
    add_srs_wkt (p, 1,
        "83(2011)\",DATUM[\"NAD83_National_Spatial_Reference_Syst");
    add_srs_wkt (p, 2,
        "em_2011\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AU");
    add_srs_wkt (p, 3,
        "THORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116\"]");
    add_srs_wkt (p, 4,
        "],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],U");
    add_srs_wkt (p, 5,
        "NIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9");
    add_srs_wkt (p, 6,
        "122\"]],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Trans");
    add_srs_wkt (p, 7,
        "verse_Mercator\"],PARAMETER[\"latitude_of_origin\",44.4]");
    add_srs_wkt (p, 8,
        ",PARAMETER[\"central_meridian\",-87.2722222222222],PARAM");
    add_srs_wkt (p, 9,
        "ETER[\"scale_factor\",1.0000187521],PARAMETER[\"false_ea");
    add_srs_wkt (p, 10,
        "sting\",521000],PARAMETER[\"false_northing\",0.008],UNIT");
    add_srs_wkt (p, 11,
        "[\"US survey foot\",0.304800609601219,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 12,
        ",\"9003\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NOR");
    add_srs_wkt (p, 13,
        "TH],AUTHORITY[\"EPSG\",\"7601\"]]");
    p = add_epsg_def_ex (filter, first, last, 7602, "epsg", 7602,
        "NAD83(2011) / WISCRS Douglas (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=45.88333333333333 +lon_0=-91.91666666");
    add_proj4text (p, 1,
        "666667 +k=1.0000385418 +x_0=59131.31826263652 +y_0=0.003");
    add_proj4text (p, 2,
        "962407924815849 +ellps=GRS80 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / WISCRS Douglas (ftUS)\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "NAD83(2011)\",DATUM[\"NAD83_National_Spatial_Reference_S");
    add_srs_wkt (p, 2,
        "ystem_2011\",SPHEROID[\"GRS 1980\",6378137,298.257222101");
    add_srs_wkt (p, 3,
        ",AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116");
    add_srs_wkt (p, 4,
        "\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]");
    add_srs_wkt (p, 5,
        "],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 6,
        "\"9122\"]],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Tr");
    add_srs_wkt (p, 7,
        "ansverse_Mercator\"],PARAMETER[\"latitude_of_origin\",45");
    add_srs_wkt (p, 8,
        ".8833333333333],PARAMETER[\"central_meridian\",-91.91666");
    add_srs_wkt (p, 9,
        "66666667],PARAMETER[\"scale_factor\",1.0000385418],PARAM");
    add_srs_wkt (p, 10,
        "ETER[\"false_easting\",194000],PARAMETER[\"false_northin");
    add_srs_wkt (p, 11,
        "g\",0.013],UNIT[\"US survey foot\",0.304800609601219,AUT");
    add_srs_wkt (p, 12,
        "HORITY[\"EPSG\",\"9003\"]],AXIS[\"Easting\",EAST],AXIS[\"");
    add_srs_wkt (p, 13,
        "Northing\",NORTH],AUTHORITY[\"EPSG\",\"7602\"]]");
    p = add_epsg_def_ex (filter, first, last, 7603, "epsg", 7603,
        "NAD83(2011) / WISCRS Dunn (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=44.40833333333333 +lon_0=-91.89444444");
    add_proj4text (p, 1,
        "444445 +k=1.0000410324 +x_0=51816.10393700787 +y_0=0.003");
    add_proj4text (p, 2,
        "048006096012192 +ellps=GRS80 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / WISCRS Dunn (ftUS)\",GEOGCS[\"NAD");
    add_srs_wkt (p, 1,
        "83(2011)\",DATUM[\"NAD83_National_Spatial_Reference_Syst");
    add_srs_wkt (p, 2,
        "em_2011\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AU");
    add_srs_wkt (p, 3,
        "THORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116\"]");
    add_srs_wkt (p, 4,
        "],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],U");
    add_srs_wkt (p, 5,
        "NIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9");
    add_srs_wkt (p, 6,
        "122\"]],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Trans");
    add_srs_wkt (p, 7,
        "verse_Mercator\"],PARAMETER[\"latitude_of_origin\",44.40");
    add_srs_wkt (p, 8,
        "83333333333],PARAMETER[\"central_meridian\",-91.89444444");
    add_srs_wkt (p, 9,
        "44444],PARAMETER[\"scale_factor\",1.0000410324],PARAMETE");
    add_srs_wkt (p, 10,
        "R[\"false_easting\",170000.001],PARAMETER[\"false_northi");
    add_srs_wkt (p, 11,
        "ng\",0.01],UNIT[\"US survey foot\",0.304800609601219,AUT");
    add_srs_wkt (p, 12,
        "HORITY[\"EPSG\",\"9003\"]],AXIS[\"Easting\",EAST],AXIS[\"");
    add_srs_wkt (p, 13,
        "Northing\",NORTH],AUTHORITY[\"EPSG\",\"7603\"]]");
    p = add_epsg_def_ex (filter, first, last, 7604, "epsg", 7604,
        "NAD83(2011) / WISCRS Eau Claire (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Lambert_Conformal_Conic_1SP", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=44.87228112638889 +lat_0=44.87228112638");
    add_proj4text (p, 1,
        "889 +lon_0=-91.28888888888889 +k_0=1.000035079 +x_0=1200");
    add_proj4text (p, 2,
        "91.4401828804 +y_0=91687.92390144781 +ellps=GRS80 +units");
    add_proj4text (p, 3,
        "=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / WISCRS Eau Claire (ftUS)\",GEOGCS");
    add_srs_wkt (p, 1,
        "[\"NAD83(2011)\",DATUM[\"NAD83_National_Spatial_Referenc");
    add_srs_wkt (p, 2,
        "e_System_2011\",SPHEROID[\"GRS 1980\",6378137,298.257222");
    add_srs_wkt (p, 3,
        "101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1");
    add_srs_wkt (p, 4,
        "116\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901");
    add_srs_wkt (p, 5,
        "\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 6,
        "\",\"9122\"]],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"");
    add_srs_wkt (p, 7,
        "Lambert_Conformal_Conic_1SP\"],PARAMETER[\"latitude_of_o");
    add_srs_wkt (p, 8,
        "rigin\",44.8722811263889],PARAMETER[\"central_meridian\"");
    add_srs_wkt (p, 9,
        ",-91.2888888888889],PARAMETER[\"scale_factor\",1.0000350");
    add_srs_wkt (p, 10,
        "79],PARAMETER[\"false_easting\",394000],PARAMETER[\"fals");
    add_srs_wkt (p, 11,
        "e_northing\",300812.797],UNIT[\"US survey foot\",0.30480");
    add_srs_wkt (p, 12,
        "0609601219,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"Easting\"");
    add_srs_wkt (p, 13,
        ",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"760");
    add_srs_wkt (p, 14,
        "4\"]]");
    p = add_epsg_def_ex (filter, first, last, 7605, "epsg", 7605,
        "NAD83(2011) / WISCRS Florence (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=45.43888888888888 +lon_0=-88.14166666");
    add_proj4text (p, 1,
        "666668 +k=1.0000552095 +x_0=133502.6682245364 +y_0=0.006");
    add_proj4text (p, 2,
        "400812801625603 +ellps=GRS80 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / WISCRS Florence (ftUS)\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "NAD83(2011)\",DATUM[\"NAD83_National_Spatial_Reference_S");
    add_srs_wkt (p, 2,
        "ystem_2011\",SPHEROID[\"GRS 1980\",6378137,298.257222101");
    add_srs_wkt (p, 3,
        ",AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116");
    add_srs_wkt (p, 4,
        "\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]");
    add_srs_wkt (p, 5,
        "],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 6,
        "\"9122\"]],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Tr");
    add_srs_wkt (p, 7,
        "ansverse_Mercator\"],PARAMETER[\"latitude_of_origin\",45");
    add_srs_wkt (p, 8,
        ".4388888888889],PARAMETER[\"central_meridian\",-88.14166");
    add_srs_wkt (p, 9,
        "66666667],PARAMETER[\"scale_factor\",1.0000552095],PARAM");
    add_srs_wkt (p, 10,
        "ETER[\"false_easting\",438000.004],PARAMETER[\"false_nor");
    add_srs_wkt (p, 11,
        "thing\",0.021],UNIT[\"US survey foot\",0.304800609601219");
    add_srs_wkt (p, 12,
        ",AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"Easting\",EAST],AX");
    add_srs_wkt (p, 13,
        "IS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"7605\"]]");
    p = add_epsg_def_ex (filter, first, last, 7606, "epsg", 7606,
        "NAD83(2011) / WISCRS Forest (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=44.00555555555555 +lon_0=-88.63333333");
    add_proj4text (p, 1,
        "333334 +k=1.0000673004 +x_0=275844.5532131065 +y_0=0.015");
    add_proj4text (p, 2,
        "8496316992634 +ellps=GRS80 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / WISCRS Forest (ftUS)\",GEOGCS[\"N");
    add_srs_wkt (p, 1,
        "AD83(2011)\",DATUM[\"NAD83_National_Spatial_Reference_Sy");
    add_srs_wkt (p, 2,
        "stem_2011\",SPHEROID[\"GRS 1980\",6378137,298.257222101,");
    add_srs_wkt (p, 3,
        "AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116\"");
    add_srs_wkt (p, 4,
        "]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],");
    add_srs_wkt (p, 5,
        "UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "9122\"]],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Tran");
    add_srs_wkt (p, 7,
        "sverse_Mercator\"],PARAMETER[\"latitude_of_origin\",44.0");
    add_srs_wkt (p, 8,
        "055555555556],PARAMETER[\"central_meridian\",-88.6333333");
    add_srs_wkt (p, 9,
        "333333],PARAMETER[\"scale_factor\",1.0000673004],PARAMET");
    add_srs_wkt (p, 10,
        "ER[\"false_easting\",905000.005],PARAMETER[\"false_north");
    add_srs_wkt (p, 11,
        "ing\",0.052],UNIT[\"US survey foot\",0.304800609601219,A");
    add_srs_wkt (p, 12,
        "UTHORITY[\"EPSG\",\"9003\"]],AXIS[\"Easting\",EAST],AXIS");
    add_srs_wkt (p, 13,
        "[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"7606\"]]");
    p = add_epsg_def_ex (filter, first, last, 7607, "epsg", 7607,
        "NAD83(2011) / WISCRS Grant (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=41.41111111111111 +lon_0=-90.8 +k=1.0");
    add_proj4text (p, 1,
        "000349452 +x_0=242316.484023368 +y_0=0.01005842011684023");
    add_proj4text (p, 2,
        " +ellps=GRS80 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / WISCRS Grant (ftUS)\",GEOGCS[\"NA");
    add_srs_wkt (p, 1,
        "D83(2011)\",DATUM[\"NAD83_National_Spatial_Reference_Sys");
    add_srs_wkt (p, 2,
        "tem_2011\",SPHEROID[\"GRS 1980\",6378137,298.257222101,A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116\"");
    add_srs_wkt (p, 4,
        "]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],");
    add_srs_wkt (p, 5,
        "UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "9122\"]],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Tran");
    add_srs_wkt (p, 7,
        "sverse_Mercator\"],PARAMETER[\"latitude_of_origin\",41.4");
    add_srs_wkt (p, 8,
        "111111111111],PARAMETER[\"central_meridian\",-90.8],PARA");
    add_srs_wkt (p, 9,
        "METER[\"scale_factor\",1.0000349452],PARAMETER[\"false_e");
    add_srs_wkt (p, 10,
        "asting\",794999.998],PARAMETER[\"false_northing\",0.033]");
    add_srs_wkt (p, 11,
        ",UNIT[\"US survey foot\",0.304800609601219,AUTHORITY[\"E");
    add_srs_wkt (p, 12,
        "PSG\",\"9003\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\"");
    add_srs_wkt (p, 13,
        ",NORTH],AUTHORITY[\"EPSG\",\"7607\"]]");
    p = add_epsg_def_ex (filter, first, last, 7608, "epsg", 7608,
        "NAD83(2011) / WISCRS Green and Lafayette (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Lambert_Conformal_Conic_1SP", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=42.63756227694444 +lat_0=42.63756227694");
    add_proj4text (p, 1,
        "444 +lon_0=-89.83888888888889 +k_0=1.0000390487 +x_0=170");
    add_proj4text (p, 2,
        "078.7401574803 +y_0=45830.29484378968 +ellps=GRS80 +unit");
    add_proj4text (p, 3,
        "s=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / WISCRS Green and Lafayette (ftUS)");
    add_srs_wkt (p, 1,
        "\",GEOGCS[\"NAD83(2011)\",DATUM[\"NAD83_National_Spatial");
    add_srs_wkt (p, 2,
        "_Reference_System_2011\",SPHEROID[\"GRS 1980\",6378137,2");
    add_srs_wkt (p, 3,
        "98.257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"E");
    add_srs_wkt (p, 4,
        "PSG\",\"1116\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 5,
        "\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORI");
    add_srs_wkt (p, 6,
        "TY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"6318\"]],PRO");
    add_srs_wkt (p, 7,
        "JECTION[\"Lambert_Conformal_Conic_1SP\"],PARAMETER[\"lat");
    add_srs_wkt (p, 8,
        "itude_of_origin\",42.6375622769444],PARAMETER[\"central_");
    add_srs_wkt (p, 9,
        "meridian\",-89.8388888888889],PARAMETER[\"scale_factor\"");
    add_srs_wkt (p, 10,
        ",1.0000390487],PARAMETER[\"false_easting\",558000],PARAM");
    add_srs_wkt (p, 11,
        "ETER[\"false_northing\",150361.559],UNIT[\"US survey foo");
    add_srs_wkt (p, 12,
        "t\",0.304800609601219,AUTHORITY[\"EPSG\",\"9003\"]],AXIS");
    add_srs_wkt (p, 13,
        "[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"");
    add_srs_wkt (p, 14,
        "EPSG\",\"7608\"]]");
    p = add_epsg_def_ex (filter, first, last, 7609, "epsg", 7609,
        "NAD83(2011) / WISCRS Green Lake and Marquette (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Lambert_Conformal_Conic_1SP", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=43.80700011777778 +lat_0=43.80700011777");
    add_proj4text (p, 1,
        "778 +lon_0=-89.24166666666667 +k_0=1.0000344057 +x_0=150");
    add_proj4text (p, 2,
        "876.3017526035 +y_0=79170.77937515875 +ellps=GRS80 +unit");
    add_proj4text (p, 3,
        "s=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / WISCRS Green Lake and Marquette (");
    add_srs_wkt (p, 1,
        "ftUS)\",GEOGCS[\"NAD83(2011)\",DATUM[\"NAD83_National_Sp");
    add_srs_wkt (p, 2,
        "atial_Reference_System_2011\",SPHEROID[\"GRS 1980\",6378");
    add_srs_wkt (p, 3,
        "137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORIT");
    add_srs_wkt (p, 4,
        "Y[\"EPSG\",\"1116\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"");
    add_srs_wkt (p, 5,
        "EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"6318\"]]");
    add_srs_wkt (p, 7,
        ",PROJECTION[\"Lambert_Conformal_Conic_1SP\"],PARAMETER[\"");
    add_srs_wkt (p, 8,
        "latitude_of_origin\",43.8070001177778],PARAMETER[\"centr");
    add_srs_wkt (p, 9,
        "al_meridian\",-89.2416666666667],PARAMETER[\"scale_facto");
    add_srs_wkt (p, 10,
        "r\",1.0000344057],PARAMETER[\"false_easting\",495000],PA");
    add_srs_wkt (p, 11,
        "RAMETER[\"false_northing\",259746.132],UNIT[\"US survey ");
    add_srs_wkt (p, 12,
        "foot\",0.304800609601219,AUTHORITY[\"EPSG\",\"9003\"]],A");
    add_srs_wkt (p, 13,
        "XIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY");
    add_srs_wkt (p, 14,
        "[\"EPSG\",\"7609\"]]");
    p = add_epsg_def_ex (filter, first, last, 7610, "epsg", 7610,
        "NAD83(2011) / WISCRS Iowa (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=42.53888888888888 +lon_0=-90.16111111");
    add_proj4text (p, 1,
        "111111 +k=1.0000394961 +x_0=113081.0261620523 +y_0=0.004");
    add_proj4text (p, 2,
        "572009144018288 +ellps=GRS80 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / WISCRS Iowa (ftUS)\",GEOGCS[\"NAD");
    add_srs_wkt (p, 1,
        "83(2011)\",DATUM[\"NAD83_National_Spatial_Reference_Syst");
    add_srs_wkt (p, 2,
        "em_2011\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AU");
    add_srs_wkt (p, 3,
        "THORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116\"]");
    add_srs_wkt (p, 4,
        "],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],U");
    add_srs_wkt (p, 5,
        "NIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9");
    add_srs_wkt (p, 6,
        "122\"]],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Trans");
    add_srs_wkt (p, 7,
        "verse_Mercator\"],PARAMETER[\"latitude_of_origin\",42.53");
    add_srs_wkt (p, 8,
        "88888888889],PARAMETER[\"central_meridian\",-90.16111111");
    add_srs_wkt (p, 9,
        "11111],PARAMETER[\"scale_factor\",1.0000394961],PARAMETE");
    add_srs_wkt (p, 10,
        "R[\"false_easting\",371000],PARAMETER[\"false_northing\"");
    add_srs_wkt (p, 11,
        ",0.015],UNIT[\"US survey foot\",0.304800609601219,AUTHOR");
    add_srs_wkt (p, 12,
        "ITY[\"EPSG\",\"9003\"]],AXIS[\"Easting\",EAST],AXIS[\"No");
    add_srs_wkt (p, 13,
        "rthing\",NORTH],AUTHORITY[\"EPSG\",\"7610\"]]");
    p = add_epsg_def_ex (filter, first, last, 7611, "epsg", 7611,
        "NAD83(2011) / WISCRS Iron (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=45.43333333333333 +lon_0=-90.25555555");
    add_proj4text (p, 1,
        "555556 +k=1.0000677153 +x_0=220980.4419608839 +y_0=0.008");
    add_proj4text (p, 2,
        "534417068834137 +ellps=GRS80 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / WISCRS Iron (ftUS)\",GEOGCS[\"NAD");
    add_srs_wkt (p, 1,
        "83(2011)\",DATUM[\"NAD83_National_Spatial_Reference_Syst");
    add_srs_wkt (p, 2,
        "em_2011\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AU");
    add_srs_wkt (p, 3,
        "THORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116\"]");
    add_srs_wkt (p, 4,
        "],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],U");
    add_srs_wkt (p, 5,
        "NIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9");
    add_srs_wkt (p, 6,
        "122\"]],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Trans");
    add_srs_wkt (p, 7,
        "verse_Mercator\"],PARAMETER[\"latitude_of_origin\",45.43");
    add_srs_wkt (p, 8,
        "33333333333],PARAMETER[\"central_meridian\",-90.25555555");
    add_srs_wkt (p, 9,
        "55556],PARAMETER[\"scale_factor\",1.0000677153],PARAMETE");
    add_srs_wkt (p, 10,
        "R[\"false_easting\",725000],PARAMETER[\"false_northing\"");
    add_srs_wkt (p, 11,
        ",0.028],UNIT[\"US survey foot\",0.304800609601219,AUTHOR");
    add_srs_wkt (p, 12,
        "ITY[\"EPSG\",\"9003\"]],AXIS[\"Easting\",EAST],AXIS[\"No");
    add_srs_wkt (p, 13,
        "rthing\",NORTH],AUTHORITY[\"EPSG\",\"7611\"]]");
    p = add_epsg_def_ex (filter, first, last, 7612, "epsg", 7612,
        "NAD83(2011) / WISCRS Jackson (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=44.25333512777778 +lon_0=-90.84429651");
    add_proj4text (p, 1,
        "944444 +k=1.0000353 +x_0=27000 +y_0=24999.99989839979 +e");
    add_proj4text (p, 2,
        "llps=GRS80 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / WISCRS Jackson (ftUS)\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "NAD83(2011)\",DATUM[\"NAD83_National_Spatial_Reference_S");
    add_srs_wkt (p, 2,
        "ystem_2011\",SPHEROID[\"GRS 1980\",6378137,298.257222101");
    add_srs_wkt (p, 3,
        ",AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116");
    add_srs_wkt (p, 4,
        "\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]");
    add_srs_wkt (p, 5,
        "],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 6,
        "\"9122\"]],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Tr");
    add_srs_wkt (p, 7,
        "ansverse_Mercator\"],PARAMETER[\"latitude_of_origin\",44");
    add_srs_wkt (p, 8,
        ".2533351277778],PARAMETER[\"central_meridian\",-90.84429");
    add_srs_wkt (p, 9,
        "65194444],PARAMETER[\"scale_factor\",1.0000353],PARAMETE");
    add_srs_wkt (p, 10,
        "R[\"false_easting\",88582.5],PARAMETER[\"false_northing\"");
    add_srs_wkt (p, 11,
        ",82020.833],UNIT[\"US survey foot\",0.304800609601219,AU");
    add_srs_wkt (p, 12,
        "THORITY[\"EPSG\",\"9003\"]],AXIS[\"Easting\",EAST],AXIS[");
    add_srs_wkt (p, 13,
        "\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"7612\"]]");
    p = add_epsg_def_ex (filter, first, last, 7613, "epsg", 7613,
        "NAD83(2011) / WISCRS Kenosha, Milwaukee, Ozaukee and Racine (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=42.21666666666667 +lon_0=-87.89444444");
    add_proj4text (p, 1,
        "444445 +k=1.0000260649 +x_0=185928.3727711455 +y_0=0.000");
    add_proj4text (p, 2,
        "9144018288036576 +ellps=GRS80 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / WISCRS Kenosha, Milwaukee, Ozauke");
    add_srs_wkt (p, 1,
        "e and Racine (ftUS)\",GEOGCS[\"NAD83(2011)\",DATUM[\"NAD");
    add_srs_wkt (p, 2,
        "83_National_Spatial_Reference_System_2011\",SPHEROID[\"G");
    add_srs_wkt (p, 3,
        "RS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"701");
    add_srs_wkt (p, 4,
        "9\"]],AUTHORITY[\"EPSG\",\"1116\"]],PRIMEM[\"Greenwich\"");
    add_srs_wkt (p, 5,
        ",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745");
    add_srs_wkt (p, 6,
        "32925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EP");
    add_srs_wkt (p, 7,
        "SG\",\"6318\"]],PROJECTION[\"Transverse_Mercator\"],PARA");
    add_srs_wkt (p, 8,
        "METER[\"latitude_of_origin\",42.2166666666667],PARAMETER");
    add_srs_wkt (p, 9,
        "[\"central_meridian\",-87.8944444444444],PARAMETER[\"sca");
    add_srs_wkt (p, 10,
        "le_factor\",1.0000260649],PARAMETER[\"false_easting\",61");
    add_srs_wkt (p, 11,
        "0000.003],PARAMETER[\"false_northing\",0.003],UNIT[\"US ");
    add_srs_wkt (p, 12,
        "survey foot\",0.304800609601219,AUTHORITY[\"EPSG\",\"900");
    add_srs_wkt (p, 13,
        "3\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AU");
    add_srs_wkt (p, 14,
        "THORITY[\"EPSG\",\"7613\"]]");
    p = add_epsg_def_ex (filter, first, last, 7614, "epsg", 7614,
        "NAD83(2011) / WISCRS Kewaunee, Manitowoc and Sheboygan (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=43.26666666666667 +lon_0=-87.55 +k=1.");
    add_proj4text (p, 1,
        "0000233704 +x_0=79857.76154432308 +y_0=0.001219202438404");
    add_proj4text (p, 2,
        "877 +ellps=GRS80 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / WISCRS Kewaunee, Manitowoc and Sh");
    add_srs_wkt (p, 1,
        "eboygan (ftUS)\",GEOGCS[\"NAD83(2011)\",DATUM[\"NAD83_Na");
    add_srs_wkt (p, 2,
        "tional_Spatial_Reference_System_2011\",SPHEROID[\"GRS 19");
    add_srs_wkt (p, 3,
        "80\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]]");
    add_srs_wkt (p, 4,
        ",AUTHORITY[\"EPSG\",\"1116\"]],PRIMEM[\"Greenwich\",0,AU");
    add_srs_wkt (p, 5,
        "THORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925");
    add_srs_wkt (p, 6,
        "199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 7,
        "\"6318\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER");
    add_srs_wkt (p, 8,
        "[\"latitude_of_origin\",43.2666666666667],PARAMETER[\"ce");
    add_srs_wkt (p, 9,
        "ntral_meridian\",-87.55],PARAMETER[\"scale_factor\",1.00");
    add_srs_wkt (p, 10,
        "00233704],PARAMETER[\"false_easting\",262000.006],PARAME");
    add_srs_wkt (p, 11,
        "TER[\"false_northing\",0.004],UNIT[\"US survey foot\",0.");
    add_srs_wkt (p, 12,
        "304800609601219,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"Eas");
    add_srs_wkt (p, 13,
        "ting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 14,
        ",\"7614\"]]");
    p = add_epsg_def_ex (filter, first, last, 7615, "epsg", 7615,
        "NAD83(2011) / WISCRS La Crosse (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=43.45111111111111 +lon_0=-91.31666666");
    add_proj4text (p, 1,
        "666666 +k=1.0000319985 +x_0=130454.6596901194 +y_0=0.003");
    add_proj4text (p, 2,
        "352806705613411 +ellps=GRS80 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / WISCRS La Crosse (ftUS)\",GEOGCS[");
    add_srs_wkt (p, 1,
        "\"NAD83(2011)\",DATUM[\"NAD83_National_Spatial_Reference");
    add_srs_wkt (p, 2,
        "_System_2011\",SPHEROID[\"GRS 1980\",6378137,298.2572221");
    add_srs_wkt (p, 3,
        "01,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"11");
    add_srs_wkt (p, 4,
        "16\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"");
    add_srs_wkt (p, 5,
        "]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"9122\"]],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"T");
    add_srs_wkt (p, 7,
        "ransverse_Mercator\"],PARAMETER[\"latitude_of_origin\",4");
    add_srs_wkt (p, 8,
        "3.4511111111111],PARAMETER[\"central_meridian\",-91.3166");
    add_srs_wkt (p, 9,
        "666666667],PARAMETER[\"scale_factor\",1.0000319985],PARA");
    add_srs_wkt (p, 10,
        "METER[\"false_easting\",427999.996],PARAMETER[\"false_no");
    add_srs_wkt (p, 11,
        "rthing\",0.011],UNIT[\"US survey foot\",0.30480060960121");
    add_srs_wkt (p, 12,
        "9,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"Easting\",EAST],A");
    add_srs_wkt (p, 13,
        "XIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"7615\"]]");
    p = add_epsg_def_ex (filter, first, last, 7616, "epsg", 7616,
        "NAD83(2011) / WISCRS Langlade (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Lambert_Conformal_Conic_1SP", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=45.15423710527778 +lat_0=45.15423710527");
    add_proj4text (p, 1,
        "778 +lon_0=-89.03333333333333 +k_0=1.0000627024 +x_0=198");
    add_proj4text (p, 2,
        "425.1968503937 +y_0=105279.7828803657 +ellps=GRS80 +unit");
    add_proj4text (p, 3,
        "s=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / WISCRS Langlade (ftUS)\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "NAD83(2011)\",DATUM[\"NAD83_National_Spatial_Reference_S");
    add_srs_wkt (p, 2,
        "ystem_2011\",SPHEROID[\"GRS 1980\",6378137,298.257222101");
    add_srs_wkt (p, 3,
        ",AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116");
    add_srs_wkt (p, 4,
        "\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]");
    add_srs_wkt (p, 5,
        "],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 6,
        "\"9122\"]],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"La");
    add_srs_wkt (p, 7,
        "mbert_Conformal_Conic_1SP\"],PARAMETER[\"latitude_of_ori");
    add_srs_wkt (p, 8,
        "gin\",45.1542371052778],PARAMETER[\"central_meridian\",-");
    add_srs_wkt (p, 9,
        "89.0333333333333],PARAMETER[\"scale_factor\",1.000062702");
    add_srs_wkt (p, 10,
        "4],PARAMETER[\"false_easting\",651000],PARAMETER[\"false");
    add_srs_wkt (p, 11,
        "_northing\",345405.421],UNIT[\"US survey foot\",0.304800");
    add_srs_wkt (p, 12,
        "609601219,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"Easting\"");
    add_srs_wkt (p, 13,
        ",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"761");
    add_srs_wkt (p, 14,
        "6\"]]");
    p = add_epsg_def_ex (filter, first, last, 7617, "epsg", 7617,
        "NAD83(2011) / WISCRS Lincoln (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=44.84444444444445 +lon_0=-89.73333333");
    add_proj4text (p, 1,
        "333333 +k=1.0000599003 +x_0=116129.0322580645 +y_0=0.005");
    add_proj4text (p, 2,
        "791211582423164 +ellps=GRS80 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / WISCRS Lincoln (ftUS)\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "NAD83(2011)\",DATUM[\"NAD83_National_Spatial_Reference_S");
    add_srs_wkt (p, 2,
        "ystem_2011\",SPHEROID[\"GRS 1980\",6378137,298.257222101");
    add_srs_wkt (p, 3,
        ",AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116");
    add_srs_wkt (p, 4,
        "\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]");
    add_srs_wkt (p, 5,
        "],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 6,
        "\"9122\"]],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Tr");
    add_srs_wkt (p, 7,
        "ansverse_Mercator\"],PARAMETER[\"latitude_of_origin\",44");
    add_srs_wkt (p, 8,
        ".8444444444444],PARAMETER[\"central_meridian\",-89.73333");
    add_srs_wkt (p, 9,
        "33333333],PARAMETER[\"scale_factor\",1.0000599003],PARAM");
    add_srs_wkt (p, 10,
        "ETER[\"false_easting\",381000],PARAMETER[\"false_northin");
    add_srs_wkt (p, 11,
        "g\",0.019],UNIT[\"US survey foot\",0.304800609601219,AUT");
    add_srs_wkt (p, 12,
        "HORITY[\"EPSG\",\"9003\"]],AXIS[\"Easting\",EAST],AXIS[\"");
    add_srs_wkt (p, 13,
        "Northing\",NORTH],AUTHORITY[\"EPSG\",\"7617\"]]");
    p = add_epsg_def_ex (filter, first, last, 7618, "epsg", 7618,
        "NAD83(2011) / WISCRS Marathon (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Lambert_Conformal_Conic_1SP", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=44.90090442361111 +lat_0=44.90090442361");
    add_proj4text (p, 1,
        "111 +lon_0=-89.77 +k_0=1.000053289 +x_0=74676.1493522987");
    add_proj4text (p, 2,
        " +y_0=55049.26695453391 +ellps=GRS80 +units=us-ft +no_de");
    add_proj4text (p, 3,
        "fs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / WISCRS Marathon (ftUS)\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "NAD83(2011)\",DATUM[\"NAD83_National_Spatial_Reference_S");
    add_srs_wkt (p, 2,
        "ystem_2011\",SPHEROID[\"GRS 1980\",6378137,298.257222101");
    add_srs_wkt (p, 3,
        ",AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116");
    add_srs_wkt (p, 4,
        "\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]");
    add_srs_wkt (p, 5,
        "],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 6,
        "\"9122\"]],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"La");
    add_srs_wkt (p, 7,
        "mbert_Conformal_Conic_1SP\"],PARAMETER[\"latitude_of_ori");
    add_srs_wkt (p, 8,
        "gin\",44.9009044236111],PARAMETER[\"central_meridian\",-");
    add_srs_wkt (p, 9,
        "89.77],PARAMETER[\"scale_factor\",1.000053289],PARAMETER");
    add_srs_wkt (p, 10,
        "[\"false_easting\",245000],PARAMETER[\"false_northing\",");
    add_srs_wkt (p, 11,
        "180607.47],UNIT[\"US survey foot\",0.304800609601219,AUT");
    add_srs_wkt (p, 12,
        "HORITY[\"EPSG\",\"9003\"]],AXIS[\"Easting\",EAST],AXIS[\"");
    add_srs_wkt (p, 13,
        "Northing\",NORTH],AUTHORITY[\"EPSG\",\"7618\"]]");
    p = add_epsg_def_ex (filter, first, last, 7619, "epsg", 7619,
        "NAD83(2011) / WISCRS Marinette (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=44.69166666666666 +lon_0=-87.71111111");
    add_proj4text (p, 1,
        "111111 +k=1.0000234982 +x_0=238658.8794513589 +y_0=0.003");
    add_proj4text (p, 2,
        "048006096012192 +ellps=GRS80 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / WISCRS Marinette (ftUS)\",GEOGCS[");
    add_srs_wkt (p, 1,
        "\"NAD83(2011)\",DATUM[\"NAD83_National_Spatial_Reference");
    add_srs_wkt (p, 2,
        "_System_2011\",SPHEROID[\"GRS 1980\",6378137,298.2572221");
    add_srs_wkt (p, 3,
        "01,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"11");
    add_srs_wkt (p, 4,
        "16\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"");
    add_srs_wkt (p, 5,
        "]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"9122\"]],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"T");
    add_srs_wkt (p, 7,
        "ransverse_Mercator\"],PARAMETER[\"latitude_of_origin\",4");
    add_srs_wkt (p, 8,
        "4.6916666666667],PARAMETER[\"central_meridian\",-87.7111");
    add_srs_wkt (p, 9,
        "111111111],PARAMETER[\"scale_factor\",1.0000234982],PARA");
    add_srs_wkt (p, 10,
        "METER[\"false_easting\",783000.007],PARAMETER[\"false_no");
    add_srs_wkt (p, 11,
        "rthing\",0.01],UNIT[\"US survey foot\",0.304800609601219");
    add_srs_wkt (p, 12,
        ",AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"Easting\",EAST],AX");
    add_srs_wkt (p, 13,
        "IS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"7619\"]]");
    p = add_epsg_def_ex (filter, first, last, 7620, "epsg", 7620,
        "NAD83(2011) / WISCRS Menominee (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=44.71666666666667 +lon_0=-88.41666666");
    add_proj4text (p, 1,
        "666667 +k=1.0000362499 +x_0=105461.0121412243 +y_0=0.003");
    add_proj4text (p, 2,
        "048006096012192 +ellps=GRS80 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / WISCRS Menominee (ftUS)\",GEOGCS[");
    add_srs_wkt (p, 1,
        "\"NAD83(2011)\",DATUM[\"NAD83_National_Spatial_Reference");
    add_srs_wkt (p, 2,
        "_System_2011\",SPHEROID[\"GRS 1980\",6378137,298.2572221");
    add_srs_wkt (p, 3,
        "01,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"11");
    add_srs_wkt (p, 4,
        "16\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"");
    add_srs_wkt (p, 5,
        "]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"9122\"]],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"T");
    add_srs_wkt (p, 7,
        "ransverse_Mercator\"],PARAMETER[\"latitude_of_origin\",4");
    add_srs_wkt (p, 8,
        "4.7166666666667],PARAMETER[\"central_meridian\",-88.4166");
    add_srs_wkt (p, 9,
        "666666667],PARAMETER[\"scale_factor\",1.0000362499],PARA");
    add_srs_wkt (p, 10,
        "METER[\"false_easting\",346000.004],PARAMETER[\"false_no");
    add_srs_wkt (p, 11,
        "rthing\",0.01],UNIT[\"US survey foot\",0.304800609601219");
    add_srs_wkt (p, 12,
        ",AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"Easting\",EAST],AX");
    add_srs_wkt (p, 13,
        "IS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"7620\"]]");
    p = add_epsg_def_ex (filter, first, last, 7621, "epsg", 7621,
        "NAD83(2011) / WISCRS Monroe (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Lambert_Conformal_Conic_1SP", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=44.00007392861111 +lat_0=44.00007392861");
    add_proj4text (p, 1,
        "111 +lon_0=-90.64166666666668 +k_0=1.0000434122 +x_0=204");
    add_proj4text (p, 2,
        "521.2090424181 +y_0=121923.9861823724 +ellps=GRS80 +unit");
    add_proj4text (p, 3,
        "s=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / WISCRS Monroe (ftUS)\",GEOGCS[\"N");
    add_srs_wkt (p, 1,
        "AD83(2011)\",DATUM[\"NAD83_National_Spatial_Reference_Sy");
    add_srs_wkt (p, 2,
        "stem_2011\",SPHEROID[\"GRS 1980\",6378137,298.257222101,");
    add_srs_wkt (p, 3,
        "AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116\"");
    add_srs_wkt (p, 4,
        "]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],");
    add_srs_wkt (p, 5,
        "UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "9122\"]],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Lamb");
    add_srs_wkt (p, 7,
        "ert_Conformal_Conic_1SP\"],PARAMETER[\"latitude_of_origi");
    add_srs_wkt (p, 8,
        "n\",44.0000739286111],PARAMETER[\"central_meridian\",-90");
    add_srs_wkt (p, 9,
        ".6416666666667],PARAMETER[\"scale_factor\",1.0000434122]");
    add_srs_wkt (p, 10,
        ",PARAMETER[\"false_easting\",671000],PARAMETER[\"false_n");
    add_srs_wkt (p, 11,
        "orthing\",400012.278],UNIT[\"US survey foot\",0.30480060");
    add_srs_wkt (p, 12,
        "9601219,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"Easting\",E");
    add_srs_wkt (p, 13,
        "AST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"7621\"");
    add_srs_wkt (p, 14,
        "]]");
    p = add_epsg_def_ex (filter, first, last, 7622, "epsg", 7622,
        "NAD83(2011) / WISCRS Oconto (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=44.39722222222222 +lon_0=-87.90833333");
    add_proj4text (p, 1,
        "333335 +k=1.0000236869 +x_0=182880.3675895352 +y_0=0.003");
    add_proj4text (p, 2,
        "352806705613411 +ellps=GRS80 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / WISCRS Oconto (ftUS)\",GEOGCS[\"N");
    add_srs_wkt (p, 1,
        "AD83(2011)\",DATUM[\"NAD83_National_Spatial_Reference_Sy");
    add_srs_wkt (p, 2,
        "stem_2011\",SPHEROID[\"GRS 1980\",6378137,298.257222101,");
    add_srs_wkt (p, 3,
        "AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116\"");
    add_srs_wkt (p, 4,
        "]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],");
    add_srs_wkt (p, 5,
        "UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "9122\"]],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Tran");
    add_srs_wkt (p, 7,
        "sverse_Mercator\"],PARAMETER[\"latitude_of_origin\",44.3");
    add_srs_wkt (p, 8,
        "972222222222],PARAMETER[\"central_meridian\",-87.9083333");
    add_srs_wkt (p, 9,
        "333333],PARAMETER[\"scale_factor\",1.0000236869],PARAMET");
    add_srs_wkt (p, 10,
        "ER[\"false_easting\",600000.006],PARAMETER[\"false_north");
    add_srs_wkt (p, 11,
        "ing\",0.011],UNIT[\"US survey foot\",0.304800609601219,A");
    add_srs_wkt (p, 12,
        "UTHORITY[\"EPSG\",\"9003\"]],AXIS[\"Easting\",EAST],AXIS");
    add_srs_wkt (p, 13,
        "[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"7622\"]]");
    p = add_epsg_def_ex (filter, first, last, 7623, "epsg", 7623,
        "NAD83(2011) / WISCRS Oneida (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Lambert_Conformal_Conic_1SP", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=45.70422377027778 +lat_0=45.70422377027");
    add_proj4text (p, 1,
        "778 +lon_0=-89.54444444444444 +k_0=1.0000686968 +x_0=701");
    add_proj4text (p, 2,
        "04.14020828041 +y_0=57588.03474726949 +ellps=GRS80 +unit");
    add_proj4text (p, 3,
        "s=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / WISCRS Oneida (ftUS)\",GEOGCS[\"N");
    add_srs_wkt (p, 1,
        "AD83(2011)\",DATUM[\"NAD83_National_Spatial_Reference_Sy");
    add_srs_wkt (p, 2,
        "stem_2011\",SPHEROID[\"GRS 1980\",6378137,298.257222101,");
    add_srs_wkt (p, 3,
        "AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116\"");
    add_srs_wkt (p, 4,
        "]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],");
    add_srs_wkt (p, 5,
        "UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "9122\"]],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Lamb");
    add_srs_wkt (p, 7,
        "ert_Conformal_Conic_1SP\"],PARAMETER[\"latitude_of_origi");
    add_srs_wkt (p, 8,
        "n\",45.7042237702778],PARAMETER[\"central_meridian\",-89");
    add_srs_wkt (p, 9,
        ".5444444444444],PARAMETER[\"scale_factor\",1.0000686968]");
    add_srs_wkt (p, 10,
        ",PARAMETER[\"false_easting\",230000],PARAMETER[\"false_n");
    add_srs_wkt (p, 11,
        "orthing\",188936.744],UNIT[\"US survey foot\",0.30480060");
    add_srs_wkt (p, 12,
        "9601219,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"Easting\",E");
    add_srs_wkt (p, 13,
        "AST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"7623\"");
    add_srs_wkt (p, 14,
        "]]");
    p = add_epsg_def_ex (filter, first, last, 7624, "epsg", 7624,
        "NAD83(2011) / WISCRS Pepin and Pierce (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Lambert_Conformal_Conic_1SP", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=44.63614887194444 +lat_0=44.63614887194");
    add_proj4text (p, 1,
        "444 +lon_0=-92.22777777777777 +k_0=1.0000362977 +x_0=167");
    add_proj4text (p, 2,
        "640.3352806706 +y_0=86033.08773177546 +ellps=GRS80 +unit");
    add_proj4text (p, 3,
        "s=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / WISCRS Pepin and Pierce (ftUS)\",");
    add_srs_wkt (p, 1,
        "GEOGCS[\"NAD83(2011)\",DATUM[\"NAD83_National_Spatial_Re");
    add_srs_wkt (p, 2,
        "ference_System_2011\",SPHEROID[\"GRS 1980\",6378137,298.");
    add_srs_wkt (p, 3,
        "257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 4,
        "\",\"1116\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 5,
        "\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[");
    add_srs_wkt (p, 6,
        "\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"6318\"]],PROJEC");
    add_srs_wkt (p, 7,
        "TION[\"Lambert_Conformal_Conic_1SP\"],PARAMETER[\"latitu");
    add_srs_wkt (p, 8,
        "de_of_origin\",44.6361488719444],PARAMETER[\"central_mer");
    add_srs_wkt (p, 9,
        "idian\",-92.2277777777778],PARAMETER[\"scale_factor\",1.");
    add_srs_wkt (p, 10,
        "0000362977],PARAMETER[\"false_easting\",550000],PARAMETE");
    add_srs_wkt (p, 11,
        "R[\"false_northing\",282260.222],UNIT[\"US survey foot\"");
    add_srs_wkt (p, 12,
        ",0.304800609601219,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"");
    add_srs_wkt (p, 13,
        "Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPS");
    add_srs_wkt (p, 14,
        "G\",\"7624\"]]");
}

#endif /* full EPSG initialization enabled/disabled */

