/*

 helper function for srs_init.c -- populating the SPATIAL_REF_SYS table

 this code was autogenerated by "auto_epsg_ext" on Tue Jul 14 19:02:34 2020

 Author: Sandro Furieri a.furieri@lqt.it

 -----------------------------------------------------------------------------

 Version: MPL 1.1/GPL 2.0/LGPL 2.1

 The contents of this file are subject to the Mozilla Public License Version
 1.1 (the "License"); you may not use this file except in compliance with
 the License. You may obtain a copy of the License at
 http://www.mozilla.org/MPL/

Software distributed under the License is distributed on an "AS IS" basis,
WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
for the specific language governing rights and limitations under the
License.

The Original Code is the SpatiaLite library

The Initial Developer of the Original Code is Alessandro Furieri

Portions created by the Initial Developer are Copyright (C) 2008
the Initial Developer. All Rights Reserved.

Contributor(s):

Alternatively, the contents of this file may be used under the terms of
either the GNU General Public License Version 2 or later (the "GPL"), or
the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
in which case the provisions of the GPL or the LGPL are applicable instead
of those above. If you wish to allow use of your version of this file only
under the terms of either the GPL or the LGPL, and not to allow others to
use your version of this file under the terms of the MPL, indicate your
decision by deleting the provisions above and replace them with the notice
and other provisions required by the GPL or the LGPL. If you do not delete
the provisions above, a recipient may use your version of this file under
the terms of any one of the MPL, the GPL or the LGPL.

*/

#if defined(_WIN32) && !defined(__MINGW32__)
#include "config-msvc.h"
#else
#include "config.h"
#endif

#include <spatialite_private.h>

#ifndef OMIT_EPSG    /* full EPSG initialization enabled */

SPATIALITE_PRIVATE void
initialize_epsg_26 (int filter, struct epsg_defs **first, struct epsg_defs **last)
{
/* initializing the EPSG defs list */
    struct epsg_defs *p;
    p = add_epsg_def_ex (filter, first, last, 4989, "epsg", 4989,
        "SIRGAS 2000", 1, 1,
        "GRS 1980", "Greenwich",
        "Sistema_de_Referencia_Geocentrico_para_las_AmericaS_2000", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +no_de");
    add_proj4text (p, 1,
        "fs");
    add_srs_wkt (p, 0,
        "GEOGCRS[\"SIRGAS 2000\",DATUM[\"Sistema de Referencia Ge");
    add_srs_wkt (p, 1,
        "ocentrico para las AmericaS 2000\",ELLIPSOID[\"GRS 1980\"");
    add_srs_wkt (p, 2,
        ",6378137,298.257222101,LENGTHUNIT[\"metre\",1]]],PRIMEM[");
    add_srs_wkt (p, 3,
        "\"Greenwich\",0,ANGLEUNIT[\"degree\",0.0174532925199433]");
    add_srs_wkt (p, 4,
        "],CS[ellipsoidal,3],AXIS[\"geodetic latitude (Lat)\",nor");
    add_srs_wkt (p, 5,
        "th,ORDER[1],ANGLEUNIT[\"degree\",0.0174532925199433]],AX");
    add_srs_wkt (p, 6,
        "IS[\"geodetic longitude (Lon)\",east,ORDER[2],ANGLEUNIT[");
    add_srs_wkt (p, 7,
        "\"degree\",0.0174532925199433]],AXIS[\"ellipsoidal heigh");
    add_srs_wkt (p, 8,
        "t (h)\",up,ORDER[3],LENGTHUNIT[\"metre\",1]],USAGE[SCOPE");
    add_srs_wkt (p, 9,
        "[\"unknown\"],AREA[\"Latin America - SIRGAS 2000 by coun");
    add_srs_wkt (p, 10,
        "try\"],BBOX[-59.87,-122.19,32.72,-25.28]],ID[\"EPSG\",49");
    add_srs_wkt (p, 11,
        "89]]");
    p = add_epsg_def_ex (filter, first, last, 4991, "epsg", 4991,
        "Lao 1993", 1, 1,
        "Krassowsky 1940", "Greenwich",
        "Lao_1993", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=krass +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCRS[\"Lao 1993\",DATUM[\"Lao 1993\",ELLIPSOID[\"Kras");
    add_srs_wkt (p, 1,
        "sowsky 1940\",6378245,298.3,LENGTHUNIT[\"metre\",1]]],PR");
    add_srs_wkt (p, 2,
        "IMEM[\"Greenwich\",0,ANGLEUNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 3,
        "9433]],CS[ellipsoidal,3],AXIS[\"geodetic latitude (Lat)\"");
    add_srs_wkt (p, 4,
        ",north,ORDER[1],ANGLEUNIT[\"degree\",0.0174532925199433]");
    add_srs_wkt (p, 5,
        "],AXIS[\"geodetic longitude (Lon)\",east,ORDER[2],ANGLEU");
    add_srs_wkt (p, 6,
        "NIT[\"degree\",0.0174532925199433]],AXIS[\"ellipsoidal h");
    add_srs_wkt (p, 7,
        "eight (h)\",up,ORDER[3],LENGTHUNIT[\"metre\",1]],USAGE[S");
    add_srs_wkt (p, 8,
        "COPE[\"unknown\"],AREA[\"Laos\"],BBOX[13.92,100.09,22.5,");
    add_srs_wkt (p, 9,
        "107.64]],ID[\"EPSG\",4991]]");
    p = add_epsg_def_ex (filter, first, last, 4993, "epsg", 4993,
        "Lao 1997", 1, 1,
        "Krassowsky 1940", "Greenwich",
        "Lao_National_Datum_1997", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=krass +towgs84=44.585,-131.212,-39.");
    add_proj4text (p, 1,
        "544,0,0,0,0 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCRS[\"Lao 1997\",DATUM[\"Lao National Datum 1997\",E");
    add_srs_wkt (p, 1,
        "LLIPSOID[\"Krassowsky 1940\",6378245,298.3,LENGTHUNIT[\"");
    add_srs_wkt (p, 2,
        "metre\",1]]],PRIMEM[\"Greenwich\",0,ANGLEUNIT[\"degree\"");
    add_srs_wkt (p, 3,
        ",0.0174532925199433]],CS[ellipsoidal,3],AXIS[\"geodetic ");
    add_srs_wkt (p, 4,
        "latitude (Lat)\",north,ORDER[1],ANGLEUNIT[\"degree\",0.0");
    add_srs_wkt (p, 5,
        "174532925199433]],AXIS[\"geodetic longitude (Lon)\",east");
    add_srs_wkt (p, 6,
        ",ORDER[2],ANGLEUNIT[\"degree\",0.0174532925199433]],AXIS");
    add_srs_wkt (p, 7,
        "[\"ellipsoidal height (h)\",up,ORDER[3],LENGTHUNIT[\"met");
    add_srs_wkt (p, 8,
        "re\",1]],USAGE[SCOPE[\"unknown\"],AREA[\"Laos\"],BBOX[13");
    add_srs_wkt (p, 9,
        ".92,100.09,22.5,107.64]],ID[\"EPSG\",4993]]");
    p = add_epsg_def_ex (filter, first, last, 4995, "epsg", 4995,
        "PRS92", 1, 1,
        "Clarke 1866", "Greenwich",
        "Philippine_Reference_System_1992", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=clrk66 +towgs84=-127.62,-67.24,-47.");
    add_proj4text (p, 1,
        "04,-3.068,4.903,1.578,-1.06 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCRS[\"PRS92\",DATUM[\"Philippine Reference System 19");
    add_srs_wkt (p, 1,
        "92\",ELLIPSOID[\"Clarke 1866\",6378206.4,294.97869821389");
    add_srs_wkt (p, 2,
        "8,LENGTHUNIT[\"metre\",1]]],PRIMEM[\"Greenwich\",0,ANGLE");
    add_srs_wkt (p, 3,
        "UNIT[\"degree\",0.0174532925199433]],CS[ellipsoidal,3],A");
    add_srs_wkt (p, 4,
        "XIS[\"geodetic latitude (Lat)\",north,ORDER[1],ANGLEUNIT");
    add_srs_wkt (p, 5,
        "[\"degree\",0.0174532925199433]],AXIS[\"geodetic longitu");
    add_srs_wkt (p, 6,
        "de (Lon)\",east,ORDER[2],ANGLEUNIT[\"degree\",0.01745329");
    add_srs_wkt (p, 7,
        "25199433]],AXIS[\"ellipsoidal height (h)\",up,ORDER[3],L");
    add_srs_wkt (p, 8,
        "ENGTHUNIT[\"metre\",1]],USAGE[SCOPE[\"unknown\"],AREA[\"");
    add_srs_wkt (p, 9,
        "Philippines\"],BBOX[3,116.04,22.18,129.95]],ID[\"EPSG\",");
    add_srs_wkt (p, 10,
        "4995]]");
    p = add_epsg_def_ex (filter, first, last, 4997, "epsg", 4997,
        "MAGNA-SIRGAS", 1, 1,
        "GRS 1980", "Greenwich",
        "Marco_Geocentrico_Nacional_de_Referencia", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +no_de");
    add_proj4text (p, 1,
        "fs");
    add_srs_wkt (p, 0,
        "GEOGCRS[\"MAGNA-SIRGAS\",DATUM[\"Marco Geocentrico Nacio");
    add_srs_wkt (p, 1,
        "nal de Referencia\",ELLIPSOID[\"GRS 1980\",6378137,298.2");
    add_srs_wkt (p, 2,
        "57222101,LENGTHUNIT[\"metre\",1]]],PRIMEM[\"Greenwich\",");
    add_srs_wkt (p, 3,
        "0,ANGLEUNIT[\"degree\",0.0174532925199433]],CS[ellipsoid");
    add_srs_wkt (p, 4,
        "al,3],AXIS[\"geodetic latitude (Lat)\",north,ORDER[1],AN");
    add_srs_wkt (p, 5,
        "GLEUNIT[\"degree\",0.0174532925199433]],AXIS[\"geodetic ");
    add_srs_wkt (p, 6,
        "longitude (Lon)\",east,ORDER[2],ANGLEUNIT[\"degree\",0.0");
    add_srs_wkt (p, 7,
        "174532925199433]],AXIS[\"ellipsoidal height (h)\",up,ORD");
    add_srs_wkt (p, 8,
        "ER[3],LENGTHUNIT[\"metre\",1]],USAGE[SCOPE[\"unknown\"],");
    add_srs_wkt (p, 9,
        "AREA[\"Colombia\"],BBOX[-4.23,-84.77,15.51,-66.87]],ID[\"");
    add_srs_wkt (p, 10,
        "EPSG\",4997]]");
    p = add_epsg_def_ex (filter, first, last, 4999, "epsg", 4999,
        "RGPF", 1, 1,
        "GRS 1980", "Greenwich",
        "Reseau_Geodesique_de_la_Polynesie_Francaise", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +towgs84=0.072,-0.507,-0.245,");
    add_proj4text (p, 1,
        "0.0183,-0.0003,0.007,-0.0093 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCRS[\"RGPF\",DATUM[\"Reseau Geodesique de la Polynes");
    add_srs_wkt (p, 1,
        "ie Francaise\",ELLIPSOID[\"GRS 1980\",6378137,298.257222");
    add_srs_wkt (p, 2,
        "101,LENGTHUNIT[\"metre\",1]]],PRIMEM[\"Greenwich\",0,ANG");
    add_srs_wkt (p, 3,
        "LEUNIT[\"degree\",0.0174532925199433]],CS[ellipsoidal,3]");
    add_srs_wkt (p, 4,
        ",AXIS[\"geodetic latitude (Lat)\",north,ORDER[1],ANGLEUN");
    add_srs_wkt (p, 5,
        "IT[\"degree\",0.0174532925199433]],AXIS[\"geodetic longi");
    add_srs_wkt (p, 6,
        "tude (Lon)\",east,ORDER[2],ANGLEUNIT[\"degree\",0.017453");
    add_srs_wkt (p, 7,
        "2925199433]],AXIS[\"ellipsoidal height (h)\",up,ORDER[3]");
    add_srs_wkt (p, 8,
        ",LENGTHUNIT[\"metre\",1]],USAGE[SCOPE[\"unknown\"],AREA[");
    add_srs_wkt (p, 9,
        "\"French Polynesia\"],BBOX[-31.24,-158.13,-4.52,-131.97]");
    add_srs_wkt (p, 10,
        "],ID[\"EPSG\",4999]]");
    p = add_epsg_def_ex (filter, first, last, 5012, "epsg", 5012,
        "PTRA08", 1, 1,
        "GRS 1980", "Greenwich",
        "Autonomous_Regions_of_Portugal_2008", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +no_de");
    add_proj4text (p, 1,
        "fs");
    add_srs_wkt (p, 0,
        "GEOGCRS[\"PTRA08\",DATUM[\"Autonomous Regions of Portuga");
    add_srs_wkt (p, 1,
        "l 2008\",ELLIPSOID[\"GRS 1980\",6378137,298.257222101,LE");
    add_srs_wkt (p, 2,
        "NGTHUNIT[\"metre\",1]]],PRIMEM[\"Greenwich\",0,ANGLEUNIT");
    add_srs_wkt (p, 3,
        "[\"degree\",0.0174532925199433]],CS[ellipsoidal,3],AXIS[");
    add_srs_wkt (p, 4,
        "\"geodetic latitude (Lat)\",north,ORDER[1],ANGLEUNIT[\"d");
    add_srs_wkt (p, 5,
        "egree\",0.0174532925199433]],AXIS[\"geodetic longitude (");
    add_srs_wkt (p, 6,
        "Lon)\",east,ORDER[2],ANGLEUNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 7,
        "9433]],AXIS[\"ellipsoidal height (h)\",up,ORDER[3],LENGT");
    add_srs_wkt (p, 8,
        "HUNIT[\"metre\",1]],USAGE[SCOPE[\"unknown\"],AREA[\"Port");
    add_srs_wkt (p, 9,
        "ugal - Azores and Madeira\"],BBOX[29.24,-35.58,43.07,-12");
    add_srs_wkt (p, 10,
        ".48]],ID[\"EPSG\",5012]]");
    p = add_epsg_def_ex (filter, first, last, 5013, "epsg", 5013,
        "PTRA08", 1, 1,
        "GRS 1980", "Greenwich",
        "Autonomous_Regions_of_Portugal_2008", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +no_de");
    add_proj4text (p, 1,
        "fs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"PTRA08\",DATUM[\"Autonomous_Regions_of_Portugal");
    add_srs_wkt (p, 1,
        "_2008\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTH");
    add_srs_wkt (p, 2,
        "ORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1041\"]],");
    add_srs_wkt (p, 3,
        "PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNI");
    add_srs_wkt (p, 4,
        "T[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"912");
    add_srs_wkt (p, 5,
        "2\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],");
    add_srs_wkt (p, 6,
        "AUTHORITY[\"EPSG\",\"5013\"]]");
    p = add_epsg_def_ex (filter, first, last, 5014, "epsg", 5014,
        "PTRA08 / UTM zone 25N", 0, 0,
        "GRS 1980", "Greenwich",
        "Autonomous_Regions_of_Portugal_2008", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=25 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +");
    add_proj4text (p, 1,
        "units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"PTRA08 / UTM zone 25N\",GEOGCS[\"PTRA08\",DATUM");
    add_srs_wkt (p, 1,
        "[\"Autonomous_Regions_of_Portugal_2008\",SPHEROID[\"GRS ");
    add_srs_wkt (p, 2,
        "1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"");
    add_srs_wkt (p, 3,
        "]],AUTHORITY[\"EPSG\",\"1041\"]],PRIMEM[\"Greenwich\",0,");
    add_srs_wkt (p, 4,
        "AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329");
    add_srs_wkt (p, 5,
        "25199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"5013\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETE");
    add_srs_wkt (p, 7,
        "R[\"latitude_of_origin\",0],PARAMETER[\"central_meridian");
    add_srs_wkt (p, 8,
        "\",-33],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"f");
    add_srs_wkt (p, 9,
        "alse_easting\",500000],PARAMETER[\"false_northing\",0],U");
    add_srs_wkt (p, 10,
        "NIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Eas");
    add_srs_wkt (p, 11,
        "ting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 12,
        ",\"5014\"]]");
    p = add_epsg_def_ex (filter, first, last, 5015, "epsg", 5015,
        "PTRA08 / UTM zone 26N", 0, 0,
        "GRS 1980", "Greenwich",
        "Autonomous_Regions_of_Portugal_2008", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=26 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +");
    add_proj4text (p, 1,
        "units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"PTRA08 / UTM zone 26N\",GEOGCS[\"PTRA08\",DATUM");
    add_srs_wkt (p, 1,
        "[\"Autonomous_Regions_of_Portugal_2008\",SPHEROID[\"GRS ");
    add_srs_wkt (p, 2,
        "1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"");
    add_srs_wkt (p, 3,
        "]],AUTHORITY[\"EPSG\",\"1041\"]],PRIMEM[\"Greenwich\",0,");
    add_srs_wkt (p, 4,
        "AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329");
    add_srs_wkt (p, 5,
        "25199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"5013\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETE");
    add_srs_wkt (p, 7,
        "R[\"latitude_of_origin\",0],PARAMETER[\"central_meridian");
    add_srs_wkt (p, 8,
        "\",-27],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"f");
    add_srs_wkt (p, 9,
        "alse_easting\",500000],PARAMETER[\"false_northing\",0],U");
    add_srs_wkt (p, 10,
        "NIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Eas");
    add_srs_wkt (p, 11,
        "ting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 12,
        ",\"5015\"]]");
    p = add_epsg_def_ex (filter, first, last, 5016, "epsg", 5016,
        "PTRA08 / UTM zone 28N", 0, 0,
        "GRS 1980", "Greenwich",
        "Autonomous_Regions_of_Portugal_2008", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=28 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +");
    add_proj4text (p, 1,
        "units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"PTRA08 / UTM zone 28N\",GEOGCS[\"PTRA08\",DATUM");
    add_srs_wkt (p, 1,
        "[\"Autonomous_Regions_of_Portugal_2008\",SPHEROID[\"GRS ");
    add_srs_wkt (p, 2,
        "1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"");
    add_srs_wkt (p, 3,
        "]],AUTHORITY[\"EPSG\",\"1041\"]],PRIMEM[\"Greenwich\",0,");
    add_srs_wkt (p, 4,
        "AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329");
    add_srs_wkt (p, 5,
        "25199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"5013\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETE");
    add_srs_wkt (p, 7,
        "R[\"latitude_of_origin\",0],PARAMETER[\"central_meridian");
    add_srs_wkt (p, 8,
        "\",-15],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"f");
    add_srs_wkt (p, 9,
        "alse_easting\",500000],PARAMETER[\"false_northing\",0],U");
    add_srs_wkt (p, 10,
        "NIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Eas");
    add_srs_wkt (p, 11,
        "ting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 12,
        ",\"5016\"]]");
    p = add_epsg_def_ex (filter, first, last, 5018, "epsg", 5018,
        "Lisbon / Portuguese Grid New", 0, 0,
        "International 1924", "Greenwich",
        "Lisbon_1937", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=39.66666666666666 +lon_0=-8.131906111");
    add_proj4text (p, 1,
        "111112 +k=1 +x_0=0 +y_0=0 +ellps=intl +towgs84=-304.046,");
    add_proj4text (p, 2,
        "-60.576,103.64,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Lisbon / Portuguese Grid New\",GEOGCS[\"Lisbon\"");
    add_srs_wkt (p, 1,
        ",DATUM[\"Lisbon_1937\",SPHEROID[\"International 1924\",6");
    add_srs_wkt (p, 2,
        "378388,297,AUTHORITY[\"EPSG\",\"7022\"]],AUTHORITY[\"EPS");
    add_srs_wkt (p, 3,
        "G\",\"6207\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 4,
        ",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY");
    add_srs_wkt (p, 5,
        "[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4207\"]],PROJE");
    add_srs_wkt (p, 6,
        "CTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_o");
    add_srs_wkt (p, 7,
        "rigin\",39.6666666666667],PARAMETER[\"central_meridian\"");
    add_srs_wkt (p, 8,
        ",-8.13190611111111],PARAMETER[\"scale_factor\",1],PARAME");
    add_srs_wkt (p, 9,
        "TER[\"false_easting\",0],PARAMETER[\"false_northing\",0]");
    add_srs_wkt (p, 10,
        ",UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"E");
    add_srs_wkt (p, 11,
        "asting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 12,
        "\",\"5018\"]]");
    p = add_epsg_def_ex (filter, first, last, 5041, "epsg", 5041,
        "WGS 84 / UPS North (E,N)", 0, 0,
        "WGS 84", "Greenwich",
        "WGS_1984", "Polar_Stereographic", "metre",
        "Easting", "South", "Northing", "South");
    add_proj4text (p, 0,
        "+proj=stere +lat_0=90 +lat_ts=90 +lon_0=0 +k=0.994 +x_0=");
    add_proj4text (p, 1,
        "2000000 +y_0=2000000 +datum=WGS84 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 84 / UPS North (E,N)\",GEOGCS[\"WGS 84\",DA");
    add_srs_wkt (p, 1,
        "TUM[\"WGS_1984\",SPHEROID[\"WGS 84\",6378137,298.2572235");
    add_srs_wkt (p, 2,
        "63,AUTHORITY[\"EPSG\",\"7030\"]],AUTHORITY[\"EPSG\",\"63");
    add_srs_wkt (p, 3,
        "26\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"");
    add_srs_wkt (p, 4,
        "]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 5,
        ",\"9122\"]],AUTHORITY[\"EPSG\",\"4326\"]],PROJECTION[\"P");
    add_srs_wkt (p, 6,
        "olar_Stereographic\"],PARAMETER[\"latitude_of_origin\",9");
    add_srs_wkt (p, 7,
        "0],PARAMETER[\"central_meridian\",0],PARAMETER[\"scale_f");
    add_srs_wkt (p, 8,
        "actor\",0.994],PARAMETER[\"false_easting\",2000000],PARA");
    add_srs_wkt (p, 9,
        "METER[\"false_northing\",2000000],UNIT[\"metre\",1,AUTHO");
    add_srs_wkt (p, 10,
        "RITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",SOUTH],AXIS[\"");
    add_srs_wkt (p, 11,
        "Northing\",SOUTH],AUTHORITY[\"EPSG\",\"5041\"]]");
    p = add_epsg_def_ex (filter, first, last, 5042, "epsg", 5042,
        "WGS 84 / UPS South (E,N)", 0, 0,
        "WGS 84", "Greenwich",
        "WGS_1984", "Polar_Stereographic", "metre",
        "Easting", "North", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=stere +lat_0=-90 +lat_ts=-90 +lon_0=0 +k=0.994 +x_");
    add_proj4text (p, 1,
        "0=2000000 +y_0=2000000 +datum=WGS84 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 84 / UPS South (E,N)\",GEOGCS[\"WGS 84\",DA");
    add_srs_wkt (p, 1,
        "TUM[\"WGS_1984\",SPHEROID[\"WGS 84\",6378137,298.2572235");
    add_srs_wkt (p, 2,
        "63,AUTHORITY[\"EPSG\",\"7030\"]],AUTHORITY[\"EPSG\",\"63");
    add_srs_wkt (p, 3,
        "26\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"");
    add_srs_wkt (p, 4,
        "]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 5,
        ",\"9122\"]],AUTHORITY[\"EPSG\",\"4326\"]],PROJECTION[\"P");
    add_srs_wkt (p, 6,
        "olar_Stereographic\"],PARAMETER[\"latitude_of_origin\",-");
    add_srs_wkt (p, 7,
        "90],PARAMETER[\"central_meridian\",0],PARAMETER[\"scale_");
    add_srs_wkt (p, 8,
        "factor\",0.994],PARAMETER[\"false_easting\",2000000],PAR");
    add_srs_wkt (p, 9,
        "AMETER[\"false_northing\",2000000],UNIT[\"metre\",1,AUTH");
    add_srs_wkt (p, 10,
        "ORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",NORTH],AXIS[\"");
    add_srs_wkt (p, 11,
        "Northing\",NORTH],AUTHORITY[\"EPSG\",\"5042\"]]");
    p = add_epsg_def_ex (filter, first, last, 5048, "epsg", 5048,
        "ETRS89 / TM35FIN(N,E)", 0, 1,
        "GRS 1980", "Greenwich",
        "European_Terrestrial_Reference_System_1989", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=utm +zone=35 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +");
    add_proj4text (p, 1,
        "units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"ETRS89 / TM35FIN(N,E)\",GEOGCS[\"ETRS89\",DATUM");
    add_srs_wkt (p, 1,
        "[\"European_Terrestrial_Reference_System_1989\",SPHEROID");
    add_srs_wkt (p, 2,
        "[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 3,
        "7019\"]],AUTHORITY[\"EPSG\",\"6258\"]],PRIMEM[\"Greenwic");
    add_srs_wkt (p, 4,
        "h\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01");
    add_srs_wkt (p, 5,
        "74532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"4258\"]],PROJECTION[\"Transverse_Mercator\"],PA");
    add_srs_wkt (p, 7,
        "RAMETER[\"latitude_of_origin\",0],PARAMETER[\"central_me");
    add_srs_wkt (p, 8,
        "ridian\",27],PARAMETER[\"scale_factor\",0.9996],PARAMETE");
    add_srs_wkt (p, 9,
        "R[\"false_easting\",500000],PARAMETER[\"false_northing\"");
    add_srs_wkt (p, 10,
        ",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[");
    add_srs_wkt (p, 11,
        "\"Northing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"E");
    add_srs_wkt (p, 12,
        "PSG\",\"5048\"]]");
    p = add_epsg_def_ex (filter, first, last, 5069, "epsg", 5069,
        "NAD27 / Conus Albers", 0, 0,
        "Clarke 1866", "Greenwich",
        "North_American_Datum_1927", "Albers_Conic_Equal_Area", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=aea +lat_1=29.5 +lat_2=45.5 +lat_0=23 +lon_0=-96 +");
    add_proj4text (p, 1,
        "x_0=0 +y_0=0 +datum=NAD27 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / Conus Albers\",GEOGCS[\"NAD27\",DATUM[\"");
    add_srs_wkt (p, 1,
        "North_American_Datum_1927\",SPHEROID[\"Clarke 1866\",637");
    add_srs_wkt (p, 2,
        "8206.4,294.978698213898,AUTHORITY[\"EPSG\",\"7008\"]],AU");
    add_srs_wkt (p, 3,
        "THORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,AUTHO");
    add_srs_wkt (p, 4,
        "RITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199");
    add_srs_wkt (p, 5,
        "433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4");
    add_srs_wkt (p, 6,
        "267\"]],PROJECTION[\"Albers_Conic_Equal_Area\"],PARAMETE");
    add_srs_wkt (p, 7,
        "R[\"latitude_of_center\",23],PARAMETER[\"longitude_of_ce");
    add_srs_wkt (p, 8,
        "nter\",-96],PARAMETER[\"standard_parallel_1\",29.5],PARA");
    add_srs_wkt (p, 9,
        "METER[\"standard_parallel_2\",45.5],PARAMETER[\"false_ea");
    add_srs_wkt (p, 10,
        "sting\",0],PARAMETER[\"false_northing\",0],UNIT[\"metre\"");
    add_srs_wkt (p, 11,
        ",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],");
    add_srs_wkt (p, 12,
        "AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"5069\"]]");
    p = add_epsg_def_ex (filter, first, last, 5070, "epsg", 5070,
        "NAD83 / Conus Albers", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Albers_Conic_Equal_Area", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=aea +lat_1=29.5 +lat_2=45.5 +lat_0=23 +lon_0=-96 +");
    add_proj4text (p, 1,
        "x_0=0 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=");
    add_proj4text (p, 2,
        "m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / Conus Albers\",GEOGCS[\"NAD83\",DATUM[\"");
    add_srs_wkt (p, 1,
        "North_American_Datum_1983\",SPHEROID[\"GRS 1980\",637813");
    add_srs_wkt (p, 2,
        "7,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[");
    add_srs_wkt (p, 3,
        "\"EPSG\",\"6269\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"E");
    add_srs_wkt (p, 4,
        "PSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTH");
    add_srs_wkt (p, 5,
        "ORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4269\"]],");
    add_srs_wkt (p, 6,
        "PROJECTION[\"Albers_Conic_Equal_Area\"],PARAMETER[\"lati");
    add_srs_wkt (p, 7,
        "tude_of_center\",23],PARAMETER[\"longitude_of_center\",-");
    add_srs_wkt (p, 8,
        "96],PARAMETER[\"standard_parallel_1\",29.5],PARAMETER[\"");
    add_srs_wkt (p, 9,
        "standard_parallel_2\",45.5],PARAMETER[\"false_easting\",");
    add_srs_wkt (p, 10,
        "0],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTH");
    add_srs_wkt (p, 11,
        "ORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"");
    add_srs_wkt (p, 12,
        "Northing\",NORTH],AUTHORITY[\"EPSG\",\"5070\"]]");
    p = add_epsg_def_ex (filter, first, last, 5071, "epsg", 5071,
        "NAD83(HARN) / Conus Albers", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Albers_Conic_Equal_Area", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=aea +lat_1=29.5 +lat_2=45.5 +lat_0=23 +lon_0=-96 +");
    add_proj4text (p, 1,
        "x_0=0 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=");
    add_proj4text (p, 2,
        "m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / Conus Albers\",GEOGCS[\"NAD83(HAR");
    add_srs_wkt (p, 1,
        "N)\",DATUM[\"NAD83_High_Accuracy_Reference_Network\",SPH");
    add_srs_wkt (p, 2,
        "EROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPS");
    add_srs_wkt (p, 3,
        "G\",\"7019\"]],AUTHORITY[\"EPSG\",\"6152\"]],PRIMEM[\"Gr");
    add_srs_wkt (p, 4,
        "eenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\"");
    add_srs_wkt (p, 5,
        ",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHOR");
    add_srs_wkt (p, 6,
        "ITY[\"EPSG\",\"4152\"]],PROJECTION[\"Albers_Conic_Equal_");
    add_srs_wkt (p, 7,
        "Area\"],PARAMETER[\"latitude_of_center\",23],PARAMETER[\"");
    add_srs_wkt (p, 8,
        "longitude_of_center\",-96],PARAMETER[\"standard_parallel");
    add_srs_wkt (p, 9,
        "_1\",29.5],PARAMETER[\"standard_parallel_2\",45.5],PARAM");
    add_srs_wkt (p, 10,
        "ETER[\"false_easting\",0],PARAMETER[\"false_northing\",0");
    add_srs_wkt (p, 11,
        "],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"");
    add_srs_wkt (p, 12,
        "Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPS");
    add_srs_wkt (p, 13,
        "G\",\"5071\"]]");
    p = add_epsg_def_ex (filter, first, last, 5072, "epsg", 5072,
        "NAD83(NSRS2007) / Conus Albers", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2007", "Albers_Conic_Equal_Area", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=aea +lat_1=29.5 +lat_2=45.5 +lat_0=23 +lon_0=-96 +");
    add_proj4text (p, 1,
        "x_0=0 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=");
    add_proj4text (p, 2,
        "m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(NSRS2007) / Conus Albers\",GEOGCS[\"NAD83");
    add_srs_wkt (p, 1,
        "(NSRS2007)\",DATUM[\"NAD83_National_Spatial_Reference_Sy");
    add_srs_wkt (p, 2,
        "stem_2007\",SPHEROID[\"GRS 1980\",6378137,298.257222101,");
    add_srs_wkt (p, 3,
        "AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"6759\"");
    add_srs_wkt (p, 4,
        "]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],");
    add_srs_wkt (p, 5,
        "UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "9122\"]],AUTHORITY[\"EPSG\",\"4759\"]],PROJECTION[\"Albe");
    add_srs_wkt (p, 7,
        "rs_Conic_Equal_Area\"],PARAMETER[\"latitude_of_center\",");
    add_srs_wkt (p, 8,
        "23],PARAMETER[\"longitude_of_center\",-96],PARAMETER[\"s");
    add_srs_wkt (p, 9,
        "tandard_parallel_1\",29.5],PARAMETER[\"standard_parallel");
    add_srs_wkt (p, 10,
        "_2\",45.5],PARAMETER[\"false_easting\",0],PARAMETER[\"fa");
    add_srs_wkt (p, 11,
        "lse_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 12,
        "9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH]");
    add_srs_wkt (p, 13,
        ",AUTHORITY[\"EPSG\",\"5072\"]]");
    p = add_epsg_def_ex (filter, first, last, 5105, "epsg", 5105,
        "ETRS89 / NTM zone 5", 0, 1,
        "GRS 1980", "Greenwich",
        "European_Terrestrial_Reference_System_1989", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=58 +lon_0=5.5 +k=1 +x_0=100000 +y_0=1");
    add_proj4text (p, 1,
        "000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_");
    add_proj4text (p, 2,
        "defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"ETRS89 / NTM zone 5\",GEOGCS[\"ETRS89\",DATUM[\"");
    add_srs_wkt (p, 1,
        "European_Terrestrial_Reference_System_1989\",SPHEROID[\"");
    add_srs_wkt (p, 2,
        "GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"70");
    add_srs_wkt (p, 3,
        "19\"]],AUTHORITY[\"EPSG\",\"6258\"]],PRIMEM[\"Greenwich\"");
    add_srs_wkt (p, 4,
        ",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745");
    add_srs_wkt (p, 5,
        "32925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EP");
    add_srs_wkt (p, 6,
        "SG\",\"4258\"]],PROJECTION[\"Transverse_Mercator\"],PARA");
    add_srs_wkt (p, 7,
        "METER[\"latitude_of_origin\",58],PARAMETER[\"central_mer");
    add_srs_wkt (p, 8,
        "idian\",5.5],PARAMETER[\"scale_factor\",1],PARAMETER[\"f");
    add_srs_wkt (p, 9,
        "alse_easting\",100000],PARAMETER[\"false_northing\",1000");
    add_srs_wkt (p, 10,
        "000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS");
    add_srs_wkt (p, 11,
        "[\"Northing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"");
    add_srs_wkt (p, 12,
        "EPSG\",\"5105\"]]");
    p = add_epsg_def_ex (filter, first, last, 5106, "epsg", 5106,
        "ETRS89 / NTM zone 6", 0, 1,
        "GRS 1980", "Greenwich",
        "European_Terrestrial_Reference_System_1989", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=58 +lon_0=6.5 +k=1 +x_0=100000 +y_0=1");
    add_proj4text (p, 1,
        "000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_");
    add_proj4text (p, 2,
        "defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"ETRS89 / NTM zone 6\",GEOGCS[\"ETRS89\",DATUM[\"");
    add_srs_wkt (p, 1,
        "European_Terrestrial_Reference_System_1989\",SPHEROID[\"");
    add_srs_wkt (p, 2,
        "GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"70");
    add_srs_wkt (p, 3,
        "19\"]],AUTHORITY[\"EPSG\",\"6258\"]],PRIMEM[\"Greenwich\"");
    add_srs_wkt (p, 4,
        ",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745");
    add_srs_wkt (p, 5,
        "32925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EP");
    add_srs_wkt (p, 6,
        "SG\",\"4258\"]],PROJECTION[\"Transverse_Mercator\"],PARA");
    add_srs_wkt (p, 7,
        "METER[\"latitude_of_origin\",58],PARAMETER[\"central_mer");
    add_srs_wkt (p, 8,
        "idian\",6.5],PARAMETER[\"scale_factor\",1],PARAMETER[\"f");
    add_srs_wkt (p, 9,
        "alse_easting\",100000],PARAMETER[\"false_northing\",1000");
    add_srs_wkt (p, 10,
        "000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS");
    add_srs_wkt (p, 11,
        "[\"Northing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"");
    add_srs_wkt (p, 12,
        "EPSG\",\"5106\"]]");
    p = add_epsg_def_ex (filter, first, last, 5107, "epsg", 5107,
        "ETRS89 / NTM zone 7", 0, 1,
        "GRS 1980", "Greenwich",
        "European_Terrestrial_Reference_System_1989", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=58 +lon_0=7.5 +k=1 +x_0=100000 +y_0=1");
    add_proj4text (p, 1,
        "000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_");
    add_proj4text (p, 2,
        "defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"ETRS89 / NTM zone 7\",GEOGCS[\"ETRS89\",DATUM[\"");
    add_srs_wkt (p, 1,
        "European_Terrestrial_Reference_System_1989\",SPHEROID[\"");
    add_srs_wkt (p, 2,
        "GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"70");
    add_srs_wkt (p, 3,
        "19\"]],AUTHORITY[\"EPSG\",\"6258\"]],PRIMEM[\"Greenwich\"");
    add_srs_wkt (p, 4,
        ",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745");
    add_srs_wkt (p, 5,
        "32925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EP");
    add_srs_wkt (p, 6,
        "SG\",\"4258\"]],PROJECTION[\"Transverse_Mercator\"],PARA");
    add_srs_wkt (p, 7,
        "METER[\"latitude_of_origin\",58],PARAMETER[\"central_mer");
    add_srs_wkt (p, 8,
        "idian\",7.5],PARAMETER[\"scale_factor\",1],PARAMETER[\"f");
    add_srs_wkt (p, 9,
        "alse_easting\",100000],PARAMETER[\"false_northing\",1000");
    add_srs_wkt (p, 10,
        "000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS");
    add_srs_wkt (p, 11,
        "[\"Northing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"");
    add_srs_wkt (p, 12,
        "EPSG\",\"5107\"]]");
    p = add_epsg_def_ex (filter, first, last, 5108, "epsg", 5108,
        "ETRS89 / NTM zone 8", 0, 1,
        "GRS 1980", "Greenwich",
        "European_Terrestrial_Reference_System_1989", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=58 +lon_0=8.5 +k=1 +x_0=100000 +y_0=1");
    add_proj4text (p, 1,
        "000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_");
    add_proj4text (p, 2,
        "defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"ETRS89 / NTM zone 8\",GEOGCS[\"ETRS89\",DATUM[\"");
    add_srs_wkt (p, 1,
        "European_Terrestrial_Reference_System_1989\",SPHEROID[\"");
    add_srs_wkt (p, 2,
        "GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"70");
    add_srs_wkt (p, 3,
        "19\"]],AUTHORITY[\"EPSG\",\"6258\"]],PRIMEM[\"Greenwich\"");
    add_srs_wkt (p, 4,
        ",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745");
    add_srs_wkt (p, 5,
        "32925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EP");
    add_srs_wkt (p, 6,
        "SG\",\"4258\"]],PROJECTION[\"Transverse_Mercator\"],PARA");
    add_srs_wkt (p, 7,
        "METER[\"latitude_of_origin\",58],PARAMETER[\"central_mer");
    add_srs_wkt (p, 8,
        "idian\",8.5],PARAMETER[\"scale_factor\",1],PARAMETER[\"f");
    add_srs_wkt (p, 9,
        "alse_easting\",100000],PARAMETER[\"false_northing\",1000");
    add_srs_wkt (p, 10,
        "000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS");
    add_srs_wkt (p, 11,
        "[\"Northing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"");
    add_srs_wkt (p, 12,
        "EPSG\",\"5108\"]]");
    p = add_epsg_def_ex (filter, first, last, 5109, "epsg", 5109,
        "ETRS89 / NTM zone 9", 0, 1,
        "GRS 1980", "Greenwich",
        "European_Terrestrial_Reference_System_1989", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=58 +lon_0=9.5 +k=1 +x_0=100000 +y_0=1");
    add_proj4text (p, 1,
        "000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_");
    add_proj4text (p, 2,
        "defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"ETRS89 / NTM zone 9\",GEOGCS[\"ETRS89\",DATUM[\"");
    add_srs_wkt (p, 1,
        "European_Terrestrial_Reference_System_1989\",SPHEROID[\"");
    add_srs_wkt (p, 2,
        "GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"70");
    add_srs_wkt (p, 3,
        "19\"]],AUTHORITY[\"EPSG\",\"6258\"]],PRIMEM[\"Greenwich\"");
    add_srs_wkt (p, 4,
        ",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745");
    add_srs_wkt (p, 5,
        "32925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EP");
    add_srs_wkt (p, 6,
        "SG\",\"4258\"]],PROJECTION[\"Transverse_Mercator\"],PARA");
    add_srs_wkt (p, 7,
        "METER[\"latitude_of_origin\",58],PARAMETER[\"central_mer");
    add_srs_wkt (p, 8,
        "idian\",9.5],PARAMETER[\"scale_factor\",1],PARAMETER[\"f");
    add_srs_wkt (p, 9,
        "alse_easting\",100000],PARAMETER[\"false_northing\",1000");
    add_srs_wkt (p, 10,
        "000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS");
    add_srs_wkt (p, 11,
        "[\"Northing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"");
    add_srs_wkt (p, 12,
        "EPSG\",\"5109\"]]");
    p = add_epsg_def_ex (filter, first, last, 5110, "epsg", 5110,
        "ETRS89 / NTM zone 10", 0, 1,
        "GRS 1980", "Greenwich",
        "European_Terrestrial_Reference_System_1989", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=58 +lon_0=10.5 +k=1 +x_0=100000 +y_0=");
    add_proj4text (p, 1,
        "1000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no");
    add_proj4text (p, 2,
        "_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"ETRS89 / NTM zone 10\",GEOGCS[\"ETRS89\",DATUM[");
    add_srs_wkt (p, 1,
        "\"European_Terrestrial_Reference_System_1989\",SPHEROID[");
    add_srs_wkt (p, 2,
        "\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 3,
        "7019\"]],AUTHORITY[\"EPSG\",\"6258\"]],PRIMEM[\"Greenwic");
    add_srs_wkt (p, 4,
        "h\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01");
    add_srs_wkt (p, 5,
        "74532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"4258\"]],PROJECTION[\"Transverse_Mercator\"],PA");
    add_srs_wkt (p, 7,
        "RAMETER[\"latitude_of_origin\",58],PARAMETER[\"central_m");
    add_srs_wkt (p, 8,
        "eridian\",10.5],PARAMETER[\"scale_factor\",1],PARAMETER[");
    add_srs_wkt (p, 9,
        "\"false_easting\",100000],PARAMETER[\"false_northing\",1");
    add_srs_wkt (p, 10,
        "000000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],A");
    add_srs_wkt (p, 11,
        "XIS[\"Northing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY");
    add_srs_wkt (p, 12,
        "[\"EPSG\",\"5110\"]]");
    p = add_epsg_def_ex (filter, first, last, 5111, "epsg", 5111,
        "ETRS89 / NTM zone 11", 0, 1,
        "GRS 1980", "Greenwich",
        "European_Terrestrial_Reference_System_1989", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=58 +lon_0=11.5 +k=1 +x_0=100000 +y_0=");
    add_proj4text (p, 1,
        "1000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no");
    add_proj4text (p, 2,
        "_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"ETRS89 / NTM zone 11\",GEOGCS[\"ETRS89\",DATUM[");
    add_srs_wkt (p, 1,
        "\"European_Terrestrial_Reference_System_1989\",SPHEROID[");
    add_srs_wkt (p, 2,
        "\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 3,
        "7019\"]],AUTHORITY[\"EPSG\",\"6258\"]],PRIMEM[\"Greenwic");
    add_srs_wkt (p, 4,
        "h\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01");
    add_srs_wkt (p, 5,
        "74532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"4258\"]],PROJECTION[\"Transverse_Mercator\"],PA");
    add_srs_wkt (p, 7,
        "RAMETER[\"latitude_of_origin\",58],PARAMETER[\"central_m");
    add_srs_wkt (p, 8,
        "eridian\",11.5],PARAMETER[\"scale_factor\",1],PARAMETER[");
    add_srs_wkt (p, 9,
        "\"false_easting\",100000],PARAMETER[\"false_northing\",1");
    add_srs_wkt (p, 10,
        "000000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],A");
    add_srs_wkt (p, 11,
        "XIS[\"Northing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY");
    add_srs_wkt (p, 12,
        "[\"EPSG\",\"5111\"]]");
    p = add_epsg_def_ex (filter, first, last, 5112, "epsg", 5112,
        "ETRS89 / NTM zone 12", 0, 1,
        "GRS 1980", "Greenwich",
        "European_Terrestrial_Reference_System_1989", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=58 +lon_0=12.5 +k=1 +x_0=100000 +y_0=");
    add_proj4text (p, 1,
        "1000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no");
    add_proj4text (p, 2,
        "_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"ETRS89 / NTM zone 12\",GEOGCS[\"ETRS89\",DATUM[");
    add_srs_wkt (p, 1,
        "\"European_Terrestrial_Reference_System_1989\",SPHEROID[");
    add_srs_wkt (p, 2,
        "\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 3,
        "7019\"]],AUTHORITY[\"EPSG\",\"6258\"]],PRIMEM[\"Greenwic");
    add_srs_wkt (p, 4,
        "h\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01");
    add_srs_wkt (p, 5,
        "74532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"4258\"]],PROJECTION[\"Transverse_Mercator\"],PA");
    add_srs_wkt (p, 7,
        "RAMETER[\"latitude_of_origin\",58],PARAMETER[\"central_m");
    add_srs_wkt (p, 8,
        "eridian\",12.5],PARAMETER[\"scale_factor\",1],PARAMETER[");
    add_srs_wkt (p, 9,
        "\"false_easting\",100000],PARAMETER[\"false_northing\",1");
    add_srs_wkt (p, 10,
        "000000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],A");
    add_srs_wkt (p, 11,
        "XIS[\"Northing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY");
    add_srs_wkt (p, 12,
        "[\"EPSG\",\"5112\"]]");
    p = add_epsg_def_ex (filter, first, last, 5113, "epsg", 5113,
        "ETRS89 / NTM zone 13", 0, 1,
        "GRS 1980", "Greenwich",
        "European_Terrestrial_Reference_System_1989", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=58 +lon_0=13.5 +k=1 +x_0=100000 +y_0=");
    add_proj4text (p, 1,
        "1000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no");
    add_proj4text (p, 2,
        "_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"ETRS89 / NTM zone 13\",GEOGCS[\"ETRS89\",DATUM[");
    add_srs_wkt (p, 1,
        "\"European_Terrestrial_Reference_System_1989\",SPHEROID[");
    add_srs_wkt (p, 2,
        "\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 3,
        "7019\"]],AUTHORITY[\"EPSG\",\"6258\"]],PRIMEM[\"Greenwic");
    add_srs_wkt (p, 4,
        "h\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01");
    add_srs_wkt (p, 5,
        "74532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"4258\"]],PROJECTION[\"Transverse_Mercator\"],PA");
    add_srs_wkt (p, 7,
        "RAMETER[\"latitude_of_origin\",58],PARAMETER[\"central_m");
    add_srs_wkt (p, 8,
        "eridian\",13.5],PARAMETER[\"scale_factor\",1],PARAMETER[");
    add_srs_wkt (p, 9,
        "\"false_easting\",100000],PARAMETER[\"false_northing\",1");
    add_srs_wkt (p, 10,
        "000000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],A");
    add_srs_wkt (p, 11,
        "XIS[\"Northing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY");
    add_srs_wkt (p, 12,
        "[\"EPSG\",\"5113\"]]");
    p = add_epsg_def_ex (filter, first, last, 5114, "epsg", 5114,
        "ETRS89 / NTM zone 14", 0, 1,
        "GRS 1980", "Greenwich",
        "European_Terrestrial_Reference_System_1989", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=58 +lon_0=14.5 +k=1 +x_0=100000 +y_0=");
    add_proj4text (p, 1,
        "1000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no");
    add_proj4text (p, 2,
        "_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"ETRS89 / NTM zone 14\",GEOGCS[\"ETRS89\",DATUM[");
    add_srs_wkt (p, 1,
        "\"European_Terrestrial_Reference_System_1989\",SPHEROID[");
    add_srs_wkt (p, 2,
        "\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 3,
        "7019\"]],AUTHORITY[\"EPSG\",\"6258\"]],PRIMEM[\"Greenwic");
    add_srs_wkt (p, 4,
        "h\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01");
    add_srs_wkt (p, 5,
        "74532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"4258\"]],PROJECTION[\"Transverse_Mercator\"],PA");
    add_srs_wkt (p, 7,
        "RAMETER[\"latitude_of_origin\",58],PARAMETER[\"central_m");
    add_srs_wkt (p, 8,
        "eridian\",14.5],PARAMETER[\"scale_factor\",1],PARAMETER[");
    add_srs_wkt (p, 9,
        "\"false_easting\",100000],PARAMETER[\"false_northing\",1");
    add_srs_wkt (p, 10,
        "000000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],A");
    add_srs_wkt (p, 11,
        "XIS[\"Northing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY");
    add_srs_wkt (p, 12,
        "[\"EPSG\",\"5114\"]]");
    p = add_epsg_def_ex (filter, first, last, 5115, "epsg", 5115,
        "ETRS89 / NTM zone 15", 0, 1,
        "GRS 1980", "Greenwich",
        "European_Terrestrial_Reference_System_1989", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=58 +lon_0=15.5 +k=1 +x_0=100000 +y_0=");
    add_proj4text (p, 1,
        "1000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no");
    add_proj4text (p, 2,
        "_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"ETRS89 / NTM zone 15\",GEOGCS[\"ETRS89\",DATUM[");
    add_srs_wkt (p, 1,
        "\"European_Terrestrial_Reference_System_1989\",SPHEROID[");
    add_srs_wkt (p, 2,
        "\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 3,
        "7019\"]],AUTHORITY[\"EPSG\",\"6258\"]],PRIMEM[\"Greenwic");
    add_srs_wkt (p, 4,
        "h\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01");
    add_srs_wkt (p, 5,
        "74532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"4258\"]],PROJECTION[\"Transverse_Mercator\"],PA");
    add_srs_wkt (p, 7,
        "RAMETER[\"latitude_of_origin\",58],PARAMETER[\"central_m");
    add_srs_wkt (p, 8,
        "eridian\",15.5],PARAMETER[\"scale_factor\",1],PARAMETER[");
    add_srs_wkt (p, 9,
        "\"false_easting\",100000],PARAMETER[\"false_northing\",1");
    add_srs_wkt (p, 10,
        "000000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],A");
    add_srs_wkt (p, 11,
        "XIS[\"Northing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY");
    add_srs_wkt (p, 12,
        "[\"EPSG\",\"5115\"]]");
    p = add_epsg_def_ex (filter, first, last, 5116, "epsg", 5116,
        "ETRS89 / NTM zone 16", 0, 1,
        "GRS 1980", "Greenwich",
        "European_Terrestrial_Reference_System_1989", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=58 +lon_0=16.5 +k=1 +x_0=100000 +y_0=");
    add_proj4text (p, 1,
        "1000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no");
    add_proj4text (p, 2,
        "_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"ETRS89 / NTM zone 16\",GEOGCS[\"ETRS89\",DATUM[");
    add_srs_wkt (p, 1,
        "\"European_Terrestrial_Reference_System_1989\",SPHEROID[");
    add_srs_wkt (p, 2,
        "\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 3,
        "7019\"]],AUTHORITY[\"EPSG\",\"6258\"]],PRIMEM[\"Greenwic");
    add_srs_wkt (p, 4,
        "h\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01");
    add_srs_wkt (p, 5,
        "74532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"4258\"]],PROJECTION[\"Transverse_Mercator\"],PA");
    add_srs_wkt (p, 7,
        "RAMETER[\"latitude_of_origin\",58],PARAMETER[\"central_m");
    add_srs_wkt (p, 8,
        "eridian\",16.5],PARAMETER[\"scale_factor\",1],PARAMETER[");
    add_srs_wkt (p, 9,
        "\"false_easting\",100000],PARAMETER[\"false_northing\",1");
    add_srs_wkt (p, 10,
        "000000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],A");
    add_srs_wkt (p, 11,
        "XIS[\"Northing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY");
    add_srs_wkt (p, 12,
        "[\"EPSG\",\"5116\"]]");
    p = add_epsg_def_ex (filter, first, last, 5117, "epsg", 5117,
        "ETRS89 / NTM zone 17", 0, 1,
        "GRS 1980", "Greenwich",
        "European_Terrestrial_Reference_System_1989", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=58 +lon_0=17.5 +k=1 +x_0=100000 +y_0=");
    add_proj4text (p, 1,
        "1000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no");
    add_proj4text (p, 2,
        "_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"ETRS89 / NTM zone 17\",GEOGCS[\"ETRS89\",DATUM[");
    add_srs_wkt (p, 1,
        "\"European_Terrestrial_Reference_System_1989\",SPHEROID[");
    add_srs_wkt (p, 2,
        "\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 3,
        "7019\"]],AUTHORITY[\"EPSG\",\"6258\"]],PRIMEM[\"Greenwic");
    add_srs_wkt (p, 4,
        "h\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01");
    add_srs_wkt (p, 5,
        "74532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"4258\"]],PROJECTION[\"Transverse_Mercator\"],PA");
    add_srs_wkt (p, 7,
        "RAMETER[\"latitude_of_origin\",58],PARAMETER[\"central_m");
    add_srs_wkt (p, 8,
        "eridian\",17.5],PARAMETER[\"scale_factor\",1],PARAMETER[");
    add_srs_wkt (p, 9,
        "\"false_easting\",100000],PARAMETER[\"false_northing\",1");
    add_srs_wkt (p, 10,
        "000000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],A");
    add_srs_wkt (p, 11,
        "XIS[\"Northing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY");
    add_srs_wkt (p, 12,
        "[\"EPSG\",\"5117\"]]");
    p = add_epsg_def_ex (filter, first, last, 5118, "epsg", 5118,
        "ETRS89 / NTM zone 18", 0, 1,
        "GRS 1980", "Greenwich",
        "European_Terrestrial_Reference_System_1989", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=58 +lon_0=18.5 +k=1 +x_0=100000 +y_0=");
    add_proj4text (p, 1,
        "1000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no");
    add_proj4text (p, 2,
        "_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"ETRS89 / NTM zone 18\",GEOGCS[\"ETRS89\",DATUM[");
    add_srs_wkt (p, 1,
        "\"European_Terrestrial_Reference_System_1989\",SPHEROID[");
    add_srs_wkt (p, 2,
        "\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 3,
        "7019\"]],AUTHORITY[\"EPSG\",\"6258\"]],PRIMEM[\"Greenwic");
    add_srs_wkt (p, 4,
        "h\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01");
    add_srs_wkt (p, 5,
        "74532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"4258\"]],PROJECTION[\"Transverse_Mercator\"],PA");
    add_srs_wkt (p, 7,
        "RAMETER[\"latitude_of_origin\",58],PARAMETER[\"central_m");
    add_srs_wkt (p, 8,
        "eridian\",18.5],PARAMETER[\"scale_factor\",1],PARAMETER[");
    add_srs_wkt (p, 9,
        "\"false_easting\",100000],PARAMETER[\"false_northing\",1");
    add_srs_wkt (p, 10,
        "000000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],A");
    add_srs_wkt (p, 11,
        "XIS[\"Northing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY");
    add_srs_wkt (p, 12,
        "[\"EPSG\",\"5118\"]]");
    p = add_epsg_def_ex (filter, first, last, 5119, "epsg", 5119,
        "ETRS89 / NTM zone 19", 0, 1,
        "GRS 1980", "Greenwich",
        "European_Terrestrial_Reference_System_1989", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=58 +lon_0=19.5 +k=1 +x_0=100000 +y_0=");
    add_proj4text (p, 1,
        "1000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no");
    add_proj4text (p, 2,
        "_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"ETRS89 / NTM zone 19\",GEOGCS[\"ETRS89\",DATUM[");
    add_srs_wkt (p, 1,
        "\"European_Terrestrial_Reference_System_1989\",SPHEROID[");
    add_srs_wkt (p, 2,
        "\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 3,
        "7019\"]],AUTHORITY[\"EPSG\",\"6258\"]],PRIMEM[\"Greenwic");
    add_srs_wkt (p, 4,
        "h\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01");
    add_srs_wkt (p, 5,
        "74532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"4258\"]],PROJECTION[\"Transverse_Mercator\"],PA");
    add_srs_wkt (p, 7,
        "RAMETER[\"latitude_of_origin\",58],PARAMETER[\"central_m");
    add_srs_wkt (p, 8,
        "eridian\",19.5],PARAMETER[\"scale_factor\",1],PARAMETER[");
    add_srs_wkt (p, 9,
        "\"false_easting\",100000],PARAMETER[\"false_northing\",1");
    add_srs_wkt (p, 10,
        "000000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],A");
    add_srs_wkt (p, 11,
        "XIS[\"Northing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY");
    add_srs_wkt (p, 12,
        "[\"EPSG\",\"5119\"]]");
    p = add_epsg_def_ex (filter, first, last, 5120, "epsg", 5120,
        "ETRS89 / NTM zone 20", 0, 1,
        "GRS 1980", "Greenwich",
        "European_Terrestrial_Reference_System_1989", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=58 +lon_0=20.5 +k=1 +x_0=100000 +y_0=");
    add_proj4text (p, 1,
        "1000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no");
    add_proj4text (p, 2,
        "_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"ETRS89 / NTM zone 20\",GEOGCS[\"ETRS89\",DATUM[");
    add_srs_wkt (p, 1,
        "\"European_Terrestrial_Reference_System_1989\",SPHEROID[");
    add_srs_wkt (p, 2,
        "\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 3,
        "7019\"]],AUTHORITY[\"EPSG\",\"6258\"]],PRIMEM[\"Greenwic");
    add_srs_wkt (p, 4,
        "h\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01");
    add_srs_wkt (p, 5,
        "74532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"4258\"]],PROJECTION[\"Transverse_Mercator\"],PA");
    add_srs_wkt (p, 7,
        "RAMETER[\"latitude_of_origin\",58],PARAMETER[\"central_m");
    add_srs_wkt (p, 8,
        "eridian\",20.5],PARAMETER[\"scale_factor\",1],PARAMETER[");
    add_srs_wkt (p, 9,
        "\"false_easting\",100000],PARAMETER[\"false_northing\",1");
    add_srs_wkt (p, 10,
        "000000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],A");
    add_srs_wkt (p, 11,
        "XIS[\"Northing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY");
    add_srs_wkt (p, 12,
        "[\"EPSG\",\"5120\"]]");
    p = add_epsg_def_ex (filter, first, last, 5121, "epsg", 5121,
        "ETRS89 / NTM zone 21", 0, 1,
        "GRS 1980", "Greenwich",
        "European_Terrestrial_Reference_System_1989", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=58 +lon_0=21.5 +k=1 +x_0=100000 +y_0=");
    add_proj4text (p, 1,
        "1000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no");
    add_proj4text (p, 2,
        "_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"ETRS89 / NTM zone 21\",GEOGCS[\"ETRS89\",DATUM[");
    add_srs_wkt (p, 1,
        "\"European_Terrestrial_Reference_System_1989\",SPHEROID[");
    add_srs_wkt (p, 2,
        "\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 3,
        "7019\"]],AUTHORITY[\"EPSG\",\"6258\"]],PRIMEM[\"Greenwic");
    add_srs_wkt (p, 4,
        "h\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01");
    add_srs_wkt (p, 5,
        "74532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"4258\"]],PROJECTION[\"Transverse_Mercator\"],PA");
    add_srs_wkt (p, 7,
        "RAMETER[\"latitude_of_origin\",58],PARAMETER[\"central_m");
    add_srs_wkt (p, 8,
        "eridian\",21.5],PARAMETER[\"scale_factor\",1],PARAMETER[");
    add_srs_wkt (p, 9,
        "\"false_easting\",100000],PARAMETER[\"false_northing\",1");
    add_srs_wkt (p, 10,
        "000000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],A");
    add_srs_wkt (p, 11,
        "XIS[\"Northing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY");
    add_srs_wkt (p, 12,
        "[\"EPSG\",\"5121\"]]");
    p = add_epsg_def_ex (filter, first, last, 5122, "epsg", 5122,
        "ETRS89 / NTM zone 22", 0, 1,
        "GRS 1980", "Greenwich",
        "European_Terrestrial_Reference_System_1989", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=58 +lon_0=22.5 +k=1 +x_0=100000 +y_0=");
    add_proj4text (p, 1,
        "1000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no");
    add_proj4text (p, 2,
        "_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"ETRS89 / NTM zone 22\",GEOGCS[\"ETRS89\",DATUM[");
    add_srs_wkt (p, 1,
        "\"European_Terrestrial_Reference_System_1989\",SPHEROID[");
    add_srs_wkt (p, 2,
        "\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 3,
        "7019\"]],AUTHORITY[\"EPSG\",\"6258\"]],PRIMEM[\"Greenwic");
    add_srs_wkt (p, 4,
        "h\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01");
    add_srs_wkt (p, 5,
        "74532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"4258\"]],PROJECTION[\"Transverse_Mercator\"],PA");
    add_srs_wkt (p, 7,
        "RAMETER[\"latitude_of_origin\",58],PARAMETER[\"central_m");
    add_srs_wkt (p, 8,
        "eridian\",22.5],PARAMETER[\"scale_factor\",1],PARAMETER[");
    add_srs_wkt (p, 9,
        "\"false_easting\",100000],PARAMETER[\"false_northing\",1");
    add_srs_wkt (p, 10,
        "000000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],A");
    add_srs_wkt (p, 11,
        "XIS[\"Northing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY");
    add_srs_wkt (p, 12,
        "[\"EPSG\",\"5122\"]]");
    p = add_epsg_def_ex (filter, first, last, 5123, "epsg", 5123,
        "ETRS89 / NTM zone 23", 0, 1,
        "GRS 1980", "Greenwich",
        "European_Terrestrial_Reference_System_1989", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=58 +lon_0=23.5 +k=1 +x_0=100000 +y_0=");
    add_proj4text (p, 1,
        "1000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no");
    add_proj4text (p, 2,
        "_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"ETRS89 / NTM zone 23\",GEOGCS[\"ETRS89\",DATUM[");
    add_srs_wkt (p, 1,
        "\"European_Terrestrial_Reference_System_1989\",SPHEROID[");
    add_srs_wkt (p, 2,
        "\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 3,
        "7019\"]],AUTHORITY[\"EPSG\",\"6258\"]],PRIMEM[\"Greenwic");
    add_srs_wkt (p, 4,
        "h\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01");
    add_srs_wkt (p, 5,
        "74532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"4258\"]],PROJECTION[\"Transverse_Mercator\"],PA");
    add_srs_wkt (p, 7,
        "RAMETER[\"latitude_of_origin\",58],PARAMETER[\"central_m");
    add_srs_wkt (p, 8,
        "eridian\",23.5],PARAMETER[\"scale_factor\",1],PARAMETER[");
    add_srs_wkt (p, 9,
        "\"false_easting\",100000],PARAMETER[\"false_northing\",1");
    add_srs_wkt (p, 10,
        "000000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],A");
    add_srs_wkt (p, 11,
        "XIS[\"Northing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY");
    add_srs_wkt (p, 12,
        "[\"EPSG\",\"5123\"]]");
    p = add_epsg_def_ex (filter, first, last, 5124, "epsg", 5124,
        "ETRS89 / NTM zone 24", 0, 1,
        "GRS 1980", "Greenwich",
        "European_Terrestrial_Reference_System_1989", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=58 +lon_0=24.5 +k=1 +x_0=100000 +y_0=");
    add_proj4text (p, 1,
        "1000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no");
    add_proj4text (p, 2,
        "_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"ETRS89 / NTM zone 24\",GEOGCS[\"ETRS89\",DATUM[");
    add_srs_wkt (p, 1,
        "\"European_Terrestrial_Reference_System_1989\",SPHEROID[");
    add_srs_wkt (p, 2,
        "\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 3,
        "7019\"]],AUTHORITY[\"EPSG\",\"6258\"]],PRIMEM[\"Greenwic");
    add_srs_wkt (p, 4,
        "h\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01");
    add_srs_wkt (p, 5,
        "74532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"4258\"]],PROJECTION[\"Transverse_Mercator\"],PA");
    add_srs_wkt (p, 7,
        "RAMETER[\"latitude_of_origin\",58],PARAMETER[\"central_m");
    add_srs_wkt (p, 8,
        "eridian\",24.5],PARAMETER[\"scale_factor\",1],PARAMETER[");
    add_srs_wkt (p, 9,
        "\"false_easting\",100000],PARAMETER[\"false_northing\",1");
    add_srs_wkt (p, 10,
        "000000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],A");
    add_srs_wkt (p, 11,
        "XIS[\"Northing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY");
    add_srs_wkt (p, 12,
        "[\"EPSG\",\"5124\"]]");
    p = add_epsg_def_ex (filter, first, last, 5125, "epsg", 5125,
        "ETRS89 / NTM zone 25", 0, 1,
        "GRS 1980", "Greenwich",
        "European_Terrestrial_Reference_System_1989", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=58 +lon_0=25.5 +k=1 +x_0=100000 +y_0=");
    add_proj4text (p, 1,
        "1000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no");
    add_proj4text (p, 2,
        "_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"ETRS89 / NTM zone 25\",GEOGCS[\"ETRS89\",DATUM[");
    add_srs_wkt (p, 1,
        "\"European_Terrestrial_Reference_System_1989\",SPHEROID[");
    add_srs_wkt (p, 2,
        "\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 3,
        "7019\"]],AUTHORITY[\"EPSG\",\"6258\"]],PRIMEM[\"Greenwic");
    add_srs_wkt (p, 4,
        "h\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01");
    add_srs_wkt (p, 5,
        "74532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"4258\"]],PROJECTION[\"Transverse_Mercator\"],PA");
    add_srs_wkt (p, 7,
        "RAMETER[\"latitude_of_origin\",58],PARAMETER[\"central_m");
    add_srs_wkt (p, 8,
        "eridian\",25.5],PARAMETER[\"scale_factor\",1],PARAMETER[");
    add_srs_wkt (p, 9,
        "\"false_easting\",100000],PARAMETER[\"false_northing\",1");
    add_srs_wkt (p, 10,
        "000000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],A");
    add_srs_wkt (p, 11,
        "XIS[\"Northing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY");
    add_srs_wkt (p, 12,
        "[\"EPSG\",\"5125\"]]");
    p = add_epsg_def_ex (filter, first, last, 5126, "epsg", 5126,
        "ETRS89 / NTM zone 26", 0, 1,
        "GRS 1980", "Greenwich",
        "European_Terrestrial_Reference_System_1989", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=58 +lon_0=26.5 +k=1 +x_0=100000 +y_0=");
    add_proj4text (p, 1,
        "1000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no");
    add_proj4text (p, 2,
        "_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"ETRS89 / NTM zone 26\",GEOGCS[\"ETRS89\",DATUM[");
    add_srs_wkt (p, 1,
        "\"European_Terrestrial_Reference_System_1989\",SPHEROID[");
    add_srs_wkt (p, 2,
        "\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 3,
        "7019\"]],AUTHORITY[\"EPSG\",\"6258\"]],PRIMEM[\"Greenwic");
    add_srs_wkt (p, 4,
        "h\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01");
    add_srs_wkt (p, 5,
        "74532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"4258\"]],PROJECTION[\"Transverse_Mercator\"],PA");
    add_srs_wkt (p, 7,
        "RAMETER[\"latitude_of_origin\",58],PARAMETER[\"central_m");
    add_srs_wkt (p, 8,
        "eridian\",26.5],PARAMETER[\"scale_factor\",1],PARAMETER[");
    add_srs_wkt (p, 9,
        "\"false_easting\",100000],PARAMETER[\"false_northing\",1");
    add_srs_wkt (p, 10,
        "000000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],A");
    add_srs_wkt (p, 11,
        "XIS[\"Northing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY");
    add_srs_wkt (p, 12,
        "[\"EPSG\",\"5126\"]]");
    p = add_epsg_def_ex (filter, first, last, 5127, "epsg", 5127,
        "ETRS89 / NTM zone 27", 0, 1,
        "GRS 1980", "Greenwich",
        "European_Terrestrial_Reference_System_1989", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=58 +lon_0=27.5 +k=1 +x_0=100000 +y_0=");
    add_proj4text (p, 1,
        "1000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no");
    add_proj4text (p, 2,
        "_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"ETRS89 / NTM zone 27\",GEOGCS[\"ETRS89\",DATUM[");
    add_srs_wkt (p, 1,
        "\"European_Terrestrial_Reference_System_1989\",SPHEROID[");
    add_srs_wkt (p, 2,
        "\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 3,
        "7019\"]],AUTHORITY[\"EPSG\",\"6258\"]],PRIMEM[\"Greenwic");
    add_srs_wkt (p, 4,
        "h\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01");
    add_srs_wkt (p, 5,
        "74532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"4258\"]],PROJECTION[\"Transverse_Mercator\"],PA");
    add_srs_wkt (p, 7,
        "RAMETER[\"latitude_of_origin\",58],PARAMETER[\"central_m");
    add_srs_wkt (p, 8,
        "eridian\",27.5],PARAMETER[\"scale_factor\",1],PARAMETER[");
    add_srs_wkt (p, 9,
        "\"false_easting\",100000],PARAMETER[\"false_northing\",1");
    add_srs_wkt (p, 10,
        "000000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],A");
    add_srs_wkt (p, 11,
        "XIS[\"Northing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY");
    add_srs_wkt (p, 12,
        "[\"EPSG\",\"5127\"]]");
    p = add_epsg_def_ex (filter, first, last, 5128, "epsg", 5128,
        "ETRS89 / NTM zone 28", 0, 1,
        "GRS 1980", "Greenwich",
        "European_Terrestrial_Reference_System_1989", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=58 +lon_0=28.5 +k=1 +x_0=100000 +y_0=");
    add_proj4text (p, 1,
        "1000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no");
    add_proj4text (p, 2,
        "_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"ETRS89 / NTM zone 28\",GEOGCS[\"ETRS89\",DATUM[");
    add_srs_wkt (p, 1,
        "\"European_Terrestrial_Reference_System_1989\",SPHEROID[");
    add_srs_wkt (p, 2,
        "\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 3,
        "7019\"]],AUTHORITY[\"EPSG\",\"6258\"]],PRIMEM[\"Greenwic");
    add_srs_wkt (p, 4,
        "h\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01");
    add_srs_wkt (p, 5,
        "74532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"4258\"]],PROJECTION[\"Transverse_Mercator\"],PA");
    add_srs_wkt (p, 7,
        "RAMETER[\"latitude_of_origin\",58],PARAMETER[\"central_m");
    add_srs_wkt (p, 8,
        "eridian\",28.5],PARAMETER[\"scale_factor\",1],PARAMETER[");
    add_srs_wkt (p, 9,
        "\"false_easting\",100000],PARAMETER[\"false_northing\",1");
    add_srs_wkt (p, 10,
        "000000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],A");
    add_srs_wkt (p, 11,
        "XIS[\"Northing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY");
    add_srs_wkt (p, 12,
        "[\"EPSG\",\"5128\"]]");
    p = add_epsg_def_ex (filter, first, last, 5129, "epsg", 5129,
        "ETRS89 / NTM zone 29", 0, 1,
        "GRS 1980", "Greenwich",
        "European_Terrestrial_Reference_System_1989", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=58 +lon_0=29.5 +k=1 +x_0=100000 +y_0=");
    add_proj4text (p, 1,
        "1000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no");
    add_proj4text (p, 2,
        "_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"ETRS89 / NTM zone 29\",GEOGCS[\"ETRS89\",DATUM[");
    add_srs_wkt (p, 1,
        "\"European_Terrestrial_Reference_System_1989\",SPHEROID[");
    add_srs_wkt (p, 2,
        "\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 3,
        "7019\"]],AUTHORITY[\"EPSG\",\"6258\"]],PRIMEM[\"Greenwic");
    add_srs_wkt (p, 4,
        "h\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01");
    add_srs_wkt (p, 5,
        "74532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"4258\"]],PROJECTION[\"Transverse_Mercator\"],PA");
    add_srs_wkt (p, 7,
        "RAMETER[\"latitude_of_origin\",58],PARAMETER[\"central_m");
    add_srs_wkt (p, 8,
        "eridian\",29.5],PARAMETER[\"scale_factor\",1],PARAMETER[");
    add_srs_wkt (p, 9,
        "\"false_easting\",100000],PARAMETER[\"false_northing\",1");
    add_srs_wkt (p, 10,
        "000000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],A");
    add_srs_wkt (p, 11,
        "XIS[\"Northing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY");
    add_srs_wkt (p, 12,
        "[\"EPSG\",\"5129\"]]");
    p = add_epsg_def_ex (filter, first, last, 5130, "epsg", 5130,
        "ETRS89 / NTM zone 30", 0, 1,
        "GRS 1980", "Greenwich",
        "European_Terrestrial_Reference_System_1989", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=58 +lon_0=30.5 +k=1 +x_0=100000 +y_0=");
    add_proj4text (p, 1,
        "1000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no");
    add_proj4text (p, 2,
        "_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"ETRS89 / NTM zone 30\",GEOGCS[\"ETRS89\",DATUM[");
    add_srs_wkt (p, 1,
        "\"European_Terrestrial_Reference_System_1989\",SPHEROID[");
    add_srs_wkt (p, 2,
        "\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 3,
        "7019\"]],AUTHORITY[\"EPSG\",\"6258\"]],PRIMEM[\"Greenwic");
    add_srs_wkt (p, 4,
        "h\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01");
    add_srs_wkt (p, 5,
        "74532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"4258\"]],PROJECTION[\"Transverse_Mercator\"],PA");
    add_srs_wkt (p, 7,
        "RAMETER[\"latitude_of_origin\",58],PARAMETER[\"central_m");
    add_srs_wkt (p, 8,
        "eridian\",30.5],PARAMETER[\"scale_factor\",1],PARAMETER[");
    add_srs_wkt (p, 9,
        "\"false_easting\",100000],PARAMETER[\"false_northing\",1");
    add_srs_wkt (p, 10,
        "000000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],A");
    add_srs_wkt (p, 11,
        "XIS[\"Northing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY");
    add_srs_wkt (p, 12,
        "[\"EPSG\",\"5130\"]]");
    p = add_epsg_def_ex (filter, first, last, 5132, "epsg", 5132,
        "Tokyo 1892", 1, 1,
        "Bessel 1841", "Greenwich",
        "Tokyo_1892", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=bessel +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Tokyo 1892\",DATUM[\"Tokyo_1892\",SPHEROID[\"Be");
    add_srs_wkt (p, 1,
        "ssel 1841\",6377397.155,299.1528128,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 2,
        "7004\"]],AUTHORITY[\"EPSG\",\"1048\"]],PRIMEM[\"Greenwic");
    add_srs_wkt (p, 3,
        "h\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01");
    add_srs_wkt (p, 4,
        "74532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Lati");
    add_srs_wkt (p, 5,
        "tude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"5132\"]]");
    p = add_epsg_def_ex (filter, first, last, 5167, "epsg", 5167,
        "Korean 1985 / East Sea Belt", 0, 1,
        "Bessel 1841", "Greenwich",
        "Korean_Datum_1985", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=38 +lon_0=131 +k=1 +x_0=200000 +y_0=5");
    add_proj4text (p, 1,
        "00000 +ellps=bessel +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Korean 1985 / East Sea Belt\",GEOGCS[\"Korean 1");
    add_srs_wkt (p, 1,
        "985\",DATUM[\"Korean_Datum_1985\",SPHEROID[\"Bessel 1841");
    add_srs_wkt (p, 2,
        "\",6377397.155,299.1528128,AUTHORITY[\"EPSG\",\"7004\"]]");
    add_srs_wkt (p, 3,
        ",AUTHORITY[\"EPSG\",\"6162\"]],PRIMEM[\"Greenwich\",0,AU");
    add_srs_wkt (p, 4,
        "THORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925");
    add_srs_wkt (p, 5,
        "199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 6,
        "\"4162\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER");
    add_srs_wkt (p, 7,
        "[\"latitude_of_origin\",38],PARAMETER[\"central_meridian");
    add_srs_wkt (p, 8,
        "\",131],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_");
    add_srs_wkt (p, 9,
        "easting\",200000],PARAMETER[\"false_northing\",500000],U");
    add_srs_wkt (p, 10,
        "NIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Nor");
    add_srs_wkt (p, 11,
        "thing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 12,
        ",\"5167\"]]");
    p = add_epsg_def_ex (filter, first, last, 5168, "epsg", 5168,
        "Korean 1985 / Central Belt Jeju", 0, 1,
        "Bessel 1841", "Greenwich",
        "Korean_Datum_1985", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=38 +lon_0=127 +k=1 +x_0=200000 +y_0=5");
    add_proj4text (p, 1,
        "50000 +ellps=bessel +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Korean 1985 / Central Belt Jeju\",GEOGCS[\"Kore");
    add_srs_wkt (p, 1,
        "an 1985\",DATUM[\"Korean_Datum_1985\",SPHEROID[\"Bessel ");
    add_srs_wkt (p, 2,
        "1841\",6377397.155,299.1528128,AUTHORITY[\"EPSG\",\"7004");
    add_srs_wkt (p, 3,
        "\"]],AUTHORITY[\"EPSG\",\"6162\"]],PRIMEM[\"Greenwich\",");
    add_srs_wkt (p, 4,
        "0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453");
    add_srs_wkt (p, 5,
        "2925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPS");
    add_srs_wkt (p, 6,
        "G\",\"4162\"]],PROJECTION[\"Transverse_Mercator\"],PARAM");
    add_srs_wkt (p, 7,
        "ETER[\"latitude_of_origin\",38],PARAMETER[\"central_meri");
    add_srs_wkt (p, 8,
        "dian\",127],PARAMETER[\"scale_factor\",1],PARAMETER[\"fa");
    add_srs_wkt (p, 9,
        "lse_easting\",200000],PARAMETER[\"false_northing\",55000");
    add_srs_wkt (p, 10,
        "0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"");
    add_srs_wkt (p, 11,
        "Northing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPS");
    add_srs_wkt (p, 12,
        "G\",\"5168\"]]");
    p = add_epsg_def_ex (filter, first, last, 5169, "epsg", 5169,
        "Tokyo 1892 / Korea West Belt", 0, 1,
        "Bessel 1841", "Greenwich",
        "Tokyo_1892", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=38 +lon_0=125 +k=1 +x_0=200000 +y_0=5");
    add_proj4text (p, 1,
        "00000 +ellps=bessel +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Tokyo 1892 / Korea West Belt\",GEOGCS[\"Tokyo 1");
    add_srs_wkt (p, 1,
        "892\",DATUM[\"Tokyo_1892\",SPHEROID[\"Bessel 1841\",6377");
    add_srs_wkt (p, 2,
        "397.155,299.1528128,AUTHORITY[\"EPSG\",\"7004\"]],AUTHOR");
    add_srs_wkt (p, 3,
        "ITY[\"EPSG\",\"1048\"]],PRIMEM[\"Greenwich\",0,AUTHORITY");
    add_srs_wkt (p, 4,
        "[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,");
    add_srs_wkt (p, 5,
        "AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"5132\"");
    add_srs_wkt (p, 6,
        "]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latit");
    add_srs_wkt (p, 7,
        "ude_of_origin\",38],PARAMETER[\"central_meridian\",125],");
    add_srs_wkt (p, 8,
        "PARAMETER[\"scale_factor\",1],PARAMETER[\"false_easting\"");
    add_srs_wkt (p, 9,
        ",200000],PARAMETER[\"false_northing\",500000],UNIT[\"met");
    add_srs_wkt (p, 10,
        "re\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",N");
    add_srs_wkt (p, 11,
        "ORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"5169\"");
    add_srs_wkt (p, 12,
        "]]");
    p = add_epsg_def_ex (filter, first, last, 5170, "epsg", 5170,
        "Tokyo 1892 / Korea Central Belt", 0, 1,
        "Bessel 1841", "Greenwich",
        "Tokyo_1892", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=38 +lon_0=127 +k=1 +x_0=200000 +y_0=5");
    add_proj4text (p, 1,
        "00000 +ellps=bessel +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Tokyo 1892 / Korea Central Belt\",GEOGCS[\"Toky");
    add_srs_wkt (p, 1,
        "o 1892\",DATUM[\"Tokyo_1892\",SPHEROID[\"Bessel 1841\",6");
    add_srs_wkt (p, 2,
        "377397.155,299.1528128,AUTHORITY[\"EPSG\",\"7004\"]],AUT");
    add_srs_wkt (p, 3,
        "HORITY[\"EPSG\",\"1048\"]],PRIMEM[\"Greenwich\",0,AUTHOR");
    add_srs_wkt (p, 4,
        "ITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251994");
    add_srs_wkt (p, 5,
        "33,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"51");
    add_srs_wkt (p, 6,
        "32\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"l");
    add_srs_wkt (p, 7,
        "atitude_of_origin\",38],PARAMETER[\"central_meridian\",1");
    add_srs_wkt (p, 8,
        "27],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_east");
    add_srs_wkt (p, 9,
        "ing\",200000],PARAMETER[\"false_northing\",500000],UNIT[");
    add_srs_wkt (p, 10,
        "\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northin");
    add_srs_wkt (p, 11,
        "g\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"5");
    add_srs_wkt (p, 12,
        "170\"]]");
    p = add_epsg_def_ex (filter, first, last, 5171, "epsg", 5171,
        "Tokyo 1892 / Korea East Belt", 0, 1,
        "Bessel 1841", "Greenwich",
        "Tokyo_1892", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=38 +lon_0=129 +k=1 +x_0=200000 +y_0=5");
    add_proj4text (p, 1,
        "00000 +ellps=bessel +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Tokyo 1892 / Korea East Belt\",GEOGCS[\"Tokyo 1");
    add_srs_wkt (p, 1,
        "892\",DATUM[\"Tokyo_1892\",SPHEROID[\"Bessel 1841\",6377");
    add_srs_wkt (p, 2,
        "397.155,299.1528128,AUTHORITY[\"EPSG\",\"7004\"]],AUTHOR");
    add_srs_wkt (p, 3,
        "ITY[\"EPSG\",\"1048\"]],PRIMEM[\"Greenwich\",0,AUTHORITY");
    add_srs_wkt (p, 4,
        "[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,");
    add_srs_wkt (p, 5,
        "AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"5132\"");
    add_srs_wkt (p, 6,
        "]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latit");
    add_srs_wkt (p, 7,
        "ude_of_origin\",38],PARAMETER[\"central_meridian\",129],");
    add_srs_wkt (p, 8,
        "PARAMETER[\"scale_factor\",1],PARAMETER[\"false_easting\"");
    add_srs_wkt (p, 9,
        ",200000],PARAMETER[\"false_northing\",500000],UNIT[\"met");
    add_srs_wkt (p, 10,
        "re\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",N");
    add_srs_wkt (p, 11,
        "ORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"5171\"");
    add_srs_wkt (p, 12,
        "]]");
    p = add_epsg_def_ex (filter, first, last, 5172, "epsg", 5172,
        "Tokyo 1892 / Korea East Sea Belt", 0, 1,
        "Bessel 1841", "Greenwich",
        "Tokyo_1892", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=38 +lon_0=131 +k=1 +x_0=200000 +y_0=5");
    add_proj4text (p, 1,
        "00000 +ellps=bessel +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Tokyo 1892 / Korea East Sea Belt\",GEOGCS[\"Tok");
    add_srs_wkt (p, 1,
        "yo 1892\",DATUM[\"Tokyo_1892\",SPHEROID[\"Bessel 1841\",");
    add_srs_wkt (p, 2,
        "6377397.155,299.1528128,AUTHORITY[\"EPSG\",\"7004\"]],AU");
    add_srs_wkt (p, 3,
        "THORITY[\"EPSG\",\"1048\"]],PRIMEM[\"Greenwich\",0,AUTHO");
    add_srs_wkt (p, 4,
        "RITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199");
    add_srs_wkt (p, 5,
        "433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"5");
    add_srs_wkt (p, 6,
        "132\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",38],PARAMETER[\"central_meridian\",");
    add_srs_wkt (p, 8,
        "131],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_eas");
    add_srs_wkt (p, 9,
        "ting\",200000],PARAMETER[\"false_northing\",500000],UNIT");
    add_srs_wkt (p, 10,
        "[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northi");
    add_srs_wkt (p, 11,
        "ng\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 12,
        "5172\"]]");
    p = add_epsg_def_ex (filter, first, last, 5173, "epsg", 5173,
        "Korean 1985 / Modified West Belt", 0, 1,
        "Bessel 1841", "Greenwich",
        "Korean_Datum_1985", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=38 +lon_0=125.0028902777778 +k=1 +x_0");
    add_proj4text (p, 1,
        "=200000 +y_0=500000 +ellps=bessel +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Korean 1985 / Modified West Belt\",GEOGCS[\"Kor");
    add_srs_wkt (p, 1,
        "ean 1985\",DATUM[\"Korean_Datum_1985\",SPHEROID[\"Bessel");
    add_srs_wkt (p, 2,
        " 1841\",6377397.155,299.1528128,AUTHORITY[\"EPSG\",\"700");
    add_srs_wkt (p, 3,
        "4\"]],AUTHORITY[\"EPSG\",\"6162\"]],PRIMEM[\"Greenwich\"");
    add_srs_wkt (p, 4,
        ",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745");
    add_srs_wkt (p, 5,
        "32925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EP");
    add_srs_wkt (p, 6,
        "SG\",\"4162\"]],PROJECTION[\"Transverse_Mercator\"],PARA");
    add_srs_wkt (p, 7,
        "METER[\"latitude_of_origin\",38],PARAMETER[\"central_mer");
    add_srs_wkt (p, 8,
        "idian\",125.002890277778],PARAMETER[\"scale_factor\",1],");
    add_srs_wkt (p, 9,
        "PARAMETER[\"false_easting\",200000],PARAMETER[\"false_no");
    add_srs_wkt (p, 10,
        "rthing\",500000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9");
    add_srs_wkt (p, 11,
        "001\"]],AXIS[\"Northing\",NORTH],AXIS[\"Easting\",EAST],");
    add_srs_wkt (p, 12,
        "AUTHORITY[\"EPSG\",\"5173\"]]");
    p = add_epsg_def_ex (filter, first, last, 5174, "epsg", 5174,
        "Korean 1985 / Modified Central Belt", 0, 1,
        "Bessel 1841", "Greenwich",
        "Korean_Datum_1985", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=38 +lon_0=127.0028902777778 +k=1 +x_0");
    add_proj4text (p, 1,
        "=200000 +y_0=500000 +ellps=bessel +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Korean 1985 / Modified Central Belt\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "Korean 1985\",DATUM[\"Korean_Datum_1985\",SPHEROID[\"Bes");
    add_srs_wkt (p, 2,
        "sel 1841\",6377397.155,299.1528128,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 3,
        "7004\"]],AUTHORITY[\"EPSG\",\"6162\"]],PRIMEM[\"Greenwic");
    add_srs_wkt (p, 4,
        "h\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01");
    add_srs_wkt (p, 5,
        "74532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"4162\"]],PROJECTION[\"Transverse_Mercator\"],PA");
    add_srs_wkt (p, 7,
        "RAMETER[\"latitude_of_origin\",38],PARAMETER[\"central_m");
    add_srs_wkt (p, 8,
        "eridian\",127.002890277778],PARAMETER[\"scale_factor\",1");
    add_srs_wkt (p, 9,
        "],PARAMETER[\"false_easting\",200000],PARAMETER[\"false_");
    add_srs_wkt (p, 10,
        "northing\",500000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 11,
        "9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"Easting\",EAST]");
    add_srs_wkt (p, 12,
        ",AUTHORITY[\"EPSG\",\"5174\"]]");
    p = add_epsg_def_ex (filter, first, last, 5175, "epsg", 5175,
        "Korean 1985 / Modified Central Belt Jeju", 0, 1,
        "Bessel 1841", "Greenwich",
        "Korean_Datum_1985", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=38 +lon_0=127.0028902777778 +k=1 +x_0");
    add_proj4text (p, 1,
        "=200000 +y_0=550000 +ellps=bessel +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Korean 1985 / Modified Central Belt Jeju\",GEOG");
    add_srs_wkt (p, 1,
        "CS[\"Korean 1985\",DATUM[\"Korean_Datum_1985\",SPHEROID[");
    add_srs_wkt (p, 2,
        "\"Bessel 1841\",6377397.155,299.1528128,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 3,
        "\",\"7004\"]],AUTHORITY[\"EPSG\",\"6162\"]],PRIMEM[\"Gre");
    add_srs_wkt (p, 4,
        "enwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\"");
    add_srs_wkt (p, 5,
        ",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHOR");
    add_srs_wkt (p, 6,
        "ITY[\"EPSG\",\"4162\"]],PROJECTION[\"Transverse_Mercator");
    add_srs_wkt (p, 7,
        "\"],PARAMETER[\"latitude_of_origin\",38],PARAMETER[\"cen");
    add_srs_wkt (p, 8,
        "tral_meridian\",127.002890277778],PARAMETER[\"scale_fact");
    add_srs_wkt (p, 9,
        "or\",1],PARAMETER[\"false_easting\",200000],PARAMETER[\"");
    add_srs_wkt (p, 10,
        "false_northing\",550000],UNIT[\"metre\",1,AUTHORITY[\"EP");
    add_srs_wkt (p, 11,
        "SG\",\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"Easting\"");
    add_srs_wkt (p, 12,
        ",EAST],AUTHORITY[\"EPSG\",\"5175\"]]");
    p = add_epsg_def_ex (filter, first, last, 5176, "epsg", 5176,
        "Korean 1985 / Modified East Belt", 0, 1,
        "Bessel 1841", "Greenwich",
        "Korean_Datum_1985", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=38 +lon_0=129.0028902777778 +k=1 +x_0");
    add_proj4text (p, 1,
        "=200000 +y_0=500000 +ellps=bessel +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Korean 1985 / Modified East Belt\",GEOGCS[\"Kor");
    add_srs_wkt (p, 1,
        "ean 1985\",DATUM[\"Korean_Datum_1985\",SPHEROID[\"Bessel");
    add_srs_wkt (p, 2,
        " 1841\",6377397.155,299.1528128,AUTHORITY[\"EPSG\",\"700");
    add_srs_wkt (p, 3,
        "4\"]],AUTHORITY[\"EPSG\",\"6162\"]],PRIMEM[\"Greenwich\"");
    add_srs_wkt (p, 4,
        ",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745");
    add_srs_wkt (p, 5,
        "32925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EP");
    add_srs_wkt (p, 6,
        "SG\",\"4162\"]],PROJECTION[\"Transverse_Mercator\"],PARA");
    add_srs_wkt (p, 7,
        "METER[\"latitude_of_origin\",38],PARAMETER[\"central_mer");
    add_srs_wkt (p, 8,
        "idian\",129.002890277778],PARAMETER[\"scale_factor\",1],");
    add_srs_wkt (p, 9,
        "PARAMETER[\"false_easting\",200000],PARAMETER[\"false_no");
    add_srs_wkt (p, 10,
        "rthing\",500000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9");
    add_srs_wkt (p, 11,
        "001\"]],AXIS[\"Northing\",NORTH],AXIS[\"Easting\",EAST],");
    add_srs_wkt (p, 12,
        "AUTHORITY[\"EPSG\",\"5176\"]]");
    p = add_epsg_def_ex (filter, first, last, 5177, "epsg", 5177,
        "Korean 1985 / Modified East Sea Belt", 0, 1,
        "Bessel 1841", "Greenwich",
        "Korean_Datum_1985", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=38 +lon_0=131.0028902777778 +k=1 +x_0");
    add_proj4text (p, 1,
        "=200000 +y_0=500000 +ellps=bessel +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Korean 1985 / Modified East Sea Belt\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "Korean 1985\",DATUM[\"Korean_Datum_1985\",SPHEROID[\"Bes");
    add_srs_wkt (p, 2,
        "sel 1841\",6377397.155,299.1528128,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 3,
        "7004\"]],AUTHORITY[\"EPSG\",\"6162\"]],PRIMEM[\"Greenwic");
    add_srs_wkt (p, 4,
        "h\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01");
    add_srs_wkt (p, 5,
        "74532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"4162\"]],PROJECTION[\"Transverse_Mercator\"],PA");
    add_srs_wkt (p, 7,
        "RAMETER[\"latitude_of_origin\",38],PARAMETER[\"central_m");
    add_srs_wkt (p, 8,
        "eridian\",131.002890277778],PARAMETER[\"scale_factor\",1");
    add_srs_wkt (p, 9,
        "],PARAMETER[\"false_easting\",200000],PARAMETER[\"false_");
    add_srs_wkt (p, 10,
        "northing\",500000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 11,
        "9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"Easting\",EAST]");
    add_srs_wkt (p, 12,
        ",AUTHORITY[\"EPSG\",\"5177\"]]");
    p = add_epsg_def_ex (filter, first, last, 5178, "epsg", 5178,
        "Korean 1985 / Unified CS", 0, 1,
        "Bessel 1841", "Greenwich",
        "Korean_Datum_1985", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=38 +lon_0=127.5 +k=0.9996 +x_0=100000");
    add_proj4text (p, 1,
        "0 +y_0=2000000 +ellps=bessel +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Korean 1985 / Unified CS\",GEOGCS[\"Korean 1985");
    add_srs_wkt (p, 1,
        "\",DATUM[\"Korean_Datum_1985\",SPHEROID[\"Bessel 1841\",");
    add_srs_wkt (p, 2,
        "6377397.155,299.1528128,AUTHORITY[\"EPSG\",\"7004\"]],AU");
    add_srs_wkt (p, 3,
        "THORITY[\"EPSG\",\"6162\"]],PRIMEM[\"Greenwich\",0,AUTHO");
    add_srs_wkt (p, 4,
        "RITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199");
    add_srs_wkt (p, 5,
        "433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4");
    add_srs_wkt (p, 6,
        "162\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",38],PARAMETER[\"central_meridian\",");
    add_srs_wkt (p, 8,
        "127.5],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"fa");
    add_srs_wkt (p, 9,
        "lse_easting\",1000000],PARAMETER[\"false_northing\",2000");
    add_srs_wkt (p, 10,
        "000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS");
    add_srs_wkt (p, 11,
        "[\"Northing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"");
    add_srs_wkt (p, 12,
        "EPSG\",\"5178\"]]");
    p = add_epsg_def_ex (filter, first, last, 5179, "epsg", 5179,
        "Korea 2000 / Unified CS", 0, 1,
        "GRS 1980", "Greenwich",
        "Geocentric_datum_of_Korea", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=38 +lon_0=127.5 +k=0.9996 +x_0=100000");
    add_proj4text (p, 1,
        "0 +y_0=2000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +unit");
    add_proj4text (p, 2,
        "s=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Korea 2000 / Unified CS\",GEOGCS[\"Korea 2000\"");
    add_srs_wkt (p, 1,
        ",DATUM[\"Geocentric_datum_of_Korea\",SPHEROID[\"GRS 1980");
    add_srs_wkt (p, 2,
        "\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"6737\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 4,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 5,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4737\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",38],PARAMETER[\"central_meridian\",");
    add_srs_wkt (p, 8,
        "127.5],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"fa");
    add_srs_wkt (p, 9,
        "lse_easting\",1000000],PARAMETER[\"false_northing\",2000");
    add_srs_wkt (p, 10,
        "000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS");
    add_srs_wkt (p, 11,
        "[\"Northing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"");
    add_srs_wkt (p, 12,
        "EPSG\",\"5179\"]]");
    p = add_epsg_def_ex (filter, first, last, 5180, "epsg", 5180,
        "Korea 2000 / West Belt", 0, 1,
        "GRS 1980", "Greenwich",
        "Geocentric_datum_of_Korea", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=38 +lon_0=125 +k=1 +x_0=200000 +y_0=5");
    add_proj4text (p, 1,
        "00000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_d");
    add_proj4text (p, 2,
        "efs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Korea 2000 / West Belt\",GEOGCS[\"Korea 2000\",");
    add_srs_wkt (p, 1,
        "DATUM[\"Geocentric_datum_of_Korea\",SPHEROID[\"GRS 1980\"");
    add_srs_wkt (p, 2,
        ",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUT");
    add_srs_wkt (p, 3,
        "HORITY[\"EPSG\",\"6737\"]],PRIMEM[\"Greenwich\",0,AUTHOR");
    add_srs_wkt (p, 4,
        "ITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251994");
    add_srs_wkt (p, 5,
        "33,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"47");
    add_srs_wkt (p, 6,
        "37\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"l");
    add_srs_wkt (p, 7,
        "atitude_of_origin\",38],PARAMETER[\"central_meridian\",1");
    add_srs_wkt (p, 8,
        "25],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_east");
    add_srs_wkt (p, 9,
        "ing\",200000],PARAMETER[\"false_northing\",500000],UNIT[");
    add_srs_wkt (p, 10,
        "\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northin");
    add_srs_wkt (p, 11,
        "g\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"5");
    add_srs_wkt (p, 12,
        "180\"]]");
    p = add_epsg_def_ex (filter, first, last, 5181, "epsg", 5181,
        "Korea 2000 / Central Belt", 0, 1,
        "GRS 1980", "Greenwich",
        "Geocentric_datum_of_Korea", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=38 +lon_0=127 +k=1 +x_0=200000 +y_0=5");
    add_proj4text (p, 1,
        "00000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_d");
    add_proj4text (p, 2,
        "efs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Korea 2000 / Central Belt\",GEOGCS[\"Korea 2000");
    add_srs_wkt (p, 1,
        "\",DATUM[\"Geocentric_datum_of_Korea\",SPHEROID[\"GRS 19");
    add_srs_wkt (p, 2,
        "80\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]]");
    add_srs_wkt (p, 3,
        ",AUTHORITY[\"EPSG\",\"6737\"]],PRIMEM[\"Greenwich\",0,AU");
    add_srs_wkt (p, 4,
        "THORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925");
    add_srs_wkt (p, 5,
        "199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 6,
        "\"4737\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER");
    add_srs_wkt (p, 7,
        "[\"latitude_of_origin\",38],PARAMETER[\"central_meridian");
    add_srs_wkt (p, 8,
        "\",127],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_");
    add_srs_wkt (p, 9,
        "easting\",200000],PARAMETER[\"false_northing\",500000],U");
    add_srs_wkt (p, 10,
        "NIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Nor");
    add_srs_wkt (p, 11,
        "thing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 12,
        ",\"5181\"]]");
    p = add_epsg_def_ex (filter, first, last, 5182, "epsg", 5182,
        "Korea 2000 / Central Belt Jeju", 0, 1,
        "GRS 1980", "Greenwich",
        "Geocentric_datum_of_Korea", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=38 +lon_0=127 +k=1 +x_0=200000 +y_0=5");
    add_proj4text (p, 1,
        "50000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_d");
    add_proj4text (p, 2,
        "efs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Korea 2000 / Central Belt Jeju\",GEOGCS[\"Korea");
    add_srs_wkt (p, 1,
        " 2000\",DATUM[\"Geocentric_datum_of_Korea\",SPHEROID[\"G");
    add_srs_wkt (p, 2,
        "RS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"701");
    add_srs_wkt (p, 3,
        "9\"]],AUTHORITY[\"EPSG\",\"6737\"]],PRIMEM[\"Greenwich\"");
    add_srs_wkt (p, 4,
        ",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745");
    add_srs_wkt (p, 5,
        "32925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EP");
    add_srs_wkt (p, 6,
        "SG\",\"4737\"]],PROJECTION[\"Transverse_Mercator\"],PARA");
    add_srs_wkt (p, 7,
        "METER[\"latitude_of_origin\",38],PARAMETER[\"central_mer");
    add_srs_wkt (p, 8,
        "idian\",127],PARAMETER[\"scale_factor\",1],PARAMETER[\"f");
    add_srs_wkt (p, 9,
        "alse_easting\",200000],PARAMETER[\"false_northing\",5500");
    add_srs_wkt (p, 10,
        "00],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[");
    add_srs_wkt (p, 11,
        "\"Northing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"E");
    add_srs_wkt (p, 12,
        "PSG\",\"5182\"]]");
    p = add_epsg_def_ex (filter, first, last, 5183, "epsg", 5183,
        "Korea 2000 / East Belt", 0, 1,
        "GRS 1980", "Greenwich",
        "Geocentric_datum_of_Korea", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=38 +lon_0=129 +k=1 +x_0=200000 +y_0=5");
    add_proj4text (p, 1,
        "00000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_d");
    add_proj4text (p, 2,
        "efs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Korea 2000 / East Belt\",GEOGCS[\"Korea 2000\",");
    add_srs_wkt (p, 1,
        "DATUM[\"Geocentric_datum_of_Korea\",SPHEROID[\"GRS 1980\"");
    add_srs_wkt (p, 2,
        ",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUT");
    add_srs_wkt (p, 3,
        "HORITY[\"EPSG\",\"6737\"]],PRIMEM[\"Greenwich\",0,AUTHOR");
    add_srs_wkt (p, 4,
        "ITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251994");
    add_srs_wkt (p, 5,
        "33,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"47");
    add_srs_wkt (p, 6,
        "37\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"l");
    add_srs_wkt (p, 7,
        "atitude_of_origin\",38],PARAMETER[\"central_meridian\",1");
    add_srs_wkt (p, 8,
        "29],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_east");
    add_srs_wkt (p, 9,
        "ing\",200000],PARAMETER[\"false_northing\",500000],UNIT[");
    add_srs_wkt (p, 10,
        "\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northin");
    add_srs_wkt (p, 11,
        "g\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"5");
    add_srs_wkt (p, 12,
        "183\"]]");
    p = add_epsg_def_ex (filter, first, last, 5184, "epsg", 5184,
        "Korea 2000 / East Sea Belt", 0, 1,
        "GRS 1980", "Greenwich",
        "Geocentric_datum_of_Korea", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=38 +lon_0=131 +k=1 +x_0=200000 +y_0=5");
    add_proj4text (p, 1,
        "00000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_d");
    add_proj4text (p, 2,
        "efs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Korea 2000 / East Sea Belt\",GEOGCS[\"Korea 200");
    add_srs_wkt (p, 1,
        "0\",DATUM[\"Geocentric_datum_of_Korea\",SPHEROID[\"GRS 1");
    add_srs_wkt (p, 2,
        "980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]");
    add_srs_wkt (p, 3,
        "],AUTHORITY[\"EPSG\",\"6737\"]],PRIMEM[\"Greenwich\",0,A");
    add_srs_wkt (p, 4,
        "UTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292");
    add_srs_wkt (p, 5,
        "5199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"4737\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETE");
    add_srs_wkt (p, 7,
        "R[\"latitude_of_origin\",38],PARAMETER[\"central_meridia");
    add_srs_wkt (p, 8,
        "n\",131],PARAMETER[\"scale_factor\",1],PARAMETER[\"false");
    add_srs_wkt (p, 9,
        "_easting\",200000],PARAMETER[\"false_northing\",500000],");
    add_srs_wkt (p, 10,
        "UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"No");
    add_srs_wkt (p, 11,
        "rthing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 12,
        ",\"5184\"]]");
    p = add_epsg_def_ex (filter, first, last, 5185, "epsg", 5185,
        "Korea 2000 / West Belt 2010", 0, 1,
        "GRS 1980", "Greenwich",
        "Geocentric_datum_of_Korea", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=38 +lon_0=125 +k=1 +x_0=200000 +y_0=6");
    add_proj4text (p, 1,
        "00000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_d");
    add_proj4text (p, 2,
        "efs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Korea 2000 / West Belt 2010\",GEOGCS[\"Korea 20");
    add_srs_wkt (p, 1,
        "00\",DATUM[\"Geocentric_datum_of_Korea\",SPHEROID[\"GRS ");
    add_srs_wkt (p, 2,
        "1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"");
    add_srs_wkt (p, 3,
        "]],AUTHORITY[\"EPSG\",\"6737\"]],PRIMEM[\"Greenwich\",0,");
    add_srs_wkt (p, 4,
        "AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329");
    add_srs_wkt (p, 5,
        "25199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"4737\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETE");
    add_srs_wkt (p, 7,
        "R[\"latitude_of_origin\",38],PARAMETER[\"central_meridia");
    add_srs_wkt (p, 8,
        "n\",125],PARAMETER[\"scale_factor\",1],PARAMETER[\"false");
    add_srs_wkt (p, 9,
        "_easting\",200000],PARAMETER[\"false_northing\",600000],");
    add_srs_wkt (p, 10,
        "UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"No");
    add_srs_wkt (p, 11,
        "rthing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 12,
        ",\"5185\"]]");
    p = add_epsg_def_ex (filter, first, last, 5186, "epsg", 5186,
        "Korea 2000 / Central Belt 2010", 0, 1,
        "GRS 1980", "Greenwich",
        "Geocentric_datum_of_Korea", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=38 +lon_0=127 +k=1 +x_0=200000 +y_0=6");
    add_proj4text (p, 1,
        "00000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_d");
    add_proj4text (p, 2,
        "efs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Korea 2000 / Central Belt 2010\",GEOGCS[\"Korea");
    add_srs_wkt (p, 1,
        " 2000\",DATUM[\"Geocentric_datum_of_Korea\",SPHEROID[\"G");
    add_srs_wkt (p, 2,
        "RS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"701");
    add_srs_wkt (p, 3,
        "9\"]],AUTHORITY[\"EPSG\",\"6737\"]],PRIMEM[\"Greenwich\"");
    add_srs_wkt (p, 4,
        ",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745");
    add_srs_wkt (p, 5,
        "32925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EP");
    add_srs_wkt (p, 6,
        "SG\",\"4737\"]],PROJECTION[\"Transverse_Mercator\"],PARA");
    add_srs_wkt (p, 7,
        "METER[\"latitude_of_origin\",38],PARAMETER[\"central_mer");
    add_srs_wkt (p, 8,
        "idian\",127],PARAMETER[\"scale_factor\",1],PARAMETER[\"f");
    add_srs_wkt (p, 9,
        "alse_easting\",200000],PARAMETER[\"false_northing\",6000");
    add_srs_wkt (p, 10,
        "00],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[");
    add_srs_wkt (p, 11,
        "\"Northing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"E");
    add_srs_wkt (p, 12,
        "PSG\",\"5186\"]]");
    p = add_epsg_def_ex (filter, first, last, 5187, "epsg", 5187,
        "Korea 2000 / East Belt 2010", 0, 1,
        "GRS 1980", "Greenwich",
        "Geocentric_datum_of_Korea", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=38 +lon_0=129 +k=1 +x_0=200000 +y_0=6");
    add_proj4text (p, 1,
        "00000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_d");
    add_proj4text (p, 2,
        "efs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Korea 2000 / East Belt 2010\",GEOGCS[\"Korea 20");
    add_srs_wkt (p, 1,
        "00\",DATUM[\"Geocentric_datum_of_Korea\",SPHEROID[\"GRS ");
    add_srs_wkt (p, 2,
        "1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"");
    add_srs_wkt (p, 3,
        "]],AUTHORITY[\"EPSG\",\"6737\"]],PRIMEM[\"Greenwich\",0,");
    add_srs_wkt (p, 4,
        "AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329");
    add_srs_wkt (p, 5,
        "25199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"4737\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETE");
    add_srs_wkt (p, 7,
        "R[\"latitude_of_origin\",38],PARAMETER[\"central_meridia");
    add_srs_wkt (p, 8,
        "n\",129],PARAMETER[\"scale_factor\",1],PARAMETER[\"false");
    add_srs_wkt (p, 9,
        "_easting\",200000],PARAMETER[\"false_northing\",600000],");
    add_srs_wkt (p, 10,
        "UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"No");
    add_srs_wkt (p, 11,
        "rthing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 12,
        ",\"5187\"]]");
    p = add_epsg_def_ex (filter, first, last, 5188, "epsg", 5188,
        "Korea 2000 / East Sea Belt 2010", 0, 1,
        "GRS 1980", "Greenwich",
        "Geocentric_datum_of_Korea", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=38 +lon_0=131 +k=1 +x_0=200000 +y_0=6");
    add_proj4text (p, 1,
        "00000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_d");
    add_proj4text (p, 2,
        "efs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Korea 2000 / East Sea Belt 2010\",GEOGCS[\"Kore");
    add_srs_wkt (p, 1,
        "a 2000\",DATUM[\"Geocentric_datum_of_Korea\",SPHEROID[\"");
    add_srs_wkt (p, 2,
        "GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"70");
    add_srs_wkt (p, 3,
        "19\"]],AUTHORITY[\"EPSG\",\"6737\"]],PRIMEM[\"Greenwich\"");
    add_srs_wkt (p, 4,
        ",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745");
    add_srs_wkt (p, 5,
        "32925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EP");
    add_srs_wkt (p, 6,
        "SG\",\"4737\"]],PROJECTION[\"Transverse_Mercator\"],PARA");
    add_srs_wkt (p, 7,
        "METER[\"latitude_of_origin\",38],PARAMETER[\"central_mer");
    add_srs_wkt (p, 8,
        "idian\",131],PARAMETER[\"scale_factor\",1],PARAMETER[\"f");
    add_srs_wkt (p, 9,
        "alse_easting\",200000],PARAMETER[\"false_northing\",6000");
    add_srs_wkt (p, 10,
        "00],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[");
    add_srs_wkt (p, 11,
        "\"Northing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"E");
    add_srs_wkt (p, 12,
        "PSG\",\"5188\"]]");
    p = add_epsg_def_ex (filter, first, last, 5221, "epsg", 5221,
        "S-JTSK (Ferro) / Krovak East North", 0, 0,
        "Bessel 1841", "Ferro",
        "System_of_the_Unified_Trigonometrical_Cadastral_Network_Ferro", "Krovak", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=krovak +lat_0=49.5 +lon_0=42.5 +alpha=30.288139722");
    add_proj4text (p, 1,
        "22222 +k=0.9999 +x_0=0 +y_0=0 +ellps=bessel +towgs84=589");
    add_proj4text (p, 2,
        ",76,480,0,0,0,0 +pm=ferro +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"S-JTSK (Ferro) / Krovak East North\",GEOGCS[\"S");
    add_srs_wkt (p, 1,
        "-JTSK (Ferro)\",DATUM[\"System_of_the_Unified_Trigonomet");
    add_srs_wkt (p, 2,
        "rical_Cadastral_Network_Ferro\",SPHEROID[\"Bessel 1841\"");
    add_srs_wkt (p, 3,
        ",6377397.155,299.1528128,AUTHORITY[\"EPSG\",\"7004\"]],A");
    add_srs_wkt (p, 4,
        "UTHORITY[\"EPSG\",\"6818\"]],PRIMEM[\"Ferro\",-17.666666");
    add_srs_wkt (p, 5,
        "6666667,AUTHORITY[\"EPSG\",\"8909\"]],UNIT[\"degree\",0.");
    add_srs_wkt (p, 6,
        "0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY");
    add_srs_wkt (p, 7,
        "[\"EPSG\",\"4818\"]],PROJECTION[\"Krovak\"],PARAMETER[\"");
    add_srs_wkt (p, 8,
        "latitude_of_center\",49.5],PARAMETER[\"longitude_of_cent");
    add_srs_wkt (p, 9,
        "er\",42.5],PARAMETER[\"azimuth\",30.2881397527778],PARAM");
    add_srs_wkt (p, 10,
        "ETER[\"pseudo_standard_parallel_1\",78.5],PARAMETER[\"sc");
    add_srs_wkt (p, 11,
        "ale_factor\",0.9999],PARAMETER[\"false_easting\",0],PARA");
    add_srs_wkt (p, 12,
        "METER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"");
    add_srs_wkt (p, 13,
        "EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing");
    add_srs_wkt (p, 14,
        "\",NORTH],AUTHORITY[\"EPSG\",\"5221\"]]");
    p = add_epsg_def_ex (filter, first, last, 5223, "epsg", 5223,
        "WGS 84 / Gabon TM", 0, 0,
        "WGS 84", "Greenwich",
        "WGS_1984", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=12 +k=0.9996 +x_0=500000 +y_");
    add_proj4text (p, 1,
        "0=500000 +datum=WGS84 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 84 / Gabon TM\",GEOGCS[\"WGS 84\",DATUM[\"W");
    add_srs_wkt (p, 1,
        "GS_1984\",SPHEROID[\"WGS 84\",6378137,298.257223563,AUTH");
    add_srs_wkt (p, 2,
        "ORITY[\"EPSG\",\"7030\"]],AUTHORITY[\"EPSG\",\"6326\"]],");
    add_srs_wkt (p, 3,
        "PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNI");
    add_srs_wkt (p, 4,
        "T[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"912");
    add_srs_wkt (p, 5,
        "2\"]],AUTHORITY[\"EPSG\",\"4326\"]],PROJECTION[\"Transve");
    add_srs_wkt (p, 6,
        "rse_Mercator\"],PARAMETER[\"latitude_of_origin\",0],PARA");
    add_srs_wkt (p, 7,
        "METER[\"central_meridian\",12],PARAMETER[\"scale_factor\"");
    add_srs_wkt (p, 8,
        ",0.9996],PARAMETER[\"false_easting\",500000],PARAMETER[\"");
    add_srs_wkt (p, 9,
        "false_northing\",500000],UNIT[\"metre\",1,AUTHORITY[\"EP");
    add_srs_wkt (p, 10,
        "SG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\"");
    add_srs_wkt (p, 11,
        ",NORTH],AUTHORITY[\"EPSG\",\"5223\"]]");
    p = add_epsg_def_ex (filter, first, last, 5228, "epsg", 5228,
        "S-JTSK/05", 1, 1,
        "Bessel 1841", "Greenwich",
        "System_of_the_Unified_Trigonometrical_Cadastral_Network_05", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=bessel +towgs84=572.213,85.334,461.");
    add_proj4text (p, 1,
        "94,4.9732,1.529,5.2484,3.5378 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"S-JTSK/05\",DATUM[\"System_of_the_Unified_Trigo");
    add_srs_wkt (p, 1,
        "nometrical_Cadastral_Network_05\",SPHEROID[\"Bessel 1841");
    add_srs_wkt (p, 2,
        "\",6377397.155,299.1528128,AUTHORITY[\"EPSG\",\"7004\"]]");
    add_srs_wkt (p, 3,
        ",AUTHORITY[\"EPSG\",\"1052\"]],PRIMEM[\"Greenwich\",0,AU");
    add_srs_wkt (p, 4,
        "THORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925");
    add_srs_wkt (p, 5,
        "199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",N");
    add_srs_wkt (p, 6,
        "ORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"5228");
    add_srs_wkt (p, 7,
        "\"]]");
    p = add_epsg_def_ex (filter, first, last, 5229, "epsg", 5229,
        "S-JTSK/05 (Ferro)", 1, 1,
        "Bessel 1841", "Ferro",
        "System_of_the_Unified_Trigonometrical_Cadastral_Network_05_Ferro", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=bessel +towgs84=572.213,85.334,461.");
    add_proj4text (p, 1,
        "94,4.9732,1.529,5.2484,3.5378 +pm=ferro +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"S-JTSK/05 (Ferro)\",DATUM[\"System_of_the_Unifi");
    add_srs_wkt (p, 1,
        "ed_Trigonometrical_Cadastral_Network_05_Ferro\",SPHEROID");
    add_srs_wkt (p, 2,
        "[\"Bessel 1841\",6377397.155,299.1528128,AUTHORITY[\"EPS");
    add_srs_wkt (p, 3,
        "G\",\"7004\"]],AUTHORITY[\"EPSG\",\"1055\"]],PRIMEM[\"Fe");
    add_srs_wkt (p, 4,
        "rro\",-17.6666666666667,AUTHORITY[\"EPSG\",\"8909\"]],UN");
    add_srs_wkt (p, 5,
        "IT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"91");
    add_srs_wkt (p, 6,
        "22\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST]");
    add_srs_wkt (p, 7,
        ",AUTHORITY[\"EPSG\",\"5229\"]]");
    p = add_epsg_def_ex (filter, first, last, 5233, "epsg", 5233,
        "SLD99", 1, 1,
        "Everest 1830 (1937 Adjustment)", "Greenwich",
        "Sri_Lanka_Datum_1999", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +a=6377276.345 +b=6356075.41314024 +towgs8");
    add_proj4text (p, 1,
        "4=-0.293,766.95,87.713,0.195704,1.695068,3.473016,-0.039");
    add_proj4text (p, 2,
        "338 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"SLD99\",DATUM[\"Sri_Lanka_Datum_1999\",SPHEROID");
    add_srs_wkt (p, 1,
        "[\"Everest 1830 (1937 Adjustment)\",6377276.345,300.8017");
    add_srs_wkt (p, 2,
        ",AUTHORITY[\"EPSG\",\"7015\"]],AUTHORITY[\"EPSG\",\"1053");
    add_srs_wkt (p, 3,
        "\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]");
    add_srs_wkt (p, 4,
        "],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 5,
        "\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",E");
    add_srs_wkt (p, 6,
        "AST],AUTHORITY[\"EPSG\",\"5233\"]]");
    p = add_epsg_def_ex (filter, first, last, 5234, "epsg", 5234,
        "Kandawala / Sri Lanka Grid", 0, 0,
        "Everest 1830 (1937 Adjustment)", "Greenwich",
        "Kandawala", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=7.000480277777778 +lon_0=80.771711111");
    add_proj4text (p, 1,
        "11112 +k=0.9999238418 +x_0=200000 +y_0=200000 +a=6377276");
    add_proj4text (p, 2,
        ".345 +b=6356075.41314024 +towgs84=-97,787,86,0,0,0,0 +un");
    add_proj4text (p, 3,
        "its=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Kandawala / Sri Lanka Grid\",GEOGCS[\"Kandawala");
    add_srs_wkt (p, 1,
        "\",DATUM[\"Kandawala\",SPHEROID[\"Everest 1830 (1937 Adj");
    add_srs_wkt (p, 2,
        "ustment)\",6377276.345,300.8017,AUTHORITY[\"EPSG\",\"701");
    add_srs_wkt (p, 3,
        "5\"]],AUTHORITY[\"EPSG\",\"6244\"]],PRIMEM[\"Greenwich\"");
    add_srs_wkt (p, 4,
        ",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745");
    add_srs_wkt (p, 5,
        "32925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EP");
    add_srs_wkt (p, 6,
        "SG\",\"4244\"]],PROJECTION[\"Transverse_Mercator\"],PARA");
    add_srs_wkt (p, 7,
        "METER[\"latitude_of_origin\",7.00048027777778],PARAMETER");
    add_srs_wkt (p, 8,
        "[\"central_meridian\",80.7717111111111],PARAMETER[\"scal");
    add_srs_wkt (p, 9,
        "e_factor\",0.9999238418],PARAMETER[\"false_easting\",200");
    add_srs_wkt (p, 10,
        "000],PARAMETER[\"false_northing\",200000],UNIT[\"metre\"");
    add_srs_wkt (p, 11,
        ",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],");
    add_srs_wkt (p, 12,
        "AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"5234\"]]");
    p = add_epsg_def_ex (filter, first, last, 5235, "epsg", 5235,
        "SLD99 / Sri Lanka Grid 1999", 0, 0,
        "Everest 1830 (1937 Adjustment)", "Greenwich",
        "Sri_Lanka_Datum_1999", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=7.000471527777778 +lon_0=80.771713083");
    add_proj4text (p, 1,
        "33334 +k=0.9999238418 +x_0=500000 +y_0=500000 +a=6377276");
    add_proj4text (p, 2,
        ".345 +b=6356075.41314024 +towgs84=-0.293,766.95,87.713,0");
    add_proj4text (p, 3,
        ".195704,1.695068,3.473016,-0.039338 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"SLD99 / Sri Lanka Grid 1999\",GEOGCS[\"SLD99\",");
    add_srs_wkt (p, 1,
        "DATUM[\"Sri_Lanka_Datum_1999\",SPHEROID[\"Everest 1830 (");
    add_srs_wkt (p, 2,
        "1937 Adjustment)\",6377276.345,300.8017,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 3,
        "\",\"7015\"]],AUTHORITY[\"EPSG\",\"1053\"]],PRIMEM[\"Gre");
    add_srs_wkt (p, 4,
        "enwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\"");
    add_srs_wkt (p, 5,
        ",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHOR");
    add_srs_wkt (p, 6,
        "ITY[\"EPSG\",\"5233\"]],PROJECTION[\"Transverse_Mercator");
    add_srs_wkt (p, 7,
        "\"],PARAMETER[\"latitude_of_origin\",7.00047152777778],P");
    add_srs_wkt (p, 8,
        "ARAMETER[\"central_meridian\",80.7717130833333],PARAMETE");
    add_srs_wkt (p, 9,
        "R[\"scale_factor\",0.9999238418],PARAMETER[\"false_easti");
    add_srs_wkt (p, 10,
        "ng\",500000],PARAMETER[\"false_northing\",500000],UNIT[\"");
    add_srs_wkt (p, 11,
        "metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\"");
    add_srs_wkt (p, 12,
        ",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"523");
    add_srs_wkt (p, 13,
        "5\"]]");
    p = add_epsg_def_ex (filter, first, last, 5243, "epsg", 5243,
        "ETRS89 / LCC Germany (E-N)", 0, 0,
        "GRS 1980", "Greenwich",
        "European_Terrestrial_Reference_System_1989", "Lambert_Conformal_Conic_2SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=48.66666666666666 +lat_2=53.66666666666");
    add_proj4text (p, 1,
        "666 +lat_0=51 +lon_0=10.5 +x_0=0 +y_0=0 +ellps=GRS80 +to");
    add_proj4text (p, 2,
        "wgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"ETRS89 / LCC Germany (E-N)\",GEOGCS[\"ETRS89\",");
    add_srs_wkt (p, 1,
        "DATUM[\"European_Terrestrial_Reference_System_1989\",SPH");
    add_srs_wkt (p, 2,
        "EROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPS");
    add_srs_wkt (p, 3,
        "G\",\"7019\"]],AUTHORITY[\"EPSG\",\"6258\"]],PRIMEM[\"Gr");
    add_srs_wkt (p, 4,
        "eenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\"");
    add_srs_wkt (p, 5,
        ",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHOR");
    add_srs_wkt (p, 6,
        "ITY[\"EPSG\",\"4258\"]],PROJECTION[\"Lambert_Conformal_C");
    add_srs_wkt (p, 7,
        "onic_2SP\"],PARAMETER[\"latitude_of_origin\",51],PARAMET");
    add_srs_wkt (p, 8,
        "ER[\"central_meridian\",10.5],PARAMETER[\"standard_paral");
    add_srs_wkt (p, 9,
        "lel_1\",48.6666666666667],PARAMETER[\"standard_parallel_");
    add_srs_wkt (p, 10,
        "2\",53.6666666666667],PARAMETER[\"false_easting\",0],PAR");
    add_srs_wkt (p, 11,
        "AMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[");
    add_srs_wkt (p, 12,
        "\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northi");
    add_srs_wkt (p, 13,
        "ng\",NORTH],AUTHORITY[\"EPSG\",\"5243\"]]");
    p = add_epsg_def_ex (filter, first, last, 5245, "epsg", 5245,
        "GDBD2009", 1, 1,
        "GRS 1980", "Greenwich",
        "Geocentric_Datum_Brunei_Darussalam_2009", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +no_de");
    add_proj4text (p, 1,
        "fs");
    add_srs_wkt (p, 0,
        "GEOGCRS[\"GDBD2009\",DATUM[\"Geocentric Datum Brunei Dar");
    add_srs_wkt (p, 1,
        "ussalam 2009\",ELLIPSOID[\"GRS 1980\",6378137,298.257222");
    add_srs_wkt (p, 2,
        "101,LENGTHUNIT[\"metre\",1]]],PRIMEM[\"Greenwich\",0,ANG");
    add_srs_wkt (p, 3,
        "LEUNIT[\"degree\",0.0174532925199433]],CS[ellipsoidal,3]");
    add_srs_wkt (p, 4,
        ",AXIS[\"geodetic latitude (Lat)\",north,ORDER[1],ANGLEUN");
    add_srs_wkt (p, 5,
        "IT[\"degree\",0.0174532925199433]],AXIS[\"geodetic longi");
    add_srs_wkt (p, 6,
        "tude (Lon)\",east,ORDER[2],ANGLEUNIT[\"degree\",0.017453");
    add_srs_wkt (p, 7,
        "2925199433]],AXIS[\"ellipsoidal height (h)\",up,ORDER[3]");
    add_srs_wkt (p, 8,
        ",LENGTHUNIT[\"metre\",1]],USAGE[SCOPE[\"unknown\"],AREA[");
    add_srs_wkt (p, 9,
        "\"Brunei\"],BBOX[4.01,112.37,6.31,115.37]],ID[\"EPSG\",5");
    add_srs_wkt (p, 10,
        "245]]");
    p = add_epsg_def_ex (filter, first, last, 5246, "epsg", 5246,
        "GDBD2009", 1, 1,
        "GRS 1980", "Greenwich",
        "Geocentric_Datum_Brunei_Darussalam_2009", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +no_de");
    add_proj4text (p, 1,
        "fs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"GDBD2009\",DATUM[\"Geocentric_Datum_Brunei_Daru");
    add_srs_wkt (p, 1,
        "ssalam_2009\",SPHEROID[\"GRS 1980\",6378137,298.25722210");
    add_srs_wkt (p, 2,
        "1,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"105");
    add_srs_wkt (p, 3,
        "6\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"");
    add_srs_wkt (p, 4,
        "]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 5,
        ",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",");
    add_srs_wkt (p, 6,
        "EAST],AUTHORITY[\"EPSG\",\"5246\"]]");
    p = add_epsg_def_ex (filter, first, last, 5247, "epsg", 5247,
        "GDBD2009 / Brunei BRSO", 0, 0,
        "GRS 1980", "Greenwich",
        "Geocentric_Datum_Brunei_Darussalam_2009", "Hotine_Oblique_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=omerc +lat_0=4 +lonc=115 +alpha=53.31580995 +k=0.9");
    add_proj4text (p, 1,
        "9984 +x_0=0 +y_0=0 +no_uoff +gamma=53.13010236111111 +el");
    add_proj4text (p, 2,
        "lps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"GDBD2009 / Brunei BRSO\",GEOGCS[\"GDBD2009\",DA");
    add_srs_wkt (p, 1,
        "TUM[\"Geocentric_Datum_Brunei_Darussalam_2009\",SPHEROID");
    add_srs_wkt (p, 2,
        "[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 3,
        "7019\"]],AUTHORITY[\"EPSG\",\"1056\"]],PRIMEM[\"Greenwic");
    add_srs_wkt (p, 4,
        "h\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01");
    add_srs_wkt (p, 5,
        "74532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"5246\"]],PROJECTION[\"Hotine_Oblique_Mercator\"");
    add_srs_wkt (p, 7,
        "],PARAMETER[\"latitude_of_center\",4],PARAMETER[\"longit");
    add_srs_wkt (p, 8,
        "ude_of_center\",115],PARAMETER[\"azimuth\",53.31580995],");
    add_srs_wkt (p, 9,
        "PARAMETER[\"rectified_grid_angle\",53.1301023611111],PAR");
    add_srs_wkt (p, 10,
        "AMETER[\"scale_factor\",0.99984],PARAMETER[\"false_easti");
    add_srs_wkt (p, 11,
        "ng\",0],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1");
    add_srs_wkt (p, 12,
        ",AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AX");
    add_srs_wkt (p, 13,
        "IS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"5247\"]]");
    p = add_epsg_def_ex (filter, first, last, 5251, "epsg", 5251,
        "TUREF", 1, 1,
        "GRS 1980", "Greenwich",
        "Turkish_National_Reference_Frame", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +no_de");
    add_proj4text (p, 1,
        "fs");
    add_srs_wkt (p, 0,
        "GEOGCRS[\"TUREF\",DATUM[\"Turkish National Reference Fra");
    add_srs_wkt (p, 1,
        "me\",ELLIPSOID[\"GRS 1980\",6378137,298.257222101,LENGTH");
    add_srs_wkt (p, 2,
        "UNIT[\"metre\",1]]],PRIMEM[\"Greenwich\",0,ANGLEUNIT[\"d");
    add_srs_wkt (p, 3,
        "egree\",0.0174532925199433]],CS[ellipsoidal,3],AXIS[\"ge");
    add_srs_wkt (p, 4,
        "odetic latitude (Lat)\",north,ORDER[1],ANGLEUNIT[\"degre");
    add_srs_wkt (p, 5,
        "e\",0.0174532925199433]],AXIS[\"geodetic longitude (Lon)");
    add_srs_wkt (p, 6,
        "\",east,ORDER[2],ANGLEUNIT[\"degree\",0.0174532925199433");
    add_srs_wkt (p, 7,
        "]],AXIS[\"ellipsoidal height (h)\",up,ORDER[3],LENGTHUNI");
    add_srs_wkt (p, 8,
        "T[\"metre\",1]],USAGE[SCOPE[\"unknown\"],AREA[\"Turkey\"");
    add_srs_wkt (p, 9,
        "],BBOX[34.42,25.62,43.45,44.83]],ID[\"EPSG\",5251]]");
    p = add_epsg_def_ex (filter, first, last, 5252, "epsg", 5252,
        "TUREF", 1, 1,
        "GRS 1980", "Greenwich",
        "Turkish_National_Reference_Frame", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +no_de");
    add_proj4text (p, 1,
        "fs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"TUREF\",DATUM[\"Turkish_National_Reference_Fram");
    add_srs_wkt (p, 1,
        "e\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORIT");
    add_srs_wkt (p, 2,
        "Y[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1057\"]],PRIM");
    add_srs_wkt (p, 3,
        "EM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"");
    add_srs_wkt (p, 4,
        "degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]");
    add_srs_wkt (p, 5,
        "],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTH");
    add_srs_wkt (p, 6,
        "ORITY[\"EPSG\",\"5252\"]]");
    p = add_epsg_def_ex (filter, first, last, 5253, "epsg", 5253,
        "TUREF / TM27", 0, 1,
        "GRS 1980", "Greenwich",
        "Turkish_National_Reference_Frame", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=27 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"TUREF / TM27\",GEOGCS[\"TUREF\",DATUM[\"Turkish");
    add_srs_wkt (p, 1,
        "_National_Reference_Frame\",SPHEROID[\"GRS 1980\",637813");
    add_srs_wkt (p, 2,
        "7,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[");
    add_srs_wkt (p, 3,
        "\"EPSG\",\"1057\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"E");
    add_srs_wkt (p, 4,
        "PSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTH");
    add_srs_wkt (p, 5,
        "ORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"5252\"]],");
    add_srs_wkt (p, 6,
        "PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude");
    add_srs_wkt (p, 7,
        "_of_origin\",0],PARAMETER[\"central_meridian\",27],PARAM");
    add_srs_wkt (p, 8,
        "ETER[\"scale_factor\",1],PARAMETER[\"false_easting\",500");
    add_srs_wkt (p, 9,
        "000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AU");
    add_srs_wkt (p, 10,
        "THORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",NORTH],AXI");
    add_srs_wkt (p, 11,
        "S[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"5253\"]]");
    p = add_epsg_def_ex (filter, first, last, 5254, "epsg", 5254,
        "TUREF / TM30", 0, 1,
        "GRS 1980", "Greenwich",
        "Turkish_National_Reference_Frame", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=30 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"TUREF / TM30\",GEOGCS[\"TUREF\",DATUM[\"Turkish");
    add_srs_wkt (p, 1,
        "_National_Reference_Frame\",SPHEROID[\"GRS 1980\",637813");
    add_srs_wkt (p, 2,
        "7,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[");
    add_srs_wkt (p, 3,
        "\"EPSG\",\"1057\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"E");
    add_srs_wkt (p, 4,
        "PSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTH");
    add_srs_wkt (p, 5,
        "ORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"5252\"]],");
    add_srs_wkt (p, 6,
        "PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude");
    add_srs_wkt (p, 7,
        "_of_origin\",0],PARAMETER[\"central_meridian\",30],PARAM");
    add_srs_wkt (p, 8,
        "ETER[\"scale_factor\",1],PARAMETER[\"false_easting\",500");
    add_srs_wkt (p, 9,
        "000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AU");
    add_srs_wkt (p, 10,
        "THORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",NORTH],AXI");
    add_srs_wkt (p, 11,
        "S[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"5254\"]]");
    p = add_epsg_def_ex (filter, first, last, 5255, "epsg", 5255,
        "TUREF / TM33", 0, 1,
        "GRS 1980", "Greenwich",
        "Turkish_National_Reference_Frame", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=33 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"TUREF / TM33\",GEOGCS[\"TUREF\",DATUM[\"Turkish");
    add_srs_wkt (p, 1,
        "_National_Reference_Frame\",SPHEROID[\"GRS 1980\",637813");
    add_srs_wkt (p, 2,
        "7,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[");
    add_srs_wkt (p, 3,
        "\"EPSG\",\"1057\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"E");
    add_srs_wkt (p, 4,
        "PSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTH");
    add_srs_wkt (p, 5,
        "ORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"5252\"]],");
    add_srs_wkt (p, 6,
        "PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude");
    add_srs_wkt (p, 7,
        "_of_origin\",0],PARAMETER[\"central_meridian\",33],PARAM");
    add_srs_wkt (p, 8,
        "ETER[\"scale_factor\",1],PARAMETER[\"false_easting\",500");
    add_srs_wkt (p, 9,
        "000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AU");
    add_srs_wkt (p, 10,
        "THORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",NORTH],AXI");
    add_srs_wkt (p, 11,
        "S[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"5255\"]]");
    p = add_epsg_def_ex (filter, first, last, 5256, "epsg", 5256,
        "TUREF / TM36", 0, 1,
        "GRS 1980", "Greenwich",
        "Turkish_National_Reference_Frame", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=36 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"TUREF / TM36\",GEOGCS[\"TUREF\",DATUM[\"Turkish");
    add_srs_wkt (p, 1,
        "_National_Reference_Frame\",SPHEROID[\"GRS 1980\",637813");
    add_srs_wkt (p, 2,
        "7,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[");
    add_srs_wkt (p, 3,
        "\"EPSG\",\"1057\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"E");
    add_srs_wkt (p, 4,
        "PSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTH");
    add_srs_wkt (p, 5,
        "ORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"5252\"]],");
    add_srs_wkt (p, 6,
        "PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude");
    add_srs_wkt (p, 7,
        "_of_origin\",0],PARAMETER[\"central_meridian\",36],PARAM");
    add_srs_wkt (p, 8,
        "ETER[\"scale_factor\",1],PARAMETER[\"false_easting\",500");
    add_srs_wkt (p, 9,
        "000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AU");
    add_srs_wkt (p, 10,
        "THORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",NORTH],AXI");
    add_srs_wkt (p, 11,
        "S[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"5256\"]]");
    p = add_epsg_def_ex (filter, first, last, 5257, "epsg", 5257,
        "TUREF / TM39", 0, 1,
        "GRS 1980", "Greenwich",
        "Turkish_National_Reference_Frame", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=39 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"TUREF / TM39\",GEOGCS[\"TUREF\",DATUM[\"Turkish");
    add_srs_wkt (p, 1,
        "_National_Reference_Frame\",SPHEROID[\"GRS 1980\",637813");
    add_srs_wkt (p, 2,
        "7,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[");
    add_srs_wkt (p, 3,
        "\"EPSG\",\"1057\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"E");
    add_srs_wkt (p, 4,
        "PSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTH");
    add_srs_wkt (p, 5,
        "ORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"5252\"]],");
    add_srs_wkt (p, 6,
        "PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude");
    add_srs_wkt (p, 7,
        "_of_origin\",0],PARAMETER[\"central_meridian\",39],PARAM");
    add_srs_wkt (p, 8,
        "ETER[\"scale_factor\",1],PARAMETER[\"false_easting\",500");
    add_srs_wkt (p, 9,
        "000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AU");
    add_srs_wkt (p, 10,
        "THORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",NORTH],AXI");
    add_srs_wkt (p, 11,
        "S[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"5257\"]]");
    p = add_epsg_def_ex (filter, first, last, 5258, "epsg", 5258,
        "TUREF / TM42", 0, 1,
        "GRS 1980", "Greenwich",
        "Turkish_National_Reference_Frame", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=42 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"TUREF / TM42\",GEOGCS[\"TUREF\",DATUM[\"Turkish");
    add_srs_wkt (p, 1,
        "_National_Reference_Frame\",SPHEROID[\"GRS 1980\",637813");
    add_srs_wkt (p, 2,
        "7,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[");
    add_srs_wkt (p, 3,
        "\"EPSG\",\"1057\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"E");
    add_srs_wkt (p, 4,
        "PSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTH");
    add_srs_wkt (p, 5,
        "ORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"5252\"]],");
    add_srs_wkt (p, 6,
        "PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude");
    add_srs_wkt (p, 7,
        "_of_origin\",0],PARAMETER[\"central_meridian\",42],PARAM");
    add_srs_wkt (p, 8,
        "ETER[\"scale_factor\",1],PARAMETER[\"false_easting\",500");
    add_srs_wkt (p, 9,
        "000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AU");
    add_srs_wkt (p, 10,
        "THORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",NORTH],AXI");
    add_srs_wkt (p, 11,
        "S[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"5258\"]]");
    p = add_epsg_def_ex (filter, first, last, 5259, "epsg", 5259,
        "TUREF / TM45", 0, 1,
        "GRS 1980", "Greenwich",
        "Turkish_National_Reference_Frame", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=45 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"TUREF / TM45\",GEOGCS[\"TUREF\",DATUM[\"Turkish");
    add_srs_wkt (p, 1,
        "_National_Reference_Frame\",SPHEROID[\"GRS 1980\",637813");
    add_srs_wkt (p, 2,
        "7,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[");
    add_srs_wkt (p, 3,
        "\"EPSG\",\"1057\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"E");
    add_srs_wkt (p, 4,
        "PSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTH");
    add_srs_wkt (p, 5,
        "ORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"5252\"]],");
    add_srs_wkt (p, 6,
        "PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude");
    add_srs_wkt (p, 7,
        "_of_origin\",0],PARAMETER[\"central_meridian\",45],PARAM");
    add_srs_wkt (p, 8,
        "ETER[\"scale_factor\",1],PARAMETER[\"false_easting\",500");
    add_srs_wkt (p, 9,
        "000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AU");
    add_srs_wkt (p, 10,
        "THORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",NORTH],AXI");
    add_srs_wkt (p, 11,
        "S[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"5259\"]]");
    p = add_epsg_def_ex (filter, first, last, 5263, "epsg", 5263,
        "DRUKREF 03", 1, 1,
        "GRS 1980", "Greenwich",
        "Bhutan_National_Geodetic_Datum", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +no_de");
    add_proj4text (p, 1,
        "fs");
    add_srs_wkt (p, 0,
        "GEOGCRS[\"DRUKREF 03\",DATUM[\"Bhutan National Geodetic ");
    add_srs_wkt (p, 1,
        "Datum\",ELLIPSOID[\"GRS 1980\",6378137,298.257222101,LEN");
    add_srs_wkt (p, 2,
        "GTHUNIT[\"metre\",1]]],PRIMEM[\"Greenwich\",0,ANGLEUNIT[");
    add_srs_wkt (p, 3,
        "\"degree\",0.0174532925199433]],CS[ellipsoidal,3],AXIS[\"");
    add_srs_wkt (p, 4,
        "geodetic latitude (Lat)\",north,ORDER[1],ANGLEUNIT[\"deg");
    add_srs_wkt (p, 5,
        "ree\",0.0174532925199433]],AXIS[\"geodetic longitude (Lo");
    add_srs_wkt (p, 6,
        "n)\",east,ORDER[2],ANGLEUNIT[\"degree\",0.01745329251994");
    add_srs_wkt (p, 7,
        "33]],AXIS[\"ellipsoidal height (h)\",up,ORDER[3],LENGTHU");
    add_srs_wkt (p, 8,
        "NIT[\"metre\",1]],USAGE[SCOPE[\"unknown\"],AREA[\"Bhutan");
    add_srs_wkt (p, 9,
        "\"],BBOX[26.7,88.74,28.33,92.13]],ID[\"EPSG\",5263]]");
    p = add_epsg_def_ex (filter, first, last, 5264, "epsg", 5264,
        "DRUKREF 03", 1, 1,
        "GRS 1980", "Greenwich",
        "Bhutan_National_Geodetic_Datum", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +no_de");
    add_proj4text (p, 1,
        "fs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"DRUKREF 03\",DATUM[\"Bhutan_National_Geodetic_D");
    add_srs_wkt (p, 1,
        "atum\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHO");
    add_srs_wkt (p, 2,
        "RITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1058\"]],P");
    add_srs_wkt (p, 3,
        "RIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT");
    add_srs_wkt (p, 4,
        "[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122");
    add_srs_wkt (p, 5,
        "\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],A");
    add_srs_wkt (p, 6,
        "UTHORITY[\"EPSG\",\"5264\"]]");
    p = add_epsg_def_ex (filter, first, last, 5266, "epsg", 5266,
        "DRUKREF 03 / Bhutan National Grid", 0, 0,
        "GRS 1980", "Greenwich",
        "Bhutan_National_Geodetic_Datum", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=90 +k=1 +x_0=250000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"DRUKREF 03 / Bhutan National Grid\",GEOGCS[\"DR");
    add_srs_wkt (p, 1,
        "UKREF 03\",DATUM[\"Bhutan_National_Geodetic_Datum\",SPHE");
    add_srs_wkt (p, 2,
        "ROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 3,
        "\",\"7019\"]],AUTHORITY[\"EPSG\",\"1058\"]],PRIMEM[\"Gre");
    add_srs_wkt (p, 4,
        "enwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\"");
    add_srs_wkt (p, 5,
        ",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHOR");
    add_srs_wkt (p, 6,
        "ITY[\"EPSG\",\"5264\"]],PROJECTION[\"Transverse_Mercator");
    add_srs_wkt (p, 7,
        "\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"cent");
    add_srs_wkt (p, 8,
        "ral_meridian\",90],PARAMETER[\"scale_factor\",1],PARAMET");
    add_srs_wkt (p, 9,
        "ER[\"false_easting\",250000],PARAMETER[\"false_northing\"");
    add_srs_wkt (p, 10,
        ",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[");
    add_srs_wkt (p, 11,
        "\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"E");
    add_srs_wkt (p, 12,
        "PSG\",\"5266\"]]");
    p = add_epsg_def_ex (filter, first, last, 5269, "epsg", 5269,
        "TUREF / 3-degree Gauss-Kruger zone 9", 0, 1,
        "GRS 1980", "Greenwich",
        "Turkish_National_Reference_Frame", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=27 +k=1 +x_0=9500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"TUREF / 3-degree Gauss-Kruger zone 9\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "TUREF\",DATUM[\"Turkish_National_Reference_Frame\",SPHER");
    add_srs_wkt (p, 2,
        "OID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"7019\"]],AUTHORITY[\"EPSG\",\"1057\"]],PRIMEM[\"Green");
    add_srs_wkt (p, 4,
        "wich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0");
    add_srs_wkt (p, 5,
        ".0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORIT");
    add_srs_wkt (p, 6,
        "Y[\"EPSG\",\"5252\"]],PROJECTION[\"Transverse_Mercator\"");
    add_srs_wkt (p, 7,
        "],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"centra");
    add_srs_wkt (p, 8,
        "l_meridian\",27],PARAMETER[\"scale_factor\",1],PARAMETER");
    add_srs_wkt (p, 9,
        "[\"false_easting\",9500000],PARAMETER[\"false_northing\"");
    add_srs_wkt (p, 10,
        ",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[");
    add_srs_wkt (p, 11,
        "\"Northing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"E");
    add_srs_wkt (p, 12,
        "PSG\",\"5269\"]]");
    p = add_epsg_def_ex (filter, first, last, 5270, "epsg", 5270,
        "TUREF / 3-degree Gauss-Kruger zone 10", 0, 1,
        "GRS 1980", "Greenwich",
        "Turkish_National_Reference_Frame", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=30 +k=1 +x_0=10500000 +y_0=0");
    add_proj4text (p, 1,
        " +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"TUREF / 3-degree Gauss-Kruger zone 10\",GEOGCS[");
    add_srs_wkt (p, 1,
        "\"TUREF\",DATUM[\"Turkish_National_Reference_Frame\",SPH");
    add_srs_wkt (p, 2,
        "EROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPS");
    add_srs_wkt (p, 3,
        "G\",\"7019\"]],AUTHORITY[\"EPSG\",\"1057\"]],PRIMEM[\"Gr");
    add_srs_wkt (p, 4,
        "eenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\"");
    add_srs_wkt (p, 5,
        ",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHOR");
    add_srs_wkt (p, 6,
        "ITY[\"EPSG\",\"5252\"]],PROJECTION[\"Transverse_Mercator");
    add_srs_wkt (p, 7,
        "\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"cent");
    add_srs_wkt (p, 8,
        "ral_meridian\",30],PARAMETER[\"scale_factor\",1],PARAMET");
    add_srs_wkt (p, 9,
        "ER[\"false_easting\",10500000],PARAMETER[\"false_northin");
    add_srs_wkt (p, 10,
        "g\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AX");
    add_srs_wkt (p, 11,
        "IS[\"Northing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[");
    add_srs_wkt (p, 12,
        "\"EPSG\",\"5270\"]]");
    p = add_epsg_def_ex (filter, first, last, 5271, "epsg", 5271,
        "TUREF / 3-degree Gauss-Kruger zone 11", 0, 1,
        "GRS 1980", "Greenwich",
        "Turkish_National_Reference_Frame", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=33 +k=1 +x_0=11500000 +y_0=0");
    add_proj4text (p, 1,
        " +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"TUREF / 3-degree Gauss-Kruger zone 11\",GEOGCS[");
    add_srs_wkt (p, 1,
        "\"TUREF\",DATUM[\"Turkish_National_Reference_Frame\",SPH");
    add_srs_wkt (p, 2,
        "EROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPS");
    add_srs_wkt (p, 3,
        "G\",\"7019\"]],AUTHORITY[\"EPSG\",\"1057\"]],PRIMEM[\"Gr");
    add_srs_wkt (p, 4,
        "eenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\"");
    add_srs_wkt (p, 5,
        ",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHOR");
    add_srs_wkt (p, 6,
        "ITY[\"EPSG\",\"5252\"]],PROJECTION[\"Transverse_Mercator");
    add_srs_wkt (p, 7,
        "\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"cent");
    add_srs_wkt (p, 8,
        "ral_meridian\",33],PARAMETER[\"scale_factor\",1],PARAMET");
    add_srs_wkt (p, 9,
        "ER[\"false_easting\",11500000],PARAMETER[\"false_northin");
    add_srs_wkt (p, 10,
        "g\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AX");
    add_srs_wkt (p, 11,
        "IS[\"Northing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[");
    add_srs_wkt (p, 12,
        "\"EPSG\",\"5271\"]]");
    p = add_epsg_def_ex (filter, first, last, 5272, "epsg", 5272,
        "TUREF / 3-degree Gauss-Kruger zone 12", 0, 1,
        "GRS 1980", "Greenwich",
        "Turkish_National_Reference_Frame", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=36 +k=1 +x_0=12500000 +y_0=0");
    add_proj4text (p, 1,
        " +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"TUREF / 3-degree Gauss-Kruger zone 12\",GEOGCS[");
    add_srs_wkt (p, 1,
        "\"TUREF\",DATUM[\"Turkish_National_Reference_Frame\",SPH");
    add_srs_wkt (p, 2,
        "EROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPS");
    add_srs_wkt (p, 3,
        "G\",\"7019\"]],AUTHORITY[\"EPSG\",\"1057\"]],PRIMEM[\"Gr");
    add_srs_wkt (p, 4,
        "eenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\"");
    add_srs_wkt (p, 5,
        ",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHOR");
    add_srs_wkt (p, 6,
        "ITY[\"EPSG\",\"5252\"]],PROJECTION[\"Transverse_Mercator");
    add_srs_wkt (p, 7,
        "\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"cent");
    add_srs_wkt (p, 8,
        "ral_meridian\",36],PARAMETER[\"scale_factor\",1],PARAMET");
    add_srs_wkt (p, 9,
        "ER[\"false_easting\",12500000],PARAMETER[\"false_northin");
    add_srs_wkt (p, 10,
        "g\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AX");
    add_srs_wkt (p, 11,
        "IS[\"Northing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[");
    add_srs_wkt (p, 12,
        "\"EPSG\",\"5272\"]]");
    p = add_epsg_def_ex (filter, first, last, 5273, "epsg", 5273,
        "TUREF / 3-degree Gauss-Kruger zone 13", 0, 1,
        "GRS 1980", "Greenwich",
        "Turkish_National_Reference_Frame", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=39 +k=1 +x_0=13500000 +y_0=0");
    add_proj4text (p, 1,
        " +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"TUREF / 3-degree Gauss-Kruger zone 13\",GEOGCS[");
    add_srs_wkt (p, 1,
        "\"TUREF\",DATUM[\"Turkish_National_Reference_Frame\",SPH");
    add_srs_wkt (p, 2,
        "EROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPS");
    add_srs_wkt (p, 3,
        "G\",\"7019\"]],AUTHORITY[\"EPSG\",\"1057\"]],PRIMEM[\"Gr");
    add_srs_wkt (p, 4,
        "eenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\"");
    add_srs_wkt (p, 5,
        ",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHOR");
    add_srs_wkt (p, 6,
        "ITY[\"EPSG\",\"5252\"]],PROJECTION[\"Transverse_Mercator");
    add_srs_wkt (p, 7,
        "\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"cent");
    add_srs_wkt (p, 8,
        "ral_meridian\",39],PARAMETER[\"scale_factor\",1],PARAMET");
    add_srs_wkt (p, 9,
        "ER[\"false_easting\",13500000],PARAMETER[\"false_northin");
    add_srs_wkt (p, 10,
        "g\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AX");
    add_srs_wkt (p, 11,
        "IS[\"Northing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[");
    add_srs_wkt (p, 12,
        "\"EPSG\",\"5273\"]]");
    p = add_epsg_def_ex (filter, first, last, 5274, "epsg", 5274,
        "TUREF / 3-degree Gauss-Kruger zone 14", 0, 1,
        "GRS 1980", "Greenwich",
        "Turkish_National_Reference_Frame", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=42 +k=1 +x_0=14500000 +y_0=0");
    add_proj4text (p, 1,
        " +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"TUREF / 3-degree Gauss-Kruger zone 14\",GEOGCS[");
    add_srs_wkt (p, 1,
        "\"TUREF\",DATUM[\"Turkish_National_Reference_Frame\",SPH");
    add_srs_wkt (p, 2,
        "EROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPS");
    add_srs_wkt (p, 3,
        "G\",\"7019\"]],AUTHORITY[\"EPSG\",\"1057\"]],PRIMEM[\"Gr");
    add_srs_wkt (p, 4,
        "eenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\"");
    add_srs_wkt (p, 5,
        ",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHOR");
    add_srs_wkt (p, 6,
        "ITY[\"EPSG\",\"5252\"]],PROJECTION[\"Transverse_Mercator");
    add_srs_wkt (p, 7,
        "\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"cent");
    add_srs_wkt (p, 8,
        "ral_meridian\",42],PARAMETER[\"scale_factor\",1],PARAMET");
    add_srs_wkt (p, 9,
        "ER[\"false_easting\",14500000],PARAMETER[\"false_northin");
    add_srs_wkt (p, 10,
        "g\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AX");
    add_srs_wkt (p, 11,
        "IS[\"Northing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[");
    add_srs_wkt (p, 12,
        "\"EPSG\",\"5274\"]]");
    p = add_epsg_def_ex (filter, first, last, 5275, "epsg", 5275,
        "TUREF / 3-degree Gauss-Kruger zone 15", 0, 1,
        "GRS 1980", "Greenwich",
        "Turkish_National_Reference_Frame", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=45 +k=1 +x_0=15500000 +y_0=0");
    add_proj4text (p, 1,
        " +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"TUREF / 3-degree Gauss-Kruger zone 15\",GEOGCS[");
    add_srs_wkt (p, 1,
        "\"TUREF\",DATUM[\"Turkish_National_Reference_Frame\",SPH");
    add_srs_wkt (p, 2,
        "EROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPS");
    add_srs_wkt (p, 3,
        "G\",\"7019\"]],AUTHORITY[\"EPSG\",\"1057\"]],PRIMEM[\"Gr");
    add_srs_wkt (p, 4,
        "eenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\"");
    add_srs_wkt (p, 5,
        ",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHOR");
    add_srs_wkt (p, 6,
        "ITY[\"EPSG\",\"5252\"]],PROJECTION[\"Transverse_Mercator");
    add_srs_wkt (p, 7,
        "\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"cent");
    add_srs_wkt (p, 8,
        "ral_meridian\",45],PARAMETER[\"scale_factor\",1],PARAMET");
    add_srs_wkt (p, 9,
        "ER[\"false_easting\",15500000],PARAMETER[\"false_northin");
    add_srs_wkt (p, 10,
        "g\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AX");
    add_srs_wkt (p, 11,
        "IS[\"Northing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[");
    add_srs_wkt (p, 12,
        "\"EPSG\",\"5275\"]]");
    p = add_epsg_def_ex (filter, first, last, 5292, "epsg", 5292,
        "DRUKREF 03 / Bumthang TM", 0, 0,
        "GRS 1980", "Greenwich",
        "Bhutan_National_Geodetic_Datum", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=90.73333333333333 +k=1 +x_0=");
    add_proj4text (p, 1,
        "250000 +y_0=-2500000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0");
    add_proj4text (p, 2,
        " +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"DRUKREF 03 / Bumthang TM\",GEOGCS[\"DRUKREF 03\"");
    add_srs_wkt (p, 1,
        ",DATUM[\"Bhutan_National_Geodetic_Datum\",SPHEROID[\"GRS");
    add_srs_wkt (p, 2,
        " 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"");
    add_srs_wkt (p, 3,
        "]],AUTHORITY[\"EPSG\",\"1058\"]],PRIMEM[\"Greenwich\",0,");
    add_srs_wkt (p, 4,
        "AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329");
    add_srs_wkt (p, 5,
        "25199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"5264\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETE");
    add_srs_wkt (p, 7,
        "R[\"latitude_of_origin\",0],PARAMETER[\"central_meridian");
    add_srs_wkt (p, 8,
        "\",90.7333333333333],PARAMETER[\"scale_factor\",1],PARAM");
    add_srs_wkt (p, 9,
        "ETER[\"false_easting\",250000],PARAMETER[\"false_northin");
    add_srs_wkt (p, 10,
        "g\",-2500000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001");
    add_srs_wkt (p, 11,
        "\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUT");
    add_srs_wkt (p, 12,
        "HORITY[\"EPSG\",\"5292\"]]");
    p = add_epsg_def_ex (filter, first, last, 5293, "epsg", 5293,
        "DRUKREF 03 / Chhukha TM", 0, 0,
        "GRS 1980", "Greenwich",
        "Bhutan_National_Geodetic_Datum", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=89.55 +k=1 +x_0=250000 +y_0=");
    add_proj4text (p, 1,
        "-2500000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +n");
    add_proj4text (p, 2,
        "o_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"DRUKREF 03 / Chhukha TM\",GEOGCS[\"DRUKREF 03\"");
    add_srs_wkt (p, 1,
        ",DATUM[\"Bhutan_National_Geodetic_Datum\",SPHEROID[\"GRS");
    add_srs_wkt (p, 2,
        " 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"");
    add_srs_wkt (p, 3,
        "]],AUTHORITY[\"EPSG\",\"1058\"]],PRIMEM[\"Greenwich\",0,");
    add_srs_wkt (p, 4,
        "AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329");
    add_srs_wkt (p, 5,
        "25199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"5264\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETE");
    add_srs_wkt (p, 7,
        "R[\"latitude_of_origin\",0],PARAMETER[\"central_meridian");
    add_srs_wkt (p, 8,
        "\",89.55],PARAMETER[\"scale_factor\",1],PARAMETER[\"fals");
    add_srs_wkt (p, 9,
        "e_easting\",250000],PARAMETER[\"false_northing\",-250000");
    add_srs_wkt (p, 10,
        "0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"");
    add_srs_wkt (p, 11,
        "Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPS");
    add_srs_wkt (p, 12,
        "G\",\"5293\"]]");
    p = add_epsg_def_ex (filter, first, last, 5294, "epsg", 5294,
        "DRUKREF 03 / Dagana TM", 0, 0,
        "GRS 1980", "Greenwich",
        "Bhutan_National_Geodetic_Datum", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=89.84999999999999 +k=1 +x_0=");
    add_proj4text (p, 1,
        "250000 +y_0=-2500000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0");
    add_proj4text (p, 2,
        " +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"DRUKREF 03 / Dagana TM\",GEOGCS[\"DRUKREF 03\",");
    add_srs_wkt (p, 1,
        "DATUM[\"Bhutan_National_Geodetic_Datum\",SPHEROID[\"GRS ");
    add_srs_wkt (p, 2,
        "1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"");
    add_srs_wkt (p, 3,
        "]],AUTHORITY[\"EPSG\",\"1058\"]],PRIMEM[\"Greenwich\",0,");
    add_srs_wkt (p, 4,
        "AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329");
    add_srs_wkt (p, 5,
        "25199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"5264\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETE");
    add_srs_wkt (p, 7,
        "R[\"latitude_of_origin\",0],PARAMETER[\"central_meridian");
    add_srs_wkt (p, 8,
        "\",89.85],PARAMETER[\"scale_factor\",1],PARAMETER[\"fals");
    add_srs_wkt (p, 9,
        "e_easting\",250000],PARAMETER[\"false_northing\",-250000");
    add_srs_wkt (p, 10,
        "0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"");
    add_srs_wkt (p, 11,
        "Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPS");
    add_srs_wkt (p, 12,
        "G\",\"5294\"]]");
}

#endif /* full EPSG initialization enabled/disabled */

