# Soya 3D tutorial
# Copyright (C) 2003 Bertrand 'blam!' LAMY
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA


# ---------------------
# Lesson 122: Shape LOD
# ---------------------
#
# A ShapeLOD is a Shape with multiple LOD (levels of detail). The transition
# between LOD levels is not smoothed. Each LOD is in fact a different Shape.

import os, os.path, sys, time

import soya
import soya.model
import soya.widget
import soya.soya3d
import soya.sphere


soya.init()

# Create a world
scene = soya.soya3d.World()

# Create some spheres with different number of faces (= LOD)
w = soya.sphere.Sphere(None, None, slices = 20, stacks = 20, smooth_lit = 0)
sphere20 = w.shapify()
w = soya.sphere.Sphere(None, None, slices = 15, stacks = 15, smooth_lit = 0)
sphere15 = w.shapify()
w = soya.sphere.Sphere(None, None, slices = 10, stacks = 10, smooth_lit = 0)
sphere10 = w.shapify()
w = soya.sphere.Sphere(None, None, slices = 6, stacks = 5, smooth_lit = 0)
sphere5 = w.shapify()


# Create the ShapeLOD
# -------------------
# shapes is the list of Shape for each LOD, first shape is the maximum LOD
# (maximum detail), last shape is the minimum LOD.
sphere = soya.model.ShapeLOD(shapes = [sphere20, sphere15, sphere10, sphere5])

# ShapeLOD.LOD_factor is the float value that controls which LOD level is
# displayed in function of the distance of the ShapeLOD to the camera.
# Higher value means LOD changes for fewer distance to camera. Default value
# is 0.2
sphere.LOD_factor = 0.2

# A few things to remember about ShapeLOD:
#   - raypicking is always performed with the most accurate LOD level
#   - visibility computations are always performed with the sphere of
#       most accurate LOD level

scene.shape = sphere


# Add a light
light = soya.soya3d.Light(scene)
light.set_xyz(-2.0, 2.0, 2.0)

# Add a camera and a loop to render
roow = soya.widget.Group()
camera = soya.soya3d.Camera(scene)
camera.set_xyz(0.0, 0.0, 6.0)
roow.add(camera)

label = soya.widget.Label(roow, " - ShapeLOD demo -\n Left click: forward, Right click: backward")
label.resize_style = soya.widget.WIDGET_RESIZE_MAXIMIZE

soya.set_root_widget(roow)

advance = 0
while(1):
  time.sleep(0.1)

  for event in soya.process_event():

    if event[0] == soya.KEYDOWN:
      sys.exit()

    elif event[0] == soya.MOUSEBUTTONUP:
      advance = 0

    elif event[0] == soya.MOUSEBUTTONDOWN:
      if event[1] == soya.BUTTON_LEFT:
        advance = 1
      elif event[1] == soya.BUTTON_RIGHT:
        advance = -1

  if advance > 0:
    camera.shift(0.0, 0.0, -0.5)
  elif advance < 0:
    camera.shift(0.0, 0.0, 0.5)

  soya.render()
