# Soya 3D tutorial
# Copyright (C) 2001-2002 Jean-Baptiste LAMY
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

# Lesson 116: 3D Sound

# In this lesson, we integrate 3D sounds by using OpenAL and PyOpenAL.
# PyOpenAL includes a special module for using it along with Soya.
#
# You need to install OpenAL and PyOpenAL before running this lesson !
# You may need to stop artsd daemon too (typically for KDE user)
#
# The lesson draws a moving cube that play a 3D sound.

import os, os.path, sys

import soya, soya.soya3d as soya3d, soya.model as model, soya.cube as cube
soya.init()

scene = soya3d.World()

camera = soya3d.Camera(scene)
camera.y = 0.3
camera.z = 2.0

soya.set_root_widget(camera)


# Imports OpenAL.

import pyopenal, pyopenal.openal4soya as openal4soya

# Inits the OpenAL for Soya module, and pass to it the location of the listener
# (usually the camera).

openal4soya.init(camera)

# Define the sound directory

openal4soya.PATH = os.path.join(os.path.dirname(os.path.abspath(sys.argv[0])), "data")


# Create a cube.

cube = soya3d.Volume(scene, cube.Cube().shapify())

# The cube continuously play a sound
#
# The parameters for play are:
#  - the sound file name (supported format: Wave, and Ogg Vorbis if PyVorbis is installed)
#  - the sound position
#  - the sound speed (a Vector, optional)
#    the speed is automatically computed if omitted
#  - 1 for looping (0 else)
#  - 1 to load the sound asynchronously (if not already cached)

openal4soya.play("test.wav", cube, None, 1)


light = soya3d.Light(scene)
light.set_xyz(1.5, 2.0, 2.2)

import time, math

angle = 3.0

while 1:
  
  # Move the cube.
  # The sound's source is automagically moved with the cube.
  
  angle += 0.1
  cube.set_xyz(3.0 * math.cos(angle), 0.0, 3.0 * math.sin(angle))
  
  soya.render()
  
  time.sleep(0.1)

