# Soya 3D tutorial
# Copyright (C) 2001-2002 Jean-Baptiste LAMY
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

# Lesson 111: Demo : "the red place autocar" demo

import time, sys
import _soya, soya
import soya.model    as model
import soya.soya3d   as soya3d
import soya.particle as particle
import soya.cube     as cube
import soya.cursor   as cursor, soya.widget as widget, soya.idler as idler
from   soya.math3d import Point, Vector

soya.init()

scene    = soya3d.World()
camera   = soya3d.Camera(scene)
camera.y = 20.0
camera.z = 5.0
camera.look_at(Point(scene, 0.0, 0.0, 0.0))

soya.set_root_widget(widget.Group())
soya.root_widget.add(camera)
soya.root_widget.add(widget.FPSLabel())

light    = soya3d.Light(scene)
light.set_xyz(1.5, 2.0, 0.2)

# Draws the "red place"

material = model.Material()
material.diffuse = (1.0, 0.0, 0.0, 1.0)

ground = model.Face(scene, [
  model.Vertex(scene, -10.0, 0.0, -10.0, 0.0, 0.0),
  model.Vertex(scene, -10.0, 0.0,  10.0, 1.0, 0.0),
  model.Vertex(scene,  10.0, 0.0,  10.0, 1.0, 1.0),
  model.Vertex(scene,  10.0, 0.0, -10.0, 0.0, 1.0),
  ], material)


class Vehicle(soya3d.World):
  def __init__(self, parent = None):
    soya3d.World.__init__(self, parent)
    cube.Cube(None, model.Material(), self)
    self.mouse_x      = camera.get_screen_width () / 2
    self.mouse_y      = camera.get_screen_height() / 2
    self.speed        = Vector()
    self.scale_x      = 0.5
    self.brake        = 0
    
  def begin_round(self):
    for event in cursor.coalesce_motion_event(soya.process_event()):
      if   event[0] == soya.MOUSEMOTION:
        self.mouse_x = event[1]
        self.mouse_y = event[2]
        
      elif event[0] == soya.MOUSEBUTTONDOWN: self.brake = 1
      elif event[0] == soya.MOUSEBUTTONUP:   self.brake = 0
      
  def advance_time(self, proportion):
    acceleration = Vector(
      None,
      float(self.mouse_x - camera.get_screen_width () / 2) / camera.get_screen_width () / 100.0,
      0.0,
      float(self.mouse_y - camera.get_screen_height() / 2) / camera.get_screen_height() / 100.0,
      )
    
    maxspeed = 1.0
    if self.speed.length() > maxspeed: self.speed.set_length(self.speed.length() * 0.9)
    self.speed += acceleration * proportion * 50.0
    self       += self.speed   * proportion
    
    if self.brake:
      self.speed.set_length(self.speed.length() * 0.1)
      

    self.look_at(self.speed)
    
    if self.speed.length():
      camera.move(self)
      camera.z = camera.z + 4.0
      camera.y = 15.0
      
    if   self.x < -10.0: self.speed.x =  abs(self.speed.x) * 2
    elif self.x >  10.0: self.speed.x = -abs(self.speed.x) * 2
    if   self.z < -10.0: self.speed.z =  abs(self.speed.z) * 2
    elif self.z >  10.0: self.speed.z = -abs(self.speed.z) * 2
    
vehicle = Vehicle(scene)
vehicle.y = 0.5


idler.Idler(scene).idle()

  
