# Soya 3D tutorial
# Copyright (C) 2001-2002 Jean-Baptiste LAMY
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

# Lesson 106: Ray : the light sword

# This lesson is a light sword, which can be controlled with the mouse.

import soya, soya.soya3d as soya3d, soya.model as model, soya.cube as cube, soya.widget as widget, soya.idler as idler, soya.cursor
from soya.math3d import Point

soya.init()

scene = soya3d.World()

metal_bar = soya3d.World(scene)
metal_bar.y = -1.5

# This is the material used in lesson 3

material = model.Material()
material.shininess = 0.5
material.diffuse   = (0.5, 0.5, 0.5, 1.0)
material.specular  = (0.7, 0.7, 1.0, 1.0)

c = cube.Cube(None, material)
c.scale(0.1, 0.1, 3.0)

volume = soya3d.Volume(metal_bar, c.shapify())
volume.z = -1.7

c = cube.Cube(None, material)
c.scale(0.8, 0.1, 0.1)

volume = soya3d.Volume(metal_bar, c.shapify())
volume.z = -0.8

light = soya3d.Light(scene)
light.set_xyz(0.0, 0.2, 1.0)

camera = soya3d.Camera(scene)
camera.set_xyz(0.0, 0.0, 3.0)

soya.set_root_widget(widget.Group())
soya.root_widget.add(camera)
soya.root_widget.add(widget.FPSLabel())

# Creates the material for the ray.

material = model.Material()
material.shininess = 0.5
material.diffuse   = (0.5, 0.5, 0.7, 1.0)
material.specular  = (0.7, 0.7, 1.0, 1.0)
material.additive_blending = 1 # Additive blending istypically used for FX

# Creates the ray.

import soya.ray
ray = soya.ray.Ray(metal_bar, length = 20)
ray.z = -0.8
ray.endpoint = Point(metal_bar, 0.0, 0.0, -3.2)
ray.material = material

# Hide the mouse cursor

soya.cursor_set_visible(0)


def begin_round():
  # Processes the events
  
  # soya.cursor.coalesce_motion_event() removes all mouse motion events, except
  # the last one -- we use it for speed gain, since many mouse motion event
  # often occur at the same time.
  
  for event in soya.cursor.coalesce_motion_event(soya.process_event()):
    if event[0] == soya.MOUSEMOTION:
      
      # For mouse motion event, rotate the laser (quite) toward the mouse.
      # The formulas are empirical; see soya.cursor for a better algorithm
      # if you want to translate mouse positions into 3D coordinates.
      
      mouse = Point(
        scene,
        (float(event[1]) / camera.get_screen_width () - 0.5) *  2.0,
        (float(event[2]) / camera.get_screen_height() - 0.5) * -4.0,
        (float(event[2]) / camera.get_screen_height() - 0.5) * -1.0 + 0.25,
        )
      metal_bar.look_at(mouse)
  
metal_bar.begin_round = begin_round

# Main loop

idler.Idler(scene).idle()


# TODO (left as an exercice):
# Turn this tutorial lesson into a full Doom-like game!
