# Soya 3D tutorial
# Copyright (C) 2001-2002 Jean-Baptiste LAMY
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

# Lesson 015: Character animation with Cal3D : Mixing Cal3D and Soya, or Balazar with a knife...
#
# In this lesson, we add a knife in the right hand of Balazar,
# the sorcerer of the lesson 014.
# The knife is a Soya object, wich is added in the Cal3D character !


import os, os.path, sys
import soya, soya.soya3d as soya3d, soya.model as model, soya.cal3d as cal3d, soya.idler as idler, soya.widget as widget

soya.init()

scene = soya3d.World()

model .Shape   .PATH = os.path.join(os.path.dirname(os.path.abspath(sys.argv[0])), "data", "shapes")
model .Material.PATH = os.path.join(os.path.dirname(os.path.abspath(sys.argv[0])), "data", "materials")
soya3d.World   .PATH = os.path.join(os.path.dirname(os.path.abspath(sys.argv[0])), "data", "worlds")

sorcerer_shape = cal3d.Shape.get("balazar")

# We need the sorcerer to be a World, in order to add other world in it.
# The Cal3D volume is now added in the sorcerer world.

sorcerer = soya3d.World(scene)
sorcerer.rotate_lateral(-120.0)
sorcerer_volume = cal3d.Volume(sorcerer, sorcerer_shape)
sorcerer_volume.animate_blend_cycle("marche")

right_hand = soya3d.World(sorcerer)
sorcerer_volume.attach_to_bone(right_hand, "mainD")

right_hand_item = soya3d.Volume(right_hand, model.Shape.get("couteau"))
right_hand_item.rotate_incline(180.0)
right_hand_item.set_xyz(0.05, 0.1, 0.0)

# By using right_hand_item.set_shape(...), you can easily replace the knife by a sword,
# an axe, or a gun !
# Use Soya system coordinate conversion facilities for collision detection
# (e.g. Point(right_hand_item, 0.0, 0.0, -3.0) is the end of the knife)

camera = soya3d.Camera(scene)
camera.set_xyz(0.0, 1.5, 3.0)

soya.set_root_widget(widget.Group())
soya.root_widget.add(camera)
soya.root_widget.add(widget.FPSLabel())

soya3d.Light(scene).set_xyz(5.0, 5.0, 8.0)

idler.Idler(scene).idle()


