# Soya 3D tutorial
# Copyright (C) 2001-2002 Jean-Baptiste LAMY
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

# Lesson 003: Modeling : a metallic cube

# This lesson is similar to lesson 001, but it demonstrates the use of material
# properties. The cube now has a metallic color and specular.

import soya, soya.soya3d as soya3d, soya.model as model, soya.cube as cube

soya.init()

scene = soya3d.World()

# Creates the material

material = model.Material()

# Sets the material's shininess to 0.5. The shininess ranges from 0.0 to 128.0;
# 0.0 is the most metallic / shiny, and 128.0 is the most plastic.

material.shininess = 0.5

# Sets the material's diffuse color. The diffuse color is the basic color.
# In Soya 3D, colors are tupples of 4 floats: (red, green, blue, alpha), where
# each component normally ranges from 0.0 to 1.0 (though you can use values
# out of this range, e.g. to get a dark light), and alpha is used for
# transparency (1.0 is opaque and 0.0 fully transparent).
#
# We use here a light gray.

material.diffuse   = (0.7, 0.7, 0.7, 1.0)

# Sets the material's specular color. The specular color is the one used for
# the specular / shiny effects.
#
# We use here a light blue, to get metallic reflexions.

material.specular  = (0.7, 0.7, 1.0, 1.0)

# Other interesting attributes of materials are:
# - wireframed        : draw in wireframe
# - additive_blending : usefull for alpha-blending and special effect
# - tex_name          : 
# - separate_specular : 

cube = cube.Cube(scene, material)
cube.rotate_vertical(30.0)

light = soya3d.Light(scene)
light.set_xyz(0.0, 0.2, 1.0)

camera = soya3d.Camera(scene)
camera.z = 2.0
soya.set_root_widget(camera)


def advance_time(proportion):
  cube.rotate_lateral(proportion * 10.0)
  cube.rotate_incline(proportion *  5.0)
  
cube.advance_time = advance_time


import time

while 1:
  soya.render()
  
  scene.begin_round()
  scene.advance_time()
  
  time.sleep(0.1)
