# Soya 3D
# Copyright (C) 2001-2002 Jean-Baptiste LAMY -- jiba@tuxfamily.org
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

"""soya.math3d

This module provides the Point and Vector classes that are used for 3D math
computation, such as coordinates system conversion.

In Soya 3D, a position is defined by 3 coordinates
(x, y, z) AND the coordinates system in which the coordinates are defined
(sometime called the "parent").

Points and Vectors are used for math computation; my own experience in 3D
has convinced me that ANY complicated 3D computation can be heavily
simplified by the use of coordinates system conversions. As Soya 3D
associates the coordinates system along with the coordinates values, it
performs coordinates system conversion automagically !"""

import math
import soya
import _soya
import copy_reg


class Parentable:
  def __deepcopy__(self, memo):
    # Do not clone the parent (except if already cloned before, in the memo) !
    import copy
    
    red = self.__reduce__()
    clone = red[1][0]()
    memo[id(self)] = clone
    state = red[2]
    
    if self.parent and (not id(self.parent) in memo.keys()):
      state = (None, state[1], state[2], state[3])
      
    s2 = copy.deepcopy(state, memo)
    clone.__setstate__(s2)
    return clone


class Point(Parentable, _soya._Point):
  pass

class Vector(Parentable, _soya._Vector):
  pass

__all__ = ["Point", "Vector"]

#Point  = _soya.Point
#Vector = _soya.Vector

#def soya_generic_reduce (obj):
#  return (soya._soya_reconstructor, (obj.__class__, ), obj.__getstate__())

#copy_reg.constructor(Point)
#copy_reg.constructor(Vector)
#copy_reg.pickle(Point,  soya_generic_reduce, soya._soya_reconstructor)
#copy_reg.pickle(Vector, soya_generic_reduce, soya._soya_reconstructor)



## class Point(_soya.Point):
## #class Point(object):
##   "A Point is a 3D position."
  
##   def __init__(self, parent = None, x = 0.0, y = 0.0, z = 0.0):
##     """Point(parent = None, x = 0.0, y = 0.0, z = 0.0)

## Creates a new Point, with coordinates X, Y and Z, defined in the coordinates
## system PARENT.
## """

##     _soya.Point.__init__(self, parent, x, y, z)
    
##     # Very common error
##     #assert parent.__class__ is not float, "Parent must be a coordinate system !!!"
##     if parent.__class__ is float: raise TypeError, "Parent must be a coordinate system !!!"
    
##     self.parent = parent
    
##     self.x = x
##     self.y = y
##     self.z = z
    
##   def get_root(self):
##     """Point.get_root() -> World

## Gets the root parent of a Point. The root parent is the root World of the
## hierarchy (often called the "scene" object)."""
##     if self.parent: return self.parent.get_root()
    
##   def set_xyz(self, x, y, z):
##     """Point.set_xyz(x, y, z)

## Sets the coordinates of a point to X, Y and Z."""
##     self.x = x
##     self.y = y
##     self.z = z
    
##   def move(self, position):
##     """Point.move(position)

## Moves a Point to POSITION (a Point or another 3D object, such as a World,
## a volume,...).
## Coordinates system conversion is performed if needed (=if the Point and
## POSITION are not defined in the same coordinates system)."""
##     if (not position.parent) or (not self.parent) or (self.parent is position.parent):
##       self.x = position.x
##       self.y = position.y
##       self.z = position.z
##     else:
##       self.x, self.y, self.z = self.parent.transform_point(position.x, position.y, position.z, position.parent)
      
##   def convert_to(self, parent):
##     """Point.convert_to(parent)

## Converts a Point to the coordinates system PARENT in place. The x, y and z
## coordinates are modified, and the Point's parent is set to PARENT."""
##     if parent:
##       self.x, self.y, self.z = parent.transform_point(self.x, self.y, self.z, self.parent)
##     self.parent = parent
##   __imod__ = convert_to
  
##   def copy(self):
##     """Point.copy() -> Point

## Returns a copy of a Point."""
##     return Point(self.parent, self.x, self.y, self.z)
##   position = copy
  
##   def clone(self, other):
##     """Point.clone(other)

## Changes IN PLACE this Point so as it is a clone of OTHER."""
##     self.parent = other.parent
##     self.x= other.x
##     self.y= other.y
##     self.z= other.z
    
##   def __mod__(self, coordsyst):
##     """Point % coordsyst -> Point

## Converts a Point to the coordinates system COORDSYST and returns the result.
## The returned value may be the same Point if its coordinates system is
## already COORDSYST, so you should be carreful if you modify it."""
##     if (not self.parent) or (not coordsyst) or (self.parent is coordsyst): return self
##     p = Point(self.parent, self.x, self.y, self.z)
##     p.convert_to(coordsyst)
##     return p
  
##   def __add__(self, vector):
##     """Point + Vector -> Point

## Translates a Point and returns the result (a new Point).
## Coordinates system conversion is performed if needed (=if the Point and
## VECTOR are not defined in the same coordinates system)."""
##     if (not vector.parent) or (not self.parent) or (self.parent is vector.parent):
##       return Point(self.parent, self.x + vector.x, self.y + vector.y, self.z + vector.z)
##     else:
##       x, y, z = self.parent.transform_vector(vector.x, vector.y, vector.z, vector.parent)
##       return Point(self.parent, self.x + x, self.y + y, self.z + z)
  
##   def __sub__(self, vector):
##     """Point - Vector -> Point

## Translates a Point and returns the result (a new Point).
## Coordinates system conversion is performed if needed (=if the Point and
## VECTOR are not defined in the same coordinates system)."""
##     if (not vector.parent) or (not self.parent) or (self.parent is vector.parent):
##       return Point(self.parent, self.x - vector.x, self.y - vector.y, self.z - vector.z)
##     else:
##       x, y, z = self.parent.transform_vector(vector.x, vector.y, vector.z, vector.parent)
##       return Point(self.parent, self.x - x, self.y - y, self.z - z)
  
##   def add_xyz(self, x, y, z):
##     """Point.add_xyz(x, y, z)

## Translates the coordinates of a point by X, Y and Z."""
##     self.x += x
##     self.y += y
##     self.z += z
    
##   def add_vector(self, vector):
##     """Point.add_vector(vector)

## Translates a Point IN PLACE.
## Coordinates system conversion is performed if needed (=if the Point and
## VECTOR are not defined in the same coordinates system).

## For Vector, add_vector means vectorial addition (translating a vector does
## nothing !)."""
##     if (not vector.parent) or (not self.parent) or (self.parent is vector.parent):
##       self.x += vector.x
##       self.y += vector.y
##       self.z += vector.z
##     else:
##       x, y, z = self.parent.transform_vector(vector.x, vector.y, vector.z, vector.parent)
##       self.x += x
##       self.y += y
##       self.z += z
      
##     return self
##   __iadd__ = add_vector
  
##   def add_mul_vector(self, k, vector):
##     """Point.add_mul_vector(k, vector)

## Translates a Point IN PLACE, by K * VECTOR.
## Coordinates system conversion is performed if needed (=if the Point and
## VECTOR are not defined in the same coordinates system).

## For Vector, add_vector means vectorial addition (translating a vector does
## nothing !)."""
##     if (not vector.parent) or (not self.parent) or (self.parent is vector.parent):
##       self.x += k * vector.x
##       self.y += k * vector.y
##       self.z += k * vector.z
##     else:
##       x, y, z = self.parent.transform_vector(vector.x, vector.y, vector.z, vector.parent)
##       self.x += k * x
##       self.y += k * y
##       self.z += k * z
##     return self
  
##   def distance_to(self, other):
##     """Point.distance_to(other) -> float

## Gets the distance between a Point and anOTHER."""
##     if (not other.parent) or (not self.parent) or (self.parent is other.parent):
##       return math.sqrt((self.x - other.x) ** 2 + (self.y - other.y) ** 2 + (self.z - other.z) ** 2)
##     else:
##       x, y, z = self.parent.transform_point(other.x, other.y, other.z, other.parent)
##       return math.sqrt((self.x - x) ** 2 + (self.y - y) ** 2 + (self.z - z) ** 2)
    
##   def vector_to(self, other):
##     """Point.vector_to(other) -> Vector

## Gets the vector that starts at a Point and ends at OTHER."""
##     if (not other.parent) or (not self.parent) or (self.parent is other.parent):
##       return Vector(self.parent, other.x - self.x, other.y - self.y, other.z - self.z)
##     else:
##       x, y, z = self.parent.transform_point(other.x, other.y, other.z, other.parent)
##       return Vector(self.parent, x - self.x, y - self.y, z - self.z)
##   __rshift__ = vector_to
  
##   def __eq__(self, other):
##     return hasattr(other, "x") and hasattr(other, "y") and hasattr(other, "z") and hasattr(other, "parent") and (self.parent is other.parent) and (self.x == other.x) and (self.y == other.y) and (self.z == other.z)
  
##   def __ne__(self, other):
##     return hasattr(other, "x") and hasattr(other, "y") and hasattr(other, "z") and hasattr(other, "parent") and (not (self.parent is other.parent) and (self.x == other.x) and (self.y == other.y) and (self.z == other.z))
  
##   def __repr__(self): return "<Point %s, %s, %s in %s>" % (self.x, self.y, self.z, self.parent)
  
## #   def __deepcopy__(self, memo):
## #     # Don't copy the parent !
## #     import copy
    
## #     red = self.__reduce__()
    
## #     clone = _Empty()
## #     clone.__class__ = red[1][0]
## #     memo[id(self)] = clone
    
## #     state = red[2]
## #     if state is self.__dict__: state = state.copy()
## #     copy._keep_alive(state, memo)
      
## #     if not id(self.parent) in memo.keys():
## #       del state["parent"]
## #       state = copy.deepcopy(state, memo)
## #       state["parent"] = self.parent
## #     else:
## #       state = copy.deepcopy(state, memo)
## #     copy._keep_alive(state, memo)
    
## #     if hasattr(clone, "__setstate__"): clone.__setstate__(state)
## #     else:                              clone.__dict__ = state
    
## #     return clone
  
  
##   def __deepcopy__(self, memo):
##     # Do not clone the parent (except if already cloned before, in the memo) !
##     import copy
    
##     red = self.__reduce__()
    
##     clone = red[1][0]()
##     memo[id(self)] = clone
    
##     state = red[2]
  
##     if not id(self.parent) in memo.keys():
##       state = copy.copy(state)
##       state["parent"] = None

##     s2 = copy.deepcopy(state, memo)
    
##     if hasattr(clone, "__setstate__"): clone.__setstate__(s2)
##     else:                              clone.__dict__ = s2
    
##     return clone

  


## class Vector(_soya.Vector):
## #class Vector(Point):
##   """A Vector is a 3D vector (and not a kind of list or sequence ;-). Vectors are
## usefull for 3D math computation. 

## Most of the math operator, such as +, -, *, /, abs,... work on Vectors and do
## what they are intended to do ;-)

## Vector inherits from Point for practical reasons, since both have x, y, z
## coordinates and a parent."""
  
##   def __init__(_self, _parent = None, _x = 0.0, _y = 0.0, _z = 0.0):
##     _soya.Vector.__init__(_self, _parent, _x, _y, _z)

##   def move(self, position):
##     """Vector.move(position)

## Moves a Vector to POSITION (a Vector).
## Coordinates system conversion is performed if needed (=if the Vector and
## POSITION are not defined in the same coordinates system)."""
##     if (not position.parent) or (not self.parent) or (self.parent is position.parent):
##       self.x = position.x
##       self.y = position.y
##       self.z = position.z
##     else:
##       self.x, self.y, self.z = self.parent.transform_vector(position.x, position.y, position.z, position.parent)
      
##   def convert_to(self, parent):
##     """Vector.convert_to(parent)

## Converts a Vector to the coordinates system PARENT in place. The x, y and z
## coordinates are modified, and the Vector's parent is set to PARENT."""
##     if parent: self.x, self.y, self.z = parent.transform_vector(self.x, self.y, self.z, self.parent)
##     self.parent = parent
##   __imod__ = convert_to
  
##   def copy(self):
##     """Vector.copy() -> Vector

## Returns a copy of a Vector."""
##     return Vector(self.parent, self.x, self.y, self.z)
##   position = copy
  
##   def cross_product(self, vector):
##     """Vector.cross_product(VECTOR) -> Vector

## Returns the cross product of a Vector with VECTOR."""
##     return _soya.cross_vector(self, vector)
  
##   def dot_product(self, vector):
##     """Vector.dot_product(VECTOR) -> float

## Returns the dot product of a Vector with VECTOR."""
##     if (not vector.parent) or (not self.parent) or (self.parent is vector.parent):
##       return self.x * vector.x + self.y * vector.y + self.z * vector.z
##     else:
##       x, y, z = self.parent.transform_vector(vector.x, vector.y, vector.z, vector.parent)
##       return self.x * x + self.y * y + self.z * z
  
##   def length(self):
##     """Vector.length() -> float

## Gets the length of a Vector."""
##     return math.sqrt(self.x ** 2 + self.y ** 2 + self.z ** 2)
    
##   def set_length(self, new_length):
##     """Vector.set_length(new_length)

## Sets the length of a Vector to NEW_LENGTH. The Vector's coordinates are
## multiplicated as needed."""
##     f = new_length / self.length()
##     self.x *= f
##     self.y *= f
##     self.z *= f
    
##   def __mod__(self, coordsyst):
##     """Vector % coordsyst -> Vector

## Converts a Vector to the coordinates system COORDSYST and returns the result.
## The returned value may be the same Vector if its coordinates system is
## already COORDSYST, so you should be carreful if you modify it."""

##     if (not self.parent) or (not coordsyst) or (self.parent is coordsyst): return self
##     v = Vector(self.parent, self.x, self.y, self.z)
##     v.convert_to(coordsyst)
##     return v
  
##   def __mul__(self, number): return Vector(self.parent, self.x * number, self.y * number, self.z * number)
##   def __div__(self, number): return Vector(self.parent, self.x / number, self.y / number, self.z / number)
##   __truediv__ = __div__
  
##   def __imul__(self, number):
##     self.x *= number
##     self.y *= number
##     self.z *= number
##     return self
  
##   def __idiv__(self, number):
##     self.x /= number
##     self.y /= number
##     self.z /= number
##     return self
    
##   def __add__(self, vector):
##     if (not vector.parent) or (not self.parent) or (self.parent is vector.parent):
##       return Vector(self.parent, self.x + vector.x, self.y + vector.y, self.z + vector.z)
##     else:
##       x, y, z = self.parent.transform_vector(vector.x, vector.y, vector.z, vector.parent)
##       return Vector(self.parent, self.x + x, self.y + y, self.z + z)
  
##   def __sub__(self, vector):
##     if (not vector.parent) or (not self.parent) or (self.parent is vector.parent):
##       return Vector(self.parent, self.x - vector.x, self.y - vector.y, self.z - vector.z)
##     else:
##       x, y, z = self.parent.transform_vector(vector.x, vector.y, vector.z, vector.parent)
##       return Vector(self.parent, self.x - x, self.y - y, self.z - z)
  
##   def __neg__(self): return Vector(self.parent, -self.x, -self.y, -self.z)
  
##   def __abs__(self): return Vector(self.parent, abs(self.x), abs(self.y), abs(self.z))
  
##   def normalize(self):
##     """Vector.normalize()

## Normalizes a Vector IN PLACE."""
##     length = self.length()
##     self.x /= length
##     self.y /= length
##     self.z /= length
    
##   def __repr__(self): return "<Vector %s, %s, %s in %s>" % (self.x, self.y, self.z, self.parent)
  
##   def set_start_end(self, start, end):
##     """Vector.set_start_end(start, end)

## Sets this vector IN PLACE so as it correspond to the vector start->end."""
##     self.parent = start.parent
    
##     if (not start.parent) or (not end.parent) or (start.parent is end.parent):
##       self.x = end.x - start.x
##       self.y = end.y - start.y
##       self.z = end.z - start.z
##     else:
##       x, y, z = self.parent.transform_point(end.x, end.y, end.z, end.parent)
##       self.x = x - start.x
##       self.y = y - start.y
##       self.z = z - start.z

##   def angle_to(self, vector):
##     """Vector.angle_to(VECTOR) -> angle in degree

## Computes the angle between this Vector and VECTOR."""
##     vector = vector % self.parent
##     s = self.length() * vector.length()
##     f = self.dot_product(vector) / s
##     if f >=  1.0: return   0.0
##     if f <= -1.0: return 180.0
##     return (math.atan(-f / math.sqrt(1.0 - f * f)) + math.pi / 2.0) * 180.0 / math.pi

  
_soya.new_point  = Point
_soya.new_vector = Vector

