# Import the obj format used by wavefront and others

import soya, soya.soya3d as soya3d, soya.model as model
import os

def Mtl(filename):
    f = open(filename)
    materials = {}
    for line in f.xreadlines():
	if line[0] == "#": continue
	data = line.split()
	if not data: continue
	if data[0] == "newmtl":
	    # starting a new material
	    material = model.Material()
	    materials[data[1]] = material
	    # Initialize the specular color to black, dunno if we should really do this
	    material.specular = (0.0, 0.0, 0.0, 1.0)
	elif data[0] == "Ka":
	    material.ambient = float(data[1]), float(data[2]), float(data[3]), 10
	elif data[0] == "Kd":
	    material.diffuse = float(data[1]), float(data[2]), float(data[3]), 10
	elif data[0] == "Ks":
	    material.specular = float(data[1]), float(data[2]), float(data[3]), 1.0
	elif data[0] == "Ns":
	    # I have no idea what the scale factor should be for this
	    material.shininess = float(data[1])
	elif data[0] == "Ni":
	    # Refractive index
	    pass
	elif data[0] == "illum":
	    # Illumination model, 0 for no lighting, 1 for no specular, 
	    # 2 for full lighting
	    pass
	else: print "Unknown command:", data[0]
	
    return materials

    
def Obj(filename):
    mtlpath = os.path.dirname(filename)
    world = soya3d.World()
    
    material = model.Material()
    #if texfilename is not None: material.tex_filename = texfilename

    f = open(filename)
    vertices = [None] # Vertex indexing starts at one, so this is a placeholder
    vt = [None] # placeholder
    for line in f.xreadlines():
	if line[0] == "#": continue # skip comments
	data = line.split()
	if data[0] == "mtllib": materials = Mtl(os.path.join(mtlpath, data[1]))
	if data[0] == "v":
	    # A vertex
	    vertices.append((float(data[1]), float(data[2]), float(data[3])))
	elif data[0] == "vn":
	    # Ignoring vertex normals for now
	    pass
	elif data[0] == "vt":
	    # Vertex texture. What's w?
	    vt.append((float(data[1]), float(data[2])))
	    # w = float(data[3])
	elif data[0] == "usemtl":
	    material = materials[data[1]]
	elif data[0] == "f":
	    # Loop through the vertices
	    face_vertices = []
	    for vertex in data[1:]:
		args = vertex.split('/')
		x, y, z = vertices[int(args[0])]
		u, v = 0.0, 0.0
		if len(args) > 1 and args[1]:
		    u, v = vt[int(args[1])]
		# Don't care about the normal right now
		face_vertices.append(model.Vertex(world, x, y, z, u, v))
	    
	    f = model.Face(world, face_vertices, material)
	    f.double_sided = 1
    world.scale(0.01, 0.01, 0.01)
    return world.shapify()

if __name__ == '__main__':
    import walktest
    
    world = walktest.World()
    obj = Obj('gltron/lightcycle high.obj')
    #Model(world, 'armagetron/cycle_front.mod')
    #Model(world, 'armagetron/cycle_rear.mod')
    #world.scale(0.01, 0.01, 0.01)
    world.set_shape(obj)
    world.run()

