# export blender model to soya

# HOW TO EXPORT A BLENDER MODEL :
# - run Blender and load your model
# - delete useless objects like camera, lights, armature that can crash this script
# - load the script and run it ! Your shape is edited in the Soya editor
# - you can configure the Soya's material, world, shape, ... path in the Soya editor

# Parameters :

# The directories where files will be saved
IMAGE_PATH    = '/home/jiba/src/balazar/images'
MATERIAL_PATH = '/home/jiba/src/balazar/materials'
WORLD_PATH    = '/home/jiba/src/balazar/worlds'
SHAPE_PATH    = '/home/jiba/src/balazar/shapes'

# The model's (file)name (without path or extension)
FILENAME = "my_model"

# If 1 the model is edited in the Soya editor instead of being saved.
EDIT = 0

# If false, point and lines are removed (only triangles, quads or poly are kept).
# This is usefull since creating useless lines or point is easy in Blender.
KEEP_POINTS_AND_LINES = 0


import os, os.path, tempfile, string

# WARNING : there are some hack on this script since Blender python module is very few documented...
#   (for example for vertices color)

import Blender

name_trans = string.maketrans(" -.", "___")
def to_name(s):
  return s.translate(name_trans)

def pointbymatrix(p, m):
  return [p[0] * m[0][0] + p[1] * m[1][0] + p[2] * m[2][0] + m[3][0],
          p[0] * m[0][1] + p[1] * m[1][1] + p[2] * m[2][1] + m[3][1],
          p[0] * m[0][2] + p[1] * m[1][2] + p[2] * m[2][2] + m[3][2]]

def export_to_soya():
  objs      = Blender.Object.Get()
  code      = ""
  materials = []
  
  for obj in objs:
    data = obj.getData()
    if (type(data) is Blender.Types.NMeshType) and data.faces:
      nmesh = Blender.NMesh.GetRawFromObject(obj.name)
      
      matrix = [[obj.mat[0][0], obj.mat[0][1], obj.mat[0][2], obj.mat[0][3]],
                [obj.mat[1][0], obj.mat[1][1], obj.mat[1][2], obj.mat[1][3]],
                [obj.mat[2][0], obj.mat[2][1], obj.mat[2][2], obj.mat[2][3]],
                [obj.mat[3][0], obj.mat[3][1], obj.mat[3][2], obj.mat[3][3]]]
      
      for face in nmesh.faces:
        if (not KEEP_POINTS_AND_LINES) and (len(face.v) <= 2): continue
        
        code += "f = soya.model.Face(root_world)\n"
        
        # face option
        if(face.smooth != 0): code += "f.smooth_lit = 1\n"
        if(face.mode & Blender.NMesh.FaceModes.TWOSIDE): code += "f.double_sided = 1\n"
        
        # material
        if(face.image != None):
          m_filename = face.image.name[:face.image.name.find(".")]
          m_name = to_name(m_filename)
          code += "f.material = mat_%s \n" % m_name
          for (already_name, already_image) in materials:
            if m_name == already_name: break
          else: materials.append((m_name, m_filename))
          
        # vertices
        index = 0
        for vertex in face.v:
          # vertex coordinates
          co = pointbymatrix(vertex.co, matrix)
          code += "v = soya.model.Vertex(root_world, " + str(co[0]) + ", " + str(co[1]) + ", " + str(co[2]) + ")\n"
          
          # vertex color
          if(face.col != None and len(face.col) > 0):
            color = face.col[index]
            code += "v.color = (%s, %s, %s, %s)\n" % (color.r / 255.0, color.g / 255.0, color.b / 255.0, color.a / 255.0)
            
          # vertex texture coordinates
          if(len(face.uv) > 0):
            uv = face.uv[index]
            code += "v.tex_x = %s\nv.tex_y = %s\n" % (uv[0], 1.0 - uv[1])
            
          code += "f.append(v)\n"
          index = index + 1
          
  full_code = """
# This file has been generated by the Soya Blender exporter

import Tkinter, sys, os, os.path, shutil, glob, soya, soya.model, soya.soya3d, soya.editor, soya.editor.main

root_world = soya.soya3d.World()
root_world.filename = '%s'

new_materials = []
""" % FILENAME
  if EDIT: full_code += """
soya.editor.main.App()
  """
  full_code += """
soya.model.Image.PATH    = '%s'
soya.model.Material.PATH = '%s'
soya.soya3d.World.PATH   = '%s'
soya.model.Shape.PATH    = '%s'
""" % (IMAGE_PATH, MATERIAL_PATH, WORLD_PATH, SHAPE_PATH)
  
  for material, texture_filename in materials:
    full_code += """
try:
  mat_%(material)s = soya.model.Material.get('%(material)s')
except IOError: # New material
  mat_%(material)s = soya.model.Material('%(material)s')
  image = glob.glob(os.path.join(soya.model.Image.PATH, "%(texture_filename)s.*"))
  if image:
    mat_%(material)s.tex_filename = os.path.basename(image[0])
  new_materials.append(mat_%(material)s)
""" % locals()
    
  full_code += """

# This is to compensate because upper axis is Z in blender, Y in Soya
root_world.rotate_vertical(-90.0)

import soya.facecutter as facecutter
facecutter.check_quads(root_world)

os.remove(sys.argv[0])
"""
  
  if EDIT: return full_code + "\n\n" + code + """
soya.editor.edit(root_world)
for material in new_materials: soya.editor.edit(material)
Tkinter.mainloop()
"""
  else: return full_code + "\n\n" + code + """
root_world.save()
for material in new_materials: material.save()
"""

filename = tempfile.mktemp(".py")
open(filename, "w").write(export_to_soya())

print "*****************", filename, "*****************"

print open(filename).read()

os.system("python %s &" % filename)
