/*
 * P3
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

/**********************************************
 * world.h
 * Copyright (C) 2001-2002 Bertrand 'blam' LAMY
 **********************************************/


P3_world* P3_world_new           (P3_world*);
void      P3_world_dealloc       (P3_world*);
void      P3_world_invalid       (P3_world*);
void      P3_world_make_context  (P3_world*, P3_instance*);
void      P3_world_batch         (P3_world*, P3_instance*);
int       P3_world_shadow        (P3_world*, P3_instance*, P3_light*);
void      P3_world_raypick       (P3_world*, P3_raypick_data*, P3_raypickable*);
int       P3_world_raypick_b     (P3_world*, P3_raypick_data*, P3_raypickable*);
void      P3_world_extract       (P3_world*, int class, P3_list*);
int       P3_contains            (P3_any_object*, void*);
void      P3_world_get_data      (P3_world*, P3_chunk*);
void      P3_world_set_data      (P3_world*, P3_chunk*);
//void      P3_world_get_in_sphere (P3_world*, P3_list*, P3_list* nodes, GLfloat* rsphere);
//void      P3_world_add          (P3_world*, P3_any_object*);
//void      P3_world_remove       (P3_world*, P3_any_object*);
//int       P3_world_need_frustum (P3_world*);

void P3_get_in_sphere   (P3_any_object*, P3_list* list, P3_list* parents, void* parent, GLfloat* rsphere, GLfloat* sphere);
void P3_lists_raypick   (P3_list* objs, P3_list* parents, GLfloat* rdata, int option, GLfloat* result, GLfloat* norm, void** rc);
int  P3_lists_raypick_b (P3_list* objs, P3_list* parents, GLfloat* rdata, int option);

#define P3_world_get_root(world) \
  P3_parent_get_root((P3_parent*) world)
