/*
 * P3
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

/**********************************************
 * volume.c
 * Copyright (C) 2001-2002 Bertrand 'blam' LAMY
 **********************************************/

#include "p3_base.h"
#include "math3d.h"
#include "frustum.h"
#include "coordsys.h"
#include "util.h"
#include "volume.h"

extern P3_renderer* renderer;


/*========*
 * VOLUME *
 *========*/

P3_class P3_class_volume = { 
  P3_ID_VOLUME,
  (batch_func)     P3_volume_batch,
  (render_func)    0,
  (shadow_func)    P3_volume_shadow,
  (raypick_func)   P3_volume_raypick,
  (raypick_b_func) P3_volume_raypick_b,
};


P3_volume* P3_volume_new (P3_volume* c) {
  if (c == NULL) {
    c = (P3_volume*) malloc (sizeof (P3_volume));
  }
  P3_coordsys_initialize ((P3_coordsys*) c);
  c->raypick_data = -1;
  c->class = &P3_class_volume;
  c->shape = NULL;
  return c;
}

void P3_volume_batch (P3_volume* c, P3_instance* csys) {
  P3_any_object* o;
  if (c->option & P3_OBJECT_HIDDEN) { return; }
  /* compute new renderer stuff: enter in this coordsys */
  P3_multiply_matrix (c->render_matrix, renderer->c_camera->render_matrix, P3_coordsys_get_root_matrix ((P3_coordsys*) c));
  c->frustum_data = -1;
  o = c->shape;
  if(o != NULL && o->class->batch != 0 && !(c->option & P3_OBJECT_HIDDEN)) {
    o->class->batch (o, (P3_instance*) c);
  }
}

int P3_volume_shadow (P3_volume* v, P3_instance* inst, P3_light* light) {
  if (v->shape != NULL && v->shape->class->shadow != 0) {
    return v->shape->class->shadow (v->shape, (P3_instance*) v, light);
  }
  return P3_FALSE;
}

void P3_volume_raypick (P3_volume* inst, P3_raypick_data* data, P3_raypickable* parent) {
  if (inst->shape == NULL || inst->shape->class->raypick == 0 || inst->option & P3_OBJECT_NON_SOLID) return;
  /* transform origin and direction into the volume coordsys */
  inst->shape->class->raypick (inst->shape, data, (P3_raypickable*) inst);
}

int P3_volume_raypick_b (P3_volume* inst, P3_raypick_data* data, P3_raypickable* parent) {
  if (inst->shape == NULL || inst->shape->class->raypick_b == 0 || inst->option & P3_OBJECT_NON_SOLID) return P3_FALSE;
  /* transform origin and direction into the volume coordsys */
  return inst->shape->class->raypick_b (inst->shape, data, (P3_raypickable*) inst);
}

void P3_volume_get_data (P3_volume* v, P3_chunk* chunk) {
  P3_chunk_save (chunk, v->m, 19 * sizeof (GLfloat));
  P3_chunk_save_int (chunk, v->option);
}

void P3_volume_set_data (P3_volume* v, P3_chunk* chunk) {
  v->class = &P3_class_volume;
  v->validity = P3_COORDSYS_INVALID;
  v->raypick_data = -1;
  P3_chunk_load (chunk, v->m, 19 * sizeof (GLfloat));
  v->option = P3_chunk_load_int (chunk);
}

