/*
 * P3
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

/**********************************************
 * util.h : utilitary
 * Copyright (C) 2001-2002 Bertrand 'blam' LAMY
 **********************************************/

#ifndef __P3_UTIL_H_
#define __P3_UTIL_H_

/* - string - */
char* P3_strcat             (char*, char*);
char* P3_filename_extension (char*);

/* - list - */
#define  P3_list_get(list, index) (list->content[index])
P3_list* P3_list_new          (int);
void     P3_list_dealloc      (P3_list*);
void     P3_list_add          (P3_list*, void*);
void     P3_list_remove       (P3_list*, int);
int      P3_list_remove_named (P3_list*, void*);
int      P3_list_find         (P3_list*, void*);
void     P3_list_update       (P3_list*, void*);
P3_list* P3_list_clone        (P3_list*, P3_list*);

/* - memory chunk - */
P3_chunk* P3_chunk_new       (void);
void      P3_chunk_dealloc   (P3_chunk*);
int       P3_chunk_register  (P3_chunk*, int size);
void      P3_chunk_add       (P3_chunk*, void*, int size);
void      P3_chunk_add_char  (P3_chunk*, char);
void      P3_chunk_add_int   (P3_chunk*, int);
void      P3_chunk_add_float (P3_chunk*, GLfloat);
void      P3_chunk_add_ptr   (P3_chunk*, void*);
void      P3_chunk_get       (P3_chunk*, void*, int size);
char      P3_chunk_get_char  (P3_chunk*);
int       P3_chunk_get_int   (P3_chunk*);
GLfloat   P3_chunk_get_float (P3_chunk*);
void*     P3_chunk_get_ptr   (P3_chunk*);
void      P3_chunk_save_int   (P3_chunk*, int);
void      P3_chunk_save_float (P3_chunk*, GLfloat);
int       P3_chunk_load_int   (P3_chunk*);
GLfloat   P3_chunk_load_float (P3_chunk*);
void      P3_chunk_save       (P3_chunk*, void*, int);
void      P3_chunk_load       (P3_chunk*, void*, int);

/* - chunk/list recycler - */
P3_chunk* P3_get_chunk  (void);
P3_list*  P3_get_list   (void);
void      P3_drop_chunk (P3_chunk*);
void      P3_drop_list  (P3_list*);

/* - chain - */
//P3_chain* P3_chain_append        (P3_chain*, void*);
//void      P3_chain_dealloc_nexts (P3_chain*);

#endif /* __P3_UTIL_H_ */
