/*
 * P3
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

/**********************************************
 * renderer.h
 * Copyright (C) 2001-2003 Bertrand 'blam' LAMY
 **********************************************/

P3_renderer* P3_renderer_new                 (void);
void         P3_renderer_dealloc             (P3_renderer*);
P3_frustum*  P3_renderer_get_frustum         (P3_instance*);
void         P3_renderer_reset               (void);
void         P3_renderer_render              (void);
P3_context*  P3_renderer_get_context         (void);
void         P3_renderer_batch               (P3_chunk*, void*, P3_instance*, int);
void         P3_renderer_add                 (void* obj, P3_instance*);
void         P3_renderer_add_alpha           (void* obj, P3_instance*);
void         P3_renderer_active_context_over (P3_context* old, P3_context* ctxt);

#define P3_renderer_add(obj, ins) \
  P3_renderer_batch (renderer->opaque, obj, ins, renderer->data->nb)

#define P3_renderer_add_alpha(obj, ins) \
  P3_renderer_batch (renderer->alpha, obj, ins, renderer->data->nb)
