/*
 * P3
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

/**********************************************
 * renderer.c
 * Copyright (C) 2001-2003 Bertrand 'blam' LAMY
 **********************************************/

// HACK
//#include <SDL/SDL.h>

// TO DO is all needed ?
#include "p3_base.h"
#include "util.h"
#include "gladd.h"
#include "math3d.h"
#include "atmosphere.h"
#include "light.h"
#include "frustum.h"
#include "coordsys.h"
#include "camera.h"
#include "portal.h"
#include "material.h"
#include "watercube.h"
#include "fx.h"
#include "shadow.h"
//#include "bsp.h"
#include "renderer.h"

extern int engine_option;
extern P3_renderer* renderer;
extern int* lights_gl_activated;
extern int  maxlights;
//extern P3_bsp* bsp;
extern GLfloat black[4];
extern GLfloat white[4];
extern P3_material* current_material;
extern float delta_time;
extern int shadow_display_list;


/* - RENDERER - */

P3_renderer* P3_renderer_new (void) {
  P3_renderer* r = (P3_renderer*) malloc (sizeof (P3_renderer));
  r->root_object = NULL;
  r->c_camera = NULL;
  r->c_context = NULL;
  r->nb_contexts = 0;
  r->max_contexts = 0;
  r->contexts = NULL;
  r->r_atmosphere = NULL;
  r->c_frustum_coordsys = NULL;
  r->c_frustum = (P3_frustum*) malloc (sizeof (P3_frustum));
  r->r_frustum = (P3_frustum*) malloc (sizeof (P3_frustum));
  r->top_lights  = P3_list_new (0);
  r->all_lights  = P3_list_new (2);
  r->worlds_made = P3_list_new (0);
  r->portals     = P3_list_new (0);
  r->watercubes  = P3_list_new (0);
  r->opaque     = P3_chunk_new ();
  r->secondpass = P3_chunk_new ();
  r->alpha      = P3_chunk_new ();
  r->specials   = P3_chunk_new ();
  r->data       = P3_chunk_new ();
  r->faces      = P3_chunk_new ();
  return r;
}

void P3_renderer_dealloc (P3_renderer* r) {
  int i;
  P3_chunk_dealloc (r->opaque);
  P3_chunk_dealloc (r->alpha);
  P3_chunk_dealloc (r->secondpass);
  P3_chunk_dealloc (r->specials);
  P3_chunk_dealloc (r->data);
  P3_chunk_dealloc (r->faces);
  P3_list_dealloc (r->top_lights);
  P3_list_dealloc (r->all_lights);
  P3_list_dealloc (r->worlds_made);
  P3_list_dealloc (r->portals);
  P3_list_dealloc (r->watercubes);
  P3_frustum_dealloc (r->c_frustum);
  P3_frustum_dealloc (r->r_frustum);
  for (i = 0; i < r->max_contexts; i++) {
    P3_list_dealloc (r->contexts[i]->lights);
    free (r->contexts[i]);
  }
  free (r->contexts);
  free (r);
}

P3_frustum* P3_renderer_get_frustum (P3_instance* inst) {
  if (inst == NULL) {
    return renderer->r_frustum;
  } else {
    if (inst->frustum_data == -1) {
      inst->frustum_data = P3_chunk_register (renderer->frustums, sizeof (P3_frustum));
      P3_frustum_by_matrix ((P3_frustum*) (renderer->frustums->content + inst->frustum_data), renderer->r_frustum, P3_coordsys_get_inverted_root_matrix ((P3_coordsys*) inst));
    }
    return (P3_frustum*) (renderer->frustums->content + inst->frustum_data);
  }
}

/*
P3_frustum* P3_renderer_get_frustum (P3_coordsys* csys) {
  if (csys == NULL) {
    return renderer->r_frustum;
  } else {
    if (renderer->c_frustum_coordsys != csys) {
      P3_frustum_by_matrix (renderer->c_frustum, renderer->r_frustum, P3_coordsys_get_inverted_root_matrix (csys));
      renderer->c_frustum_coordsys = csys;
    }
    return renderer->c_frustum;
  }
}
*/

P3_context* P3_renderer_get_context (void) {
  P3_context* rc;
  int n;
  n = renderer->nb_contexts;
  (renderer->nb_contexts)++;
  if (n < renderer->max_contexts) {
    rc = renderer->contexts[n];
    rc->lights->nb = 0;
    rc->atmosphere = NULL;
    rc->portal = NULL;
  } else {
    /* I don't think contexts need a geometrical growth... the 1rst render will be slower but it doesn't matter */
    (renderer->max_contexts)++;

// TO DO simple array and not pointer array ?
// in that case I need to stock index and not pointer...

    renderer->contexts = (P3_context**) realloc (renderer->contexts, renderer->max_contexts * sizeof (P3_context*));
    rc = (P3_context*) malloc (sizeof (P3_context));
    renderer->contexts[n] = rc;
    rc->lights = P3_list_new (2);
    rc->atmosphere = NULL;
    rc->portal = NULL;
  }
  return rc;
}

void P3_renderer_active_context_over (P3_context* old, P3_context* ctxt) {
  int i;
  P3_list* list;
  P3_light* light;
// TO DO active / inactive light only if necessary ?
  if (old != NULL) {
    /* inactive previous lights */
    list = old->lights;
    for (i = 0; i < list->nb; i++) {
      light = (P3_light*) P3_list_get (list, i);
      if (light->id != -1) {
        glDisable (GL_LIGHT0 + light->id);
        lights_gl_activated[light->id] = P3_FALSE;
      }
    }
    if (old->portal != NULL && old->portal->option & (P3_PORTAL_USE_4_CLIP_PLANES | P3_PORTAL_USE_5_CLIP_PLANES)) {
      glDisable (GL_CLIP_PLANE0);
      glDisable (GL_CLIP_PLANE1);
      glDisable (GL_CLIP_PLANE2);
      glDisable (GL_CLIP_PLANE3);
      if (old->portal->option & P3_PORTAL_USE_5_CLIP_PLANES) { glDisable (GL_CLIP_PLANE4); }
    }
  }
  /* active new context */
  if (ctxt != NULL) {
    if (ctxt->atmosphere != NULL && (old == NULL || ctxt->atmosphere != old->atmosphere)) {
      P3_atmosphere_render (ctxt->atmosphere);
    }
    list = ctxt->lights;
    for (i = 0; i < list->nb; i++) {
      P3_light_render ((P3_light*) P3_list_get (list, i), NULL);
    }
  }
  /* re-active top level lights that may have been inactivated due to too many lights */
  list = renderer->top_lights;
  for (i = 0; i < list->nb; i++) {
    light = (P3_light*) P3_list_get (list, i);
    if (light->id == -1) {
      P3_light_render (light, NULL);
    }
  }
  /* active portal clip plane */
  if (ctxt != NULL && ctxt->portal != NULL && ctxt->portal->option & (P3_PORTAL_USE_4_CLIP_PLANES | P3_PORTAL_USE_5_CLIP_PLANES)) {
    P3_portal* portal = ctxt->portal;
    glLoadIdentity ();  /* the clip planes must be defined in the camera coordsys... so identity */
    glClipPlane (GL_CLIP_PLANE0, portal->equation);
    glClipPlane (GL_CLIP_PLANE1, portal->equation + 4);
    glClipPlane (GL_CLIP_PLANE2, portal->equation + 8);
    glClipPlane (GL_CLIP_PLANE3, portal->equation + 12);
    glEnable (GL_CLIP_PLANE0);
    glEnable (GL_CLIP_PLANE1);
    glEnable (GL_CLIP_PLANE2);
    glEnable (GL_CLIP_PLANE3);
    if (portal->option & P3_PORTAL_USE_5_CLIP_PLANES) { 
      glClipPlane (GL_CLIP_PLANE4, portal->equation + 16);
      glEnable (GL_CLIP_PLANE4); 
    }
  }
}

void P3_renderer_reset (void) {
  int i;
  /* reset renderer */
  renderer->nb_contexts = 0;
  renderer->r_atmosphere = NULL;
  P3_disable_all_lights ();
// TO DO why ? usefull ?
/*
  glDisable (GL_CLIP_PLANE0);
  glDisable (GL_CLIP_PLANE1);
  glDisable (GL_CLIP_PLANE2);
  glDisable (GL_CLIP_PLANE3);
  glDisable (GL_CLIP_PLANE4);
*/
  renderer->top_lights->nb  = 0;
  renderer->all_lights->nb  = 0;

  for (i = 0; i < renderer->worlds_made->nb; i++) {
    ((P3_world*) P3_list_get (renderer->worlds_made, i))->option -= P3_WORLD_BATCHED;
  }
  renderer->worlds_made->nb = 0;
  renderer->portals->nb = 0;
  renderer->watercubes->nb = 0;

  renderer->data->nb = 0;
  renderer->faces->nb = 0;
  renderer->opaque->nb = 0;
  renderer->secondpass->nb = 0;
  renderer->alpha->nb = 0;
  renderer->specials->nb = 0;
  delta_time = 0.0;
}

/*
void P3_renderer_render_specials (P3_chunk* list) {
  P3_any_object* obj;
  int max = list->nb;
  list->nb = 0;
  while (list->nb < max) {
    obj = *((P3_any_object**) (list->content + list->nb));
    list->nb += sizeof (P3_any_object*);
    switch (obj->class->id) {
    case P3_ID_WATERCUBE:
      P3_watercube_render ((P3_watercube*) obj);
      break;
    }
  }
}
*/

void P3_renderer_render_list (P3_chunk* list) {
  P3_renderer_obj* robj;
  int max = list->nb;
  list->nb = 0;
  while (list->nb < max) {

//printf("new object on list at %i\n", list->nb);

    robj = (P3_renderer_obj*) (list->content + list->nb);
    /* context */
    if (robj->ctx != renderer->c_context) {
      P3_renderer_active_context_over (renderer->c_context, robj->ctx);
      renderer->c_context = robj->ctx;
    }
    /* instance */
    if (robj->ins != NULL) glLoadMatrixf (robj->ins->render_matrix);
    renderer->c_instance = robj->ins;
    /* data */
    renderer->data->nb = robj->data;

//printf ("rendering a %i (option %i)\n", robj->obj->class->id, robj->obj->option);

// TO DO NEW at the end
    list->nb += sizeof (P3_renderer_obj);
    /* object */
    robj->obj->class->render (robj->obj, robj->ins);
  }
}

void P3_renderer_render (void) {
  P3_context* ctxt;
  P3_portal* portal;
  P3_world* w;
  P3_list* list;
  P3_light* light;
  int i;

//printf("--- renderer start\n");

  renderer->frustums = P3_get_chunk ();

  /*==========================*
   * RENDERING STEP 1 : BATCH *
   *==========================*/

  ctxt = P3_renderer_get_context ();
  renderer->c_context = ctxt;

  if (renderer->root_object->class->batch != 0) 
    renderer->root_object->class->batch (renderer->root_object, (P3_instance*) renderer->c_camera);
  
  /*===========================*
   * RENDERING STEP 2 : RENDER *
   *===========================*/
  /* clear */
  if (renderer->r_atmosphere != NULL) {
    P3_atmosphere_clear (renderer->r_atmosphere);
  } else {
    P3_clear_screen (NULL);
  }
  /* draw the atmosphere of the worlds that are seen through portals */
  for (i = renderer->portals->nb - 1; i >= 0; i--) {
    portal = (P3_portal*) P3_list_get (renderer->portals, i);
    if (portal->option & P3_PORTAL_BOUND_ATMOSPHERE) {
      P3_atmosphere_clear_part (portal);
    }
  }
  /* activate top lights */
  list = renderer->top_lights;
  for (i = 0; i < list->nb; i++) {
    P3_light_render ((P3_light*) P3_list_get (list, i), NULL);
  }
  /* current context have been changed during batching -> reinitialize */
  renderer->c_context = NULL;
  /* render collected objects */
  /* draw opaque stuff first */
  renderer->state = P3_RENDERER_STATE_OPAQUE;
  P3_renderer_render_list (renderer->opaque);
  /* then draw secondpass */
  renderer->state = P3_RENDERER_STATE_SECONDPASS;
  P3_renderer_render_list (renderer->secondpass);
  /* finally draw alpha */
  renderer->state = P3_RENDERER_STATE_ALPHA;
  glDepthMask (GL_FALSE);
  glEnable (GL_BLEND);
  P3_renderer_render_list (renderer->alpha);
  /* reset a part of the renderer here cause it's needed for rendering the portal fog */
  P3_material_activate (NULL);
  P3_renderer_active_context_over (renderer->c_context, NULL);
  renderer->c_context = NULL;
  /* draw fog for portal if necessary */
  for (i = renderer->portals->nb - 1; i >= 0; i--) {
    portal = (P3_portal*) P3_list_get (renderer->portals, i);
    if (portal->option & P3_PORTAL_BOUND_ATMOSPHERE) {
      /* get root atmosphere */
      w = (P3_world*) portal->parent;
      while (w != NULL && w->atmosphere == NULL) {
        w = (P3_world*) w->parent;
      }
      if (w->atmosphere != NULL && w->atmosphere->option & P3_ATMOSPHERE_FOG) {
        P3_portal_draw_fog (portal, w->atmosphere);
      }
    }
  }
  /* render shadow */
  if (engine_option & P3_SHADOWS) P3_render_shadows ();
  /* render specials: objects that are not shadowed (sprite, particules) */
  renderer->state = P3_RENDERER_STATE_SPECIAL;
  P3_renderer_render_list (renderer->specials);
  /* render watercube */
  for (i = 0; i < renderer->watercubes->nb; i++) {
    P3_watercube_render ((P3_watercube*) P3_list_get (renderer->watercubes, i));
  }
  /* end of OpenGL rendering */
  glDepthMask (GL_TRUE);
  glDisable (GL_BLEND);
//  P3_renderer_render_specials (renderer->specials);
  if (engine_option & P3_FX_INITED) P3_fx_advance_time ();
  /* auto-reset renderer */
  P3_renderer_reset ();

  P3_drop_chunk (renderer->frustums);

//printf("time for renderer : %i\n", SDL_GetTicks() - t);

//printf("renderer end\n");

}

void P3_renderer_batch (P3_chunk* list, void* object, P3_instance* instance, int data) {
  P3_renderer_obj* robj;
  int i;
  i = P3_chunk_register (list, sizeof (P3_renderer_obj));

//printf("add object on list at %i\n", i);

  robj = (P3_renderer_obj*) (list->content + i);
  robj->obj = (P3_any_object*) object;
  robj->ins = instance;
  robj->ctx = renderer->c_context;
  robj->data = data;
}

/*
void P3_renderer_add (void* obj, P3_instance* ins) {
  P3_renderer_batch (renderer->opaque, obj, ins, renderer->data->nb);
}

void P3_renderer_add_alpha (void* obj, P3_instance* ins) {
  P3_renderer_batch (renderer->alpha, obj, ins, renderer->data->nb);
}
*/


