/*
 * P3 python wrapper
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

/*****************************************
 * p3_python.c : 'wrapper' for python
 * Copyright (C) 2002 Bertrand 'blam' LAMY
 *****************************************/

#include <Python.h>

#ifdef USE_GLX
#include <X11/Xlib.h>
#include <X11/keysym.h>
#include <GL/glx.h>
#endif /* USE_GLX */

#ifdef USE_SDL
#include <SDL/SDL.h>
#endif /* USE_SDL */

#include "../p3_base.h"
#include "../math3d.h"
#include "../engine.h"
#include "../gladd.h"
#include "../util.h"
#include "../renderer.h"
#include "../material.h"
#include "../image.h"
#include "../atmosphere.h"
#include "../coordsys.h"
#include "../volume.h"
#include "../world.h"
#include "../frustum.h"
#include "../camera.h"
#include "../light.h"
#include "../sprite.h"
#include "../portal.h"
#include "../dimension.h"
//#include "../morph.h"
//#include "../morph_build.h"
#include "../text.h"
#include "../land.h"
#include "../cal3d4p3.h"
#include "../mesh.h"
#include "../raypick.h"
#include "../watercube.h"
#include "../fx.h"
#include "../anim.h"
#include "face_python.h"


extern P3_renderer* renderer;
extern P3_light** lights_gl;
extern int engine_option;
extern int screen_w;
extern int screen_h;
extern P3_material* current_material;
extern float delta_time;
extern GLfloat white[4];
extern GLfloat black[4];

#ifdef USE_GLX
extern Display* display;
extern Window window;
#endif /* USE_GLX */

#ifdef USE_SDL
extern SDL_Surface* screen;
#endif /* USE_SDL */

PyObject* P3Module;


#include "i_macros.c"

/*==================*
 * OBJECTS WRAPPERS *
 *==================*/

#include "i_shape.c"
#include "i_pointvector.c"
#include "i_funcs.c"
#include "i_graphicelement.c"
#include "i_raypick.c"
#include "i_coordsys.c"
#include "i_gl.c"
#include "i_material.c"
#include "i_instance.c"
#include "i_volume.c"
#include "i_world.c"
#include "i_camera.c"
#include "i_atmosphere.c"
#include "i_light.c"
#include "i_portal.c"
#include "i_mesh.c"
//#include "i_morph.c"
#include "i_sprite.c"
#include "i_particule.c"
#include "i_text.c"
#include "i_land.c"
#include "i_face.c"
#include "i_watercube.c"
#include "i_anim.c"
#ifdef HAVE_CAL3D
#include "i_cal3d4p3.c"
#endif /* HAVE_CAL3D */


/*==================*
 * PYTHON P3 MODULE *
 *==================*/

static PyMethodDef PyP3_Methods[] = {
  /* rendering functions */
  { "init",                  (PyCFunction) PyP3_Init,                   METH_VARARGS },
  { "quit",                  (PyCFunction) PyP3_Quit,                   METH_NOARGS },
  { "set_video",             (PyCFunction) PyP3_SetVideo,               METH_VARARGS },
  { "set_quality",           (PyCFunction) PyP3_SetQuality,             METH_O },
  { "set_shadow",            (PyCFunction) PyP3_SetShadow,              METH_O },
  { "display",               (PyCFunction) PyP3_Display,                METH_NOARGS },
  { "minimize",              (PyCFunction) PyP3_MinimizeWindow,         METH_NOARGS },
  { "toggle_fullscreen",     (PyCFunction) PyP3_ToggleFullscreen,       METH_NOARGS },
  { "activate_material",     (PyCFunction) PyP3_ActivateMaterial,       METH_O },
  { "get_screen_width",      (PyCFunction) PyP3_GetScreenWidth,         METH_NOARGS },
  { "get_screen_height",     (PyCFunction) PyP3_GetScreenHeight,        METH_NOARGS },
  { "cursor_set_visible",    (PyCFunction) PyP3_SetCursorVisibility,    METH_O },
  { "cursor_set_xy",         (PyCFunction) PyP3_SetCursorPosition,      METH_VARARGS },
  { "get_camera",            (PyCFunction) PyP3_GetCamera,              METH_NOARGS },
  { "renderer_add",          (PyCFunction) PyP3_RendererAdd,            METH_VARARGS },
  { "screenshot",            (PyCFunction) PyP3_Screenshot,             METH_O },
  { "toggle_wireframe",      (PyCFunction) PyP3_ToggleWireFrame,        METH_NOARGS },
  { "advance_time",          (PyCFunction) PyP3_AdvanceTime,            METH_O },
  /* math functions */
  { "points_normal",         (PyCFunction) PyP3_PointsNormal,           METH_VARARGS },
  /* event functions */
  { "_process_event",        (PyCFunction) PyP3_ProcessEvent,           METH_NOARGS },
  { "get_mod",               (PyCFunction) PyP3_GetModifier,            METH_NOARGS },
  /* font functions */
  { "load_font",             (PyCFunction) PyP3_LoadFont,               METH_O },
  /* particles functions */
  { "draw_multiple_sprites", (PyCFunction) PyP3SpritesSphere_RenderOld, METH_VARARGS },
  { "draw_sprites",          (PyCFunction) PyP3SpritesSphere_Render,    METH_VARARGS },
  { "fading_advance",        (PyCFunction) PyP3FadingColor_Advance,     METH_O },
  { "acceleration_advance",  (PyCFunction) PyP3Acceleration_Advance,    METH_VARARGS },
  /* some OpenGL functions */
  { "glClearWithColor",      (PyCFunction) PyP3GL_ClearWithColor,       METH_VARARGS },
  { "glGenList",             (PyCFunction) PyP3GL_GenList,              METH_NOARGS },
  { "glNewList",             (PyCFunction) PyP3GL_NewList,              METH_O },
  { "glEndList",             (PyCFunction) PyP3GL_EndList,              METH_NOARGS },
  { "glCallList",            (PyCFunction) PyP3GL_CallList,             METH_O },
  { "glDeleteList",          (PyCFunction) PyP3GL_DeleteList,           METH_O },
  { "glLightModeli",         (PyCFunction) PyP3GL_LightModeli,          METH_VARARGS },
  { "glEnable",              (PyCFunction) PyP3GL_Enable,               METH_O },
  { "glDisable",             (PyCFunction) PyP3GL_Disable,              METH_O },
  { "glVertex2i",            (PyCFunction) PyP3GL_Vertex2i,             METH_VARARGS },
  { "glVertex2f",            (PyCFunction) PyP3GL_Vertex2f,             METH_VARARGS },
  { "glVertex3f",            (PyCFunction) PyP3GL_Vertex3f,             METH_VARARGS },
  { "glVertex4f",            (PyCFunction) PyP3GL_Vertex4f,             METH_VARARGS },
  { "glNormal3f",            (PyCFunction) PyP3GL_Normal3f,             METH_VARARGS },
  { "glColor4f",             (PyCFunction) PyP3GL_Color4f,              METH_VARARGS },
  { "glTexCoord2f",          (PyCFunction) PyP3GL_TexCoord2f,           METH_VARARGS },
  { "glBegin",               (PyCFunction) PyP3GL_Begin,                METH_O },
  { "glEnd",                 (PyCFunction) PyP3GL_End,                  METH_NOARGS },
  { "glPointSize",           (PyCFunction) PyP3GL_PointSize,            METH_O },
  { "glLineWidth",           (PyCFunction) PyP3GL_LineWidth,            METH_O },
  { NULL, NULL }
};


DL_EXPORT (void) init_soya (void) {
  PyObject* P3Module_Dict;

  /* init new types and module */
  P3Module = Py_InitModule ("_soya", PyP3_Methods);


  /* add the new types in the module */
  P3Module_Dict = PyModule_GetDict (P3Module);

  PY_MODULE_ADD_TYPE (Point,   "_Point");
  PY_MODULE_ADD_TYPE (Vector,  "_Vector");
  PY_MODULE_ADD_TYPE (Element, "Element3D");

  PY_MODULE_ADD_TYPE (Shape,          "_Shape");
  PY_MODULE_ADD_TYPE (Image,          "_Image");
  PY_MODULE_ADD_TYPE (Material,       "_Material");
  PY_MODULE_ADD_TYPE (Face,           "_Face");
  PY_MODULE_ADD_TYPE (Camera,         "_Camera");
  PY_MODULE_ADD_TYPE (Instance,       "_Coordsys");
  PY_MODULE_ADD_TYPE (Volume,         "_Volume");
  PY_MODULE_ADD_TYPE (World,          "_World");
  PY_MODULE_ADD_TYPE (Light,          "_Light");
  PY_MODULE_ADD_TYPE (Portal,         "_Portal");
  PY_MODULE_ADD_TYPE (Mesh,           "_Mesh");
  PY_MODULE_ADD_TYPE (MeshLOD,        "_MeshLOD");
  PY_MODULE_ADD_TYPE (MeshFXInstance, "_MeshFXInstance");
//  PY_MODULE_ADD_TYPE (Morph,        "_Morph");
//  PY_MODULE_ADD_TYPE (MorphData,    "_MorphData");
  PY_MODULE_ADD_TYPE (AnimCoordsys,   "_AnimCoordsys");
  PY_MODULE_ADD_TYPE (Atmosphere,     "_Atmosphere");
  PY_MODULE_ADD_TYPE (Land,           "_Land");
  PY_MODULE_ADD_TYPE (Sprite,         "_Sprite");
  PY_MODULE_ADD_TYPE (Cylinder,       "_Cylinder");
  PY_MODULE_ADD_TYPE (Bonus,          "_Bonus");
  PY_MODULE_ADD_TYPE (Particles,      "_Particles");
  PY_MODULE_ADD_TYPE (Watercube,      "_WaterCube");
  PY_MODULE_ADD_TYPE (FontRaster,     "FontRaster");
  PY_MODULE_ADD_TYPE (FontTexture,    "FontTexture");

  PyP3RaypickContext_Type.ob_type = &PyType_Type;

#ifdef HAVE_CAL3D
  PY_MODULE_ADD_TYPE (Cal3DShape,  "_Cal3DShape");
  PY_MODULE_ADD_TYPE (Cal3DVolume, "_Cal3DVolume");
#endif /* HAVE_CAL3D */


  /* add some OpenGL and SDL constants */

  PY_MODULE_ADD_SYMBOL (GL_POINTS, "GL_POINTS");
  PY_MODULE_ADD_SYMBOL (GL_LINES, "GL_LINES");
  PY_MODULE_ADD_SYMBOL (GL_LINE_LOOP, "GL_LINE_LOOP");
  PY_MODULE_ADD_SYMBOL (GL_TRIANGLES, "GL_TRIANGLES");
  PY_MODULE_ADD_SYMBOL (GL_QUADS, "GL_QUADS");
  PY_MODULE_ADD_SYMBOL (GL_POLYGON, "GL_POLYGON");
  PY_MODULE_ADD_SYMBOL (GL_TEXTURE_2D, "GL_TEXTURE_2D");
  PY_MODULE_ADD_SYMBOL (GL_CULL_FACE, "GL_CULL_FACE");
  PY_MODULE_ADD_SYMBOL (GL_BLEND, "GL_BLEND");
  PY_MODULE_ADD_SYMBOL (GL_LIGHTING, "GL_LIGHTING");
  PY_MODULE_ADD_SYMBOL (GL_LIGHT_MODEL_TWO_SIDE, "GL_LIGHT_MODEL_TWO_SIDE");
  PY_MODULE_ADD_SYMBOL (GL_TRUE, "GL_TRUE");
  PY_MODULE_ADD_SYMBOL (GL_FALSE, "GL_FALSE");

#ifdef USE_GLX

  PY_MODULE_ADD_SYMBOL (KeyRelease, "KEYUP");
  PY_MODULE_ADD_SYMBOL (KeyPress, "KEYDOWN");
  PY_MODULE_ADD_SYMBOL (MotionNotify, "MOUSEMOTION");
  PY_MODULE_ADD_SYMBOL (ButtonPress, "MOUSEBUTTONDOWN");
  PY_MODULE_ADD_SYMBOL (ButtonRelease, "MOUSEBUTTONUP");
  PY_MODULE_ADD_SYMBOL (0, "QUIT");
  PY_MODULE_ADD_SYMBOL (GraphicsExpose, "VIDEOEXPOSE");
  PY_MODULE_ADD_SYMBOL (ResizeRequest, "VIDEORESIZE");

  PY_MODULE_ADD_SYMBOL (Button1, "BUTTON_LEFT");
  PY_MODULE_ADD_SYMBOL (Button2, "BUTTON_MIDDLE");
  PY_MODULE_ADD_SYMBOL (Button3, "BUTTON_RIGHT");
  PY_MODULE_ADD_SYMBOL (Button4, "BUTTON_4");
  PY_MODULE_ADD_SYMBOL (Button5, "BUTTON_5");

  PY_MODULE_ADD_SYMBOL (Button1Mask, "STATE_BUTTON_LEFT");
  PY_MODULE_ADD_SYMBOL (Button2Mask, "STATE_BUTTON_MIDDLE");
  PY_MODULE_ADD_SYMBOL (Button3Mask, "STATE_BUTTON_RIGHT");

  PY_MODULE_ADD_SYMBOL (ControlMask, "KMOD_CTRL");
  PY_MODULE_ADD_SYMBOL (ShiftMask, "KMOD_SHIFT");
  PY_MODULE_ADD_SYMBOL (Mod1Mask, "KMOD_ALT");
  PY_MODULE_ADD_SYMBOL (Mod2Mask | Mod3Mask | Mod4Mask | Mod5Mask, "KMOD_META");

  PY_MODULE_ADD_SYMBOL (XK_Tab, "K_TAB");
  PY_MODULE_ADD_SYMBOL (XK_Return, "K_RETURN");
  PY_MODULE_ADD_SYMBOL (XK_Escape, "K_ESCAPE");
  PY_MODULE_ADD_SYMBOL (XK_KP_Space, "K_SPACE");
  PY_MODULE_ADD_SYMBOL (XK_KP_Add, "K_KP_PLUS");
  PY_MODULE_ADD_SYMBOL (XK_KP_Subtract, "K_KP_MINUS");
  PY_MODULE_ADD_SYMBOL (XK_plus, "K_PLUS");
  PY_MODULE_ADD_SYMBOL (XK_minus, "K_MINUS");
  PY_MODULE_ADD_SYMBOL (XK_0, "K_0");
  PY_MODULE_ADD_SYMBOL (XK_1, "K_1");
  PY_MODULE_ADD_SYMBOL (XK_2, "K_2");
  PY_MODULE_ADD_SYMBOL (XK_3, "K_3");
  PY_MODULE_ADD_SYMBOL (XK_4, "K_4");
  PY_MODULE_ADD_SYMBOL (XK_5, "K_5");
  PY_MODULE_ADD_SYMBOL (XK_6, "K_6");
  PY_MODULE_ADD_SYMBOL (XK_7, "K_7");
  PY_MODULE_ADD_SYMBOL (XK_8, "K_8");
  PY_MODULE_ADD_SYMBOL (XK_9, "K_9");
  PY_MODULE_ADD_SYMBOL (XK_KP_0, "K_KP0");
  PY_MODULE_ADD_SYMBOL (XK_KP_1, "K_KP1");
  PY_MODULE_ADD_SYMBOL (XK_KP_2, "K_KP2");
  PY_MODULE_ADD_SYMBOL (XK_KP_3, "K_KP3");
  PY_MODULE_ADD_SYMBOL (XK_KP_4, "K_KP4");
  PY_MODULE_ADD_SYMBOL (XK_KP_5, "K_KP5");
  PY_MODULE_ADD_SYMBOL (XK_KP_6, "K_KP6");
  PY_MODULE_ADD_SYMBOL (XK_KP_7, "K_KP7");
  PY_MODULE_ADD_SYMBOL (XK_KP_8, "K_KP8");
  PY_MODULE_ADD_SYMBOL (XK_KP_9, "K_KP9");
  PY_MODULE_ADD_SYMBOL (XK_Delete, "K_DELETE");
  PY_MODULE_ADD_SYMBOL (XK_KP_Enter, "K_KP_ENTER");
  PY_MODULE_ADD_SYMBOL (XK_Up, "K_UP");
  PY_MODULE_ADD_SYMBOL (XK_Down, "K_DOWN");
  PY_MODULE_ADD_SYMBOL (XK_Left, "K_LEFT");
  PY_MODULE_ADD_SYMBOL (XK_Right, "K_RIGHT");
  PY_MODULE_ADD_SYMBOL (XK_Home, "K_HOME");
  PY_MODULE_ADD_SYMBOL (XK_End, "K_END");
  PY_MODULE_ADD_SYMBOL (XK_Page_Up, "K_PAGEUP");
  PY_MODULE_ADD_SYMBOL (XK_Page_Down, "K_PAGEDOWN");
  PY_MODULE_ADD_SYMBOL (XK_F1, "K_F1");
  PY_MODULE_ADD_SYMBOL (XK_F2, "K_F2");
  PY_MODULE_ADD_SYMBOL (XK_F3, "K_F3");
  PY_MODULE_ADD_SYMBOL (XK_F4, "K_F4");
  PY_MODULE_ADD_SYMBOL (XK_F5, "K_F5");
  PY_MODULE_ADD_SYMBOL (XK_F6, "K_F6");
  PY_MODULE_ADD_SYMBOL (XK_F7, "K_F7");
  PY_MODULE_ADD_SYMBOL (XK_F8, "K_F8");
  PY_MODULE_ADD_SYMBOL (XK_F9, "K_F9");
  PY_MODULE_ADD_SYMBOL (XK_F10, "K_F10");
  PY_MODULE_ADD_SYMBOL (XK_F11, "K_F11");
  PY_MODULE_ADD_SYMBOL (XK_F12, "K_F12");
  PY_MODULE_ADD_SYMBOL (XK_a, "K_a");
  PY_MODULE_ADD_SYMBOL (XK_b, "K_b");
  PY_MODULE_ADD_SYMBOL (XK_c, "K_c");
  PY_MODULE_ADD_SYMBOL (XK_d, "K_d");
  PY_MODULE_ADD_SYMBOL (XK_e, "K_e");
  PY_MODULE_ADD_SYMBOL (XK_f, "K_f");
  PY_MODULE_ADD_SYMBOL (XK_g, "K_g");
  PY_MODULE_ADD_SYMBOL (XK_h, "K_h");
  PY_MODULE_ADD_SYMBOL (XK_i, "K_i");
  PY_MODULE_ADD_SYMBOL (XK_j, "K_j");
  PY_MODULE_ADD_SYMBOL (XK_k, "K_k");
  PY_MODULE_ADD_SYMBOL (XK_l, "K_l");
  PY_MODULE_ADD_SYMBOL (XK_m, "K_m");
  PY_MODULE_ADD_SYMBOL (XK_n, "K_n");
  PY_MODULE_ADD_SYMBOL (XK_o, "K_o");
  PY_MODULE_ADD_SYMBOL (XK_p, "K_p");
  PY_MODULE_ADD_SYMBOL (XK_q, "K_q");
  PY_MODULE_ADD_SYMBOL (XK_r, "K_r");
  PY_MODULE_ADD_SYMBOL (XK_s, "K_s");
  PY_MODULE_ADD_SYMBOL (XK_t, "K_t");
  PY_MODULE_ADD_SYMBOL (XK_u, "K_u");
  PY_MODULE_ADD_SYMBOL (XK_v, "K_v");
  PY_MODULE_ADD_SYMBOL (XK_w, "K_w");
  PY_MODULE_ADD_SYMBOL (XK_x, "K_x");
  PY_MODULE_ADD_SYMBOL (XK_y, "K_y");
  PY_MODULE_ADD_SYMBOL (XK_z, "K_z");

#endif /* USE_GLX */

#ifdef USE_SDL

  PY_MODULE_ADD_SYMBOL (SDL_KEYUP, "KEYUP");
  PY_MODULE_ADD_SYMBOL (SDL_KEYDOWN, "KEYDOWN");
  PY_MODULE_ADD_SYMBOL (SDL_MOUSEMOTION, "MOUSEMOTION");
  PY_MODULE_ADD_SYMBOL (SDL_MOUSEBUTTONDOWN, "MOUSEBUTTONDOWN");
  PY_MODULE_ADD_SYMBOL (SDL_MOUSEBUTTONUP, "MOUSEBUTTONUP");
  PY_MODULE_ADD_SYMBOL (SDL_JOYAXISMOTION, "JOYAXISMOTION");
  PY_MODULE_ADD_SYMBOL (SDL_JOYBUTTONDOWN, "JOYBUTTONDOWN");
  PY_MODULE_ADD_SYMBOL (SDL_JOYBUTTONUP, "JOYBUTTONUP");
  PY_MODULE_ADD_SYMBOL (SDL_QUIT, "QUIT");
  PY_MODULE_ADD_SYMBOL (SDL_VIDEOEXPOSE, "VIDEOEXPOSE");
  PY_MODULE_ADD_SYMBOL (SDL_VIDEORESIZE, "VIDEORESIZE");

  PY_MODULE_ADD_SYMBOL (SDL_BUTTON_LEFT, "BUTTON_LEFT");
  PY_MODULE_ADD_SYMBOL (SDL_BUTTON_MIDDLE, "BUTTON_MIDDLE");
  PY_MODULE_ADD_SYMBOL (SDL_BUTTON_RIGHT, "BUTTON_RIGHT");

  PY_MODULE_ADD_SYMBOL (SDL_BUTTON (SDL_BUTTON_LEFT), "STATE_BUTTON_LEFT");
  PY_MODULE_ADD_SYMBOL (SDL_BUTTON (SDL_BUTTON_MIDDLE), "STATE_BUTTON_MIDDLE");
  PY_MODULE_ADD_SYMBOL (SDL_BUTTON (SDL_BUTTON_RIGHT), "STATE_BUTTON_RIGHT");

  PY_MODULE_ADD_SYMBOL (KMOD_CTRL, "KMOD_CTRL");
  PY_MODULE_ADD_SYMBOL (KMOD_SHIFT, "KMOD_SHIFT");
  PY_MODULE_ADD_SYMBOL (KMOD_ALT, "KMOD_ALT");
  PY_MODULE_ADD_SYMBOL (KMOD_META, "KMOD_META");
  PY_MODULE_ADD_SYMBOL (KMOD_CAPS, "KMOD_CAPS");
  PY_MODULE_ADD_SYMBOL (KMOD_MODE, "KMOD_ALTGR");

  PY_MODULE_ADD_SYMBOL (SDLK_TAB, "K_TAB");
  PY_MODULE_ADD_SYMBOL (SDLK_RETURN, "K_RETURN");
  PY_MODULE_ADD_SYMBOL (SDLK_ESCAPE, "K_ESCAPE");
  PY_MODULE_ADD_SYMBOL (SDLK_SPACE, "K_SPACE");
  PY_MODULE_ADD_SYMBOL (SDLK_KP_PLUS, "K_KP_PLUS");
  PY_MODULE_ADD_SYMBOL (SDLK_KP_MINUS, "K_KP_MINUS");
  PY_MODULE_ADD_SYMBOL (SDLK_PLUS, "K_PLUS");
  PY_MODULE_ADD_SYMBOL (SDLK_MINUS, "K_MINUS");
  PY_MODULE_ADD_SYMBOL (SDLK_0, "K_0");
  PY_MODULE_ADD_SYMBOL (SDLK_1, "K_1");
  PY_MODULE_ADD_SYMBOL (SDLK_2, "K_2");
  PY_MODULE_ADD_SYMBOL (SDLK_3, "K_3");
  PY_MODULE_ADD_SYMBOL (SDLK_4, "K_4");
  PY_MODULE_ADD_SYMBOL (SDLK_5, "K_5");
  PY_MODULE_ADD_SYMBOL (SDLK_6, "K_6");
  PY_MODULE_ADD_SYMBOL (SDLK_7, "K_7");
  PY_MODULE_ADD_SYMBOL (SDLK_8, "K_8");
  PY_MODULE_ADD_SYMBOL (SDLK_9, "K_9");
  PY_MODULE_ADD_SYMBOL (SDLK_KP0, "K_KP0");
  PY_MODULE_ADD_SYMBOL (SDLK_KP1, "K_KP1");
  PY_MODULE_ADD_SYMBOL (SDLK_KP2, "K_KP2");
  PY_MODULE_ADD_SYMBOL (SDLK_KP3, "K_KP3");
  PY_MODULE_ADD_SYMBOL (SDLK_KP4, "K_KP4");
  PY_MODULE_ADD_SYMBOL (SDLK_KP5, "K_KP5");
  PY_MODULE_ADD_SYMBOL (SDLK_KP6, "K_KP6");
  PY_MODULE_ADD_SYMBOL (SDLK_KP7, "K_KP7");
  PY_MODULE_ADD_SYMBOL (SDLK_KP8, "K_KP8");
  PY_MODULE_ADD_SYMBOL (SDLK_KP9, "K_KP9");
  PY_MODULE_ADD_SYMBOL (SDLK_DELETE, "K_DELETE");
  PY_MODULE_ADD_SYMBOL (SDLK_BACKSPACE, "K_BACKSPACE");
  PY_MODULE_ADD_SYMBOL (SDLK_CLEAR, "K_CLEAR");
  PY_MODULE_ADD_SYMBOL (SDLK_UNDERSCORE, "K_UNDERSCORE");
  PY_MODULE_ADD_SYMBOL (SDLK_SEMICOLON, "K_SEMICOLON");
  PY_MODULE_ADD_SYMBOL (SDLK_PERIOD, "K_PERIOD");
  PY_MODULE_ADD_SYMBOL (SDLK_KP_PERIOD, "K_KP_PERIOD");
  PY_MODULE_ADD_SYMBOL (SDLK_MODE, "K_ALTGR");
  PY_MODULE_ADD_SYMBOL (SDLK_KP_ENTER, "K_KP_ENTER");
  PY_MODULE_ADD_SYMBOL (SDLK_UP, "K_UP");
  PY_MODULE_ADD_SYMBOL (SDLK_DOWN, "K_DOWN");
  PY_MODULE_ADD_SYMBOL (SDLK_LEFT, "K_LEFT");
  PY_MODULE_ADD_SYMBOL (SDLK_RIGHT, "K_RIGHT");
  PY_MODULE_ADD_SYMBOL (SDLK_HOME, "K_HOME");
  PY_MODULE_ADD_SYMBOL (SDLK_END, "K_END");
  PY_MODULE_ADD_SYMBOL (SDLK_PAGEUP, "K_PAGEUP");
  PY_MODULE_ADD_SYMBOL (SDLK_PAGEDOWN, "K_PAGEDOWN");
	PY_MODULE_ADD_SYMBOL (SDLK_RSHIFT, "K_RSHIFT");
	PY_MODULE_ADD_SYMBOL (SDLK_LSHIFT, "K_LSHIFT");
	PY_MODULE_ADD_SYMBOL (SDLK_RCTRL, "K_RCTRL");
	PY_MODULE_ADD_SYMBOL (SDLK_LCTRL, "K_LCTRL");
	PY_MODULE_ADD_SYMBOL (SDLK_RALT, "K_RALT");
	PY_MODULE_ADD_SYMBOL (SDLK_LALT, "K_LALT");
  PY_MODULE_ADD_SYMBOL (SDLK_F1, "K_F1");
  PY_MODULE_ADD_SYMBOL (SDLK_F2, "K_F2");
  PY_MODULE_ADD_SYMBOL (SDLK_F3, "K_F3");
  PY_MODULE_ADD_SYMBOL (SDLK_F4, "K_F4");
  PY_MODULE_ADD_SYMBOL (SDLK_F5, "K_F5");
  PY_MODULE_ADD_SYMBOL (SDLK_F6, "K_F6");
  PY_MODULE_ADD_SYMBOL (SDLK_F7, "K_F7");
  PY_MODULE_ADD_SYMBOL (SDLK_F8, "K_F8");
  PY_MODULE_ADD_SYMBOL (SDLK_F9, "K_F9");
  PY_MODULE_ADD_SYMBOL (SDLK_F10, "K_F10");
  PY_MODULE_ADD_SYMBOL (SDLK_F11, "K_F11");
  PY_MODULE_ADD_SYMBOL (SDLK_F12, "K_F12");
  PY_MODULE_ADD_SYMBOL (SDLK_a, "K_a");
  PY_MODULE_ADD_SYMBOL (SDLK_b, "K_b");
  PY_MODULE_ADD_SYMBOL (SDLK_c, "K_c");
  PY_MODULE_ADD_SYMBOL (SDLK_d, "K_d");
  PY_MODULE_ADD_SYMBOL (SDLK_e, "K_e");
  PY_MODULE_ADD_SYMBOL (SDLK_f, "K_f");
  PY_MODULE_ADD_SYMBOL (SDLK_g, "K_g");
  PY_MODULE_ADD_SYMBOL (SDLK_h, "K_h");
  PY_MODULE_ADD_SYMBOL (SDLK_i, "K_i");
  PY_MODULE_ADD_SYMBOL (SDLK_j, "K_j");
  PY_MODULE_ADD_SYMBOL (SDLK_k, "K_k");
  PY_MODULE_ADD_SYMBOL (SDLK_l, "K_l");
  PY_MODULE_ADD_SYMBOL (SDLK_m, "K_m");
  PY_MODULE_ADD_SYMBOL (SDLK_n, "K_n");
  PY_MODULE_ADD_SYMBOL (SDLK_o, "K_o");
  PY_MODULE_ADD_SYMBOL (SDLK_p, "K_p");
  PY_MODULE_ADD_SYMBOL (SDLK_q, "K_q");
  PY_MODULE_ADD_SYMBOL (SDLK_r, "K_r");
  PY_MODULE_ADD_SYMBOL (SDLK_s, "K_s");
  PY_MODULE_ADD_SYMBOL (SDLK_t, "K_t");
  PY_MODULE_ADD_SYMBOL (SDLK_u, "K_u");
  PY_MODULE_ADD_SYMBOL (SDLK_v, "K_v");
  PY_MODULE_ADD_SYMBOL (SDLK_w, "K_w");
  PY_MODULE_ADD_SYMBOL (SDLK_x, "K_x");
  PY_MODULE_ADD_SYMBOL (SDLK_y, "K_y");
  PY_MODULE_ADD_SYMBOL (SDLK_z, "K_z");

#endif /* USE_SDL */

}
 
