# Soya 3D tutorial
# Copyright (C) 2001-2002 Bertrand 'blam!' LAMY
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA


# --------------------------------------------------
# Lesson 120: Shape face/vertex visibility functions
# --------------------------------------------------

# Lesson 117 shows how to perform a fog of war effect with Land. This
# lesson does the same with Shape (= Mesh).


import os, os.path, sys, time, random

import soya
import soya.model
import soya.soya3d
import soya.cube


soya.init()


# Create a world
scene = soya.soya3d.World()


# Some Materials
soya.model.Image.PATH = os.path.join(os.path.dirname(os.path.abspath(sys.argv[0])), "data")
material = soya.model.Material()
material.tex_filename = "block2.tga"

# Create a huge Shape
world = soya.soya3d.World()
W = 20
H = 20
heights = []
j = 0
while (j < H):
  i = 0
  while (i < W):
    heights.append(random.random() * 2.0)
    i += 1
  j += 1
j = 0
while (j < H - 1):
  i = 0
  while (i < W - 1):
    soya.model.Face(
      world,
      [soya.model.Vertex(world, float(i),     heights[i + j * W],       float(j),     float(i),     float(j)),
       soya.model.Vertex(world, float(i),     heights[i + (j + 1) * W], float(j + 1), float(i),     float(j + 1)),
       soya.model.Vertex(world, float(i + 1), heights[i + 1 + j * W],   float(j),     float(i + 1), float(j))
      ],
      material)
    soya.model.Face(
      world,
      [soya.model.Vertex(world, float(i + 1), heights[i + 1 + j * W],       float(j),     float(i + 1), float(j)),
       soya.model.Vertex(world, float(i),     heights[i + (j + 1) * W],     float(j + 1), float(i),     float(j + 1)),
       soya.model.Vertex(world, float(i + 1), heights[i + 1 + (j + 1) * W], float(j + 1), float(i + 1), float(j + 1))
      ],
      material)
    i += 1
  j += 1

shape = world.shapify()


# add the Shape in the scene
scene.set_shape(shape)

# Add a light
light = soya.soya3d.Light(scene)
light.ambient = (1.0, 0.0, 1.0, 1.0)
light.set_xyz(0.0, 5.0, 0.0)

# Add a camera and a loop to render
camera = soya.soya3d.Camera(scene)
camera.set_xyz(10.0, 8.0, 10.0)
camera.look_at(soya.soya3d.Point(scene, 10.0, 0.0, 10.0))
soya.set_root_widget(camera)


# SHAPE VISIBILITY FUNCTIONS
# --------------------------

# The functions are similar to the ones of the Land:
#   shape.set_all_visibility(VISIBILITY)
#   shape.set_visibility_in_sphere(VISIBILITY, CENTER_X, CENTER_Y, CENTER_Z, RADIUS)
#   shape.set_visibility_in_cylinder(VISIBILITY, CENTER_X, CENTER_Z, RADIUS)

# This option allow to have 1 visibility for each vertex.
# If the option is set to 0, a face will have to possibility:
# to be fully visible or fully invisible. If the option is set
# to 1, you will have some faces rendered with a smooth alpha
# gradient.
shape.use_vertex_visibility = 1

# Hide all the faces of the Shape
shape.set_all_visibility(0)


while(1):

# Reveal the part of the Shape that is around the camera
  shape.set_visibility_in_cylinder(1, camera.x, camera.z, 2.0)
  
  soya.render()

  time.sleep(0.1)
  
# Use Up, Down, Left, Right arrows to move the camera

  for event in soya.process_event():
    if event[0] == soya.KEYDOWN:
      if event[1] == soya.K_UP:
        camera.translate(0.0, 0.0, -0.5)
      elif event[1] == soya.K_DOWN:
        camera.translate(0.0, 0.0, 0.5)
      elif event[1] == soya.K_LEFT:
        camera.translate(-0.5, 0.0, 0.0)
      elif event[1] == soya.K_RIGHT:
        camera.translate(0.5, 0.0, 0.0)
      elif event[1] == soya.K_KP_PLUS:
        camera.translate(0.0, -0.5, 0.0)
      elif event[1] == soya.K_KP_MINUS:
        camera.translate(0.0, 0.5, 0.0)
      elif event[1] == soya.K_q:
        sys.exit()
