/*
 * P3 python wrapper
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

/*****************************************
 * Copyright (C) 2003 Bertrand 'blam' LAMY
 *****************************************/

/*===========+
 | WATERCUBE |
 +===========*/

/*---------+
 | Methods |
 +---------*/

static int PyP3Watercube_Init (P3_watercube* a, PyObject* args, PyObject* kwds) {
  P3_watercube_new ((P3_watercube*) a);
  return 0;
}

static void PyP3Watercube_Dealloc (P3_watercube* a) {
  PyObject_GC_UnTrack ((PyObject*) a);
  Py_XDECREF (a->material);
  Py_XDECREF (a->parent);
  P3_watercube_dealloc (a);
  a->ob_type->tp_free ((PyObject*) a); 
}

static int PyP3Watercube_Traverse (P3_watercube* a, visitproc visit, void* arg) {
  int err;
  if (a->material != NULL) {
    err = visit ((PyObject*) a->material, arg);
    if (err) { return err; }
  }
  if (a->parent != NULL) {
    err = visit ((PyObject*) a->parent, arg);
    if (err) { return err; }
  }
  return 0;
}

static int PyP3Watercube_Clear (P3_watercube* a) {
  Py_XDECREF (a->material);
  a->material = NULL;
  Py_XDECREF (a->parent);
  a->parent = NULL;
  return 0;
}

static PyObject* PyP3Watercube_GetState (P3_watercube* a) {
  P3_chunk* chunk = P3_chunk_new ();
  PyObject* tuple;
  P3_watercube_get_data (a, chunk);
  tuple = PyTuple_New (2);
  PyTuple_SET_ITEM (tuple, 0, PyString_FromStringAndSize ((char*) chunk->content, chunk->nb));
  if (a->material == NULL) {
    Py_INCREF (Py_None);
    PyTuple_SET_ITEM (tuple, 1, Py_None);
  } else {
    Py_INCREF ((PyObject*) a->material);
    PyTuple_SET_ITEM (tuple, 1, (PyObject*) a->material);
  }
  P3_chunk_dealloc (chunk);
  return tuple;
}

static PyObject* PyP3Watercube_SetState (P3_watercube* a, PyObject* args) {
  P3_chunk* chunk = P3_chunk_new ();
  PyObject* o;
  o = PySequence_Fast_GET_ITEM (args, 0);
  chunk->content = PyString_AS_STRING (o);
  P3_watercube_set_data (a, chunk);
  a->material = (P3_material*) PySequence_Fast_GET_ITEM (args, 1);
  if ((PyObject*) a->material == Py_None) {
    a->material = NULL;
  } else {
    Py_INCREF ((PyObject*) a->material);
  }
  free (chunk);
  Py_INCREF (Py_None);
  return Py_None;
}

/*
static PyObject* PyP3Watercube_AdvanceTime (P3_watercube* a, PyObject* arg) {
  P3_watercube_advance_time (a, (float) PyFloat_AS_DOUBLE (arg));
  Py_INCREF (Py_None);
  return Py_None;
}
*/

static PyObject* PyP3Watercube_AddWave (P3_watercube* a, PyObject* args) {
  P3_watercube_new_wave (a, 
                         (GLfloat) PyFloat_AS_DOUBLE (PySequence_Fast_GET_ITEM (args, 0)),
                         (GLfloat) PyFloat_AS_DOUBLE (PySequence_Fast_GET_ITEM (args, 1)),
                         (GLfloat) PyFloat_AS_DOUBLE (PySequence_Fast_GET_ITEM (args, 2)),
                         (GLfloat) PyFloat_AS_DOUBLE (PySequence_Fast_GET_ITEM (args, 3)),
                         (GLfloat) PyFloat_AS_DOUBLE (PySequence_Fast_GET_ITEM (args, 4)),
                         (GLfloat) PyFloat_AS_DOUBLE (PySequence_Fast_GET_ITEM (args, 5)),
                         (GLfloat) PyFloat_AS_DOUBLE (PySequence_Fast_GET_ITEM (args, 6)),
                         (GLfloat) PyFloat_AS_DOUBLE (PySequence_Fast_GET_ITEM (args, 7)));
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject* PyP3Watercube_IsUnderwater (P3_watercube* a, PyObject* arg) {
//  PyObject* o;
  GLfloat point[3];
  if (!(a->option & P3_WATERCUBE_INITED)) P3_watercube_init (a);
  PyP3_GetPositionInto (arg, (P3_coordsys*) a, point);
//  GET_PY_POINT_COORD (point, arg, o, a);
  return PyInt_FromLong ((long) P3_watercube_is_underwater (a, point));
}

static PyObject* PyP3Watercube_GetWaterlevel (P3_watercube* a, PyObject* args) {
  PyObject* o;
  P3_vector* v;
  GLfloat n[3];
  GLfloat y;
  GLfloat x = (GLfloat) PyFloat_AS_DOUBLE (PySequence_Fast_GET_ITEM (args, 0));
  GLfloat z = (GLfloat) PyFloat_AS_DOUBLE (PySequence_Fast_GET_ITEM (args, 1));
  if (!(a->option & P3_WATERCUBE_INITED)) { P3_watercube_init (a); }
  if (x < 0.0f || z < 0.0f || x > a->size[0] || z > a->size[2]) {
    Py_INCREF (Py_None);
    return Py_None;
  }
  y = P3_watercube_get_waterlevel (a, x, z, n);
  /* returned normal is not normalized */
  P3_vector_normalize (n);
  if (PySequence_Size (args) == 3) {
    o = PySequence_Fast_GET_ITEM (args, 2);
    if (o != Py_None) {
      v = (P3_vector*) o;
      Py_INCREF ((PyObject*) a);
      v->parent = (P3_coordsys*) a;
      memcpy (v->coord, n, 3 * sizeof (GLfloat));
/*
      PyObject_SetAttrString (o, "parent", (PyObject*) a);
      q = PyFloat_FromDouble ((double) n[0]);
      PyObject_SetAttrString (o, "x", q);
      Py_DECREF (q);
      q = PyFloat_FromDouble ((double) n[1]);
      PyObject_SetAttrString (o, "y", q);
      Py_DECREF (q);
      q = PyFloat_FromDouble ((double) n[2]);
      PyObject_SetAttrString (o, "z", q);
      Py_DECREF (q);
*/
    }
    return PyFloat_FromDouble ((double) y);
  } else {
    /* 2 args */
    o = PyTuple_New (2);
    PyTuple_SET_ITEM (o, 0, PyFloat_FromDouble ((double) y));
    v = (P3_vector*) PyP3Vector_Type.tp_alloc (&PyP3Vector_Type, 0);
    Py_INCREF ((PyObject*) a);
    v->parent = (P3_coordsys*) a;
    memcpy (v->coord, n, 3 * sizeof (GLfloat));
    PyTuple_SET_ITEM (o, 1, (PyObject*) v);
//    PyTuple_SET_ITEM (o, 1, PyObject_CallMethod (P3Module, "new_vector", "Offf", a, (double) n[0], (double) n[1], (double) n[2]));
    return o;
  }
}

static PyObject* PyP3Watercube_ToSurface (P3_watercube* a, PyObject* args) {
  PyObject* p;
  P3_coordsys* pc;
  P3_coordsys* c;
  GLfloat* m;
  GLfloat point[3];
  GLfloat n[3];
  GLfloat y;
  int id;
  if (!(a->option & P3_WATERCUBE_INITED)) P3_watercube_init (a);
  p = PySequence_Fast_GET_ITEM (args, 0);
  if (PyObject_IsInstance ((PyObject*) p, (PyObject*) &PyP3Point_Type) == 1) {
    id = 0;
    pc = ((P3_point*) p)->parent;
    if (pc == NULL) {
      memcpy (point, ((P3_point*) p)->coord, 3 * sizeof (GLfloat));
    } else {
      P3_point_by_matrix_copy (point, ((P3_point*) p)->coord, P3_coordsys_get_root_matrix (((P3_point*) p)->parent));
      P3_point_by_matrix (point, P3_coordsys_get_inverted_root_matrix ((P3_coordsys*) a));
    }
  } else {
    /* assume it's a P3_any_object */
    id = ((P3_any_object*) p)->class->id;
    if (id == P3_ID_SPRITE || id == P3_ID_CYLINDER) {
      id = 1;
      pc = ((P3_sprite*) p)->parent;
      if (pc == NULL) {
        memcpy (point, ((P3_sprite*) p)->position, 3 * sizeof (GLfloat));
      } else {
        P3_point_by_matrix_copy (point, ((P3_sprite*) p)->position, P3_coordsys_get_root_matrix (((P3_sprite*) p)->parent));
        P3_point_by_matrix (point, P3_coordsys_get_inverted_root_matrix ((P3_coordsys*) a));
      }
    } else {
      id = 2;
      /* assume it's a coordsys */
      pc = ((P3_coordsys*) a)->parent;
      if (pc == NULL) {
        memcpy (point, ((P3_coordsys*) a)->m + 12, 3 * sizeof (GLfloat));
      } else {
        P3_point_by_matrix_copy (point, ((P3_coordsys*) a)->m + 12, P3_coordsys_get_root_matrix (((P3_coordsys*) a)->parent));
        P3_point_by_matrix (point, P3_coordsys_get_inverted_root_matrix ((P3_coordsys*) a));
      }
    }
  }
//  PyP3_GetPositionInto (p, (P3_coordsys*) a, point);
//  GET_PY_COORD (point, p, o);
  if (PySequence_Size (args) > 1) {
    c = (P3_coordsys*) PySequence_Fast_GET_ITEM (args, 1);
  } else {
    c = NULL;
  }
//  o = PyObject_GetAttrString (p, "parent");
//  if (o != Py_None && o != (PyObject*) a) {
//    P3_point_by_matrix (point, P3_coordsys_get_root_matrix ((P3_coordsys*) o));
//    P3_point_by_matrix (point, P3_coordsys_get_inverted_root_matrix ((P3_coordsys*) a));
//  }
  if (point[0] >= 0.0 && point[2] >= 0.0 && point[0] <= a->size[0] && point[2] <= a->size[2]) {
    if (c == NULL) {
      point[1] = P3_watercube_get_waterlevel (a, point[0], point[2], NULL);
    } else {
      point[1] = P3_watercube_get_waterlevel (a, point[0], point[2], n);
    }
    if (pc != NULL && pc != (P3_coordsys*) a) {
//    if (o != Py_None && o != (PyObject*) a) {
      P3_point_by_matrix (point, P3_coordsys_get_root_matrix ((P3_coordsys*) a));
      m = P3_coordsys_get_inverted_root_matrix (pc);
      y = point[0] * m[1] + point[1] * m[5] + point[2] * m[9] + m[13];
    } else {
      y = point[1];
    }
    if (id == 0) {
      ((P3_point*) p)->coord[1] = y;
    } else if (id == 1) {
      ((P3_sprite*) p)->position[1] = y;
    } else if (id == 2) {
      ((P3_coordsys*) p)->m[13] = y;
    }
//    PyObject_SetAttrString (p, "y", PyFloat_FromDouble ((double) y));
    if (c != NULL) {
      P3_vector_by_matrix (n, P3_coordsys_get_root_matrix ((P3_coordsys*) a));
      if (c->parent != NULL) {
        P3_vector_by_matrix (n, P3_coordsys_get_inverted_root_matrix ((P3_coordsys*) c->parent));
      }
      P3_matrix_look_to_Y (c->m, n);
      P3_coordsys_invalid (c);
    }
  }
//  Py_DECREF (o);
  Py_INCREF (Py_None);
  return Py_None;
}

static PyMethodDef PyP3Watercube_Methods[] = {
//  PYP3_COORDSYS_FUNCS,
  { "to_surface",       (PyCFunction) PyP3Watercube_ToSurface,      METH_VARARGS },
  { "get_waterlevel",   (PyCFunction) PyP3Watercube_GetWaterlevel,  METH_VARARGS },
  { "is_underwater",    (PyCFunction) PyP3Watercube_IsUnderwater,   METH_O },
//  { "advance_time",     (PyCFunction) PyP3Watercube_AdvanceTime,    METH_O },
  { "_add_wave",        (PyCFunction) PyP3Watercube_AddWave,        METH_VARARGS },
  { "_getstate",        (PyCFunction) PyP3Watercube_GetState,       METH_NOARGS },
  { "_setstate",        (PyCFunction) PyP3Watercube_SetState,       METH_O },
  { NULL, NULL } /* sentinel */
};

/*---------+
 | Get Set |
 +---------*/

PY_GET_SET_ON_INT         (Watercube, P3_watercube*, CameraMaxLOD, max_camera_level)
PY_GET_SET_ON_INT_ADD     (Watercube, P3_watercube*, PhaseNumber, nb_phases, P3_watercube_set_nb_phases (a, a->nb_phases);)
PY_GET_SET_ON_INT_ADD     (Watercube, P3_watercube*, PatchSize, patch_size, P3_watercube_dealloc (a); if (a->option & P3_WATERCUBE_INITED) { a->option -= P3_WATERCUBE_INITED; } )
PY_GET_SET_ON_INT_ADD     (Watercube, P3_watercube*, PointWidth, nb_points_width, P3_watercube_dealloc (a); if (a->option & P3_WATERCUBE_INITED) { a->option -= P3_WATERCUBE_INITED; } )
PY_GET_SET_ON_INT_ADD     (Watercube, P3_watercube*, PointDepth, nb_points_depth, P3_watercube_dealloc (a); if (a->option & P3_WATERCUBE_INITED) { a->option -= P3_WATERCUBE_INITED; } )
PY_GET_SET_ON_FLOAT       (Watercube, P3_watercube*, LODLinear, lod_linear)
PY_GET_SET_ON_FLOAT       (Watercube, P3_watercube*, WaveLODLinear, wave_lod_linear)
PY_GET_SET_ON_FLOAT_ADD   (Watercube, P3_watercube*, TextureFactor, texture_factor, P3_watercube_dealloc (a); if (a->option & P3_WATERCUBE_INITED) { a->option -= P3_WATERCUBE_INITED; } )
PY_GET_SET_ON_FLOAT_ADD   (Watercube, P3_watercube*, Width,  size[0], P3_watercube_dealloc (a); if (a->option & P3_WATERCUBE_INITED) { a->option -= P3_WATERCUBE_INITED; } )
PY_GET_SET_ON_FLOAT_ADD   (Watercube, P3_watercube*, Height, size[1], P3_watercube_dealloc (a); if (a->option & P3_WATERCUBE_INITED) { a->option -= P3_WATERCUBE_INITED; } )
PY_GET_SET_ON_FLOAT_ADD   (Watercube, P3_watercube*, Depth,  size[2], P3_watercube_dealloc (a); if (a->option & P3_WATERCUBE_INITED) { a->option -= P3_WATERCUBE_INITED; } )
PY_GET_SET_ON_FLOAT       (Watercube, P3_watercube*, WaveHeight, wave_height)
PY_GET_SET_ON_FLOAT       (Watercube, P3_watercube*, Speed, speed)
PY_GET_SET_ON_FLOAT_ARRAY (Watercube, P3_watercube*, Color, color, 4)
PY_GET_SET_ON_OBJECT      (Watercube, P3_watercube*, Material, material, P3_material*)

static PyGetSetDef PyP3Watercube_GetSets[] = {
//  PYP3_COORDSYS_GETSETS,
//  PYP3_CHILD_GETSETS,
//  PYP3_VISIBLE_GETSETS,
  { "texture_factor",  (getter) PyP3Watercube_GetTextureFactor, (setter) PyP3Watercube_SetTextureFactor, NULL },
  { "camera_max_LOD",  (getter) PyP3Watercube_GetCameraMaxLOD,  (setter) PyP3Watercube_SetCameraMaxLOD,  NULL },
  { "nb_phases",       (getter) PyP3Watercube_GetPhaseNumber,   (setter) PyP3Watercube_SetPhaseNumber,   NULL },
  { "LOD_linear",      (getter) PyP3Watercube_GetLODLinear,     (setter) PyP3Watercube_SetLODLinear,     NULL },
  { "wave_LOD_linear", (getter) PyP3Watercube_GetWaveLODLinear, (setter) PyP3Watercube_SetWaveLODLinear, NULL },
  { "patch_size",      (getter) PyP3Watercube_GetPatchSize,     (setter) PyP3Watercube_SetPatchSize,     NULL },
  { "point_width",     (getter) PyP3Watercube_GetPointWidth,    (setter) PyP3Watercube_SetPointWidth,    NULL },
  { "point_depth",     (getter) PyP3Watercube_GetPointDepth,    (setter) PyP3Watercube_SetPointDepth,    NULL },
  { "width",           (getter) PyP3Watercube_GetWidth,         (setter) PyP3Watercube_SetWidth,         NULL },
  { "height",          (getter) PyP3Watercube_GetHeight,        (setter) PyP3Watercube_SetHeight,        NULL },
  { "depth",           (getter) PyP3Watercube_GetDepth,         (setter) PyP3Watercube_SetDepth,         NULL },
  { "speed",           (getter) PyP3Watercube_GetSpeed,         (setter) PyP3Watercube_SetSpeed,         NULL },
  { "wave_height",     (getter) PyP3Watercube_GetWaveHeight,    (setter) PyP3Watercube_SetWaveHeight,    NULL },
  { "color",           (getter) PyP3Watercube_GetColor,         (setter) PyP3Watercube_SetColor,         NULL },
  { "material",        (getter) PyP3Watercube_GetMaterial,      (setter) PyP3Watercube_SetMaterial,      NULL },
  { NULL }
};

/*------+
 | Type |
 +------*/

PyTypeObject PyP3Watercube_Type = {
  PyObject_HEAD_INIT(NULL)
  0,
  "_soya._WaterCube",
  sizeof(P3_watercube),
  0,
  (destructor) PyP3Watercube_Dealloc,/* tp_dealloc */
  0,/* tp_print */
  0,/* tp_getattr */
  0,/* tp_setattr */
  0,/* tp_compare */
  0,/* tp_repr */
  0,/* tp_as_number */
  0,/* tp_as_sequence */
  0,/* tp_as_mapping */
  0,/* tp_hash */
  0,/* tp_call */
  0,/* tp_str */
  PYP3_GENERIC_GETATTR,/* tp_getattro */
  0,/* tp_setattro */
  0,/* tp_as_buffer */
  Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE | Py_TPFLAGS_HAVE_GC,/* tp_flags */
  0,/* tp_doc */
  (traverseproc) PyP3Watercube_Traverse,/* tp_traverse */
  (inquiry) PyP3Watercube_Clear,/* tp_clear */
  0,/* tp_richcompare */
  0,/* tp_weaklistoffset */
  0,/* tp_iter */
  0,/* tp_iternext */
  (PyMethodDef*) &PyP3Watercube_Methods,/* tp_methods */
  0,/* tp_members */
  (PyGetSetDef*) &PyP3Watercube_GetSets,/* tp_getset */
  &PyP3Element_Type,/* tp_base */
  0,/* tp_dict */
  0,/* tp_descr_get */
  0,/* tp_descr_set */
  0,/* tp_dictoffset */
  (initproc) PyP3Watercube_Init,/* tp_init */
  PYP3_GENERIC_ALLOC,/* tp_alloc */
  (newfunc) PyP3Object_New,/* tp_new */
  PYP3_GENERIC_GC_FREE,/* tp_free */
};

