/*
 * P3 python wrapper
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

/*****************************************
 * Copyright (C) 2003 Bertrand 'blam' LAMY
 *****************************************/

/*========+
 | VOLUME |
 +========*/

/*---------+
 | Methods |
 +---------*/

static int PyP3Volume_Init (P3_volume* a, PyObject* args, PyObject* kwds) {
  P3_volume_new (a);
  return 0;
}

static void PyP3Volume_Dealloc (P3_volume* a) {
  PyObject_GC_UnTrack ((PyObject*) a);
  Py_XDECREF (a->shape);
  Py_XDECREF (a->parent);
  a->ob_type->tp_free ((PyObject*) a); 
}

static int PyP3Volume_Traverse (P3_volume* a, visitproc visit, void* arg) {
  int err;
  if (a->shape != NULL) {
    err = visit ((PyObject*) a->shape, arg);
    if (err) { return err; }
  }
  if (a->parent != NULL) {
    err = visit ((PyObject*) a->parent, arg);
    if (err) { return err; }
  }
  return 0;
}

static int PyP3Volume_Clear (P3_volume* a) {
  Py_XDECREF (a->shape);
  a->shape = NULL;
  Py_XDECREF (a->parent);
  a->parent = NULL;
  return 0;
}

static PyObject* PyP3Volume_GetState (P3_volume* a) {
  P3_chunk* chunk = P3_chunk_new ();
  PyObject* tuple;
  P3_volume_get_data (a, chunk);
  tuple = PyTuple_New (3);
  PyTuple_SET_ITEM (tuple, 0, PyString_FromStringAndSize ((char*) chunk->content, chunk->nb));
// HACK because previous object saved their parent
  Py_INCREF (Py_None);
  PyTuple_SET_ITEM (tuple, 1, Py_None);
  if (a->shape == NULL) {
    Py_INCREF (Py_None);
    PyTuple_SET_ITEM (tuple, 2, Py_None);
  } else {
    Py_INCREF ((PyObject*) a->shape);
    PyTuple_SET_ITEM (tuple, 2, (PyObject*) a->shape);
  }
  P3_chunk_dealloc (chunk);
  return tuple;
}

static PyObject* PyP3Volume_SetState (P3_volume* a, PyObject* args) {
  P3_chunk* chunk = P3_chunk_new ();
  PyObject* o;
  o = PySequence_Fast_GET_ITEM (args, 0);
  chunk->content = PyString_AS_STRING (o);
  P3_volume_set_data (a, chunk);
  a->shape = (P3_any_object*) PySequence_Fast_GET_ITEM (args, 2);
  if ((PyObject*) a->shape == Py_None) {
    a->shape = NULL;
  } else {
    Py_INCREF ((PyObject*) a->shape);
  }
  free (chunk);
  Py_INCREF (Py_None);
  return Py_None;
}

static PyMethodDef PyP3Volume_Methods[] = {

//  PYP3_COORDSYS_FUNCS,

  { "_getstate", (PyCFunction) PyP3Volume_GetState,    METH_NOARGS },
  { "_setstate", (PyCFunction) PyP3Volume_SetState,    METH_O },
  { NULL, NULL } /* sentinel */
};

/*---------+
 | Get Set |
 +---------*/

static PyObject* PyP3Volume_GetShape (P3_volume* a, void* context) {
  if (a->shape == NULL) {
    Py_INCREF (Py_None);
    return Py_None;
  } else {
    Py_INCREF ((PyObject*) a->shape);
    return (PyObject*) a->shape;
  }
}

static int PyP3Volume_SetShape (P3_volume* a, PyObject* arg, void* context) {
  if ((PyObject*) arg == Py_None) { 
    arg = NULL; 
  } else { 
    Py_INCREF (arg);
  }
  Py_XDECREF ((PyObject*) a->shape);
  P3_volume_set_shape (a, (P3_any_object*) arg);
  return 0;
}

static PyGetSetDef PyP3Volume_GetSets[] = {

//  PYP3_COORDSYS_GETSETS,
//  PYP3_CHILD_GETSETS,
//  PYP3_VISIBLE_GETSETS,
//  PYP3_SOLID_GETSETS,

  { "shape", (getter) PyP3Volume_GetShape, (setter) PyP3Volume_SetShape, NULL },
  { NULL }
};

/*------+
 | Type |
 +------*/

PyTypeObject PyP3Volume_Type = {
  PyObject_HEAD_INIT(NULL)
  0,
  "_soya._Volume",
  sizeof(P3_volume),
  0,
  (destructor) PyP3Volume_Dealloc,/* tp_dealloc */
  0,/* tp_print */
  0,/* tp_getattr */
  0,/* tp_setattr */
  0,/* tp_compare */
  0,/* tp_repr */
  0,/* tp_as_number */
  0,/* tp_as_sequence */
  0,/* tp_as_mapping */
  0,/* tp_hash */
  0,/* tp_call */
  0,/* tp_str */
  PYP3_GENERIC_GETATTR,/* tp_getattro */
  0,/* tp_setattro */
  0,/* tp_as_buffer */
  Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE | Py_TPFLAGS_HAVE_GC,/* tp_flags */
  0,/* tp_doc */
  (traverseproc) PyP3Volume_Traverse,/* tp_traverse */
  (inquiry) PyP3Volume_Clear,/* tp_clear */
  0,/* tp_richcompare */
  0,/* tp_weaklistoffset */
  0,/* tp_iter */
  0,/* tp_iternext */
  (PyMethodDef*) &PyP3Volume_Methods,/* tp_methods */
  0,/* tp_members */
  (PyGetSetDef*) &PyP3Volume_GetSets,/* tp_getset */
  &PyP3Element_Type,/* tp_base */
  0,/* tp_dict */
  0,/* tp_descr_get */
  0,/* tp_descr_set */
  0,/* tp_dictoffset */
  (initproc) PyP3Volume_Init,/* tp_init */
  PYP3_GENERIC_ALLOC,/* tp_alloc */
  (newfunc) PyP3Object_New,/* tp_new */
  PYP3_GENERIC_GC_FREE,/* tp_free */
};

